/* vrtx_20.s - VRTX 32/68020 v1.05 */

/*
modification history
--------------------
*/

/*
This is VRTX 32/68020 version 1.05, in pseudo-disassembled form 
*/

	.globl _vrtxent
	.globl _vrtxCfTblVec

	.text


_vrtxent:	
	.long	0x603EFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF
	.long	0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF
	.word	0x0003


/* The next long is the pointer to the Configuration table pointer.
 * VRTX32 1.05 default is 0x100 (the first user exception vector);
 * We're going to use the reserved vector just before the user
 * vectors (don't tell motorola)
 */


_vrtxCfTblVec:
	.long	0x000000FC
/*	.byte	0x00,0x00,0x01,0x00*/

/* The next word is the version number (1.05) */

	.word	0x0105

	.byte	0xFF,0xFF
	.byte	0xFF,0xFF,0x95,0x06,0x82,0x05
	.byte	0x10,0x00,0xFF,0xFF,0xFF,0xFF,0x40,0x40,0x40,0x40
	.byte	0xFF,0x00,0x00,0x40,0x00,0x80
	.byte	0x0C,0x40,0x00,0x11,0x66,0x5C,0x50,0x8F,0x20,0x1F
	.byte	0x08,0x17,0x00,0x04,0x67,0x48
	.byte	0x50,0x8F,0x00,0x7C,0x10,0x00,0x2F,0x0E,0x4E,0x7A
	.byte	0xE8,0x01,0xDD,0xFA,0xFF,0xC4
	.byte	0x2C,0x56,0x2C,0x56,0x40,0xE7,0x46,0xEE,0x00,0x9C
	.byte	0x0C,0x6E,0xFF,0xFF,0x00,0x18
	.byte	0x66,0x22,0x4A,0x6E,0x00,0xA6,0x66,0x06,0x4A,0x2E
	.byte	0x00,0x1E,0x67,0x16,0x46,0xDF
	.byte	0x48,0xE7,0x03,0x0C,0x52,0x6E,0x00,0x18,0x40,0xC6
	.byte	0x48,0x46,0x3C,0x2E,0x00,0x9C
	.byte	0x60,0x00,0x01,0x0E,0x46,0xDF,0x2C,0x5F,0x4E,0x73
	.byte	0x8C,0x6E,0x00,0x9E,0x60,0x00
	.byte	0x01,0x00,0x48,0xE7,0x03,0x0E,0x4E,0x7A,0xD8,0x01
	.byte	0xDB,0xFA,0xFF,0x76,0x2A,0x55
	.byte	0x2C,0x55,0x52,0x6E,0x00,0x18,0x2E,0x00,0x0C,0x47
	.byte	0x00,0x31,0x62,0x00,0x02,0x4A
	.byte	0x70,0x00,0x40,0xC6,0x48,0x46,0x40,0xC6,0x02,0x46
	.byte	0x30,0x00,0x4E,0xFB,0x75,0x20
	.byte	0x00,0x04,0x60,0x00,0x02,0xE8,0x60,0x00,0x04,0x50
	.byte	0x60,0x00,0x05,0x54,0x60,0x00
	.byte	0x05,0x9C,0x60,0x00,0x06,0x54,0x60,0x00,0x06,0xD2
	.byte	0x60,0x00,0x07,0x4C,0x60,0x00
	.byte	0x07,0xBA,0x60,0x00,0x0C,0x8C,0x60,0x00,0x0D,0x08
	.byte	0x60,0x00,0x19,0x3E,0x60,0x00
	.byte	0x19,0x46,0x60,0x00,0x18,0x3E,0x60,0x00,0x0E,0x6A
	.byte	0x60,0x00,0x0E,0xDA,0x60,0x00
	.byte	0x0F,0x72,0x60,0x00,0x00,0x86,0x60,0x00,0xFF,0x28
	.byte	0x60,0x00,0x19,0x42,0x60,0x00
	.byte	0x0F,0xB0,0x60,0x00,0x10,0x52,0x60,0x00,0x19,0x2A
	.byte	0x60,0x00,0xFF,0x6E,0x60,0x00
	.byte	0x12,0x88,0x60,0x00,0x12,0xC0,0x60,0x00,0x13,0x64
	.byte	0x60,0x00,0x14,0x86,0x60,0x00
	.byte	0x15,0x4A,0x60,0x00,0x15,0x7A,0x60,0x00,0x00,0x52
	.byte	0x60,0x00,0x0B,0xD2,0x60,0x00
	.byte	0x0B,0x16,0x60,0x00,0x06,0xBE,0x60,0x00,0x06,0xC6
	.byte	0x60,0x00,0x07,0xCE,0x60,0x00
	.byte	0x08,0xA6,0x60,0x00,0x00,0x36,0x60,0x00,0x0D,0xAC
	.byte	0x60,0x00,0x09,0x3A,0x60,0x00
	.byte	0x09,0xDA,0x60,0x00,0x0A,0x8A,0x60,0x00,0x0A,0xE6
	.byte	0x60,0x00,0x0B,0x62,0x60,0x00
	.byte	0x15,0x6A,0x60,0x00,0x15,0xA6,0x60,0x00,0x16,0x44
	.byte	0x60,0x00,0x16,0xF6,0x60,0x00
	.byte	0x17,0x7E,0x60,0x00,0x19,0x42,0x60,0x00,0x1C,0x2E
	.byte	0x8C,0x6E,0x00,0x9E,0x70,0x09
	.byte	0x46,0xC6,0x4A,0x6E,0x00,0x18,0x66,0x00,0x00,0x1E
	.byte	0x08,0x2F,0x00,0x04,0x00,0x14
	.byte	0x67,0x14,0x4A,0x6E,0x00,0xA6,0x66,0x18,0x4A,0x6E
	.byte	0x00,0x1A,0x66,0x08,0x4A,0x2E
	.byte	0x00,0x1E,0x66,0x00,0x00,0xC2,0x53,0x6E,0x00,0x18
	.byte	0x4C,0xDF,0x70,0xC0,0x4E,0x73
	.byte	0x7E,0x00,0x3E,0x2E,0x00,0xA6,0x42,0x6E,0x00,0xA6
	.byte	0x48,0x46,0x46,0xC6,0x48,0x46
	.byte	0x3D,0x7C,0xFF,0xFF,0x00,0xAA,0x28,0x6E,0x00,0xAC
	.byte	0xBE,0xAC,0x00,0x04,0x65,0x00
	.byte	0x00,0x8C,0x2F,0x01,0x46,0xC6,0x32,0x2C,0x00,0x22
	.byte	0x02,0x41,0x06,0x42,0x67,0x2A
	.byte	0x61,0x00,0x10,0x6A,0x32,0x2C,0x00,0x22,0x02,0x01
	.byte	0x00,0x40,0x67,0x08,0x2A,0x6C
	.byte	0x00,0x68,0x53,0x6D,0x00,0x06,0x02,0x6C,0xF9,0xBD
	.byte	0x00,0x22,0x48,0x46,0x46,0xC6
	.byte	0x48,0x46,0x29,0x7C,0x00,0x00,0x00,0x0A,0x00,0x24
	.byte	0x22,0x1F,0x2A,0x6C,0x00,0x0C
	.byte	0x2B,0x6C,0x00,0x08,0x00,0x08,0x2A,0x6C,0x00,0x08
	.byte	0x2B,0x6C,0x00,0x0C,0x00,0x0C
	.byte	0x29,0x4C,0x00,0x08,0x29,0x4C,0x00,0x0C,0x48,0xE7
	.byte	0x60,0x00,0x74,0x00,0x34,0x2C
	.byte	0x00,0x12,0x22,0x02,0xE8,0x49,0x46,0xC6,0x08,0xAC
	.byte	0x00,0x05,0x00,0x23,0x67,0x0A
	.byte	0x4A,0x6C,0x00,0x22,0x66,0x04,0x61,0x00,0x10,0x20
	.byte	0x48,0x46,0x46,0xC6,0x48,0x46
	.byte	0x4C,0xDF,0x00,0x06,0x9E,0xAC,0x00,0x04,0x60,0x00
	.byte	0xFF,0x6C,0x9F,0xAC,0x00,0x04
	.byte	0x46,0xC6,0x60,0x00,0xFF,0x34,0x42,0x2E,0x00,0x1E
	.byte	0x28,0x6E,0x00,0x10,0xB9,0xEE
	.byte	0x00,0x14,0x67,0x00,0x00,0x60,0x08,0xAC,0x00,0x07
	.byte	0x00,0x58,0x66,0x06,0x48,0xEC
	.byte	0x0F,0x3F,0x00,0x24,0x29,0x4F,0x00,0x4C,0x4E,0x68
	.byte	0x29,0x48,0x00,0x50,0x2A,0x6E
	.byte	0x00,0x14,0x2D,0x4D,0x00,0x10,0x48,0x46,0x46,0xC6
	.byte	0x48,0x46,0x2E,0x2E,0x00,0x90
	.byte	0x67,0x14,0x22,0x4C,0x24,0x4D,0xD3,0xFC,0x00,0x00
	.byte	0x00,0x14,0xD5,0xFC,0x00,0x00
	.byte	0x00,0x14,0x20,0x47,0x4E,0x90,0x46,0xC6,0x2E,0x6D
	.byte	0x00,0x4C,0x20,0x6D,0x00,0x50
	.byte	0x4E,0x60,0x4C,0xED,0x0F,0x3F,0x00,0x24,0x28,0x4D
	.byte	0x4A,0x2E,0x00,0x1E,0x67,0x00
	.byte	0xFE,0xD6,0x60,0x92,0x08,0xAC,0x00,0x07,0x00,0x58
	.byte	0x67,0x00,0xFE,0xCA,0x4C,0xEC
	.byte	0x0F,0x3F,0x00,0x24,0x60,0x00,0xFE,0xC0,0x0C,0x47
	.byte	0x00,0xFF,0x63,0x00,0xFE,0x8C
	.byte	0x28,0x6D,0x00,0x30,0x7E,0x00,0xBE,0x8C,0x67,0x4E
	.byte	0x1E,0x00,0x3C,0x00,0xE0,0x46
	.byte	0x6B,0x3A,0xBC,0x14,0x6E,0x46,0x2A,0x74,0x67,0x20
	.byte	0x00,0x04,0x28,0x74,0x67,0x10
	.byte	0x7C,0x00,0xBC,0x8C,0x67,0x36,0xBE,0x2C,0x00,0x40
	.byte	0x62,0x34,0x3C,0x34,0x74,0x50
	.byte	0x67,0x2E,0x3E,0x34,0x74,0x52,0x2F,0x07,0x48,0x7A
	.byte	0x00,0x46,0x48,0x74,0x60,0x00
	.byte	0x08,0x07,0x00,0x00,0x66,0x04,0x53,0x6E,0x00,0x18
	.byte	0x4E,0x75,0x44,0x46,0xBC,0x2C
	.byte	0x00,0x01,0x6E,0x08,0x44,0x46,0x60,0xBE,0x70,0x20
	.byte	0x60,0x06,0x70,0x21,0x60,0x02
	.byte	0x70,0x22,0x4E,0x7A,0xD8,0x01,0xDB,0xFA,0xFC,0xAA
	.byte	0x2A,0x55,0x2C,0x55,0x40,0xC6
	.byte	0x48,0x46,0x40,0xC6,0x02,0x46,0x30,0x00,0x8C,0x6E
	.byte	0x00,0x9E,0x60,0x00,0xFE,0x12
	.byte	0x4E,0x7A,0xD8,0x01,0xDB,0xFA,0xFC,0x8C,0x2A,0x55
	.byte	0x2C,0x55,0x40,0xC6,0x48,0x46
	.byte	0x40,0xC6,0x02,0x46,0x30,0x00,0x8C,0x6E,0x00,0x9E
	.byte	0x2E,0x1F,0x08,0x07,0x00,0x00
	.byte	0x66,0x00,0xFD,0xEE,0x52,0x6E,0x00,0x18,0x60,0x00
	.byte	0xFD,0xE6,0x8C,0x6E,0x00,0x9E
	.byte	0x4A,0x02,0x67,0x20,0x1E,0x02,0xCE,0x6E,0x00,0x28
	.byte	0xE5,0x4F,0x2A,0x6E,0x00,0x2C
	.byte	0xDA,0xC7,0x2A,0x55,0xB0,0x8D,0x67,0x0C,0xB4,0x2D
	.byte	0x00,0x21,0x66,0xF4,0x70,0x01
	.byte	0x60,0x00,0xFD,0xBE,0x70,0x00,0xB2,0x3A,0xFC,0x52
	.byte	0x63,0x06,0x70,0x12,0x60,0x00
	.byte	0xFD,0xB0,0x28,0x6E,0x00,0x08,0xB0,0x8C,0x66,0x06
	.byte	0x70,0x02,0x60,0x00,0xFD,0xA2
	.byte	0x2D,0x6C,0x00,0x5A,0x00,0x08,0x19,0x41,0x00,0x20
	.byte	0x19,0x41,0x00,0x13,0x19,0x42
	.byte	0x00,0x21,0x29,0x4C,0x00,0x08,0x29,0x4C,0x00,0x0C
	.byte	0x4B,0xEE,0x00,0xF8,0x3B,0x7C
	.byte	0xFF,0xFF,0x00,0x08,0x29,0x4D,0x00,0x64,0x42,0x6C
	.byte	0x00,0x22,0x48,0xEC,0x0F,0x3F
	.byte	0x00,0x24,0x29,0x4C,0x00,0x3C,0x2A,0x6C,0x00,0x54
	.byte	0xB0,0x8D,0x66,0x04,0x4B,0xEE
	.byte	0x01,0xB4,0x9B,0xFC,0x00,0x00,0x00,0x1C,0x3B,0x7C
	.byte	0x00,0x80,0x00,0x1A,0x2B,0x48
	.byte	0x00,0x16,0x3B,0x7C,0x10,0x00,0x00,0x14,0x0C,0x83
	.byte	0x00,0x00,0x00,0x01,0x66,0x06
	.byte	0x08,0xED,0x00,0x05,0x00,0x14,0x48,0xE7,0xF8,0x00
	.byte	0x4C,0xEF,0x00,0x1F,0x00,0x14
	.byte	0x48,0xD5,0x00,0x1F,0x4C,0xDF,0x00,0x1F,0x29,0x4D
	.byte	0x00,0x4C,0x0C,0x83,0x00,0x00
	.byte	0x00,0x01,0x67,0x16,0x9B,0xEE,0x00,0x98,0x29,0x4D
	.byte	0x00,0x50,0x06,0xAC,0x00,0x00
	.byte	0x00,0x1C,0x00,0x50,0x08,0xEC,0x00,0x06,0x00,0x58
	.byte	0x08,0xAC,0x00,0x07,0x00,0x58
	.byte	0x2A,0x6E,0x00,0x10,0x29,0x6D,0x00,0x1C,0x00,0x1C
	.byte	0x4A,0xAE,0x00,0x88,0x67,0x1A
	.byte	0x48,0xE7,0x00,0x70,0x22,0x4C,0x24,0x4D,0xD2,0xFC
	.byte	0x00,0x14,0xD4,0xFC,0x00,0x14
	.byte	0x2A,0x6E,0x00,0x88,0x4E,0x95,0x4C,0xDF,0x0E,0x00
	.byte	0x29,0x4C,0x00,0x14,0x29,0x4C
	.byte	0x00,0x18,0x48,0xE7,0x60,0x00,0x74,0x00,0x34,0x2C
	.byte	0x00,0x12,0x22,0x02,0xE8,0x49
	.byte	0x46,0xC6,0x61,0x00,0x0D,0xA4,0x48,0x46,0x46,0xC6
	.byte	0x48,0x46,0x4C,0xDF,0x00,0x06
	.byte	0x4B,0xEE,0xFF,0xA6,0x29,0x4D,0x00,0x5E,0x29,0x56
	.byte	0x00,0x5A,0x2B,0x4C,0x00,0x5A
	.byte	0x2A,0x6C,0x00,0x5A,0x2B,0x4C,0x00,0x5E,0x4A,0x2C
	.byte	0x00,0x21,0x67,0x00,0xFC,0x92
	.byte	0x1E,0x02,0xCE,0x6E,0x00,0x28,0xE5,0x4F,0x2A,0x6E
	.byte	0x00,0x2C,0x28,0xB5,0x70,0x00
	.byte	0x2B,0x8C,0x70,0x00,0x60,0x00,0xFC,0x7A,0x8C,0x6E
	.byte	0x00,0x9E,0x2F,0x0B,0x47,0xFA
	.byte	0x00,0x0C,0x61,0x00,0x01,0x94,0x26,0x5F,0x60,0x00
	.byte	0xFC,0x66,0x46,0xC6,0x2A,0x6C
	.byte	0x00,0x5A,0x2B,0x6C,0x00,0x5E,0x00,0x5E,0x2A,0x6C
	.byte	0x00,0x5E,0x2B,0x6C,0x00,0x5A
	.byte	0x00,0x5A,0x48,0x46,0x46,0xC6,0x48,0x46,0x4A,0x2C
	.byte	0x00,0x21,0x67,0x1C,0x1E,0x2C
	.byte	0x00,0x21,0xCE,0x6E,0x00,0x28,0xE5,0x4F,0x2A,0x6E
	.byte	0x00,0x2C,0xDA,0xC7,0x2E,0x15
	.byte	0xBE,0x8C,0x67,0x04,0x2A,0x55,0x60,0xF6,0x2A,0x94
	.byte	0x48,0xE7,0x60,0x00,0x74,0x00
	.byte	0x34,0x2C,0x00,0x12,0x22,0x02,0xE8,0x49,0x46,0xC6
	.byte	0x4A,0x6C,0x00,0x22,0x66,0x06
	.byte	0x61,0x00,0x0D,0x5A,0x60,0x34,0x32,0x2C,0x00,0x22
	.byte	0x02,0x41,0x00,0x10,0x67,0x0A
	.byte	0x42,0x6E,0x00,0x22,0x42,0xAE,0x00,0x24,0x60,0x20
	.byte	0x32,0x2C,0x00,0x22,0x02,0x41
	.byte	0x06,0x4E,0x67,0x04,0x61,0x00,0x0C,0xB6,0x32,0x2C
	.byte	0x00,0x22,0x02,0x41,0x00,0x40
	.byte	0x67,0x08,0x2A,0x6C,0x00,0x68,0x53,0x6D,0x00,0x06
	.byte	0x39,0x7C,0x00,0x80,0x00,0x22
	.byte	0x48,0x46,0x46,0xC6,0x48,0x46,0x61,0x00,0x0D,0x5A
	.byte	0x4C,0xDF,0x00,0x06,0x61,0x00
	.byte	0x14,0x2E,0x2A,0x6C,0x00,0x64,0x53,0x6D,0x00,0x08
	.byte	0x66,0x16,0x48,0xE7,0x00,0x0C
	.byte	0x28,0x4D,0x61,0x00,0x09,0x62,0x4C,0xDF,0x30,0x00
	.byte	0x2A,0xAE,0x00,0xF4,0x2D,0x4D
	.byte	0x00,0xF4,0x29,0x6E,0x00,0x08,0x00,0x5A,0x2D,0x4C
	.byte	0x00,0x08,0x4A,0xAE,0x00,0x8C
	.byte	0x67,0x1C,0x48,0xE7,0x00,0x60,0x22,0x4C,0x24,0x6E
	.byte	0x00,0x10,0xD2,0xFC,0x00,0x14
	.byte	0xD4,0xFC,0x00,0x14,0x2A,0x6E,0x00,0x8C,0x4E,0x95
	.byte	0x4C,0xDF,0x06,0x00,0x4E,0x75
	.byte	0x8C,0x6E,0x00,0x9E,0x2F,0x0B,0x47,0xFA,0x00,0x0C
	.byte	0x61,0x00,0x00,0x8C,0x26,0x5F
	.byte	0x60,0x00,0xFB,0x5E,0x48,0xE7,0x60,0x00,0x0C,0x6C
	.byte	0x01,0x00,0x00,0x22,0x67,0x26
	.byte	0x74,0x00,0x34,0x2C,0x00,0x12,0x22,0x02,0xE8,0x49
	.byte	0x46,0xC6,0x4A,0x6C,0x00,0x22
	.byte	0x66,0x04,0x61,0x00,0x0C,0x88,0x00,0x6C,0x00,0x01
	.byte	0x00,0x22,0x48,0x46,0x46,0xC6
	.byte	0x48,0x46,0x61,0x00,0x0C,0xBE,0x4C,0xDF,0x00,0x06
	.byte	0x4E,0x75,0x8C,0x6E,0x00,0x9E
	.byte	0x3E,0x01,0x67,0x10,0x2F,0x0B,0x47,0xFA,0x00,0x12
	.byte	0x61,0x00,0x00,0x3C,0x26,0x5F
	.byte	0x60,0x00,0xFB,0x0E,0x70,0x01,0x60,0x00,0xFB,0x08
	.byte	0x48,0xE7,0x60,0x00,0x74,0x00
	.byte	0x34,0x2C,0x00,0x12,0x22,0x02,0xE8,0x49,0x46,0xC6
	.byte	0x08,0xAC,0x00,0x00,0x00,0x23
	.byte	0x67,0x0A,0x4A,0x6C,0x00,0x22,0x66,0x04,0x61,0x00
	.byte	0x0B,0xCE,0x48,0x46,0x46,0xC6
	.byte	0x48,0x46,0x4C,0xDF,0x00,0x06,0x4E,0x75,0x3E,0x01
	.byte	0x67,0x30,0x02,0x47,0xFF,0x00
	.byte	0x67,0x0A,0x0C,0x47,0x41,0x00,0x67,0x2C,0x70,0x12
	.byte	0x4E,0x75,0x1E,0x01,0xCE,0x6E
	.byte	0x00,0x28,0xE5,0x4F,0x28,0x6E,0x00,0x2C,0xD8,0xC7
	.byte	0x28,0x54,0xB0,0x8C,0x67,0x08
	.byte	0xB2,0x2C,0x00,0x21,0x66,0xF4,0x60,0x08,0x70,0x01
	.byte	0x4E,0x75,0x28,0x6E,0x00,0x10
	.byte	0x4E,0x93,0x4E,0x75,0xB2,0x3A,0xF9,0x34,0x63,0x04
	.byte	0x70,0x12,0x4E,0x75,0x4B,0xEE
	.byte	0xFF,0xA6,0x28,0x56,0xBB,0xCC,0x67,0x1E,0xB2,0x2C
	.byte	0x00,0x13,0x67,0x06,0x28,0x6C
	.byte	0x00,0x5A,0x60,0xF0,0x2F,0x2C,0x00,0x5A,0x48,0xE7
	.byte	0x40,0x04,0x4E,0x93,0x4C,0xDF
	.byte	0x20,0x02,0x28,0x5F,0x60,0xDE,0x4E,0x75,0x8C,0x6E
	.byte	0x00,0x9E,0x61,0x00,0x00,0xA4
	.byte	0x66,0x00,0xFA,0x5E,0xB4,0x3A,0xF8,0xF4,0x63,0x06
	.byte	0x70,0x12,0x60,0x00,0xFA,0x52
	.byte	0x4B,0xEE,0x01,0x18,0xB9,0xCD,0x67,0x00,0xFA,0x48
	.byte	0x1E,0x02,0x48,0xE7,0x60,0x00
	.byte	0x74,0x00,0x34,0x2C,0x00,0x12,0x22,0x02,0xE8,0x49
	.byte	0x46,0xC6,0x19,0x47,0x00,0x20
	.byte	0x4A,0x6C,0x00,0x22,0x66,0x36,0x61,0x00,0x0B,0x74
	.byte	0x00,0x6C,0x00,0x80,0x00,0x22
	.byte	0x19,0x6C,0x00,0x20,0x00,0x13,0x48,0x46,0x46,0xC6
	.byte	0x48,0x46,0x61,0x00,0x0B,0xA4
	.byte	0x74,0x00,0x34,0x2C,0x00,0x12,0x22,0x02,0xE8,0x49
	.byte	0x46,0xC6,0x02,0x6C,0xFF,0x7F
	.byte	0x00,0x22,0x4A,0x6C,0x00,0x22,0x66,0x04,0x61,0x00
	.byte	0x0A,0xDE,0x48,0x46,0x46,0xC6
	.byte	0x48,0x46,0x4C,0xDF,0x00,0x06,0x60,0x00,0xF9,0xE8
	.byte	0x8C,0x6E,0x00,0x9E,0x61,0x00
	.byte	0x00,0x22,0x66,0x00,0xF9,0xDC,0x72,0x00,0x12,0x2C
	.byte	0x00,0x21,0x74,0x00,0x14,0x2C
	.byte	0x00,0x20,0x76,0x00,0x36,0x2C,0x00,0x22,0x20,0x4C
	.byte	0xD0,0xFC,0x00,0x14,0x60,0x00
	.byte	0xF9,0xC0,0x3E,0x01,0x66,0x06,0x28,0x6E,0x00,0x10
	.byte	0x4E,0x75,0x02,0x47,0xFF,0x00
	.byte	0x67,0x04,0x70,0x01,0x4E,0x75,0x1E,0x01,0xCE,0x6E
	.byte	0x00,0x28,0xE5,0x4F,0x28,0x6E
	.byte	0x00,0x2C,0xD8,0xC7,0x28,0x54,0xB0,0x8C,0x67,0xE8
	.byte	0xB2,0x2C,0x00,0x21,0x66,0xF4
	.byte	0x4E,0x75,0x8C,0x6E,0x00,0x9E,0x52,0x6E,0x00,0x1A
	.byte	0x60,0x00,0xF9,0x84,0x8C,0x6E
	.byte	0x00,0x9E,0x46,0xC6,0x4A,0x6E,0x00,0x1A,0x67,0x04
	.byte	0x53,0x6E,0x00,0x1A,0x48,0x46
	.byte	0x46,0xC6,0x48,0x46,0x60,0x00,0xF9,0x6A,0x8C,0x6E
	.byte	0x00,0x9E,0x3E,0x01,0xCE,0x6E
	.byte	0x00,0x40,0x2A,0x76,0x75,0x25,0x00,0x44,0x60,0x02
	.byte	0x2A,0x55,0xB0,0x8D,0x67,0x54
	.byte	0xB2,0x6D,0x00,0x04,0x66,0xF4,0x28,0x6D,0x00,0x0C
	.byte	0x2F,0x06,0x46,0xEF,0x00,0x02
	.byte	0x3C,0x2C,0x00,0x1E,0x6B,0x2E,0x39,0x74,0x62,0x20
	.byte	0x00,0x1E,0x39,0xBC,0xFF,0xFF
	.byte	0x62,0x20,0x46,0xD7,0x3E,0x2D,0x00,0x0A,0xCE,0xC6
	.byte	0xDE,0xAC,0x00,0x04,0x20,0x47
	.byte	0x3E,0x2D,0x00,0x08,0x67,0x08,0xCE,0xC6,0x48,0x47
	.byte	0x42,0x47,0xD1,0xC7,0x2C,0x1F
	.byte	0x60,0x00,0xF9,0x0E,0x46,0xD7,0x28,0x54,0xB0,0x8C
	.byte	0x66,0xC0,0x2C,0x1F,0x70,0x03
	.byte	0x60,0x00,0xF8,0xFE,0x70,0x0E,0x60,0x00,0xF8,0xF8
	.byte	0x8C,0x6E,0x00,0x9E,0x3E,0x01
	.byte	0xCE,0x6E,0x00,0x40,0x2A,0x76,0x75,0x25,0x00,0x44
	.byte	0x60,0x02,0x2A,0x55,0xB0,0x8D
	.byte	0x67,0x62,0xB2,0x6D,0x00,0x04,0x66,0xF4,0x2F,0x06
	.byte	0x28,0x6D,0x00,0x0C,0x2C,0x08
	.byte	0xBC,0xAC,0x00,0x04,0x65,0x3A,0xBC,0xAC,0x00,0x08
	.byte	0x64,0x34,0x9C,0xAC,0x00,0x04
	.byte	0x4C,0x6D,0x60,0x07,0x00,0x08,0x4A,0x47,0x66,0x2C
	.byte	0xBC,0x6C,0x00,0x0C,0x62,0x26
	.byte	0x46,0xEF,0x00,0x02,0x0C,0x74,0xFF,0xFF,0x63,0x20
	.byte	0x00,0x20,0x66,0x18,0x39,0xAC
	.byte	0x00,0x1E,0x62,0x20,0x39,0x46,0x00,0x1E,0x46,0xD7
	.byte	0x2C,0x1F,0x60,0x00,0xF8,0x92
	.byte	0x28,0x54,0xB0,0x8C,0x66,0xBA,0x2C,0x1F,0x48,0x46
	.byte	0x46,0xC6,0x48,0x46,0x70,0x04
	.byte	0x60,0x00,0xF8,0x7E,0x70,0x0E,0x60,0x00,0xF8,0x78
	.byte	0x8C,0x6E,0x00,0x9E,0x3E,0x01
	.byte	0xCE,0x6E,0x00,0x40,0x2A,0x76,0x75,0x25,0x00,0x44
	.byte	0x60,0x02,0x2A,0x55,0xB0,0x8D
	.byte	0x67,0x0A,0xB2,0x6D,0x00,0x04,0x66,0xF4,0x70,0x0E
	.byte	0x60,0x68,0x70,0x00,0x2F,0x06
	.byte	0x2C,0x02,0x4A,0x83,0x67,0x5A,0x4C,0x43,0x60,0x07
	.byte	0x69,0x54,0x6E,0x06,0x0C,0x46
	.byte	0x80,0x00,0x66,0x4C,0x7E,0x00,0x3E,0x06,0xDE,0x87
	.byte	0x06,0x87,0x00,0x00,0x00,0x40
	.byte	0x28,0x47,0x46,0xEF,0x00,0x02,0x61,0x00,0x08,0x84
	.byte	0x66,0x3C,0x46,0xD7,0x39,0x41
	.byte	0x00,0x04,0x29,0x43,0x00,0x08,0x2A,0x4C,0xDB,0xFC
	.byte	0x00,0x00,0x00,0x20,0x29,0x4D
	.byte	0x00,0x0C,0x61,0x30,0x2A,0x80,0x3E,0x01,0xCE,0x6E
	.byte	0x00,0x40,0xE5,0x4F,0x2A,0x6E
	.byte	0x00,0x44,0x28,0xB5,0x70,0x00,0x2B,0x8C,0x70,0x00
	.byte	0x2C,0x1F,0x60,0x00,0xF7,0xF2
	.byte	0x2C,0x1F,0x70,0x12,0x60,0x00,0xF7,0xEA,0x2C,0x1F
	.byte	0x48,0x46,0x46,0xC6,0x48,0x46
	.byte	0x70,0x03,0x60,0xF0,0x2F,0x0C,0x2B,0x48,0x00,0x04
	.byte	0x3E,0x06,0xCE,0xEC,0x00,0x0A
	.byte	0xDE,0x88,0x2B,0x47,0x00,0x08,0x4A,0x6C,0x00,0x08
	.byte	0x67,0x0E,0x3E,0x06,0xCE,0xEC
	.byte	0x00,0x08,0x48,0x47,0x42,0x47,0xDF,0xAD,0x00,0x08
	.byte	0x7E,0x00,0x53,0x86,0x3B,0x46
	.byte	0x00,0x0C,0x49,0xED,0x00,0x1E,0x38,0xC7,0x52,0x47
	.byte	0x51,0xCE,0xFF,0xFA,0x38,0xBC
	.byte	0x80,0x00,0x28,0x5F,0x4E,0x75,0x8C,0x6E,0x00,0x9E
	.byte	0x3E,0x01,0xCE,0x6E,0x00,0x40
	.byte	0x2A,0x76,0x75,0x25,0x00,0x44,0x60,0x02,0x2A,0x55
	.byte	0xB0,0x8D,0x67,0x6C,0xB2,0x6D
	.byte	0x00,0x04,0x66,0xF4,0x2F,0x06,0x2C,0x02,0x4C,0x6D
	.byte	0x60,0x07,0x00,0x08,0x69,0x60
	.byte	0x6E,0x06,0x0C,0x46,0x80,0x00,0x66,0x58,0x2E,0x02
	.byte	0xDE,0x88,0x28,0x6D,0x00,0x0C
	.byte	0xB1,0xEC,0x00,0x04,0x65,0x0A,0xB1,0xEC,0x00,0x08
	.byte	0x64,0x0A,0x60,0x00,0x00,0x42
	.byte	0xBE,0xAC,0x00,0x04,0x62,0x3A,0x28,0x54,0xB0,0x8C
	.byte	0x66,0xE4,0x7E,0x00,0x3E,0x06
	.byte	0xDE,0x87,0x06,0x87,0x00,0x00,0x00,0x20,0x46,0xEF
	.byte	0x00,0x02,0x28,0x47,0x61,0x00
	.byte	0x07,0x8C,0x66,0x24,0x46,0xD7,0xC9,0x4D,0x61,0x00
	.byte	0xFF,0x4A,0x2A,0xAC,0x00,0x0C
	.byte	0x29,0x4D,0x00,0x0C,0x2C,0x1F,0x60,0x00,0xF7,0x18
	.byte	0x70,0x0E,0x60,0x00,0xF7,0x12
	.byte	0x2C,0x1F,0x70,0x12,0x60,0x00,0xF7,0x0A,0x2C,0x1F
	.byte	0x48,0x46,0x46,0xC6,0x48,0x46
	.byte	0x70,0x03,0x60,0x00,0xF6,0xFC,0x8C,0x6E,0x00,0x9E
	.byte	0x3E,0x01,0xCE,0x6E,0x00,0x30
	.byte	0x2A,0x76,0x75,0x25,0x00,0x34,0x60,0x02,0x2A,0x55
	.byte	0xB0,0x8D,0x67,0x3C,0xB2,0x6D
	.byte	0x00,0x04,0x66,0xF4,0x46,0xC6,0x4A,0x6D,0x00,0x06
	.byte	0x66,0x3A,0x3E,0x2D,0x00,0x08
	.byte	0xBE,0x6D,0x00,0x0A,0x6C,0x2A,0x3E,0x2D,0x00,0x0E
	.byte	0x2B,0x82,0x74,0x20,0x52,0x47
	.byte	0xBE,0x6D,0x00,0x0A,0x63,0x02,0x7E,0x00,0x3B,0x47
	.byte	0x00,0x0E,0x52,0x6D,0x00,0x08
	.byte	0x48,0x46,0x46,0xC6,0x48,0x46,0x60,0x00,0xF6,0xA8
	.byte	0x70,0x0C,0x60,0x00,0xF6,0xA2
	.byte	0x70,0x0D,0x60,0x00,0xF6,0x9C,0x53,0x6D,0x00,0x06
	.byte	0x28,0x6D,0x00,0x12,0x61,0x00
	.byte	0x07,0x5C,0x48,0x46,0x46,0xC6,0x48,0x46,0x29,0x42
	.byte	0x00,0x2C,0x48,0xE7,0x60,0x00
	.byte	0x74,0x00,0x34,0x2C,0x00,0x12,0x22,0x02,0xE8,0x49
	.byte	0x46,0xC6,0x02,0x6C,0xFF,0x9F
	.byte	0x00,0x22,0x4A,0x6C,0x00,0x22,0x66,0x04,0x61,0x00
	.byte	0x07,0x4E,0x48,0x46,0x46,0xC6
	.byte	0x48,0x46,0x4C,0xDF,0x00,0x06,0x60,0x00,0xF6,0x58
	.byte	0x8C,0x6E,0x00,0x9E,0x3E,0x01
	.byte	0xCE,0x6E,0x00,0x30,0x2A,0x76,0x75,0x25,0x00,0x34
	.byte	0x60,0x02,0x2A,0x55,0xB0,0x8D
	.byte	0x67,0x00,0x00,0x96,0xB2,0x6D,0x00,0x04,0x66,0xF2
	.byte	0x28,0x6E,0x00,0x10,0x29,0x4D
	.byte	0x00,0x68,0x48,0xEC,0x0F,0x3F,0x00,0x24,0x46,0xC6
	.byte	0x4A,0x6D,0x00,0x08,0x66,0x00
	.byte	0x00,0xBA,0x2F,0x02,0x74,0x00,0x34,0x2C,0x00,0x12
	.byte	0x22,0x02,0xE8,0x49,0x4A,0x6C
	.byte	0x00,0x22,0x66,0x04,0x61,0x00,0x07,0x56,0x00,0x6C
	.byte	0x00,0x60,0x00,0x22,0x2A,0x6C
	.byte	0x00,0x68,0x52,0x6D,0x00,0x06,0x4A,0x6D,0x00,0x1A
	.byte	0x4B,0xED,0xFF,0xFE,0x67,0x18
	.byte	0x29,0x4D,0x00,0x14,0x29,0x6D,0x00,0x18,0x00,0x18
	.byte	0x2B,0x4C,0x00,0x18,0x2A,0x6C
	.byte	0x00,0x18,0x2B,0x4C,0x00,0x14,0x60,0x04,0x61,0x00
	.byte	0x06,0x52,0x48,0x46,0x46,0xC6
	.byte	0x48,0x46,0x08,0xEC,0x00,0x07,0x00,0x58,0x61,0x00
	.byte	0x07,0x58,0x61,0x00,0x0E,0x30
	.byte	0x24,0x1F,0x4A,0x82,0x67,0x08,0x22,0x02,0x61,0x00
	.byte	0x0D,0xE0,0x60,0x06,0x02,0x6C
	.byte	0xFF,0xDF,0x00,0x22,0x60,0x00,0xF5,0xAA,0x70,0x0C
	.byte	0x60,0x00,0xF5,0xA4,0x8C,0x6E
	.byte	0x00,0x9E,0x3E,0x01,0xCE,0x6E,0x00,0x30,0x2A,0x76
	.byte	0x75,0x25,0x00,0x34,0x60,0x02
	.byte	0x2A,0x55,0xB0,0x8D,0x67,0x1E,0xB2,0x6D,0x00,0x04
	.byte	0x66,0xF4,0x28,0x6E,0x00,0x10
	.byte	0x46,0xC6,0x4A,0x6D,0x00,0x08,0x66,0x12,0x48,0x46
	.byte	0x46,0xC6,0x48,0x46,0x70,0x0B
	.byte	0x60,0x00,0xF5,0x6E,0x70,0x0C,0x60,0x00,0xF5,0x68
	.byte	0x3E,0x2D,0x00,0x0C,0x24,0x35
	.byte	0x74,0x20,0x53,0x6D,0x00,0x08,0x52,0x47,0xBE,0x6D
	.byte	0x00,0x0A,0x63,0x02,0x7E,0x00
	.byte	0x3B,0x47,0x00,0x0C,0x48,0x46,0x46,0xC6,0x48,0x46
	.byte	0x60,0x00,0xF5,0x44,0x61,0x00
	.byte	0x00,0x1A,0x60,0x00,0xF5,0x3C,0x61,0x00,0x00,0x12
	.byte	0x4A,0x80,0x66,0x08,0x4A,0x83
	.byte	0x67,0x04,0x52,0x6C,0x00,0x1A,0x60,0x00,0xF5,0x28
	.byte	0x8C,0x6E,0x00,0x9E,0x3E,0x01
	.byte	0xCE,0x6E,0x00,0x30,0x2A,0x76,0x75,0x25,0x00,0x34
	.byte	0x60,0x02,0x2A,0x55,0xB0,0x8D
	.byte	0x67,0x0A,0xB2,0x6D,0x00,0x04,0x66,0xF4,0x70,0x0C
	.byte	0x4E,0x75,0x70,0x00,0x2E,0x00
	.byte	0x3E,0x02,0xE5,0x8F,0x06,0x87,0x00,0x00,0x00,0x24
	.byte	0x28,0x47,0x61,0x00,0x05,0x4E
	.byte	0x66,0x28,0x39,0x41,0x00,0x04,0x39,0x42,0x00,0x0A
	.byte	0x4B,0xEC,0xFF,0xFE,0x29,0x4D
	.byte	0x00,0x12,0x29,0x4D,0x00,0x16,0x3E,0x01,0xCE,0x6E
	.byte	0x00,0x30,0x28,0xB6,0x75,0x25
	.byte	0x00,0x34,0x2D,0x8C,0x75,0x25,0x00,0x34,0x4E,0x75
	.byte	0x70,0x03,0x4E,0x75,0x8C,0x6E
	.byte	0x00,0x9E,0x3E,0x01,0xCE,0x6E,0x00,0x30,0x2A,0x76
	.byte	0x75,0x25,0x00,0x34,0x60,0x02
	.byte	0x2A,0x55,0xB0,0x8D,0x67,0x22,0xB2,0x6D,0x00,0x04
	.byte	0x66,0xF4,0x46,0xC6,0x76,0x00
	.byte	0x36,0x2D,0x00,0x08,0x67,0x08,0x3E,0x2D,0x00,0x0C
	.byte	0x24,0x35,0x74,0x20,0x48,0x46
	.byte	0x46,0xC6,0x48,0x46,0x60,0x00,0xF4,0x8A,0x70,0x0C
	.byte	0x60,0x00,0xF4,0x84,0x8C,0x6E
	.byte	0x00,0x9E,0x3E,0x01,0xCE,0x6E,0x00,0x30,0x2A,0x76
	.byte	0x75,0x25,0x00,0x34,0x60,0x02
	.byte	0x2A,0x55,0xB0,0x8D,0x67,0x44,0xB2,0x6D,0x00,0x04
	.byte	0x66,0xF4,0x46,0xC6,0x4A,0x6D
	.byte	0x00,0x06,0x66,0x00,0xFD,0xC2,0x3E,0x2D,0x00,0x08
	.byte	0xBE,0x6D,0x00,0x0A,0x62,0x24
	.byte	0x3E,0x2D,0x00,0x0C,0x66,0x06,0x3E,0x2D,0x00,0x0A
	.byte	0x60,0x02,0x53,0x47,0x2B,0x82
	.byte	0x74,0x20,0x3B,0x47,0x00,0x0C,0x52,0x6D,0x00,0x08
	.byte	0x48,0x46,0x46,0xC6,0x48,0x46
	.byte	0x60,0x00,0xF4,0x2E,0x70,0x0D,0x60,0x00,0xF4,0x28
	.byte	0x70,0x0C,0x60,0x00,0xF4,0x22
	.byte	0x8C,0x6E,0x00,0x9E,0x4A,0x81,0x67,0x00,0x00,0x72
	.byte	0x61,0x00,0x01,0xAC,0x66,0x4C
	.byte	0x46,0xC6,0x49,0xED,0xFF,0xF8,0xB9,0xED,0x00,0x0C
	.byte	0x67,0x40,0x28,0x6D,0x00,0x0C
	.byte	0x61,0x00,0x04,0xCA,0x48,0x46,0x46,0xC6,0x48,0x46
	.byte	0x29,0x41,0x00,0x28,0x48,0xE7
	.byte	0x60,0x00,0x74,0x00,0x34,0x2C,0x00,0x12,0x22,0x02
	.byte	0xE8,0x49,0x46,0xC6,0x02,0x6C
	.byte	0xFF,0xDD,0x00,0x22,0x4A,0x6C,0x00,0x22,0x66,0x04
	.byte	0x61,0x00,0x04,0xBC,0x48,0x46
	.byte	0x46,0xC6,0x48,0x46,0x4C,0xDF,0x00,0x06,0x60,0x00
	.byte	0xF3,0xC6,0x46,0xC6,0x4A,0x90
	.byte	0x66,0x0C,0x20,0x81,0x48,0x46,0x46,0xC6,0x48,0x46
	.byte	0x60,0x00,0xF3,0xB4,0x48,0x46
	.byte	0x46,0xC6,0x48,0x46,0x70,0x05,0x60,0x00,0xF3,0xA8
	.byte	0x70,0x06,0x60,0x00,0xF3,0xA2
	.byte	0x8C,0x6E,0x00,0x9E,0x28,0x6E,0x00,0x10,0x46,0xC6
	.byte	0x2E,0x10,0x42,0x90,0x48,0x46
	.byte	0x46,0xC6,0x48,0x46,0x4A,0x87,0x67,0x06,0x22,0x07
	.byte	0x60,0x00,0xF3,0x84,0x48,0xE7
	.byte	0x60,0x00,0x74,0x00,0x34,0x2C,0x00,0x12,0x22,0x02
	.byte	0xE8,0x49,0x46,0xC6,0x4A,0x6C
	.byte	0x00,0x22,0x66,0x04,0x61,0x00,0x04,0xB6,0x00,0x6C
	.byte	0x00,0x02,0x00,0x22,0x48,0x46
	.byte	0x46,0xC6,0x48,0x46,0x61,0x00,0x04,0xEC,0x4C,0xDF
	.byte	0x00,0x06,0x2A,0x6C,0x00,0x64
	.byte	0xB1,0xED,0x00,0x04,0x67,0x3E,0x53,0x6D,0x00,0x08
	.byte	0x66,0x0E,0x28,0x4D,0x61,0x00
	.byte	0x00,0xF6,0x28,0xAE,0x00,0xF4,0x2D,0x4C,0x00,0xF4
	.byte	0x61,0x00,0x00,0xCC,0x67,0x20
	.byte	0x28,0x6E,0x00,0xF4,0x2D,0x54,0x00,0xF4,0x29,0x48
	.byte	0x00,0x04,0x3E,0x08,0xCE,0x6E
	.byte	0x00,0x38,0x2A,0x6E,0x00,0x3C,0x28,0xB5,0x70,0x00
	.byte	0x2B,0x8C,0x70,0x00,0x2A,0x4C
	.byte	0x52,0x6D,0x00,0x08,0x28,0x6E,0x00,0x10,0x29,0x4D
	.byte	0x00,0x64,0x48,0xEC,0x0F,0x3F
	.byte	0x00,0x24,0x46,0xC6,0x2E,0x10,0x66,0x36,0x4B,0xED
	.byte	0xFF,0xF8,0x00,0x6C,0x00,0x22
	.byte	0x00,0x22,0x61,0x00,0x03,0x68,0x48,0x46,0x46,0xC6
	.byte	0x48,0x46,0x08,0xEC,0x00,0x07
	.byte	0x00,0x58,0x61,0x00,0x0B,0x4A,0x4A,0x81,0x67,0x0A
	.byte	0x2F,0x01,0x61,0x00,0x0A,0xFC
	.byte	0x22,0x1F,0x60,0x06,0x02,0x6C,0xFF,0xDF,0x00,0x22
	.byte	0x60,0x00,0xF2,0xC4,0x42,0x90
	.byte	0x22,0x07,0x48,0x46,0x46,0xC6,0x48,0x46,0x48,0xE7
	.byte	0x60,0x00,0x74,0x00,0x34,0x2C
	.byte	0x00,0x12,0x22,0x02,0xE8,0x49,0x46,0xC6,0x02,0x6C
	.byte	0xFF,0xFD,0x00,0x22,0x4A,0x6C
	.byte	0x00,0x22,0x66,0x04,0x61,0x00,0x03,0x82,0x48,0x46
	.byte	0x46,0xC6,0x48,0x46,0x4C,0xDF
	.byte	0x00,0x06,0x60,0xC6,0x8C,0x6E,0x00,0x9E,0x46,0xC6
	.byte	0x4A,0x90,0x66,0x0C,0x48,0x46
	.byte	0x46,0xC6,0x48,0x46,0x70,0x0B,0x60,0x00,0xF2,0x78
	.byte	0x22,0x10,0x42,0x90,0x48,0x46
	.byte	0x46,0xC6,0x48,0x46,0x60,0x00,0xF2,0x6A,0x3E,0x08
	.byte	0xCE,0x6E,0x00,0x38,0x2A,0x6E
	.byte	0x00,0x3C,0xDA,0xC7,0x2A,0x55,0xB0,0x8D,0x67,0x08
	.byte	0xB1,0xED,0x00,0x04,0x66,0xF4
	.byte	0x4E,0x75,0x7E,0x01,0x4E,0x75,0x2E,0x2C,0x00,0x04
	.byte	0xCE,0x6E,0x00,0x38,0x2A,0x6E
	.byte	0x00,0x3C,0xDA,0xC7,0x2E,0x15,0xBE,0x8C,0x67,0x04
	.byte	0x2A,0x55,0x60,0xF6,0x2A,0x94
	.byte	0x4E,0x75,0x8C,0x6E,0x00,0x9E,0x28,0x6E,0x00,0x10
	.byte	0x48,0xE7,0x60,0x00,0x74,0x00
	.byte	0x34,0x2C,0x00,0x12,0x22,0x02,0xE8,0x49,0x46,0xC6
	.byte	0x4A,0x6E,0x00,0xB4,0x67,0x26
	.byte	0x4C,0xDF,0x00,0x06,0x3E,0x2E,0x00,0xB6,0x2A,0x6E
	.byte	0x00,0xC4,0x12,0x35,0x70,0x00
	.byte	0x53,0x6E,0x00,0xB4,0x52,0x47,0xBE,0x7A,0xF0,0x94
	.byte	0x66,0x02,0x7E,0x00,0x3D,0x47
	.byte	0x00,0xB6,0x60,0x00,0xF1,0xEC,0x4A,0x6C,0x00,0x22
	.byte	0x66,0x04,0x61,0x00,0x03,0x2E
	.byte	0x00,0x6C,0x00,0x04,0x00,0x22,0x4B,0xEE,0x00,0xA8
	.byte	0x61,0x00,0x02,0x50,0x48,0x46
	.byte	0x46,0xC6,0x48,0x46,0x61,0x00,0x03,0x5C,0x4C,0xDF
	.byte	0x00,0x06,0x55,0xAF,0x00,0x16
	.byte	0x70,0x0D,0x60,0x00,0xF1,0xBC,0x8C,0x6E,0x00,0x9E
	.byte	0x28,0x6E,0x00,0x10,0x48,0xE7
	.byte	0x60,0x00,0x74,0x00,0x34,0x2C,0x00,0x12,0x22,0x02
	.byte	0xE8,0x49,0x46,0xC6,0x4A,0x2E
	.byte	0x00,0x60,0x66,0x00,0x00,0x6C,0x3E,0x2E,0x00,0xD4
	.byte	0xBE,0x7A,0xF0,0x30,0x67,0x2C
	.byte	0x4C,0xDF,0x00,0x06,0x3E,0x2E,0x00,0xD8,0x2A,0x6E
	.byte	0x00,0xE4,0x1B,0x81,0x70,0x00
	.byte	0x52,0x6E,0x00,0xD4,0x52,0x47,0xBE,0x7A,0xF0,0x14
	.byte	0x66,0x02,0x7E,0x00,0x3D,0x47
	.byte	0x00,0xD8,0x48,0x46,0x46,0xC6,0x48,0x46,0x60,0x00
	.byte	0xF1,0x66,0x4A,0x6C,0x00,0x22
	.byte	0x66,0x04,0x61,0x00,0x02,0xA8,0x00,0x6C,0x00,0x08
	.byte	0x00,0x22,0x4B,0xEE,0x00,0xC8
	.byte	0x61,0x00,0x01,0xCA,0x48,0x46,0x46,0xC6,0x48,0x46
	.byte	0x61,0x00,0x02,0xD6,0x4C,0xDF
	.byte	0x00,0x06,0x55,0xAF,0x00,0x16,0x70,0x0E,0x29,0x40
	.byte	0x00,0x24,0x60,0x00,0xF1,0x32
	.byte	0x4C,0xDF,0x00,0x06,0x42,0x2E,0x00,0x60,0x2A,0x6E
	.byte	0x00,0x62,0x4E,0x95,0x60,0x00
	.byte	0xF1,0x20,0x8C,0x6E,0x00,0x9E,0x4A,0xAE,0x00,0x24
	.byte	0x66,0x3E,0x28,0x6E,0x00,0x10
	.byte	0x1D,0x41,0x00,0x22,0x48,0xE7,0x60,0x00,0x74,0x00
	.byte	0x34,0x2C,0x00,0x12,0x22,0x02
	.byte	0xE8,0x49,0x46,0xC6,0x4A,0x6C,0x00,0x22,0x66,0x04
	.byte	0x61,0x00,0x02,0x40,0x00,0x6C
	.byte	0x00,0x10,0x00,0x22,0x2D,0x4C,0x00,0x24,0x48,0x46
	.byte	0x46,0xC6,0x48,0x46,0x61,0x00
	.byte	0x02,0x72,0x4C,0xDF,0x00,0x06,0x60,0x00,0xF0,0xD8
	.byte	0x70,0x08,0x60,0x00,0xF0,0xD2
	.byte	0x8C,0x6E,0x00,0x9E,0x46,0xC6,0xB2,0x2E,0x00,0x22
	.byte	0x67,0x00,0x00,0x7A,0x3E,0x2E
	.byte	0x00,0xB4,0xBE,0x7A,0xEF,0x58,0x67,0x00,0x00,0x82
	.byte	0x3E,0x2E,0x00,0xB8,0x2A,0x6E
	.byte	0x00,0xC4,0x1B,0x81,0x70,0x00,0x52,0x6E,0x00,0xB4
	.byte	0x52,0x47,0xBE,0x7A,0xEF,0x3E
	.byte	0x66,0x02,0x7E,0x00,0x3D,0x47,0x00,0xB8,0x48,0x46
	.byte	0x46,0xC6,0x48,0x46,0x4B,0xEE
	.byte	0x00,0xA8,0x46,0xC6,0xBB,0xEE,0x00,0xBC,0x67,0x32
	.byte	0x28,0x6E,0x00,0xBC,0x61,0x00
	.byte	0x01,0x4C,0x48,0x46,0x46,0xC6,0x48,0x46,0x48,0xE7
	.byte	0x60,0x00,0x74,0x00,0x34,0x2C
	.byte	0x00,0x12,0x22,0x02,0xE8,0x49,0x46,0xC6,0x02,0x6C
	.byte	0xFF,0xEB,0x00,0x22,0x4A,0x6C
	.byte	0x00,0x22,0x66,0x04,0x61,0x00,0x01,0x42,0x4C,0xDF
	.byte	0x00,0x06,0x48,0x46,0x46,0xC6
	.byte	0x48,0x46,0x60,0x00,0xF0,0x4C,0x28,0x6E,0x00,0x24
	.byte	0xB0,0x8C,0x67,0x00,0xFF,0x80
	.byte	0x2D,0x40,0x00,0x24,0x1D,0x40,0x00,0x22,0x60,0xBE
	.byte	0x70,0x07,0x48,0x46,0x46,0xC6
	.byte	0x48,0x46,0x60,0x00,0xF0,0x2C,0x8C,0x6E,0x00,0x9E
	.byte	0x46,0xC6,0x42,0x2E,0x00,0x60
	.byte	0x4A,0x6E,0x00,0xD4,0x67,0x6C,0x3E,0x2E,0x00,0xD6
	.byte	0x2A,0x6E,0x00,0xE4,0x12,0x35
	.byte	0x70,0x00,0x53,0x6E,0x00,0xD4,0x52,0x87,0xBE,0x7A
	.byte	0xEE,0xA2,0x66,0x02,0x7E,0x00
	.byte	0x3D,0x47,0x00,0xD6,0x48,0x46,0x46,0xC6,0x48,0x46
	.byte	0x4B,0xEE,0x00,0xC8,0x46,0xC6
	.byte	0xBB,0xEE,0x00,0xDC,0x67,0x32,0x28,0x6E,0x00,0xDC
	.byte	0x61,0x00,0x00,0xB0,0x48,0x46
	.byte	0x46,0xC6,0x48,0x46,0x48,0xE7,0x60,0x00,0x74,0x00
	.byte	0x34,0x2C,0x00,0x12,0x22,0x02
	.byte	0xE8,0x49,0x46,0xC6,0x02,0x6C,0xFF,0xF7,0x00,0x22
	.byte	0x4A,0x6C,0x00,0x22,0x66,0x04
	.byte	0x61,0x00,0x00,0xA6,0x4C,0xDF,0x00,0x06,0x48,0x46
	.byte	0x46,0xC6,0x48,0x46,0x60,0x00
	.byte	0xEF,0xB0,0x52,0x2E,0x00,0x60,0x70,0x10,0x60,0x00
	.byte	0xEF,0xA6,0xB9,0xEE,0x00,0x5C
	.byte	0x62,0x16,0x2F,0x00,0x20,0x0C,0x91,0xAE,0x00,0x5C
	.byte	0x20,0x2E,0x00,0x58,0xC1,0x8C
	.byte	0xD1,0xAE,0x00,0x58,0x20,0x1F,0x4E,0x75,0x70,0x03
	.byte	0x4E,0x75,0x29,0x4D,0x00,0x14
	.byte	0x29,0x6D,0x00,0x18,0x00,0x18,0x2B,0x4C,0x00,0x18
	.byte	0x2A,0x6C,0x00,0x18,0x2B,0x4C
	.byte	0x00,0x14,0x48,0x46,0x46,0xC6,0x48,0x46,0x46,0xC6
	.byte	0x3E,0x2C,0x00,0x22,0x02,0x47
	.byte	0x06,0x4E,0x67,0x26,0x2A,0x6C,0x00,0x18,0x3E,0x2C
	.byte	0x00,0x12,0xBE,0x6D,0x00,0x12
	.byte	0x6C,0x18,0x2B,0x6C,0x00,0x14,0x00,0x14,0x2A,0x6C
	.byte	0x00,0x14,0x2B,0x6C,0x00,0x18
	.byte	0x00,0x18,0x2A,0x6C,0x00,0x18,0x60,0x00,0xFF,0xB4
	.byte	0x4E,0x75,0x2A,0x6C,0x00,0x14
	.byte	0x2B,0x6C,0x00,0x18,0x00,0x18,0x2A,0x6C,0x00,0x18
	.byte	0x2B,0x6C,0x00,0x14,0x00,0x14
	.byte	0x19,0x6C,0x00,0x20,0x00,0x13,0x4E,0x75,0x19,0x6C
	.byte	0x00,0x20,0x00,0x13,0x42,0x6C
	.byte	0x00,0x70,0x4A,0xB6,0x25,0x25,0x00,0x4C,0x67,0x1E
	.byte	0x2A,0x76,0x25,0x25,0x00,0x4C
	.byte	0x29,0x6D,0x00,0x18,0x00,0x18,0x29,0x4D,0x00,0x14
	.byte	0x2B,0x4C,0x00,0x18,0x2A,0x6C
	.byte	0x00,0x18,0x2B,0x4C,0x00,0x14,0x4E,0x75,0x29,0x4C
	.byte	0x00,0x14,0x29,0x4C,0x00,0x18
	.byte	0x2D,0x8C,0x25,0x25,0x00,0x4C,0xEE,0xEE,0x08,0x41
	.byte	0x00,0x86,0xEE,0xEE,0x08,0x81
	.byte	0x00,0x66,0x2A,0x6E,0x00,0x14,0x34,0x2C,0x00,0x12
	.byte	0xB4,0x6D,0x00,0x12,0x6C,0x0A
	.byte	0x2D,0x4C,0x00,0x14,0x1D,0x7C,0x00,0x01,0x00,0x1E
	.byte	0x4E,0x75,0xB9,0xEC,0x00,0x14
	.byte	0x66,0x1A,0x42,0xB6,0x25,0x25,0x00,0x4C,0xEC,0xEE
	.byte	0x08,0x81,0x00,0x66,0x4A,0x76
	.byte	0x12,0x66,0x66,0x06,0xEC,0xEE,0x08,0x41,0x00,0x86
	.byte	0x4E,0x75,0xB9,0xF6,0x25,0x25
	.byte	0x00,0x4C,0x66,0x08,0x2D,0xAC,0x00,0x14,0x25,0x25
	.byte	0x00,0x4C,0x2A,0x6C,0x00,0x18
	.byte	0x2B,0x6C,0x00,0x14,0x00,0x14,0x2A,0x6C,0x00,0x14
	.byte	0x2B,0x6C,0x00,0x18,0x00,0x18
	.byte	0x4E,0x75,0x72,0x00,0x34,0x01,0x46,0xC6,0xED,0xEE
	.byte	0x20,0x10,0x00,0x86,0x67,0x20
	.byte	0xED,0xF6,0x10,0x10,0x22,0x66,0xE9,0x4A,0xD4,0x41
	.byte	0x2D,0x76,0x25,0x25,0x00,0x4C
	.byte	0x00,0x14,0x48,0x46,0x46,0xC6,0x48,0x46,0x1D,0x7C
	.byte	0x00,0x01,0x00,0x1E,0x4E,0x75
	.byte	0x24,0x0E,0x06,0x42,0x01,0x18,0x2D,0x42,0x00,0x14
	.byte	0x60,0xE6,0x60,0xFE,0x43,0x6F
	.byte	0x70,0x79,0x72,0x69,0x67,0x68,0x74,0x20,0x31,0x39
	.byte	0x38,0x36,0x2C,0x20,0x48,0x75
	.byte	0x6E,0x74,0x65,0x72,0x20,0x26,0x20,0x52,0x65,0x61
	.byte	0x64,0x79,0x2C,0x20,0x49,0x6E
	.byte	0x63,0x2E,0xAE,0x68,0x55,0x21,0xB1,0xD5,0xE4,0xEB
	.byte	0x1C,0xED,0xD5,0x96,0x95,0x94
	.byte	0xD4,0x6B,0x82,0x15,0x9E,0xF6,0x1A,0xF4,0x68,0xE4
	.byte	0x4E,0xCF,0x98,0x09,0x94,0xEB
	.byte	0xFD,0x8C,0x50,0xE0,0x09,0x49,0x55,0xFF,0x8C,0x6E
	.byte	0x00,0x9E,0x2A,0x6E,0x00,0x0C
	.byte	0xBB,0xC0,0x67,0x2A,0x2D,0x6D,0x00,0x0C,0x00,0x0C
	.byte	0x2B,0x40,0x00,0x14,0x2B,0x7C
	.byte	0x00,0x00,0x00,0x01,0x00,0x04,0x49,0xED,0xFF,0xF8
	.byte	0x2B,0x4C,0x00,0x0C,0x2B,0x4C
	.byte	0x00,0x10,0x22,0x15,0x2D,0x8D,0x1D,0x25,0x00,0x54
	.byte	0x60,0x00,0xED,0xB4,0x70,0x30
	.byte	0x60,0x00,0xED,0xAE,0x8C,0x6E,0x00,0x9E,0xB2,0xAE
	.byte	0x00,0x50,0x62,0x00,0x01,0xBE
	.byte	0x2A,0x76,0x1D,0x25,0x00,0x54,0xB0,0x8D,0x67,0x00
	.byte	0x01,0xB2,0x0C,0xAD,0x00,0x00
	.byte	0x00,0x01,0x00,0x04,0x66,0x00,0x01,0xA6,0x4B,0xED
	.byte	0xFF,0xF8,0x46,0xC6,0xBB,0xED
	.byte	0x00,0x14,0x67,0x50,0x4A,0x82,0x67,0x6E,0x2F,0x0D
	.byte	0x28,0x6D,0x00,0x14,0x29,0x6D
	.byte	0x00,0x1C,0x00,0x2C,0x61,0x00,0xFE,0x36,0x48,0x46
	.byte	0x46,0xC6,0x48,0x46,0x29,0x7C
	.byte	0x00,0x00,0x00,0x33,0x00,0x24,0x48,0xE7,0x60,0x00
	.byte	0x74,0x00,0x34,0x2C,0x00,0x12
	.byte	0x22,0x02,0xE8,0x49,0x46,0xC6,0x02,0x6C,0xFD,0xDF
	.byte	0x00,0x22,0x4A,0x6C,0x00,0x22
	.byte	0x66,0x04,0x61,0x00,0xFE,0x24,0x48,0x46,0x46,0xC6
	.byte	0x48,0x46,0x4C,0xDF,0x00,0x06
	.byte	0x2A,0x5F,0x60,0xA8,0x4B,0xED,0x00,0x08,0x42,0xB6
	.byte	0x1D,0x25,0x00,0x54,0x42,0xAD
	.byte	0x00,0x04,0x48,0x46,0x46,0xC6,0x48,0x46,0x2B,0x6E
	.byte	0x00,0x0C,0x00,0x0C,0x2D,0x4D
	.byte	0x00,0x0C,0x60,0x00,0xED,0x0C,0x70,0x32,0x60,0x00
	.byte	0xED,0x06,0x8C,0x6E,0x00,0x9E
	.byte	0xB2,0xAE,0x00,0x50,0x62,0x00,0x01,0x16,0x2A,0x76
	.byte	0x1D,0x25,0x00,0x54,0xB0,0x8D
	.byte	0x67,0x00,0x01,0x0A,0x0C,0xAD,0x00,0x00,0x00,0x01
	.byte	0x00,0x04,0x66,0x00,0x00,0xFE
	.byte	0x2F,0x03,0x46,0xC6,0x4A,0x84,0x67,0x18,0xC6,0xAD
	.byte	0x00,0x14,0xB6,0x97,0x66,0x16
	.byte	0x24,0x2D,0x00,0x14,0x48,0x46,0x46,0xC6,0x48,0x46
	.byte	0x26,0x1F,0x60,0x00,0xEC,0xC2
	.byte	0xC6,0xAD,0x00,0x14,0x66,0xEA,0x48,0x46,0x46,0xC6
	.byte	0x48,0x46,0x26,0x1F,0x28,0x6E
	.byte	0x00,0x10,0x48,0xEC,0x0F,0x3F,0x00,0x24,0x48,0xE7
	.byte	0x60,0x00,0x74,0x00,0x34,0x2C
	.byte	0x00,0x12,0x22,0x02,0xE8,0x49,0x46,0xC6,0x4A,0x6C
	.byte	0x00,0x22,0x66,0x08,0x2F,0x0D
	.byte	0x61,0x00,0xFD,0xDA,0x2A,0x5F,0x00,0x6C,0x02,0x20
	.byte	0x00,0x22,0x48,0x46,0x46,0xC6
	.byte	0x48,0x46,0x61,0x00,0xFE,0x0E,0x4C,0xDF,0x00,0x06
	.byte	0x2F,0x03,0x46,0xC6,0x4A,0x84
	.byte	0x67,0x42,0xC6,0xAD,0x00,0x14,0xB6,0x97,0x66,0x40
	.byte	0x24,0x2D,0x00,0x14,0x48,0x46
	.byte	0x46,0xC6,0x48,0x46,0x48,0xE7,0x60,0x00,0x74,0x00
	.byte	0x34,0x2C,0x00,0x12,0x22,0x02
	.byte	0xE8,0x49,0x46,0xC6,0x02,0x6C,0xFD,0xDF,0x00,0x22
	.byte	0x4A,0x6C,0x00,0x22,0x66,0x04
	.byte	0x61,0x00,0xFD,0x26,0x48,0x46,0x46,0xC6,0x48,0x46
	.byte	0x4C,0xDF,0x00,0x06,0x26,0x1F
	.byte	0x60,0x00,0xEC,0x2E,0xC6,0xAD,0x00,0x14,0x66,0xC0
	.byte	0x4B,0xED,0xFF,0xF8,0x29,0x4D
	.byte	0x00,0x14,0x29,0x6D,0x00,0x18,0x00,0x18,0x2B,0x4C
	.byte	0x00,0x18,0x2A,0x6C,0x00,0x18
	.byte	0x2B,0x4C,0x00,0x14,0x48,0x46,0x46,0xC6,0x48,0x46
	.byte	0x26,0x1F,0x08,0xEC,0x00,0x07
	.byte	0x00,0x58,0x61,0x00,0x04,0x6A,0x4A,0x82,0x67,0x08
	.byte	0x22,0x02,0x61,0x00,0x04,0x1C
	.byte	0x60,0x06,0x02,0x6C,0xFF,0xDF,0x00,0x22,0x60,0x00
	.byte	0xEB,0xE6,0x70,0x31,0x60,0x00
	.byte	0xEB,0xE0,0x8C,0x6E,0x00,0x9E,0xB2,0xAE,0x00,0x50
	.byte	0x62,0x00,0xFF,0xF0,0x2A,0x76
	.byte	0x1D,0x25,0x00,0x54,0xB0,0x8D,0x67,0x00,0xFF,0xE4
	.byte	0x0C,0xAD,0x00,0x00,0x00,0x01
	.byte	0x00,0x04,0x66,0x00,0xFF,0xD8,0x2F,0x02,0xC4,0xAD
	.byte	0x00,0x14,0x67,0x02,0x70,0x34
	.byte	0x24,0x1F,0x85,0xAD,0x00,0x14,0x4B,0xED,0xFF,0xF8
	.byte	0x46,0xC6,0x28,0x6D,0x00,0x14
	.byte	0xBB,0xCC,0x66,0x0A,0x48,0x46,0x46,0xC6,0x48,0x46
	.byte	0x60,0x00,0xEB,0x94,0x2F,0x2C
	.byte	0x00,0x14,0x3E,0x2C,0x00,0x22,0x02,0x47,0x02,0x00
	.byte	0x66,0x0C,0x48,0x46,0x46,0xC6
	.byte	0x48,0x46,0x54,0x8F,0x60,0x00,0xEB,0x7A,0x2E,0x2D
	.byte	0x00,0x1C,0x4A,0xAC,0x00,0x34
	.byte	0x66,0x08,0xCE,0xAC,0x00,0x30,0x66,0x0C,0x60,0x48
	.byte	0xCE,0xAC,0x00,0x30,0xBE,0xAC
	.byte	0x00,0x30,0x66,0x3E,0x2F,0x0D,0x61,0x00,0xFC,0x24
	.byte	0x2A,0x5F,0x29,0x6D,0x00,0x1C
	.byte	0x00,0x2C,0x48,0x46,0x46,0xC6,0x48,0x46,0x48,0xE7
	.byte	0x60,0x00,0x74,0x00,0x34,0x2C
	.byte	0x00,0x12,0x22,0x02,0xE8,0x49,0x46,0xC6,0x02,0x6C
	.byte	0xFD,0xDF,0x00,0x22,0x66,0x08
	.byte	0x2F,0x0D,0x61,0x00,0xFC,0x14,0x2A,0x5F,0x48,0x46
	.byte	0x46,0xC6,0x48,0x46,0x4C,0xDF
	.byte	0x00,0x06,0x28,0x5F,0x46,0xC6,0x60,0x00,0xFF,0x78
	.byte	0x8C,0x6E,0x00,0x9E,0xB2,0xAE
	.byte	0x00,0x50,0x62,0x00,0xFF,0x28,0x2A,0x76,0x1D,0x25
	.byte	0x00,0x54,0xB0,0x8D,0x67,0x00
	.byte	0xFF,0x1C,0x0C,0xAD,0x00,0x00,0x00,0x01,0x00,0x04
	.byte	0x66,0x00,0xFF,0x10,0x2E,0x02
	.byte	0x46,0x87,0x24,0x2D,0x00,0x14,0xCF,0xAD,0x00,0x14
	.byte	0x60,0x00,0xEA,0xE4,0x8C,0x6E
	.byte	0x00,0x9E,0xB2,0xAE,0x00,0x50,0x62,0x00,0xFE,0xF4
	.byte	0x2A,0x76,0x1D,0x25,0x00,0x54
	.byte	0xB0,0x8D,0x67,0x00,0xFE,0xE8,0x0C,0xAD,0x00,0x00
	.byte	0x00,0x01,0x00,0x04,0x66,0x00
	.byte	0xFE,0xDC,0x24,0x2D,0x00,0x14,0x60,0x00,0xEA,0xB8
	.byte	0x8C,0x6E,0x00,0x9E,0x2A,0x6E
	.byte	0x00,0x0C,0xBB,0xC0,0x67,0x2E,0x2D,0x6D,0x00,0x0C
	.byte	0x00,0x0C,0x3B,0x41,0x00,0x14
	.byte	0x2B,0x7C,0x00,0x00,0x00,0x02,0x00,0x04,0x3B,0x42
	.byte	0x00,0x16,0x49,0xED,0xFF,0xF8
	.byte	0x2B,0x4C,0x00,0x0C,0x2B,0x4C,0x00,0x10,0x22,0x15
	.byte	0x2D,0x8D,0x1D,0x25,0x00,0x54
	.byte	0x60,0x00,0xEA,0x7E,0x70,0x30,0x60,0x00,0xEA,0x78
	.byte	0x8C,0x6E,0x00,0x9E,0xB2,0xAE
	.byte	0x00,0x50,0x62,0x00,0x02,0x08,0x2A,0x76,0x1D,0x25
	.byte	0x00,0x54,0xB0,0x8D,0x67,0x00
	.byte	0x01,0xFC,0x0C,0xAD,0x00,0x00,0x00,0x02,0x00,0x04
	.byte	0x66,0x00,0x01,0xF0,0x4B,0xED
	.byte	0xFF,0xF8,0x46,0xC6,0xBB,0xED,0x00,0x14,0x67,0x4A
	.byte	0x4A,0x82,0x67,0x68,0x2F,0x0D
	.byte	0x28,0x6D,0x00,0x14,0x61,0x00,0xFB,0x06,0x48,0x46
	.byte	0x46,0xC6,0x48,0x46,0x48,0xE7
	.byte	0x60,0x00,0x74,0x00,0x34,0x2C,0x00,0x12,0x22,0x02
	.byte	0xE8,0x49,0x46,0xC6,0x02,0x6C
	.byte	0xFB,0xDF,0x00,0x22,0x4A,0x6C,0x00,0x22,0x66,0x04
	.byte	0x61,0x00,0xFA,0xFC,0x29,0x7C
	.byte	0x00,0x00,0x00,0x33,0x00,0x24,0x48,0x46,0x46,0xC6
	.byte	0x48,0x46,0x4C,0xDF,0x00,0x06
	.byte	0x2A,0x5F,0x60,0xAE,0x4B,0xED,0x00,0x08,0x42,0xB6
	.byte	0x1D,0x25,0x00,0x54,0x42,0xAD
	.byte	0x00,0x04,0x48,0x46,0x46,0xC6,0x48,0x46,0x2B,0x6E
	.byte	0x00,0x0C,0x00,0x0C,0x2D,0x4D
	.byte	0x00,0x0C,0x60,0x00,0xE9,0xDC,0x70,0x32,0x60,0x00
	.byte	0xE9,0xD6,0x8C,0x6E,0x00,0x9E
	.byte	0xB2,0xAE,0x00,0x50,0x62,0x00,0x01,0x66,0x2A,0x76
	.byte	0x1D,0x25,0x00,0x54,0xB0,0x8D
	.byte	0x67,0x00,0x01,0x5A,0x0C,0xAD,0x00,0x00,0x00,0x02
	.byte	0x00,0x04,0x66,0x00,0x01,0x4E
	.byte	0x28,0x6E,0x00,0x10,0x48,0xE7,0x60,0x00,0x74,0x00
	.byte	0x34,0x2C,0x00,0x12,0x22,0x02
	.byte	0xE8,0x49,0x46,0xC6,0x4A,0x6D,0x00,0x14,0x66,0x66
	.byte	0x4A,0x6C,0x00,0x22,0x66,0x08
	.byte	0x2F,0x0D,0x61,0x00,0xFA,0xD8,0x2A,0x5F,0x00,0x6C
	.byte	0x04,0x20,0x00,0x22,0x4B,0xED
	.byte	0xFF,0xF8,0x4A,0x6D,0x00,0x1E,0x67,0x18,0x29,0x4D
	.byte	0x00,0x14,0x29,0x6D,0x00,0x18
	.byte	0x00,0x18,0x2B,0x4C,0x00,0x18,0x2A,0x6C,0x00,0x18
	.byte	0x2B,0x4C,0x00,0x14,0x60,0x04
	.byte	0x61,0x00,0xF9,0xDA,0x48,0x46,0x46,0xC6,0x48,0x46
	.byte	0x61,0x00,0xFA,0xE6,0x4C,0xDF
	.byte	0x00,0x06,0x61,0x00,0x01,0xBA,0x4A,0x82,0x67,0x0C
	.byte	0x2F,0x01,0x22,0x02,0x61,0x00
	.byte	0x01,0x6A,0x22,0x1F,0x60,0x06,0x02,0x6C,0xFF,0xDF
	.byte	0x00,0x22,0x60,0x00,0xE9,0x32
	.byte	0x53,0x6D,0x00,0x14,0x48,0x46,0x46,0xC6,0x48,0x46
	.byte	0x4C,0xDF,0x00,0x06,0x60,0x00
	.byte	0xE9,0x20,0x8C,0x6E,0x00,0x9E,0xB2,0xAE,0x00,0x50
	.byte	0x62,0x00,0x00,0xB0,0x2A,0x76
	.byte	0x1D,0x25,0x00,0x54,0xB0,0x8D,0x67,0x00,0x00,0xA4
	.byte	0x0C,0xAD,0x00,0x00,0x00,0x02
	.byte	0x00,0x04,0x66,0x00,0x00,0x98,0x46,0xC6,0x4A,0x6D
	.byte	0x00,0x14,0x66,0x42,0x4B,0xED
	.byte	0xFF,0xF8,0xBB,0xED,0x00,0x14,0x67,0x50,0x28,0x6D
	.byte	0x00,0x14,0x61,0x00,0xF9,0xAE
	.byte	0x48,0x46,0x46,0xC6,0x48,0x46,0x48,0xE7,0x60,0x00
	.byte	0x74,0x00,0x34,0x2C,0x00,0x12
	.byte	0x22,0x02,0xE8,0x49,0x46,0xC6,0x02,0x6C,0xFB,0xDF
	.byte	0x00,0x22,0x66,0x04,0x61,0x00
	.byte	0xF9,0xA8,0x48,0x46,0x46,0xC6,0x48,0x46,0x4C,0xDF
	.byte	0x00,0x06,0x60,0x00,0xE8,0xB2
	.byte	0x52,0x6D,0x00,0x14,0x64,0x08,0x3B,0x7C,0xFF,0xFF
	.byte	0x00,0x14,0x70,0x34,0x48,0x46
	.byte	0x46,0xC6,0x48,0x46,0x60,0x00,0xE8,0x9A,0x4B,0xED
	.byte	0x00,0x08,0x60,0xE2,0x8C,0x6E
	.byte	0x00,0x9E,0xB2,0xAE,0x00,0x50,0x62,0x00,0x00,0x24
	.byte	0x2A,0x76,0x1D,0x25,0x00,0x54
	.byte	0xB0,0x8D,0x67,0x00,0x00,0x18,0x0C,0xAD,0x00,0x00
	.byte	0x00,0x02,0x00,0x04,0x66,0x00
	.byte	0x00,0x0C,0x24,0x00,0x34,0x2D,0x00,0x14,0x60,0x00
	.byte	0xE8,0x66,0x70,0x31,0x60,0x00
	.byte	0xE8,0x60,0x8C,0x6E,0x00,0x9E,0x28,0x6E,0x00,0x10
	.byte	0x4A,0x81,0x67,0x3E,0x48,0xE7
	.byte	0x60,0x00,0x74,0x00,0x34,0x2C,0x00,0x12,0x22,0x02
	.byte	0xE8,0x49,0x46,0xC6,0x4A,0x6C
	.byte	0x00,0x22,0x66,0x04,0x61,0x00,0xF9,0x86,0x00,0x6C
	.byte	0x00,0x20,0x00,0x22,0x48,0x46
	.byte	0x46,0xC6,0x48,0x46,0x61,0x00,0xF9,0xBC,0x4C,0xDF
	.byte	0x00,0x06,0x61,0x00,0x00,0x90
	.byte	0x2F,0x01,0x61,0x00,0x00,0x46,0x22,0x1F,0x60,0x00
	.byte	0xE8,0x16,0x46,0xC6,0x4A,0x6C
	.byte	0x00,0x22,0x66,0x2C,0x32,0x2C,0x00,0x12,0x2A,0x6E
	.byte	0x00,0x4C,0x2B,0xAC,0x00,0x14
	.byte	0x14,0x00,0x2A,0x6C,0x00,0x14,0x42,0x6D,0x00,0x70
	.byte	0x42,0x6C,0x00,0x70,0x72,0x00
	.byte	0xB9,0xEE,0x00,0x14,0x66,0x0A,0x2D,0x4D,0x00,0x14
	.byte	0x1D,0x7C,0x00,0x01,0x00,0x1E
	.byte	0x48,0x46,0x46,0xC6,0x48,0x46,0x60,0x00,0xE7,0xD8
	.byte	0x2F,0x01,0x2A,0x6E,0x00,0xAC
	.byte	0x2D,0x7C,0xFF,0xFF,0xFF,0xFF,0x00,0xA8,0x92,0xAD
	.byte	0x00,0x04,0x65,0x06,0x2A,0x6D
	.byte	0x00,0x08,0x60,0xF4,0xD2,0xAD,0x00,0x04,0x29,0x4D
	.byte	0x00,0x08,0x29,0x6D,0x00,0x0C
	.byte	0x00,0x0C,0x2B,0x4C,0x00,0x0C,0x2A,0x6C,0x00,0x0C
	.byte	0x2B,0x4C,0x00,0x08,0x2A,0x6C
	.byte	0x00,0x08,0x29,0x41,0x00,0x04,0x93,0xAD,0x00,0x04
	.byte	0x22,0x1F,0x4E,0x75,0xB9,0xEC
	.byte	0x00,0x08,0x67,0x24,0x2A,0x6C,0x00,0x0C,0x2B,0x6C
	.byte	0x00,0x08,0x00,0x08,0x2A,0x6C
	.byte	0x00,0x08,0x2B,0x6C,0x00,0x0C,0x00,0x0C,0x29,0x4C
	.byte	0x00,0x08,0x29,0x4C,0x00,0x0C
	.byte	0x2E,0x2C,0x00,0x04,0xDF,0xAD,0x00,0x04,0x4E,0x75
	.byte	0x8C,0x6E,0x00,0x9E,0x22,0x2E
	.byte	0x00,0xA0,0x60,0x00,0xE7,0x5C,0x8C,0x6E,0x00,0x9E
	.byte	0x2D,0x41,0x00,0xA0,0x60,0x00
	.byte	0xE7,0x50,0x8C,0x6E,0x00,0x9E,0x3D,0x41,0x00,0x1C
	.byte	0x60,0x00,0xE7,0x44,0x8C,0x6E
	.byte	0x00,0x9E,0x46,0xC6,0x52,0x6E,0x00,0xA6,0x52,0xAE
	.byte	0x00,0xA0,0x28,0x6E,0x00,0x10
	.byte	0x52,0xAC,0x00,0x6C,0x4A,0x6C,0x00,0x22,0x66,0x12
	.byte	0x48,0x46,0x46,0xC6,0x48,0x46
	.byte	0x46,0xC6,0x4A,0x6E,0x00,0x1C,0x67,0x04,0x61,0x00
	.byte	0x00,0x0C,0x48,0x46,0x46,0xC6
	.byte	0x48,0x46,0x60,0x00,0xE7,0x0C,0x2F,0x01,0x06,0x6C
	.byte	0x00,0x01,0x00,0x70,0x32,0x2E
	.byte	0x00,0x1C,0xB2,0x6C,0x00,0x70,0x62,0x2A,0x32,0x2C
	.byte	0x00,0x12,0x2A,0x6E,0x00,0x4C
	.byte	0x2B,0xAC,0x00,0x14,0x14,0x00,0x2A,0x6C,0x00,0x14
	.byte	0x42,0x6D,0x00,0x70,0x42,0x6C
	.byte	0x00,0x70,0xB9,0xEE,0x00,0x14,0x66,0x0A,0x2D,0x4D
	.byte	0x00,0x14,0x1D,0x7C,0x00,0x01
	.byte	0x00,0x1E,0x22,0x1F,0x4E,0x75,0x00,0x7C,0x07,0x00
	.byte	0x40,0xC6,0x48,0x46,0x40,0xC6
	.byte	0x00,0x6F,0x07,0x00,0x00,0x14,0x48,0xE7,0x7C,0xF0
	.byte	0x22,0x4E,0x22,0x2D,0x00,0x04
	.byte	0xE4,0x89,0x67,0x00,0x02,0xAC,0x53,0x81,0x22,0xC0
	.byte	0x53,0x81,0x6A,0xFA,0x52,0x6E
	.byte	0x00,0x18,0x52,0x6E,0x00,0x1A,0x24,0x7C,0x00,0x00
	.byte	0x01,0xB8,0xD5,0xCE,0x2D,0x4A
	.byte	0x00,0x58,0x22,0x2D,0x00,0x04,0x04,0x81,0x00,0x00
	.byte	0x01,0xB8,0x6B,0x00,0x02,0x82
	.byte	0x2D,0x41,0x00,0x5C,0x38,0x7A,0xE5,0x16,0xD9,0xCC
	.byte	0x61,0x00,0xF6,0xD0,0x66,0x00
	.byte	0x02,0x70,0x2D,0x4C,0x00,0xC4,0xD8,0xFA,0xE5,0x04
	.byte	0x2D,0x4C,0x00,0xE4,0x45,0xEE
	.byte	0x00,0xA8,0x2D,0x4A,0x00,0xBC,0x2D,0x4A,0x00,0xC0
	.byte	0x45,0xEE,0x00,0xC8,0x2D,0x4A
	.byte	0x00,0xDC,0x2D,0x4A,0x00,0xE0,0x42,0x81,0x12,0x3A
	.byte	0xE4,0xDC,0x67,0x00,0x02,0x46
	.byte	0x47,0xEE,0x00,0x28,0x61,0x00,0x02,0x48,0x66,0x00
	.byte	0x02,0x36,0x42,0x81,0x12,0x3A
	.byte	0xE4,0xC7,0x67,0x00,0x00,0x0E,0x47,0xEE,0x00,0x30
	.byte	0x61,0x00,0x02,0x32,0x66,0x00
	.byte	0x02,0x20,0x42,0x81,0x12,0x3A,0xE4,0xB2,0x67,0x00
	.byte	0x00,0x18,0x47,0xEE,0x00,0x38
	.byte	0x61,0x00,0x02,0x1C,0x66,0x00,0x02,0x0A,0x32,0x2E
	.byte	0x00,0x38,0xE5,0x49,0x3D,0x41
	.byte	0x00,0x38,0x42,0x81,0x12,0x3A,0xE4,0x93,0x67,0x00
	.byte	0x00,0x0E,0x47,0xEE,0x00,0x40
	.byte	0x61,0x00,0x01,0xFC,0x66,0x00,0x01,0xEA,0x42,0x81
	.byte	0x12,0x3A,0xE4,0x7E,0x54,0x81
	.byte	0xE5,0x89,0x28,0x41,0x61,0x00,0xF6,0x36,0x66,0x00
	.byte	0x01,0xD6,0x2D,0x4C,0x00,0x4C
	.byte	0x70,0x00,0x47,0xEE,0x01,0x18,0x29,0x0B,0x3D,0x7C
	.byte	0x37,0x00,0x00,0x9C,0x3D,0x7C
	.byte	0x27,0x00,0x00,0x9E,0x3C,0x2D,0x00,0x14,0x67,0x1E
	.byte	0x6B,0x00,0x01,0xB8,0x0C,0x46
	.byte	0x00,0x08,0x6A,0x00,0x01,0xB0,0xE1,0x4E,0x08,0xC6
	.byte	0x00,0x0D,0x3D,0x46,0x00,0x9E
	.byte	0x08,0xC6,0x00,0x0C,0x3D,0x46,0x00,0x9C,0x40,0xC6
	.byte	0x8C,0x6E,0x00,0x9E,0x48,0x46
	.byte	0x40,0xC6,0x8C,0x6E,0x00,0x9E,0x45,0xED,0x00,0x24
	.byte	0x2D,0x5A,0x00,0x88,0x2D,0x5A
	.byte	0x00,0x8C,0x2D,0x52,0x00,0x90,0x52,0x2E,0x00,0x60
	.byte	0x2D,0x6D,0x00,0x20,0x00,0x62
	.byte	0x32,0x2D,0x00,0x0A,0x67,0x00,0x01,0x6E,0x38,0x41
	.byte	0x61,0x00,0xF5,0xC0,0x66,0x00
	.byte	0x01,0x60,0xD8,0xED,0x00,0x0A,0x2D,0x4C,0x00,0x94
	.byte	0x4E,0x7B,0xC8,0x04,0x72,0x00
	.byte	0x74,0x00,0x32,0x2D,0x00,0x16,0x34,0x2D,0x00,0x08
	.byte	0xD2,0x82,0x2D,0x42,0x00,0x98
	.byte	0x34,0x2D,0x00,0x1C,0x53,0x82,0x28,0x7C,0x00,0x00
	.byte	0x00,0x80,0x61,0x00,0xF5,0x8E
	.byte	0x66,0x00,0x01,0x2E,0x29,0x6E,0x00,0x08,0x00,0x5A
	.byte	0x2D,0x4C,0x00,0x08,0x39,0x7C
	.byte	0x00,0x80,0x00,0x22,0x4A,0x81,0x67,0x0E,0x29,0x49
	.byte	0x00,0x54,0x93,0xAE,0x00,0x5C
	.byte	0x6B,0x00,0x01,0x0E,0x93,0xC1,0x51,0xCA,0xFF,0xCE
	.byte	0x2D,0x49,0x01,0x6C,0x42,0x82
	.byte	0x34,0x2D,0x00,0x10,0x66,0x04,0x34,0x3A,0xE3,0x96
	.byte	0x95,0xAE,0x00,0x5C,0x6B,0x00
	.byte	0x00,0xF0,0x93,0xFC,0x00,0x00,0x00,0x1C,0x33,0x7C
	.byte	0x00,0x80,0x00,0x1A,0x2D,0x49
	.byte	0x01,0x64,0x49,0xFA,0xF6,0xA8,0x23,0x4C,0x00,0x16
	.byte	0x33,0x7C,0x10,0x00,0x00,0x14
	.byte	0x08,0xE9,0x00,0x05,0x00,0x14,0x3D,0x7C,0x01,0x00
	.byte	0x01,0x3A,0x42,0x41,0x12,0x3A
	.byte	0xE3,0x5A,0x52,0x41,0x3D,0x41,0x01,0x2A,0x49,0xEE
	.byte	0x01,0x18,0x29,0x4C,0x00,0x14
	.byte	0x29,0x4C,0x00,0x18,0x34,0x2D,0x00,0x1C,0x53,0x82
	.byte	0x28,0x7C,0x00,0x00,0x00,0x20
	.byte	0x61,0x00,0xF4,0xFA,0x66,0x00,0x00,0x9A,0x28,0xAE
	.byte	0x00,0xF4,0x2D,0x4C,0x00,0xF4
	.byte	0x47,0xEC,0xFF,0xF8,0x29,0x4B,0x00,0x0C,0x29,0x4B
	.byte	0x00,0x10,0x51,0xCA,0xFF,0xDC
	.byte	0x74,0x00,0x34,0x2D,0x00,0x0C,0x67,0x38,0x53,0x82
	.byte	0x3D,0x42,0x00,0x52,0x28,0x7C
	.byte	0x00,0x00,0x00,0x20,0x61,0x00,0xF4,0xC6,0x66,0x00
	.byte	0x00,0x66,0x29,0x6E,0x00,0x0C
	.byte	0x00,0x0C,0x2D,0x4C,0x00,0x0C,0x28,0x82,0x51,0xCA
	.byte	0xFF,0xE4,0x34,0x2D,0x00,0x0C
	.byte	0xE5,0x8A,0x28,0x42,0x61,0x00,0xF4,0xA6,0x66,0x00
	.byte	0x00,0x46,0x2D,0x4C,0x00,0x54
	.byte	0x43,0xEE,0x01,0x18,0x2D,0x49,0x00,0x10,0x2D,0x49
	.byte	0x00,0x14,0x43,0xEE,0xFF,0xA6
	.byte	0x2C,0x89,0x2D,0x49,0x00,0x04,0x43,0xEE,0x00,0xA4
	.byte	0x2D,0x49,0x00,0xAC,0x2D,0x49
	.byte	0x00,0xB0,0x2D,0x7C,0xFF,0xFF,0xFF,0xFF,0x00,0xA8
	.byte	0x45,0xEE,0x00,0xF8,0x25,0x4A
	.byte	0x00,0x04,0x35,0x7C,0xFF,0xFF,0x00,0x08,0x4C,0xDF
	.byte	0x0F,0x3E,0x60,0x00,0xE4,0x02
	.byte	0x70,0x0F,0x60,0x02,0x70,0x11,0x4C,0xDF,0x0F,0x3E
	.byte	0x60,0x00,0xE3,0xF4,0x28,0x41
	.byte	0x53,0x41,0x36,0xC1,0x54,0x4B,0xD9,0xCC,0xD9,0xCC
	.byte	0x61,0x00,0xF4,0x40,0x66,0x04
	.byte	0x26,0x8C,0x80,0x80,0x4E,0x75,0x8C,0x6E,0x00,0x9E
	.byte	0x46,0xC6,0x28,0x6E,0x00,0x10
	.byte	0x2E,0x6C,0x00,0x4C,0x42,0x6E,0x00,0x18,0x42,0x6E
	.byte	0x00,0x1A,0x1D,0x7C,0x00,0x01
	.byte	0x00,0x1E,0x60,0x00,0xE3,0xBC
