/* clnt_simple.c - simplified front end to rpc */

static char *copyright = "Copyright 1987-1988, Wind River Systems, Inc.";

/*
 * Copyright (c) 1987 Wind River Systems, Inc.
 * Copyright (C) 1984, Sun Microsystems, Inc.
 *
 * Sun RPC is a product of Sun Microsystems, Inc. and is provided for
 * unrestricted use provided that this legend is included on all tape
 * media and as a part of the software program in whole or part.  Users
 * may copy or modify Sun RPC without charge, but are not authorized
 * to license or distribute it to anyone else except as part of a product or
 * program developed by the user.
 * 
 * SUN RPC IS PROVIDED AS IS WITH NO WARRANTIES OF ANY KIND INCLUDING THE
 * WARRANTIES OF DESIGN, MERCHANTIBILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE, OR ARISING FROM A COURSE OF DEALING, USAGE OR TRADE PRACTICE.
 * 
 * Sun RPC is provided with no support and without any obligation on the
 * part of Sun Microsystems, Inc. to assist in its use, correction,
 * modification or enhancement.
 * 
 * SUN MICROSYSTEMS, INC. SHALL HAVE NO LIABILITY WITH RESPECT TO THE
 * INFRINGEMENT OF COPYRIGHTS, TRADE SECRETS OR ANY PATENTS BY SUN RPC
 * OR ANY PART THEREOF.
 * 
 * In no event will Sun Microsystems, Inc. be liable for any lost revenue
 * or profits or other special, indirect and consequential damages, even if
 * Sun has been advised of the possibility of such damages.
 * 
 * Sun Microsystems, Inc.
 * 2550 Garcia Avenue
 * Mountain View, California  94043
 */

/*
modification history
--------------------
*/

#ifndef lint
static char sccsid[] = "@(#)clnt_simple.c 1.1 86/02/03 Copyr 1984 Sun Micro";
#endif

/* 
 * clnt_simple.c
 * Simplified front end to rpc.
 *
 */

#include "rpc.h"
#include "socket.h"
#include "utime.h"
#undef TRUE
#undef FALSE
#include "UniWorks.h"
#include "rpcGbl.h"

char *malloc();

struct moduleStatics
    {
    CLIENT *client;
    int socket;
    int oldprognum;
    int oldversnum; 
    int valid;
    char *oldhost;
    };

STATUS clnt_simpleInit (myModuleList)
    FAST MODULE_LIST *myModuleList;
    {

    /* allocate the module statics */

    myModuleList->clnt_simple = 
	 (struct moduleStatics *) malloc (sizeof (struct moduleStatics)); 

    if (myModuleList->clnt_simple == NULL)
	{
	printErr ("clnt_simpleInit: out of Memory! \n");
	return (ERROR);
	}

    bzero (myModuleList->clnt_simple, sizeof (struct moduleStatics)); 
    return (OK);
    }

callrpc(host, prognum, versnum, procnum, inproc, in, outproc, out)
	char *host;
	xdrproc_t inproc, outproc;
	char *in, *out;
{
	struct sockaddr_in server_addr;
	enum clnt_stat clnt_stat;
	int hp;
	struct timeval timeout, tottimeout;
	FAST struct moduleStatics *ms = taskModuleList->clnt_simple;

	if (ms->oldhost == NULL) {
		ms->oldhost = malloc(256);
		ms->oldhost[0] = 0;
		ms->socket = RPC_ANYSOCK;
	}
	if (ms->valid && ms->oldprognum == prognum && ms->oldversnum == versnum
		&& strcmp(ms->oldhost, host) == 0) {
		/* reuse old client */		
	}
	else {
		ms->valid = 0;
		close(ms->socket);
		ms->socket = RPC_ANYSOCK;
		if (ms->client) {
			clnt_destroy(ms->client);
			ms->client = NULL;
		}
/* XXX		if ((hp = gethostbyname(host)) == NULL) */
		if ((hp = remGetHostByName (host)) == ERROR) 
			return ((int) RPC_UNKNOWNHOST);
		timeout.tv_usec = 0;
		timeout.tv_sec = 5;
/* XXX		bcopy(hp->h_addr, &server_addr.sin_addr, hp->h_length); */
		server_addr.sin_addr.s_addr = hp;
		server_addr.sin_family = AF_INET;
		server_addr.sin_port =  0;
		if ((ms->client = clntudp_create(&server_addr, prognum,
		    versnum, timeout, &ms->socket)) == NULL)
			return ((int) taskModuleList->rpc_createerr.cf_stat);
		ms->valid = 1;
		ms->oldprognum = prognum;
		ms->oldversnum = versnum;
		strcpy(ms->oldhost, host);
	}
	tottimeout.tv_sec = 25;
	tottimeout.tv_usec = 0;
	clnt_stat = clnt_call(ms->client, procnum, inproc, in,
	    outproc, out, tottimeout);
	/* 
	 * if call failed, empty cache
	 */
	if (clnt_stat != RPC_SUCCESS)
		ms->valid = 0;
	return ((int) clnt_stat);
}
