/* excALib.s - assembly language exception handling stubs */

	.data
	.asciz	"Copyright 1984, Wind River Systems, Inc."

/*
modification history
--------------------
*/

/*
DESCRIPTION
This module contains the assembly language exception handling stub.
It is connected directly to the 680x0 exception vectors.
It simply sets up an appropriate environment and then calls a routine
in excLib.

There are no user-callable routines in this module.
*/

#define ASMLANGUAGE
#include "UniWorks.h"

	/* internal */

#if (CPU==MC68000)
	.globl	_excBsrTbl	/* BSR table */
#else
	.globl	_excStub	/* generic stub routine */
#endif
	.globl	_excIntStub	/* uninitialized interrupt handler */

	/* external */

	.globl	_excIntHandle	/* interrupt processing routine */
	.globl	_excExcHandle	/* exception processing routine */
	.globl	_intEnt		/* interrupt entry routine */
        .globl  _intExit	/* interrupt exit routine */

	.text
	.even

#if (CPU==MC68000)
/**************************************************************************
*
* excBsrTbl - table of BSRs
*
* NOMANUAL
*/

_excBsrTbl:
	bsr	_excIntStub	/* 0 */ /* reset sp */
	bsr	_excIntStub	/* reset pc */
	bsr	_excStub
	bsr	_excStub
	bsr	_excStub
	bsr	_excStub
	bsr	_excStub
	bsr	_excStub
	bsr	_excStub
	bsr	_excStub
	bsr	_excStub
	bsr	_excStub
	bsr	_excStub
	bsr	_excStub
	bsr	_excStub
	bsr	_excIntStub	/* uninitialized interrupt */
	bsr	_excIntStub	/* 10 */ /* unassigned reserved */
	bsr	_excIntStub 	/* unassigned reserved */
	bsr	_excIntStub 	/* unassigned reserved */
	bsr	_excIntStub 	/* unassigned reserved */
	bsr	_excIntStub 	/* unassigned reserved */
	bsr	_excIntStub 	/* unassigned reserved */
	bsr	_excIntStub 	/* unassigned reserved */
	bsr	_excIntStub 	/* unassigned reserved */
	bsr	_excIntStub	/* spurious interrupt */
	bsr	_excIntStub	/* level 1 Auto Vec */
	bsr	_excIntStub	/* level 2 Auto Vec */
	bsr	_excIntStub	/* level 3 Auto Vec */
	bsr	_excIntStub	/* level 4 Auto Vec */
	bsr	_excIntStub	/* level 5 Auto Vec */
	bsr	_excIntStub	/* level 6 Auto Vec */
	bsr	_excIntStub	/* level 7 Auto Vec */
	bsr	_excStub	/* 20 */
	bsr	_excStub
	bsr	_excStub
	bsr	_excStub
	bsr	_excStub
	bsr	_excStub
	bsr	_excStub
	bsr	_excStub
	bsr	_excStub
	bsr	_excStub
	bsr	_excStub
	bsr	_excStub
	bsr	_excStub
	bsr	_excStub
	bsr	_excStub
	bsr	_excStub
	bsr	_excStub	/* 30 */
	bsr	_excStub
	bsr	_excStub
	bsr	_excStub
	bsr	_excStub
	bsr	_excStub
	bsr	_excStub
	bsr	_excStub
	bsr	_excStub
	bsr	_excStub
	bsr	_excStub
	bsr	_excStub
	bsr	_excStub
	bsr	_excStub
	bsr	_excStub
	bsr	_excStub
	bsr	_excIntStub	/* 40 */ /* User Interrupts */
	bsr	_excIntStub
	bsr	_excIntStub
	bsr	_excIntStub
	bsr	_excIntStub
	bsr	_excIntStub
	bsr	_excIntStub
	bsr	_excIntStub
	bsr	_excIntStub
	bsr	_excIntStub
	bsr	_excIntStub
	bsr	_excIntStub
	bsr	_excIntStub
	bsr	_excIntStub
	bsr	_excIntStub
	bsr	_excIntStub
	bsr	_excIntStub	/* 50 */
	bsr	_excIntStub
	bsr	_excIntStub
	bsr	_excIntStub
	bsr	_excIntStub
	bsr	_excIntStub
	bsr	_excIntStub
	bsr	_excIntStub
	bsr	_excIntStub
	bsr	_excIntStub
	bsr	_excIntStub
	bsr	_excIntStub
	bsr	_excIntStub
	bsr	_excIntStub
	bsr	_excIntStub
	bsr	_excIntStub
	bsr	_excIntStub	/* 60 */
	bsr	_excIntStub
	bsr	_excIntStub
	bsr	_excIntStub
	bsr	_excIntStub
	bsr	_excIntStub
	bsr	_excIntStub
	bsr	_excIntStub
	bsr	_excIntStub
	bsr	_excIntStub
	bsr	_excIntStub
	bsr	_excIntStub
	bsr	_excIntStub
	bsr	_excIntStub
	bsr	_excIntStub
	bsr	_excIntStub
	bsr	_excIntStub	/* 70 */
	bsr	_excIntStub
	bsr	_excIntStub
	bsr	_excIntStub
	bsr	_excIntStub
	bsr	_excIntStub
	bsr	_excIntStub
	bsr	_excIntStub
	bsr	_excIntStub
	bsr	_excIntStub
	bsr	_excIntStub
	bsr	_excIntStub
	bsr	_excIntStub
	bsr	_excIntStub
	bsr	_excIntStub
	bsr	_excIntStub
	bsr	_excIntStub	/* 80 */
	bsr	_excIntStub
	bsr	_excIntStub
	bsr	_excIntStub
	bsr	_excIntStub
	bsr	_excIntStub
	bsr	_excIntStub
	bsr	_excIntStub
	bsr	_excIntStub
	bsr	_excIntStub
	bsr	_excIntStub
	bsr	_excIntStub
	bsr	_excIntStub
	bsr	_excIntStub
	bsr	_excIntStub
	bsr	_excIntStub
	bsr	_excIntStub	/* 90 */
	bsr	_excIntStub
	bsr	_excIntStub
	bsr	_excIntStub
	bsr	_excIntStub
	bsr	_excIntStub
	bsr	_excIntStub
	bsr	_excIntStub
	bsr	_excIntStub
	bsr	_excIntStub
	bsr	_excIntStub
	bsr	_excIntStub
	bsr	_excIntStub
	bsr	_excIntStub
	bsr	_excIntStub
	bsr	_excIntStub
	bsr	_excIntStub	/* a0 */
	bsr	_excIntStub
	bsr	_excIntStub
	bsr	_excIntStub
	bsr	_excIntStub
	bsr	_excIntStub
	bsr	_excIntStub
	bsr	_excIntStub
	bsr	_excIntStub
	bsr	_excIntStub
	bsr	_excIntStub
	bsr	_excIntStub
	bsr	_excIntStub
	bsr	_excIntStub
	bsr	_excIntStub
	bsr	_excIntStub
	bsr	_excIntStub	/* b0 */
	bsr	_excIntStub
	bsr	_excIntStub
	bsr	_excIntStub
	bsr	_excIntStub
	bsr	_excIntStub
	bsr	_excIntStub
	bsr	_excIntStub
	bsr	_excIntStub
	bsr	_excIntStub
	bsr	_excIntStub
	bsr	_excIntStub
	bsr	_excIntStub
	bsr	_excIntStub
	bsr	_excIntStub
	bsr	_excIntStub
	bsr	_excIntStub	/* c0 */
	bsr	_excIntStub
	bsr	_excIntStub
	bsr	_excIntStub
	bsr	_excIntStub
	bsr	_excIntStub
	bsr	_excIntStub
	bsr	_excIntStub
	bsr	_excIntStub
	bsr	_excIntStub
	bsr	_excIntStub
	bsr	_excIntStub
	bsr	_excIntStub
	bsr	_excIntStub
	bsr	_excIntStub
	bsr	_excIntStub
	bsr	_excIntStub	/* d0 */
	bsr	_excIntStub
	bsr	_excIntStub
	bsr	_excIntStub
	bsr	_excIntStub
	bsr	_excIntStub
	bsr	_excIntStub
	bsr	_excIntStub
	bsr	_excIntStub
	bsr	_excIntStub
	bsr	_excIntStub
	bsr	_excIntStub
	bsr	_excIntStub
	bsr	_excIntStub
	bsr	_excIntStub
	bsr	_excIntStub
	bsr	_excIntStub	/* e0 */
	bsr	_excIntStub
	bsr	_excIntStub
	bsr	_excIntStub
	bsr	_excIntStub
	bsr	_excIntStub
	bsr	_excIntStub
	bsr	_excIntStub
	bsr	_excIntStub
	bsr	_excIntStub
	bsr	_excIntStub
	bsr	_excIntStub
	bsr	_excIntStub
	bsr	_excIntStub
	bsr	_excIntStub
	bsr	_excIntStub
	bsr	_excIntStub	/* f0 */
	bsr	_excIntStub
	bsr	_excIntStub
	bsr	_excIntStub
	bsr	_excIntStub
	bsr	_excIntStub
	bsr	_excIntStub
	bsr	_excIntStub
	bsr	_excIntStub
	bsr	_excIntStub
	bsr	_excIntStub
	bsr	_excIntStub
	bsr	_excIntStub
	bsr	_excIntStub
	bsr	_excIntStub
	bsr	_excIntStub
#endif

/*********************************************************************
*
* excStub - exception handler
*
* NOMANUAL
*/

_excStub:
	moveml	d0-d7/a0-a7,a7@-	/* save remaining regs */
	movel	a7,a5			/* save pointer to regs */

#if (CPU==MC68000)
	/* compute vector offset from return address to BSR in table */

	movel	a7@(0x40),d0		/* get BSR return adrs */
	subql	#4,d0			/* adjust return adrs to be BSR adrs */
	subl	#_excBsrTbl,d0		/* get offset from start of BSR table
					 * (= vector offset) */
	lsrw	#2,d0			/* turn vector offset into excep num */
#else
	/* get vector offset from esf */

	clrl	d0			/* clear d0 */
	movew	a7@(0x46),d0		/* get the vector offset from the esf */
	andw	#0x0fff,d0		/* clear the format */
	lsrw	#2,d0			/* turn vector offset into excep num */
#endif


	/* call exception handling routine */
	movel	a5,a7@-			/* push pointer to regs */
#if (CPU==MC68000)
	pea	a5@(0x44)		/* push pointer to esf */
#else
	pea	a5@(0x40)		/* push pointer to esf */
#endif
	movel	d0,a7@-			/* push exception number */
	jsr	_excExcHandle		/* do exception processing */

/* We only come back here if we are retrying the instruction.  Such is the case
* in a vme bus deadlock cycle, where the local CPU initiates a TAS instuction
* (or RMW cycle) at the same time it's dual port arbiter grants the local bus
* to an external access.  The cpu backs off by signaling a bus error and
* setting the RM bit in the special status word of the bus error exception
* frame.  The solution is simply to retry the instruction hoping that the
* external access has been resolved.  Even if a card such as a disk controller
* has grabed the bus for DMA accesses for a long time, the worst that will
* happen is we'll end up back here again, and we can keep trying until we get
* through. */

	movel	a5,a7			/* get pointer to regs */
	moveml	a7@+,d0-d7/a0-a7	/* restore regs */
	rte				/* retry the instruction */

/*********************************************************************
*
* excIntStub - uninitialized interrupt handler
*
* NOMANUAL
*/

_excIntStub:
	movel	d0,a7@-			/* push d0 */
	jsr	_intEnt			/* enter interrupt level */
	moveml	d1-d7/a0-a7,a7@-	/* save remaining regs */

#if (CPU==MC68000)
	/* compute vector offset from return address to BSR in table */

	movel	a7@(0x40),d0		/* get BSR return adrs */
	subql	#4,d0			/* adjust return adrs to be BSR adrs */
	subl	#_excBsrTbl,d0		/* get offset from start of BSR table
					 * (= vector offset) */
	lsrw	#2,d0			/* turn vector offset into excep num */
#else
	/* get vector offset from esf */

	clrl	d0			/* clear d0 */
	movew	a7@(0x46),d0		/* get the vector offset from the esf */
	andw	#0x0fff,d0		/* clear the format */
	lsrw	#2,d0			/* turn vector offset into excep num */
#endif

#if (CPU==MC68000)
	pea	a7@(0x44)		/* push pointer to esf */
#else
	pea	a7@(0x40)		/* push pointer to esf */
#endif
	movel	d0,a7@-			/* push exception number */
	jsr	_excIntHandle		/* do exception processing */
	addql	#8,a7			/* get rid of ptr to esf */
	moveml	a7@+,d1-d7/a0-a7	/* restore regs */

#if (CPU==MC68000)
/* yank the branch table return address off'n the stack */
	movel	a7@+,d0
	addl	#4,a7
	movel	d0,a7@-
#endif

	jmp	_intExit		/* UI_EXIT expects d0 on the stack */
