/* stdioLib.h - standard I/O library header file */

/*
modification history
--------------------
01a,28mar88,gae  created.
*/

#ifndef	INCstdioLibh
#define	INCstdioLibh

#define	BUFSIZE	1024	/* default buffer size for stdio package */

/* HIDDEN */

typedef	struct	/* FILE */
    {
    int count;		/* number of characters in buffer */
    char *ptr;		/* current position in buffer */
    char *base;		/* start of buffer */
    int bufsize;	/* size of buffer */
    short flag;		/* [un,line]buffered/eof/error/read-write/string/my */
    int fd;		/* underlying file descriptor */
    int taskId;		/* id of task that created this entity */
    } FILE;

/* flag values */

#define	_STDIO_READ	0x01
#define	_STDIO_WRT	0x02
#define	_STDIO_NBF	0x04
#define	_STDIO_MYBUF	0x08
#define	_STDIO_EOF	0x10
#define	_STDIO_ERR	0x20
#define	_STDIO_STRG	0x40
#define	_STDIO_LBF	0x80
#define	_STDIO_RW	0x100

/* END_HIDDEN */

#ifndef	LINT

#define	getc(fp)	(--(fp)->count >= 0 ? \
			    (int)(*(unsigned char *)(fp)->ptr++) : \
			    stdioFillBuf (fp))

#define putc(x, fp)	(--(fp)->count >= 0 ?\
	(int)(*(unsigned char *)(fp)->ptr++ = (x)) :\
	(((fp)->flag & _STDIO_LBF) && -(fp)->count < (fp)->bufsize ?\
		((*(fp)->ptr = (x)) != '\n' ?\
			(int)(*(unsigned char *)(fp)->ptr++) :\
			stdioFlushBuf(*(unsigned char *)(fp)->ptr, fp)) :\
		stdioFlushBuf((unsigned char)(x), fp)))

#else

IMPORT int putc ();
IMPORT int getc ();

#endif LINT

#define	getchar()	getc(stdin)
#define	putchar(x)	putc(x,stdout)
#define	feof(fp)	(((fp)->flag & _STDIO_EOF) != 0)
#define	ferror(fp)	(((fp)->flag & _STDIO_ERR) != 0)
#define	fileno(fp)	((fp)->fd)
#define	clearerr(fp)	((fp)->flag &= ~(_STDIO_ERR|_STDIO_EOF))

IMPORT FILE *stdin;	/* standard input task variable */
IMPORT FILE *stdout;	/* standard output task variable */
IMPORT FILE *stderr;	/* standard error task variable */

IMPORT FILE *fopen ();
IMPORT FILE *fdopen ();
IMPORT FILE *freopen ();
IMPORT long ftell ();
IMPORT char *fgets ();
IMPORT char *gets ();
IMPORT char *sprintf ();

#endif	INCstdioLibh
