/* in_pcb.h - internet protocol control block header file */

/*
 * Copyright (c) 1987 Wind River Systems, Inc.
 * Copyright (c) 1982, 1986 Regents of the University of California.
 * All rights reserved.  The Berkeley software License Agreement
 * and the VxWorks Software License Agreement specify the terms and
 * conditions for redistribution.
 *
 *	@(#)in_pcb.h	7.1 (Berkeley) 6/5/86
 */

/*
modification history
--------------------
02b,04nov87,dnw  removed unnecessary KERNEL conditionals.
02a,03apr87,ecs  added header and copyright.
*/

#ifndef INCin_pcbh
#define INCin_pcbh

/*
 * Common structure pcb for internet protocol implementation.
 * Here are stored pointers to local and foreign host table
 * entries, local and foreign socket numbers, and pointers
 * up (to a socket structure) and down (to a protocol-specific)
 * control block.
 */
struct inpcb
    {
    struct	inpcb *inp_next;	/* pointers to other pcb's */
    struct	inpcb *inp_prev;
    struct	inpcb *inp_head;	/* pointer back to chain of inpcb's
					   for this protocol */
    struct	in_addr inp_faddr;	/* foreign host table entry */
    u_short	inp_fport;		/* foreign port */
    struct	in_addr inp_laddr;	/* local host table entry */
    u_short	inp_lport;		/* local port */
    struct	socket *inp_socket;	/* back pointer to socket */
    caddr_t	inp_ppcb;		/* pointer to per-protocol pcb */
    struct	route inp_route;	/* placeholder for routing entry */
    struct	mbuf *inp_options;	/* IP options */
    };

#define	INPLOOKUP_WILDCARD	1
#define	INPLOOKUP_SETLOCAL	2

#define	sotoinpcb(so)	((struct inpcb *)(so)->so_pcb)

struct	inpcb *in_pcblookup();

#endif
