/* af.h - address family header file */

/*
 * Copyright (c) 1987 Wind River Systems, Inc.
 * Copyright (c) 1980, 1986 Regents of the University of California.
 * All rights reserved.  The Berkeley software License Agreement
 * and the VxWorks Software License Agreement specify the terms and
 * conditions for redistribution.
 *
 *	@(#)af.h	7.1 (Berkeley) 6/4/86
 */


/*
modification history
--------------------
01c,03apr87,ecs  added header and copyright.
01b,22dec86,dnw  added IMPORT to declaration of afswitch to satisfy
		   Intermetrics assembler.
*/

/*
 * Address family routines,
 * used in handling generic sockaddr structures.
 *
 * Hash routine is called
 *	af_hash(addr, h);
 *	struct sockaddr *addr; struct afhash *h;
 * producing an afhash structure for addr.
 *
 * Netmatch routine is called
 *	af_netmatch(addr1, addr2);
 * where addr1 and addr2 are sockaddr *.  Returns 1 if network
 * values match, 0 otherwise.
 */
struct afswitch {
	int	(*af_hash)();
	int	(*af_netmatch)();
};

struct afhash {
	u_int	afh_hosthash;
	u_int	afh_nethash;
};

IMPORT struct afswitch afswitch[];
