/* client.c - client task for simple client/server network demo */

static char *copyright = "Copyright 1986-1988, Wind River Systems, Inc.";

/*
modification history
--------------------
*/

/*
DESCRIPTION
This is a simple demonstration of the server-client relationship.
This is the client. The other half of the demonstration is in server.c

EXAMPLE
On the UNIX host "wrs":
    % server

On the UniWorks target:
    -> ld < client.o
    -> client "wrs"

When you type characters into UniWorks, they will be echoed by the server
on UNIX.  Type control-D to terminate.
*/

#include "UniWorks.h"
#include "socket.h"
#include "in.h"
#include "serverDemo.h"

IMPORT char sysBootHost [];	/* UniWorks saves name of host booted from */

/* make 'clientSock' a global variable so that if something goes wrong 
 * when the client runs on UniWorks, the socket can be closed.
 */
int clientSock;		/* socket opened to server */


/*******************************************************************************
*
* client - client task
*
* This is a simple client program which connects to the server
* via a socket.  It reads characters from standard input and sends 
* them onto the server through the socket.  It stops when it reads 
* 0 characters (receives an EOF).
*
* The server runs on UNIX, client runs on UniWorks.
*
* RETURNS: OK or ERROR
*/

STATUS client (hostName)
    char *hostName; /* name of host running server, 0=boot host */

    {
    struct sockaddr_in	serverAddr;	/* server's address */
    struct sockaddr_in	clientAddr;	/* client's address */
    int		nBytes;			/* number of bytes read from stdin */
    char	c;

    if (hostName == NULL)
	hostName = sysBootHost;
	
    /* Zero out the sock_addr structures.
     * This MUST be done before the socket call.
     */

    bzero (&serverAddr, sizeof (serverAddr));
    bzero (&clientAddr, sizeof (clientAddr));

    /* Open the socket.
     * Use ARPA Internet address format and stream sockets.
     * Format described in "socket.h".
     */

    clientSock = socket (AF_INET, SOCK_STREAM, 0);

    if (clientSock == ERROR)
	return (ERROR);

    serverAddr.sin_family = AF_INET;
    serverAddr.sin_port   = SERVER_NUM;	
    
    /* get server's Internet address */
    
    if ((serverAddr.sin_addr.s_addr = inet_addr (hostName)) == ERROR &&
	(serverAddr.sin_addr.s_addr = hostGetByName (hostName)) == ERROR)
	{
	printf ("Invalid host: \"%s\"\n", hostName);
	printErrno (errnoGet ());
	close (clientSock);
	return (ERROR);
	}

    printf ("Server's address is %x:\n", serverAddr.sin_addr.s_addr);

    if (connect (clientSock, (SOCKADDR *)&serverAddr, sizeof (serverAddr)) ==
									ERROR)
	{
	printf ("Connect failed:\n");
	printErrno (errnoGet ());
	close (clientSock);
	return (ERROR);
	}

    printf ("Connected...\n");

    /* repeatedly read from standard input and send to socket until EOF */

    while (TRUE)
	{
	/* read a character from standard input */

	if ((nBytes = read (STD_IN, &c, 1)) == 0)	
	    {
	    /* client read an EOF; exit the loop. */
	    break;
	    }
	else if (nBytes != 1)
	    {
	    printf ("CLIENT read error, %d bytes read\n", nBytes);
	    printErrno (errnoGet ());
	    break;
	    }

	/* send byte to server */

	if (send (clientSock, &c, 1, 0) != 1)
	    {
	    printf ("CLIENT write error:\n");
	    printErrno (errnoGet ());
	    }
	}

    /* close socket from the UniWorks side */

    close (clientSock);

    printf ("\n...goodbye\n");
    return (OK);
    }
