/* configVrtx.c - UniWorks/VRTX system configuration */

/*
modification history
--------------------
*/

#include "UniWorks.h"
#include "config.h"

IMPORT VOID vxTcreateHook ();	/* task creation extension */
IMPORT VOID vxTswitchHook ();	/* task switch extension */

/* globals */

#define WORKSPACE_SIZE	10000	/* # of bytes for kernel workspace */

/*
 * 2748 + ISR_STACK_SIZE + MAX_TASKS * 160 + 128 + X
 */
char vrtxWorkspace[WORKSPACE_SIZE];

#if ((CPU == MC68020) || (CPU == MC68030))	/* use VRTX/32 for MC68020 */
#include "vrtx32.h"

/*******************************************************************************
*
* VRTX/32 configuration table
*/

VRTX_CONFIG_TABLE usrCftbl =
    {
    (char *) vrtxWorkspace,	/* VRTX/32 workspace address */
    WORKSPACE_SIZE,		/* VRTX/32 workspace size */
    0,				/* system-mode task VRTX/32 stack size */
    ISR_STACK_SIZE,		/* ISR stack size */
    0,				/* control block count */
    0,				/* blank1 */
    0,				/* blank2 */
    INT_LOCK_LEVEL,		/* VRTX/32 disable mask */
    0,				/* user-mode task VRTX/32 stack size */
    0,				/* blank3 */
    MAX_TASKS,			/* user task count (max tasks) */
    0,				/* blank4 */
    (FUNCPTR) 0,		/* no TXRDY driver */
    vxTcreateHook,		/* system task create routine */
    (FUNCPTR) 0,		/* no delete routine */
    vxTswitchHook,  		/* system task switch routine */
    (char *) 0			/* no component vector table */
    };

#else (CPU != MC68020)		/* use VRTX/680X0 for MC68010/MC68000 */
#include "vrtx.h"

/*******************************************************************************
*
* VRTX configuration table
*/


VRTX_CONFIG_TABLE usrCftbl =
    {
    (char *) vrtxWorkspace,	/* VRTX workspace address */
    WORKSPACE_SIZE,		/* VRTX workspace size */
    0,				/* system-mode task VRTX stack size */
    0,				/* ISR stack size */
    0,				/* blank1 */
    0,				/* blank2 */
    INT_LOCK_LEVEL,		/* VRTX disable mask */
    0,				/* user-mode task VRTX stack size */
    0,				/* blank3 */
    MAX_TASKS,			/* user task count (max tasks) */
    0,				/* blank4 */
    (FUNCPTR) 0,		/* TXRDY driver address */
    vxTcreateHook,		/* system task create routine */
    (FUNCPTR) 0,		/* no delete routine */
    vxTswitchHook,  		/* system task switch routine */
    (char *) 0			/* CVT address */
    };
#endif (CPU)
