{**  DEC/CMS REPLACEMENT HISTORY, Element ZTRAVERSE.SRC **}
{**  *1    10-OCT-1986 08:59:38 PALASM2 "" **}
{**  DEC/CMS REPLACEMENT HISTORY, Element ZTRAVERSE.SRC **}
(*                                                                   *)
(*  (c) copyright Monolithic Memories, Inc. , 1986		     *)
(*                                                                   *)
(*  RJS 27/JAN/86 *)
{vax %include 'pal2$inc:z24global.inc'	vax}
{vax module ztraverse (INPUT,OUTPUT); vax}


#include 'csopeninc.i'
#include 'ctre.i'
#include 'ctxtio.i'
#include 'fnxinc.i'
#include 'z24.i'


{ipp program ztraverse ; ipp}
{ipp pragma On(Externals_allowed_internally); ipp}
{ipp pragma C_include('ctre.inc'); ipp}
{ipp pragma C_include('ctxtio.inc'); ipp}
{ipp pragma C_include('fnxinc.inc'); ipp}
{ipp pragma C_include('z24.inc'); ipp}
(*-------------------------------------------------------------------*)
(*                                                                   *)
(*  Module    : ZTraverse                                            *)
(*  AUTHOR    : Chie-Jiun Chien                                      *)
(*  DATE      : 12/11/85                                             *)
(*  FUNCTION  : Routines in this module are related to traversing    *)
(*              the PALASM tree and getting the terms from the tree  *)
(*                                                                   *)
(*  MODIFICATIONS :                                                  *)
(*    NAME        DATE       DESCRIPTION                             *)
(*    ----------- ---------- ------------------------------------    *)
(*    C.J.       12/11/85   Initial release                          *)
(*    M.Gzowski   1/17/86    Debug fixes			     *)
(*    M.Gzowski   1/30/86    Debug fixes			     *)
(*    M.Gzowski   2/25/86    Debug fixes			     *)
(*                                                                   *)
(*                                                                   *)
(*  COMMENTS  :                                                      *)
(*                                                                   *)
(*  NOTES     :                                                      *)
(*                                                                   *)
(*                                                                   *)
(*  GLOBAL DECLARATIONS :                                            *)
(*                                                                   *)
(*  Const                                                            *)
(*  Type                                                             *)
(*  TreLink = ^TreNode;                                              *)
(*  TreNode = record                                                 *)
(*              Tre_kind : integer;                                  *)
(*              Tre_up   : TreLink;                                  *)
(*              Tre_down : TreLink;                                  *)
(*              Tre_right: TreLink;                                  *)
(*              Tre_left : TreLink;                                  *)
(*              Tre_value: integer;                                  *)
(*                                                                   *)
(*  EquationType = (SETF_Eq,RSTF_Eq,TRST_Eq,CLKF_Eq);                *)
(*                                                                   *)
(*  LvlRng = MinAssocLevels..MaxAssocLevels                          *)
(*                                                                   *)
(*  Var                                                              *)
(*                                                                   *)
(*  EXTERNAL DECLARATIONS                                            *)
(*                                                                   *)
(*  The following routines are declared in this module external to   *)
(*  all other modules                                                *)
(*  SetTreNode                        EquationPin                    *)
(*  GetTreNode                                                       *)
(*                                                                   *)
(*  The following routines are declared only for this module use     *)
(*                                                                   *)
(*  Free                              Clear                          *)
(*  RetireTre_ForDevicePin            Push                           *)
(*  Pop                               Empty                          *)
(*  CheckKind                         Top                            *)
(*-------------------------------------------------------------------*)
(**)
(*1111111111111111111111111111111111111111111111111111111111111111111*)
(*                                                                   *)
(*  Procedure : Free                                                 *)
(*  AUTHOR    : Chie-Jiun Chien                                      *)
(*  DATE      : 12/11/85                                             *)
(*  FUNCTION  : This function clear the whole stack                  *)
(*                                                                   *)
(*  MODIFICATIONS :                                                  *)
(*    NAME        DATE       DESCRIPTION                             *)
(*    ----------- ---------- ------------------------------------    *)
(*    C.J.       12/11/85   Initial release                          *)
(*    M.Gzowski   1/17/86    Debug fixes			     *)
(*                                                                   *)
(*                                                                   *)
(*  COMMENTS  :                                                      *)
(*                                                                   *)
(*  Input Parameters:                                                *)
(*  ---------------------------------------------------------------- *)
(*  Variable     Type        Description                             *)
(*  StkPtr       stack                                               *)
(*1111111111111111111111111111111111111111111111111111111111111111111*)
(* MEG 1/17/86 *)
    (* leave here for future use *)

(**)
(*1111111111111111111111111111111111111111111111111111111111111111111*)
(*                                                                   *)
(*  Procedure : Clear                                                *)
(*  AUTHOR    : Chie-Jiun Chien                                      *)
(*  DATE      : 12/11/85                                             *)
(*  FUNCTION  : This function clear the whole stack                  *)
(*                                                                   *)
(*  MODIFICATIONS :                                                  *)
(*    NAME        DATE       DESCRIPTION                             *)
(*    ----------- ---------- ------------------------------------    *)
(*    C.J.       12/11/85   Initial release                          *)
(*    M.Gzowski   1/17/86    Debug fixes			     *)
(*    M.Gzowski   1/30/86    Debug fixes			     *)
(*                                                                   *)
(*                                                                   *)
(*  COMMENTS  :                                                      *)
(*                                                                   *)
(*  Input Parameters:                                                *)
(*  ---------------------------------------------------------------- *)
(*  Variable      type       Description                             *) 
(*  StkPtr        stack                                              *)
(*1111111111111111111111111111111111111111111111111111111111111111111*)
(* MEG 1/17/86 *)
procedure clear(var stkptr : stack);
var count : intXx4;

begin  (* begin clear *)
      stkptr.reduce := 0;

(* clean all the stack contents *)
      for count := stackstart to stackend do
       begin
         stkptr.stackstruct[count].op := noop;
         stkptr.stackstruct[count].pntr := nil;
        end;
      stkptr.stckindex := stackstart;  
end;    (* end clear *)
(**)

(**)
(*1111111111111111111111111111111111111111111111111111111111111111111*)
(*                                                                   *)
(*  Procedure : ClearReduction					     *)
(*  AUTHOR    : Mike Gzowski					     *)
(*  DATE      : 1/31/86						     *)
(*  FUNCTION  : This procedure clears the reduction count for 	     *)
(*		the given stack					     *)
(*                                                                   *)
(*  MODIFICATIONS :                                                  *)
(*    NAME        DATE       DESCRIPTION                             *)
(*    ----------- ---------- ------------------------------------    *)
(*                                                                   *)
(*  COMMENTS  :                                                      *)
(*                                                                   *)
(*  Input Parameters:                                                *)
(*  Variable      Type       Description                             *) 
(*  ------------- ---------- --------------------------------------- *)
(*  StkPtr        stack                                              *)
(*1111111111111111111111111111111111111111111111111111111111111111111*)
(* MEG 1/17/86 *)
procedure clearreduction (var stkptr : stack);

  begin  (* ClearReduction *)
      stkptr.reduce := 0;
  end;   (* ClearReduction *)

(**)
(*1111111111111111111111111111111111111111111111111111111111111111111*)
(*                                                                   *)
(*  Procedure : RetireTre_ForDevicePin				     *)
(*  AUTHOR    : Chie-Jiun Chien                                      *)
(*  DATE      : 12/11/85                                             *)
(*  FUNCTION  : This function retires the whole tree, free those     *)
(*              TreeNode back to the link list                       *)
(*                                                                   *)
(*  MODIFICATIONS :                                                  *)
(*    NAME        DATE       DESCRIPTION                             *)
(*    ----------- ---------- ------------------------------------    *)
(*    C.J.        12/11/85   Initial release                         *)
(*    M. Gzowski  1/19/86    Debug rewrite			     *)
(*                                                                   *)
(*  INPUT PARAMETERS:                                                *)
(*  VARIABLE      TYPE       DESCRIPTION                             *)
(*  ------------- ---------- ------------------------------------    *)
(*  DEVICEPIN     INT_X4     the device pin to retire		     *)
(*1111111111111111111111111111111111111111111111111111111111111111111*)
(* MEG 1/19/86 *)
{vax [global]   vax}
 procedure retiretreXfordevicepin ;  
  var 
	equationtree : trelink;
	count : intXx4;

(**)
  (*22222222222222222222222222222222222222222222222222222222222222222*)
  (*								     *)
  (*  Procedure : RetireEq					     *)
  (*  AUTHOR    : M. Gzowski					     *)
  (*  DATE      : 1/19/86					     *)
  (*  FUNCTION  : this procedure retires a tre (via RetireTre 	     *)
  (*		  routine), given any link in the tre.		     *)
  (*								     *)
  (*  MODIFICATIONS :						     *)
  (*    NAME        DATE       DESCRIPTION			     *)
  (*    ----------- ---------- ----------------------------------    *)
  (*								     *)
  (*  INPUT PARAMETERS:						     *)
  (*  VARIABLE      TYPE       DESCRIPTION			     *)
  (*  ------------- ---------- ---------------------------------     *)
  (*  Eq	    TreLink    A link in the tre to be retired.	     *)
  (*22222222222222222222222222222222222222222222222222222222222222222*)
  procedure retireeq (var eq : trelink );
    begin

    (* only retire a tre that exists *)
      if eq <> nil
        then begin

    (* find the tre top *)
	  while eq^.treXup <> nil
            do eq := eq^.treXup;
          retiretre (eq);
	 end; (*if...then*)
    end; (*RetireEq*)


(**)
(*1111111111111111111111111111111111111111111111111111111111111111111*)
  begin  (*RetireTre_ForDevicePin*)
    retireeq (devpins[ devicepin ].tristate);
    retireeq (devpins[ devicepin ].equatn);
  end;   (*RetireTre_ForDevicePin*)

(**)       
(*1111111111111111111111111111111111111111111111111111111111111111111*)
(*                                                                   *)
(*  PROCEDURE : SetTRENode                                           *)
(*  AUTHOR    : C.J.                                                 *)
(*  DATE      : 12/20/85                                             *)
(*  FUNCTION  : This function initializes the internal and global    *)
(*              structures and variables used by GetTREnode          *)
(*                                                                   *)
(*  MODIFICATIONS :                                                  *)
(*    NAME        DATE       DESCRIPTION                             *)
(*    ----------- ---------- ------------------------------------    *)
(*   C.J.          12/20     initial release                         *)  
(*    M.Gzowski   1/17/86    Debug fixes			     *)
(*                                                                   *)
(*  COMMENTS  :                                                      *)
(*                                                                   *)
(*  INPUT PARAMETERS :                                               *)
(*                                                                   *)
(*    VARIABLE    TYPE       DESCRIPTION                             *)
(*    ----------- ---------- ------------------------------------    *)
(*    DevicePin   int_x4                                             *)
(*    Traversal   TraverseRec                                        *)
(*    EqType      EquationType the type of node to set up.	     *)
(*                                                                   *)
(*1111111111111111111111111111111111111111111111111111111111111111111*)
(* MEG 1/17/86 *)
{vax    [global]    vax}
 procedure settrenode;  

begin  (*  begin of SetTreNode *)

(* get the tree node from DevPins and set those to initial values *)
      with traversal do
      begin
      if eqtype in [pinXeq,trstXeq] then begin  
           case eqtype of
             pinXeq:
                 nextdown := devpins[devicepin].equatn;
             trstXeq:
                 nextdown := devpins[devicepin].tristate;
            end;
        end else nextdown := nil;  
           clear(rightstack);
           clear(opstack);
           currentop := noop;
           currentvalue := 0;
      end;
end;  (* end of SetTreNode *)
(**)
(*1111111111111111111111111111111111111111111111111111111111111111111*)
(*                                                                   *)
(*  Function  : EquationPin                                          *)
(*  AUTHOR    : Chie-Jiun Chien                                      *)
(*  DATE      : 12/11/85                                             *)
(*  FUNCTION  : This function returns the Device Pin for a given     *)
(*              equation, along with other data describing that      *)
(*              which is (logically) to the left of the equation     *)
(*              equivalence, and a pointer to the portion of the     *)
(*              equation that is to the (logical) right of the       *)
(*              equation equivalence symbol                          *)
(*                                                                   *)
(*  MODIFICATIONS :                                                  *)
(*    NAME        DATE       DESCRIPTION                             *)
(*    ----------- ---------- ------------------------------------    *)
(*    C.J.        12/11/85   Initial release                         *)
(*    M.Gzowski   1/17/86    Debug fixes			     *)
(*                                                                   *)
(*                                                                   *)
(*  COMMENTS  :                                                      *)
(*                                                                   *)
(*  Input Parameters:                                                 *)
(*  EquationPtr -  The link to the equation in question              *)
(*  Registered  -  This boolean flag is true if the passed equation  *)
(*                 is registered                                     *)
(*  Complemented-  This boolean flag is true if the passed equaion   *)
(*                 is complemented                                   *)
(*  EqClassification- This is used to determin how the equation      *)
(*                    relates to the Device Pin                      *)
(*  TermPtr - This is the pointer to the term to the (logical) right *)
(*            of the equation equivalence symbol                     *)
(*                                                                   *)
(*1111111111111111111111111111111111111111111111111111111111111111111*)
(* MEG 1/17/86 *)
{vax   [Global] vax}
 function equationpin;  

begin (* begin EquationPin *)
 (* Initialization *)
      eqclassification := pinXeq;  
      complemented := false;
      termptr := nil;

 (* get equation head *)
  if equationptr^.treXkind in [tkXclkeq,tkXasseq] then begin  
      case equationptr^.treXkind of
         tkXclkeq: registered := true;
         tkXasseq: registered := false;
      end;  (* case...of *)
  end else zglobalerr(tregetwrongtrenode,dummyvalue);  


 (* get information from left of equation *)
      while equationptr^.treXdown <> nil do
      begin  (* begin while loop *)
            if equationptr^.treXdown^.treXright <> nil 
               then termptr := equationptr^.treXdown^.treXright;
            equationptr := equationptr^.treXdown;
       if equationptr^.treXkind in [tkXnot,tkXset,tkXreset,  
                                    tkXtrst,tkXclk,tkXid] then begin  
            case equationptr^.treXkind of
                tkXnot : complemented := true;         
                tkXset : eqclassification := setfXeq;
                tkXreset:eqclassification := rstfXeq;
                tkXtrst :eqclassification := trstXeq;
                tkXclk  :eqclassification := clkfXeq;
                tkXid   :equationpin := equationptr^.treXvalue;
            end; (* end of case *)
        end else zglobalerr(treilleagletokeninlefteqn,dummyvalue);  
      end;  (* end of whole loop *)
end;
(**)
(*1111111111111111111111111111111111111111111111111111111111111111111*)
(*                                                                   *)
(*  Function  : Push                                                 *)
(*  AUTHOR    : Chie-Jiun Chien                                      *)
(*  DATE      : 12/11/85                                             *)
(*  FUNCTION  : This function push a item into stack                 *)
(*                                                                   *)
(*  MODIFICATIONS :                                                  *)
(*    NAME        DATE       DESCRIPTION                             *)
(*    ----------- ---------- ------------------------------------    *)
(*    C.J.       12/11/85   Initial release                          *)
(*    M.Gzowski   1/17/86    Debug fixes			     *)
(*    M.Gzowski   1/30/86    Debug fixes			     *)
(*                                                                   *)
(*                                                                   *)
(*  COMMENTS  :                                                      *)
(*                                                                   *)
(*  Notes     : The stack and item can be defined by the passed      *)
(*              parameter                                            *)
(*  Input Parameter:                                                 *)
(*  StackPtr : The desired stack name                                *)
(*  Item     : the desired content to be pushed into the stack       *)
(*                                                                   *)
(*1111111111111111111111111111111111111111111111111111111111111111111*)
(* MEG 1/17/86 *)
procedure push( var stackptr : stack;
 		    item     : stacktype);

begin (* begin of push *)

 (* set reduce to be 0 and push one content into stack  *)
      stackptr.stackstruct[stackptr.stckindex] := item;   
      stackptr.stckindex := succ(stackptr.stckindex);
 (* MEG 1/31/86 *)
 (* do not change reduction state 			*)
 (*   StackPtr.reduce := 0;				*)
end; (* end of push *)
(**)
(*1111111111111111111111111111111111111111111111111111111111111111111*)
(*                                                                   *)
(*  Function  : Pop                                                  *)
(*  AUTHOR    : Chie-Jiun Chien                                      *)
(*  DATE      : 12/11/85                                             *)
(*  FUNCTION  : This function pops an item from stack                *)
(*                                                                   *)
(*  MODIFICATIONS :                                                  *)
(*    NAME        DATE       DESCRIPTION                             *)
(*    ----------- ---------- ------------------------------------    *)
(*    C.J.       12/11/85   Initial release                          *)
(*    M.Gzowski   1/17/86    Debug fixes			     *)
(*    M.Gzowski   1/30/86    Debug fixes			     *)
(*                                                                   *)
(*                                                                   *)
(*  COMMENTS  :                                                      *)
(*                                                                   *)
(*  Notes     : The stack and item can be defined by the passed      *)
(*              parameter                                            *)
(*  Input Parameter:                                                 *)
(*  Variable     Type        Description                             *)
(*  ------------ ----------- -------------------------------------   *)
(*  StackPtr     Stack       The desired stack to be used            *)
(*1111111111111111111111111111111111111111111111111111111111111111111*)
(* MEG 1/17/86 *)
{vax [global] vax}
function pop(var stackptr:stack) : stacktype;   
begin (* begin pop *)

(* MEG 1/31/86 *)
  if stackptr.stckindex > 0
   then begin
     stackptr.stckindex := pred(stackptr.stckindex);
     stackptr.reduce := pred(stackptr.reduce);
     pop := stackptr.stackstruct[stackptr.stckindex];
    end
   else
     zglobalerr(trestackempty,dummyvalue);

end;  (* end pop *)

(**)
(*1111111111111111111111111111111111111111111111111111111111111111111*)
(*								     *)
(*  PROCEDURE : TOP						     *)
(*  AUTHOR    : C.J. 						     *)
(*  DATE      : 12/27/85 					     *)
(*  FUNCTION  : get the top element in a given stack		     *)
(*								     *)
(*								     *)
(*  MODIFICATIONS :     					     *)
(*    NAME        DATE       DESCRIPTION			     *)
(*    ----------- ---------- ------------------------------------    *)  
(*    M.Gzowski   12/20/85   Initial release			     *)
(*    M.Gzowski   1/17/86    procedure made local		     *)
(*    M.Gzowski   1/31/86    procedure move to from ZCOMPRESS module *)
(*								     *)
(*  COMMENTS  :  a term may be built only after the OpStack has      *)
(*		     been reduce.  This signifies that the last term *)
(*		     has been completed.  However, a reduction	     *)
(*		     on an AND op means that the term is still	     *)
(*		     being built.				     *)
(*								     *)
(*  INPUT PARAMETERS :						     *)
(*    VARIABLE    TYPE       DESCRIPTION			     *)
(*    ----------- ---------- ------------------------------------    *)
(*     STACKPTR   STACK      a stack				     *)
(*								     *)
(*1111111111111111111111111111111111111111111111111111111111111111111*)
{vax [global] vax}
 function top;  
  begin (*TOP*)

         
(* MEG 1/31/86 *)
    if stackptr.stckindex > 0
     then top := stackptr.stackstruct[ pred(stackptr.stckindex) ]
     else zglobalerr(trestackempty,dummyvalue);
   end; (*TOP*)

(**)
(*1111111111111111111111111111111111111111111111111111111111111111111*)
(*                                                                   *)
(*  Function  : Empty                                                *)
(*  AUTHOR    : Chie-Jiun Chien                                      *)
(*  DATE      : 12/11/85                                             *)
(*  FUNCTION  : Get A Node From the Tree                             *)
(*                                                                   *)
(*  MODIFICATIONS :                                                  *)
(*    NAME        DATE       DESCRIPTION                             *)
(*    ----------- ---------- ------------------------------------    *)
(*    C.J.       12/11/85   Initial release                          *)
(*    M.Gzowski   1/17/86    Debug fixes			     *)
(*                                                                   *)
(*                                                                   *)
(*  COMMENTS  :                                                      *)
(*                                                                   *)
(*  GLOBALS   :                                                      *)
(*  Type                                                             *)
(*      TreverseNode = Record                                        *)    
(*                     code : TreLink;                               *)
(*                     op   : EqOp;                                  *)
(*                     End;                                          *)
(*  Var                                                              *)
(*      NextDown : TraverseNode;                                     *)
(*              CurrentOp                                            *)
(*              OpStack                                              *)
(*                                                                   *)
(*  INPUT PARAMETERS:                                                *)
(*  --------------------------------------------------------------   *)
(*  VARIABLE      TYPE                DESCRIPTION                    *)
(*  STACKPTR      STACK                                              *)
(*1111111111111111111111111111111111111111111111111111111111111111111*)
(* MEG 1/17/86 *)
{vax   [Global]  vax}
 function empty;  
begin (* begin empty routine *)
      if stackptr.stckindex = 0
       then 
            empty := true
       else
            empty := false;
end;  (* end empty routine *)
(**)
(*1111111111111111111111111111111111111111111111111111111111111111111*)
(*                                                                   *)
(*  Function  : CheckKind                                            *)
(*  AUTHOR    : Chie-Jiun Chien                                      *)
(*  DATE      : 12/11/85                                             *)
(*  FUNCTION  : Check Tree kind and trasform it into EqOp type       *)
(*                                                                   *)
(*  MODIFICATIONS :                                                  *)
(*    NAME        DATE       DESCRIPTION                             *)
(*    ----------- ---------- ------------------------------------    *)
(*    C.J.       12/11/85   Initial release                          *)
(*    M. Gzowski 2/25/86     added more token types		     *)
(*                                                                   *)
(*                                                                   *)
(*  COMMENTS  :                                                      *)
(*                                                                   *)
(*  GLOBALS   :                                                      *)
(*                                                                   *)
(*  Input Parameters:                                                *)
(*  Variable      Type        Description                            *)
(*  -------------------------------------------------------------    *)
(*  Kind          int_x4      Token kind                             *)  
(*                                                                   *)
(*1111111111111111111111111111111111111111111111111111111111111111111*)
function checkkind(kind : intXx4): eqop;

begin

(* MEG 2/25/86 *)
      if kind in [tkXid,tkXxor,tkXor,tkXand,  
                  tkXxnor,tkXvcc,tkXgnd] then begin  
           case kind of

(* first check all the boolean operator types *)
             tkXid :  checkkind := idop;
             tkXxor:  checkkind := xorop;
             tkXor :  checkkind := orop;
             tkXand:  checkkind := andop;
             tkXxnor: checkkind := xnorop;
(*           tk_Nor:  CheckKind := NorOp;       *)
(*           tk_nand: CheckKind := NandOp;      *)

(* next check for other tokens *)
             tkXvcc:  checkkind := vccop;
             tkXgnd:  checkkind := gndop;

(* the passed token is incorrect *)
           end;
       end else zglobalerr(trekindoutofrange,dummyvalue);  
end;   (* end checkkind *)
(**)
(*1111111111111111111111111111111111111111111111111111111111111111111*)
(*                                                                   *)
(*  Function  : GetTreNode                                           *)
(*  AUTHOR    : Chie-Jiun Chien                                      *)
(*  DATE      : 12/11/85                                             *)
(*  FUNCTION  : Get A Node From the Tree                             *)
(*                                                                   *)
(*  MODIFICATIONS :                                                  *)
(*    NAME        DATE       DESCRIPTION                             *)
(*    ----------- ---------- ------------------------------------    *)
(*    C.J.       12/11/85   Initial release                          *)
(*    M.Gzowski   1/17/86    Debug fixes			     *)
(*                                                                   *)
(*                                                                   *)
(*  COMMENTS  :                                                      *)
(*                                                                   *)
(*  GLOBALS   :                                                      *)
(*                                                                   *)
(*1111111111111111111111111111111111111111111111111111111111111111111*)
(* MEG 1/17/86 *)
{vax   [Global]   vax}
 procedure gettrenode;  

var  next,temp,tempnext : stacktype;
     
begin
     with traversal do 
     begin                       (* with... do   *)
     clearreduction (opstack);
     clearreduction (rightstack);
(* save the current operation   *)
     if currentop <> noop 
      then begin
           temp.op := currentop;
           temp.pntr := nextdown;
           push(opstack,temp);
           end; 
(* Check the tree node, check down first *)
(* initial value has been set in SetTRENode *)
(* MEG 2/5/86 *)
     if nextdown <> nil
      then next.pntr := nextdown

(* MEG 1/31/86 *)
(* there is nothing below us in the tree...  *)
(*  ...otherwise check the right shifts      *)
      else if not empty (rightstack)
       then begin
         next := pop(rightstack);
(* -----------> reduce  OpStack <----------- *)
         repeat
           if empty(opstack)
             then zglobalerr(trestackempty,dummyvalue)
             else temp := pop(opstack);
          until (next.op = temp.op);           
        end  (* else if...then -- begin---end *)

(* there is nothing below and to the right... *)
(*  ...therefore we must be done!             *)
(* MEG 2/5/86 *)
(* Assignment a current operator and fully reduce OpStack *)
       else begin
         currentop := doneop;
         while not empty(opstack)
           do temp := pop(opstack);
         next.pntr := nil;
        end;

(* if we are not done, then get the next node  *)
       if next.pntr <> nil
        then begin

(* if the next node is NOT, get the (negative of the) node being complemented *)
           if next.pntr^.treXkind = tkXnot
            then begin
              currentop := checkkind(next.pntr^.treXdown^.treXkind);
              currentvalue := -next.pntr^.treXdown^.treXvalue;
             end
            else begin
              currentop := checkkind(next.pntr^.treXkind);
              currentvalue := next.pntr^.treXvalue;
             end;

(* get the next next node *)
           with next.pntr^ do
            begin

(* check for NOT *)
                 if currentvalue < 0
                 then 
                     if treXdown^.treXdown <> nil
                      then 
                          zglobalerr(trefailgettrenode,dummyvalue)
                      else
                          nextdown := nil
                 else                          
                     nextdown := treXdown;

(* MEG 1/30/86 *)
(* Save the current operator for right shifts...                   *)
(* ... then check for right shifts.  Clapse all associative terms. *)
                 tempnext.op := currentop;
                 if treXright <> nil
                  then 
                      begin
                  if treXright^.treXkind in [tkXand,tkXor, 
                                             tkXxor,tkXxnor] then begin 
                      case treXright^.treXkind of
(* C.J. 12/23 *)
                       tkXand,tkXor,tkXxor,tkXxnor:
                       if treXright^.treXkind = treXup^.treXkind
                        then     
                            tempnext.pntr := treXright^.treXdown
                        else 
                           tempnext.pntr := treXright;
                      end;  
                  end else tempnext.pntr := treXright;  
                      push(rightstack,tempnext);
                      end (* if __ then __ *)
             end  (* with ... do  *)
       end; (* if ... then ... *)
       end; (* with .. do .. begin *)
end;
    
{vax End. vax}
