{**  DEC/CMS REPLACEMENT HISTORY, Element ZPROPHYSICAL.SRC **}
{**  *1    10-OCT-1986 08:59:33 PALASM2 "" **}
{**  DEC/CMS REPLACEMENT HISTORY, Element ZPROPHYSICAL.SRC **}
(**)
(*-------------------------------------------------------------------*)
(*                                                                   *)
(*  MODULE    : Process_Physical_Map                                 *)
(*  AUTHOR    : Chie-Jiun Chien                                      *)
(*  DATE      : 1/7/86                                               *)
(*  FUNCTION  : Routines needed to control the flow and access the   *)
(*              data used in processing the physical map             *)
(*                                                                   *)
(*  MODIFICATIONS :                                                  *)
(*    NAME        DATE       DESCRIPTION                             *)
(*    ----------- ---------- ------------------------------------    *)
(*    C.J.        1/7/85     Initial release                         *)
(*    M.Gzowski   9/16/86    added OffTemplate flag, corrected 	     *)
(*			     comments in Get_Physical_ViaRecord	     *)
(*                                                                   *)
(*                                                                   *)
(*  COMMENTS  :                                                      *)
(*                                                                   *)
(*  NOTES     :                                                      *)
(*                                                                   *)
(*  EXTERNAL DECLARATIONS :                                          *)
(*                                                                   *)
(*  GLOBAL DECLARATIONS :                                            *)
(*                                                                   *)
(*-------------------------------------------------------------------*)
{vax  %include 'pal2$inc:z24global.inc'  vax}
{vax  module zprophysical;               vax}


#include 'csopeninc.i'
#include 'ctre.i'
#include 'ctxtio.i'
#include 'fnxinc.i'
#include 'z24.i'


(**)
(*-------------------------------------------------------------------*)
(*                                                                   *)
(*  PROCEDURE : Make_Physical_Map                                    *)
(*  AUTHOR    : CJ                                                   *)
(*  DATE      : 1/7/86                                               *)
(*  FUNCTION  : This routine sets up and makes the calls for the     *)
(*              physical Mapping and graphical data file creation    *)
(*              The user is qureied for type output of output file   *)
(*              desired                                              *)
(*                                                                   *)
(*  MODIFICATIONS :                                                  *)
(*    NAME        DATE       DESCRIPTION                             *)
(*    ----------- ---------- ------------------------------------    *)  
(*    CJ          1/7/86                                             *)
(*  COMMENTS  :                                                      *)
(*                                                                   *)
(*  INPUT PARAMETERS :                                               *)
(*                                                                   *)
(*    VARIABLE         TYPE       DESCRIPTION                        *)
(*    -----------      ---------- -------------------------------    *)
(*    PhysicalfilNam   ZHALFilNam                                    *)
(*    GraphicalFilNam  ZhalFilNam                                    *)
(*-------------------------------------------------------------------*)
{vax  [Global]  vax}
procedure makeXphysicalXmap;

begin(*Make_physical_map *)

(*     Write_PhysMap_File;   later                 *)
(*     Write_Graphic_File;   later                 *)

end; (* Make_physical_map*)



(**)
(*1111111111111111111111111111111111111111111111111111111111111111111*)
(*                                                                   *)
(*  PROCEDURE : Initialize_Physical_Mapping                          *)
(*  AUTHOR    : CJ                                                   *)
(*  DATE      : 1/7/86                                               *)
(*  FUNCTION  : Initializes the variables used in reading the Log_   *)
(*              Phys_Via_Directives                                  *)
(*                                                                   *)
(*  MODIFICATIONS :                                                  *)
(*    NAME        DATE       DESCRIPTION                             *)
(*    ----------- ---------- ------------------------------------    *)  
(*    CJ          1/7/86                                             *)
(*  COMMENTS  :                                                      *)
(*                                                                   *)
(*  INPUT PARAMETERS :                                               *)
(*                                                                   *)
(*    VARIABLE    TYPE       DESCRIPTION                             *)
(*    ----------- ---------- ------------------------------------    *)
(*                                                                   *)
(*1111111111111111111111111111111111111111111111111111111111111111111*)
{vax   [Global]   vax}
procedure initializeXphysicalXmapping;

begin (*Initialize_Physical_Mapping *)
       viapointer := logphysmap;
       
end;  (*Intialize_Physical_Mapping *)

(**)
(*-------------------------------------------------------------------*)
(*                                                                   *)
(*  FUNCTION  : CheckLogVia                                          *)
(*  AUTHOR    : CJ                                                   *)
(*  DATE      : 1/7/86                                               *)
(*                                                                   *)
(*  MODIFICATIONS :                                                  *)
(*    NAME        DATE       DESCRIPTION                             *)
(*    ----------- ---------- ------------------------------------    *)  
(*    CJ          1/7/86                                             *)
(*  COMMENTS  :                                                      *)
(*                                                                   *)
(*  GLOBAL DECLARATIONS:                                             *)
(*          ViaPointer : int_X4                                      *)
(*          EndSection = -1000                                       *)
(*  INPUT PARAMETERS :                                               *)
(*                                                                   *)
(*    VARIABLE    TYPE       DESCRIPTION                             *)
(*    ----------- ---------- ------------------------------------    *)
(*                                                                   *)
function checklogvia(viacontent : intXx4) : boolean;
var status : intXx4;
    flag   : intXx4;

begin (* CheckLogVia *)

(* Check if the corresponding physical vias is when the logical vias connect *)
(* or not connect. If ViaContent is postive, it means the via is connected,  *)
(* vice versa                                                                *)
      if  viacontent >= standardno
        then
            begin
            status := examinelocation(viacontent,flag);
            if (flag >= standardno) and ( flag < vln)
              then
                  checklogvia := false
              else
                  checklogvia := true
             end
        else
            begin
            status := examinelocation(abs(viacontent),flag);
            if (flag >= standardno) and (flag < vln)
              then
                   checklogvia := true
              else
                   checklogvia := false
            end
end;

(**)
(*-------------------------------------------------------------------*)
(*                                                                   *)
(*  FUNCTION  : CheckArrayColumn                                     *)
(*  AUTHOR    : CJ                                                   *)
(*  DATE      : 2/11/86                                               *)
(*                                                                   *)
(*  MODIFICATIONS :                                                  *)
(*    NAME        DATE       DESCRIPTION                             *)
(*    ----------- ---------- ------------------------------------    *)  
(*    CJ          2/11/86                                            *)
(*  COMMENTS  :                                                      *)
(*                                                                   *)
(*  GLOBAL DECLARATIONS:                                             *)
(*          ViaPointer : int_X4                                      *)
(*          EndSection = -1000                                       *)
(*  INPUT PARAMETERS :                                               *)
(*                                                                   *)
(*    VARIABLE    TYPE       DESCRIPTION                             *)
(*    ----------- ---------- ------------------------------------    *)
(*                                                                   *)
function checkarraycolumn(viacontent : intXx4) : boolean;
var status : intXx4;
    flag   : intXx4;

begin (* CheckArrayColumn *)

(* Check if the desired logical via is connected or not *)

      if  viacontent <> arraynotconnect
        then
             checkarraycolumn := true
        else
             checkarraycolumn := false
end;
(**)
(*-------------------------------------------------------------------*)
(*                                                                   *)
(*  FUNCTION  : GetPhysicalVias                                      *)
(*  AUTHOR    : CJ                                                   *)
(*  DATE      : 1/7/86                                               *)
(*  FUNCTION  : Search for the starting address of the list of       *)
(*              physical vias                                        *)
(*                                                                   *)
(*  MODIFICATIONS :                                                  *)
(*    NAME        DATE       DESCRIPTION                             *)
(*    ----------- ---------- ------------------------------------    *)  
(*    CJ          1/7/86                                             *)
(*    CB          3/14/86    Modified to take into account default   *)
(*                           condition in the array. VCC tie-up.     *)
(*  COMMENTS  :                                                      *)
(*                                                                   *)
(*  GLOBAL DECLARATIONS:                                             *)
(*          ViaPointer : int_X4                                      *)
(*          EndSection = -1000                                       *)
(*  INPUT PARAMETERS :                                               *)
(*                                                                   *)
(*    VARIABLE    TYPE       DESCRIPTION                             *)
(*    ----------- ---------- ------------------------------------    *)
(*   Vpointer     int_x4      starting address for physical via      *)
(*   RecordSpec   SpecRecordType  this record includes viacount,     *)
(*                                pin number and specification       *)
(*                                                                   *)

function getphysicalvias(var vpointer : intXx4; 
                         var recordspec:specrecordtype):boolean;

var logicviacount : intXx4;
    status      : intXx4;
    content     : intXx4;
    logviacount : intXx4;
    count       : intXx4;
    connect     : boolean;
    tempaddress : intXx4;
begin  (* GetPhysicalVias *)
      connect := false;
      status := examinelocation(vpointer,logicviacount);
      vpointer := succ(vpointer);
      status := examinelocation(vpointer,content);
      recordspec.viacount := content div physvialen;
      count := 0;
      recordspec.logptr := vpointer + 1;
(* This repeat loop is to check if all the logical vias been flaged or not *)
      repeat
       count := succ(count);
       vpointer := succ(vpointer);
       status := examinelocation(vpointer,content);
(* This case statement checks the specification record *)
 if recordspec.spec in [viaspec,array1spec,array2spec] then begin  
       case recordspec.spec of
          viaspec : connect := checklogvia(content);
          array1spec,array2spec: begin
                                 tempaddress := content;
                                 status      := examinelocation(tempaddress,content);
(* CB 3/14 *)
                                 connect     := true;
                                 end;
       end;
       end;  
      until (count = logicviacount) or (not connect);


      if not connect
        then
            begin
             getphysicalvias := false;
	     vpointer := recordspec.logptr + logicviacount + 
                         recordspec.viacount*physvialen;
            end
        else
             begin
             getphysicalvias := true;
             vpointer := succ(vpointer);
             end;
end;
(**)
(*-------------------------------------------------------------------*)
(*                                                                   *)
(*  FUNCTION  : Get_Physical_ViaRecord                               *)
(*  AUTHOR    : CJ                                                   *)
(*  DATE      : 1/7/86                                               *)
(*  FUNCTION  : This function returns the index to a record contain- *)
(*              ing a list of physical vias that are used for the    *)
(*              design. The list is determined by relationships      *)
(*              stated in the Log_Phys_Via_Directories, therefore    *)
(*              the vias in the list have a similar function. Each   *)
(*              subsequent call to this function returns the next    *)
(*              list of vias used.                                   *)
(*                                                                   *)
(*  MODIFICATIONS :                                                  *)
(*    NAME        DATE       DESCRIPTION                             *)
(*    ----------- ---------- ------------------------------------    *)  
(*    CJ          1/7/86                                             *)
(*    M.Gzowski   9/16/86    added OffTemplate flag, corrected 	     *)
(*			     comments				     *)
(*  COMMENTS  :                                                      *)
(*                                                                   *)
(*  GLOBAL DECLARATIONS:                                             *)
(*          ViaPointer : int_X4                                      *)
(*          EndSection = -1000                                       *)
(*          Array1Spec = -503                                        *)
(*          ViaSpec    = -504                                        *)
(*          Array2Spec = -505                                        *)
(*	    TempViaBegin = -506					     *)
(*	    TempViaEnd = -507					     *)
(*  SpecRecordType = record                                          *)
(*                   pinno : int_x4;                                 *)
(*                   viacount : int_x4;                              *)
(*                   spec     : int_X4;                              *)
(*                   physptr  : int_x4;                              *)
(*                   LogPtr   : int_x4;                              *)
(*  INPUT PARAMETERS :                                               *)
(*                                                                   *)
(*    VARIABLE    TYPE       DESCRIPTION                             *)
(*    ----------- ---------- ------------------------------------    *)
(*                                                                   *)
(*    RecordSpec  SpecRecordType				     *)
(*			     return record for via data		     *)
(*    OffTemplate boolean    on entry contains the current state of  *)
(*			     the Off template via flag, modified by  *)
(*			     directives in Log_Phys section of PDF   *)

{vax   [global]  vax}
(* MEG 9/16/86 *)
 procedure getXphysicalXviarecord;  

var
    content : intXx4;
    status  : intXx4;
    done    : boolean;
    vpointer: intXx4;
    
begin (* get_physical_viarecord *)
     done := false;
     if recordspec.physptr = standardno
        then 
(* Use local variable instead *)
             vpointer := viapointer
        else
             vpointer := recordspec.physptr + recordspec.viacount* 2;

(* This repeat loop is to check the physical via map and get the address *)
(* for physical vias                                                     *)

     repeat

       status := examinelocation(vpointer,content);
       if status = normal
         then

(* MEG 9/16/86 *)
(* If the Content in physical via map is less than 0, then it could be an end *)
(* section flag, a via specification, array specification, via on(off) 	      *)
(* template directive, or a pin number					      *)
(* If the content is positive, then it could be a via count or via numbers    *)
             if content < standardno
      	       then
                   begin

(* MEG 9/16/86 *)
(* This case statement is to check if the Via Map Content a end section flag, *)
(* a Via Specification, Array Specification , via on(off) template directive, *)
(* or a pin number       					              *)
                  if content in [endsection,viaspec,array1spec,  
                                 array2spec,tempviabegin,tempviaend] then begin  
                        case content of
	                 endsection : recordspec.spec := endsection;
	                 viaspec    : recordspec.spec := viaspec;
	                 array1spec : recordspec.spec := array1spec;
                         array2spec : recordspec.spec := array2spec;
(* MEG 9/16/86 *)
(* template vias begin, off template via flag cleared *)
                         tempviabegin :
                                      offtemplate := false;
(* template vias end, off template via flag set *)
                         tempviaend :
                                      offtemplate := true;
                        end;
	                end else begin 
                                   recordspec.pinno := abs(content);
                                   recordspec.spec  := viaspec;
                                   end;  
	                vpointer := succ(vpointer);
	           end
	       else
       	            done := getphysicalvias(vpointer,recordspec)
          else
              begin
              zglobalerror := true;
              zglobalerr(ioerrgetphysicalviarecord,dummyvalue);
              end;
               
       until (done or (content = endsection)) or zglobalerror;

       if done
         then
             begin
               recordspec.physptr := vpointer;
               viapointer := vpointer + recordspec.viacount * physvialen;
             end;
end;
         

(**)
(*-------------------------------------------------------------------*)
(*                                                                   *)
(*  PROCEDURE : Get_ViaRecord_Via                                    *)
(*  AUTHOR    : CJ                                                   *)
(*  DATE      : 1/7/86                                               *)
(*  FUNCTION  : This procedure returns a via specification for the   *)
(*              given ViaRecord and offset within the Via List.      *)
(*              Combined with the pin number of the ViaRecord, this  *)
(*              gives a unique specification for each via in the     *)
(*              device. for example if the index and offset specified*)
(*              via v4e, the via number prefix is 4 and the postfix  *)
(*              is 5.                                                *)
(*                                                                   *)
(*  MODIFICATIONS :                                                  *)
(*    NAME        DATE       DESCRIPTION                             *)
(*    ----------- ---------- ------------------------------------    *)  
(*    CJ          1/7/86     initial release                         *)
(*    CJ          2/11/86    modification                            *)
(*    CB          3/14/86    Modified to allow for default VCC       *)
(*                           tie-up in the array.                    *)
(*    IT          8/21/86    Modified column number bug		     *)
(*  COMMENTS  :                                                      *)
(*                                                                   *)
(*  INPUT PARAMETERS :                                               *)
(*                                                                   *)
(*    VARIABLE    TYPE       DESCRIPTION                             *)
(*    ----------- ---------- ------------------------------------    *)
(*    RecordSpec  SpecRecordType                                     *)
(*                           physical vias                           *)
(*    Offset      int_x4     the offset of the list to a desired     *)
(*                           via record                              *)
(*    PhysRecord  PhysRecType a return record having fields of prefix*)
(*                            and postfix1 and postfix2              *)
(*    Return Value: normal return code or NoMoreVia                  *)
(*                                                                   *)
{vax  [global]  vax}
 function getXviarecordXvia;  
var 
    viaaddress : intXx4;
    status     : intXx4;
    content    : intXx4;
    vpointer   : intXx4;
    startaddress : intXx4;
begin  (* Get_ViaRecord_Via *)

(* check if offset is out of vias *)
     if offset > recordspec.viacount
       then
            getXviarecordXvia := nomorevia
       else              
(* check the via specification and classify the type of vias *)
    if recordspec.spec in [array1spec,array2spec,viaspec,endsection] then begin  
        case recordspec.spec of
         array1spec:
                    begin
                     startaddress := recordspec.physptr + (offset - 1) * 2; 
                     startaddress := succ(startaddress); 
                     status := examinelocation(startaddress,content);
                     physrecord.prefix := content;
                     status := examinelocation(recordspec.logptr,content);
                     status := examinelocation(content,content);
(* CB 3/13 *)
(* IT 8/21 *)
                     if checkarraycolumn(content) 
                       then physrecord.postfix:= content 
                     else   physrecord.postfix:= maxcolno;
(* CB 3/13 *)
                     end;

         array2spec:begin
                     status := examinelocation(recordspec.logptr,offset);
(* check the offset to a desired via *)
                     if offset  > vln
                       then
                            offset := offset - ( vln + 1)
                       else
                           if offset < - vln
                             then
                                  offset := -(vln + offset + 1);
                     vpointer := recordspec.physptr + (offset - 1) * physvialen;
                     status := examinelocation(vpointer,content);
                     vpointer := succ(vpointer);
                     status := examinelocation(vpointer,content);
                     physrecord.postfix := content;
                    end;
         viaspec   :begin
                     startaddress := recordspec.physptr + (offset - 1) * 2;
                     status := examinelocation(startaddress,content);
                     physrecord.prefix := content;
                     startaddress := succ(startaddress);
                     status := examinelocation(startaddress,content);
                     physrecord.postfix := content;
                    end;
         endsection :;
        end; 
        end;   
end;  (* Get_ViaRecord_Via *) 
           

