{**  DEC/CMS REPLACEMENT HISTORY, Element ZPDFPROC.SRC **}
{**  *2    10-NOV-1986 15:06:38 LIN "Changed for UNIX - T.C.Lin 11/10/86" **}
{**  *1    10-OCT-1986 08:59:28 PALASM2 "" **}
{**  DEC/CMS REPLACEMENT HISTORY, Element ZPDFPROC.SRC **}
(*                                                                   *)
(*  (c) copyright Monolithic Memories, Inc. , 1986		     *)
(*                                                                   *)
{vax %include 'pal2$inc:z24global.inc'	vax}
{vax module zpdfproc (INPUT,OUTPUT,PDF); vax}


#include 'csopeninc.i'
#include 'ctre.i'
#include 'ctxtio.i'
#include 'fnxinc.i'
#include 'z24.i'

  function fileok(var f:fnameXtyp):boolean; external;  {!! 2 !!}

{ipp pragma C_Include('status.pf'); ipp}
{ipp with status; ipp}
{ipp program zpdfproc ; ipp}
{ipp pragma On(Externals_allowed_internally); ipp}
{ipp pragma C_include('ctre.inc'); ipp}
{ipp pragma C_include('ctxtio.inc'); ipp}
{ipp pragma C_include('fnxinc.inc'); ipp}
{ipp pragma C_include('z24.inc'); ipp}
(*-------------------------------------------------------------------*)
(*                                                                   *)
(*  MODULE    : ZPDFProc					     *)
(*  AUTHOR    : I. TALLER					     *)
(*  DATE      :	3-26-86						     *)
(*  FUNCTION  :	Reads PDF object file				     *)
(*                                                                   *)
(*  MODIFICATIONS :                                                  *)
(*    NAME        DATE       DESCRIPTION                             *)
(*    ----------- ---------- ------------------------------------    *)
(*    I. Taller   4/3/86     module rewrite			     *)
(*    M. Gzowski  5/9/86     incorperate OPENFILE routine for        *)
(*			     module release.  Function call support. *)
(*    I. Taller   6/19/86    chaging PDF file name according to the  *)
(*			     device type (ZHAL20, ZHAL24) 	     *)
(*    I. Taller   7/10/86    Adding checkSum mechanism               *)
(*								     *)
(* COMMENTS : This module contains a procedure, READ_PDF             *)
(*                                                                   *)
(*  NOTES     :                                                      *)
(*                                                                   *)
(* EXTERNAL DECLARATION : All external declaration include in        *)
(*                        "pal2$inc:z24global.inc"                   *)
(*                                                                   *)
(* GLOBAL DECLARATION : The global declaration is the array          *)
(*                      variable that this module dump the data      *)
(*                      from PDF file into it.                       *)
(*                                                                   *)
(*********************************************************************)

type
	pdftype = file of objblock;

var

(* object file variables *)

	pdf: pdftype;


(*                                                               *)
(*                                                                   *)
(*1111111111111111111111111111111111111111111111111111111111111111111*)
(*                                                                   *)
(*  PROCEDURE : READ_PDF					     *)
(*  AUTHOR    : I. TALLER					     *)
(*  DATE      : 3-31-86						     *)
(*  FUNCTION  :	Reads the PDF object file.			     *)
(*								     *)
(*  MODIFICATIONS :                                                  *)
(*    NAME        DATE       DESCRIPTION                             *)
(*    ----------- ---------- ------------------------------------    *)  
(*    M. Gzowski  5/9/86     function call support		     *)
(*                                                                   *)
(*  COMMENTS  :                                                      *)
(*                                                                   *)

(* MEG 5/9/86 *)
{vax [global] vax}  
 procedure readXpdf ;  

label  11;

var
	
(* Object file header *)
	header: headerrecord;

(* PDF Object File I/O Buffer *)
	inputbuffer : objblock;	

(* Pointer to I/O buffer *)
	bufferptr: 0..objblocksize;	



(**)
(*                                                                 *)
(*22222222222222222222222222222222222222222222222222222222222222222*)
(*                                                                 *)
(* PROCEDURE : ERRORHANDLER                                        *)
(* AUTHOR    : DER-HAUR HSIEH                                      *)
(* DATE      : 10/15/85                                            *)
(* FUNCTION  : This procdure reports the error and displays all    *)
(*             the variables on terminals                          *)
(*  MODIFICATIONS :                                                *)
(*       NAME               DATE             DESCRIPTION           *)
(*     -----------      ----------      -------------------------- *)  
(*    Der-Haur Hsieh       11/23/85        Initial release         *)
(*    Der-Haur Hsieh       12/3/85         call external           *)
(*    M. Gzowski	   5/9/86          function call support   *)
(*                                                                 *)
(* COMMENTS :                                                      *)
(*  INPUT PARAMETERS :                                             *)
(*                                                                 *)
(*    VARIABLE    TYPE       DESCRIPTION                           *)
(*    ----------- ---------- -----------------------------------   *)
(*    ErrorCode   int_X4     error code 			   *)
(*                                                                 *)





   procedure errorhandler(errorcode : intXx4);

   begin
      zglobalerr(errorcode,nili);

   (* MEG 5/9/86 *)
   (* when an error, set the function status    *)
   (*  the assumption being that any error that *)
   (*   has occured is a system type error      *)
      fnxXstatus := fnxXsysXerr;
      goto 11;
   end;

(**)
(*                                                                 *)
(*22222222222222222222222222222222222222222222222222222222222222222*)
(*                                                                 *)
(* PROCEDURE : OpenFile_ModuleSpec				   *)
(* AUTHOR    : Bala Kulasekaran                                    *)
(* DATE      : Mar 24 1986                                         *)
(* FUNCTION  : the module specific file openning routine.	   *)
(*             Properly opens files returning the status about the *)
(*             open operation                                      *)
(*                                                                 *)
(*  MODIFICATIONS :                                                *)
(*    NAME	       DATE	 DESCRIPTION			   *)
(*    ---------------  --------- --------------------------------  *)  
(*    M. Gzowski       5/12/86   unable to use function as 	   *)
(*				 resident in the CSOPEN module 	   *)
(*				 due to non-TEXT PDF file.	   *)
(*				 Copied this function and 	   *)
(*				 modified it accordingly.	   *)
(*				 Return a boolean status flag, 	   *)
(*				 TRUE if file open is successful.  *)
(*								   *)
(* COMMENTS :                                                      *)
(*								   *)
(*								   *)
(*			To whom it may concern:			   *)
(*			  If this were a perfect world,		   *)
(*			  the standard OPENFILE would have	   *)
(*			  worked in this case.  Alas it is	   *)
(*			  not perfect, so if you read this,	   *)
(*			  consider it your responsiblity to	   *)
(*			  verify that this routine conforms	   *)
(*			  to the presently release of		   *)
(*			  OPENFILE.				   *)
(*								   *)
(*								   *)
(*								   *)
(* INPUT PARAMETERS :                                              *)
(*    VARIABLE         TYPE      DESCRIPTION                       *)
(*    ---------------- --------- --------------------------------  *)
(*    filelogical      text      the logical file name      	   *)
(*    filename         string (ipp) 				   *)
(*                     packed array (vax/vms)			   *)
(*				 the actual file name		   *)
(*    filename_len     integer   the length of actual file name	   *)
(*    file_flag        integer   OLDFILE - open old file	   *)
(*				 NEWFILE - open new file	   *)
(*				 SHAREDFILE - open shared file	   *)
(*                                                                 *)
(*22222222222222222222222222222222222222222222222222222222222222222*)

function openfileXmodulespec
		( var   filelogical	: pdftype;    
			filename	: fnameXtyp;
			filenameXlen	: integer;
			fileXflag	: integer) 
						: boolean; 

var  
    openflag : boolean;
  unxpdfname : fnameXtyp;   {!! 2 !!}
  i : integer;   {!! 2 !!}

(* for opening filename is a string on the pc       *)
{ipp  temp_filename  :  string (fname_const);   ipp}

(* for opening filename is packed array on vax      *)
(* temp_filename  :  fname_typ;   *)

begin   (*OpenFile_ModuleSpec*)
  openflag := false;

(* set length of filename in string on PC *)
{ipp   temp_filename := filename; ipp}
{ipp   set_length (temp_filename,filename_len);                 ipp}
{ipp   Status.return_io_status := true;                         ipp}
  for i:=1 to filenameXlen do unxpdfname[i]:=filename[i];   {!! 2 !!}
 unxpdfname[i+1]:=chr(0);   {!! 2 !!}

(* Branch to required open file type *)
  case fileXflag of
  oldfile:
     begin
{vax   open(filelogical,filename,history:=old,error:=continue); vax}
{vax   openflag := (status(filelogical) = 0);                   vax}
{vax   if openflag then reset(filelogical);                     vax}
{ipp   reset (filelogical,temp_filename);                       ipp}
{ipp   Status.return_io_status := false;                        ipp}
{ipp   openflag := Status.ErrNo = no_error_occurred;            ipp}
   if fileok(unxpdfname) then    {!! 2 !!}
    begin    {!! 2 !!}
      reset(filelogical,unxpdfname);   {!! 2 !!}
      openflag:=true;   {!! 2 !!}
    end;   {!! 2 !!}
     end;

  newfile:
     begin
{vax   open(filelogical,filename,history:=new,error:=continue); vax}
{vax   openflag := (status(filelogical) = 0);                   vax}
{vax   if openflag then rewrite (filelogical);                  vax}
{ipp   rewrite (filelogical,temp_filename);                     ipp}
{ipp   Status.return_io_status := false;                        ipp}
{ipp   openflag := Status.ErrNo = no_error_occurred;            ipp}
   rewrite(filelogical,unxpdfname);   {!! 2 !!}
 {!! 2 !!}
     end;

  sharedfile:
     begin
{vax   open(filelogical,filename,history:=readonly,sharing:=readonly
		,error:=continue); 				vax}
{vax   openflag := (status(filelogical) = 0);                   vax}
{vax   if openflag then reset(filelogical);                     vax}
{ipp   reset (filelogical,temp_filename);                       ipp}
{ipp   Status.return_io_status := false;                        ipp}
{ipp   openflag := Status.ErrNo = no_error_occurred;            ipp}
   if fileok(unxpdfname) then    {!! 2 !!}
   begin    {!! 2 !!}
     reset(filelogical,unxpdfname);   {!! 2 !!}
     openflag := true;   {!! 2 !!}
   end;   {!! 2 !!}
     end;
  end;

(* set return status flag *)
  openfileXmodulespec := openflag;
end;   (*OpenFile_ModuleSpec*)

(*                                                               *)
(*                                                                   *)
(*2222222222222222222222222222222222222222222222222222222222222222222*)
(*                                                                   *)
(*  PROCEDURE :	readHeader					     *)
(*  AUTHOR    : I. TALLER					     *)
(*  DATE      : 3-26-86						     *)
(*  FUNCTION  : open the PDF object file and read the header, assign *)
(*		the correct value to some global variables and test  *)
(*		the PDF version number.				     *)
(*								     *)
(*  MODIFICATIONS :                                                  *)
(*    NAME        DATE       DESCRIPTION                             *)
(*    ----------- ---------- ------------------------------------    *)  
(*    M. Gzowski  5/9/86     Added new open statement/call	     *)
(*    I. Taller   6/19/86    chaging PDF file name according to the  *)
(*			     device type (ZHAL20, ZHAL24) 	     *)
(*                                                                   *)
(*  COMMENTS  :                                                      *)
(*                                                                   *)

procedure readheader;

var
(* MEG 5/9/86 *)
      i  : integer;
{/fnx}{ipp b_pdfname :fname_typ; ipp}

{dsy  LABEL 999;  dsy}
begin

(*    I. Taller   6/19/86    chaging PDF file name according to the  *)
(*			     device type (ZHAL20, ZHAL24) 	     *)
if (devicetype = zhal20) then
begin
    for i := 1 to pdffilenamesiz - 1 do 
	if (pdffilenameloc[i] = '2') and (pdffilenameloc[i+1] = '4') then 
		pdffilenameloc[i+1] := '0';
end;
		
(* open the PDF object file for reading *)
(* MEG 5/9/86 *)
if not openfileXmodulespec ( pdf, pdffilenameloc, pdffilenamesiz, sharedfile ) then
{/fnx} (* check for B Drive *)
{/fnx}{ipp    begin                                             ipp}
{/fnx}{ipp      for I := (fname_const - 2) downto 1 do          ipp}
{/fnx}{ipp         B_pdfname[I+2] := PDFFileNameLoc[I];         ipp}
{/fnx}{ipp      B_pdfname[1] := 'B';                            ipp}
{/fnx}{ipp      B_pdfname[2] := ':';                            ipp}
{/fnx}{ipp      if not OpenFile_ModuleSpec (pdf,B_pdfname,      ipp}
{/fnx}{ipp                 PDFFileNameSiz+2,sharedfile) then    ipp}
  begin
    errorhandler(pdfopenfail);
{dsy    goto 999;  dsy}
  end;
{/fnx}{ipp    end;                                              ipp}

(* read the header *)
	read(pdf, inputbuffer);
	header := inputbuffer.headerblock;

	with header do
	begin

	    pdfsize := memsize;
	    pdfid := idnum;
	    operatorindex := tablesaddr[oit];
	    mainindex     := tablesaddr[mit];
	    rectypedef    := tablesaddr[cit];
	    logphysmap    := tablesaddr[lpm];
	    logicaliomap  := tablesaddr[lia];
	    norecordtype  := mitnum;
	    pdfchecksum   := checksum;

	end; (* of with *)

   (* test the version range *)
	if (pdfid <> pdfversionnum) then errorhandler(versionunmatch);

{dsy 999:  dsy}
end; (* of proc *)




(*                                                               *)
(*                                                                   *)
(*2222222222222222222222222222222222222222222222222222222222222222222*)
(*                                                                   *)
(*  PROCEDURE :	readFile					     *)
(*  AUTHOR    : I. TALLER					     *)
(*  DATE      : 3-26-86						     *)
(*  FUNCTION  : reads the PDF object file into the memory 	     *) 
(*								     *)
(*  MODIFICATIONS :                                                  *)
(*    NAME        DATE       DESCRIPTION                             *)
(*    ----------- ---------- ------------------------------------    *)  
(*    I. Taller   7/10/86    Adding checkSum mechanism               *)
(*                                                                   *)
(*  COMMENTS  :                                                      *)
(*                                                                   *)

procedure readfile;

var

(* pointer to the current read integer inside the input block *)
	fileptr: integer;
	dummy,
(* the current PDF value *)
        pdfcontent: intXx4;
(* number of checksum numbers in the PDF file *)
        checksumnum: intXx4; 
begin

(* allocate memory for the PDF file contents *)
	initblock(pdfsize + 10);

(* init *)
	bufferptr := 0;
	fileptr := 0;
        checksumnum := 0;

(* read the file into the memory *)

	repeat

(* read one block when buffer is empty *)
	     if (bufferptr = 0) then 
		 if eof(pdf) then errorhandler(pdfreadfail)
		 	else read(pdf, inputbuffer);

	     pdfcontent := inputbuffer.intblock[bufferptr];
	     if (bufferptr = objblocksize) then
(* check if the computing checksum (PDFcheckSum) is equal to the last *)
(* value in the PDF object file block *)
	     begin
		 if (pdfchecksum <> pdfcontent) then 
					errorhandler(pdfchecksumerr);
        	 checksumnum := checksumnum + 1;
		 pdfchecksum := 0;
	     end
	     else
	     begin
(* store one integer in memory *)
	     	 dummy := savenext(pdfcontent);
		 pdfchecksum := (pdfchecksum + pdfcontent) mod checksumconst;
	     end;
(* MOD operation is system depend - 11/10/86. T.C.Lin *) {!! 2 !!}
             if (pdfchecksum < 0) then {!! 2 !!}
               pdfchecksum := pdfchecksum+checksumconst; {!! 2 !!}

	     bufferptr := (bufferptr + 1) mod (objblocksize + 1);
	     fileptr := fileptr + 1;

	until (fileptr = pdfsize + checksumnum);

	returnflag := examinelocation(pdfsize - 1, pdfcontent);
	if (pdfcontent <> eofmarker) then errorhandler(pdfreadfail);


end; (* of proc  *)



   (*                                                                 *)
   (*22222222222222222222222222222222222222222222222222222222222222222*)
   (*                                                                 *)
   (* PROCEDURE : GETCONTENTS                                         *)
   (* AUTHOR    : DER-HAUR HSIEH                                      *)
   (* DATE      : 11/23/85                                            *)
   (* FUNCTION : This procedure get the data from the address         *)
   (*            of the global variable                               *)
   (*  MODIFICATIONS :                                                *)
   (*       NAME               DATE             DESCRIPTION           *)
   (*     -----------      ----------      -------------------------- *)  
   (*    Der-Haur Hsieh      11/23/85         Initial release         *)
   (*                                                                 *)
   (* COMMENTS :                                                      *)
   (*  INPUT PARAMETERS :                                             *)
   (*                                                                 *)
   (*    VARIABLE    TYPE       DESCRIPTION                           *)
   (*    ----------- ---------- -----------------------------------   *)
   (*                                                                 *)




    procedure getcontents;

    var
	temp: intXx4;

    begin

	    returnflag := examinelocation(operatorindex , temp);   
            returnflag := examinelocation(mainindex, temp);
            returnflag := examinelocation(header.tablesaddr[int], temp);
            returnflag := examinelocation(header.tablesaddr[iod], temp);
            returnflag := examinelocation(rectypedef, temp);
            returnflag := examinelocation(header.tablesaddr[acr], temp);
{/dsy}            if logphysmap <> -1 then 
{/dsy}		returnflag := examinelocation(logphysmap, temp);
{/dsy}            if logicaliomap <> -1 then 
{/dsy}		returnflag := examinelocation(logicaliomap, temp);

    end; (* end of procedure GetContents *)




(*11111111111111111111111111111111111111111111111111111111111111111111111111*)


begin	(* of READ_PDF  *)

(* open the PDF object file and read the header *)
	readheader;
{dsy if (fnx_status <> fnx_ret_ok) then goto 11;  dsy}
(* read the rest of the PDF object file into the memory *)
	readfile;
(* get the date from the address of the global variables *)
	getcontents;

11:
end;


{vax end. vax}


