{**  DEC/CMS REPLACEMENT HISTORY, Element ZMBC.SRC **}
{**  *1    10-OCT-1986 08:59:23 PALASM2 "" **}
{**  DEC/CMS REPLACEMENT HISTORY, Element ZMBC.SRC **}
(*                                                                   *)
(*  (c) copyright Monolithic Memories, Inc. , 1986		     *)
(*                                                                   *)
(* MEG 2/10/86 *)
{vax %include 'pal2$inc:z24global.inc'		vax}
{vax module ZMBC;				vax}


#include 'csopeninc.i'
#include 'ctre.i'
#include 'ctxtio.i'
#include 'fnxinc.i'
#include 'z24.i'


{ipp program ZMBC; 				ipp}
{ipp pragma On(Externals_allowed_internally); 	ipp}
{ipp pragma C_include('ctre.inc'); 		ipp}
{ipp pragma C_include('ctxtio.inc'); 		ipp}
{ipp pragma C_include('fnxinc.inc'); ipp}
{ipp pragma C_include('z24.inc'); 		ipp}
(*-------------------------------------------------------------------*)
(*                                                                   *)
(*  MODULE    : ZMBC - MemoryBlockControl			     *)
(*  AUTHOR    : Michael Gzowski                                      *)
(*  DATE      : 10/24/85                                             *)
(*  FUNCTION  : This module contains the routines necessary to 	     *)
(*              control the memory used to store the PDF or device   *)
(*              architectural structure.			     *)
(*                                                                   *)
(*  MODIFICATIONS :                                                  *)
(*    NAME        DATE       DESCRIPTION                             *) 
(*    ----------- ---------- ------------------------------------    *)
(*    M. Gzowski  10/24/85   Initial release                         *)
(*    M. Gzowski  11/26/85   1) Removed all global declarations to   *)
(*			        ENVIRONMENT file, 	     	     *)
(*			     2) added NextLocation routine, and	     *)
(*			     3) changed all "integer" types to 	     *)
(*				"int_X4" types.			     *)
(*    M. Gzowski  11/27/85   1) ENVIRONMENT file inherits removed to *)
(*				standard INCLUDE file		     *)
(*    M. Gzowski  12/4/85    Added ZHAL condition handler calls	     *)
(*    M. Gzowski  1/7/86     Substituted ZMBCTop for Top	     *)
(*    M. Gzowski  2/10/86    corrected module header and trailer     *)
(*                                                                   *)
(*                                                                   *)
(*  COMMENTS  : These routines provide the only legitimate access to *)
(*		the device architectural structure.  Through this    *)
(*		module all pointer and indexes associated with the   *)
(*		memory management function is controlled.  Therefore,*)
(*		should an improved method of memory handling be used *)
(*		in the future, this will be the only module to       *)
(*		change.						     *)
(*                                                                   *)
(*  NOTES     : The following global procedures are contained within *)
(*		this module:					     *)
(*			InitBlock				     *)
(*			ExamineLocation				     *)
(*			PutLocation				     *)
(*			AllocateSpace				     *)
(*			SaveNext				     *)
(*			NextLocation				     *)
(*                                                                   *)
(*  EXTERNAL DECLARATIONS :                                          *)
(*		Declared in Z24.INC				     *)

type
	codesect = (examl, putl, accessl, exists, saven);	

(*  GLOBAL DECLARATIONS :                                            *)
(*		Declared in Z24.INC				     *)
(*                                                                   *)

(**)
  (*                                                                 *)
  (*11111111111111111111111111111111111111111111111111111111111111111*)
  (*                                                                 *)
  (*  PROCEDURE : NewPtrOfArray					     *)
  (*  AUTHOR    : M.Gzowski                                          *)
  (*  DATE      : 10/24/85                                           *)
  (*  FUNCTION  : create a new PtrOfArray record and initializes all *)
  (*   		  pointer elements in the record.		     *)
  (*                                                                 *)
  (*  MODIFICATIONS :                                                *)
  (*    NAME        DATE       DESCRIPTION                           *)
  (*    ----------- ---------- ------------------------------------  *)  
  (*                                                                 *)
  (*  COMMENTS  : PtrOfArray is created via NEW, and all pointers    *)
  (*		  contained are set to NIL.  The procedure is local  *)
  (*		  to Module only.				     *)
  (*                                                                 *)
  (*  INPUT PARAMETERS :                                             *)
  (*                                                                 *)
  (*    VARIABLE    TYPE       DESCRIPTION                           *)
  (*    ----------- ---------- ------------------------------------  *)
  (*    Pointer	    ArrayPtr   the pointer to the PtrOfArray 	     *)
  (*		   	       structure to be created.		     *)
  (*			       Passed by reference.		     *)
  (*                                                                 *)
  procedure newptrofarray ( var pointer : arrayptr );
    var
   	i : intXx4;

    begin (*NewPtrOfArray*)
      new(pointer);
      with pointer^
       do begin
         for i := lowerlimit to upperlimit
          do blocks[i] := nil;
         nextarray := nil
        end; (*with...do*)
    end;  (*NewPtrOfArray*)


(**)
  (*                                                                 *)
  (*11111111111111111111111111111111111111111111111111111111111111111*)
  (*                                                                 *)
  (*  PROCEDURE : FlagZHALErr					     *)
  (*  AUTHOR    : M.Gzowski                                          *)
  (*  DATE      : 12/4/85                                            *)
  (*  FUNCTION  : set the ZHAL global error flag in case of error.   *)
  (*                                                                 *)
  (*  MODIFICATIONS :                                                *)
  (*    NAME        DATE       DESCRIPTION                           *)
  (*    ----------- ---------- ------------------------------------  *)  
  (*                                                                 *)
  (*  COMMENTS  : 
  (*                                                                 *)
  (*  INPUT PARAMETERS :                                             *)
  (*                                                                 *)
  (*    VARIABLE    TYPE       DESCRIPTION                           *)
  (*    ----------- ---------- ------------------------------------  *)
  (*    Routine	    CodeSect   the location of the potential error.  *)
  (*                                                                 *)
  procedure flagzhalerr  ( routine : codesect );

    begin (*FlagZHALErr*)
      if memblkctrlstatus <> normal
       then begin
         case routine of
 	   examl:
		zglobalerr ( zmbcexam, dummyvalue );
           putl:  
		zglobalerr ( zmbcput, dummyvalue );
           accessl: 
		zglobalerr ( zmbcaccess, dummyvalue );
           exists: 
		zglobalerr ( zmbcexists, dummyvalue );
           saven:
		zglobalerr ( zmbcsave, dummyvalue );
          end; (*case*)
         zglobalerr ( memblkctrlstatus, dummyvalue );
        end; (*if...then*)

    end;  (*FlagZHALErr*)


(**)
  (*                                                                 *)
  (*11111111111111111111111111111111111111111111111111111111111111111*)
  (*                                                                 *)
  (*  PROCEDURE : GetOffsets 					     *)
  (*  AUTHOR    : M.Gzowski                                          *)
  (*  DATE      : 10/24/85                                           *)
  (*  FUNCTION  : get the values of the Link number of the 	     *)
  (*		  PtrOfArray, the Block Point Offset, the Offset     *)
  (*		  within the Block.				     *)
  (*                                                                 *)
  (*  MODIFICATIONS :                                                *)
  (*    NAME        DATE       DESCRIPTION                           *)
  (*    ----------- ---------- ------------------------------------  *)  
  (*                                                                 *)
  (*  COMMENTS  : for a given memory index, calculate the offsets    *)
  (*		  to that location.				     *)
  (*                                                                 *)
  (*  INPUT PARAMETERS :                                             *)
  (*                                                                 *)
  (*    VARIABLE    TYPE       DESCRIPTION                           *)
  (*    ----------- ---------- ------------------------------------  *)
  (*	MemIndex      int_X4	The index to the memory location,    *)
  (*				passed by reference.		     *)
  (*	Link          int_X4	The link (PtrOfArray) offset, passed *)
  (*				by reference.			     *)
  (*	BlockPtr      int_X4	The offset in the Blocks field of    *)
  (*				PtrOfArray, passed by reference.     *)
  (*	BlockLoc      int_X4	The offset (index) in the Block,     *)
  (*				passed by reference.		     *)
  (*	OffsetsWanted boolean	true for offsets, false for Index    *)
  (*				(location), passed by value.	     *)
  (*                                                                 *)
  procedure getoffsets (var memindex : intXx4;
			var link, blockptr, blockloc : intXx4;
                        offsetswanted : boolean );
    var
   	temp : intXx4;
   
    begin (*GetOffsets*)
      if offsetswanted 
       then begin
         link := memindex div blksizxx2;
         temp := memindex mod blksizxx2;
         blockptr := temp div blocksize;
         blockloc := temp mod blocksize;
        end (*if...then*)
       else
(* MEG 1/7/86 *)
        memindex := (link-zmbctop) * blksizxx2 
                  + (blockptr-lowerlimit) * blocksize 
                  + (blockloc-lowerlimit);
    end;  (*GetOffsets*)


(**)
  (*                                                                 *)
  (*11111111111111111111111111111111111111111111111111111111111111111*)
  (*                                                                 *)
  (*  PROCEDURE : AllocateSpace                                      *)
  (*  AUTHOR    : M.Gzowski                                          *)
  (*  DATE      : 10/24/85					     *)
  (*  FUNCTION  : This procedure is called to get some 		     *)
  (*              predetermined amount of space.  The intention      *)
  (*              being that this procedure can be called prior to   *)
  (*              the reading in of the entire PDF file into memory. *)
  (*                                                                 *)
  (*  MODIFICATIONS :                                                *)
  (*    NAME        DATE       DESCRIPTION                           *)
  (*    ----------- ---------- ------------------------------------  *)  
  (*                                                                 *)
  (*  COMMENTS  : this procedure will set allocated memory to some   *)
  (*		  passed size.  An additional paramter determines    *)
  (*		  whether the size is a minimum value for memory, or *)
  (*		  an addition amount of space beyond that already    *)
  (*		  allocated.					     *)
  (*                                                                 *)
  (*  INPUT PARAMETERS :                                             *)
  (*                                                                 *)
  (*    VARIABLE    TYPE       DESCRIPTION                           *)
  (*    ----------- ---------- ------------------------------------  *)
  (*	Size	    int_X4     amount of memory to allocate, passed  *)
  (*			       by value.			     *)
  (*	BaseSize    boolean    if true, then Size is a minimum	     *)
  (*			       amount of space to be allocated, if   *)
  (*			       false, it is a additional allocation  *)
  (*		 	       amount.  Passed by value. 	     *)
  (*			       					     *)
  {vax [GLOBAL] vax}
  procedure allocatespace ;  
    var
	temp : intXx4;
        oldsize : intXx4;
 	stoplink,
        stopblock,
        stopblkloc : intXx4;

    begin (*AllocateSpace*)

  (* Calculate the current allocated size *)
      getoffsets ( oldsize, 
                   lastptrarraylink, 
                   lastblock, 
                   lastblkloc, 
                   locations );
   
  (* now decide whether any more space needs to be allocated *)
      if (basesize and (oldsize < size)) or not(basesize)
       then begin
         if not(basesize) then size := oldsize + size;
         getoffsets (size, stoplink, stopblock, stopblkloc, offsets);

  (* create the required number of PtrOfArray *)
         while stoplink > lastptrarraylink
          do begin
            with lastptrarray^
             do begin
               for temp := lastblock + 1 to upperlimit
                do new(blocks[temp]);
               newptrofarray(nextarray);
               lastptrarray := nextarray;
              end; (*with...do*)
            lastblock := pred(lowerlimit);
            lastptrarraylink := succ(lastptrarraylink);
           end; (*while...do*)

  (*create any additional Blocks needed *)
         temp := succ(lastblock);
         if stopblock > lastblock then begin
	  for temp := temp to stopblock do new(lastptrarray^.blocks[temp]);
          lastblock := temp;
         end;
         lastblkloc := stopblkloc;
        end; (*if...then*)
    end;  (*AllocateSpace*)

(**)
  (*                                                                 *)
  (*11111111111111111111111111111111111111111111111111111111111111111*)
  (*                                                                 *)
  (*  PROCEDURE : InitBlock                                          *)
  (*  AUTHOR    : M.Gzowski                                          *)
  (*  DATE      : 10/24/85                                           *)
  (*  FUNCTION  : Frees any existing or used blocks.  If no blocks   *)
  (*              are in use, then the initial block is created.     *)
  (*              All pointers are reset.  Also sets initial memory  *)
  (*	 	  space requirements.	                             *)
  (*                                                                 *)
  (*  MODIFICATIONS :                                                *)
  (*    NAME        DATE       DESCRIPTION                           *)
  (*    ----------- ---------- ------------------------------------  *)  
  (*                                                                 *)
  (*                                                                 *)
  (*  COMMENTS  : First, check if the memory has 		     *)
  (*                been initialized before;                         *)
  (*		  if it has not been initialized, 		     *)
  (*		    create the first PtrOfArray;		     *)
  (*		  set all the "Current" pointers and indices to	     *)
  (*		    the first positions;			     *)
  (* 		  allocated the indicated amount of space.	     *)
  (*                                                                 *)
  (*  INPUT PARAMETERS :                                             *)
  (*                                                                 *)
  (*    VARIABLE    TYPE       DESCRIPTION                           *)
  (*    ----------- ---------- ------------------------------------  *)
  (*    Space	    int_X4     the integer value of the initial	     *)
  (*			       memory allocation amount.	     *)
  (*                                                                 *)
  {vax [GLOBAL] vax}
  procedure initblock ;  
    begin (*InitBlock*)

  (* setup for uninitialized structures *)
      if memoryblockinitialized = not(initialized)
       then begin
         memoryblockinitialized := initialized;
         newptrofarray(topptrarray);
(* MEG 1/7/86 *)
         lastptrarraylink := zmbctop;
         lastptrarray := topptrarray;
         new( topptrarray^.blocks[lowerlimit] ); 
         lastblock := lowerlimit;
         lastblkloc := pred(lowerlimit);
        end; (*if...then*)

  (* setup for all structures *)
(* MEG 1/7/86 *)
      currentptrarraylink := zmbctop;
      currentptrarray := topptrarray;
      currentblock := lowerlimit;
      currentblkloc := pred(lowerlimit);

  (* get any space requested *)
      allocatespace (space, baseamount);

    end;  (*InitBlock*)


(**)
  (*                                                                 *)
  (*11111111111111111111111111111111111111111111111111111111111111111*)
  (*                                                                 *)
  (*  PROCEDURE : LocationExists				     *)
  (*  AUTHOR    : M.Gzowski                                          *)
  (*  DATE      : 10/24/85					     *)
  (*  FUNCTION  : This function is used to determine if any given    *)
  (* 		  memory location exist and set the module status    *)
  (*		  flag (MemBlkCtrlStatus) accordingly.  Set the      *)
  (*		  global variables up to access the location, if it  *)
  (*		  exists.					     *)
  (*                                                                 *)
  (*  MODIFICATIONS :                                                *)
  (*    NAME        DATE       DESCRIPTION                           *)
  (*    ----------- ---------- ------------------------------------  *)  
  (*                                                                 *)
  (*  COMMENTS  : This function is used to test for the existance of *)
  (*		  given location.  The value returned is the boolean *)
  (*		  result of that test, true if it exists, false if   *)
  (*		  not.  The following Module Global variables are    *)
  (*		  set to allow access to the tested location 	     *)
  (*		  immediately after this function is called:	     *)
  (*			PtrArrayLink,				     *)
  (*			BlkPtrOffset, and			     *)
  (*			BlockOffset.				     *)
  (*              One of the following status codes will be set in   *)
  (*		  the module status flag, MemBlkCtrlStatus:	     *)
  (*			NORMAL, no error encountered;		     *)
  (*			BlockErrBlkLoc, bad location in a Block;     *)
  (*		 	BlockErrBlock, Block out of allocated range; *)
  (*			BlockErrPrtArray, PtrOfArray out of range.   *)
  (*                                                                 *)
  (*  INPUT PARAMETERS :                                             *)
  (*                                                                 *)
  (*    VARIABLE    TYPE       DESCRIPTION                           *)
  (*    ----------- ---------- ------------------------------------  *)
  (*	Location    int_X4	The index (address) to the location  *)
  (*                              to be examined, passed by value.   *)
  (*                                                                 *)
  function locationexists ( location : intXx4 ) : boolean;
    var
	temp : intXx4;

    begin (* LocationExists *)

  (* set the initial status *)
      memblkctrlstatus := normal;

  (* get the values of the links and offsets for location test and access*) 
      getoffsets (location, ptrarraylink, blkptroffset, blockoffset, offsets); 

  (* test if any boundaries have been exceeded *)
      if ptrarraylink > lastptrarraylink
       then memblkctrlstatus := blockerrprtarray
       else begin
         if ptrarraylink = lastptrarraylink
	  then begin
            if blkptroffset > lastblock
             then memblkctrlstatus := blockerrblock
	     else begin
               if blkptroffset = lastblock
                then begin
                  if blockoffset > lastblkloc
                   then memblkctrlstatus := blockerrblkloc
                 end (*if...then*)
              end (* else *)
           end (*if...then*)
        end; (* else *)

  (* assign the function its return value *)
      if memblkctrlstatus = normal
       then locationexists := true           
       else locationexists := false;           
      
    end;  (* LocationExists *)

(**)
  (*                                                                 *)
  (*11111111111111111111111111111111111111111111111111111111111111111*)
  (*                                                                 *)
  (*  PROCEDURE : AccessLocation				     *)
  (*  AUTHOR    : M.Gzowski                                          *)
  (*  DATE      : 10/24/85					     *)
  (*  FUNCTION  : This procedure is used to do random reads and      *)
  (*		  writes to Block Control Memory.		     *)
  (*                                                                 *)
  (*  MODIFICATIONS :                                                *)
  (*    NAME        DATE       DESCRIPTION                           *)
  (*    ----------- ---------- ------------------------------------  *)  
  (*                                                                 *)
  (*  COMMENTS  : This function is used to write to (PutValue), read *)
  (*              from (GetValue), or both (GetAndPut).  This 	     *)
  (*		  routine is intended to be called from ZMBC module  *)
  (*		  only.  The following Module Global variables 	     *)
  (*		  should be set up prior to calling this routine:    *)
  (*			PtrArrayLink,				     *)
  (*			BlkPtrOffset, and			     *)
  (*			BlockOffset.				     *)
  (*		  The following error codes may be placed in the     *)
  (*		  module status flag, MemBlkCtrlStatus:		     *)
  (*			NORMAL, no error encountered;		     *)
  (*		 	BlockErrBlock, Block out of allocated range; *)
  (*			BlockErrPrtArray, PtrOfArray out of range.   *)
  (*                                                                 *)
  (*  INPUT PARAMETERS :                                             *)
  (*                                                                 *)
  (*    VARIABLE    TYPE       DESCRIPTION                           *)
  (*    ----------- ---------- ------------------------------------  *)
  (*    PutOrGet    AccessMethod This parameteris used to control    *)
  (*    			 whether the parameter Value is	     *)
  (*    			 saved, read, or saved then read.    *)
  (*    			 Passed by value.		     *)
  (*    val          int_X4      The value to be saved, read into,   *)
  (*    			 or both.  Passed by reference.	     *)
  (*                                                                 *)
  procedure accesslocation ( putorget : accessmethod;
                            var val : intXx4 );
    var
	temp : intXx4;
	tempptr : arrayptr;

    begin (* AccessLocation *)

  (* initialize the loop variables *)
(* MEG 1/7/86 *)
      temp := zmbctop;
      tempptr := topptrarray;
 
  (* find the correct PtrOfArray *)
      while ( temp <> ptrarraylink )
       and ( tempptr <> nil )
       do begin
         temp := succ(temp);
         tempptr := tempptr^.nextarray
        end; (*while...do*)

  (* see if we've found the PtrOfArray *)
      if ( tempptr <> nil ) and ( temp = ptrarraylink )

  (* PtrOfArray found, make sure that the Block exists, too. *)
       then begin
         with tempptr^ 
          do if blocks[blkptroffset] <> nil
           then begin
             case putorget of
               getvalue:
			val := blocks[blkptroffset]^[blockoffset];
               putvalue:
			blocks[blkptroffset]^[blockoffset] := val;
               getandput:
			begin
			  temp := blocks[blkptroffset]^[blockoffset];
			  blocks[blkptroffset]^[blockoffset] := val;
			  val := temp
 			 end;
              end; (*case*)  
             memblkctrlstatus := normal
            end (*if...then*)
           else memblkctrlstatus := blockerrblock
        end (*if...then*)

  (* PtrOfArray not found *)
       else memblkctrlstatus := blockerrprtarray

    end;  (* AccessLocation *)

(**)
  (*                                                                 *)
  (*11111111111111111111111111111111111111111111111111111111111111111*)
  (*                                                                 *)
  (*  PROCEDURE : ExamineLocation  				     *)
  (*  AUTHOR    : M.Gzowski                                          *)
  (*  DATE      : 10/24/85					     *)
  (*  FUNCTION  : This function is used to view any memory location  *)
  (*              under the control of Memory Block Control.	     *)
  (*                                                                 *)
  (*  MODIFICATIONS :                                                *)
  (*    NAME        DATE       DESCRIPTION                           *)
  (*    ----------- ---------- ------------------------------------  *)  
  (*                                                                 *)
  (*  COMMENTS  : This function is used to gain random read access   *)
  (*		to the data stored in the Block Control Blocks.	     *)
  (*		The value returned by the function is a status value *)
  (*		for the routine and may have the following values:   *)
  (*			NORMAL, no error encountered;		     *)
  (*			BlockErrBlkLoc, bad location in a Block;     *)
  (*		 	BlockErrBlock, Block out of allocated range; *)
  (*			BlockErrPrtArray, PtrOfArray out of range.   *)
  (*                                                                 *)
  (*  INPUT PARAMETERS :                                             *)
  (*                                                                 *)
  (*    VARIABLE    TYPE       DESCRIPTION                           *)
  (*    ----------- ---------- ------------------------------------  *)
  (*	Location    int_X4	The index (address) to the location  *)
  (*                              to be examined, passed by value.   *)
  (*	val	    int_X4  	The value stored at the examined     *)
  (*				location, passed by reference.	     *)
  (*                                                                 *)
  {vax [GLOBAL] vax}
  function examinelocation ;  

    begin (* ExamineLocation *)

      if locationexists( location )
       then accesslocation( getvalue, val );
      examinelocation := memblkctrlstatus;
    (*vvv MEG 12/4/85 vvv*)
      flagzhalerr ( examl );
    (*^^^ MEG 12/4/85 ^^^*)

    end;  (* ExamineLocation *)

(**)
  (*                                                                 *)
  (*11111111111111111111111111111111111111111111111111111111111111111*)
  (*                                                                 *)
  (*  PROCEDURE : PutLocation  					     *)
  (*  AUTHOR    : M.Gzowski                                          *)
  (*  DATE      : 10/24/85					     *)
  (*  FUNCTION  : This function is used to save to a memory location *)
  (*              under the control of Memory Block Control.	     *)
  (*                                                                 *)
  (*  MODIFICATIONS :                                                *)
  (*    NAME        DATE       DESCRIPTION                           *)
  (*    ----------- ---------- ------------------------------------  *)  
  (*                                                                 *)
  (*  COMMENTS  : This function is used to gain random write access  *)
  (*		to the data stored in the Block Control Blocks.	     *)
  (*		The value returned by the function is a status value *)
  (*		for the routine and may have the following values:   *)
  (*			NORMAL, no error encountered;		     *)
  (*			BlockErrBlkLoc, bad location in a Block;     *)
  (*		 	BlockErrBlock, Block out of allocated range; *)
  (*			BlockErrPrtArray, PtrOfArray out of range.   *)
  (*                                                                 *)
  (*  INPUT PARAMETERS :                                             *)
  (*                                                                 *)
  (*    VARIABLE    TYPE       DESCRIPTION                           *)
  (*    ----------- ---------- ------------------------------------  *)
  (*	Location    int_X4	The index (address) to the location  *)
  (*                            to be saved to, passed by value.     *)
  (*	val	    int_X4  	The value to be put at Location,     *)
  (*				passed by value.		     *)
  (*                                                                 *)
  {vax [GLOBAL] vax}
  function putlocation ;  

    begin (* PutLocation *)

      if locationexists( location )
       then accesslocation( putvalue, val );
      putlocation := memblkctrlstatus;
    (*vvv MEG 12/4/85 vvv*)
      flagzhalerr ( putl );
    (*^^^ MEG 12/4/85 ^^^*)

    end;  (* PutLocation *)

(**)
  (*                                                                 *)
  (*11111111111111111111111111111111111111111111111111111111111111111*)
  (*                                                                 *)
  (*  PROCEDURE : SaveNext					     *)
  (*  AUTHOR    : M.Gzowski                                          *)
  (*  DATE      : 10/24/85					     *)
  (*  FUNCTION  : This procedure is called to put some value into    *)
  (*		  Block Controlled Memory, at the next sequential    *)
  (*		  location.					     *)
  (*                                                                 *)
  (*  MODIFICATIONS :                                                *)
  (*    NAME        DATE       DESCRIPTION                           *)
  (*    ----------- ---------- ------------------------------------  *)  
  (*                                                                 *)
  (*  COMMENTS  : This function saves the passed value at the next   *)
  (*              available location.  If the present Block is       *)
  (*              filled, then a new block is created.  If the       *)
  (*              present PtrOfArray is filled, a new one is 	     *)
  (*		  created.   The integer index (pointer) to the      *)
  (*		  stored data is returned.  If the returned value is *)
  (*		  negative, then it is a status code, and not an     *)
  (*		  index.					     *)
  (*                                                                 *)
  (*  INPUT PARAMETERS :                                             *)
  (*                                                                 *)
  (*    VARIABLE    TYPE       DESCRIPTION                           *)
  (*    ----------- ---------- ------------------------------------  *)
  (*	val	    int_X4	the value to be saved, passed by     *)
  (*			       	value. 				     *)
  (*			       					     *)
  {vax [GLOBAL] vax}
  function savenext ;  

    var
	temp : intXx4;

    begin (*SaveNext*)

  (* see if there is enough space available *)
      if (currentptrarraylink = lastptrarraylink)
       and (currentblock = lastblock)
       and (currentblkloc = lastblkloc)

  (* No, get more space, move all link counters and offsets *)
       then begin
         allocatespace (1, additionalamount);
         currentptrarraylink := lastptrarraylink ;
         currentblock := lastblock;
         currentblkloc := lastblkloc;
        end (*if...then*)

  (* Yes, move only the current location *)
       else begin
         if currentblkloc = upperlimit
          then begin
            currentblkloc := lowerlimit;
            if currentblock = upperlimit
             then begin
               currentblock := lowerlimit;
               currentptrarraylink := succ(currentptrarraylink);
              end (*if...then*)
             else currentblock := succ(currentblock);
           end (*if...then*)
          else currentblkloc := succ(currentblkloc);
        end; (*else*)

  (* Get the location and save the value *)
     getoffsets( temp, 
                 currentptrarraylink, 
                 currentblock, 
                 currentblkloc, 
                 locations );
     ptrarraylink := currentptrarraylink;
     blkptroffset := currentblock;
     blockoffset := currentblkloc;
     accesslocation( putvalue, val );
     
  (* Check MemBlkCtrlStatus *)
  (*vvv MEG 12/4/85 vvv*)
     if memblkctrlstatus <> normal
      then begin
        savenext := -memblkctrlstatus;
        flagzhalerr ( saven );
       end (*if...then*)
      else savenext := temp;
  (*^^^ MEG 12/4/85 ^^^*)

    end;  (*SaveNext*)

(**)
  (*                                                                 *)
  (*11111111111111111111111111111111111111111111111111111111111111111*)
  (*                                                                 *)
  (*  PROCEDURE : NextLocation					     *)
  (*  AUTHOR    : M.Gzowski                                          *)
  (*  DATE      : 11/26/85					     *)
  (*  FUNCTION  : This procedure is called to get integer index to   *)
  (*		  the next sequential location in Block Controlled   *)
  (*		  Memory.					     *)
  (*                                                                 *)
  (*  MODIFICATIONS :                                                *)
  (*    NAME        DATE       DESCRIPTION                           *)
  (*    ----------- ---------- ------------------------------------  *)  
  (*	M.Gzowski   11/26/85   Added to MemoryBlockControl module.   *)
  (*                                                                 *)
  (*  COMMENTS  : This function returns the integer index of the     *)
  (*		  next available location.  		             *)
  (*		  This is intended for use in label resolution.	     *)
  (*                                                                 *)
  (*  INPUT PARAMETERS :                                             *)
  (*                                                                 *)
  (*    VARIABLE    TYPE       DESCRIPTION                           *)
  (*    ----------- ---------- ------------------------------------  *)
  (*			       					     *)
  {vax [GLOBAL] vax}
  function nextlocation ;  

    var
	temp : intXx4;

    begin (*NextLocation*)

  (* Get the current location *)
     getoffsets( temp, 
                 currentptrarraylink, 
                 currentblock, 
                 currentblkloc, 
                 locations );

     nextlocation := succ(temp);

    end;  (*NextLocation*)

{vax  end.  vax} (* of module MemoryBlockControl *)
