{**  DEC/CMS REPLACEMENT HISTORY, Element ZGLBINIT.SRC **}
{**  *3    13-FEB-1987 12:08:48 TALLER "zhal2420 bug  2/13/1987" **}
{**  *2    13-OCT-1986 13:20:04 GZOWSKI "corrected zhal2420 pin numbering" **}
{**  *1    10-OCT-1986 08:59:14 PALASM2 "" **}
{**  DEC/CMS REPLACEMENT HISTORY, Element ZGLBINIT.SRC **}
(*                                                                   *)
(*  (c) copyright Monolithic Memories, Inc. , 1986                   *)
(*                                                                   *)
(*  RJS 27/JAN/86 *)
{vax %include 'pal2$inc:z24global.inc'  vax}
{vax module zglbinit (INPUT,OUTPUT); vax}


#include 'csopeninc.i'
#include 'ctre.i'
#include 'ctxtio.i'
#include 'fnxinc.i'
#include 'z24.i'


{ipp program zglbinit ; ipp}
{ipp pragma On(Externals_allowed_internally); ipp}
{ipp pragma C_include('ctre.inc'); ipp}
{ipp pragma C_include('ctxtio.inc'); ipp}
{ipp pragma C_include('fnxinc.inc'); ipp}
{ipp pragma C_include('z24.inc'); ipp}
(*-------------------------------------------------------------------*)
(*                                                                   *)
(*  MODULE    : ZGlbInit                                             *)
(*  AUTHOR    : Boris B. Shih                                        *)
(*  DATE      : 11/6/85                                              *)
(*  FUNCTION  : This module contains the routines necessary for      *)
(*              data structure and global data initialization.       *)
(*                                                                   *)
(*  MODIFICATIONS :                                                  *)
(*    NAME        DATE       DESCRIPTION                             *)
(*    ----------- ---------- ------------------------------------    *)
(*    M.Gzowski   1/5/86     Minor fixes before release.             *)
(*    M.Gzowski   1/7/86     Made the following call substitutions:  *)
(*                              GetConnection for GetFlag;           *)
(*                              PutConnection for PutFlag;           *)
(*                              ClrArrayLine for ClrArrayRow         *)
(*                           Removed TempFlag, added TempIOType.     *)
(*    M.Gzowski   1/7/86     Added assignment to TxtFileName         *)
(*    M.Gzowski   1/20/86    Added assignment to TxtGlobalStr        *)
(*                           fixes to InitDeviceData                 *)
(*    M.Gzowski   2/3/86     added call to ResetForceRoute           *)
(*    M.Gzowski   2/10/86    modified InitDeviceData                 *)
(*    M.Gzowski   2/12/86    modified InitGlobals                    *)
(*    I.Taller    6/19/86    added the InitDeviceType procedure      *)
(*    I.Taller    7/3/86     changes in InitDeviceType               *)
(*    M.Gzowski   7/8/86     fix for bug #882, remove text file name *)
(*    I. Taller   7/11/86    modified initdevicetype zhal2420	     *)
(*    I. Taller   8/15/86    init ZHALviaMapFile name		     *)
(*    M.Gzowski	  10/13/86   changes for ZHAL2420		     *) {!! 2 !!}
(*    I. Taller   2/13/87    fixing bug in initdevicetype 	     *) {!! 3 !!}
(*                                                                   *)
(*  COMMENTS  :                                                      *)
(*		WHO MADE THE UNIX CHANGES, AND WHY AREN'T	     *) {!! 2 !!}
(*		THE CHANGES MARKED?				     *) {!! 2 !!}
(*			M.Gzowski 10/13/86			     *) {!! 2 !!}
(*                                                                   *)
(*  NOTES     : The following procedures are contained within this   *)
(*              module:                                              *)
(*                  InitGlobals                                      *)
(*                  InitDeviceType                                   *)
(*                  InitDeviceData                                   *)
(*                                                                   *)
(*  EXTERNAL DECLARATIONS : see NOTES.                               *)
(*                                                                   *)
(*  GLOBAL DECLARATIONS : all Globals referenced are declared in     *)
(*                        the ZHAL24 include file, Z24.INC           *)
(*                                                                   *)
 
(*
  
  
*)
 
(*                                                                   *)
(*-------------------------------------------------------------------*)
(*                                                                   *)
(*  PROCEDURE : InitGlobals                                          *)
(*  AUTHOR    : Boris B. Shih                                        *)
(*  DATE      : 11/6/85                                              *)
(*  FUNCTION  : This procedure is called to set all global           *)
(*              variables to their initial state.                    *)
(*                                                                   *)
(*  MODIFICATIONS :                                                  *)
(*    NAME        DATE       DESCRIPTION                             *)
(*    ----------- ---------- ------------------------------------    *)
(*    M.Gzowski   1/5/86     Minor fixes before release.             *)
(*    M.Gzowski   2/3/86     call to ResetForceRoute                 *)
(*    M.Gzowski   2/11/86    initialize TRE equation traverse var's  *)
(*    M.Gzowski   2/12/86    call to ResetDataCompress               *)
(*    I.Taller    6/19/86    init MaxDevicePin, MaxColNo             *)
(*    M.Gzowski   7/8/86     fix for bug #882, remove text file name *)
(*    I.Taller    7/8/86     init MemoryBlockInitialized             *)
(*                                                                   *)
(*  COMMENTS  : It should be called once, when first starting the    *)
(*              program.                                             *)
(*                                                                   *)
(*  INPUT PARAMETERS : none                                          *)
(*                                                                   *)
(*    VARIABLE    TYPE       DESCRIPTION                             *)
(*    ----------- ---------- ------------------------------------    *)
(*                                                                   *)
(*  GLOBAL VARIABLES :                                               *)
(*                                                                   *)
(*    VARIABLE           TYPE                                        *)
(*    -----------        ----------                                  *)
(*    FactoryOption      boolean                                     *)
(*    FAEOption          boolean                                     *)
(*    MaxColNo           int_x4                                      *)
(*    MaxDevicePin       int_x4                                      *)
(*    LogPhysMap         int_X4                                      *)
(*    LogicalIOMap       int_X4                                      *)
(*    MainIndex          int_X4                                      *)
(*    MaxRoutePass       int_X4                                      *)
(*    NoCompIndex        int_X4                                      *)
(*    NoRecordType       int_X4                                      *)
(*    OperatorIndex      int_X4                                      *)
(*    PDFChecksum        int_X4                                      *)
(*    Routed             boolean                                     *)
(*    RoutePassCount     int_X4                                      *)
 
{vax [GLOBAL] vax}
procedure initglobal;
 
  begin  (* InitGlobal *)
    {dsy  dsyinit;  dsy}
    factoryoption       := initfactoryoption;
    faeoption           := initfaeoption;
    maxcolno            := initmaxcolno;
    maxdevicepin        := initmaxdevicepin;
    logphysmap          := initlogphysmap;
    logicaliomap        := initlogicaliomap;
    mainindex           := initmainindex;
    maxroutepass        := initmaxroutepass;
    nocompindex         := initnocompindex;
    norecordtype        := initnorecordtype;
    operatorindex       := initoperatorindex;
(*  PDSAuthor           := InitPDSAuthor;               *)
    pdfchecksum         := initpdfchecksum;
(*  PDSCompany          := InitPDSCompany;              *)
(*  PDSDate             := InitPDSDate;                 *)
{/dsy}    pdffilename         := initpdffilename;
    pdfid               := initpdfid;
    pdfsize             := initpdfsize;
(*  PDSFilename         := InitPDSFilename;             *)
(*  PDSXPLOT            := InitPDSXPLOT;                *)
(*  PDSVers             := InitPDSVers;                 *)
(*  PDSPattern          := InitPDSPattern;              *)
(*  PDSRevision         := InitPDSRevision;             *)
(*  PDSTitle            := InitPDSTitle;                *)
    rectypedef          := initrectypedef;
    routed              := initrouted;
    routepasscount      := initroutepasscount;
    zhalnamelen         := initzhalnamelen;
(*  ZHALName            := InitZHALName;                *)
    memoryblockinitialized
                        := initmemoryblock;
 
(* MEG 2/11/86 *)
(* initialize the .TRE handler... *)
    inittremod;
(* ... and the TRE traversal data *)
    freeidrec := nil;
 
(* initialize the message handler *)
(* M.E.G. 1/7/86 *)
(* MEG 7/8/86 bug #882 - one line removed *)
(* MEG 1/20/86 *)
    txtglobalstr := inittxtglobalstr;
    textinitialize;
 
(* MEG 2/3/86 *)
(* initialize the forced routing *)
    resetforceroute;
 
(* MEG 2/12/86 *)
(* initialize device data (equation) compression *)
    resetdatacompress;
 
  end;  (* InitGlobal *)
 
{dsy PROCEDURE DSYINIT;  dsy}
{dsy      var  i : integer; dsy}

{dsy     BEGIN   dsy}
{dsy       Returnflag:=0; ReturnStatus:=false; CountKeeper:=0;  dsy}
{dsy       ZGlobalError:=false; ZGlbErrList:=nil; ViaPointer:=0;  dsy}
{dsy       CurrentBlkLoc:=0; CurrentBlock:=0; CurrentPtrArray:=nil;  dsy}
{dsy       CurrentPtrArrayLink:=0; LastBlkLoc:=0; LastPtrArray:=nil;  dsy}
{dsy       LastPtrArrayLink:=0; TopPtrArray:=nil; PtrArrayLink:=0;  dsy}
{dsy       BlkPtrOffset:=0; BlockOffset:=0; MemBlkCtrlstatus:=0;  dsy}
{dsy       ArrayRows:=0; ArrayColumns:=0; HeadList:=0; TailList:=0;  dsy}
{dsy       MinCompAddr:=0; MaxCompAddr:=0; DAAComponentLoc:=0;  dsy}
{dsy       DAALineIndex:=0; RowPinCntKeeper:=0;  dsy}
{dsy       DAAPinAsscLevel:=0; DAAPinAsscCompLoc:=0; DAAPinAsscRowIndex:=0;  dsy}
{dsy       RecordCounter:=0; CurrentValue:=0; NextDown:=nil;  dsy}
{dsy       FR_index:=0; Force_route_failure:=false;   dsy}
{dsy       GarbList:=nil; CurrentList:=nil; FreeIDRec:=nil;FreeLink:=nil;  dsy}
{dsy       RowGroup:=0; NoOfLevels:=0; NoOfRows:=0; ArrRecType:=0;  dsy}
{dsy       ArrayAddress:=0; BuffPtr:=0; InComment:=false; LogIO_Pointer:=0;  dsy}
{dsy       PDFSpec:=0; PDFPin:=0; PDFCompAddr:=0; DAARowOrCol:=ROW;  dsy}
{dsy     END;  dsy}
 
(*
  
 
*)
(*                                                                   *)
(*1111111111111111111111111111111111111111111111111111111111111111111*)
(*                                                                   *)
(*  PROCEDURE : InitDeviceType                                       *)
(*  AUTHOR    : I. Taller                                            *)
(*  DATE      : 6/19/86                                              *)
(*  FUNCTION  : initializes global variables that are device         *)
(*              depended.                                            *)
(*                                                                   *)
(*  MODIFICATIONS :                                                  *)
(*    NAME        DATE       DESCRIPTION                             *)
(*    ----------- ---------- ------------------------------------    *)
(*    I. Taller   7/11/86    zhal24/20 changes			     *)
(*    I. Taller   8/15/86    init ZHALviaMapFile name		     *)
(*    M. Gzowski  10/13/86   change unused pad #'s for ZHAL2420	     *) {!! 2 !!}
(*    I. Taller   2/13/87    fixing bug in initdevicetype 	     *) {!! 3 !!}
(*                                                                   *)
(*  COMMENTS  :                                                      *)
(*                                                                   *)
(*  INPUT PARAMETERS :                                               *)
(*                                                                   *)
(*    VARIABLE    TYPE       DESCRIPTION                             *)
(*    ----------- ---------- ------------------------------------    *)
(*                                                                   *)
(*  GLOBAL VARIABLES :                                               *)
(*                                                                   *)
(*    VARIABLE           TYPE                                        *)
(*    -----------        ----------                                  *)
(*    DeviceType         ZHALDeviceType                              *)
(*    TrePinCount        int_x4                                      *)
(*                                                                   *)
(*                                                                   *)
 
{vax [GLOBAL] vax}
procedure initdevicetype;

(* MEG 10/13/86 *) {!! 2 !!}
const
    zhal2420pin2  = 2;
    zhal2420pin9  = 9; {!! 2 !!}
    zhal2420pin15 = 15; {!! 2 !!}
    zhal2420pin22 = 22; {!! 2 !!}
    initpinname = ' NC ';
var
        zhaldevname: zhalstring;
	offset, {!! 3 !!}
        pinindex1,
        pinindex2: 0..maxzhalpinno;
        temppinlist: array[1..maxzhalpinno] of trepinname;
 
(*
  *)
    (*222222222222222222222222222222222222222222222222222222222222222*)
    (*                                                               *)
    (*  PROCEDURE : CnvtTreStr                                       *)
    (*  AUTHOR    : I. Taller                                        *)
    (*  DATE      : 7/2/86                                           *)
    (*  FUNCTION  : Converts string of type TreStr to a (returned)   *)
    (*              string of type ZHALstring                        *)
    (*                                                               *)
    (*  MODIFICATIONS :                                              *)
    (*    NAME        DATE       DESCRIPTION                         *)
    (*    ----------- ---------- ----------------------------------  *)
    (*                                                               *)
    (*  COMMENTS  :                                                  *)
    (*                                                               *)
    (*  INPUT PARAMETERS :                                           *)
    (*    VARIABLE    TYPE       DESCRIPTION                         *)
    (*    ----------- ---------- ----------------------------------  *)
    (*    InString    TreStr     a string of type TreStr             *)
    (*                                                               *)
 
    function cnvttrestr ( instring : trestr ) : zhalstring;
 
      var temp : zhalstring;
          i    : integer;
          c    : char;
 
      begin
      (* start at the beginning *)
        i := 1;
 
      (* move each character from the old string to the new string *)
        while ( i <= zhalstringlen )
         and ( i <= treXstrlen )
         do begin
           c := instring[i];
           if c in ['a'..'z'] then c := chr(ord(c) - ord('a') + ord('A'));
           temp[i] := c;
           i := succ(i);
          end; (*while...do*)
        if i < zhalstringlen
         then for i := i to zhalstringlen
          do temp[i] := blank;
 
        cnvttrestr := temp;
      end; (*CnvtTreStr*)
 
(*
*)
 
(*1111111111111111111111111111111111111111111111111111111111111111111*)
(* ----------------- InitDeviceType ---------------------------------*)
 
begin
 
(* get the chip name from the TRE file *)
zhaldevname := cnvttrestr( treheader.treXchipname);
 
(* and/or according to number of device in the TRE file  *)
 
(* try to decide the device type according to the chipname in the TRE file *)
(* MEG 10/13/86 *) {!! 2 !!}
if (zhaldevname = zhal24devname) then
                        devicetype := zhal24
  else if (zhaldevname = zhal20devname) then
                        devicetype := zhal20
    else if (zhaldevname = zhal2024devname) or
            (zhaldevname = zhal2420devname) then
                        devicetype := zhal20X24
 
(* try to decide the device type according to the device pin number *)
        else if (trepincount = zhal24pinno) then
                        devicetype := zhal24
          else if (trepincount = zhal20pinno) then
                        devicetype := zhal20
 
                else zglobalerr(intdevtype, nili);
 
 
if not zglobalerror then
        case devicetype of
 
          zhal24: begin
                 maxcolno := zhal24colno;
                 maxdevicepin := zhal24pinno;
                 maxtermids := zhal24maxterm;
                 maxprodtermcount := zhal24maxterm;
                 zhalviamapfile := zhal24viamapfile;
                end;
 
          zhal20: begin
                 maxcolno := zhal20colno;
                 maxdevicepin := zhal20pinno;
                 maxtermids := zhal20maxterm;
                 maxprodtermcount := zhal20maxterm;
                 zhalviamapfile := zhal20viamapfile;
                end;
 
	  zhal20X24: begin

(* ZHAL24/20 is treated like ZHAL24. The only differance is that in       *)	
(* ZHAL24/20 four pins are not used, so we map the ZHAL24/20 pins to 	  *)
(* the ZHAL24 pins. This is done by shifting the TrePinList that contains *)
(* the names of the device pins.    					  *)


(* init TempListPin as not connected *)
		for pinindex1 := 1 to zhal24pinno do
		begin
		    for pinindex2 := 0 to treXidlen do
		    	temppinlist[pinindex1][pinindex2] := blank;
		    temppinlist[pinindex1][1] := 'N';
		    temppinlist[pinindex1][2] := 'C';
		end;

(* shift TrePinList to TempPinList *)
		offset := 0;  pinindex2 := 1; {!! 3 !!}
		for pinindex1 := 1 to trepincount do
		begin
		    pinindex2 := pinindex1 + offset; {!! 3 !!}
		    if (pinindex2 = zhal2420pin2) or (pinindex2 = zhal2420pin9) {!! 3 !!}
		       	or (pinindex2 = zhal2420pin15) or {!! 3 !!}
			(pinindex2 = zhal2420pin22) then {!! 3 !!}
				offset := offset + 1; {!! 3 !!}
		    temppinlist[pinindex1 + offset] := trepinlist[pinindex1]; {!! 3 !!}
		end;

(* move TempPinList into TrePinList  *)
		for pinindex1 := 1 to zhal24pinno do
		    trepinlist[pinindex1] := temppinlist[pinindex1];

(* init the device depended variables  *)
		 trepincount := zhal24pinno;
		 maxcolno := zhal24colno;
		 maxdevicepin := zhal24pinno;
		 maxtermids := zhal24maxterm;
		 maxprodtermcount := zhal24maxterm;
                 zhalviamapfile := zhal24viamapfile;

	    end;


        end; (* of case *)
 
end;
 
 
 
(*
  
  
*)
(*                                                                   *)
(*1111111111111111111111111111111111111111111111111111111111111111111*)
(*                                                                   *)
(*  PROCEDURE : InitDeviceData                                       *)
(*  AUTHOR    : Boris B. Shih                                        *)
(*  DATE      : 11/8/85                                              *)
(*  FUNCTION  : initializes or reset, depending upon parameters,     *)
(*              the device data to make it ready for the next        *)
(*              routing level.                                       *)
(*                                                                   *)
(*  MODIFICATIONS :                                                  *)
(*    NAME        DATE       DESCRIPTION                             *)
(*    ----------- ---------- ------------------------------------    *)
(*    M.Gzowski   1/5/86     Minor fixes before release.             *)
(*    M.Gzowski   1/21/86    Major changes, subroutine added.        *)
(*                                                                   *)
(*  COMMENTS  :                                                      *)
(*                                                                   *)
(*  INPUT PARAMETERS : (level of initialization)                     *)
(*                                                                   *)
(*    VARIABLE    TYPE       DESCRIPTION                             *)
(*    ----------- ---------- ------------------------------------    *)
(*    M. Gzowski  2/10/86    moved variable k to ClearConnect        *)
(*                                                                   *)
(*  GLOBAL VARIABLES :                                               *)
(*                                                                   *)
(*    VARIABLE           TYPE                                        *)
(*    -----------        ----------                                  *)
(*    NoRecordType       int_X4                                      *)
(*                                                                   *)
 
{vax [GLOBAL] vax}
procedure initdevicedata;
 
(* error bailout *)
  label
        999;
 
  var
(* MEG 2/10/86 *)
      i,
      j                : intXx4;
      tempcomponentcls,
      tempnocomponents,
      tempcitlocation,
      tempcomponentloc,
      tempinputdef,
      tempoutputdef    : intXx4;
 
 
 
 
  (*
 *)
  (*                                                                 *)
  (*22222222222222222222222222222222222222222222222222222222222222222*)
  (*                                                                 *)
  (*  PROCEDURE : ClearConnect                                       *)
  (*  AUTHOR    : Michael Gzowski                                    *)
  (*  DATE      : 1/21/86                                            *)
  (*  FUNCTION  : this clears the input or output connections for    *)
  (*              a given component.                                 *)
  (*                                                                 *)
  (*  MODIFICATIONS :                                                *)
  (*    NAME        DATE       DESCRIPTION                           *)
  (*    ----------- ---------- ------------------------------------  *)
  (*    M. Gzowski  2/10/86    made variable k routine local.        *)
  (*                                                                 *)
  (*  COMMENTS  :                                                    *)
  (*                                                                 *)
  (*  INPUT PARAMETERS : (level of initialization)                   *)
  (*                                                                 *)
  (*    VARIABLE    TYPE       DESCRIPTION                           *)
  (*    ----------- ---------- ------------------------------------  *)
  (*    CompLoc     int_X4     the given component (location)        *)
  (*    ConnectCnt  int_X4     the number of inputs or outputs       *)
  (*    ConnectType IOSpecifier inputs or outputs?                   *)
  (*    CompCls     int_X4     the Component_Class of the component  *)
  (*                                                                 *)
  procedure clearconnect ( comploc : intXx4;
                           connectcnt : intXx4;
                           connecttype : iospecifier;
                           compcls : intXx4 );
 
    (* set the error bailout point *)
    label
        999;
    var
      tempiotype       : iotype;
    (* MEG 2/10/86 *)
      k                : intXx4;
 
    begin (*ClearConnect*)
 
    (* make sure that there is something to clear *)
      if connectcnt > 0
       then begin
 
    (* clear each connections *)
         for k := 0 to pred(connectcnt) do
          begin
            if zglobalerror then goto 999;
            tempiotype := getconnection ( comploc, connecttype, k );
            tempiotype[flag] := abs(tempiotype[flag]);
            putconnection ( comploc, connecttype, k, tempiotype );
 
    (* in the case of an Array Component, clear each row for the outputs *)
            if ( compcls = ccXarray ) and ( connecttype = outputcomp )
             then clrarrayline ( comploc, k, row);
           end; (* 0..TempInputDef *)
        end; (*if...then*)
    999:;
    end;  (*ClearConnect*)
 
 
(*
 *)
(*1111111111111111111111111111111111111111111111111111111111111111111*)
(*----------------- Main Flow of InitDeviceData ---------------------*)
  begin  (* InitDeviceData *)
    if not zglobalerror
     then begin
  
(* clear all RecordTypes referenced in the Main Index Table *)
       for i := 0 to pred(norecordtype) do
          begin
            tempcomponentcls := examinemitrec (i, componentXclass);
            tempnocomponents := examinemitrec (i, nocomponents);
            tempcitlocation := examinemitrec (i, citlocation);
            tempinputdef := qtycomppin (i, inputcomp);
            tempoutputdef := qtycomppin (i, outputcomp);
            if zglobalerror then goto 999;
 
(* MEG 1/21/86 *)
(* clear all components of a given RecordType *)
            for j := 0 to pred(tempnocomponents) do
             begin
               tempcomponentloc := getcomponentloc ( i, j );
               if zglobalerror then goto 999;
 
(* clear all inputs to the component *)
               clearconnect ( tempcomponentloc,
                              tempinputdef,
                              inputcomp,
                              tempcomponentcls );
 
(* clear all outputs to the component *)
               clearconnect ( tempcomponentloc,
                              tempoutputdef,
                              outputcomp,
                              tempcomponentcls );
              end;  (* 0..NoComponents *)
          end;  (* 0..NoRecordType *)
     end; (*if...then*)
 
(* clear the pin usage map *)
   for i := mindevicepin to maxdevicepin
    do pinused[i] := false;
 
999:;
  end;  (* InitDeviceData *)
{vax end. vax}(* ZGlbInit module *)
