{**  DEC/CMS REPLACEMENT HISTORY, Element ZFORCE.SRC **}
{**  *2     7-NOV-1986 08:34:49 PALASM2 "unix changes. FITFEEDBACK already defined."**}
{**  *1    10-OCT-1986 08:59:07 PALASM2 "" **}
{**  DEC/CMS REPLACEMENT HISTORY, Element ZFORCE.SRC **}
(*                                                                   *)
(*  (c) copyright Monolithic Memories, Inc. , 1986		     *)
(*                                                                   *)
(* MEG 2/10/86 *)
{vax  %include 'pal2$inc:z24global.inc' vax}
{vax  module ZForce;        vax}


#include 'csopeninc.i'
#include 'ctre.i'
#include 'ctxtio.i'
#include 'fnxinc.i'
#include 'z24.i'


{ipp program ZForce; ipp}
{ipp pragma On(Externals_allowed_internally); ipp}
{ipp pragma C_include('ctre.inc'); ipp}
{ipp pragma C_include('ctxtio.inc'); ipp}
{ipp pragma C_include('fnxinc.inc'); ipp}
{ipp pragma C_include('z24.inc'); ipp}


(*-------------------------------------------------------------------*)
(*                                                                   *)
(*  MODULE    :  ZForce                                              *)
(*  AUTHOR    :  Pseudo code: M.G. Code : C.J.                       *)
(*  DATE      :  12/19                                               *)
(*  FUNCTION  :  Routines in this module are related to force routing*)
(*                                                                   *)
(*  MODIFICATIONS :                                                  *)
(*    NAME        DATE       DESCRIPTION                             *)
(*    ----------- ---------- ------------------------------------    *)
(*    C.J.        12/19      initial release			     *)
(*    M. Gzowski  2/3/86     debug fixes			     *)
(*    M. Gzowski  2/10/86    fixed module header and trailer	     *)
(*    M. Gzowski  2/19/86    corrected error calls		     *)
(*    M. Gzowski  2/26/86    debug fixes                             *)
(*    M. Gzowski  3/4/86     debug fixes                             *)
(*    CJ          4/11/86    debug fixes                             *)
(*    M. Gzowski  4/18/86    bug fix for #793			     *)
(*    M. Gzowski  5/20/86    fix to flow in MoveToRange and 	     *)
(*			     ProcessGate routines		     *)
(*                                                                   *)
(*    CJ Chien    6/27/86    Modification to cover 20.g03 tricky case*)
(*                           This change will only work for zhal20 and*)
(*                           zhal24. We made this decision because of*)
(*                           time and effort concern                 *)
(*    M. Gzowski  7/15/86    fix to allow CC_Tristate in GoToOrGate  *)
(*    M. Gzowski  9/19/86    fix ConnOr for FF_Fan_io 		     *)
(*    CJ          9/23/86    Modify ConnNext to connect proper gate  *)
(*    M. Gzowski  9/25/86    Added FitFeedback			     *)
(*  COMMENTS  :                                                      *)
(*                                                                   *)
(*  NOTES     :                                                      *)
(*                                                                   *)
(*  EXTERNAL DECLARATIONS :                                          *)
(*                                                                   *)
(*  GLOBAL DECLARATIONS :                                            *)
(*  const                                                            *)
(*  FRRangeFullUsed =                                                *)
(*  FREquationTooLarge =                                             *)
(*  FRTermTooLarge =                                                 *)
(*  FrRangeDNE =                                                     *)
(*  TriStSelErr =                                                    *) 
(*  FRErrFindColumnNo =                                              *)
(*                                                                   *)
(*  var                                                              *)
(*  Force_Route_failure : boolean;                                   *)
(*  FR_Index : int_x4;                                               *)
(*                                                                   *)
(*  EXTERNAL DECLARATIONS:                                           *)
(*  The following routines are declared in this module external to   *)
(*  all other modules                                                *)
(*  GateAlign                      FitTerm                           *)
(*  ResetForceRoute                                                  *)
(*                                                                   *)
(*  The following routines are declared only for this module use     *)
(*  ProcessGate                    KeyRange                          *)
(*  InRange                                                          *)
(*                                                                   *)
(*-------------------------------------------------------------------*)

(* 6/27/86 CJ Chien*)
const gateclusterfactor = 3;

type  preinforec = record
                    devpin : intXx4;
                    left   : boolean;
                   end;
var   preinfo : preinforec;
(**)
(*                                                                   *)
(*-------------------------------------------------------------------*)
(*                                                                   *)
(*  PROCEDURE : GateAlign                                            *)
(*  AUTHOR    : CJ Chien                                             *)
(*  DATE      : 6/27/86                                              *)
(*  FUNCTION  : To Gate And2 gate to one which associates to a new   *)
(*              OR gate                                              *)
(*                                                                   *)
(*  MODIFICATIONS :                                                  *)
(*    NAME        DATE       DESCRIPTION                             *)
(*    ----------- ---------- ------------------------------------    *)  
(*    CJ Chien    12/19/85    initial release                        *)
(*    MEG         2/3/86      debug rewrite                          *)
(*    CJ Chien    3/6/86      remove gate align to adjust to And2 gate*)
(*    CJ Chien    6/27/86     recover gate align for 24.g05 case     *)        
(*                                                                   *)
(*  COMMENTS  :                                                      *)
(*                                                                   *)
(*  INPUT PARAMETERS :                                               *)
(*                                                                   *)
(*    VARIABLE    TYPE       DESCRIPTION                             *)
(*    ----------- ---------- ------------------------------------    *)
(*                                                                   *)
procedure gatealign;
begin
     frXindex := frXindex + ((gateclusterfactor - 
                (frXindex mod gateclusterfactor)) mod gateclusterfactor); 
end;

(*                                                                   *)
(*-------------------------------------------------------------------*)
(*                                                                   *)
(*  PROCEDURE : InitPreInfo                                          *)
(*  AUTHOR    : CJ Chien                                             *)
(*  DATE      : To initialize the previous information record for    *)
(*              gate align purpose                                   *)
(*  FUNCTION  : To initialize the previous record for gate align     *)
(*                                                                   *)
(*  MODIFICATIONS :                                                  *)
(*    NAME        DATE       DESCRIPTION                             *) 
(*    ----------- ---------- ------------------------------------    *)
(*    CJ Chien    6/27/86    initial release                         *)  
(*                                                                   *)
(*  COMMENTS  :                                                      *)
(*                                                                   *)
(*  INPUT PARAMETERS :                                               *)
(*                                                                   *)
(*    VARIABLE    TYPE       DESCRIPTION                             *)
(*    ----------- ---------- ------------------------------------    *)
(*                                                                   *)
procedure initpreinfo;

begin
      with preinfo do
        begin
             devpin := 0;
             left   := false;
        end;
end;

(**)
(*1111111111111111111111111111111111111111111111111111111111111111111*)
(*                                                                   *)
(*  PROCEDURE : ResetForceRoute                                      *)
(*  AUTHOR    : C.J.                                                 *)
(*  DATE      : 12/21                                                *)
(*  FUNCTION  : To initalize variables for force routing use         *)
(*                                                                   *)
(*  MODIFICATIONS :                                                  *)
(*    NAME        DATE       DESCRIPTION                             *)
(*    ----------- ---------- ------------------------------------    *)  
(*    cj          12/21      initial release                         *)
(*    CJ          6/27/86    add initial previous information call   *)
(*                                                                   *)
(*  COMMENTS  :                                                      *)
(*                                                                   *)
(*  INPUT PARAMETERS :                                               *)
(*                                                                   *)
(*    VARIABLE    TYPE       DESCRIPTION                             *)
(*    ----------- ---------- ------------------------------------    *)
(*1111111111111111111111111111111111111111111111111111111111111111111*)
{vax [global] vax} 
procedure resetforceroute;
begin (*RESETFORCEROUTE*)
     frXindex := 0;
     forceXrouteXfailure := initXforcedXrouteXfailure;
     initpreinfo;
end; (*RESETFORCEROUTE*)

(**)
(*                                                                   *)
(*-------------------------------------------------------------------*)
(*                                                                   *)
(*  PROCEDURE : ChangeFlag                                           *)
(*  AUTHOR    : CJ Chien                                             *)
(*  DATE      : 6/11/86                                              *)
(*  FUNCTION  : Change the flag in IO Record to be used flag         *)
(*                                                                   *)
(*  MODIFICATIONS :                                                  *)
(*    NAME        DATE       DESCRIPTION                             *)
(*    ----------- ---------- ------------------------------------    *)  
(*    CJ Chien    6/11/86    initial release                         *)
(*                                                                   *)
(*  COMMENTS  :                                                      *)
(*                                                                   *)
(*  INPUT PARAMETERS :                                               *)
(*                                                                   *)
(*    VARIABLE    TYPE       DESCRIPTION                             *)
(*    ----------- ---------- ------------------------------------    *)
(*    IORec       IOType                                             *)
(*                                                                   *)
procedure changeflag(var iorec : iotype);
begin (* ChangeFlag *)
         if (iorec[flag] > vln) 
              then  iorec[flag] := -(iorec[flag] - vln)
              else if (iorec[flag] < vln)
                     then iorec[flag] := -(iorec[flag]+vln)
                     else iorec[flag] := -iorec[flag];
end; (* ChangeFlag *)

(**)
(*1111111111111111111111111111111111111111111111111111111111111111111*)
(*                                                                   *)
(*  PROCEDURE : MakeConnection					     *)
(*  AUTHOR    : M. Gzowski					     *)
(*  DATE      : 3/19/86						     *)
(*  FUNCTION  : flags the specified connection as used.              *)
(*                                                                   *)
(*  MODIFICATIONS :                                                  *)
(*    NAME        DATE       DESCRIPTION     			     *)
(*    ----------- ---------- --------------------------------------  *)  
(*    MEG                     initial release                        *)  
(*    CJ          4/3/86      debug                                  *)
(*    M.Gzowski   9/25/86     made top level procedure               *)
(*								     *)
(*  COMMENTS  :                                                      *)
(*                                                                   *)
(*  INPUT PARAMETERS :                                               *)
(*                                                                   *)
(*    VARIABLE    TYPE       DESCRIPTION                             *)
(*    ----------- ---------- --------------------------------------  *)
(*    CompLoc       int_X4      the destination component location   *)
(*    CompPinNumber int_X4      the offset of the destination        *)
(*				  component input 		     *)
(*    ErrorCode     int_X4      the errorcode used if failure	     *)
(*    DevicePin     int_X4      used with ErrorCode		     *)
(*1111111111111111111111111111111111111111111111111111111111111111111*)
  procedure makeconnection ( comploc 		: intXx4;
			     comppinnumber 	: intXx4;
                             errorcode     	: intXx4;
                             devicepin     	: intXx4 );

    var
	tempconnect,
	tempconnect2 : iotype;
  
    begin

    (* check if the component has been used already *)
      if not connectfull( comploc, inputcomp )
   
    (* connect the indicated input *)
       then begin
         tempconnect := getconnection ( comploc, inputcomp, comppinnumber );
         tempconnect[flag] := -tempconnect[flag];
         putconnection ( comploc, inputcomp, comppinnumber, tempconnect );

    (* connect the corresponding output...          *)
    (* ...checking if the component connect is free *)
         tempconnect[flag] := pred( abs(tempconnect[flag]) mod vln );
         if not connectfull( tempconnect[nextXcomponent], outputcomp )
          then begin
            tempconnect2 := getconnection ( tempconnect[nextXcomponent], 
                                           outputcomp, 
                                           tempconnect[flag] );
            tempconnect2[flag] := -tempconnect2[flag];
            putconnection ( tempconnect[nextXcomponent], 
                            outputcomp, 
                            tempconnect[flag],
                            tempconnect2 );
           end (*if...then*)


    (* cannot make the connection *)
          else zglobalerr ( errorcode, devicepin );
        end (*if...then*)
       else zglobalerr ( errorcode, devicepin );
    end; (*MakeConnection*)

 
(**)
(*1111111111111111111111111111111111111111111111111111111111111111111*)
(*                                                                   *)
(*  PROCEDURE : FitTriCondition					     *)
(*  AUTHOR    : M. Gzowski					     *)
(*  DATE      : 3/19/86						     *)
(*  FUNCTION  : this procedure makes the appropriate connections to  *)
(*              correspond with the passed DevicePin and case        *)
(*              selection.  					     *)
(*                                                                   *)
(*  MODIFICATIONS :                                                  *)
(*    NAME        DATE       DESCRIPTION                             *)
(*    ----------- ---------- ------------------------------------    *)  
(*    MEG         3/20/86    initial release                         *)
(*    CJ          3/21/86    debug syntax error                      *)
(*    MEG         4/7/86     debug changes			     *)
(*    CJ          6/18/86    add tristtype                           *)
(*    M.Gzowski   9/25/86    remove nested proc. MakeConnection	     *)
(*                                                                   *)
(*  COMMENTS  :                                                      *)
(*                                                                   *)
(*  INPUT PARAMETERS :                                               *)
(*                                                                   *)
(*    VARIABLE    TYPE       DESCRIPTION                             *)
(*    ----------- ---------- ------------------------------------    *)
(*    DevicePin   int_X4      the device pin used		     *)
(*    TriStSwitch TriStSelect selects the type of tristate enable:   *)
(*			       -equation 			     *)
(*			       -enable pin			     *)
(*			       -VCC				     *)
(*			       -GND				     *)
(*                                                                   *)
(*1111111111111111111111111111111111111111111111111111111111111111111*)
{vax   [global]  vax}
 procedure fittricondition ;  

  const 
        pinlevel     =  0; 
  var
	i : intXx4;
	noofcomps,
	selectedcomp : intXx4;
        noofpin : intXx4;
        devpinmatch : boolean;
	assocdevpin : intXx4;
        tristrectype: intXx4;

  begin (*FitTriCondition*)

  (* set the initial values *)
    tristrectype := getop(tristateop,opcomponentref);
    noofcomps := examinemitrec ( tristrectype, nocomponents );
    i := pred (minnocomp);
    devpinmatch := false;
  (* get the offset to the correct component for the associated device pin *)
    while ( i < pred( noofcomps ) ) 
     and not devpinmatch
      do begin
        i := succ (i);
        repeat 
          assocdevpin := getpinassoct( tristrectype, i, pinlevel );
          if not devpinmatch
           then devpinmatch := ( assocdevpin = devicepin );
         until assocdevpin = nomoredevpinassc;
       end; (*while...do*)

  (* get and connect the indicated input...           *)
  (* ... or flag an error that no component was found *)
    if devpinmatch
     then begin 
       selectedcomp := getcomponentloc ( tristrectype, i );
(* MEG 9/25/86 *)
       makeconnection ( selectedcomp, 
                        ord( tristswitch ), 
                        tristselerr,
                        devicepin );
      end (*if...then*)
     else
      zglobalerr ( tristselerr, devicepin )

  end;  (*FitTriCondition*)
(**)
(*1111111111111111111111111111111111111111111111111111111111111111111*)
(*                                                                   *)
(*  PROCEDURE : FitFeedback					     *)
(*  AUTHOR    : M. Gzowski					     *)
(*  DATE      : 9/25/86						     *)
(*  FUNCTION  : this procedure makes the appropriate connections to  *)
(*              feedback component corresponding with the passed     *)
(*              DevicePin and case selection.  			     *)
(*                                                                   *)
(*  MODIFICATIONS :                                                  *)
(*    NAME        DATE       DESCRIPTION                             *)
(*    ----------- ---------- ------------------------------------    *)  
(*    MEG         9/25/86    initial release copied from 	     *)
(*			      FitTriCondition                        *)
(*                                                                   *)
(*  COMMENTS  :                                                      *)
(*                                                                   *)
(*  INPUT PARAMETERS :                                               *)
(*                                                                   *)
(*    VARIABLE    TYPE       DESCRIPTION                             *)
(*    ----------- ---------- ------------------------------------    *)
(*    CITIndex    int_X4      the CIT index of the component	     *)
(*    AssocPin    int_X4      the association for the component	     *)
(*    DevicePin   int_X4      the device pin used		     *)
(*    FeedbackUsage ColumnUsage shows which components have been used*)
(*                                                                   *)
(*1111111111111111111111111111111111111111111111111111111111111111111*)
{vax   [global]  vax}
 procedure fitfeedback ;   {!! 2 !!}

  var
	selectedcomp : intXx4;
        fbrectype: intXx4;
        fbswitch:  feedbackselect;

  begin (*FitFeedback*)
 
  (* if the component has not been set used yet *)
    if not feedbackusage[citindex]
     then begin
  (* set the initial values *)
       fbrectype := getop(feedbackop,opcomponentref);
       selectedcomp := getcomponentloc ( fbrectype, citindex );

  (* check that the component is not being used illegally *)
       if (assocpin = devicepin) or not devpins[devicepin].registered
        then begin
          if assocpin = devicepin
           then begin
             if devpins[devicepin].registered
              then fbswitch := regcase
              else fbswitch := noshiftcase;
            end (*if...then*)
           else begin
             if assocpin = succ(devicepin)
              then fbswitch := shiftupcase
              else fbswitch := shiftdowncase;
            end; (*else*)
          makeconnection ( selectedcomp,
                           ord( fbswitch ),
                           feedbackselerr,
   		           devicepin );
          feedbackusage[citindex] := true;
         end (*if...then *)
        else
         zglobalerr ( feedbackselerr, devicepin );

      end; (*if...then*)

  end;  (*FitFeedback*)

(**)
(*1111111111111111111111111111111111111111111111111111111111111111111*)
(*                                                                   *)
(*  PROCEDURE : InRange                                              *)
(*  AUTHOR    : C.J.                                                 *)
(*  DATE      : 12/19/85                                             *)
(*  FUNCTION  : to check if the index is in the selected range or not*)
(*                                                                   *)
(*  MODIFICATIONS :                                                  *)
(*    NAME        DATE       DESCRIPTION                             *)
(*    ----------- ---------- ------------------------------------    *)  
(*    CJ          12/19/85   initial release                         *)
(*                                                                   *)
(*  COMMENTS  :                                                      *)
(*                                                                   *)
(*  INPUT PARAMETERS :                                               *)
(*                                                                   *)
(*    VARIABLE    TYPE       DESCRIPTION                             *)
(*    ----------- ---------- ------------------------------------    *)
(*    INDEX       INT_X4                                             *)
(*    CHECKRANGE  RANGE                                              *)
(*                                                                   *)
(*1111111111111111111111111111111111111111111111111111111111111111111*)
function inrange(index: intXx4;
                 checkrange:range) : boolean;
begin (*INRANGE*)

      if (index >= checkrange.low) and (index <= checkrange.high)
       then 
           inrange := true
       else
           inrange := false
end; (*INRANGE*)
(**)
(*1111111111111111111111111111111111111111111111111111111111111111111*)
(*                                                                   *)
(*  PROCEDURE : KeyRange                                             *)
(*  AUTHOR    : C.J.                                                 *)
(*  DATE      : 12/19                                                *)
(*  FUNCTION  : SELECT THE PROPER RANGE                              *)
(*                                                                   *)
(*  MODIFICATIONS :                                                  *)
(*    NAME        DATE       DESCRIPTION                             *)
(*    ----------- ---------- ------------------------------------    *)  
(*    M.Gzowski   2/3/86     removed magic numbers		     *)
(*    M.Gzowski   3/4/86     correct potential bug                   *)
(*                                                                   *)
(*  COMMENTS  :                                                      *)
(*                                                                   *)
(*  INPUT PARAMETERS :                                               *)
(*                                                                   *)
(*    VARIABLE    TYPE       DESCRIPTION                             *)
(*    ----------- ---------- ------------------------------------    *)
(*    TERM        TERMREC    A COMPLETE TERM                         *)
(*                                                                   *)
(*1111111111111111111111111111111111111111111111111111111111111111111*)
function keyrange(term: termrec): range;
var pinno : intXx4;
    level : intXx4;
    temprange : range;
begin
(* choose the level depends on the operator *)
      pinno := term.devpin;
      if term.trstnode
       then 
            level := tristassoc
       else
            if term.xornode
             then
                 if term.left
                   then 
                        level := xorassoc
                   else
                        level := -xorassoc
             else
                 if term.ornode
                  then 
                      level := orassoc
                  else
                      level := orassoc;
(* SELECT THE LOW AND HIGH LIMIT OF THE RANGE REGARDING TO DEVICE PIN *)
      if level > 0
       then
           begin
(* get primary  range, if it exists *)
            if devpins[pinno].levelrange = nil
              then zglobalerr(frrangedne, pinno)
              else
                   begin
                       temprange.low := devpins[pinno].levelrange^[level].low;
                       temprange.high := devpins[pinno].levelrange^[level].high;
                       keyrange := temprange;
                   end (* else *)
           end
       else
           begin
(* get secondary range, if it exists *)
             if devpins[pinno].levelrange2nd = nil
               then zglobalerr(frrangedne,pinno)
               else begin
                    temprange.low := devpins[pinno].levelrange2nd^[abs(level)].low;
                    temprange.high:= devpins[pinno].levelrange2nd^[abs(level)].high;
                    keyrange := temprange;
                    end; (* else *)
           end
end; (* KEYRANGE *)
          
(**)
(*1111111111111111111111111111111111111111111111111111111111111111111*)
(*                                                                   *)
(*  PROCEDURE : MoveToRange 					     *)
(*  AUTHOR    : Michael Gzowski					     *)
(*  DATE      : 2/3/86						     *)
(*  Function  : this procedure put the force routing index, FR_Index,*)
(*              into the given range, then aligns FR_Index on a gate *)
(*              boundary.					     *)
(*                                                                   *)
(*  MODIFICATIONS :                                                  *)
(*    NAME        DATE       DESCRIPTION                             *)
(*    ----------- ---------- ------------------------------------    *)
(*    M.G.        12//85      initial release                        *)
(*    C.J.        3/6/86      modification and remove gate align     *)   
(*    M Gzowski   4/11/86     check gate availablity 		     *)
(*    M Gzowski   5/20/86     modify flow, to avoid redundant 	     *)
(*			      flagging of error condition	     *)
(*    CJ CHIEN    6/27/86     MODIFICATION FOR GATE ALIGN            *)
(*                            and add eqterm parameter               *)
(*                                                                   *)
(*  COMMENTS  :                                                      *)
(*                                                                   *)
(*  INPUT PARAMETERS :                                               *)
(*                                                                   *)
(*    VARIABLE    TYPE       DESCRIPTION                             *)
(*    ----------- ---------- ------------------------------------    *)
(*    DevicePin   int_X4     the range Device Pin, for error messages*)
(*    TargetRange Range	     the range to move FR_Index to.	     *)
(*    KeyRecType  int_X4     the key record type for Eq fitting      *)
(*    EqTermSize  int_X4     the number of minterms in the term      *)
(*    EqTerm      TermRec    Term REcord to give the term info       *)
(*                                                                   *)
(*1111111111111111111111111111111111111111111111111111111111111111111*)
procedure movetorange ( devicepin   : intXx4;
			targetrange : range;
                        keyrectype  : intXx4;
                        eqtermsize  : intXx4;
                        eqterm      : termrec);

  (* MEG 5/20/86 *)
  var
	thetermfitshere	: boolean;

  (**)
  (*22222222222222222222222222222222222222222222222222222222222222222*)
  (*                                                                 *)
  (*  PROCEDURE : CurrentSize 					     *)
  (*  AUTHOR    : Michael Gzowski				     *)
  (*  DATE      : 4/11/86					     *)
  (*  Function  : get the maximum size of a term that can be placed  *)
  (* 		  on the gate referenced by the current FR_Index.    *)
  (*                                                                 *)
  (*  MODIFICATIONS :                                                *)
  (*    NAME        DATE       DESCRIPTION                           *)
  (*    ----------- ---------- ----------------------------------    *)
  (*                                                                 *)
  (*  COMMENTS  :                                                    *)
  (*                                                                 *)
  (*  INPUT PARAMETERS :                                             *)
  (*                                                                 *)
  (*    VARIABLE    TYPE       DESCRIPTION                           *)
  (*    ----------- ---------- ----------------------------------    *)
  (*                                                                 *)
  (*22222222222222222222222222222222222222222222222222222222222222222*)
  function currentsize : intXx4;
    var
        connection : iotype;
        i, count : intXx4;
	devaddress : intXx4;
    begin

    (* initialize *)
      count := 0;
      devaddress := getcomponentloc(keyrectype,frXindex);

    (* get the number of available inputs *)
      for i := 0 to pred( qtycomppin (keyrectype, inputcomp) )
       do begin
         connection := getconnection ( devaddress, inputcomp, i );
         if ( connection[flag] > 0 ) and not zglobalerror
          then if ( 
                     connectsavail ( connection[nextXcomponent], outputcomp )
                   = qtycomppin ( getrecordtype( connection[nextXcomponent] ),
                                  outputcomp ) 
                  )
           then count := count + qtycomppin 
                                  ( getrecordtype (connection[nextXcomponent]),
                                    inputcomp );
        end; (*for...do*)

      currentsize := count;

    end; (*CurrentSize*)

(**)
(*1111111111111111111111111111111111111111111111111111111111111111111*)
(* -------------------- Main flow of MoveToRange --------------------*)
(*1111111111111111111111111111111111111111111111111111111111111111111*)

begin (*MoveToRange*)

(* MEG 2/27/86 *)
  if (targetrange.low = minpinassno)
     and (targetrange.high = minpinassno)
    then zglobalerr(frrangedne,devicepin)
(* the range contains something, now see if we can move to the range *)
    else begin

(* bring FR_Index to the range, if neccessary *)
  if frXindex <= targetrange.low
    then frXindex := targetrange.low;

  if eqterm.devpin <> preinfo.devpin
    then
        begin
            gatealign;
            preinfo.devpin := eqterm.devpin;
            preinfo.left   := eqterm.left;
        end
    else if eqterm.xornode and
            (eqterm.left <> preinfo.left)
              then
                   begin
                     gatealign;
                     preinfo.left := eqterm.left;
                   end;

(* MEG 4/11/86 *)
(* MEG 5/20/86 *)
(* find the first gate in the range that will support the equation term*)
(* loop conditions verify that *)
(*	1.  we are still in range, *)
(*	2.  the term still can't fit, and *)
(*	3.  no global has occurred *)
  thetermfitshere := false;
  while ( frXindex <= targetrange.high ) 
   and not thetermfitshere
   and not zglobalerror
    do if ( eqtermsize <= currentsize )
     then thetermfitshere := true
     else 
          frXindex := succ(frXindex);
(* Check if device pin changes or change term from left part of xor to right *)
(* part, if it is so, gate align and reset the previous info                 *)
                   

(* check that the index has not pasted the target range *)
  if frXindex > targetrange.high 
   then zglobalerr ( frrangefullused, devicepin )
        end; (* else *)
  

end;  (*MoveToRange*)

(**)
(*1111111111111111111111111111111111111111111111111111111111111111111*)
(*                                                                   *)
(*  PROCEDURE : FindColumnNo                                         *)
(*  AUTHOR    : C.J.                                                 *)
(*  DATE      : 2/20/86                                              *)
(*                                                                   *)
(*  Function  : Find Array column to a desired pin                   *)
(*  MODIFICATIONS :                                                  *)
(*    NAME        DATE       DESCRIPTION                             *)
(*    ----------- ---------- ------------------------------------    *)
(*    CJ          2/20/86     initial release                        *)  
(*                                                                   *)
(*  COMMENTS  :                                                      *)
(*                                                                   *)
(*  INPUT PARAMETERS :                                               *)
(*                                                                   *)
(*    VARIABLE    TYPE       DESCRIPTION                             *)
(*    ----------- ---------- ------------------------------------    *)
(*    pin         int_x4                                             *)
(*1111111111111111111111111111111111111111111111111111111111111111111*)

function findcolumnno(pin:  intXx4) : intXx4;
var count : intXx4;
    done  : boolean;
    temppinlink : pinlink;
begin (* findColumnNo *)
     done := false;
     count := -maxdevicepin; 
     while (count <= maxdevicepin) and (not done) do
     begin
            if (count = pin) and (not done)
              then
                   begin
                     done := true;
                     findcolumnno := columntable[count] -1;
                   end
              else
                   count := succ(count);
      end;
 
(* check error *)
      if not done
       then
           begin
                 forceXrouteXfailure := true;
                 zglobalerr(frerrfindcolumnno,pin);
           end;
end;
(**)
(*1111111111111111111111111111111111111111111111111111111111111111111*)
(*                                                                   *)
(*  PROCEDURE : AllocateTerm                                         *)
(*  AUTHOR    : C.J.                                                 *)
(*  DATE      : 3/6/86                                               *)
(*  FUNCTION  : To allocate Term IDs into the  Array                 *)
(*                                                                   *)
(*  MODIFICATIONS :                                                  *)
(*    NAME        DATE       DESCRIPTION                             *)
(*    ----------- ---------- ------------------------------------    *)  
(*    cj          3/6/86      initial release                        *)
(*    CJ          3/31/86     modification                           *)
(*    M. Gzowski  4/18/86     bug fix, new errorcode, #793	     *)
(*                                                                   *)
(*  COMMENTS  :                                                      *)
(*                                                                   *)
(*  INPUT PARAMETERS :                                               *)
(*                                                                   *)
(*    VARIABLE    TYPE       DESCRIPTION                             *)
(*    ----------- ---------- ------------------------------------    *)
(*    TermLink    IDLink                                             *)
(*    Addr        int_x4                                             *)
(*1111111111111111111111111111111111111111111111111111111111111111111*)
procedure allocateterm(var termlink : idlink;
                       addr     : intXx4);
const citindex = 0;
var noofinputs : intXx4;
    status     : intXx4; 
    andrectype : intXx4;
    done       : boolean;
    iorec      : iotype;
    connno     : intXx4;
    columnno   : intXx4;
    arrayrectype: intXx4;
    templink   : idlink;
    rowindex   : intXx4;
begin (* Allocate Term *)
       connno := 1;
       andrectype := getrecordtype(addr);
       noofinputs := qtycomppin(andrectype,inputcomp);
       while (connno <= noofinputs) 
           and (termlink <> nil) 
           and not zglobalerror do
             begin
(* To get the input for And1 Gate *)
                  iorec := getconnection(addr,inputcomp,connno-1);
(* if not used then put connection on it *)
                  if notused(iorec) and not zglobalerror 
                    then
                        begin
                          iorec[flag] := -(iorec[flag] - vln);
                          columnno := findcolumnno(termlink^.val);
                          arrayrectype := getop(andop,oparrayref);
                          arrayaddress := getcomponentloc(arrayrectype,citindex);
                          rowindex := abs(iorec[flag]) -1;
                          addlineintracon(arrayaddress,columnno,rowindex); 
                          putconnection(addr,inputcomp,connno-1,iorec);
(* MEG 4/18/86  bug # 793 *)
                          if zglobalerror
                           then zglobalerr ( failtoplacesig, abs(termlink^.val));
                          termlink := termlink^.next;
                        end;
                   connno := succ(connno);                  
              end; (* while *)
 end;  (* allocateterm *)          
                                    
(**)
(*1111111111111111111111111111111111111111111111111111111111111111111*)
(*                                                                   *)
(*  PROCEDURE : ConnectAndArray                                      *)
(*  AUTHOR    : C.J.                                                 *)
(*  DATE      : 3/6/86                                               *)
(*  FUNCTION  : To connect AND Gate 1 and Array Component            *)
(*                                                                   *)
(*  MODIFICATIONS :                                                  *)
(*    NAME        DATE       DESCRIPTION                             *)
(*    ----------- ---------- ------------------------------------    *)  
(*    cj          12/21      initial release                         *)
(*                                                                   *)
(*  COMMENTS  :                                                      *)
(*                                                                   *)
(*  INPUT PARAMETERS :                                               *)
(*                                                                   *)
(*    VARIABLE    TYPE       DESCRIPTION                             *)
(*    ----------- ---------- ------------------------------------    *)
(*    And1Addr    int_x4     address for and1 gate                   *)
(*    ConnNo      int_x4     Connnection offset in component record  *)
(*    TermLink    IDLink     Link of Equation ids                    *)   
(*1111111111111111111111111111111111111111111111111111111111111111111*)
procedure connectandarray(and1addr : intXx4;
                          connno   : intXx4;
                          var termlink : idlink);
var and1rectype : intXx4;
    status      : intXx4;
    noofoutputs : intXx4;
    iorec       : iotype;
begin (* ConnectAndArray *)

      and1rectype := getrecordtype(and1addr);      
      noofoutputs := qtycomppin(and1rectype,outputcomp); 

(* Connect the desired component specified by ConnNO *)
      if   ((connno >= 0) and (connno < noofoutputs)) 
       then
         begin
           iorec := getconnection(and1addr,outputcomp,connno);
           if notused(iorec)
              then
                  begin
(* expected a fixed connection here *)    
               if iorec[flag] > vln
                    then
                        iorec[flag] := -(iorec[flag]-vln)
                    else
                        if iorec[flag] > 0
                          then iorec[flag] := -iorec[flag]
                          else iorec[flag] := iorec[flag] + vln; 
                    putconnection(and1addr,outputcomp,connno,iorec);
                    allocateterm(termlink,and1addr);
                   end
              else
                   begin
                    zglobalerr(frerrconnectand2, nili);
                   end;
          end; (* if then *) 
end; (* ConnectAndArray *)      
      

(**)
(*1111111111111111111111111111111111111111111111111111111111111111111*)
(*                                                                   *)
(*  Procedure : ConnectAnd                                          *)
(*  AUTHOR    : C.J.                                                 *)
(*  DATE      : 3/6/86                                               *)
(*  FUNCTION  : To Connect And2 Gate and call ConnectAndArray to     *)
(*              connect array part                                   *) 
(*                                                                   *)
(*  MODIFICATIONS :                                                  *)
(*    NAME        DATE       DESCRIPTION                             *)
(*    ----------- ---------- ------------------------------------    *)  
(*    cj          3/6/21     initial release                         *)
(*    CJ          4/1/86     move routine to a new place and call    *)
(*                           ConnectAndArray                         *)
(*                                                                   *)
(*  COMMENTS  :                                                      *)
(*                                                                   *)
(*  INPUT PARAMETERS :                                               *)
(*                                                                   *)
(*    VARIABLE    TYPE       DESCRIPTION                             *)
(*    ----------- ---------- ------------------------------------    *)
(*    Addr        int_x4                                             *)
(*    IO          IOSpecifier                                        *)
(*    TermLink    IDLink                                             *) 
(*1111111111111111111111111111111111111111111111111111111111111111111*)
procedure connectand(addr:intXx4;
                     io:iospecifier;
                     var termlink:idlink);
var and2rectype : intXx4;
    and1addr    : intXx4;
    status      : intXx4;
    noofinputs  : intXx4;
    iorec       : iotype; 
    connno      : intXx4;
    connectsfree: intXx4;
    noofcomp    : intXx4;
begin (* ConnectAnd *)

      and2rectype := getrecordtype(addr);
      noofinputs := qtycomppin(and2rectype,inputcomp); 
      connno    := 0;
(* check each input  connection for the component *)
      while ((connno >= 0) and (connno < noofinputs)) and 
         (termlink <> nil ) do
      begin
            iorec := getconnection(addr,inputcomp,connno);

(* if there is no connection to be made yet, then change flag *)
            if (iorec[flag] > 0) and (iorec[flag] <= vln)
                 then
                  begin
                    connectsfree := connectsavail(iorec[nextXcomponent],outputcomp);
                    noofcomp := qtycomppin(getrecordtype(iorec[nextXcomponent]),outputcomp);
                    if connectsfree = noofcomp
                     then begin
                          iorec[flag] := -(iorec[flag]);
                          putconnection(addr,inputcomp,connno,iorec);
                          and1addr := iorec[nextXcomponent];
                          connectandarray(and1addr,abs(iorec[flag])-1,termlink);
                          end;
                end; (* if then *)
           connno := succ(connno); 
     end; (* while *)     

(* Expect termlink to be nil here *)
      if termlink <> nil 
             then
                     begin
                       forceXrouteXfailure := true;
                       zglobalerr(frerrallocateterm, nili);
                     end;               
end;                 
(**)
(*1111111111111111111111111111111111111111111111111111111111111111111*)
(*                                                                   *)
(*  PROCEDURE : ConnGate                                             *)
(*  AUTHOR    : C.J.                                                 *)
(*  DATE      : 3/20/86                                              *)
(*                                                                   *)
(*  Function  : Connect desired gate and with specification of       *)
(*              inputdef or outputdef                                *)   
(*  MODIFICATIONS :                                                  *)
(*    NAME        DATE       DESCRIPTION                             *)
(*    ----------- ---------- ------------------------------------    *)
(*    cj          3/19/86     initial release                        *)  
(*    CJ          4/11/86     debug fix				     *)
(*    CJ          6/27/86     bug fix                                *)
(*                                                                   *)
(*  COMMENTS  :                                                      *)
(*                                                                   *)
(*  INPUT PARAMETERS :                                               *)
(*                                                                   *)
(*    VARIABLE    TYPE       DESCRIPTION                             *)
(*    ----------- ---------- ------------------------------------    *)
(*    Addr        int_x4                                             *)
(*    LastAddr    int_X4                                             *)
(*    IO          MITField                                           *)
(*1111111111111111111111111111111111111111111111111111111111111111111*)
procedure conngate(addr: intXx4; 
                   lastaddr:intXx4;
                   io:mitfield);
var comprectype : intXx4;
    noofio     : intXx4; 
    connno     : intXx4;
    found      : boolean;
    iorec      : iotype;
begin
(* find the REcord type of the component and no of io *)
      found := false;
      comprectype := getrecordtype(addr);
      case io of
      inputdef : noofio := qtycomppin(comprectype,inputcomp);
      outputdef: noofio := qtycomppin(comprectype,outputcomp);
      end;
      connno := 0;

(* find a desired one and make the connection *)
      while (connno <noofio) and (not found) do
      begin
            case io of
             inputdef : iorec := getconnection(addr,inputcomp,connno);
             outputdef: iorec := getconnection(addr,outputcomp,connno);
            end; (* case *)
            if iorec[nextXcomponent] = lastaddr
               then
                    begin
                    if (iorec[flag] > 0) and (iorec[flag] <= vln)
                     then
                         iorec[flag] := -iorec[flag]
                     else 
                         if iorec[flag] > vln
                              then iorec[flag] := -(iorec[flag]-vln)
                              else
                                   if iorec[flag] < -vln
                                        then iorec[flag] := iorec[flag] + vln;
                    case io of
                    inputdef :putconnection(addr,inputcomp,connno,iorec);
                    outputdef:putconnection(addr,outputcomp,connno,iorec);
                    end;
                    found := true;
                    end
               else
                    connno := succ(connno);
      end; (* While *)
end; (* ConnGate *)   

(**)
(*1111111111111111111111111111111111111111111111111111111111111111111*)
(*                                                                   *)
(*  PROCEDURE : ConnectNext                                          *)
(*  AUTHOR    : C.J.                                                 *)
(*  DATE      : 3/20/86                                              *)
(*                                                                   *)
(*  Function  : Start Fanio 7 and connect OR2 or OR3 Gate            *)
(*  MODIFICATIONS :                                                  *)
(*    NAME        DATE       DESCRIPTION                             *)
(*    ----------- ---------- ------------------------------------    *)
(*    cj          3/19/86     initial release                        *)  
(*    CJ          4/11/86     modification                           *)   
(*    CJ          9/23/86     modify to connect gate for 7.FO output *)
(*                                                                   *)
(*  COMMENTS  :                                                      *)
(*                                                                   *)
(*  INPUT PARAMETERS :                                               *)
(*                                                                   *)
(*    VARIABLE    TYPE       DESCRIPTION                             *)
(*    ----------- ---------- ------------------------------------    *)
(*    Addr        int_x4                                             *)
(*    LastAddr    int_x4                                             *)
(*    Term        TermRec                                            *)      
(*1111111111111111111111111111111111111111111111111111111111111111111*)
procedure connnext(addr,lastaddr: intXx4;term:termrec);
var iorec : iotype;
    connno: intXx4;
    done  : boolean;
    orrectype : intXx4; 
    comprectype : intXx4; 
    noofoutputs : intXx4;
    limitio : limitiorecord;
begin (* ConnNext *)
      comprectype := getrecordtype(addr);
      conngate(addr,lastaddr,inputdef);
      noofoutputs := qtycomppin(comprectype,outputcomp);
      connno := 0;
      done   := false;
      repeat
         iorec := getconnection(addr,outputcomp,connno);
         orrectype := getop(orop,opcomponentref);
         comprectype := getrecordtype(iorec[nextXcomponent]);
(* check if the address is XOR gate or OR gate *)
         if orrectype = comprectype
           then
               begin
(* if next component is OR gate and no xor gate in the term *)
               if not term.xornode
                  then
                      begin
                         iorec[flag] := -iorec[flag];
                         putconnection(addr,outputcomp,connno,iorec);
(* CJ 9/23/86 *)
                         conngate(addr,iorec[nextXcomponent],outputdef);
                         conngate(iorec[nextXcomponent],addr,inputdef);
                         done := true;
                      end
               end   
          else
              begin

(* if next component is OR3 and there is a exclusive or in the term *)
              if term.xornode
                then
                    begin
                     iorec[flag] := -iorec[flag];
                     putconnection(addr,outputcomp,connno,iorec);
(* CJ 9/23/86 *)
                     conngate(addr,iorec[nextXcomponent],outputdef);
                     conngate(iorec[nextXcomponent],addr,inputdef);
                     done := true;
                     end;
              end;
          if not done
           then connno := succ(connno);
      until (connno = noofoutputs) or done;
      if not done
        then
               zglobalerr(frerrconnnext,nili);
end; (*ConnNext *)



(**)
(*1111111111111111111111111111111111111111111111111111111111111111111*)
(*                                                                   *)
(*  PROCEDURE : MatchGatePinWithEq                                   *)
(*  AUTHOR    : C.J.                                                 *)
(*  DATE      : 3/20/86                                              *)
(*                                                                   *)
(*  Function  : Check pin association with equation, return boolean  *)
(*		true if a match.	                             *)
(*  MODIFICATIONS :                                                  *)
(*    NAME        DATE       DESCRIPTION                             *)
(*    ----------- ---------- ------------------------------------    *)
(*    cj          3/19/86     initial release                        *) 
(*    CJ          9/19/86     modify whole function                  *) 
(*                                                                   *)
(*  COMMENTS  :                                                      *)
(*                                                                   *)
(*  INPUT PARAMETERS :                                               *)
(*                                                                   *)
(*    VARIABLE    TYPE       DESCRIPTION                             *)
(*    ----------- ---------- ------------------------------------    *)
(*    Addr        int_x4     the component address                   *)
(*    Eqterm      TermRec    the equation to match to		     *)
(*1111111111111111111111111111111111111111111111111111111111111111111*)
function matchgatepinwitheq(addr:intXx4; eqterm: termrec): boolean;
const nomorpinassoc = -1;

var rectype : intXx4;
    citindex: intXx4;
    level   : intXx4;
    pinlevel: intXx4;
    pinno   : intXx4;
    temppin : intXx4;
    retval  : boolean;
 begin
(* MEG 9/19/86 *)
(* initialize to no match *)
     retval := false;
(* It is temporary until Mike fixed the getPinAssocT *)
     rectype := getrecordtype(addr);
     citindex := getcitindex(addr);
(* try to call GetPinAssoct and call until the return value is -1 *)
     level := getassoclevels(rectype);
     for pinlevel := 0 to level-1 do
     begin
          temppin :=  getpinassoct(rectype,citindex,pinlevel);
          repeat
             if temppin = eqterm.devpin 
               then                      
                    retval := true;
             temppin := getpinassoct(rectype,citindex,pinlevel);
          until (temppin = nomorpinassoc);
     end;

(* set the return value *)
   matchgatepinwitheq := retval;
 end; (* MatchGatePinWithEq *)

(**)
(*1111111111111111111111111111111111111111111111111111111111111111111*)
(*                                                                   *)
(*  PROCEDURE : ConnOr                                               *)
(*  AUTHOR    : C.J.                                                 *)
(*  DATE      : 3/20/86                                              *)
(*                                                                   *)
(*  Function  : Connect OR gate                                      *)
(*  MODIFICATIONS :                                                  *)
(*    NAME        DATE       DESCRIPTION                             *)
(*    ----------- ---------- ------------------------------------    *)
(*    cj          3/19/86     initial release                        *)  
(*    M.Gzowski   9/18/86     fix problem with OR gate feedback      *)
(*                                                                   *)
(*  COMMENTS  :                                                      *)
(*                                                                   *)
(*  INPUT PARAMETERS :                                               *)
(*                                                                   *)
(*    VARIABLE    TYPE       DESCRIPTION                             *)
(*    ----------- ---------- ------------------------------------    *)
(*   Addr         int_X4                                             *)
(*   LastAddr     int_x4                                             *)
(*   EqTerm       TermRec                                            *)
(*1111111111111111111111111111111111111111111111111111111111111111111*)
procedure connor(addr:intXx4;lastaddr:intXx4;eqterm:termrec);
var rectype : intXx4;
    noofoutputs : intXx4;
    connno    : intXx4;
    done      : boolean;
    iorec     : iotype;    
    pin       : intXx4;
    compclass : intXx4;
begin

(* Connect Fanio which goes to OR/Xor gate *)
     connno := 0;
     done := false;

(* Connect OR's input *)
     conngate(addr,lastaddr,inputdef);
     rectype := getrecordtype(addr);
     noofoutputs := qtycomppin(rectype,outputcomp);

(* connect OR's output *)
     while (connno <= noofoutputs-1) and (not done) do
     begin
          iorec := getconnection(addr,outputcomp,connno);

          if iorec[flag] <> 0
            then
               begin
                rectype := getrecordtype(iorec[nextXcomponent]);
                compclass := examinemitrec(rectype,componentXclass);

(* check next component a fan io or array *)
            if compclass in [ccXarray,ccXor,ccXfanio] then begin  
                case compclass of
(* MEG 9/19/86 *)
                 ccXarray:;
                 ccXor   : begin
                           if matchgatepinwitheq(iorec[nextXcomponent],eqterm)
                            then begin
                              done := true;
                              conngate(addr,iorec[nextXcomponent],outputdef);
                              conngate(iorec[nextXcomponent],addr,inputdef);
                             end; (*if...then*)
                           end;
                 ccXfanio: begin
                           if matchgatepinwitheq(iorec[nextXcomponent],eqterm)
                            then begin
                              done := true;
                              conngate(addr,iorec[nextXcomponent],outputdef);
                              connnext(iorec[nextXcomponent],addr,eqterm);
                             end; (*if...then*)
                           end;
(* MEG 9/18/86 *)
(* if the next component is not of the expected type, try another connection *)
                end; (* case *)
            end;    {!! 2 !!}
               end; (* if .. then *)
          if (not done )
            then connno := succ(connno);
     end; (* while *)
end;                      
(**)
(*1111111111111111111111111111111111111111111111111111111111111111111*)
(*                                                                   *)
(*  PROCEDURE : GoToOrGate                                           *)
(*  AUTHOR    : C.J.                                                 *)
(*  DATE      : 3/20/86                                              *)
(*                                                                   *)
(*  Function  : Start with a fanio 5 type and connect next component *)
(*  MODIFICATIONS :                                                  *)
(*    NAME        DATE       DESCRIPTION                             *)
(*    ----------- ---------- ------------------------------------    *)
(*    cj          3/19/86     initial release                        *)
(*    CJ          4/11/86     modification                           *)  
(*    M Gzowski   7/16/86     added CC_TriState as alternate to      *)
(*			      CC_FanIO in case, corrected error case *)
(*                                                                   *)
(*  COMMENTS  :                                                      *)
(*                                                                   *)
(*  INPUT PARAMETERS :                                               *)
(*                                                                   *)
(*    VARIABLE    TYPE       DESCRIPTION                             *)
(*    ----------- ---------- ------------------------------------    *)
(*    EqTerm      termrec                                            *)
(*    FanIOAddr   int_X4                                             *)
(*    AndAddr     int_X4                                             *) 
(*1111111111111111111111111111111111111111111111111111111111111111111*)
procedure gotoorgate(eqterm:termrec;
                     fanioaddr:intXx4;
                     andaddr:intXx4);
var compclass  : intXx4;
    comprectype: intXx4; 
    faniorectype : intXx4;
    noofinputs : intXx4;
    connno     : intXx4;
    done       : boolean;
    iorec      : iotype;
    oraddr     : intXx4;
    noofoutputs : intXx4;
    limitio    : limitiorecord; 
begin (* GOTOORGAte *)
     done := false;
     connno := 0; 

(* Connect Connection between fanio/OR and AND gate *)
     conngate(fanioaddr,andaddr,inputdef);
     faniorectype := getrecordtype(fanioaddr);

(* Connecting a specified component in outputdef of FanIO *)
     noofoutputs := qtycomppin(faniorectype,outputcomp);
     repeat
            iorec := getconnection(fanioaddr,outputcomp,connno);
            comprectype := getrecordtype(iorec[nextXcomponent]);
            compclass := examinemitrec(comprectype,componentXclass);
            if iorec[flag] <> 0 
              then  
(* check the component class a fanio or OR gate *)
            if compclass in [ccXtristate,ccXor,ccXfanio] then begin  
                   case compclass of
(* MEG 7/16/86 *)
                   ccXfanio, ccXtristate : 
                       if eqterm.trstnode
                         then 
                             begin      
                              fittricondition(eqterm.devpin,eqcase);
                              iorec[flag] := - iorec[flag];
                              putconnection(fanioaddr,outputcomp,connno,iorec);
                              conngate(iorec[nextXcomponent],fanioaddr,inputdef);
                              done := true;
                             end;
                   ccXor : 
                        if not eqterm.trstnode
                         then 
                          begin
                          iorec[flag] := -iorec[flag];
                          putconnection(fanioaddr,outputcomp,connno,iorec);
                          connor(iorec[nextXcomponent],fanioaddr,eqterm);
                          done := true;
                         end;
(* MEG 7/16/86 *)
                  end; (* case *)
		  end else begin  
                          zglobalerr(sendbugrpt,nili); 
                          zglobalerr(badpdf,eqterm.devpin);	
                         end;  
            if not done
             then
                  connno := succ(connno);
      until (connno = noofoutputs) or done;
end; (* GoTOOrGate *)                    
(**) 
(*1111111111111111111111111111111111111111111111111111111111111111111*)
(*                                                                   *)
(*  PROCEDURE : ProUpGate                                            *)
(*  AUTHOR    : C.J.                                                 *)
(*  DATE      : 3/19/85                                              *)
(*                                                                   *)
(*  Function  : Connect OR and XOR  gates                            *)
(*  MODIFICATIONS :                                                  *)
(*    NAME        DATE       DESCRIPTION                             *)
(*    ----------- ---------- ------------------------------------    *)
(*    cj          3/19/86     initial release                        *)  
(*    CJ          4/11/86     modification  and add comments         *)
(*                                                                   *)
(*  COMMENTS  :                                                      *)
(*                                                                   *)
(*  INPUT PARAMETERS :                                               *)
(*                                                                   *)
(*    VARIABLE    TYPE       DESCRIPTION                             *)
(*    ----------- ---------- ------------------------------------    *)
(*    EqTerm      TermRec                                            *)
(*    Addr        int_x4                                             *) 
(*1111111111111111111111111111111111111111111111111111111111111111111*)
procedure proupgate(eqterm:termrec;addr : intXx4);
const connno = 0;
var andrectype : intXx4;
    iorec      : iotype;

begin (* ProUpGate *)

(*Connect outputdef of AND2 gate and go forward to next component *)
      if not connectfull(addr,outputcomp)
         and (not zglobalerror) 
        then
             begin
               andrectype := getrecordtype(addr);
(* expect a fixed connection with fan io type here *)
               iorec := getconnection(addr,outputcomp,connno);
               if iorec[flag] > vln
                 then
                     begin 
                     iorec[flag] := -(iorec[flag] - vln);
                     putconnection(addr,outputcomp,connno,iorec); 
                     gotoorgate(eqterm,iorec[nextXcomponent],addr);
                     end; (* if *)
             end (* if *)
        else
            begin
                 zglobalerr(frerrproupgate,nili);
            end;
end; (* ProUpGate *)
(**)
(*1111111111111111111111111111111111111111111111111111111111111111111*)
(*                                                                   *)
(*  PROCEDURE : ProcessGate                                          *)
(*  AUTHOR    : C.J.                                                 *)
(*  DATE      : 12/19/85                                             *)
(*                                                                   *)
(*  Function  : Start from And2 gate and check each connection with  *)
(*              a specified inputdef/outputdef and go forward to     *)
(*              connect OR/XOR gate or backward to connect AND array *)
(*  MODIFICATIONS :                                                  *)
(*    NAME        DATE       DESCRIPTION                             *)
(*    ----------- ---------- ------------------------------------    *)
(*    cj          12/19       initial release                        *)  
(*    CJ          3/6/86      rewrite                                *)
(*    M Gzowski   4/11/86     accept pass record type                *)
(*    CJ          4/11/86     modification                           *)      
(*    M Gzowski   5/20/86     modify flow, to avoid redundant 	     *)
(*			      flagging of error condition	     *)
(*                                                                   *)
(*  COMMENTS  :                                                      *)
(*                                                                   *)
(*  INPUT PARAMETERS :                                               *)
(*                                                                   *)
(*    VARIABLE    TYPE       DESCRIPTION                             *)
(*    ----------- ---------- ------------------------------------    *)
(*    TERM        TERMREC                                            *)
(*    And2RecType int_X4     the key record type        	     *)
(*1111111111111111111111111111111111111111111111111111111111111111111*)
(* MEG 4/11/86*)
procedure processgate(term        : termrec; 
                      and2rectype : intXx4);
var tempidlink  : idlink;
    and2address : intXx4;
    termlink    : idlink;
begin (*PUTTREMINARRAY*)

(* MEG 5/20/86 *)
(* check for that omnipresent danger of the dreaded global error *)
      if not zglobalerror
       then begin

(* Get the Component Record *)
         termlink := term.idlist;
         and2address := getcomponentloc(and2rectype,frXindex);

(* We expected the picked and2 gate can cover all the term elements *)
         proupgate(term,and2address);
         connectand(and2address,inputcomp,termlink);

(* check if the case that there is no available connection but still some *)
(* terms left *)
            if termlink <> nil
              then
                  begin
                  forceXrouteXfailure := true;
                  zglobalerr(frerrputterminarray,nili);
                  end
              else           
                  frXindex := succ(frXindex);

(* MEG 5/20/86 *)
        end; (*if...then*)

end; (*ProcessGate*)

      
(**)
(*1111111111111111111111111111111111111111111111111111111111111111111*)
(*                                                                   *)
(*  PROCEDURE : CountTerm                                            *)
(*  AUTHOR    : C.J.                                                 *)
(*  DATE      : 12/19/85                                             *)
(*  FUNCTION  : This procedure counts the element number in EqTErm   *)
(*                                                                   *)
(*  MODIFICATIONS :                                                  *)
(*    NAME        DATE       DESCRIPTION                             *)
(*    ----------- ---------- ------------------------------------    *)  
(*    CJ          4/10/86      initial release			     *)
(*                                                                   *)
(*  COMMENTS  :                                                      *)
(*                                                                   *)
(*  INPUT PARAMETERS :                                               *)
(*                                                                   *)
(*    VARIABLE    TYPE       DESCRIPTION                             *)
(*    ----------- ---------- ------------------------------------    *)
(*    EqTerm      TermRec    The term to be fitted.		     *)
(*                                                                   *)
(*1111111111111111111111111111111111111111111111111111111111111111111*)
function countterm(eqterm : termrec) : intXx4;
var count : intXx4;
    termlink : idlink;
begin (* CountTerm *)

(* Count how many elements in eqterm *)
     termlink := eqterm.idlist;
     count := 0;
     while termlink <> nil do
      begin
          count := succ(count);
          termlink := termlink^.next;
      end;
     countterm := count;
end; (* CountTerm *)       
      
(**)
(*1111111111111111111111111111111111111111111111111111111111111111111*)
(*                                                                   *)
(*  PROCEDURE : FitTerm                                              *)
(*  AUTHOR    : C.J.                                                 *)
(*  DATE      : 12/19/85                                             *)
(*  FUNCTION  : This procedure takes a given equation term descripter*)
(*              and attemps to fit the term into the device AND array*)
(*              in the appropriate range. Should a routing failure   *)
(*              occur, then the force_route_failure flag is set so  *)
(*              no additional routing attempt will occur             *)
(*                                                                   *)
(*  MODIFICATIONS :                                                  *)
(*    NAME        DATE       DESCRIPTION                             *)
(*    ----------- ---------- ------------------------------------    *)  
(*    CJ          12/19      initial release			     *)
(*    M. Gzowski  2/3/86     debug rewrite			     *)
(*    M. Gzowski  4/11/86    get the key record type, changes to     *)
(*                           routine calling parameters		     *)
(*    M. Gzowski  4/18/86    increase error checking, bug #793       *)
(*                                                                   *)
(*  COMMENTS  :                                                      *)
(*                                                                   *)
(*  INPUT PARAMETERS :                                               *)
(*                                                                   *)
(*    VARIABLE    TYPE       DESCRIPTION                             *)
(*    ----------- ---------- ------------------------------------    *)
(*    EqTerm      TermRec    The term to be fitted.		     *)
(*                                                                   *)
(*1111111111111111111111111111111111111111111111111111111111111111111*)
{vax   [global]  vax}
 procedure fitterm;  
var selectedrange : range;
    lastid : intXx4;
    keyrectype : intXx4;
begin (*FitTerm*)

(* MEG 4/11/86 *)
(* get the key record type *)
      keyrectype := getop(andop,opcomponentref);

(* fit the equation *)
      with eqterm do
       begin

(* If the ID term is not larger than the maximum number,chose the range *)
(* to be put and put the term into the array                            *)     
        if idcount  <= maxtermids
         then begin
           selectedrange := keyrange(eqterm);
(* CJ 6/27 *)
           movetorange ( devpin, selectedrange, keyrectype, idcount, eqterm);
           processgate(eqterm, keyrectype);
(* MEG 4/18/86, bug # 793 *)
           if zglobalerror
            then zglobalerr( failtoplaceterm, devpin );
          end (*if...then*)

(* if the ID term is beyond the maximum number, report error *)
         else begin
(* MEG 2/19/86 *)
           zglobalerr(frtermmax, maxtermids);
           zglobalerr(frtermtoolarge, devpin);
           forceXrouteXfailure := true;
          end;
   end; (* with.. do  *)
end;(*FitTerm*)

(* MEG 2/10/86 *)
{vax End. vax}

