{**  DEC/CMS REPLACEMENT HISTORY, Element ZERROR.SRC **}
{**  *1    10-OCT-1986 08:58:59 PALASM2 "" **}
{**  DEC/CMS REPLACEMENT HISTORY, Element ZERROR.SRC **}
(*                                                                   *)
(*  (c) copyright Monolithic Memories, Inc. , 1986                   *)
(*                                                                   *)
(*  RJS 27/JAN/86 *)
{vax %include 'pal2$inc:z24global.inc'  vax}
{vax module zerror (INPUT,OUTPUT); vax}


#include 'csopeninc.i'
#include 'ctre.i'
#include 'ctxtio.i'
#include 'fnxinc.i'
#include 'z24.i'


{ipp program zerror ; ipp}
{ipp pragma On(Externals_allowed_internally); ipp}
{ipp pragma C_include('ctre.inc'); ipp}
{ipp pragma C_include('ctxtio.inc'); ipp}
{ipp pragma C_include('fnxinc.inc'); ipp}
{ipp pragma C_include('z24.inc'); ipp}
 
(*-------------------------------------------------------------------*)
(*                                                                   *)
(*  PROCEDURE:ZGlbErrInit                                            *)
(*  AUTHOR    : Chie-Jiun Chien                                      *)
(*  DATE      : 11/20/85                                             *)
(*  FUNCTION  : This procedure sets all globals used in program      *)
(*              internal error and condition handling to their       *)
(*              internal states                                      *)
(*                                                                   *)
(*  MODIFICATIONS :                                                  *)
(*    NAME        DATE       DESCRIPTION                             *)
(*    ----------- ---------- ------------------------------------    *)
(*    Chie-Jiun   11/20/85   Initial release                         *)
(*                                                                   *)
(*                                                                   *)
(*  COMMENTS  :                                                      *)
(*                                                                   *)
(*  NOTES     :                                                      *)
(*                                                                   *)
(*  EXTERNAL DECLARATIONS :                                          *)
(*                                                                   *)
(*  GLOBAL DECLARATIONS :  ZGlobalError                              *)
(*                         ZGlbErrList                               *)
(*                                                                   *)
(*-------------------------------------------------------------------*)
{vax  [Global]       vax}
procedure zglberrinit;
 
begin
    zglobalerror := false;
    zglberrlist  := nil;
end;
 
(*-------------------------------------------------------------------*)
(*                                                                   *)
(*  Routine   : ZGlobalErr                                           *)
(*  AUTHOR    : Chie-Jiun Chien                                      *)
(*  DATE      : 11/21/85                                             *)
(*  FUNCTION  : This procedure  adds a passed code to a list of      *)
(*              error and condition codes to be reported. This allows*)
(*              a large number of errors to be gathered before       *)
(*              reporting                                            *)
(*                                                                   *)
(*  MODIFICATIONS :                                                  *)
(*    NAME        DATE       DESCRIPTION                             *)
(*    ----------- ---------- ------------------------------------    *)
(*    C.J.        11/21/85   Initial release                         *)
(*    M.Gzowski   7/8/86     do not set error flag for information   *)
(*                                                                   *)
(*                                                                   *)
(*  COMMENTS  :                                                      *)
(*                                                                   *)
(*  NOTES     :                                                      *)
(*                                                                   *)
(*  EXTERNAL DECLARATIONS :                                          *)
(*                                                                   *)
(*  GLOBAL DECLARATIONS :                                            *)
(*              ZGlobalError                                         *)
(*              ZGlbErrList                                          *)
(*-------------------------------------------------------------------*)
{vax  [Global] vax}
 procedure zglobalerr;  
var errorlink : errorXlink;
    olderrorlink : errorXlink;
begin
(* MEG 7/8/86 *)
     if not odd (errorcode) then zglobalerror:= true;
     olderrorlink := zglberrlist;
     new(errorlink);
     errorlink^.code := errorcode;
     errorlink^.val:= val;
     errorlink^.next := olderrorlink;
     zglberrlist := errorlink;
end;
 
 
(*-------------------------------------------------------------------*)
(*                                                                   *)
(*  PROCEDURE : ReportGlbErr                                         *)
(*  AUTHOR    : Chie-Jiun Chien                                      *)
(*  DATE      : 11/21/85                                             *)
(*  FUNCTION  : This procedure reports all error and conditions on   *)
(*              the Global Error List                                *)
(*                                                                   *)
(*  MODIFICATIONS :                                                  *)
(*    NAME        DATE       DESCRIPTION                             *)
(*    ----------- ---------- ------------------------------------    *)
(*    Chie-Jiun   11/21/85   Initial release                         *)
(*    M.Gzowski   1/20/86    Prerelease debug fixes                  *)
(*    M.Gzowski   2/18/86    corrected numeric parameter handling    *)
(*    M.Gzowski   2/26/86    cosmetic changes to output              *)
(*    M.Gzowski   7/8/86     reinitialize list after report          *)
(*                                                                   *)
(*                                                                   *)
(*  COMMENTS  :                                                      *)
(*                                                                   *)
(*  NOTES     :                                                      *)
(*                                                                   *)
(*  EXTERNAL DECLARATIONS :                                          *)
(*                                                                   *)
(*  GLOBAL DECLARATIONS :                                            *)
(*                   ZGlobalError                                    *)
(*                   ZGlbErrList                                     *)
(*-------------------------------------------------------------------*)
{vax [Global]     vax}
procedure reportglberr;
var errorcode : intXx4;
    errorvalue     : intXx4;
(* MEG 7/8/86 *)
    olderrorlink : errorXlink;
 
begin
(* MEG 1/20/86 *)
(* MEG 7/8/86 *)
(* if Error list is not empty, report the error(s) *)
     if (zglberrlist <> nil)
      then begin
 
(* MEG 2/26/86 *)
(* put some blank lines in the output *)
          zglobalerr ( makespace, nili );
 
          repeat
               errorcode := zglberrlist^.code;
               errorvalue     := zglberrlist^.val;
(* MEG 7/8/86 *)
               olderrorlink := zglberrlist;
               zglberrlist := zglberrlist^.next;
               dispose (olderrorlink);
               if (errorcode mod 4 = 0) or ((errorcode - 1) mod 4 = 0)
(* MEG 2/18/86 *)
{dsy           then WrTextLn(errfile,ErrorCode,Nils,ErrorValue)  dsy}
{dsy           else WrText(errfile,ErrorCode,Nils,ErrorValue);   dsy}
{/dsy}         then wrtextln(output,errorcode,nils,errorvalue)
{/dsy}         else wrtext(output,errorcode,nils,errorvalue);
           until (zglberrlist = nil) or (txtretcode<>txtXok);
 
(* MEG 7/8/86 *)
(* MEG 1/20/86 *)
(* check the return code from text writer                  *)
(* an error return code signifies a general system failure *)
          case txtretcode of
            txtXok:
                begin
                  zglberrinit;
                 end;
            txtXaccesserr:
                begin
    {dsy          WrTextLn(errfile,AccessErr,Nils,0);    dsy}
    {/dsy}        wrtextln(output,accesserr,nils,0);
    {/dsy}        writeln('Message handler failure - Txt_AccessErr');
                 end;
            txtXnoindex:
                begin
    {dsy          WrTextLn(errfile,NoIndex,Nils,0);    dsy}
    {/dsy}        wrtextln(output,noindex,nils,0);
    {/dsy}        writeln('Message handler failure - Txt_NoIndex');
                 end;
            txtXoutputerr:
                begin
    {dsy          WrTextLn(errfile,OutputErr,Nils,0);     dsy}
    {/dsy}        wrtextln(output,outputerr,nils,0);
    {/dsy}        writeln('Message handler failure - Txt_OutputErr');
                 end;
           end; (*case*)
(* MEG 7/8/86 - one line removed *)
       end; (*if...then*)
end;
{vax End. vax}
