{**  DEC/CMS REPLACEMENT HISTORY, Element ZDAA.SRC **}
{**  *1    10-OCT-1986 08:58:46 PALASM2 "" **}
{**  DEC/CMS REPLACEMENT HISTORY, Element ZDAA.SRC **}
(*                                                                   *)
(* Monolithic Memories, Inc.                                         *)
(* 2175 Mission College Blvd.                                        *)
(* Santa Clara, CA 95054-1592                                        *)
(*								     *)
(* (c) copyright 1985						     *)
(*                                                                   *)
(* MEG 2/10/86 *)
{vax    %include 'pal2$inc:z24global.inc'   vax}       
{vax   module zdaa(output);                 vax}			       


#include 'csopeninc.i'
#include 'ctre.i'
#include 'ctxtio.i'
#include 'fnxinc.i'
#include 'z24.i'


{ipp program zdaa; ipp}
{ipp pragma On(Externals_allowed_internally); ipp}
{ipp pragma C_include('ctre.inc'); ipp}
{ipp pragma C_include('ctxtio.inc'); ipp}
{ipp pragma C_include('fnxinc.inc'); ipp}
{ipp pragma C_include('z24.inc'); ipp}
(*-------------------------------------------------------------------*)
(*                                                                   *)
(*  Module    : ZDAA - DeviceArchitectureAccess			     *)
(*  AUTHOR    : Boris and C.J.                                       *)
(*  DATE      : 11/13/85                                             *)
(*  FUNCTION  : The module contains some routines for data-accessing *)
(*              and placing.                                         *)
(*                                                                   *)
(*  MODIFICATIONS :                                                  *)
(*    NAME        DATE       DESCRIPTION                             *)
(*    ----------- ---------- ------------------------------------    *)
(*    C.B. Lee    1/11/86    Pre-release/debugging fixes	     *)
(*    M. Gzowski						     *)
(*    M. Gzowski  2/10/86    corrected module header and trailer     *)
(*    M. Gzowski  3/12/86    fix for bug #762                        *)
(*    M. Gzowski  4/18/86    fix for bug #794                        *)
(*			     changed references to dummyvalue to NilI*)
(*    I.Taller    4/3/86     changes in FindLineAddress, ArrayNext   *)
(*    (M.Gzowski  4/24/86    incorporation of above changes)         *)
(*    C.J. Chien  5/12/86    new routine GetListNo		     *)
(*    (M.Gzowski)						     *)
(*    I. Taller   6/18/86    changes for ZHAL20			     *)
(*    I. Taller   9/30/86    Feedback component changes		     *)
(*                                                                   *)
(*  COMMENTS  :                                                      *)
(*                                                                   *)
(*  NOTES     : All the Export procedures or functios are in the     *)
(*              following:                                           *)
(*                 GetOp,                GetComponentLoc             *)
(*                 GetMITRec,            GetAssocLevels              *)
(*                 ExamineMITRec,        GetPinAssocT                *)
(*                 ChangeMITRec,         GetConnection               *)
(*                 RedefineCompPins,     PutConnection               *)
(*                 QtyCompPin,           ArrayNext                   *)
(*                 QtyPinAssoc,          RowAssocLevels              *)
(*                 GetRecordType,        ClrArrayLine                *)
(*                 MovArrayLine,         QtyLineIntraCon             *)
(*                 AddLineIntraCon       GetLineIntraCon             *)
(*                 ArrayLineFull         StatLineArray               *)
(*                 UsedLineArray         ConnectFull                 *)
(*              All the procedures and functions in the following are*)
(*              only used in this module                             *)
(*                 DenseNextLLT                                      *)
(*                 valid                 CountCITRecSize             *)
(*                 GetPinAssoc           FindLimitRec                *)
(*                 RowColOffset          FindLineAddress             *)
(*                 GetLLT                                            *)
(*                 FindUnUsedIntraCon    PutSparseValue              *)
(*                 PutDenseValue         GetDenseIntraCon            *)
(*                                                                   *)
(*  EXTERNAL DECLARATIONS :                                          *)
(*                                                                   *)
(*  GLOBAL DECLARATIONS :                                            *)
(*                                                                   *)


(*-------------------------------------------------------------------*)
(*     Componnt_Class Definitions                                    *)
(*-------------------------------------------------------------------*)

(*           CC_Terminal       = 1;                                  *)
(*           CC_AND            = 2;                                  *)
(*           CC_OR             = 3;                                  *)
(*           CC_XOR            = 4;                                  *)
(*           CC_NAND           = 5;                                  *)
(*           CC_NOR            = 6;                                  *)
(*           CC_XNOR           = 7;                                  *)
(*           CC_InvBuff        = 8;                                  *)
(*           CC_TriBuff        = 9;                                  *)
(*           CC_InvNInvBuff    = 10;                                 *)
(*           CC_DReg           = 11;                                 *)
(*           CC_RSReg          = 12;                                 *)
(*           CC_JKReg          = 13;                                 *)
(*           CC_Buff           = 14;                                 *)
(*           CC_TriState       = 15;                                 *)
(*           CC_FeedBack       = 16;                                 *)
(*           CC_Array          = 0;                                  *)
(*           CC_FanIO          = 20;                                 *)


    type
(*           LimitIORecType = (NoTotal, MaxUsage);            *)
(*           LimitIORange = NoTotal .. MaxUsage;              *)
(*           LimitIORecord = array[LimitIORange] of int_x4;   *)
           rowtype = (sparse, dense);


(*

*)

(*-------------------------------------------------------------------*)
(*                                                                   *)
(*  Funciton  : NotUsed                                              *)
(*  AUTHOR    : CB Lee        					     *)
(*  DATE      : 11/25/85                                             *)
(*  FUNCTION  : This function checks the specified connection for    *)
(*              a component and return false if not connected        *)
(*                                                                   *)
(*  MODIFICATIONS :                                                  *)
(*    NAME        DATE       DESCRIPTION                             *)
(*    ----------- ---------- ------------------------------------    *)
(*                                                                   *)
(*  COMMENTS  :                                                      *)
(*                                                                   *)
(*                                                                   *)
(*    VARIABLE    TYPE       DESCRIPTION                             *)
(*    ----------- ---------- ------------------------------------    *)
(*                                                                   *)
{vax  [Global]  vax}  
 function notused;  

begin
      if (iorec[flag] <= 0) and (iorec[flag] >= -vln)
        then
             notused := false
        else
             notused := true;
end;

(**)
(*-------------------------------------------------------------------*)
(*                                                                   *)
(*  PROCEDURE : GetListNo                                            *)
(*  AUTHOR    : CJ Chien                                             *)
(*  DATE      : 5/1/86                                               *)
(*  FUNCTION  : Get List No of One Densed Array Record               *)
(*                                                                   *)
(*  MODIFICATIONS :                                                  *)
(*    NAME        DATE       DESCRIPTION                             *)
(*    ----------- ---------- ------------------------------------    *)
(*    CJ Chien    5/1/86     initial release                         *)  
(*                                                                   *)
(*  COMMENTS  :                                                      *)
(*                                                                   *)
(*  INPUT PARAMETERS :                                               *)
(*                                                                   *)
(*    VARIABLE    TYPE       DESCRIPTION                             *)
(*    ----------- ---------- ------------------------------------    *)
(*    RecAddress  int_X4     starting address of the specified record*) 
(*                                                                   *)

{vax [global] vax}
 function getlistno;  
var  listno     : intXx4;
     returnstatus : intXx4;

begin (* GetListNo *)
    recaddress := recaddress + 2;
    returnstatus := examinelocation(recaddress,listno);
    if returnstatus > 0
      then
          getlistno := listno
      else
          zglobalerror := true
end; (* GetListNo *)
(*

*)

(*-------------------------------------------------------------------*)
(*                                                                   *)
(*  PROCEDURE : valid                                                *)
(*  AUTHOR    : CB Lee        					     *)
(*  DATE      : 11/25/85                                             *)
(*  FUNCTION  : This function valids the parameter passed for the    *)
(*              specified range. If it fails, the error message is   *)
(*              to the global error message routine.                 *)
(*                                                                   *)
(*  MODIFICATIONS :                                                  *)
(*    NAME        DATE       DESCRIPTION                             *)
(*    ----------- ---------- ------------------------------------    *)
(*                                                                   *)
(*  COMMENTS  :                                                      *)
(*                                                                   *)
(*  INPUT PARAMETERS :                                               *)
(*                                                                   *)
(*    VARIABLE    TYPE       DESCRIPTION                             *)
(*    ----------- ---------- ------------------------------------    *)
(*    Field       integer    the field to be valid		     *)
(*                                                                   *)
(*    MinValue    integer    minimum field value                     *)
(*                                                                   *)
(*    MaxValue    integer    maximum field value                     *)
(*                                                                   *)
(*    ErrorMsg    integer    error message                           *)
(*                                                                   *)
(*                                                                   *)
(*  GLOBAL VARIABLES:                                                *)
(*      ZGlobalError   : boolean                                     *)       
(*                                                                   *)

function valid(field      : intXx4;
                  minvalue   : intXx4;
                  maxvalue   : intXx4;
                  errormsg   : intXx4): boolean;

const dummy = 99;
  begin  (* valid *)

    if not zglobalerror
    then begin

(* valid the range of the record type, otherwise flag an error.   *)

        if ((field >= minvalue) and (field <= maxvalue))
        then
            valid := true
	else begin
             if field = dummy
               then valid := true   
               else
                    begin
                     valid := false;
                     zglobalerr(errormsg, field);
                    end; (* else *)
             end;
      end  (* if .. then *)

    else
        zglobalerr(daanexevalid, nili);

  end;  (* valid *)

(*

*)

(*-------------------------------------------------------------------*)
(*                                                                   *)
(*  PROGRAM   : GarbageCollect                                       *)
(*  AUTHOR    : CB Lee                                               *)
(*  DATE      : 12/6/85                                              *)
(*  FUNCTION  : This function returns a pointer to a linked list of  *)
(*              free memory space                                    *)
(*                                                                   *)
(*  MODIFICATIONS :                                                  *)
(*    NAME        DATE       DESCRIPTION                             *)
(*    ----------- ---------- ------------------------------------    *)
(*    CB          1/9/85     Initial release                         *)
(*                                                                   *)
(*                                                                   *)
(*  COMMENTS  :                                                      *)
(*                                                                   *)
(*  NOTES     : Returns an address; passed an argument that points   *)
(*              the linked list to be retrieved.                     *)
(*  Calls     :                                                      *)
(*                                                                   *)
(*                                                                   *)
(*                                                                   *)
{vax   [Global]  vax}   
 function garbagecollect;  
var 
  nextaddr  : intXx4;

begin (* GarbageCollect *)

  if headlist = taillist
    then headlist:= lpointer
  else returnflag := putlocation(taillist + 1, lpointer);
        
  nextaddr:= 0;
  taillist:= lpointer;
  while (nextaddr <> zXnil) do
    begin
      returnflag := examinelocation(taillist + 1, nextaddr);
      returnstatus := valid(nextaddr, minloc, maxloc, daalocationoutb);
      if  nextaddr <> zXnil
        then taillist:= nextaddr;
    end;

  garbagecollect:= headlist;

end; (* GarbageCollect *)

(*

*)

(*-------------------------------------------------------------------*)
(*                                                                   *)
(*  PROCEDURE : GetOp                                        	     *)
(*  AUTHOR    :                                                      *)
(*  DATE      : 11/13/1985                                           *)
(*  FUNCTION  : This function gets the index into the Main Index     *)
(*              table. The specified record is used to find the      *)
(*              component used to map a given Equation Operator      *)
(*              (EqOp), or the array used to map the equation for    *)
(*              the Equation Operator.                               *)
(*                                                                   *)
(*  MODIFICATIONS :                                                  *)
(*    NAME        DATE       DESCRIPTION                             *) 
(*    ----------- ---------- ------------------------------------    *)
(*                                                                   *)
(*  COMMENTS:  The record consists of two parts -- array and         *)
(*             component. once the record has been accessed, we      *)
(*             have to specify which part we want to access.         *)
(*             This function returns either an index pointer to      *)
(*             array component in Main Index Table or an index       *)
(*             pointer to the corresponding operator component in    *)
(*             Main Index Table.                                     *)
(*                                                                   *)
(*  INPUT PARAMETERS :                                               *)
(*                                                                   *)
(*    VARIABLE    TYPE       DESCRIPTION                             *)
(*    ----------- ---------- ------------------------------------    *)
(*    Operator    EqOp                                               *)
(*    OperUse     OpUse                                              *)
(*                                                                   *)
(*                                                                   *)
(*  NOTES :                                                          *)  
(*                                                                   *)
(*  EXTERNAL DECLARATIONS :                                          *)
(*                                                                   *)
(*  GLOBAL VARIABLES:                                                *)
(*    OperatorIndex    : integer                                     *)
(*    ZGlobalError     : boolean                                     *)
(*                                                                   *)

{vax  [global] vax}   
 function getop;  

var
      errstatus     : intXx4;
      oitrecaddr    : intXx4;
      rectype       : intXx4;

begin  (* GetOp *)

  if  not (zglobalerror)
  then begin
      oitrecaddr := operatorindex + (2 * (ord(operator)));
     
      case operuse of
          oparrayref :
              errstatus := examinelocation (oitrecaddr, rectype);
          opcomponentref :
              errstatus := examinelocation (oitrecaddr + 1, rectype);
      end;  (* case .. of *)

(* Check RecordType and ZGlobalError *)

      if  (valid (rectype, minrecordtype, maxrecordtype, daarecordtypeoutb))
                  and (not zglobalerror)
      then
          getop := rectype
      else begin
             zglobalerr (daafailgetop, nili);
             getop := -daafailgetop
           end
    end (* if .. then *)
  else begin
         zglobalerr (daanexegetop, ord(operator));
         getop := -daanexegetop
       end

end;  (* GetOp *)
          
(*

*)

(*                                                                   *)
(*-------------------------------------------------------------------*)
(*                                                                   *)
(*  PROCEDURE : ExamineMITRec                                        *)
(*  AUTHOR    : Boris B. Shih                                        *)
(*  DATE      : 11/13/85                                             *)
(*  FUNCTION  : This routine is used to fetch one single field       *)
(*              from a Main Index Table record.                      *)
(*                                                                   *)
(*  MODIFICATIONS :                                                  *)
(*    NAME        DATE       DESCRIPTION                             *)
(*    ----------- ---------- ------------------------------------    *)
(*                                                                   *)
(*  COMMENTS  : The returning integer value is the content of the    *)
(*              specified field. If the returning value is negative, *)
(*              it means that the routine causes some error or is    *)
(*              not executed.                                        *)
(*                                                                   *)
(*  INPUT PARAMETERS :                                               *)
(*                                                                   *)
(*    VARIABLE    TYPE       DESCRIPTION                             *)
(*    ----------- ---------- ------------------------------------    *)
(*    RecordType  integer    The integer index into the Main         *)
(*                           Index Table for the desired record      *)
(*    FieldType   MITField                                           *)
(*                                                                   *)
(*  GLOBAL VARIABLES:                                                *)
(*      MainIndex       : integer                                    *)
(*      ZGlobalError    : boolean                                    *)
(*                                                                   *)

{vax   [global]  vax}     
 function examinemitrec ;  

  var
      temp             : boolean;
      errstatus        : intXx4;
      recaddr          : intXx4;
      val              : intXx4;

  begin  (* ExamineMITRec *)

    if  not zglobalerror
    then begin
        recaddr := mainindex + recordXtype * mitrecsize;

        case field of
            componentXclass : begin
              errstatus:=examinelocation(recaddr+ord(componentXclass),val);
              if  errstatus = normal
              then
                  temp:=valid(val,mincompcls,maxcompcls,daacompclsoutb);
              end;  (* case . Component_Class *)

            inputdef : begin
              errstatus:=examinelocation(recaddr+ord(inputdef),val);
              if  errstatus = normal
              then
                  temp:=valid(val,minloc,maxloc,daalocationoutb);
              end;  (* case . InputDef *)

            outputdef : begin
              errstatus:=examinelocation(recaddr+ord(outputdef),val);
              if  errstatus = normal
              then
                  temp:=valid(val,minloc,maxloc,daalocationoutb);
              end;  (* OutputDef *)

            nocomponents : begin
              errstatus:=examinelocation(recaddr+ord(nocomponents),val);
              if  errstatus = normal
              then
                  temp:=valid(val,minnocomp,maxnocomp,daanocompoutb);
              end;  (* NoComponents *)

            pinassoclevels : begin
              errstatus:=examinelocation(recaddr+ord(pinassoclevels),val);
              if  errstatus = normal
              then
                  temp:=valid(val,minpinasslevel,maxpinasslevel,
                             daapinassleveloutb);
              end;  (* PinAssocLevels *)

            pinassocdef : begin
              errstatus:=examinelocation(recaddr+ord(pinassocdef),val);
              if  errstatus = normal
              then
                  temp:=valid(val,minloc,maxloc,daalocationoutb);
              end;  (* PinAssocDef *)

            citlocation : begin
              errstatus:=examinelocation(recaddr+ord(citlocation),val);
              if  errstatus = normal
              then
                  temp:=valid(val,minloc,maxloc,daalocationoutb);
              end;  (* CITLocation *)
        end;  (* case .. of *)

        if  zglobalerror
        then begin
               zglobalerr (daafailexammitrec, recordXtype);
               examinemitrec := -daafailexammitrec
             end
        else
            examinemitrec := val;
       end  (* if .. then *)
    else begin
           zglobalerr (daanexeexammitrec, recordXtype);
           examinemitrec := -daanexeexammitrec;
         end;

  end;  (* ExamineMITRec *)

(*

*)

(*                                                                   *)
(*-------------------------------------------------------------------*)
(*                                                                   *)
(*  PROCEDURE : GetMITRec                                            *)
(*  AUTHOR    : Boris B. Shih                                        *)
(*  DATE      : 11/13/85                                             *)
(*  FUNCTION  : This routine pulls one record from the Main Index    *)
(*              Table. It is used as an alternative to making        *)
(*              several calls to ExamineMITRec.                      *)
(*                                                                   *)
(*  MODIFICATIONS :                                                  *)
(*    NAME        DATE       DESCRIPTION                             *)
(*    ----------- ---------- ------------------------------------    *)  
(*                                                                   *)
(*  COMMENTS  :                                                      *)
(*                                                                   *)
(*  INPUT PARAMETERS :                                               *)
(*                                                                   *)
(*    VARIABLE    TYPE       DESCRIPTION                             *)
(*    ----------- ---------- ------------------------------------    *)
(*    RecordType  integer      The integer index into the Main       *)
(*                             Index Table for the desired record    *)
(*                                                                   *)
(*  GLOBAL VARIABLES :                                               *)
(*                                                                   *)
(*      MainIndex       : integer                                    *)
(*      ZGlobalError    : boolean                                    *)
(*                                                                   *)

{vax    [Global]  vax}     
 function getmitrec ;  

  var
        errorstatus  : intXx4;
        mitrecbuf    : mitrecord;
        temp         : intXx4;

  begin  (* GetMITRec *)

    if  not zglobalerror
    then begin
        mitrecbuf[componentXclass]:=examinemitrec(recordXtype,componentXclass);
        mitrecbuf[inputdef] := examinemitrec(recordXtype, inputdef);
        mitrecbuf[outputdef] := examinemitrec(recordXtype, outputdef);
        mitrecbuf[nocomponents] := examinemitrec(recordXtype, nocomponents);
        mitrecbuf[pinassoclevels]:= examinemitrec(recordXtype, pinassoclevels);
        mitrecbuf[pinassocdef] := examinemitrec(recordXtype, pinassocdef);
        mitrecbuf[citlocation] := examinemitrec(recordXtype, citlocation);

(* The value obtained by calling ExamineMITRec is already checked
   in the called routine                                            *)

        if  zglobalerror
        then
            temp := daafailgetmitrec;
       end  (* if .. then *)
    else
        temp := daanexegetmitrec;

    if  (temp = daafailgetmitrec) or (temp = daanexegetmitrec)
    then begin
        zglobalerr (temp, recordXtype);
        mitrecbuf[componentXclass] := -temp;
        mitrecbuf[inputdef] := -temp;
        mitrecbuf[outputdef] := -temp;
        mitrecbuf[nocomponents] := -temp;
        mitrecbuf[pinassoclevels] := -temp;
        mitrecbuf[pinassocdef] := -temp;
        mitrecbuf[citlocation] := -temp;
     end;  (* if .. then *)

    getmitrec := mitrecbuf;

  end;  (* GetMITRec *)

(*

*)

(*                                                                   *)
(*-------------------------------------------------------------------*)
(*                                                                   *)
(*  PROCEDURE : ChangeMITRec                                         *)
(*  AUTHOR    : Boris B. Shih                                        *)
(*  DATE      : 11/14/85                                             *)
(*  FUNCTION  : This routine is used to update a given record        *)
(*              field in the Main Index Table.                       *)
(*                                                                   *)
(*  MODIFICATIONS :                                                  *)
(*    NAME        DATE       DESCRIPTION                             *)
(*    ----------- ---------- ------------------------------------    *)  
(*                                                                   *)
(*  COMMENTS  :                                                      *)
(*                                                                   *)
(*  INPUT PARAMETERS :                                               *)
(*                                                                   *)
(*    VARIABLE    TYPE       DESCRIPTION                             *)
(*    ----------- ---------- ------------------------------------    *)
(*    RecordType  integer    The integer index into the Main         *)
(*                           Index Table for the desired record      *)
(*    Field       MITFields  To indicate the desired field           *)
(*    val         integer    The new field value to be placed in     *)
(*                                                                   *)
(*  GLOBAL VARIABLES:                                                *)
(*      MainIndex         : integer                                  *)
(*      ZGlobalError      : boolean                                  *)
(*                                                                   *)

{vax    [global]  vax}   
 procedure changemitrec ;  

  var
         errstatus       : intXx4;
         recaddr         : intXx4;

  begin  (* ChangeMITRec *)

    if  not zglobalerror
    then begin
        recaddr := mainindex + recordXtype * mitrecsize;

        case field of
            componentXclass :
              errstatus:=putlocation(recaddr+ ord(componentXclass),val);
            inputdef :
              errstatus := putlocation(recaddr + ord(inputdef), val);
            outputdef :
              errstatus := putlocation(recaddr + ord(outputdef), val);
            nocomponents :
              errstatus := putlocation(recaddr+ ord(nocomponents), val);
            pinassoclevels :
              errstatus := putlocation(recaddr+ord(pinassoclevels),val);
            pinassocdef :
              errstatus := putlocation(recaddr + ord(pinassocdef), val);
            citlocation :
              errstatus := putlocation(recaddr + ord(citlocation), val)
          end;  (* case .. of *)

          if  zglobalerror
          then
              zglobalerr (daafailchngmitrec, recordXtype);
        end  (* if .. then *)
    else
        zglobalerr (daanexechngmitrec, recordXtype);

  end;  (* ChangeMITRec *)

(*

*)

(*                                                                   *)
(*-------------------------------------------------------------------*)
(*                                                                   *)
(*  PROCEDURE : RedefineCompPins                                     *)
(*  AUTHOR    : Boris B. Shih                                        *)
(*  DATE      : 11/14/85                                             *)
(*  FUNCTION  : This function determines whether the inputs or       *)
(*              outputs to a component record have been redefined,   *)
(*              when that number of inputs or outputs is fixed.      *)
(*                                                                   *)
(*  MODIFICATIONS :                                                  *)
(*    NAME        DATE       DESCRIPTION                             *)
(*    ----------- ---------- ------------------------------------    *)  
(*    CB Lee      12/31/85   Modified the case statement so that     *)
(*                           only component types that have pointers *)
(*                           redefinition records return a TRUE value*)
(*    I. Taller   6/18/86    adding the Tristate component type      *)
(*    I. Taller   9/30/86    adding the FeedBack component type      *)
(*                                                                   *)
(*  COMMENTS  :                                                      *)
(*                                                                   *)
(*  INPUT PARAMETERS :                                               *)
(*                                                                   *)
(*    VARIABLE    TYPE       DESCRIPTION                             *)
(*    ----------- ---------- ------------------------------------    *)
(*    RecordType  integer    The integer index into the Main         *)
(*                           Index Table for the desired record      *)
(*                                                                   *)
(*  GLOBAL VARIABLES:                                                *)
(*                                                                   *)

{vax  [global]  vax}   
 function redefinecomppins ;  

  var
      val        : intXx4;

  begin  (* RedefineCompPins *)

    redefinecomppins := false;

    if  not zglobalerror
    then begin
        val := examinemitrec(recordXtype, componentXclass);

(* If th global variable ZGlobalError is not set, we can guarantee
   the value of Component_Class is valid                             *)

        if  not zglobalerror
        then
            case val of
                ccXterminal,ccXand,ccXor,ccXxor,ccXnand,ccXnor
                        ,ccXxnor,ccXinvbuff,ccXtribuff,ccXinvninvbuff
			,ccXdreg,ccXrsreg,ccXjkreg,ccXbuff:
                    redefinecomppins := false;
                ccXarray,ccXfanio,ccXtristate,ccXfeedback:
                    redefinecomppins := true
            end  (* case .. of *)
        else
            zglobalerr (daafailredefpin, recordXtype)
      end  (* if .. then *)
    else
        zglobalerr (daanexeredefpin, recordXtype);

  end;  (* RedefineCompPins *)

(*

*)

(*                                                                   *)
(*-------------------------------------------------------------------*)
(*                                                                   *)
(*  PROCEDURE : QtyCompPin                                           *)
(*  AUTHOR    : Boris B. Shih                                        *)
(*  DATE      : 11/14/85                                             *)
(*  FUNCTION  : The function gets number of inputs or outputs to     *)
(*              a component, or group of components.                 *)
(*                                                                   *)
(*  MODIFICATIONS :                                                  *)
(*    NAME        DATE       DESCRIPTION                             *)
(*    ----------- ---------- ------------------------------------    *) 
(*    CB Lee      12/31/85   Modified entire routine to make a  call *)
(*                           to RedefineCompPins to determine if an  *)
(*                           address or the actual # of pins is in   *)
(*                           the MITable.                            *)
(*                                                                   *)
(*  COMMENTS  : A return value of j would mean that the specified    *)
(*              connection list, InputList or OutputList, for the    *)
(*              specified RecordType has the range [0..j]. Because   *)
(*              of this interpretation, a value of 0 indicates       *)
(*              that there is one component pin in the list.         *)
(*                                                                   *)
(*  INPUT PARAMETERS :                                               *)
(*                                                                   *)
(*    VARIABLE    TYPE       DESCRIPTION                             *)
(*    ----------- ---------- ------------------------------------    *)
(*    RecordType  integer      The integer index into the Main       *)
(*                             Index Table for the desired record    *)
(*    IOSpec      IOSpecifier  It used to distinguish the inputs     *)
(*                             and outputs component pins            *)
(*                                                                   *)
(*  GLOBAL VARIABLES:                                                *)
(*    NoRecordType   : integer                                       *)
(*    MainIndex      : integer                                       *)
(*    ZGlobalError   : boolean                                       *)
(*                                                                   *)

{vax   [global]  vax}   
 function qtycomppin ;  

  var
         rtnstatus        : intXx4;
         classno          : intXx4;
         recordaddr       : intXx4;
         deflistaddr      : intXx4;
         numberofpins     : intXx4;

  begin  (* QtyCompPin *)

    if not zglobalerror
    then begin
      classno:= examinemitrec(recordXtype, componentXclass);
      if redefinecomppins(recordXtype)
        then begin

          case iXo of
            inputcomp:
              deflistaddr:= examinemitrec(recordXtype, inputdef);
            outputcomp:
              deflistaddr:= examinemitrec(recordXtype, outputdef);
          end;  (* case .. of *)

          if deflistaddr = -1 
            then numberofpins:= 0
          else            
            rtnstatus:= examinelocation(deflistaddr, numberofpins);
        end (* if.. then *)

      else begin
 
        case iXo of
          inputcomp:
            numberofpins:= examinemitrec(recordXtype, inputdef);
          outputcomp:
            numberofpins:= examinemitrec(recordXtype, outputdef);
        end;  (* case .. of *)
                              
      end; (* else *)

(* Is the value returned valid? Otherwise, flag an error. *)
      if valid(numberofpins,minpincount,maxpincount,daapincountoutb)
        then qtycomppin:= numberofpins;

      if zglobalerror
        then begin
          zglobalerr (daafailqtycomppin, recordXtype);
          qtycomppin := -daafailqtycomppin;
        end  (* if .. then *)
    end  (* if .. then *)

(* Global error already detected *)
    else begin
      zglobalerr (daanexeqtycomppin, recordXtype);
      qtycomppin := -daanexeqtycomppin;
    end; (* else *)

  end;  (* QtyCompPin *)

(*

*)

(*                                                                   *)
(*-------------------------------------------------------------------*)
(*                                                                   *)
(*  PROCEDURE : GetAssocLevels                                       *)
(*  AUTHOR    : Boris B. Shih                                        *)
(*  DATE      : 11/15/85                                             *)
(*  FUNCTION  : This function finds out the number of Device Pin     *)
(*              Association levels for a Component Record by the     *)
(*              given RecordType.                                    *)
(*                                                                   *)
(*  MODIFICATIONS :                                                  *)
(*    NAME        DATE       DESCRIPTION                             *)
(*    ----------- ---------- ------------------------------------    *)  
(*                                                                   *)
(*  COMMENTS  :                                                      *)
(*                                                                   *)
(*  INPUT PARAMETERS :                                               *)
(*                                                                   *)
(*    VARIABLE    TYPE       DESCRIPTION                             *)
(*    ----------- ---------- ------------------------------------    *)
(*    RecordType  integer      The integer index into the Main Index *)
(*                             Table for the Component Record used   *)
(*                                                                   *)
(*  GLOBAL VARIABLES:                                                *)
(*                                                                   *)

{vax   [global]  vax} 
 function getassoclevels ;  

  var
         temp       : intXx4;

  begin  (* GetAssocLevels *)

    if  not zglobalerror
      then begin
        temp := examinemitrec(recordXtype, pinassoclevels);

(* Is the value returned valid? Otherwise, flag an error. *)
        if valid(temp,minpinasslevel,maxpinasslevel,daafailgetasslevel)
          then getassoclevels:= temp
        else begin
          zglobalerr (daafailgetasslevel, recordXtype);
          getassoclevels := -daafailgetasslevel;
        end (* else *)
      end (* if..then *)

(* Global error already detected *)
    else begin
        zglobalerr (daanexegetasslevel, recordXtype);
        getassoclevels := -daanexegetasslevel
    end (* else *)

  end;  (* GetAssocLevels *)

(*

*)

(*                                                                   *)
(*-------------------------------------------------------------------*)
(*                                                                   *)
(*  PROCEDURE : QtyPinAssoc                                          *)
(*  AUTHOR    : Boris B. Shih                                        *)
(*  DATE      : 11/15/85                                             *)
(*  FUNCTION  : This function gets the number of fields in the       *)
(*              CITRecord that are occupied by associations of the   *)
(*              spicified level.                                     *)
(*                                                                   *)
(*  MODIFICATIONS :                                                  *)
(*    NAME        DATE       DESCRIPTION                             *)
(*    ----------- ---------- ------------------------------------    *)  
(*    BORIS       11/15/85   initial release                         *)
(*                                                                   *)
(*  COMMENTS  : For a return value of k, the CITRecord for that      *)
(*              RecordType would contain 0 to k pin associations.    *)
(*              If no pin associations exist for that level, then    *)
(*              a value of -1 is returned.                           *)
(*                                                                   *)
(*  INPUT PARAMETERS :                                               *)
(*                                                                   *)
(*    VARIABLE    TYPE       DESCRIPTION                             *)
(*    ----------- ---------- ------------------------------------    *)
(*    RecordType  integer      The integer index into the Main       *)
(*                             Index Table for the desired record    *)
(*    Level       integer      The integer value of the association  *)
(*                             level desired                         *)
(*                                                                   *)
(*  GLOBAL VARIABLES:                                                *)
(*    ZGlobalError     : boolean                                     *)
(*                                                                   *)

{vax   [Global]  vax}    
 function qtypinassoc ;  

  var
         errstatus     : intXx4;
         levelvalue    : intXx4;
         assocdefaddr  : intXx4;
         val           : intXx4;

  begin  (* QtyPinAssoc *)

    if  not zglobalerror
    then begin
        levelvalue := getassoclevels(recordXtype);
        assocdefaddr := examinemitrec (recordXtype, pinassocdef);

        if  not zglobalerror
        then begin
            if  valid(level,0,levelvalue,daafielderror)
            then begin
                errstatus := examinelocation(assocdefaddr + level, val);

                if  errstatus = normal
                then
                    if valid(val,minpinassno,maxpinassno,daapinassocnooutb)
                    then 
                        if (val = 0)
                           then qtypinassoc := -1
                        else qtypinassoc := val;
             end  (* if .. then *)
          end;

        if  zglobalerror
        then begin
            zglobalerr (daafailqtypinass, recordXtype);
            qtypinassoc := -daafailqtypinass;
          end
      end  (* if .. then *)

    else begin
        zglobalerr (daanexeqtypinass, recordXtype);
        qtypinassoc := -daanexeqtypinass
      end;

  end;  (* QtyPinAssoc *)

(*

*)

(*                                                                   *)
(*-------------------------------------------------------------------*)
(*                                                                   *)
(*  PROCEDURE : CountCITRecSize                                      *)
(*  AUTHOR    : Boris B. Shih                                        *)
(*  DATE      : 11/18/85                                             *)
(*  FUNCTION  : This function computes the Component Index Table     *)
(*              record size for a given pin association definition   *)
(*              table address and the number of level be computed.   *)
(*                                                                   *)
(*  MODIFICATIONS :                                                  *)
(*    NAME        DATE       DESCRIPTION                             *)
(*    ----------- ---------- ------------------------------------    *)  
(*    CB Lee      1/1/86     Modified overall flow so that the value *)
(*                           returned by this routine no longer has  *)
(*                           to be adjusted give the true record size*)
(*                                                                   *)
(*  COMMENTS  : If the input level number equals the PinAssocLevels, *)
(*              the return value will be the record size.            *)
(*                                                                   *)
(*  INPUT PARAMETERS :                                               *)
(*                                                                   *)
(*    VARIABLE    TYPE       DESCRIPTION                             *)
(*    ----------- ---------- ------------------------------------    *)
(*    assocdefaddr  integer  The address of AssocDefList             *)
(*    levelvalue    integer  The number of level to be computed      *)
(*                                                                   *)
(*  GLOBAL VARIABLES:                                                *)
(*                                                                   *)

function countcitrecsize (assocdefaddr: intXx4; levelvalue : intXx4): intXx4;

  var
         errstatus       : intXx4;
         i               : intXx4;
         val             : intXx4;
         citrecordlen    : intXx4;

  begin  (* CountCITRecSize *)

    if  not zglobalerror
    then begin
      if (assocdefaddr=-1)  
        then countcitrecsize:=2
      else begin
        citrecordlen := 0;
        i := 0;
        while i<levelvalue do
          begin
            errstatus := examinelocation(assocdefaddr + i, val);
            if  valid(val,minpinassno,maxpinassno,daapinassocnooutb)
              then begin
                i := i + 1;
                citrecordlen := citrecordlen + val;
               end
            else begin
                i := levelvalue + 1;
              end  (* else *)
          end;  (* while .. do *)
        if zglobalerror 
          then begin
            zglobalerr (daafailcntcitsize, nili);
            countcitrecsize:= -daafailcntcitsize;
          end
        else
            countcitrecsize := citrecordlen+1;
      end; (* if..then *)
    end  (* if .. then *)

    else begin
        zglobalerr (daanexecntcitsize, nili);
        countcitrecsize := -daanexecntcitsize
      end

  end;  (* CountCITRecSize *)

(*

*)

(*                                                                   *)
(*-------------------------------------------------------------------*)
(*                                                                   *)
(*  PROCEDURE : GetComponentLoc                                      *)
(*  AUTHOR    : Boris B. Shih                                        *)
(*  DATE      : 11/15/85                                             *)
(*  FUNCTION  : This function gets the integer index to a specific   *)
(*              Component Record.                                    *)
(*                                                                   *)
(*  MODIFICATIONS :                                                  *)
(*    NAME        DATE       DESCRIPTION                             *)
(*    ----------- ---------- ------------------------------------    *)  
(*                                                                   *)
(*  COMMENTS  :                                                      *)
(*                                                                   *)
(*  INPUT PARAMETERS :                                               *)
(*                                                                   *)
(*    VARIABLE    TYPE       DESCRIPTION                             *)
(*    ----------- ---------- ------------------------------------    *)
(*    RecordType  integer      The integer index into the Main Index *)
(*                             Table for the desired record          *)
(*    CITIndex    integer      The integer index of the desired      *)
(*                             component within the Component Index  *)
(*                             Table                                 *)
(*                                                                   *)
(*  GLOBAL VARIABLES:                                                *)
(*    ZGlobalError     : boolean                                     *)
(*                                                                   *)
{vax   [Global]  vax}   
 function getcomponentloc ;  

  var
         errstatus    : intXx4;
         levelvalue   : intXx4;
         citrecordlen : intXx4;
         assocdefaddr : intXx4;
         val          : intXx4;
         temp         : intXx4;
         mitrecbuf    : mitrecord;

  begin  (* GetComponentLoc *)

    if  not zglobalerror
    then begin
        levelvalue   := getassoclevels (recordXtype);
        mitrecbuf    := getmitrec(recordXtype);
        assocdefaddr := mitrecbuf[pinassocdef];
        citrecordlen := countcitrecsize (assocdefaddr, levelvalue);
        returnflag := examinelocation((mitrecbuf[citlocation]+citindex*citrecordlen),val);
        returnflag := examinelocation( mitrecbuf[citlocation],mincompaddr);
        returnflag := examinelocation((mitrecbuf[citlocation]+(mitrecbuf[nocomponents]-1)*citrecordlen),maxcompaddr);

        if valid(val,mincompaddr,maxcompaddr,daalocationoutb)
          then getcomponentloc:= val
        else begin
            zglobalerr (daafailgetcomploc, recordXtype);
            getcomponentloc := -daafailgetcomploc;
        end; (* else *)
      end

    else begin
        zglobalerr (daanexegetcomploc, recordXtype);
        getcomponentloc :=-daanexegetcomploc;
      end

  end;  (* GetComponentLoc *)

(*

*)

(*                                                                   *)
(*-------------------------------------------------------------------*)
(*                                                                   *)
(*  PROCEDURE : GetPinAssoc                                          *)
(*  AUTHOR    : Boris B. Shih                                        *)
(*  DATE      : 11/18/85                                             *)
(*  FUNCTION  : This function returns an integer value which         *)
(*              indicates a association pin number or an error code  *)
(*              DAANoMorePinAssc.                                    *)
(*                                                                   *)
(*  MODIFICATIONS :                                                  *)
(*    NAME        DATE       DESCRIPTION                             *)
(*    ----------- ---------- ------------------------------------    *)  
(*    I. Taller   6/18/86    changes for ZHAL20			     *)
(*                                                                   *)
(*  COMMENTS  :                                                      *)
(*                                                                   *)
(*  INPUT PARAMETERS :                                               *)
(*                                                                   *)
(*    VARIABLE    TYPE       DESCRIPTION                             *)
(*    ----------- ---------- ------------------------------------    *)
(*    RecordType  integer      An integer index in the Main Index    *)
(*                             Table for the desired record          *)
(*    CITIndex    integer      The integer index of the desired      *)
(*                             component within the Component Index  *)
(*                             Table                                 *)
(*    Level       integer      The integer value of the association  *)
(*                             pin desired                           *)
(*    PinCount    integer      An integer value to specify which pin *)
(*                             should be accessed                    *)
(*                                                                   *)
(*  GLOBAL VARIABLES:                                                *)
(*    ZGlobalError      : boolean                                    *)
(*                                                                   *)

{vax  [global]  vax}   
 function getpinassoc ;  

  var
          citaddr       : intXx4;
          assocdefaddr  : intXx4;
          asslevelno    : intXx4;
          pinasscno     : intXx4;
          citrecsize    : intXx4;
          citrecaddr    : intXx4;
          levelstaddr   : intXx4;
          val           : intXx4;

  begin  (* GetPinAssoc *)

    if  not zglobalerror
    then begin
        assocdefaddr:= examinemitrec (recordXtype, pinassocdef);
        pinasscno   := qtypinassoc (recordXtype, level);

        if  not zglobalerror
        then begin
            if  currpin <=  (pinasscno - 1)
            then begin
                asslevelno := examinemitrec(recordXtype, pinassoclevels);
                citaddr    := examinemitrec(recordXtype, citlocation) ;
                citrecsize := countcitrecsize(assocdefaddr, asslevelno);
                citrecaddr := citaddr + citindex * citrecsize;
                levelstaddr:= citrecaddr + countcitrecsize(assocdefaddr,level);
                returnflag := examinelocation(levelstaddr + currpin, val); 
                returnstatus := valid(abs(val), -maxdevicepin, maxdevicepin, daapinnooutb);
              end
            else begin
                val          := nomoredevpinassc;
                rowpincntkeeper:= initrowpincntkp;
              end
          end;  (* if .. then *)

        if  zglobalerror
        then begin
            zglobalerr (daafailgetpinass, recordXtype);
            getpinassoc := -daafailgetpinass
           end
        else
            getpinassoc := val;
      end
    else begin
        zglobalerr (daanexegetpinass, recordXtype);
        getpinassoc := -daanexegetpinass
      end

  end;  (* GetPinAssoc *)

(*

*)

(*                                                                   *)
(*-------------------------------------------------------------------*)
(*                                                                   *)
(*  PROCEDURE : GetPinAssocT                                         *)
(*  AUTHOR    : Boris B. Shih                                        *)
(*  DATE      :                                                      *)
(*  FUNCTION  : This function gets the Device Pin Associations       *)
(*              for a given Component Record, for a given level.     *)
(*                                                                   *)
(*  MODIFICATIONS :                                                  *)
(*    NAME        DATE       DESCRIPTION                             *)
(*    ----------- ---------- ------------------------------------    *)  
(*    Boris                  initial release                         *)
(*    CJ          3/6/86     modification                            *)
(*                                                                   *)
(*  COMMENTS  :                                                      *)
(*                                                                   *)
(*  INPUT PARAMETERS :                                               *)
(*                                                                   *)
(*    VARIABLE    TYPE       DESCRIPTION                             *)
(*    ----------- ---------- ------------------------------------    *)
(*    RecordType  integer      The integer index for the Main Index  *)
(*                             Table of the desired record           *)
(*    CITIndex    Integer      The integer index of the desired      *)
(*                             component within the CIT              *)
(*    Level       integer      The integer value of the Device Pin   *)
(*                             Association level                     *)
(*                                                                   *)
(*  GLOBAL VARIABLES:                                                *)
(*    CountKeeper     : integer                                      *)
(*                      The counter keeps the pin count which        *)
(*                      should be processed next                     *)
(*                                                                   *)

{vax   [global]  vax}   
 function getpinassoct ;  

const nomorpinassoc = -1;
  var
         val        : intXx4;

  begin  (* GetPinAssocT *)

    if  not zglobalerror
    then begin
        val := getpinassoc (recordXtype, citindex, level, countkeeper);

(* If the global variable ZGlobalError is not set, we can guarantee
   that the returning value is valid                                   *)

        if  not zglobalerror
        then begin
            getpinassoct := val;
            if val <> nomorpinassoc
              then countkeeper := countkeeper + 1
              else countkeeper := 0;
          end
        else begin
            zglobalerr (daafailgetpinasst, recordXtype);
            getpinassoct := -daafailgetpinasst;
          end
      end
    else begin
        zglobalerr (daanexegetpinasst, recordXtype);
        getpinassoct := -daanexegetpinasst;
      end

  end;  (* GetPinAssocT *)

(*

*)

(*-------------------------------------------------------------------*)
(*                                                                   *)
(*  PROCEDURE : GetRecordType                                        *)
(*  AUTHOR    : CB Lee        					     *)
(*  DATE      : 11/19/85                                             *)
(*  FUNCTION  : This function extracts the Record_Type field         *)
(*              from the specified Component Record.                 *)
(*                                                                   *)
(*  MODIFICATIONS :                                                  *)
(*    NAME        DATE       DESCRIPTION                             *)
(*    ----------- ---------- ------------------------------------    *)
(*    M. Gzowski  2/14/86    changed proc. parameter type to int_X4  *)
(*                                                                   *)
(*  COMMENTS  :                                                      *)
(*                                                                   *)
(*  INPUT PARAMETERS :                                               *)
(*                                                                   *)
(*    VARIABLE    TYPE       DESCRIPTION                             *)
(*    ----------- ---------- ------------------------------------    *)
(*   ComponentLoc integer    the integer index to the desired        *)
(*                           component.                              *)
(*                                                                   *)
(*  GLOBAL VARIABLES:                                                *)
(*      ZGlobalError   : boolean                                     *)       
(*                                                                   *)

{vax    [Global]   vax}   
(* MEG 2/14/86 *)
 function getrecordtype ;  

var
      recordtype       : intXx4;
      rtnstatus        : intXx4;
      tgetrecordtype   : intXx4;

begin  (* GetRecordType *)

  if  not zglobalerror
  then begin
      rtnstatus := examinelocation(componentloc, recordtype);
      if  rtnstatus = normal
      then
          if valid(recordtype,minrecordtype,norecordtype,daarecordtypeoutb)
          then
              tgetrecordtype := recordtype;

(* Has global error been tripped from within this routine? *)

      if  zglobalerror
      then begin 
          zglobalerr(daafailgetrecordtype, componentloc);
          tgetrecordtype := -daafailgetrecordtype;
        end; (* if..then *)
    end (* if..then *)

  else begin
      zglobalerr(daanexegetrecordtype, nili);
      tgetrecordtype := -daanexegetrecordtype; 
    end; (* else *)

  getrecordtype := tgetrecordtype;

end;  (* GetRecordType *)


(*

*)

(*                                                                   *)
(*-------------------------------------------------------------------*)
(*                                                                   *)
(*  PROCEDURE : FindLimitRecord                                      *)
(*  AUTHOR    : Boris B. Shih                                        *)
(*  DATE      : 11/26/85                                             *)
(*  FUNCTION  : This function gets the Limited_IO_Record of the      *)
(*              RecordType specified by the ComponentLoc             *)
(*                                                                   *)
(*  MODIFICATIONS :                                                  *)
(*    NAME        DATE       DESCRIPTION                             *)
(*    ----------- ---------- ------------------------------------    *)  
(*    CB Lee      1/1/86     Modified to allow LimitedIORecords for  *)
(*                           FanIO type records also. Corrected      *)
(*                           for matching on component class rather  *)
(*                           than record types.                      *)
(*    I. Taller   6/18/86    Modified to allow LimitedIORecords for  *)
(*                           TriState type records also. 	     *)
(*    I. Taller   9/30/86    Modified to allow LimitedIORecords for  *)
(*                           FeedBack type records also. 	     *)
(*                                                                   *)
(*  COMMENTS  :                                                      *)
(*                                                                   *)
(*  INPUT PARAMETERS :                                               *)
(*                                                                   *)
(*    VARIABLE    TYPE       DESCRIPTION                             *)
(*    ----------- ---------- ------------------------------------    *)
(*    ComponentLoc integer   The integer index to the desired Array  *)
(*                           Component                               *)
(*    RowCol      LineType   A value of type LineType                *)
(*                                                                   *)
(*  GLOBAL VARIABLES:                                                *)
(*    ZGlobalError       : integer                                   *)
(*                                                                   *)

{vax  [global]  vax}   
 function findlimitrecord ;  

var
         rectype          : intXx4;
         iorecaddr        : intXx4;
         classno          : intXx4;
         outputaddr       : intXx4;
         inputaddr        : intXx4;
         tempbuf          : limitiorecord;

begin  (* FindLimitRecord *)

  if  not zglobalerror
    then begin
      rectype   := getrecordtype(componentloc);
      classno   := examinemitrec(rectype, componentXclass);
      outputaddr:= examinemitrec(rectype, outputdef);
      inputaddr := examinemitrec(rectype, inputdef);

      if  (classno=ccXarray) or (classno=ccXfanio) or (classno=ccXtristate)
	  or (classno=ccXfeedback) 
        then begin
          case rowcol of
            row    : iorecaddr := outputaddr;
            column : iorecaddr := inputaddr;
          end;  (* case .. of *)

          returnflag := examinelocation (iorecaddr,  tempbuf[nototal]);
          returnflag := examinelocation (iorecaddr+1,tempbuf[maxusage]);

          if  valid(tempbuf[maxusage],minmaxusage,maxmaxusage,daafielderror) 
          and valid(tempbuf[nototal],minnototal,maxnototal,daafielderror)
            then findlimitrecord := tempbuf
          else zglobalerr (daafielderror, nili);
        end  (* if .. then *)
      else
        zglobalerr (daarectypenotarray, rectype);

      if  zglobalerror
        then begin
          zglobalerr (daafailfindlimitr, componentloc);
          tempbuf[nototal]  := -daafailfindlimitr;
          tempbuf[maxusage] := -daafailfindlimitr;
          findlimitrecord := tempbuf;
        end;
    end (* if..then *)

  else begin
    zglobalerr (daanexefindlimitr, componentloc);
    tempbuf[nototal] := -daanexefindlimitr;
    tempbuf[maxusage] := -daanexefindlimitr;
    findlimitrecord := tempbuf;
  end;

end;  (* FindLimitRecord *)


(*

*)

(*                                                                   *)
(*-------------------------------------------------------------------*)
(*                                                                   *)
(*  PROCEDURE : RowColOffset                                         *)
(*  AUTHOR    : Boris B. Shih                                        *)
(*  DATE      : 12/2/85                                              *)
(*  FUNCTION  : The function calculates the memory occupied by the   *)
(*              desired number of rows from the specified address    *)
(*                                                                   *)
(*  MODIFICATIONS :                                                  *)
(*    NAME        DATE       DESCRIPTION                             *)
(*    ----------- ---------- ------------------------------------    *)  
(*                                                                   *)
(*  COMMENTS  :                                                      *)
(*                                                                   *)
(*  INPUT PARAMETERS :                                               *)
(*                                                                   *)
(*    VARIABLE    TYPE       DESCRIPTION                             *)
(*    ----------- ---------- ------------------------------------    *)
(*    StartAddr    integer   The integer index to the desired array  *)
(*                           component record                        *)
(*    LimitRec     LimitIORecord  The Limit IO Record                *)
(*                                                                   *)
(*  GLOBAL VARIABLES:                                                *)
(*    ZGlobalError        : boolean                                  *)
(*    StandardIntactNo    : integer                                  *)
(*                                                                   *)

function rowcoloffset (pinnumber : intXx4; usage : intXx4) : intXx4;

var
       rowcolsize : intXx4;

begin  (* RowColOffset *)

  if  not zglobalerror
  then begin

(* Sparse line option                                   *)
    if  usage <= standardintactno
      then rowcolsize:= pinnumber * (usage + iorecsize)

(* Dense line option                                    *)
    else   rowcolsize:= pinnumber * rowdenserecsize;

    if  zglobalerror
      then begin
        zglobalerr(daafailrowcoloffset, nili);
        rowcoloffset:= -daafailrowcoloffset
      end
    else rowcoloffset:= rowcolsize;
  end  (* if .. then *)

  else begin
      zglobalerr(daanexerowcoloffset, nili);
      rowcoloffset:= -daanexerowcoloffset
    end;

end;  (* RowColOffset *)

(*

*)

(*                                                                   *)
(*-------------------------------------------------------------------*)
(*                                                                   *)
(*  PROCEDURE : FindLineAddress                                      *)
(*  AUTHOR    : Boris B. Shih                                        *)
(*  DATE      : 12/2/85                                              *)
(*  FUNCTION  : The function calculates the array record starting    *)
(*              address of the desired array record                  *)
(*                                                                   *)
(*  MODIFICATIONS :                                                  *)
(*    NAME        DATE       DESCRIPTION                             *)
(*    ----------- ---------- ------------------------------------    *)  
(*    I. Taller   4/3/86     Array Format: columns lines first,      *)
(*			     Rows lines second.			     *)
(*                                                                   *)
(*  COMMENTS  :                                                      *)
(*                                                                   *)
(*  INPUT PARAMETERS :                                               *)
(*                                                                   *)
(*    VARIABLE    TYPE       DESCRIPTION                             *)
(*    ----------- ---------- ------------------------------------    *)
(*    ComponentLoc integer   The integer index to the desired array  *)
(*                           component                               *)
(*    LineIndex    integer   The integer index to the line within    *)
(*                           the array component                     *)
(*    RowOrColumn  LineType  Specifies whether LinIndex refers to a  *)
(*                           row or a column                         *)
(*                                                                   *)
(*  GLOBAL VARIABLES:                                                *)
(*    ZGlobalError        : boolean                                  *)
(*                                                                   *)

(* IT 4/3/86 *)
{vax  [global]  vax}
 function findlineaddress ;  

var
       rowcoladdr     : intXx4;
       offset         : intXx4;
       skipcolumns    : intXx4;
       iobuffer       : limitiorecord;
       colbuffer      : limitiorecord;

begin  (* FindLineAddress *)

if  not zglobalerror
  then begin
    iobuffer := findlimitrecord(componentloc, roworcolumn);
    offset   := rowcoloffset(lineindex,iobuffer[maxusage]);

    if (roworcolumn = row) then 
    begin
    	colbuffer := findlimitrecord(componentloc,column);
    	arrayrows := colbuffer[nototal];
	skipcolumns := rowcoloffset(arrayrows,colbuffer[maxusage]);
    end
    else skipcolumns := 0;
    rowcoladdr := componentloc + skipcolumns + offset;

    if  zglobalerror
      then begin
        zglobalerr (daafailfindladdr, componentloc);
        findlineaddress := -daafailfindladdr;
      end  (* if .. then *)
    else
      (* advance past one location to account for the record type *)
      findlineaddress := rowcoladdr + 1;
  end  (* if .. then *)

else begin
    zglobalerr (daanexefindladdr, componentloc);
    findlineaddress := -daanexefindladdr;
  end;

end;  (* FindLineAddress *)


(*

*)

(*-------------------------------------------------------------------*)
(*                                                                   *)
(*  PROCEDURE : GetConnection                                        *)
(*  AUTHOR    : Boris B. Shih                                        *)
(*  DATE      : 11/19/85                                             *)
(*  FUNCTION  : This function gets the IOType record for the         *)
(*              specified connection.                                *)
(*                                                                   *)
(*  MODIFICATIONS :                                                  *)
(*    NAME        DATE       DESCRIPTION                             *)
(*    ----------- ---------- ------------------------------------    *)  
(*    M.Gzowski   4/18/86    fix for bug #793			     *)
(*    I. Taller   6/18/86    Modified to allow GetConnection for     *)
(*                           TriState type records also. 	     *)
(*    I. Taller   9/30/86    Modified to allow GetConnection for     *)
(*                           FeedBack type records also. 	     *)
(*                                                                   *)
(*  COMMENTS  : The IOType record contains the integer index to the  *)
(*              next or adjacent component and the status of the     *)
(*              connection : has been used, may be used, may not be  *)
(*              used, and preallocated.                              *)
(*                                                                   *)
(*  INPUT PARAMETERS :                                               *)
(*                                                                   *)
(*    VARIABLE    TYPE       DESCRIPTION                             *)
(*    ----------- ---------- ------------------------------------    *)
(*    ComponentLoc integer   The integer index to the desired        *)
(*                           component                               *)
(*    IOSpec       IOSpecifier Used to distinguish between the       *)
(*                             inputs and outputs component pins     *)
(*    CompPinNumber integer  The offset in the OutputList (RowList)  *)
(*                           or InputList (ColumnList) and is in the *)
(*                           range defined by InputDef or OutputDef  *)
(*                                                                   *)
(*  GLOBAL VARIABLES:                                                *)
(*    ZGlobalError         : boolean                                 *)
(*    StandardIntactNo     : integer                                 *)
(*                                                                   *)

{vax   [global]  vax}   
 function getconnection ;  

var
         rectype       : intXx4;
         iotypeaddr    : intXx4;
         classno       : intXx4;
         noinputs      : intXx4;
         nooutputs     : intXx4;
         iotypebuf     : iotype;
         ltdiobuffer   : limitiorecord;

begin  (* GetConnection *)
  if  not zglobalerror
    then begin
      rectype := getrecordtype (componentloc);
      classno := examinemitrec(rectype, componentXclass);

      if  not redefinecomppins(rectype)
        then begin
          noinputs := examinemitrec(rectype, inputdef);
          nooutputs:= examinemitrec(rectype, outputdef);
        end
      else begin
        returnflag := examinelocation(examinemitrec(rectype, inputdef), noinputs);
        returnflag := examinelocation(examinemitrec(rectype, outputdef), nooutputs);
      end;

      case iXo of
          inputcomp  : begin
                       if (noinputs = 0) or not valid(comppinnumber, 0, noinputs, daapincountoutb)
                        then zglobalerr(daafielderror, comppinnumber);
                       end;
          outputcomp : begin
                       if (nooutputs = 0) or not valid(comppinnumber, 0, nooutputs, daapincountoutb)
                        then zglobalerr(daafielderror, comppinnumber);
                       end;
      end; (* case *)          

      if  (not zglobalerror) and (iotypebuf[nextXcomponent] <> vln)
        then begin
          case classno of

(* If classno = CC_Array, inputcomp means we have to access Column area
   and outputcomp to access Row area                                     *)

              ccXarray : begin
                   if  iXo = inputcomp
                     then begin
                       ltdiobuffer:= findlimitrecord(componentloc, column);
                       iotypeaddr := findlineaddress(componentloc, comppinnumber,column);
                     end  (* if .. then *)
                   else begin
                       ltdiobuffer:= findlimitrecord(componentloc, row);
                       iotypeaddr := findlineaddress(componentloc, comppinnumber,row);
                   end;  (* else *)

                   if  ltdiobuffer[maxusage] <= standardintactno
                     then iotypeaddr:= iotypeaddr + ltdiobuffer[maxusage]
                   else   iotypeaddr:= iotypeaddr;

                end;  (* CC_Array *)
     
              ccXfanio, ccXtristate, ccXfeedback: begin
                  if  iXo = inputcomp
                    then iotypeaddr:= componentloc + 3 +  comppinnumber * iorecsize
                  else   iotypeaddr:= componentloc + 3 + (comppinnumber + noinputs) * iorecsize;
                end; (* CC FanIO.. *)

              ccXterminal,ccXand,ccXor,ccXxor,ccXnand,ccXnor,ccXxnor,
		ccXinvbuff,ccXinvninvbuff,ccXtribuff,ccXbuff,ccXdreg,
		ccXrsreg,ccXjkreg: begin
                  if  iXo = inputcomp
                    then iotypeaddr:= componentloc + 1 +  comppinnumber * iorecsize
                  else   iotypeaddr:= componentloc + 1 + (comppinnumber + noinputs) * iorecsize;
                end;  (* CC_Terminal.. *)

          end; (* case .. of *)

(* We can guarantee the values we get above are valid , if the global
   variable ZGlobalError is not set                                    *)

          returnflag := examinelocation(iotypeaddr,  iotypebuf[nextXcomponent]);

          returnflag := examinelocation(iotypeaddr+1,iotypebuf[flag]);

(* MEG 3/12/86, bug #762 *)
          if  (iotypebuf[nextXcomponent] < 0)
            then zglobalerr(daafielderror, noinputs);

          getconnection:= iotypebuf;

      end; (* if..then *)

      if zglobalerror 
        then begin
          zglobalerr(daafailgetconnec, componentloc);
          iotypebuf[nextXcomponent]:= -daafailgetconnec;
          iotypebuf[flag]:= -daafailgetconnec;
          getconnection:= iotypebuf;
      end; (* if..then *)

    end  (* if..then *)
  else begin
(* MEG 4/18/86  #493 *)
(*     ZGlobalErr(DAANExeGetConnec, ComponentLoc); *)
      iotypebuf[nextXcomponent]:= -daanexegetconnec;
      iotypebuf[flag]:= -daanexegetconnec;
      getconnection  := iotypebuf;
    end;

end;  (* GetConnection *)
(*

*)

(*-------------------------------------------------------------------*)
(*                                                                   *)
(*  PROCEDURE : ConnectsAvail                                        *)
(*  AUTHOR    : CJ Chien                                             *)
(*  DATE      : 3/8/86                                               *)
(*  FUNCTION  : This function checks the connection for a desired    *)
(*              component and see if there is any free connection    *)
(*              and return the Free number                           *)
(*                                                                   *)
(*                                                                   *)
(*  MODIFICATIONS :                                                  *)
(*    NAME        DATE       DESCRIPTION                             *)
(*    ----------- ---------- ------------------------------------    *) 
(*    CJ          4/8/86     initial release                         *)
(*                                                                   *)
(*  INPUT PARAMETERS :                                               *)
(*                                                                   *)
(*    VARIABLE    TYPE       DESCRIPTION                             *)
(*    ----------- ---------- ------------------------------------    *)
(*    CompoLoc integer   The integer index to the desired            *)
(*                           component                               *)
(*    IOSpec       IOSpecifier Used to distinguish between the       *)
(*                             inputs and outputs component pins     *)
(*                                                                   *)
(*                                                                   *)

{vax [Global] vax} 
 function connectsavail;  
var comprectype : intXx4;
    iopinno     : intXx4;
    compno      : intXx4; 
    iorec       : iotype;
    noofconnection:intXx4;
begin (* ConnectsAvail *)
      comprectype := getrecordtype(componentloc);
      iopinno     := qtycomppin(comprectype,iXo);
      noofconnection := 0;
      for compno := 0 to (iopinno-1) do
      begin
           iorec := getconnection(componentloc,iXo,compno);
           if not ((iorec[flag] < 0) and (iorec[flag] >= -vln))
              then
                  noofconnection := succ(noofconnection);
      end; (* for *)
      connectsavail := noofconnection;
end; (* ConnectsAvail *) 
(*                

*)
(*

*)

(*-------------------------------------------------------------------*)
(*                                                                   *)
(*  PROCEDURE : CntHardConnection                                     *)
(*  AUTHOR    : CJ Chien                                             *)
(*  DATE      : 3/8/86                                               *)
(*  FUNCTION  : This function checks the connection for a desired    *)
(*              component and see if it is hard connection           *)
(*                                                                   *)
(*                                                                   *)
(*  MODIFICATIONS :                                                  *)
(*    NAME        DATE       DESCRIPTION                             *)
(*    ----------- ---------- ------------------------------------    *) 
(*    CJ          4/8/86     initial release                         *)
(*                                                                   *)
(*  INPUT PARAMETERS :                                               *)
(*                                                                   *)
(*    VARIABLE    TYPE       DESCRIPTION                             *)
(*    ----------- ---------- ------------------------------------    *)
(*    ComponentLoc  int_x4                                           *)
(*    I_O           IOSpecifier                                      *)
(*                                                                   *)
(*                                                                   *)

 {vax [Global] vax} 
 function cnthardconnection;  
var comprectype : intXx4;
    iopinno     : intXx4;
    compno      : intXx4; 
    iorec       : iotype;
    noofhc      : intXx4;
begin (* CntHardConnection *)
      comprectype := getrecordtype(componentloc);
      iopinno     := qtycomppin(comprectype,iXo);
      noofhc      := 0;
      for compno := 0 to (iopinno-1) do
      begin
           iorec := getconnection(componentloc,iXo,compno);
           if (iorec[flag] = 0) 
              then
                  noofhc := succ(noofhc);
      end; (* for *)
      cnthardconnection := noofhc;
end; (* CntHardConnection *) 
(*                

*)

(*-------------------------------------------------------------------*)
(*                                                                   *)
(*  PROCEDURE : ConnectFull                                          *)
(*  AUTHOR    : CJ Chien                                             *)
(*  DATE      : 3/5/86                                               *)
(*  FUNCTION  : This function checks the connection for a desired    *)
(*              component and see if there is any free connection    *)
(*              or all used                                          *)
(*                                                                   *)
(*  MODIFICATIONS :                                                  *)
(*    NAME        DATE       DESCRIPTION                             *)
(*    ----------- ---------- ------------------------------------    *) 
(*    CJ          3/5/86     initial release                         *)
(*                                                                   *)
(*  INPUT PARAMETERS :                                               *)
(*                                                                   *)
(*    VARIABLE    TYPE       DESCRIPTION                             *)
(*    ----------- ---------- ------------------------------------    *)
(*    CompoLoc integer   The integer index to the desired            *)
(*                           component                               *)
(*    IOSpec       IOSpecifier Used to distinguish between the       *)
(*                             inputs and outputs component pins     *)
(*                                                                   *)
(*                                                                   *)
{vax  [Global]  vax} 
 function connectfull;  
var recordtype : intXx4;
    idef       : intXx4;
    iorec      : iotype;
    compno     : intXx4;
    full       : boolean;
    limitio    : limitiorecord; 
begin  (* ConnectFull *)
     full := true;
     recordtype := getrecordtype(comploc);
     idef := qtycomppin(recordtype,io);
     if redefinecomppins(recordtype)
       then
            case io of
            inputcomp: begin
                       limitio := findlimitrecord(comploc,column);
                       idef    := limitio[nototal];
                       end;
            outputcomp:begin
                       limitio := findlimitrecord(comploc,row); 
                       idef    := limitio[nototal];
                       end;
            end; (* case *)
     compno := 1;
     while (compno <= idef) and (full)  do
              begin
                iorec := getconnection(comploc,io,compno-1);
                if (iorec[flag] <= 0) and (iorec[flag] >= -vln)
                     then
                         compno := succ(compno)
                     else 
                         full := false;
              end; (* while *)
    if redefinecomppins(recordtype)
                then
                    begin
                    if compno > limitio[maxusage]
                      then
                          full := true;
                    end
                else
                    if compno > idef
                      then
                          full := true;
    connectfull := full;
end; (* connectfull *)       
     

(*

*)

(*                                                                   *)
(*-------------------------------------------------------------------*)
(*                                                                   *)
(*  PROCEDURE : PutConnection                                        *)
(*  AUTHOR    : Boris B. Shih                                        *)
(*  DATE      : 11/25/85                                             *)
(*  FUNCTION  : This procedure puts an IOType record into the        *)
(*              specified connection.                                *)
(*                                                                   *)
(*  MODIFICATIONS :                                                  *)
(*    NAME        DATE       DESCRIPTION                             *)
(*    ----------- ---------- ------------------------------------    *)  
(*    M. Gzowski  4/18/86    remove debug error call, bug #793       *)
(*    I. Taller   6/18/86    Modified to allow PutConnection for     *)
(*                           TriState type records also. 	     *)
(*    I. Taller   9/30/86    Modified to allow PutConnection for     *)
(*                           FeedBack type records also. 	     *)
(*                                                                   *)
(*  COMMENTS  :                                                      *)
(*                                                                   *)
(*  INPUT PARAMETERS :                                               *)
(*                                                                   *)
(*    VARIABLE    TYPE       DESCRIPTION                             *)
(*    ----------- ---------- ------------------------------------    *)
(*    ComponentLoc integer   The integer index to the desired        *)
(*                           component                               *)
(*    IOSpec       IOSpecifier Used to distinguish between the       *)
(*                             inputs and outputs component pins     *)
(*    CompPinNumber integer  The offset in the OutputList (RowList)  *)
(*                           or InputList (ColumnList) and is in the *)
(*                           range defined by InputDef or OutputDef  *)
(*    Connection   IOType    A record of type IOType                 *)
(*                                                                   *)
(*  GLOBAL VARIABLES:                                                *)
(*    ZGlobalError         : boolean                                 *)
(*    StandardIntactNo     : integer                                 *)
(*                                                                   *)
{vax  [global]  vax}  
 procedure putconnection ;  

var
         rectype       : intXx4;
         iotypeaddr    : intXx4;
         classno       : intXx4;
         noinputs      : intXx4;
         nooutputs     : intXx4;
         ltdiobuffer   : limitiorecord;

begin  (* putConnection *)

  if  not zglobalerror
    then begin
      rectype := getrecordtype (componentloc);
      classno := examinemitrec(rectype, componentXclass);

      if  not redefinecomppins(rectype)
        then begin
          noinputs := examinemitrec(rectype, inputdef);
          nooutputs:= examinemitrec(rectype, outputdef);
        end
      else begin
        returnflag := examinelocation(examinemitrec(rectype, inputdef), noinputs);
        returnflag := examinelocation(examinemitrec(rectype, outputdef), nooutputs);
      end;

      case iXo of
          inputcomp  :
                      if(noinputs=0)or  not valid(comppinnumber, 0, noinputs, daapincountoutb)
                        then zglobalerr(daafielderror, comppinnumber);
          outputcomp :
                      if (nooutputs = 0)or not valid(comppinnumber, 0, nooutputs, daapincountoutb)
                        then zglobalerr(daafielderror, comppinnumber);
      end; (* case *)          

      if  not zglobalerror
        then begin
          case classno of

(* If classno = CC_Array, inputcomp means we have to access Column area
   and outputcomp to access Row area                                     *)

              ccXarray : begin
                   if  iXo = inputcomp
                     then begin
                       ltdiobuffer:= findlimitrecord(componentloc, column);
                       iotypeaddr := findlineaddress(componentloc, comppinnumber,column);
                     end  (* if .. then *)
                   else begin
                       ltdiobuffer:= findlimitrecord(componentloc, row);
                       iotypeaddr := findlineaddress(componentloc, comppinnumber,row);
                   end;  (* else *)

                   if  ltdiobuffer[maxusage] <= standardintactno
                     then iotypeaddr:= iotypeaddr + ltdiobuffer[maxusage]
                   else   iotypeaddr:= iotypeaddr;
                end;  (* CC_Array *)
     
              ccXfanio, ccXtristate, ccXfeedback: begin
                  if  iXo = inputcomp
                    then iotypeaddr:= componentloc + 3 +  comppinnumber * iorecsize
                  else   iotypeaddr:= componentloc + 3 + (comppinnumber + noinputs) * iorecsize;
                end; (* CC FanIO.. *)

              ccXterminal,ccXand,ccXor,ccXxor,ccXnand,ccXnor,ccXxnor,
		ccXinvbuff,ccXinvninvbuff,ccXtribuff,ccXbuff,ccXdreg,
		ccXrsreg,ccXjkreg: begin
                  if  iXo = inputcomp
                    then iotypeaddr:= componentloc + 1 +  comppinnumber * iorecsize
                  else   iotypeaddr:= componentloc + 1 + (comppinnumber + noinputs) * iorecsize;
                end;  (* CC_Terminal.. *)

          end; (* case .. of *)

(* We can guarantee the values we get above are valid , if the global
   variable ZGlobalError is not set                                    *)

          returnflag := putlocation(iotypeaddr,  connection[nextXcomponent]);
          returnflag := putlocation(iotypeaddr+1,connection[flag]);

      end; (* if..then *)

      if zglobalerror 
        then zglobalerr(daafailgetconnec, componentloc);

    end;  (* if..then *)

  end;  (* PutConnection *)


(*

*)

(*-------------------------------------------------------------------*)
(*                                                                   *)
(*  PROCEDURE : ArrayNext                                            *)
(*  AUTHOR    : CB Lee        					     *)
(*  DATE      : 11/19/85                                             *)
(*  FUNCTION  : This function gets the Record_Type of all components *)
(*              connected to the outputs of the Array component.     *)
(*                                                                   *)
(*  MODIFICATIONS :                                                  *)
(*    NAME        DATE       DESCRIPTION                             *)
(*    ----------- ---------- ------------------------------------    *)
(*    I. Taller   4/3/86     Array Format: columns lines first,      *)
(*			     Rows lines second.			     *)
(*                                                                   *)
(*  COMMENTS  :                                                      *)
(*                                                                   *)
(*  NOTE:  All outputs of an Array component must be connected to    *)
(*         components with identical Record_Type.                    *)
(*                                                                   *)
(*  INPUT PARAMETERS :                                               *)
(*                                                                   *)
(*    VARIABLE    TYPE       DESCRIPTION                             *)
(*    ----------- ---------- ------------------------------------    *)
(*   ComponentLoc integer    the integer index to the desired        *)
(*                           array component.                        *)
(*                                                                   *)
(*  GLOBAL VARIABLES:                                                *)
(*    ZGlobalError        : boolean                                  *)
(*                                                                   *)


(* IT 4/3/86 *)
{vax  [global]  vax}
 function arraynext ;  

var
      iotypeaddr       : intXx4;
      nextcompaddr     : intXx4;
      compclass        : intXx4;
      rectype          : intXx4;
      tempbuf          : limitiorecord;

begin  (* ArrayNext *)

  if  not zglobalerror
  then begin
      rectype  := getrecordtype(componentloc);
      compclass:= examinemitrec(rectype,componentXclass);
      tempbuf  := findlimitrecord(componentloc, row);

      if  not zglobalerror
      then begin
          if  compclass=ccXarray
          then begin 

	      iotypeaddr := findlineaddress(componentloc, 0, row);

              if tempbuf[maxusage]<=standardintactno
              then
                  iotypeaddr:= iotypeaddr + tempbuf[maxusage];

              if  examinelocation(iotypeaddr, nextcompaddr)=normal
              then
                  if valid(nextcompaddr,minloc,maxloc,daabadcompaddr)
                    then arraynext:= getrecordtype(nextcompaddr);
            end  (* if..then *)
          else
              zglobalerr(daarectypenotarray, rectype);
        end; (* if..then *)

      if  zglobalerror
      then begin
          zglobalerr(daafailarraynext, componentloc);
          arraynext:= -daafailarraynext;
        end; (* if..then *)
    end (* if..then *)

  else begin
      zglobalerr(daanexearraynext, nili);
      arraynext:= -daanexearraynext;
    end; (* else *)

end;  (* ArrayNext *)


(*

*)

(*-------------------------------------------------------------------*)
(*                                                                   *)
(*  PROCEDURE : RowAssocLevels                                       *)
(*  AUTHOR    : CB Lee        					     *)
(*  DATE      : 11/19/85                                             *)
(*  FUNCTION:   This function gets the number of Device Pin          *)
(*              Association Levels for any row of the Array. The     *)
(*              Levels are those of the next component.              *)
(*                                                                   *)
(*  MODIFICATIONS :                                                  *)
(*    NAME        DATE       DESCRIPTION                             *)
(*    ----------- ---------- ------------------------------------    *)
(*                                                                   *)
(*  COMMENTS  :                                                      *)
(*                                                                   *)
(*  INPUT PARAMETERS :                                               *)
(*                                                                   *)
(*    VARIABLE    TYPE       DESCRIPTION                             *)
(*    ----------- ---------- ------------------------------------    *)
(*   ComponentLoc integer    the integer index to the desired        *)
(*                           component.                              *)
(*                                                                   *)
(*  GLOBAL VARIABLES:                                                *)
(*      ZGlobalError   : boolean                                     *)
(*                                                                   *)
(*                                                                   *)

{vax   [Global]  vax}  
 function rowassoclevels ;  

  var
      rectype          : intXx4;
      assoclevels      : intXx4;
 
  begin  (* RowAssocLevels *)

    if  not zglobalerror
    then begin
        rectype    := arraynext(componentloc);
        assoclevels:= examinemitrec(rectype,pinassoclevels);

(* If the global variable ZGlobalError is not set, we can guarantee
   that the value we get in ExaminMITRec is valid                      *)

        if  not zglobalerror
          then rowassoclevels:= assoclevels
        else begin
          zglobalerr(daafailrowasslevel, rectype);
          rowassoclevels := -daafailrowasslevel;
        end; (* else *)
      end (*if..then*)

(* Global error already detected *)

    else begin
        zglobalerr (daanexerowasslevel, nili);
        rowassoclevels := -daanexerowasslevel;
      end; (*else*)

  end;  (* RowAssocLevels *)

(*

*)

(*-------------------------------------------------------------------*)
(*                                                                   *)
(*  PROCEDURE : RowAssocLvlCnt                                       *)
(*  AUTHOR    : CB Lee        					     *)
(*  DATE      : 11/19/85                                             *)
(*  FUNCTION  : This function gets the number of Device Pin          *)
(*              Association for a given Level for any Array row.     *)
(*                                                                   *)
(*  MODIFICATIONS :                                                  *)
(*    NAME        DATE       DESCRIPTION                             *)
(*    ----------- ---------- ------------------------------------    *)
(*    CB Lee      1/3/86     Check for no pin associations; return   *)
(*                           a default of -1 if none.                *)
(*                                                                   *)
(*  COMMENTS  :                                                      *)
(*                                                                   *)
(*  INPUT PARAMETERS :                                               *)
(*                                                                   *)
(*    VARIABLE    TYPE       DESCRIPTION                             *)
(*    ----------- ---------- ------------------------------------    *)
(*   ComponentLoc integer    the integer index to the desired        *)
(*                           component.                              *)
(*   Level        integer    the integer value of the Device Pin     *)
(*                           Association Level.                      *)
(*                                                                   *)
(*  GLOBAL VARIABLES:                                                *)
(*      ZGlobalError   : boolean                                     *)
(*                                                                   *)

{vax   [global]    vax}  
 function rowassoclvlcnt ;  

  var
      pinassocdefaddr  : intXx4;
      rectype          : intXx4;
      noassocs         : intXx4;

  begin  (* RowAssocLvlCnt *)

    if  not zglobalerror
    then begin
        rectype := arraynext (componentloc);
        pinassocdefaddr := examinemitrec (rectype, pinassocdef);
        if (pinassocdefaddr <> -1)
          then returnflag := examinelocation(pinassocdefaddr + level, noassocs)
        else noassocs:= -1;

(* Is the value returned valid? Otherwise, flag an error. *)
        if  valid(noassocs, minpinassno, maxpinassno, daapinassocnooutb)
        then
            rowassoclvlcnt := noassocs;

        if  zglobalerror
        then begin
            zglobalerr (daafailrowasslvlcnt, pinassocdefaddr);
            rowassoclvlcnt := -daafailrowasslvlcnt;
          end; (* if..then *)
     end (* if..then *)

(* Global error already detected *)
    else begin
      zglobalerr (daanexerowasslvlcnt, nili);
      rowassoclvlcnt := -daanexerowasslvlcnt;
     end; (*else*)

  end;  (* RowAssocLvlCnt *)

(*

*)

(*-------------------------------------------------------------------*)
(*                                                                   *)
(*  PROCEDURE : DenseNextLLT                                         *)
(*  AUTHOR    : Boris B. Shih                                        *)
(*  DATE      : 12/6/85                                              *)
(*  FUNCTION  : The function returns the NextMapping address by      *)
(*              specifying the current LinkListType (LLT) address.   *)
(*                                                                   *)
(*  MODIFICATIONS :                                                  *)
(*    NAME        DATE       DESCRIPTION                             *)
(*    ----------- ---------- ------------------------------------    *)  
(*                                                                   *)
(*  COMMENTS  :                                                      *)
(*                                                                   *)
(*  INPUT PARAMETERS :                                               *)
(*                                                                   *)
(*    VARIABLE    TYPE       DESCRIPTION                             *)
(*    ----------- ---------- ------------------------------------    *)
(*                                                                   *)
(*  GLOBAL VARIABLES:                                                *)
(*                                                                   *)

function densenextllt (arraymapaddr : intXx4; putorget : accessmethod;
                       var val : intXx4) : intXx4;

var
         nextaddr         : intXx4;

begin (* DenseNextLLT *)

  if  not zglobalerror
    then begin

      case putorget of
          putvalue : returnflag := putlocation(arraymapaddr, val);
          getvalue : returnflag := examinelocation(arraymapaddr, val);
      end; (* case..of *)

      returnflag := examinelocation(arraymapaddr + 1, nextaddr);
      if  valid(nextaddr, minloc, maxloc, daalocationoutb)
        then densenextllt:= nextaddr;

      if  zglobalerror
        then begin
          zglobalerr(daafaildensenextllt, nili);
          densenextllt:= -daafaildensenextllt;
        end; (* if..then *)
    end (* if..then *)

  else begin
      zglobalerr(daanexedensenextllt, nili);
      densenextllt:= -daanexedensenextllt;
    end;  (* else *)
end; (* DenseNextLLT *)

(*

*)

(*                                                                   *)
(*-------------------------------------------------------------------*)
(*                                                                   *)
(*  PROCEDURE : GetCITIndex                                          *)
(*  AUTHOR    : Boris B. Shih                                        *)
(*  DATE      : 12/5/85                                              *)
(*  FUNCTION  : The function gets the CITIndex by specifying the     *)
(*              ComponentLoc                                         *)
(*                                                                   *)
(*  MODIFICATIONS :                                                  *)
(*    NAME        DATE       DESCRIPTION                             *)
(*    ----------- ---------- ------------------------------------    *)  
(*                                                                   *)
(*  COMMENT :                                                        *)
(*                                                                   *)
(*  INPUT PARAMETERS :                                               *)
(*                                                                   *)
(*    VARIABLE    TYPE       DESCRIPTION                             *)
(*    ----------- ---------- ------------------------------------    *)
(*    ComponentLoc integer   The integer index to the desired comp   *)
(*                                                                   *)
(*  GLOBAL VARIABLES:                                                *)
(*    ZGlobalError      : boolean                                    *)
(*                                                                   *)

{vax   [global]  vax} 
 function getcitindex ;  

var
        found          : boolean;
        i              : intXx4;
        rectype        : intXx4;
        mitrecbuf      : mitrecord;
        recaddr        : intXx4;
        citrecsize     : intXx4;
        val            : intXx4;

begin  (* GetCITIndex *)

  if  not zglobalerror
    then begin
      rectype    := getrecordtype(componentloc);
      mitrecbuf  := getmitrec (rectype);
      citrecsize := countcitrecsize (mitrecbuf[pinassocdef],mitrecbuf[pinassoclevels]);
      recaddr    := mitrecbuf[citlocation];
      returnflag := examinelocation(recaddr,mincompaddr);
      returnflag := examinelocation((recaddr+(mitrecbuf[nocomponents]-1)*citrecsize),maxcompaddr);
      val        := mincompaddr;
      i    := 0;
      found:= false;

      while (not found) and (not zglobalerror) do
        begin
          if valid(val,mincompaddr,maxcompaddr,daabadcompaddr)
            then begin
              if val=componentloc
                then found:= true
              else begin
                recaddr:= recaddr + citrecsize;
                returnflag := examinelocation(recaddr,val);
                i:= i + 1;
                if  i > mitrecbuf[nocomponents]
                  then begin
                    found:= true;
                    zglobalerr (daafielderror, nili)
                  end; (* if .. then *)
              end;  (* else *)
            end; (* if..then *)
        end; (* while..do *)

      if  not zglobalerror
      then
          getcitindex := i
      else begin
          zglobalerr (daafailgetcitindex, componentloc);
          getcitindex := -daafailgetcitindex;
        end;  (* else *)
    end  (* if .. then *)

  else begin
      zglobalerr (daanexegetcitindex, componentloc);
      getcitindex := -daanexegetcitindex;
    end;  (* else *)
end;  (* GetCITIndex *)

(*

*)

(*                                                                   *)
(*-------------------------------------------------------------------*)
(*                                                                   *)
(*  PROCEDURE : GetRowPinAssoc                                       *)
(*  AUTHOR    : Boris B. Shih                                        *)
(*  DATE      : 12/5/85                                              *)
(*  FUNCTION  : The function gets the Device Pin Associations for    *)
(*              a given row, for a given level.                      *)
(*                                                                   *)
(*  MODIFICATIONS :                                                  *)
(*    NAME        DATE       DESCRIPTION                             *)
(*    ----------- ---------- ------------------------------------    *)  
(*                                                                   *)
(*  COMMENTS  : The first call to this function returns the first    *)
(*              Device Pin Association for that level, with each     *)
(*              consecutive call returning the next Association,     *)
(*              until there are no more Device Pin Association for   *)
(*              that level. In that case, the NoMorDevPinAssc error  *)
(*              code is returned.                                    *)
(*                                                                   *)
(*  NOTES : If the first parameter ComponentLoc = Z_Reset, it means  *)
(*          the global variable RowPinCntKeeper should be reset to 0 *)
(*                                                                   *)
(*  INPUT PARAMETERS :                                               *)
(*                                                                   *)
(*    VARIABLE    TYPE       DESCRIPTION                             *)
(*    ----------- ---------- ------------------------------------    *)
(*   ComponentLoc integer    the integer index to the desired        *)
(*                           array component.                        *)
(*   Level        integer    the integer value of the Device Pin     *)
(*                           Association Level.                      *)
(*   RowIndex     integer    the integer index to a row within the   *)
(*                           array component.                        *)
(*                                                                   *)
(*  GLOBAL VARIABLES:                                                *)
(*    ZGlobalError        : boolean                                  *)
(*    RowPinCntKeeper     : integer                                  *)
(*                          The counter keeps the pin count which    *)
(*                          should be processed next                 *)
(*                                                                   *)

{vax  [Global]  vax} 
 function getrowpinassoc ;  

var
         nextiotype      : iotype;
         rectype         : intXx4;
         citindex        : intXx4;
         val             : intXx4;

begin  (* GetRowPinAssoc *)

  if  not zglobalerror
    then begin
     if   (componentloc <> daapinassccomploc) or (rowindex <> daapinasscrowindex)
       or (level        <> daapinassclevel)
       then begin
         rowpincntkeeper   := initrowpincntkp;
         daapinassccomploc := componentloc;
         daapinasscrowindex:= rowindex;
         daapinassclevel   := level;
       end; (* if..then *)

      nextiotype     := getconnection(componentloc, outputcomp, rowindex);
      rectype        := getrecordtype(nextiotype[nextXcomponent]);
      citindex       := getcitindex  (nextiotype[nextXcomponent]);
      val            := getpinassoc  (rectype, citindex, level, rowpincntkeeper);
      rowpincntkeeper:= rowpincntkeeper + 1;

      if  not zglobalerror
        then getrowpinassoc := val
      else begin
        zglobalerr (daafailgetrowpinass, rowindex);
        getrowpinassoc:= -daafailgetrowpinass;
      end  (* else *)
    end  (* if .. then *)

  else begin
      zglobalerr(daanexegetrowpinass, rowindex);
      getrowpinassoc:= -daanexegetrowpinass;
    end; (* else *)

end; (* GetRowPinAssoc *)

(*

*)

(*-------------------------------------------------------------------*)
(*                                                                   *)
(*  PROGRAM   : GetLLT                                               *)
(*  AUTHOR    : Chie-Jiun Chien                                      *)
(*  DATE      : 12/6/85                                              *)
(*  FUNCTION  : This function is to get a new Link List Type Record  *)
(*              from memory block and initialize it.                 *)
(*                                                                   *)
(*  MODIFICATIONS :                                                  *)
(*    NAME        DATE       DESCRIPTION                             *)
(*    ----------- ---------- ------------------------------------    *)
(*    C.J.        12/6/85    Initial release                         *)
(*                                                                   *)
(*                                                                   *)
(*  COMMENTS  :                                                      *)
(*                                                                   *)
(*  NOTES     :                                                      *)
(*                                                                   *)
(*  EXTERNAL DECLARATIONS :                                          *)
(*                                                                   *)
(*  GLOBAL DECLARATIONS :                                            *)
(*                                                                   *)
(*-------------------------------------------------------------------*)
function getllt : intXx4;
var 
  dummy : intXx4;

begin (* GetLLT *)

  if headlist = taillist
    then begin
      getllt:= savenext(intraconnotused);
      dummy := savenext(zXnil);
    end
  else begin
    getllt:= headlist;
    returnflag := examinelocation(headlist + 1, headlist);
  end;

end;  (* GetLLT *)

(*

*)

(*-------------------------------------------------------------------*)
(*                                                                   *)
(*  PROGRAM   : DispLLT                                              *)
(*  AUTHOR    : Chie-Jiun Chien                                      *)
(*  DATE      : 12/6/85                                              *)
(*  FUNCTION  : This function is to dispose a new Link List          *)
(*              Type                                                 *)
(*                                                                   *)
(*  MODIFICATIONS :                                                  *)
(*    NAME        DATE       DESCRIPTION                             *)
(*    ----------- ---------- ------------------------------------    *)
(*    C.J.        12/6/85    Initial release                         *)
(*                                                                   *)
(*                                                                   *)
(*  COMMENTS  :                                                      *)
(*                                                                   *)
(*  NOTES     :                                                      *)
(*                                                                   *)
(*  EXTERNAL DECLARATIONS :                                          *)
(*                                                                   *)
(*  GLOBAL DECLARATIONS :                                            *)
(*                                                                   *)
(*-------------------------------------------------------------------*)

(*-------------------------------------------------------------------*)
(*                                                                   *)
(*  PROGRAM   : FindUnUsedIntraCon                                   *)
(*  AUTHOR    : Chie-Jiun Chien                                      *)
(*  DATE      : 12/6/85                                              *)
(*  FUNCTION  : Find a Unused Intra-array Connection in one array    *)
(*                                                                   *)
(*  MODIFICATIONS :                                                  *)
(*    NAME        DATE       DESCRIPTION                             *)
(*    ----------- ---------- ------------------------------------    *)
(*    C.J.        12/6/85    Initial release                         *)
(*                                                                   *)
(*                                                                   *)
(*  COMMENTS  :                                                      *)
(*                                                                   *)
(*  NOTES     :                                                      *)
(*                                                                   *)
(*  EXTERNAL DECLARATIONS :                                          *)
(*                                                                   *)
(*  GLOBAL DECLARATIONS :                                            *)
(*                                                                   *)
function findunusedintracon(recaddress : intXx4; maxusage : intXx4) : intXx4;
var
    count  : intXx4;
    found  : boolean;
    val    : intXx4;

begin (* FindUnUsedIntraCon *)

     count :=0;
     repeat
       returnflag := examinelocation(recaddress + count, val);
       if val = intraconnotused
         then begin
           found := true;
           findunusedintracon := count;
         end;
       count := count + 1;
     until (count > maxusage) or (found);

     if  not found
       then begin
         zglobalerr(daaerrorinintraconnection, nili);
         findunusedintracon:= -daafailunusedintracon;
       end; 

end; (* FindUnUsedIntraCon *)

(*

*)

(*-------------------------------------------------------------------*)
(*                                                                   *)
(*  PROGRAM   : QtyLineIntraCon                                      *)
(*  AUTHOR    : Chie-Jiun Chien                                      *)
(*  DATE      : 12/6/85                                             *)
(*  FUNCTION  :                                                      *)
(*                                                                   *)
(*  MODIFICATIONS :                                                  *)
(*    NAME        DATE       DESCRIPTION                             *)
(*    ----------- ---------- ------------------------------------    *)
(*    C.J.        12/6/85    Initial release                         *)
(*                                                                   *)
(*                                                                   *)
(*  COMMENTS  :                                                      *)
(*                                                                   *)
(*  NOTES     :                                                      *)
(*                                                                   *)
(*  EXTERNAL DECLARATIONS :                                          *)
(*                                                                   *)
(*  GLOBAL DECLARATIONS :                                            *)
(*                                                                   *)
{vax    [Global]  vax}    
 function qtylineintracon;  
var
    iorecord     : limitiorecord;
    recordaddress: intXx4;
    val          : intXx4;

begin (* QtyLineIntraCon *)

      iorecord     := findlimitrecord(componentloc, orientation);
      recordaddress:= findlineaddress(componentloc, lineindex, orientation);

      (* Sparse or dense array *)
      if iorecord[maxusage] <= standardintactno
        then val:= findunusedintracon(recordaddress, iorecord[maxusage])
      else returnflag := examinelocation(recordaddress + iorecsize, val);

      if (val > iorecord[maxusage])
        then begin
          zglobalerr(daafailtoaccessintraconnection, nili);
          qtylineintracon:= daafailqtylineintracon;
        end
      else
        qtylineintracon:= val;                    

end; (* QtyLineIntraCon *)

(*

*)

(*-------------------------------------------------------------------*)
(*                                                                   *)
(*  PROCEDURE : PutSparseValue                                       *)
(*  AUTHOR    : Chie-Jiun Chien                                      *)
(*  DATE      : 12/4/85                                             *)
(*  FUNCTION  : This procedure puts a intra connection reference     *)
(*              value into the sparse array                          *) 
(*                                                                   *)
(*  MODIFICATIONS :                                                  *)
(*    NAME        DATE       DESCRIPTION                             *)
(*    ----------- ---------- ------------------------------------    *)
(*    C.J.        12/4/85    Initial release                         *)
(*    M.Gzowski   4/18/86    fix potential bug (#793)		     *)
(*                                                                   *)
(*                                                                   *)
(*  COMMENTS  :                                                      *)
(*                                                                   *)
(*  NOTES     :                                                      *)
(*                                                                   *)
(*  EXTERNAL DECLARATIONS :                                          *)
(*                                                                   *)
(*  GLOBAL DECLARATIONS :                                            *)
(*                                                                   *)

procedure putsparsevalue(startaddress : intXx4; index : intXx4; 
                         maxusage     : intXx4);
var 
     offset : intXx4;

begin (* PutSparseValue *)

      offset:= findunusedintracon(startaddress, maxusage);
(* MEG 4/18/86 bug # 793 *)
(* check if a connect was found *)
      if offset >= 0
       then begin  
         returnflag := putlocation(startaddress + offset, index);
        end
       else 
         zglobalerr (daaexceedmaxlineuse, maxusage);

      if zglobalerror
        then begin
           zglobalerr(daafailtowriteintraconnection, nili);
           zglobalerr(daafailputsparsevalue, nili);
        end;

end; (* PutSparseValue *)

(*

*)

(*-------------------------------------------------------------------*)
(*                                                                   *)
(*  PROCEDURE : PutDenseValue                                        *)
(*  AUTHOR    : Chie-Jiun Chien                                      *)
(*  DATE      : 12/4/85                                              *)
(*  FUNCTION  : This procedure is to put an intra connection         *)
(*              reference value into the Dense Array                 *)
(*                                                                   *)
(*  MODIFICATIONS :                                                  *)
(*    NAME        DATE       DESCRIPTION                             *)
(*    ----------- ---------- ------------------------------------    *)
(*    C.J.        12/4/85    Initial release                         *)
(*    M.Gzowski   4/18/86    Corrected error code, removed error     *)
(*			     call.	( Bug rep # 793 )	     *)
(*                                                                   *)
(*                                                                   *)
(*  COMMENTS  :                                                      *)
(*                                                                   *)
(*  NOTES     :                                                      *)
(*                                                                   *)
(*  EXTERNAL DECLARATIONS :                                          *)
(*                                                                   *)
(*  GLOBAL DECLARATIONS :                                            *)
(*                                                                   *)

procedure putdensevalue(startaddress : intXx4; index : intXx4; 
                        maxusage     : intXx4);
var
   i            : intXx4;
   val          : intXx4;
   linkno       : intXx4;
   lltaddress   : intXx4;
   nextaddress  : intXx4;

begin (* PutDenseValue *)

  lltaddress  := startaddress + iorecsize;
  startaddress:= startaddress + iorecsize + 1;
  returnflag := examinelocation(lltaddress, linkno);

  if linkno <= maxusage
    then begin
  
      for i:= 1 to linkno - 1
        do begin
          returnflag := examinelocation(startaddress + 1, startaddress);
          if (startaddress = zXnil) and (i < linkno)
            then zglobalerr(daabadlinklistaccess, nili );
        end;

      returnflag := examinelocation (startaddress + 1, nextaddress);

      if nextaddress = zXnil
        then begin
          returnflag := examinelocation(startaddress, val);

          if val <> zXnil
            then begin
              returnflag := putlocation(startaddress + 1, getllt);
              returnflag := examinelocation(startaddress + 1, startaddress);
            end;

          returnflag := putlocation(lltaddress,   linkno + 1);
          returnflag := putlocation(startaddress, index);
        end (* if..then *)
      else 
          zglobalerr(daafailtowriteintraconnection, nili);
    end (* if..then *)

(* MEG 4/18/86 bug # 793 *)
  else 
    zglobalerr (daaexceedmaxlineuse, maxusage);

end; (* PutDenseValue *)

(*

*)

(*-------------------------------------------------------------------*)
(*                                                                   *)
(*  PROGRAM   : AddLineIntracon                                      *)
(*  AUTHOR    : Chie-Jiun Chien                                      *)
(*  DATE      : 12/3/1985                                            *)
(*  FUNCTION  : This function adds an intra-array connections into   *)
(*              the array, that is to say, to put cross reference    *)
(*              information for both row and column                  *)
(*                                                                   *)
(*  MODIFICATIONS :                                                  *)
(*    NAME        DATE       DESCRIPTION                             *)
(*    ----------- ---------- ------------------------------------    *)
(*    C.J.Chien   12/3/85   Initial release                          *)
(*                                                                   *)
(*                                                                   *)
(*  COMMENTS  :                                                      *)
(*                                                                   *)
(*  NOTES     :                                                      *)
(*                                                                   *)
(*  EXTERNAL DECLARATIONS :                                          *)
(*                                                                   *)
(*  GLOBAL DECLARATIONS :                                            *)
(*                                                                   *)
(*-------------------------------------------------------------------*)
 {vax    [Global]   vax}       
 procedure addlineintracon;  
var
    iorecord      : limitiorecord;
    recordaddress : intXx4;

begin (* AddLineIntracon *)

      iorecord     := findlimitrecord(componentloc, row);
      recordaddress:= findlineaddress(componentloc, rowindex, row);

      if iorecord[maxusage] <= standardintactno
        then putsparsevalue(recordaddress, columnindex, iorecord[maxusage])
      else   putdensevalue (recordaddress, columnindex, iorecord[maxusage]);
           
      if  not zglobalerror 
        then begin
          iorecord     := findlimitrecord(componentloc, column); 
          recordaddress:= findlineaddress(componentloc, columnindex, column);

          if iorecord[maxusage] <= standardintactno
            then putsparsevalue(recordaddress, rowindex, iorecord[maxusage])
          else   putdensevalue (recordaddress, rowindex, iorecord[maxusage]);
        end;

end; (* AddLineIntracon *)

(*

*)

(*-------------------------------------------------------------------*)
(*                                                                   *)
(*  PROGRAM   : GetDenseIntraCon                                     *)
(*  AUTHOR    : Chie-Jiun Chien                                      *)
(*  DATE      : 12/4/85                                              *)
(*  FUNCTION  : This function gets an intra-array connection for a   *)
(*              Dense Array                                          *)
(*                                                                   *)
(*  MODIFICATIONS :                                                  *)
(*    NAME        DATE       DESCRIPTION                             *)
(*    ----------- ---------- ------------------------------------    *)
(*    C.J.        12/6/85    initial release                         *)
(*                                                                   *)
(*                                                                   *)
(*  COMMENTS  : Input parameter is the line record address and its   *)
(*              offset in the dense array. The return value is the   *)
(*              desired location of that connection                  *)
(*                                                                   *)
(*  NOTES     :                                                      *)
(*                                                                   *)
(*  EXTERNAL DECLARATIONS :                                          *)
(*                                                                   *)
(*  GLOBAL DECLARATIONS :                                            *)
(*                                                                   *)
(*  Calls : ExamineLocation                                          *)
(*-------------------------------------------------------------------*)
{vax [global] vax}
 function getdenseintracon;  
var 
   found       : boolean;
   counter     : intXx4;
   nextaddress : intXx4;

begin (* GetDenseIntraCon *)

     (* first array mapping *)
     recaddress:= recaddress + iorecsize + 1;
     counter   := 0;
     found     := false;

     repeat
       if  counter = reccounter
         then begin
           getdenseintracon := recaddress;
           found            := true;
         end (* if..then *)
       else begin
         returnflag := examinelocation(recaddress + 1, nextaddress);

         if nextaddress = zXnil
           then begin
             recaddress:= recaddress + 1;
             counter:= reccounter;
           end (* if..then *)
         else begin
           counter:= counter + 1;
           recaddress:= nextaddress
         end; (* else *)

       end; (* else *)
     until (found) or (recaddress = zXnil);

     if  (not found) or zglobalerror
       then begin
         zglobalerr(daafailtofindintracon,nili);
         getdenseintracon := -daafailtofindintracon;
       end; (* if..then *)

end; (* GetDenseIntraCon *)

(*

*)

(*-------------------------------------------------------------------*)
(*                                                                   *)
(*  PROGRAM   : GetLineIntraCon                                      *)
(*  AUTHOR    : Chie-Jiun Chien                                      *)
(*  DATE      : 12/4/85                                             *)
(*  FUNCTION  : This function gets the intra-array connections for a *)
(*              given array line. The first call to this function    *)
(*              returns the first connection for that line, with each*)
(*              consecutive call returning the next connection, until*)
(*              there are no more connection on that line. When that *)
(*              occurs, the NoMorRCConnects error code is returned.  *)
(*              If ComponentLoc or LineIndex is changed between con- *)
(*              secutive calls to this function, then the global     *)
(*              pointers are reset and a later call to this function *)
(*              with the previous parameters returns the first conn- *)
(*              ection for that line                                 *) 
(*                                                                   *)
(*  MODIFICATIONS :                                                  *)
(*    NAME        DATE       DESCRIPTION                             *)
(*    ----------- ---------- ------------------------------------    *)
(*    C.J.        12/6/85    initial release                         *)
(*                                                                   *)
(*                                                                   *)
(*  COMMENTS  :                                                      *)
(*                                                                   *)
(*  NOTES     :                                                      *)
(*                                                                   *)
(*  EXTERNAL DECLARATIONS :                                          *)
(*                                                                   *)
(*  GLOBAL DECLARATIONS :                                            *)
(*  DAAComponentLoc - The Component Location Record for the last time*)
(*                    call                                           *)
(*  DAALineIndex - The Line Index Record for the last time call      *)
(*  RecordCounter -  A global variable to keep the record of the     *)
(*                   consecutive call to the array record            *)
(*  InitRecordCounter - The initial value for the Record Counter     *)
(*                                                                   *)
(*  Calls : FindLimitRecord                                          *)
(*          FindLineAddress                                          *)
(*          ExamineLocation                                          *)
(*          ZGlobalErr                                               *)
(*          GetDenseIntraCon                                         *)
(*-------------------------------------------------------------------*)

{vax     [Global]   vax}       
 function getlineintracon;  
var
    iorecord      : limitiorecord;
    val           : intXx4;
    recordaddress : intXx4;

begin (* GetLineIntraCon *)

     (* If ComponentLoc or Line Index has been changed, the RecordCounter *)
     (* is reset                                                          *)
     if   (componentloc <> daacomponentloc) or (lineindex <> daalineindex)
       or (orientation  <> daaroworcol)
       then begin
         recordcounter  := initrecordcounter;
         daacomponentloc:= componentloc;
         daalineindex   := lineindex;
         daaroworcol    := orientation;
       end; (* if..then *)

     recordaddress:= findlineaddress(componentloc, lineindex, orientation);
     iorecord     := findlimitrecord(componentloc, orientation);

     if recordcounter <= (iorecord[maxusage] - 1)
       then begin

         (* sparse array *)       
         if iorecord[maxusage] <= standardintactno
           then returnflag := examinelocation(recordaddress + recordcounter, val)
         else begin
           recordaddress:= getdenseintracon(recordaddress, recordcounter);
           returnflag := examinelocation(recordaddress, val);
         end; (* else *)

         if zglobalerror
           then begin
             zglobalerr(daafailtoaccessintraconnection, nili);
             getlineintracon := -daafailgetlineintracon;
           end (* if..then *)
         else 
           getlineintracon:= val;

         if val <> zXnil 
           then recordcounter := recordcounter + 1
         else recordcounter:= iorecord[maxusage];

       end (* if..then *)

     else begin
       getlineintracon := nomorrcconnects;
       recordcounter  := 0;
     end; (* else *)

end; (* GetLineIntraCon *)

(*

*)

(*-------------------------------------------------------------------*)
(*                                                                   *)
(*  PROGRAM   : ArrayLineFull                                        *)
(*  AUTHOR    : Chie-Jiun Chien                                      *)
(*  DATE      : 12/6/85                                              *)
(*  FUNCTION  : This function checks the desired array line and      *)
(*              returns true if all the array connections on that    *)
(*              line has been used, false if not                     *)
(*                                                                   *)
(*  MODIFICATIONS :                                                  *)
(*    NAME        DATE       DESCRIPTION                             *)
(*    ----------- ---------- ------------------------------------    *)
(*    Chie-Jiun  12/6/85     Initial release                         *)
(*                                                                   *)
(*                                                                   *)
(*  COMMENTS  :                                                      *)
(*                                                                   *)
(*  NOTES     :                                                      *)
(*                                                                   *)
(*  EXTERNAL DECLARATIONS :                                          *)
(*                                                                   *)
(*  GLOBAL DECLARATIONS :                                            *)
(*                                                                   *)
(*  Calls : FindLimitRecord                                          *)
(*          FindLineAddress                                          *)
(*          ExamineLocation                                          *)
(*          ZGlobalErr                                               *)

{vax   [Global]  vax}   
 function arraylinefull;  
var 
    iorecord      : limitiorecord;
    val           : intXx4;
    mappingaddress: intXx4;
    listno        : intXx4;
    nextcomponent : intXx4;
    count         : intXx4;

begin (* ArrayLineFull *)

     iorecord      := findlimitrecord(componentloc, orientation);
     mappingaddress:= findlineaddress(componentloc, lineindex, orientation);

     if iorecord[maxusage] <= standardintactno
       then begin
          (*  Sparse array *)
          (*  Check the last connection in the desired array line *)
          mappingaddress:= mappingaddress + iorecord[maxusage] - 1;
          returnflag := examinelocation(mappingaddress,val);

          if zglobalerror 
            then zglobalerr(daafailtoaccessintraconnection,nili)
          else 
              if val = intraconnotused
                then arraylinefull := false
              else   arraylinefull := true;
          end
     else begin
          (*   Dense Array    *)
          (*  MappingAddress + IORecSize is the ListNo in the array record *)
          returnflag := examinelocation(mappingaddress + iorecsize,listno);

          if listno = iorecord[maxusage]
            then arraylinefull := true
          else 
               if listno < iorecord[maxusage]
                 then arraylinefull := false
               else zglobalerr(daafailarraylinefull,nili);          
     end;     
    
end; (* ArrayLineFull *)

(*

*)

(*-------------------------------------------------------------------*)
(*                                                                   *)
(*  PROGRAM   : UsedLineArray                                        *)
(*  AUTHOR    : Chie-Jiun Chien                                      *)
(*  DATE      : 12/6/85                                             *)
(*  FUNCTION  : This function checks if any intra-array connections  *)
(*              are used on a given line                             *)
(*                                                                   *)
(*  MODIFICATIONS :                                                  *)
(*    NAME        DATE       DESCRIPTION                             *)
(*    ----------- ---------- ------------------------------------    *)
(*    C.J.        12/6/85   Initial release                          *)
(*                                                                   *)
(*                                                                   *)
(*  COMMENTS  :                                                      *)
(*                                                                   *)
(*  NOTES     :                                                      *)
(*                                                                   *)
(*  EXTERNAL DECLARATIONS :                                          *)
(*                                                                   *)
(*  GLOBAL DECLARATIONS :                                            *)
(*                                                                   *)
{vax [Global] vax}   
 function usedlinearray;  

var iorecord     : limitiorecord;
    recordaddress: intXx4;
    val          : intXx4;
    
begin (* UsedLineArray *)

     iorecord     := findlimitrecord(componentloc, orientation);
     recordaddress:= findlineaddress(componentloc, lineindex, orientation);

     (* find first array mapping in dense array record *)
     if iorecord[maxusage] > standardintactno
       then recordaddress:= recordaddress + iorecsize + 1;

     returnflag := examinelocation(recordaddress,val);

    if zglobalerror 
      then begin
          zglobalerr(daafailtoaccessintraconnection, nili);
          zglobalerr(daafailusedlinearray, nili);
        end
    else
         if  val = intraconnotused
           then usedlinearray:= false
         else   usedlinearray:= true;

end; (* UsedLineArray *)

(*

*)

(*-------------------------------------------------------------------*)
(*                                                                   *)
(*  PROGRAM   : StatLineArray                                        *)
(*  AUTHOR    : Chie-Jiun Chien                                      *)
(*  DATE      : 12/6/85                                              *)
(*  FUNCTION  : This function gets the current status of a given     *)
(*              Array Line                                           *)
(*                                                                   *)
(*  MODIFICATIONS :                                                  *)
(*    NAME        DATE       DESCRIPTION                             *)
(*    ----------- ---------- ------------------------------------    *)
(*    C.J.        12/6/85    Initial release                         *)
(*                                                                   *)
(*                                                                   *)
(*  COMMENTS  :                                                      *)
(*                                                                   *)
(*  NOTES     :This function returns a status code of the following: *)
(*             Linefull,LineEmpty and LineUsed                       *)
(*  Calls     : ArrayLineFull                                        *)
(*              UsedLineArray                                        *)
(*                                                                   *)
(*                                                                   *)
(*                                                                   *)
{vax   [Global]  vax}    
 function statlinearray;  

begin (* StatLineArray *)

   if arraylinefull(componentloc, lineindex, orientation)
     then statlinearray:= linefull
   else begin
     if usedlinearray(componentloc, lineindex, orientation)
       then statlinearray:= lineused
     else   statlinearray:= lineempty;
   end;

end; (* StatLineArray *)

(*

*)

(*                                                                   *)
(*-------------------------------------------------------------------*)
(*                                                                   *)
(*  PROCEDURE : ClrArrayLine                                         *)
(*  AUTHOR    : Boris B. Shih                                        *)
(*  DATE      : 11/25/85                                             *)
(*  FUNCTION  : This procedure removes all intra-array connections   *)
(*              on a given array column.                             *)
(*                                                                   *)
(*  MODIFICATIONS :                                                  *)
(*    NAME        DATE       DESCRIPTION                             *)
(*    ----------- ---------- ------------------------------------    *)  
(*                                                                   *)
(*  COMMENTS  :                                                      *)
(*                                                                   *)
(*  INPUT PARAMETERS :                                               *)
(*                                                                   *)
(*    VARIABLE    TYPE       DESCRIPTION                             *)
(*    ----------- ---------- ------------------------------------    *)
(*    ComponentLoc integer   The integer index to the desired array  *)
(*                           component                               *)
(*    LineIndex    integer   The integer index to a line within      *)
(*                           the array component                     *)
(*    Orientation  LineType  Specify whether LineIndex refers to a   *)
(*                           row or column                           *)
(*                                                                   *)
(*  GLOBAL VARIABLES:                                                *)
(*    ZGlobalError         : boolean                                 *)
(*                                                                   *)

{vax   [Global]   vax}    
 procedure clrarrayline ;  

var
       recrange          : intXx4;
       staddr            : intXx4;
       arraymapaddr      : intXx4;
       nextmapaddr       : intXx4;
       garbageaddr       : intXx4;
       listno            : intXx4;
       linkcnt           : intXx4;
       val               : intXx4;
       sparseordense     : rowtype;
       ltdiorecord       : limitiorecord;

begin  (* ClrArrayLine *)

if  not zglobalerror
  then begin

    val        := intraconnotused;
    ltdiorecord:= findlimitrecord(componentloc, orientation);
    staddr     := findlineaddress(componentloc, lineindex, orientation);

(* determine the no of entries in a row or column record  *)
    recrange:= ltdiorecord[maxusage];

    if  recrange <= standardintactno
      then sparseordense:= sparse
    else   sparseordense:= dense;

    if  not zglobalerror
      then begin
        case sparseordense of
            sparse :
                for linkcnt := 0 to recrange - 1 do
                    returnflag := putlocation (staddr + linkcnt, val);

            dense : begin
                returnflag := examinelocation(staddr + iorecsize, listno);
                returnstatus := valid(listno, -1, recrange, daafielderror);

                arraymapaddr:= staddr + iorecsize + 1;
                returnflag := putlocation(staddr + iorecsize, 0);

                linkcnt:= 0;
                while (linkcnt < listno) do
                  begin
                    nextmapaddr:= densenextllt(arraymapaddr, putvalue, val);
                    if  not zglobalerror
                      then begin
                        linkcnt:= linkcnt + 1;
                        if  ((nextmapaddr  = zXnil) and (linkcnt <> listno))
                        or  ((nextmapaddr <> zXnil) and (linkcnt  = listno))
                          then zglobalerr(daadenserecconflict, nili)
                        else arraymapaddr:= nextmapaddr;
                      end; (* if .. then *)
                  end; (* while .. do *)

                returnflag := examinelocation(staddr + iorecsize + 2, garbageaddr);
                if garbageaddr <> zXnil
                  then returnflag := garbagecollect(garbageaddr);
                returnflag := putlocation(staddr + iorecsize + 2, zXnil);
              end; (* Dense *)
        end; (* case .. of *)
      end; (* if..then *)

    if  zglobalerror 
      then zglobalerr (daafailclrarray, componentloc);
  end  (* if .. then *)

else
    zglobalerr (daanexeclrarray, componentloc);

end;  (* ClrArrayLine *)

(*

*)

(*                                                                   *)
(*-------------------------------------------------------------------*)
(*                                                                   *)
(*  PROCEDURE : MovArrayLine                                         *)
(*  AUTHOR    : Boris B. Shih                                        *)
(*  DATE      : 12/2/85                                              *)
(*  FUNCTION  : This procedure moves the intra-array connection      *)
(*              data from the source line to the destination line    *)
(*                                                                   *)
(*  MODIFICATIONS :                                                  *)
(*    NAME        DATE       DESCRIPTION                             *)
(*    ----------- ---------- ------------------------------------    *)  
(*                                                                   *)
(*  COMMENTS  :                                                      *)
(*                                                                   *)
(*  INPUT PARAMETERS :                                               *)
(*                                                                   *)
(*    VARIABLE    TYPE       DESCRIPTION                             *)
(*    ----------- ---------- ------------------------------------    *)
(*    ComponentLoc integer   The integer index to the desired array  *)
(*                           component                               *)
(*    LineIndexS   integer   The integer index to a source line      *)
(*                           within the Array Component              *)
(*    LineIndexD   integer   The integer index to a destination line *)
(*                           within the Array Component              *)
(*    Orientation  LineType  Specifies whether LineIndex refers to   *)
(*                           a row or column                         *)
(*                                                                   *)
(*  GLOBAL VARIABLES:                                                *)
(*    ZGlobalError        : boolean                                  *)
(*                                                                   *)

{vax  [Global]   vax}   
 procedure movarrayline ;  

var
       ltdiorecord       : limitiorecord;
       sparseordense     : rowtype;
       sourceaddr        : intXx4;
       destaddr          : intXx4;
       sourcemapaddr     : intXx4;
       destmapaddr       : intXx4;
       sourcenextmapaddr : intXx4;
       destnextmapaddr   : intXx4;
       sourcelistno      : intXx4;
       destlistno        : intXx4;
       recrange          : intXx4;
       linkcnt           : intXx4;
       i                 : intXx4;
       val               : intXx4;

begin  (* MovArrayLine *)

if  not zglobalerror
  then begin

    ltdiorecord := findlimitrecord(componentloc, orientation);
    sourceaddr  := findlineaddress(componentloc, lineindexs, orientation);
    destaddr    := findlineaddress(componentloc, lineindexd, orientation);

(* determine the no of entries in a row or column record  *)

    recrange:= ltdiorecord[maxusage];

    if  recrange <= standardintactno
      then sparseordense:= sparse
    else   sparseordense:= dense;

    if  not zglobalerror
      then begin
        case sparseordense of
            sparse :
                for linkcnt := 0 to recrange - 1 do
                  begin
                    returnflag := examinelocation(sourceaddr + linkcnt, val);
                    returnflag := putlocation(destaddr + linkcnt, val);
                  end; (* for..loop *)

            dense : begin
                returnflag := examinelocation (sourceaddr + iorecsize, sourcelistno);
                returnflag := examinelocation (destaddr   + iorecsize, destlistno);
                if  valid(sourcelistno, -1, recrange, daafielderror)
                  then begin
                    sourcemapaddr:= sourceaddr + iorecsize + 1;
                    destmapaddr  := destaddr   + iorecsize + 1;
                  end;

                clrarrayline(componentloc, lineindexd, orientation);

                for i := 0 to sourcelistno -1 do
                  putdensevalue(destaddr, 0, ltdiorecord[maxusage]);

                returnflag := putlocation(destmapaddr - 1, sourcelistno);

                linkcnt := 0;
                while (linkcnt < sourcelistno) do
                  begin
                    sourcenextmapaddr:= densenextllt(sourcemapaddr, getvalue, val);
                    destnextmapaddr  := densenextllt(destmapaddr,   putvalue, val);

                    if  not zglobalerror
                      then begin
                        linkcnt      := linkcnt + 1;
                        sourcemapaddr:= sourcenextmapaddr;
                        destmapaddr  := destnextmapaddr;
                        if   ((sourcenextmapaddr  = zXnil) and (linkcnt <> sourcelistno))
                          or ((sourcenextmapaddr <> zXnil) and (linkcnt  = sourcelistno))
                          or ((sourcenextmapaddr  = zXnil) and (destnextmapaddr <> zXnil))
                          or ((sourcenextmapaddr <> zXnil) and (destnextmapaddr  =zXnil))
                        then
                            zglobalerr (daadenserecconflict, nili);
                      end; (* if .. then *)
                  end; (* while .. do *)
              end; (* Dense *)
        end; (* case .. of *)
      end; (* if .. then *)

    if  zglobalerror
    then
        zglobalerr (daafailmovarrayl, componentloc);
  end  (* if .. then *)
else
    zglobalerr (daanexemovarrayl, componentloc);

end;  (* MovArrayLine *)

(* MEG 2/10/86 *)
{vax end. vax} 
