{**  DEC/CMS REPLACEMENT HISTORY, Element ZCOMPRESS.SRC **}
{**  *3     7-NOV-1986 08:31:39 PALASM2 "unix changes. extra end deleted" **}
{**  *2    10-OCT-1986 17:44:14 GZOWSKI "bug fix for 1006, 1007" **}
{**  *1    10-OCT-1986 08:58:37 PALASM2 "" **}
{**  DEC/CMS REPLACEMENT HISTORY, Element ZCOMPRESS.SRC **}
(*                                                                   *)
(*  (c) copyright Monolithic Memories, Inc. , 1986		     *)
(*                                                                   *)
(*  RJS 27/JAN/86 *)
{vax  %include 'pal2$inc:z24global.inc' vax}	
{vax  module zcompress (INPUT,OUTPUT);  vax} 


#include 'csopeninc.i'
#include 'ctre.i'
#include 'ctxtio.i'
#include 'fnxinc.i'
#include 'z24.i'


{ipp program zcompress ; ipp}
{ipp pragma On(Externals_allowed_internally); ipp}
{ipp pragma C_include('ctre.inc'); ipp}
{ipp pragma C_include('ctxtio.inc'); ipp}
{ipp pragma C_include('fnxinc.inc'); ipp}
{ipp pragma C_include('z24.inc'); ipp}
(*-------------------------------------------------------------------*)
(*                                                                   *)
(*  Module    : ZCompress                                            *)
(*  AUTHOR    : Chie-Jiun Chien                                      *)
(*  DATE      : 12/11/85                                             *)
(*  FUNCTION  : Routines in this module are related to compression   *)
(*              data                                                 *)    
(*                                                                   *)
(*  MODIFICATIONS :                                                  *)
(*    NAME        DATE       DESCRIPTION                             *)
(*    ----------- ---------- ------------------------------------    *)
(*    C.J.        12/11/85   Initial release                         *)
(*    M. Gzowski  1/24/86    Debug corrections in:		     *)
(*				CompressDesignData		     *)
(*				ResetEqTerm			     *)
(*				GetEqTerm			     *)
(*    M. Gzowski  1/28/86    Debug fix in:			     *)
(*				LinkDevPinData			     *)
(*    M. Gzowski  2/12/86    corrected tristate problems	     *)
(*    M. Gzowski  2/18/86    debug fixes			     *)
(*    M. Gzowski  2/25/86    debug fixes			     *)
(*    M. Gzowski  3/4/86     fixes for bugs #746 & #747		     *)
(*    M. Gzowski  3/6/86     catch more illegal equations	     *)
(*    CJ Chien    3/18/86    extend force routing                    *)
(*    M. Gzowski  3/24/86    changes made to GetEqTerm and ReadTre   *)
(*    M. Gzowski  4/7/86     changed "NoMorPinAssoc" to 	     *)
(*                            "NoMoreDevPinAssc"		     *)
(*    M.Gzowski   4/16/86    fixed bug #794, infinite loop problem   *)
(*    M.Gzowski   4/24/86    fixed bug #802, see BuildMTable proc.   *)
(*    M.Gzowski   5/20/86    flow mod in ForceRoute_and_CompressData *)
(*    CJ          9/19/86    modify default case for tristate        *)
(*    CJ          9/22/86    modify to cover all tristate case       *)
(*    M.Gzowski   9/23/86    fix array column allocation problem     *)
(*    M.Gzowski   10/10/86   ditto, fix for bugs 1006 & 1007	     *) {!! 2 !!}
(*                                                                   *)
(*                                                                   *)
(*  COMMENTS  :                                                      *)
(*                                                                   *)
(*  NOTES     :                                                      *)
(*                                                                   *)
(*                                                                   *)
(*  GLOBAL DECLARATIONS :                                            *)
(*                                                                   *)
(*  EXTERNAL DECLARATIONS :                                          *)
(*                                                                   *)
(*  The following routines are declared in this module external to   *)
(*  all the other modules                                            *)
(*  CompressDesignData                                               *)
(*                                                                   *)
(*  The following routines are declared only for this module use     *)
(*                                                                   *)
(*  ResetEqTerm			 				     *)
(*  GetEqTerm                    ForceRoute_and_CompressData         *)
(*  NewIDLink                    RetireIDList                        *)
(*  StartNewTerm                 AddCurrentOpToTerm                  *)
(*  EqTermBuilt                  GetRangeForPin                      *)
(*  LinkPinAssoc                 InitDevPins                         *)
(*  InTristatRng                 DisposeIDLinks			     *)
(*  ReadInArrayColumn                                                *)
(*-------------------------------------------------------------------*)

(* MEG 9/25/86 *)
var
      (* upper limit of 1-to-1 column/feedback *)
	feedbackset : columnusage;  	

(**)
  (*11111111111111111111111111111111111111111111111111111111111111111*)
  (*                                                                 *)
  (*  PROCEDURE : WriteOutColumn                                     *)
  (*  AUTHOR    : CJ Chien                                           *)
  (*  DATE      : 2/20/86                                            *)
  (*  FUNCTIONS : This routine is for debug use, to write out contents*)
  (*              in column table                                    *)
  (*                                                                 *)
  (*  MODIFICATIONS :                                                *)
  (*    NAME        DATE       DESCRIPTION                           *)
  (*    ----------- ---------- ------------------------------------  *)  
  (*    CJ Chien    2/20       initial release                       *)
  (*  COMMENTS  :                                                    *)
  (*                                                                 *)
  (*  INPUT PARAMETERS :                                             *)
  (*                                                                 *)
  (*    VARIABLE    TYPE       DESCRIPTION                           *)
  (*    ----------- ---------- ------------------------------------  *)
  (*                                                                 *)
{/DBG}  procedure writeoutcolumn;
        var count : intXx4;
            temppinlink : pinlink;
  begin
        for count := -maxdevicepin to maxdevicepin do
         begin
            {/dsy} write('Pin number =', count);
            {/dsy} writeln(' Column number =',columntable[count]);
            {dsy Write(errfile,'Pin number =', count); dsy}
            {dsy writeln(errfile,' Column number =',ColumnTable[count]);  dsy}
         end;
  end;


(**)
  (*11111111111111111111111111111111111111111111111111111111111111111*)
  (*                                                                 *)
  (*  Procedure : InitTables                                         *) 
  (*  AUTHOR    : CJ Chien                                           *)
  (*  DATE      : 2/20/86                                            *)
  (*  FUNCTION  : To initialize Mapping Table and Pin Table          *)
  (*                                                                 *)
  (*  MODIFICATIONS :                                                *)
  (*    NAME        DATE       DESCRIPTION                           *)
  (*    ----------- ---------- ------------------------------------  *)  
  (*    CJ Chien    2/20       initial release                       *)
  (*    M. Gzowski  9/25/86    add init for FeedbackSet              *)
  (*                                                                 *)
  (*  COMMENTS  :                                                    *)
  (*                                                                 *)
  (*  INPUT PARAMETERS :                                             *)
  (*                                                                 *)
  (*    VARIABLE    TYPE       DESCRIPTION                           *)
  (*    ----------- ---------- ------------------------------------  *)
  (*    MTable     MapTabTyp   Map Column and pin association        *)
  (*    PTable     PinTabtyp   link Pin with associated array columns *) 
  (*    ColTable   ColtabRec   map one column to one pin             *)
  (*    Pool       PoolRec     Contains all the pin usage            *)  
  (*                                                                 *)
  (*11111111111111111111111111111111111111111111111111111111111111111*)
  procedure inittables(var mtable:maptabtyp;
                       var ptable:pintabtyp;
                       var coltable:coltabrec;
                       var pool: poolrec);  
  var count : intXx4;  
  begin (* InitTables *)
(* To initialize MapTable *)
         for count := 1 to maxcolno do
         mtable[count] := nil;

(* To initialize column table,Pin Table and Pool table *)
         for count := -maxdevicepin to maxdevicepin do
         begin
              ptable[count].cnt := 0;
              ptable[count].collink := nil;
              coltable[count] := 0;
              pool[count] := false; 
         end;

 (* MEG 9/25/86 *)
 (* initialize feedback usage *)
        for count := 0 to zhalmaxcolno
         do feedbackset[count] := false;
  end; (* InitTables *)                      

(**)
  (*-----------------------------------------------------------------*)
  (*                                                                 *)
  (*  PROCEDURE : ReadInArrayColumn                                  *)
  (*  AUTHOR    : CJ Chien                                           *)
  (*  DATE      : 2/20/86                                            *)
  (*  FUNCTION  : Scan Array and get information about Array Column  *)
  (*              and its input component                            *)
  (*                                                                 *)
  (*  MODIFICATIONS :                                                *)
  (*    NAME        DATE       DESCRIPTION                           *)
  (*    ----------- ---------- ------------------------------------  *)  
  (*    CJ Chien    2/20       initial release                       *)
  (*    M Gzowski   4/7/86     const identifier changes		     *)
  (*    M Gzowski   10/10/86   modify column allocation, bug #1006   *) {!! 2 !!}
  (*  COMMENTS  :                                                    *)
  (*                                                                 *)
  (*  INPUT PARAMETERS :                                             *)
  (*                                                                 *)
  (*    VARIABLE    TYPE       DESCRIPTION                           *)
  (*    ----------- ---------- ------------------------------------  *)
  (*    Pool        PoolRec    pin usage pool                        *)
  (*    ColTable    ColTabRec  Column TAble                          *)
  (*                                                                 *)
  {vax [global] vax}
  procedure readinarraycolumn;  
  const citsize = 2;
        cindex  = 0;
         
  var arrayaddress : intXx4;
      arrayrectype : intXx4;
      limitio      : limitiorecord;
      count        : intXx4;
      iorec        : iotype;
      citindex     : intXx4;
      comprectype  : intXx4;
      comploc      : intXx4;
      pinno        : intXx4; 


(**)
  (*22222222222222222222222222222222222222222222222222222222222222222*)
  (*                                                                 *)
  (*  Function  : LinkColPin                                         *)
  (*  AUTHOR    : CJ Chien                                           *)
  (*  DATE      : 3/18/86                                            *)
  (*  FUNCTION  : To Link Pin Associations into Column Table         *)
  (*                                                                 *)
  (*  MODIFICATIONS :                                                *)
  (*    NAME        DATE       DESCRIPTION                           *)
  (*    ----------- ---------- ------------------------------------  *)  
  (*    CJ Chien    3/18/86    initial release                       *)
  (*    M. Gzowski  4/7/86     constant name corrections	     *)
  (*    M. Gzowski  9/23/86    added current level parameter,	     *)
  (* 			       functional rewrite.		     *)
  (*  COMMENTS  :                                                    *)
  (*                                                                 *)
  (*  INPUT PARAMETERS :                                             *)
  (*                                                                 *)
  (*    VARIABLE    TYPE       DESCRIPTION                           *)
  (*    ----------- ---------- ------------------------------------  *)
  (*    ColRecord   ColTabTyp   Column Record  of Map Table          *)
  (*    Devicepin   int_x4      Device Pin                           *)
  (*    CurrentLevel  int_x4	the level of the device pin assoc.   *)
  (*    CurrentCITIdx int_x4	the CIT index for the CC_FeedBack    *)
  (*    MainPin     int_x4      the pin with the lowest assoc level  *)
  (*				for the column (feedback component)  *)
  (*    IOrec       IOType      IO connection record for component   *)
  (*                                                                 *)
  (*22222222222222222222222222222222222222222222222222222222222222222*)

(* MEG 9/23/86 *)
   function linkcolpin(var colrec:pinlink;
                           devicepin:intXx4;
			   currentlevel:intXx4;
			   currentcitidx:intXx4;
			   mainpin:intXx4;
                           iorec:iotype):intXx4;
   const 
         fst   = 1;
   var newlink : pinlink;
   begin

(* first, check to see if there is a device pin association *)
     if devicepin = nomoredevpinassc 
        then

(* no associations *)
             linkcolpin := nomoredevpinassc 
        else
             begin

(* create a record *)
              new(newlink);

(* add the record to the linked list *)
              if (iorec[flag] - vln) = fst
                then
                  newlink^.val := devicepin
                else
                  newlink^.val := -devicepin;
                newlink^.level := currentlevel;
                newlink^.citindex := currentcitidx;
                newlink^.mainassoc := mainpin;
                newlink^.next := colrec;
                colrec := newlink;

(* set the return value *)
                linkcolpin := devicepin;
             end; (*else*)

end; (* LinkColPin *)

(**)
  (*22222222222222222222222222222222222222222222222222222222222222222*)
  (*                                                                 *)
  (*  Procedure : Transform                                          *)
  (*  AUTHOR    : CJ Chien                                           *)
  (*  DATE      : 3/23/86                                            *)
  (*  FUNCTIONS : Transfom from MapTable to PinTable. MapTable is    *)
  (*              pin linked list based on array columns, Pintable is*)
  (*              array column linked list based on pin              *)
  (*                                                                 *)
  (*  MODIFICATIONS :                                                *)
  (*    NAME        DATE       DESCRIPTION                           *)
  (*    ----------- ---------- ------------------------------------  *)  
  (*    CJ Chien    3/23/86    initial release                       *)
  (*    M.Gzowski   9/23/86    sort link lists by level, rewrite     *)
  (*  COMMENTS  :                                                    *)
  (*                                                                 *)
  (*  INPUT PARAMETERS :                                             *)
  (*                                                                 *)
  (*    VARIABLE    TYPE       DESCRIPTION                           *)
  (*    ----------- ---------- ------------------------------------  *)
  (*    MTable      MapTabTyp  MapTable is pin association list based*)
  (*                           on array column                       *)
  (*    PTable      PinTabTyp  PinTable is array column list based   *)
  (*                           on each device pin                    *)
  (*                                                                 *)
  (*22222222222222222222222222222222222222222222222222222222222222222*)
(* MEG 9/23/86 *)
procedure transform( var mtable : maptabtyp; var ptable : pintabtyp);
var count : intXx4;
    ptablelink,		(* current pointer in the PTable linked lists *)
    templink,		(* temporary pointer for new PTable links *) {!! 2 !!}
(* MEG 10/10/86 *) {!! 2 !!}
    nextlink		(* current pointer in the MTable linked lists *) {!! 2 !!}
          : pinlink;
    recordinserthere	(* for traversing/inserting in the PTable linked lists*)
          : boolean;
    pin   : intXx4;
     
begin
(* test all the columns *)
      for count := 1 to maxcolno do
      begin

(* MEG 10/10/86 bug #1006*) {!! 2 !!}
          nextlink := mtable[count]; {!! 2 !!}
 {!! 2 !!}
(* get each (pin) mapping for that column, i.e. stop when list emptied *)
          while (nextlink <> nil) do {!! 2 !!}
          begin

(* make a new record, initialize it to the corresponding record from MTable *) {!!2!!}
               new (templink); {!! 2 !!}
               templink^ := nextlink^; {!! 2 !!}
               pin := templink^.val; 
               templink^.val := count;
 {!! 2 !!}
(* move the pointer *) {!! 2 !!}
               nextlink := nextlink^.next; {!! 2 !!}

(* if the PTable is empty for that pin, start the linked list *)
               if ptable[pin].collink = nil 
                 then begin
                   templink^.next := nil;
                   ptable[pin].collink := templink;
                  end (*if...then*)

(*... else if the list exist, insert the record at the proper location *)
                 else begin

(*  check for list head *)
                   if ptable[pin].collink^.level > templink^.level
                    then begin
                      templink^.next := ptable[pin].collink;
                      ptable[pin].collink := templink;
                     end (*if...then*)

(*  traverse the list, insert the record after the first link *)
                    else begin
                      ptablelink := ptable[pin].collink;
                      recordinserthere := false;
                      while not recordinserthere
                       do begin
                         
(*  check if at tail (must insert if here) *)
			if ptablelink^.next = nil
                         then recordinserthere := true

(*  check for mid list insertion (insert if appropriate) *)
                         else if ptablelink^.next^.level > templink^.level
                          then recordinserthere := true;

(*  make a mid/end-of-list insertion *)
                        if recordinserthere 
                         then begin
                           templink^.next := ptablelink^.next;
                           ptablelink^.next := templink;
                          end (*if...then*)
(*   ...or move to next link in list *)
                         else ptablelink := ptablelink^.next;
                        end; (*while...do*)
                     end; (*else*)
                  end; (*else*)

(* mark the PTable list for the addition *)
              ptable[pin].cnt := succ(ptable[pin].cnt);
           end; (* while *)   
      end; (* for *)
end; (* Transform *)

(**)
  (*22222222222222222222222222222222222222222222222222222222222222222*)
  (*                                                                 *)
  (*  Procedure : BuildMTable                                        *)
  (*  AUTHOR    : CJ Chien                                           *)
  (*  DATE      : 3/23/86                                            *)
  (*  FUNCTIONS : Build a Map Table                                  *)
  (*                                                                 *)
  (*  MODIFICATIONS :                                                *)
  (*    NAME        DATE       DESCRIPTION                           *)
  (*    ----------- ---------- ------------------------------------  *)  
  (*    CJ Chien    3/23/86    initial release                       *)
  (*    M. Gzowski  4/24/86    bug # 802, declared COUNT within this *)
  (*			       procedure.			     *)
  (*    M. Gzowski  4/24/86    fixed looping problem		     *)
  (*    M. Gzowski  9/23/86    fixed column allocation problem	     *)
  (*  COMMENTS  :                                                    *)
  (*                                                                 *)
  (*  INPUT PARAMETERS :                                             *)
  (*                                                                 *)
  (*    VARIABLE    TYPE       DESCRIPTION                           *)
  (*    ----------- ---------- ------------------------------------  *)
  (*    MTable      MapTabTyp  MapTable is pin association list based*)
  (*                           on array column                       *)
  (*                                                                 *)
  (*22222222222222222222222222222222222222222222222222222222222222222*)
   procedure buildmtable(var mtable : maptabtyp);
   var 
  (* MEG 4/24/86 bug # 802 *)
  (* MWG 9/23/86 *)
	nolevels,
        currlevel,
        keypin,
	count,
	status : intXx4;
   begin     
  
  (* To find the starting address of Array Column *)
       arrayrectype := getop(andop,oparrayref);
       arrayaddress := getcomponentloc(arrayrectype,cindex); 
       limitio      := findlimitrecord(arrayaddress,column);

  (* From first column to last one, push column information into table *)
       for count := 1 to limitio[nototal] do
       begin
  (* get the component which is input to array *)
           iorec := getconnection(arrayaddress,inputcomp,count-1);
           comprectype := getrecordtype(iorec[nextXcomponent]);
           comploc := examinemitrec(comprectype,citlocation);
           if examinemitrec(comprectype,componentXclass) = ccXinvninvbuff
             then
                 begin
  (* get all pin association for a particular component for all levels *)
  (* MEG 9/23/86 *)
                  citindex := getcitindex(iorec[nextXcomponent]);
		  nolevels := getassoclevels (comprectype);
                  for currlevel := 0 to pred(nolevels)
                   do repeat
                     pinno := getpinassoct(comprectype,citindex,currlevel);
                     if pinno <> nomoredevpinassc 
                      then begin
                        if currlevel = 0 then keypin := pinno;
                        status := linkcolpin(mtable[count],
                                             pinno,
                                             currlevel,
                                             citindex,
                                             keypin,
                                             iorec);
                       end; (*if...then*)
  (* MEG 4/24/86 *)
                    until ( pinno = nomoredevpinassc ) or zglobalerror;
                 end;
                 
       end; (* for *)
end;  

(**)
  (*22222222222222222222222222222222222222222222222222222222222222222*)
  (*                                                                 *)
  (*  Procedure : DisposeLink                                        *)
  (*  AUTHOR    : CJ Chien                                           *)
  (*  DATE      : 3/23/86                                            *)
  (*  FUNCTION  : get rid of all elements in a list that have the    *)
  (* 		  passed value.					     *)
  (*                                                                 *)
  (*  MODIFICATIONS :                                                *)
  (*    NAME        DATE       DESCRIPTION                           *)
  (*    ----------- ---------- ------------------------------------  *)  
  (*    CJ Chien    3/27/86    initial release                       *)
  (*  COMMENTS  :                                                    *)
  (*                                                                 *)
  (*  INPUT PARAMETERS :                                             *)
  (*                                                                 *)
  (*    VARIABLE    TYPE       DESCRIPTION                           *)
  (*    ----------- ---------- ------------------------------------  *)
  (*    testval     int_X4     the test value			     *)
  (*    TableLink   pinlink    is pointer to the list.		     *)
  (*                                                                 *)
  (*22222222222222222222222222222222222222222222222222222222222222222*)
  procedure disposelink (   testval  : intXx4;
                        var tablelink: pinlink);
  var currlink : pinlink;
      lastlink : pinlink;  

  begin
  (* set up the list traversal pointers *)
       currlink := tablelink;
       lastlink := tablelink;

  (* traverse the list *)
       while currlink <> nil do

  (* check if this value is a match, get rid of the link if so *)
        if testval = currlink^.val
         then begin
  
  (* if this is the first link... *)
  (* ...then the next link will be the first link... *)
           if currlink = lastlink
            then begin
              tablelink := currlink^.next;
              dispose (currlink);
  (* de ja vu *)
              lastlink := tablelink;
              currlink := tablelink;
             end (*if...then*)

  (* ...this is not the first link *)
            else begin
              lastlink^.next := currlink^.next;
              dispose (currlink);
              currlink := lastlink^.next;
             end; (*else*)
          end

  (* this is no match, move on to the next link *)
         else begin
           lastlink := currlink;
           currlink := currlink^.next;
          end;
  end;

(**)
  (*22222222222222222222222222222222222222222222222222222222222222222*)
  (*                                                                 *)
  (*  Procedure : PutIntoGarbageList                                 *)
  (*  AUTHOR    : CJ Chien                                           *)
  (*  DATE      : 3/28/86                                            *)
  (*  FUNCTIONS : Dispose not used linked list to a garbage list     *)
  (*                                                                 *)
  (*  MODIFICATIONS :                                                *)
  (*    NAME        DATE       DESCRIPTION                           *)
  (*    ----------- ---------- ------------------------------------  *)  
  (*    CJ Chien    3/28/86    initial release                       *)
  (*  COMMENTS  :                                                    *)
  (*                                                                 *)
  (*  INPUT PARAMETERS :                                             *)
  (*                                                                 *)
  (*    VARIABLE    TYPE       DESCRIPTION                           *)
  (*    ----------- ---------- ------------------------------------  *)
  (*    Pin         int_x4     Device Pin                            *)
  (*    Col         int_x4     Array Column No                       *)
  (*                                                                 *)
  (*22222222222222222222222222222222222222222222222222222222222222222*)
  procedure putintogarbagelist(pin:intXx4;
                               col:intXx4);
  var junklist : listlink;
  begin (* PutIntoGarbageList *)
       if currentlist <> nil
          then
              begin
               new(junklist); 
               currentlist^.next := junklist;
               junklist^.pin := pin;
               junklist^.col := col;
               junklist^.next := nil;
               currentlist := junklist;
              end
          else
              begin
               new(currentlist);
               currentlist^.col := col;
               currentlist^.pin := pin;
               currentlist^.next := nil;
               garblist := currentlist;
              end;
  end; (* PutIntoGarbageList *)    
(**)
  (*22222222222222222222222222222222222222222222222222222222222222222*)
  (*                                                                 *)
  (*  Procedure : KillList                                           *)
  (*  AUTHOR    : CJ Chien                                           *)
  (*  DATE      : 3/23/86                                            *)
  (*  FUNCTIONS : Kill Garbage list and do dispose                   *)
  (*                                                                 *)
  (*  MODIFICATIONS :                                                *)
  (*    NAME        DATE       DESCRIPTION                           *)
  (*    ----------- ---------- ------------------------------------  *)  
  (*    CJ Chien    3/23/86    initial release                       *)
  (*  COMMENTS  :                                                    *)
  (*                                                                 *)
  (*  INPUT PARAMETERS :                                             *)
  (*                                                                 *)
  (*    VARIABLE    TYPE       DESCRIPTION                           *)
  (*    ----------- ---------- ------------------------------------  *)
  (*                                                                 *)
  (*22222222222222222222222222222222222222222222222222222222222222222*)

  procedure killlist;
  var pin : intXx4;
      colno:intXx4;
      templink,plist : pinlink;
  begin (* KillList *)
(* Kill garbageList *)
       while garblist <> nil do
       begin
            pin := garblist^.pin;
            colno := garblist^.col;
            plist := maptable[colno];
(* Check Pin list to dispose column node *)
            while plist <> nil do
            begin
             pin := plist^.val;
             templink := pintable[pin].collink; 
             disposelink(colno,templink);
             pintable[pin].collink := templink;
             pintable[pin].cnt := pred(pintable[pin].cnt);
             plist := plist^.next;
            end;
            garblist := garblist^.next;
      end;
end;  (* KillList *)          

(**)
  (*22222222222222222222222222222222222222222222222222222222222222222*)
  (*                                                                 *)
  (*  Procedure : MatchTable                                         *)
  (*  AUTHOR    : CJ Chien                                           *)
  (*  DATE      : 3/23/86                                            *)
  (*  FUNCTIONS : Match PinTable with the usage list and decide which*)
  (*              column maps to which pin                           *)
  (*                                                                 *)
  (*  MODIFICATIONS :                                                *)
  (*    NAME        DATE       DESCRIPTION                           *)
  (*    ----------- ---------- ------------------------------------  *)  
  (*    CJ Chien    3/23/86    initial release                       *)
  (*    M. Gzowski  4/16/86    fixed bug #794, infinite loop  	     *)
  (*  COMMENTS  :                                                    *)
  (*                                                                 *)
  (*  INPUT PARAMETERS :                                             *)
  (*                                                                 *)
  (*    VARIABLE    TYPE       DESCRIPTION                           *)
  (*    ----------- ---------- ------------------------------------  *)
  (*    MTable      MapTabTyp  MapTable is pin association list based*)
  (*                           on array column no                    *)
  (*    PTable      PinTable   PTable is array column list based on  *)
  (*                           each device pin                       *)
  (*    UsageList   PoolRec    To store pin usage                    *)
  (*    ColTable    ColTabRec  Maps each array column to one pin     *)
  (*                                                                 *)
  (*22222222222222222222222222222222222222222222222222222222222222222*)
  procedure matchtable(var  mtable:maptabtyp;
                       var  ptable:pintabtyp;
                       var  usagelist:poolrec;
                       var  coltable:coltabrec);
  label 999;

  var pin : intXx4;
      col : intXx4;
      done : boolean;
      initcount : intXx4;
      pinusage  : boolean;
      templink : pinlink;
      columnused : columnusage;
      i : intXx4;
  (* MEG 9/26/86 *)
      minoutputassoc : intXx4;

  begin
  (* initialize *)
     initcount := 1;
     pinusage  := false;
  (* MEG 9/26/86 *)
  (* fit feedback on components associated with an output pin only *)
     minoutputassoc := succ(maxdevicepin div 2);
     for i := 1 to maxcolno
      do columnused[i] := false;

  (* This repeat loop is to match tables and put the correct result in column *)
  (* table until PinUsed in Pool is empty *)
     repeat
       done := true;
       currentlist := nil;
       garblist    := nil;

  (* for each pin, scan pool and marked the used pins *)
       for pin := -maxdevicepin to maxdevicepin do
       begin

  (* if Pin Usage in the pool is not empty and the count in PTable[pin] is *)
  (* what we expect , then go to get the corresponding column number and   *)
  (* put it into column table *) 
           if (usagelist[pin] ) 
            and (ptable[pin].cnt = initcount) 
            and not zglobalerror
             then
                 begin
                  done := false;
                  col := ptable[pin].collink^.val;

  (* Check if the column has been used already... *)
                  if not columnused[col]
  (* ... has not been used yet, ... *)
                   then begin
                     columnused[col] := true;
  (* ... now it has. *)
                     coltable[pin] := col;
  (*	   only fit the feedback on the outputs *)
                     with ptable[pin].collink^
                      do if mainassoc >= minoutputassoc 
                       then fitfeedback( citindex, 
                                          mainassoc,
                                          abs(pin),
                                          feedbackset);
                     templink := ptable[pin].collink;
                     if ptable[pin].collink^.next <> nil
                       then ptable[pin].collink := ptable[pin].collink^.next
                       else ptable[pin].collink := nil;
                     dispose(templink);
                     ptable[pin].cnt := pred(ptable[pin].cnt);
                     usagelist[pin] := false;
  (* To dispose the used column *)
                     disposelink(pin,mtable[col]);
                     putintogarbagelist(pin,col);
                    end (*if...then*)

  (* This column has been used already, flag an error.     *)
  (* A failure at this point indicates a bad equation set. *)
                   else begin
                     zglobalerr ( mustpassxplot , nili );
                     zglobalerr ( ddcarrayallocation , abs(pin) );
                     goto 999;
                    end; (*else*)
                 end; (* if *)
       end; (* for *)

  (* if all the pin usage comes with count more than one, *)
  (* then we have to increment, init count and do it again *)
       pin := -maxdevicepin;

  (* MEG 4/15/86 bug # 794 *)
  (* if we found something on this scanned pass, then kill the list generated...*)
       if not done
          then 
              killlist

  (* ...otherwise check if anything has been missed *)
          else
              while done 
              and (pin <= maxdevicepin) 
              and not zglobalerror do
              begin

  (*  if the pinhas been used, and the count has not been reached yet,	*)
  (*    then clear DONE and increment the count				*)
  (*    else this is a lost signal, flag an error.		   	*)
               if usagelist[pin] 
                then begin
                  if (ptable[pin].cnt > initcount) 
                   then begin
                     done := false;
                     initcount := succ(initcount);
                    end
                   else
                    zglobalerr ( ddcarrayallocation , abs(pin) );
                 end; (*if...then*)
               pin := succ(pin);
              end; (* while *)
     until done;

  (*Error Bailout*)
999:;
end; (* MatchTable *)

(**) 
(* -------------    main routine of readinarraycolumn ---------------*)
  begin (* ReadInArrayColumn *)

      buildmtable(maptable);
      transform(maptable,pintable);
      matchtable(maptable,pintable,pool,columntable);
  end;  (* ReadInArrayColumn *)
       

  (**)
  (*                                                                 *)
  (*11111111111111111111111111111111111111111111111111111111111111111*)
  (*                                                                 *)
  (*  PROCEDURE : PolarAdjust					     *)
  (*  AUTHOR    : M.Gzowski					     *)
  (*  DATE      : 3/24/86					     *)
  (*  FUNCTION  : accepts a pin/ID/signal number, i, where i>0	     *)
  (*	          signifies "pin i", and i<0 signifies "/pin i",     *)
  (*		  and returns the value of i corrected/adjusted	     *)
  (*		  for the declared polarity.			     *)
  (*								     *)
  (*  MODIFICATIONS :                                                *)
  (*    NAME        DATE       DESCRIPTION                           *)
  (*    ----------- ---------- ------------------------------------  *)  
  (*                                                                 *)
  (*  COMMENTS  : 						     *)
  (*                                                                 *)
  (*  INPUT PARAMETERS :                                             *)
  (*    VARIABLE    TYPE       DESCRIPTION                           *)
  (*    ----------- ---------- ------------------------------------  *)
  (*    PinID       int_X4     the value to be adjusted.	     *)
  (*                                                                 *)
  function polaradjust ( pinid : intXx4 ) : intXx4;
  begin (*PolarAdjust*)

    (* if the pin ID was declared as complemented then complement the value *)
      if devpins[ abs(pinid) ].declaredcomplement
       then polaradjust := -pinid
       else polaradjust := pinid;

    end;  (*PolarAdjust*)

  (**)
  (*                                                                 *)
  (*11111111111111111111111111111111111111111111111111111111111111111*)
  (*                                                                 *)
  (*  PROCEDURE : RetireIDList					     *)
  (*  AUTHOR    : M.Gzowski					     *)
  (*  DATE      : 12/20/85                                           *)
  (*  FUNCTION  : retires a linked list of IDRec to the FreeIDRec    *)
  (*              list.						     *)
  (*  MODIFICATIONS :                                                *)
  (*    NAME        DATE       DESCRIPTION                           *)
  (*    ----------- ---------- ------------------------------------  *)  
  (*    M.Gzowski   12/20/85   Initial release			     *)
  (*                                                                 *)
  (*  COMMENTS  : 						     *)
  (*                                                                 *)
  (*  INPUT PARAMETERS :                                             *)
  (*    VARIABLE    TYPE       DESCRIPTION                           *)
  (*    ----------- ---------- ------------------------------------  *)
  (*    FreeLink    IDLink     pointer to the top of the list of     *)
  (*			       records to be retired.		     *)
  procedure retireidlist ( var freelink : idlink );
    var
	templink : idlink;
    begin (*RetireIDList*)

    (* make sure there is something to save. *)
      if freelink <> nil
       then begin

    (* go to the end of the passed list *)
         templink := freelink;
         while templink^.next <> nil
          do templink := templink^.next;

         templink^.next := freeidrec;
         freeidrec := freelink;
         freelink := nil;
         
        end; (*if...then*)
    end;  (*RetireIDList*)

(**)
  (*                                                                 *)
  (*11111111111111111111111111111111111111111111111111111111111111111*)
  (*                                                                 *)
  (*  PROCEDURE : DisposeIDLinks				     *)
  (*  AUTHOR    : M.Gzowski					     *)
  (*  DATE      : 12/20/85                                           *)
  (*  FUNCTION  : this procedure cleans up the EqTerm globals.	     *)
  (*                                                                 *)
  (*  MODIFICATIONS :                                                *)
  (*    NAME        DATE       DESCRIPTION                           *)
  (*    ----------- ---------- ------------------------------------  *)  
  (*    M.Gzowski   12/20/85   initial release			     *)
  (*    M.Gzowski   1/17/86    procedure made local		     *)
  (*    M.Gzowski   2/12/86    procedure renamed from CleanUpEqTerm  *)	
  (*                                                                 *)
  (*  COMMENTS  : 						     *)
  (*                                                                 *)
  (*  INPUT PARAMETERS :                                             *)
  (*    VARIABLE    TYPE       DESCRIPTION                           *)
  (*    ----------- ---------- ------------------------------------  *)
  (*                                                                 *)
  procedure disposeidlinks;
    var
	templink : idlink;

    begin (*DisposeIDLinks*)

    (* make sure there is something to clean up. *)
      if freelink <> nil
       then begin

    (* get rid of all elements in the list *)
         repeat
           templink := freelink;
           freelink := freelink^.next;
           dispose (templink);
         until freelink = nil;
      
        end; (* if.. then .. else *)
    end;  (*DisposeIDLinks*)

  (**)
  (*                                                                 *)
  (*11111111111111111111111111111111111111111111111111111111111111111*)
  (*                                                                 *)
  (*  PROCEDURE : NewIDLink					     *)
  (*  AUTHOR    : M.Gzowski					     *)
  (*  DATE      : 12/20/85                                           *)
  (*  FUNCTION  : this function return a pointer to an IDRec, type   *)
  (*		  IDLink.  The IDRec has the field values of the     *)
  (*		  passed parameters.				     *)
  (*                                                                 *)
  (*  MODIFICATIONS :                                                *)
  (*    NAME        DATE       DESCRIPTION                           *)
  (*    ----------- ---------- ------------------------------------  *)  
  (*    M.Gzowski   12/20/85   Initial release			     *)
  (*                                                                 *)
  (*  COMMENTS  : 						     *)
  (*                                                                 *)
  (*  INPUT PARAMETERS :                                             *)
  (*    VARIABLE    TYPE       DESCRIPTION                           *)
  (*    ----------- ---------- ------------------------------------  *)
  (*    IDVal	    int_X4     the value of the identifier (device   *)
  (*			       pin number).			     *)
  (*    IDList 	    IDLink     the pointer to some list of IDRec.    *)
  (*                                                                 *)
  function newidlink ( idval : intXx4; idlist : idlink ) : idlink;
  var  templink : idlink;
    begin

    (* check if any nodes exist already *)
      if freeidrec <> nil
       then begin
         templink := freeidrec;
         freeidrec := freeidrec^.next;
        end
       else new(templink);

    (* set up the IDRec *)
      templink^.val := idval;
      templink^.next := idlist;
      newidlink := templink;
    (* C.J. 12/24 *)
    end;

  (**)
  (*                                                                 *)
  (*11111111111111111111111111111111111111111111111111111111111111111*)
  (*                                                                 *)
  (*  PROCEDURE : ResetEqTerm					     *)
  (*  AUTHOR    : Chie-Jiun Chien, M.Gzowski                         *)
  (*  DATE      : 12/20/85                                           *)
  (*  FUNCTION  : This procedure resets the globals used by the	     *)
  (*              GetEqTerm routine, and makes the appropriate	     *)
  (*		  call(s) to reset GetTreNode globals.               *)
  (*                                                                 *)
  (*  MODIFICATIONS :                                                *)
  (*    NAME        DATE       DESCRIPTION                           *)
  (*    ----------- ---------- ------------------------------------  *)  
  (*    C.J.        12/20/85   Initial release			     *)
  (*    M. Gzowski  1/13/86    Debug changes, procedure made local   *)
  (*    M. Gzowski  2/12/86    removed redunant code		     *)
  (*    M. Gzowski  2/25/86    added VCC and GND fields              *)
  (*                                                                 *)
  (*  COMMENTS  : 						     *)
  (*                                                                 *)
  (*  INPUT PARAMETERS :                                             *)
  (*                                                                 *)
  (*    VARIABLE    TYPE       DESCRIPTION                           *)
  (*    ----------- ---------- ------------------------------------  *)
  (*    DevicePin   int_X4     the device pin to be force routed and *)
  (*			       converted to compressed form.         *)
  (* MEG 2/18/86						     *)
  (*    EqType      EquationType  what to set the equation to.	     *)
  (* MEG 1/15/86						     *)
  (*    Traverse    TraverseRec 				     *)
  (*			       the record containing the traversal   *)
  (*			       for the equation			     *)
  (*                                                                 *)
  (*                                                                 *)
  (* MEG 1/15/86 *)
  (* MEG 2/18/86 *)
  procedure reseteqterm(    devicepin : intXx4;
			    eqtype    : equationtype;
			var traversal : traverserec);
  
    var 
	idlist,tempnode : idlink;

    begin  (*ResetEqTerm*)

    (* MEG 1/16/86 *)
    (* MEG 2/18/86 *)
      settrenode ( devicepin, traversal, eqtype );

    (* Set up for Term *)
       with traversal.tempeq
        do begin
          devpin := devicepin;
          if (eqtype = trstXeq) and devpins[devicepin].triflag
           then
            trstnode := true
           else
            trstnode := false;
          done := false;
          xornode := false;
          left := false;
          ornode := false;
    (* MEG 2/25/86 *)
          vccnode := false;
          gndnode := false;
          andnode := false;
          idcount := 0;
          idlist  := nil;
         end; (*with...do*)

    end;   (*ResetEqTerm*)

(**)
(*-------------------------------------------------------------------*)
(*                                                                   *)
(*  PROCEDURE : InitDevPins                                          *)
(*  AUTHOR    : Chie-Jiun Chien                                      *)
(*  DATE      : 12/12/85                                             *)
(*  FUNCTION  : TO SET INITIAL VALUES TO DEVICE PIN                  *)
(*                                                                   *)
(*  MODIFICATIONS :                                                  *)
(*    NAME        DATE       DESCRIPTION                             *)
(*    ----------- ---------- ------------------------------------    *)
(*    C.J.        12/12/85   Initial release                         *)
(*    C.J.        3/6/86     modification                            *)
(*                                                                   *)
(*                                                                   *)
(*  COMMENTS  :                                                      *)
(*                                                                   *)
(*                                                                   *)
(*  INPUT PARAMETERS:                                               *)
(*-------------------------------------------------------------------*)
procedure initdevpins;
const notused = -1;
var 
    count : intXx4;
    pincount : intXx4;
    range1,range2   : rangearrptr;
begin (* INITDEVPINS *)
   (* set initial values to Device Pins from the first pin to the last *)
      for count := mindevicepin to maxdevicepin do
      begin
            devpins[count].registered := false;
            devpins[count].complemented := false;
            devpins[count].triflag      := false;
            devpins[count].equatn := nil;
            devpins[count].tristate := nil;
            devpins[count].levelrange := nil;
            devpins[count].levelrange2nd := nil;
      end; (* first level for .. begin .. end *)
end;  (* InitDevPins *)
(**)     
(*-------------------------------------------------------------------*)
(*                                                                   *)
(*  PROCEDURE : GetRangeForPin                                       *)
(*  AUTHOR    : Chie-Jiun Chien                                      *)
(*  DATE      : 12/12/85                                             *)
(*  FUNCTION  : This procedure checks the range limit for the element*)
(*              on each level of each pin                            *)
(*                                                                   *)
(*  MODIFICATIONS :                                                  *)
(*    NAME        DATE       DESCRIPTION                             *)
(*    ----------- ---------- ------------------------------------    *)
(*    C.J.        12/12/85   Initial release                         *)
(*    M. Gzowski  1/24/86    debug fixes			     *)
(*    M. Gzowski  1/29/86    marginal increase in efficiency	     *)
(*    M. Gzowski  2/3/86     made some variables global		     *)
(*    C.J.        3/5/86     rewrite the routine for AND2 gate       *)
(*                                                                   *)
(*                                                                   *)
(*  COMMENTS  :                                                      *)
(*                                                                   *)
(*  NOTES     :							     *)
(*                                                                   *)
(*  INPUT PARAMETERS :                                               *)
(*  -------------------------------------------------------------    *)
(*  VARIABLE      TYPE        DESCRIPTION                            *)
(*                                                                   *)
(*                                                                   *)

procedure getrangeforpin;
  const
  	norow = -1;
        arrcitindex = 0;
  var 
	recordtype   : intXx4;
        currrow,
 (* MEG 1/29/86 *)
        nooftestrows,
        temprow      : intXx4;
	pinassoc     : intXx4;
 (* CJ 3/5/86 *)
        andgaterectype: intXx4;
        noofcomps    : intXx4;
        noofpin      : intXx4;
        assoclevel   : intXx4;
	citindex     : intXx4;
        level        : intXx4;
        pinno        : intXx4;
        devpinno     : intXx4;
        range        : rangearrptr;

(**)
    (*								     *)
    (*222222222222222222222222222222222222222222222222222222222222222*)
    (*								     *)
    (*  PROCEDURE : TestForFirstPinRange			     *)
    (*  AUTHOR    : Mike Gzowski				     *)
    (*  DATE      : 1/27/86					     *)
    (*  FUNCTION  : This procedure makes a new RangeArray if needed. *)
    (*								     *)
    (*  MODIFICATIONS :						     *)
    (*    NAME        DATE       DESCRIPTION			     *)
    (*    ----------- ---------- ------------------------------------*)
    (*								     *)
    (*  COMMENTS  :						     *)
    (*								     *)
    (*  NOTES     :						     *)
    (*								     *)
    (*  INPUT PARAMETERS :					     *)
    (*  VARIABLE      TYPE       DESCRIPTION			     *)
    (*  ------------- ---------- ------------------------------------*)
    (*  RngArrPtr     RangeArrPtr 	Test this pointer            *)
    (*								     *)
    procedure testforfirstpinrange ( var rngarrptr : rangearrptr);
      var
	i : intXx4;
      begin (* TestForFirstPinRange *)

      (* test if array exists *)
         if rngarrptr = nil 
          then begin

      (* create the array and intialize it *)
            new (rngarrptr);
            for i := minassoclevels to maxassoclevels 
             do with rngarrptr^[i]
              do begin
                low := norow;
                high := norow;
               end; (*with...do*)
           end; (*if...then*)
      end;  (* TestForFirstPinRange *)
(**)
  (*								     *)
  (*22222222222222222222222222222222222222222222222222222222222222222*)
  (*								     *)
  (*  PROCEDURE : LinkPinAssoc					     *)
  (*  AUTHOR    : Chie-Jiun Chien				     *)
  (*  DATE      : 12/12/85					     *)
  (*  FUNCTION  : This procedure test if the row is a new boundary   *)
  (*		  for the given pin at the given level.		     *)
  (*								     *)
  (*  MODIFICATIONS :						     *)
  (*    NAME        DATE       DESCRIPTION			     *)
  (*    ----------- ---------- ------------------------------------  *)
  (*    C.J.        12/12/85   Initial release			     *)
  (*    M.Gzowski   1/27/86    Debug rewrite			     *)
  (*    C.J.        3/5/86     rewrite                               *)
  (*								     *)
  (*								     *)
  (*  COMMENTS  :						     *)
  (*								     *)
  (*  NOTES     :						     *)
  (*								     *)
  (*  INPUT PARAMETERS :					     *)
  (*  VARIABLE      TYPE       DESCRIPTION			     *)
  (*  ------------- ---------- ------------------------------------  *)
  (*  GivenPin	    int_X4     the device pine to be associated to   *)
  (*  GivenLevel    int_X4     the level of the association	     *)
  (*  CompIndex     int_x4     the component index                   *)
  (*								     *)
  (*								     *)
  procedure linkpinassoc(  givenpin,
                           compindex,
			   givenlevel: intXx4 );
    var
	assocrng: rangearrptr;


    begin  (* LinkPinAssoc *)
        
    (* test if it belongs to first level range or second level range *)
         if givenpin < 0
           then begin
                with devpins[abs(givenpin)].levelrange2nd^[givenlevel] do
                 begin  
                    if (low = norow) or (compindex < low)
                      then low := compindex;
                    if (high = norow) or (compindex > high)
                      then high  := compindex; 
                 end
               end
           else begin
                with devpins[abs(givenpin)].levelrange^[givenlevel] do
                 begin  
                    if (low = norow) or (compindex < low)
                      then low := compindex;
                    if (high = norow) or (compindex > high)
                      then high  := compindex; 
                 end
               end

    end;   (* LinkPinAssoc *)

(**)     
(*1111111111111111111111111111111111111111111111111111111111111111111*)
(*------------------ main flow of GetRangeForPin --------------------*)
  begin  (* GetRangeForPin *)

(* Find and gate address in memory *)
    andgaterectype := getop(andop,opcomponentref);

(* Find number of components in And gate *)
    noofcomps := examinemitrec(andgaterectype,nocomponents);
    assoclevel:= getassoclevels(andgaterectype);

(* Link pin association of each component to device pin range *)
(* Be careful, all the index starts from zero *)
    for citindex := 0 to noofcomps-1 do
     begin
       for level := 0 to assoclevel-1 do
        begin
          repeat
            pinno := getpinassoct(andgaterectype,citindex,level);
            if pinno <> nomoredevpinassc 
             then begin
               if pinno < 0
                then testforfirstpinrange(devpins[abs(pinno)].levelrange2nd)
                else testforfirstpinrange(devpins[pinno].levelrange);
               linkpinassoc(pinno,citindex,level);
              end;
          until (pinno = nomoredevpinassc); 
         end;
      end;

  end;   (* GetRangeForPin *)

  (**)
  (*                                                                 *)
  (*11111111111111111111111111111111111111111111111111111111111111111*)
  (*                                                                 *)
  (*  PROCEDURE : GetEqTerm					     *)
  (*  AUTHOR    : M.Gzowski					     *)
  (*  DATE      : 12/20/85                                           *)
  (*  FUNCTION  : this function interprets the TRE traversal	     *)
  (*		  and from the data creates a term record,	     *)
  (*		  type TermRec.					     *)
  (*                                                                 *)
  (*  MODIFICATIONS :                                                *)
  (*    NAME        DATE       DESCRIPTION                           *)
  (*    ----------- ---------- ------------------------------------  *)  
  (*    M.Gzowski   12/20/85   Initial release			     *)
  (*    M.Gzowski   1/16/86    several debug changes made, made      *)
  (*			       procedure local.			     *)
  (*    M.Gzowski   2/3/86     parameter and flow changes.	     *)
  (*    M.Gzowski   2/25/86    changes made for VCC and GND	     *)
  (*    M.Gzowski   3/24/86    changes made to AddCurrentOpToTerm    *)
  (*                                                                 *)
  (*  COMMENTS  : 						     *)
  (*                                                                 *)
  (*  INPUT PARAMETERS :                                             *)
  (*                                                                 *)
  (*    VARIABLE    TYPE       DESCRIPTION                           *)
  (*    ----------- ---------- ------------------------------------  *)
  (*    Traverse    TraverseRec		 			     *)
  (*			       the record contianing the traversal   *)
  (*			       for the equation.		     *)
  (*    ReturnEqTerm TermRec
  (*                                                                 *)
  (*-----------------------------------------------------------------*) 
  (* MEG 1/17/86 *)
  procedure geteqterm( var traversal : traverserec;
 		       var returneqterm : termrec ) ;



    (**)
    (*                                                               *)
    (*222222222222222222222222222222222222222222222222222222222222222*)
    (*                                                               *)
    (*  PROCEDURE : EqTermBuilt 				     *)
    (*  AUTHOR    : M.Gzowski					     *)
    (*  DATE      : 12/20/85                                         *)
    (*  FUNCTION  : this function returns a boolean value:	     *)
    (*			true, if the equation traversal OpStack,     *)
    (*			 CurrentOp, and Reduce variable indicate     *)
    (*			 that a term has been completed;	     *)
    (*			false, if otherwise.			     *)
    (*								     *)
    (*  MODIFICATIONS :                                              *)
    (*    NAME        DATE       DESCRIPTION                         *)
    (*    ----------- ---------- ------------------------------------*)  
    (*    M.Gzowski   12/20/85   Initial release		     *)
    (*	  M.Gzowski   1/17/86    Debug modifications		     *)
    (*	  M.Gzowski   2/25/86    added VCCOp and GNDOp		     *)
    (*                                                               *)
    (*  COMMENTS  :  a term may be built only after the OpStack has  *)
    (*		     been reduce.  This signifies that the last term *)
    (*		     has been completed.  However, a reduction	     *)
    (*		     on an AND op means that the term is still	     *)
    (*		     being built.				     *)
    (*                                                               *)
    (*  INPUT PARAMETERS :                                           *)
    (*    VARIABLE    TYPE       DESCRIPTION                         *)
    (*    ----------- ---------- ------------------------------------*)
    (*    							     *)
    (* MEG 1/16/86 *)
    function eqtermbuilt : boolean;
      var
	temp : stacktype;

      (* MEG 1/17/86 *)
      begin (* EqTermBuilt *)
        with traversal
         do begin
 
      (* only build after a stack reduction *)
           if opstack.reduce < 0
            then begin

      (* now, key off the top of the Opstack *)
              if not( empty(opstack) )
               then begin
                 temp := top(opstack);
                 case temp.op of
                   xorop,
                   orop:	eqtermbuilt := true;
                   andop: 	eqtermbuilt := false;
      (* MEG 2/25/86 *)
                   vccop,
		   gndop:       begin
   			         eqtermbuilt := false;
                                 zglobalerr ( illegalvccorgnd, tempeq.devpin );
				end;
                   doneop,
                   idop,
                   noop:	begin 
   			         eqtermbuilt := false;
			         zglobalerr ( ddcbadoponstack, nili );
				end;
                  end; (*case...of*)
                end (*if...then*)

      (* the OpStack is empty, make sure we're at the equation end *)
               else if currentop = doneop 
                then begin 
                  eqtermbuilt := true 
                 end (*else if...then*)
         
      (* error state, an empty stack and we're not done *)
               else begin
                 eqtermbuilt := false;
                 zglobalerr ( ddcemptystack, nili );
                end; (*else*)
             end (*else if...then*)

      (* the stack has not been reduced *)
           else eqtermbuilt := false;

          end; (*with...do*)

      end;  (*EqTermBuilt*)

    (**)
    (*                                                               *)
    (*222222222222222222222222222222222222222222222222222222222222222*)
    (*                                                               *)
    (*  PROCEDURE : AddCurrentOpToTerm				     *)
    (*  AUTHOR    : M.Gzowski					     *)
    (*  DATE      : 12/20/85                                         *)
    (*  FUNCTION  : this procedure puts CurrentOp into TempEqTerm or *)
    (*		    flag an error if the Op is illegal.		     *)
    (*                                                               *)
    (*  MODIFICATIONS :                                              *)
    (*    NAME        DATE       DESCRIPTION                         *)
    (*    ----------- ---------- ------------------------------------*)  
    (*    M.Gzowski   12/20/85   Initial release		     *)
    (*    M. Gzowski  1/17/86    debug modifications, parameter      *)
    (*				 changed.			     *)
    (*    M. Gzowski  2/3/86     debug fix			     *)
    (*    M. Gzowski  2/25/86    debug fix			     *)
    (*    M. Gzowski  3/24/86    correct complement condition        *) 
    (*                                                               *)
    (*  COMMENTS  : 						     *)
    (*                                                               *)
    (*  INPUT PARAMETERS :                                           *)
    (*    VARIABLE    TYPE       DESCRIPTION                         *)
    (*    ----------- ---------- ------------------------------------*)
    (*                                                               *)
    procedure addcurrentoptoterm;
      var
   	tempidlink : idlink;
        idlist : idlink;
    (* MEG 1/17/86 *)
      begin (*AddCurrentOpToTerm*)
         with traversal do
  if currentop in [idop,doneop,noop,xorop,orop,andop,  
                   vccop,gndop] then begin  
           case currentop of
           xorop:  begin
                     tempeq.xornode := true;
                     tempeq.left := true;
                    end;
           orop:   tempeq.ornode := true;
           andop:  tempeq.andnode := true;
    (* MEG 2/25/86 *)
	   vccop,
	   gndop:  begin
                     if currentop = gndop
                       then tempeq.gndnode := true
                       else tempeq.vccnode := true;
		     tempeq.idcount := succ(tempeq.idcount);
                     if tempeq.idcount > 1
                       then zglobalerr ( illegalvccorgnd, tempeq.devpin );
                    end;
    (* MEG 2/3/86 *)
    (* MEG 3/24/86 *)
           idop:   begin
		     tempeq.idlist := newidlink( polaradjust(currentvalue),
                                                 tempeq.idlist );
		     tempeq.idcount := succ(tempeq.idcount);
		    end;
           doneop,
           noop:   begin end;
          end; (*case...of*)
      end else zglobalerr ( ddcbadopinequation, tempeq.devpin ); 
      end;  (*AddCurrentOpToTerm*)

    (**)
    (*                                                               *)
    (*222222222222222222222222222222222222222222222222222222222222222*)
    (*                                                               *)
    (*  PROCEDURE : TestForEqDone				     *)
    (*  AUTHOR    : M.Gzowski					     *)
    (*  DATE      : 2/4/86					     *)
    (*  FUNCTION  : test for completion of the last equation term,   *)
    (*   	    set flag if done.  				     *)
    (*                                                               *)
    (*  MODIFICATIONS :                                              *)
    (*    NAME        DATE       DESCRIPTION                         *)
    (*    ----------- ---------- ------------------------------------*)  
    (*                                                               *)
    (*  COMMENTS  : 						     *)
    (*                                                               *)
    (*  INPUT PARAMETERS :                                           *)
    (*    VARIABLE    TYPE       DESCRIPTION                         *)
    (*    ----------- ---------- ------------------------------------*)
    (*                                                               *)
    procedure testforeqdone ;

      begin (*TestForEqDone*)
        with traversal
         do begin
           if currentop = doneop
            then tempeq.done := true;
          end; (*with...do*)
      end;  (*TestForEqDone*)

    (**)
    (*                                                               *)
    (*222222222222222222222222222222222222222222222222222222222222222*)
    (*                                                               *)
    (*  PROCEDURE : StartNewTerm				     *)
    (*  AUTHOR    : M.Gzowski					     *)
    (*  DATE      : 12/20/85                                         *)
    (*  FUNCTION  : this procedure sets the TempEqTerm back to a     *)
    (*		    pre-built term state.			     *)
    (*                                                               *)
    (*  MODIFICATIONS :                                              *)
    (*    NAME        DATE       DESCRIPTION                         *)
    (*    ----------- ---------- ------------------------------------*)  
    (*    M.Gzowski   12/20/85   Initial release		     *)
    (*    M.Gzowski   1/17/86    debug modifications 		     *)
    (*                                                               *)
    (*  COMMENTS  : 						     *)
    (*                                                               *)
    (*  INPUT PARAMETERS :                                           *)
    (*    VARIABLE    TYPE       DESCRIPTION                         *)
    (*    ----------- ---------- ------------------------------------*)
    (*                                                               *)
    procedure startnewterm;
     var
	temp : stacktype;
        idlist : idlink;

      begin (*StartNewTerm*)

        with traversal.tempeq
         do begin
(* clear the AND, get rid of the Minterms *)
           andnode := false;
           idcount := 0;
           idlist := nil;
    
(* check if we're on the right leg of the XOR (if there is an XOR) *)
           if not empty(traversal.opstack)
             then temp := top(traversal.opstack)
             else begin
               temp.op := noop;
               temp.pntr := nil;
              end;
           if temp.op = xorop
           then begin
              left := false;
              ornode := false;
             end;
          end; (*with...do*)
        
      end;  (*StartNewTerm*)

  (**)
  (*11111111111111111111111111111111111111111111111111111111111111111*)
  (*--------------------- Main flow of GetEqTerm --------------------*) 

  (* MEG 1/17/86 *)
  (* MEG 2/4/86 *)
  begin  (*GetEqTerm*)

  (* build the term, a node at a time *)
    repeat
      gettrenode(traversal);

  (* see if the term is done, if so start a new one *)
       if eqtermbuilt 
        then begin
          testforeqdone;
          returneqterm := traversal.tempeq;
          startnewterm;
         end; (*if...then*)

       addcurrentoptoterm;
    until (eqtermbuilt or zglobalerror);

    if zglobalerror 
     then zglobalerr ( ddcfailgeteqterm, traversal.tempeq.devpin );
  
   end;   (*GetEqTerm*)
(**)
(*1111111111111111111111111111111111111111111111111111111111111111111*)
(*                                                                   *)
(*  PROCEDURE : CompressTerm                                         *)
(*  AUTHOR    : Chie-Jiun Chien                                      *)
(*  DATE      : 12/21/85                                             *)
(*  Function  : To do the bit mapping for each complete ID term      *)
(*  MODIFICATIONS :                                                  *)
(*    NAME        DATE       DESCRIPTION                             *)
(*    ----------- ---------- ------------------------------------    *)
(*    C.J.        12//85   Initial release                           *)
(*                                                                   *)
(*                                                                   *)
(*  COMMENTS  :                                                      *)
(*                                                                   *)
(*  NOTES     :                                                      *)
(*                                                                   *)
(*  INPUT PARAMETERS:                                                *)
(*  VARIABLE      TYPE        DESCRIPTION                            *)
(*  -------------------------------------------------------------    *)
(*  PINNO         INT_X4                                             *)
(*  EQTERM        TERMREC                                            *)
(*1111111111111111111111111111111111111111111111111111111111111111111*)
procedure compressterm(pinno : intXx4; eqterm: termrec);
begin

      (* DO IT LATER *)
end;
(**)
(*1111111111111111111111111111111111111111111111111111111111111111111*)
(*                                                                   *)
(*  PROCEDURE : ResetDataCompress                                    *)
(*  AUTHOR    : Chie-Jiun Chien                                      *)
(*  DATE      : 12/21/85 					     *)
(*  FUNCTION  : Initialize variables for data compression	     *)
(*                                                                   *)
(*  MODIFICATIONS :                                                  *)
(*    NAME        DATE       DESCRIPTION                             *)
(*    ----------- ---------- ------------------------------------    *)
(*    C.J.        12/21/85   Initial release                         *)
(*    M. Gzowski  2/18/86    made routine global 		     *)
(*                                                                   *)
(*  COMMENTS  :                                                      *)
(*                                                                   *)
(*  NOTES     :                                                      *)
(*                                                                   *)
(*  INPUT PARAMETERS:                                                *)
(*1111111111111111111111111111111111111111111111111111111111111111111*)
(* MEG 2/18/86 *)
{vax [global] vax} 
procedure resetdatacompress;
begin
     (* DO IT LATER *)
end;
(**)
(*1111111111111111111111111111111111111111111111111111111111111111111*)
(*                                                                   *)
(*    PROCEDURE  : ForceRoute_and_CompressData                       *)
(*    AUTHOR     : C.J.                                              *)
(*    DATE       : 12/23/85                                          *)
(*    FUNCTION   : It is a control routine to read in the equation   *)
(*                 and try to force route and compress data          *) 
(*                                                                   *)
(*    NAME        DATE       DESCRIPTION                             *)
(*    ----------- ---------- ------------------------------------    *)
(*    C.J.        12/23/85   Initial release                         *)
(*    M.Gzowski   1/17/86    debug changes, made procedure local.    *)
(*    M.Gzowski   1/28/86    check for no equations		     *)
(*    M.Gzowski   2/3/86     changes for subrotuines.		     *)
(*    M.Gzowski   2/12/86    made global variables local	     *)
(*    M.Gzowski   2/18/86    debug fixes for tristate		     *)
(*    M.Gzowski   2/28/86    do Max product term check		     *)
(*    M.Gzowski   5/20/86    added check for global error	     *)
(*    CJ          9/22/86    modify to cover all tristate case       *)
(*                                                                   *)
(*                                                                   *)
(*  COMMENTS  :                                                      *)
(*                                                                   *)
(*  NOTES     :                                                      *)
(*                                                                   *)
(*  INPUT PARAMETERS:                                                *)
(*  --------------------------------------------------------------   *)
(*  DEVICEPIN    INT_X4                                              *)
(*                                                                   *)
(*1111111111111111111111111111111111111111111111111111111111111111111*)

(* MEG 1/17/86 *)
procedure forcerouteXandXcompressdata(devicepin:intXx4);

var 	eqterm : termrec;
(* MEG 2/12/86 *)
        pinequation		: traverserec;
(* MEG 2/18/86 *)
	trsteqproc		: boolean;
(* MEG 2/28/86 *)
        noprodterms             : intXx4;
  (**)
  (*22222222222222222222222222222222222222222222222222222222222222222*)
  (*                                                                 *)
  (*  PROCEDURE : InTriStatRng                                       *)
  (*  AUTHOR    : C.J.                                               *)
  (*  DATE      : 12/19                                              *)
  (*  FUNCTION  : To check if the global variable FR_Index is in the *)
  (*              Tristate Range of a specific pin                   *)
  (*                                                                 *)
  (*  MODIFICATIONS :                                                *)
  (*    NAME        DATE       DESCRIPTION                           *)
  (*    ----------- ---------- ------------------------------------  *)
  (*    C.J.        12/19      initial release                       *)  
  (*    M. Gzowski  2/3/86     debug fix			     *)
  (*    M. Gzowski  2/18/86    moved code to new location	     *)
  (*    M. Gzowski  2/26/86    Adjusted FR_Index		     *)
  (*    M. Gzowski  3/4/86     fixed bug # 746			     *)
  (*                                                                 *)
  (*                                                                 *)
  (*  INPUT PARAMETERS :                                             *)
  (*                                                                 *)
  (*    VARIABLE    TYPE       DESCRIPTION                           *)
  (*    ----------- ---------- ------------------------------------  *)
  (*								     *)
  (*22222222222222222222222222222222222222222222222222222222222222222*)
  (* MEG 2/18/85 *)
  function intristatrng : boolean;
  var srange : range;
  begin (* InTristatRng *)

  (* MEG 3/4/86 bug #746 *)
  (* check for any ranges *)
   if devpins[devicepin].levelrange = nil
     then begin
          intristatrng := false;
          zglobalerr(frrangedne,devicepin);
          end (* if... then ... *)
      else begin

  (* set the range and do the allignment to the current line *)
    srange.low := devpins[devicepin].levelrange^[tristassoc].low;
    srange.high := devpins[devicepin].levelrange^[tristassoc].high;

  (* check if the index is in the range or not *)
  (* MEG 2/26/86 *)
    if (frXindex <= srange.high) 
     and (frXindex >= srange.low)
     and not trsteqproc
     then
       intristatrng := true
     else
       intristatrng := false
   end (* else *)
  end; (*InTristatRng *)
  (**)
  (*22222222222222222222222222222222222222222222222222222222222222222*)
  (*								     *)
  (*  PROCEDURE : ProcTristate					     *)
  (*  AUTHOR    : Chie-Jiun Chien				     *)
  (*  DATE      : 12/21/85					     *)
  (*  FUNCTION  : To process tristate. A complete tristate term      *)
  (*		  will be passed in and check if there is wrong      *)
  (*		  operator inside before putting into array.	     *) 
  (*								     *)
  (*  MODIFICATIONS :						     *)
  (*    NAME        DATE       DESCRIPTION			     *)
  (*    ----------- ---------- ------------------------------------  *)
  (*    C.J.        12/21/85   Initial release			     *)
  (*    M.Gzowski   1/17/86    Made procedure local.		     *)
  (*    M.Gzowski   2/12/86    moved to nested procedure under 	     *)
  (*			       ForceRoute_and_CompressData. Major    *)
  (*			       code modifications.		     *)
  (*    M.Gzowski   2/25/86    handle VCC and GND cases		     *)
  (*    M.Gzowski   3/18/86    allow for forced routing of VCC and   *)
  (* 			       GND.				     *)
  (*    CJ          9/18/86    modify the default case for tristate  *)
  (*    CJ          9/19/86    add pin 13 enable tristate case       *)
  (*								     *)
  (*  COMMENTS  :					 	     *)
  (*								     *)
  (*  INPUT PARAMETERS:						     *)
  (*  VARIABLE       TYPE      DESCRIPTION			     *)
  (*  ------------   --------- ------------------------------------- *)
  (*								     *)
  (*22222222222222222222222222222222222222222222222222222222222222222*)
  (* MEG 1/17/86 *)
  (* MEG 2/12/86 *)
  procedure proctristate;

  var	trstequation		: traverserec;
	trstterm		: termrec;

  begin  (* ProcTristate *)

  (* check if there exists a tristate equation for this term *)
    if devpins[devicepin].tristate <> nil
     then begin

  (* set up the traversal record *)
       reseteqterm ( devicepin, trstXeq, trstequation );
       geteqterm ( trstequation, trstterm );

       with trstterm
        do begin

  (* apply tristate term restrictions *)
          if trstnode and 
           (not xornode) and 
           (not ornode) and
           (done) 

  (* this is a good tristate term *)
           then begin

  (* check that then node is to be fitted *)
  (* MEG 2/25/86 *)
             if (not vccnode) and
              (not gndnode)
              then begin
  (* force route the term *)
                fitterm ( trstterm );
  (* put the data into compressed format, and get rid of the TRE structures *)
                compressterm ( devicepin, trstterm );
                retireidlist ( trstterm.idlist );
               end (*if...then*)

  (* MEG 2/25/86 *)
  (* MEG 3/18/86 *)
  (* this equation is equivalenced to GND or VCC *)
              else begin
                if idcount <> 1
	         then begin
                   zglobalerr ( illegalvccorgnd, devicepin );
                   zglobalerr ( combadtriequation, devicepin );
                  end; (*if...then*)

  (* make the appropriate connnections for this case *)
                if vccnode
                 then fittricondition ( devicepin, vcccase )
                 else fittricondition ( devicepin, gndcase );
               end (*else*)
            end (*if...then*)

  (* this is a bad tristate term, flag it as such *)
           else
             zglobalerr ( combadtriequation, devicepin );
         end; (*with...do*)
      end (*if...then*)

  (* there is no tristate equation for this term, *)
  (* treat with the default case.                 *)
     else begin
       if  ( devpins[devicepin].equatn = nil )
         then fittricondition(devicepin,gndcase)
(* 9/19/86 CJ *)
         else if not devpins[devicepin].registered
                then fittricondition ( devicepin, vcccase )
                else fittricondition ( devicepin, enblcase);
      end; (*else*)

  (* set up the traversal record *)
       reseteqterm ( devicepin, trstXeq, trstequation );

    trsteqproc := true;
    
  end; (* ProcTristate *)            


(**)
(*1111111111111111111111111111111111111111111111111111111111111111111*)
(* ------------ Main flow of ForceRoute_and_CompressData ----------- *)
begin (* FORCEROUTE_AND_COMPRESSDATA *)

(* MEG 1/28/86 *)
(* MEG 2/12/86 *)
(* MEG 2/18/86 *)
  trsteqproc := false;
(* first check for an equation at all *)
  if devpins[devicepin].equatn <> nil
   then begin
     
(* set initial values to Equation Term and get a complete term  *)
     reseteqterm ( devicepin, pinXeq, pinequation );
     eqterm := pinequation.tempeq;
(* MEG 2/28/86 *)
     noprodterms := initprodtermcount;

(* if not EqTerm done or force routing finished, do check tristate first *)
(* then try to fit term into array and do compression                    *)
     while ( not eqterm.done ) and ( not zglobalerror )
      do begin
(* MEG 2/28/86 *)
        if noprodterms >= maxprodtermcount
          then begin
            zglobalerr ( mustpassxplot, nili );
            zglobalerr ( maxprodtermallowed, maxprodtermcount );
            zglobalerr ( exceedmaxprodterms, devicepin );
           end
          else
           noprodterms := succ ( noprodterms );
        geteqterm( pinequation, eqterm );
        if intristatrng
          then proctristate;
        if ( not forceXrouteXfailure ) 
          then fitterm ( eqterm );
        compressterm ( devicepin, eqterm );
        retireidlist ( eqterm.idlist );
       end; (*while...do*)

(* MEG 5/20/86 *)
(* MEG 2/18/86 *)
(* process the Tristate equation if it is not processed yet. *)
     if not trsteqproc and not zglobalerror
      then proctristate;

    end (*if...then*)

(* MEG 1/28/86 *)
(* next check for tristate only *)
  else   
(* CJ 9/22/86 *)  
       proctristate;

end; (* end of routine *)
       
(**)
(*1111111111111111111111111111111111111111111111111111111111111111111*)
(*                                                                   *)
(*  PROCEDURE : LinkDevPinData                                       *)
(*  AUTHOR    : Chie-Jiun Chien                                      *)
(*  DATE      : 12/23/85                                             *)
(*  FUNCTION  : To fill in field information to the DevPinData record*)
(*                                                                   *)
(*  MODIFICATIONS :                                                  *)
(*    NAME        DATE       DESCRIPTION                             *)
(*    ----------- ---------- ------------------------------------    *)
(*    C.J.        12/23/85   Initial release                         *)
(*    M.Gzowski   1/28/86    Debug fix				     *)
(*    M.Gzowski   3/6/86     flag illegal (unsupported) equations    *)
(*                                                                   *)
(*                                                                   *)
(*  COMMENTS  :                                                      *)
(*                                                                   *)
(*  NOTES     :                                                      *)
(*  INPUT PARAMETERS:                                                *)
(*  -------------------------------------------------------------    *)
(*  VARIABLE      TYPE       DESCRIPTION                             *)
(*  EqTree        TreLink    Equation Tree                           *)
(*  Reg           Boolean    Register or not                         *)
(*  Comp          Boolean    Complement or not                       *)
(*  Class         EquationType if it is a normal equaiton or clk or..*)
(*  PinData       DevPinData                                         *)
(*  DevicePin     int_X4     the device pin			     *)
(*1111111111111111111111111111111111111111111111111111111111111111111*)
(* MEG 1/28/86 *)
procedure linkdevpindata (    eqtree	: trelink;
                              reg	: boolean;
                              comp	: boolean;
                              class	: equationtype;
                          var pindata	: devpindata;
			      devicepin	: intXx4 );

begin  (* Begin of LinkDevPinData *)
      pindata.registered := reg;
      pindata.complemented := comp;

 (* MEG 3/6/86 *)
 (* handle the equation by class *)
  if class in [pinXeq,trstXeq] then begin  
      case class of

         pinXeq:
                 pindata.equatn := eqtree;

         trstXeq:
                 begin
                   pindata.triflag := true;
                   pindata.tristate := eqtree;
                  end;

 (* the equation type is not supported *)

       end; (*case*)
   end else zglobalerr ( frrangedne, devicepin );  


end;    (* end of LinkDevPinData *)      
                         
(**)
(*1111111111111111111111111111111111111111111111111111111111111111111*)
(*                                                                   *)
(*  PROCEDURE : CompressDesignData                                   *)
(*  AUTHOR    : Chie-Jiun Chien                                      *)
(*  DATE      : 12/21/85                                             *)
(*  FUNCTION  : Initiallly, this procedure sorts the main array by   *)
(*              Device Pin Association, determining association level*)
(*              row ranges. Next, the TRE file is open and read.     *)
(*              After all eqatuions are read from the .TRE file, each*)
(*              tree structure containing an eqauation is processed  *)
(*              for (1) storage into a bit mapped (compressed)       *)
(*              representation, and (2) forced routing into the      *)
(*              device architectural structure. The storage space is *)
(*              then returned to the system                          *)
(*                                                                   *)
(*  MODIFICATIONS :                                                  *)
(*    NAME        DATE       DESCRIPTION                             *)
(*    ----------- ---------- ------------------------------------    *)
(*    C.J.        12/21/85   Initial release                         *)
(*    M. Gzowski  1/10/86    Added error check                       *)
(*    M. Gzowski  3/24/86    added pin usage stuff		     *)
(*    M. Gzowski  4/16/86    added test for global error	     *)
(*    M. Gzowski  10/10/86   fixed bug #1007			     *) {!! 2 !!}
(*                                                                   *)
(*                                                                   *)
(*  COMMENTS  :                                                      *)
(*                                                                   *)
(*  NOTES     :                                                      *)
(*  INPUT PARAMETERS:                                                *)
(*  VARIABLE      TYPE        DESCRIPTION                            *)
(*  -------------------------------------------------------------    *)
(*1111111111111111111111111111111111111111111111111111111111111111111*)

{vax    [Global] vax}    
procedure compressdesigndata;

(* MEG 1/19/86 *)
label
(* error bailout *)
	999;

var
    pinno : intXx4;
    equationXtree : trelink; 
    reg,comp  : boolean;
    class : equationtype;
    rightequ : trelink;
  

(**)
    (*                                                               *)
    (*222222222222222222222222222222222222222222222222222222222222222*)
    (*                                                               *)
    (*  PROCEDURE : ReadTREFile					     *)
    (*  AUTHOR    : M. Gzowski					     *)
    (*  DATE      : 1/15/86                                          *)
    (*  FUNCTION  : make all calls neccessary to the TRE file access *)
    (*		    module to get and save the equations.	     *)
    (*								     *)
    (*  MODIFICATIONS :                                              *)
    (*    NAME        DATE       DESCRIPTION                         *)
    (*    ----------- ---------- ------------------------------------*)  
    (*    M.Gzowski   1/15/86    Initial release of restructured code*)
    (*    M.Gzowski   3/4/86     fix for bug # 747		     *)
    (*    M.Gzowski   3/6/86     modify routine call		     *)
    (*    M.Gzowski   3/24/86    added debug fixes.		     *)
    (*                                                               *)
    (*  COMMENTS  :  						     *)
    (*                                                               *)
    (*  INPUT PARAMETERS :                                           *)
    (*    VARIABLE    TYPE       DESCRIPTION                         *)
    (*    ----------- ---------- ------------------------------------*)
    (*    UsageList   PoolRec    list of pins used         	     *)
    (*                                                               *)
    (* MEG 3/4/86 Bug # 747 *)
    (* MEG 3/24/86 *)
    procedure readtrefile ( var usagelist : poolrec);

    (**)
      (*                                                             *)
      (*3333333333333333333333333333333333333333333333333333333333333*)
      (*                                                             *)
      (*  PROCEDURE : GetPinPolarity				     *)
      (*  AUTHOR    : M. Gzowski				     *)
      (*  DATE      : 3/24/86                                        *)
      (*  FUNCTION  : find the polarity of each pin as declared in   *)
      (*	      pin list.  Set the correct DeclrdComplmnt Flag.*)
      (*							     *)
      (*  MODIFICATIONS :                                            *)
      (*    NAME        DATE       DESCRIPTION                       *)
      (*    ----------- ---------- ----------------------------------*)  
      (*                                                             *)
      (*  COMMENTS  :  						     *)
      (*                                                             *)
      (*  INPUT PARAMETERS :                                         *)
      (*    VARIABLE    TYPE       DESCRIPTION                       *)
      (*    ----------- ---------- ----------------------------------*)
      (*                                                             *)
      procedure getpinpolarity;

        var i : intXx4;

        begin (*GetPinPolarity*)
          for i := mindevicepin to trepincount
           do if trepinlist[i][0] = complementXchar
               then devpins[i].declaredcomplement := true
               else devpins[i].declaredcomplement := false;
        end;  (*GetPinPolarity*)

    (**)
      (*3333333333333333333333333333333333333333333333333333333333333*)
      (*                                                             *)
      (*  PROCEDURE : FindPinUsage				     *)
      (*  AUTHOR    : M. Gzowski				     *)
      (*  DATE      : 3/24/86                                        *)
      (*  FUNCTION  : determine which pin were referenced in the     *)
      (*	      equations.				     *)
      (*							     *)
      (*  MODIFICATIONS :                                            *)
      (*    NAME        DATE       DESCRIPTION                       *)
      (*    ----------- ---------- ----------------------------------*)  
      (*                                                             *)
      (*  COMMENTS  :  						     *)
      (*                                                             *)
      (*  INPUT PARAMETERS :                                         *)
      (*    VARIABLE    TYPE       DESCRIPTION                       *)
      (*    ----------- ---------- ----------------------------------*)
      (*    UsageList   PoolRec    the pin usage table               *)
      (*                                                             *)
      procedure findpinusage ( var usagelist : poolrec );

        var
		i 	: intXx4;
		treloc 	: trelink;

     (**)
        (*44444444444444444444444444444444444444444444444444444444444*)
        (*                                                           *)
        (*  PROCEDURE : ExtractIDs				     *)
        (*  AUTHOR    : M. Gzowski				     *)
        (*  DATE      : 3/24/86                                      *)
        (*  FUNCTION  : get all the IDs used in the structure 	     *)
        (*              referenced by a TreLink.		     *)
        (*							     *)
        (*  MODIFICATIONS :                                          *)
        (*    NAME        DATE       DESCRIPTION                     *)
        (*    ----------- ---------- --------------------------------*)  
        (*     MEG        3/25/86    initial release                 *)
        (*     CJ         3/26/86    debug                           *)
        (*                                                           *)
        (*  COMMENTS  :  					     *)
        (*                                                           *)
        (*  INPUT PARAMETERS :                                       *)
        (*    VARIABLE    TYPE       DESCRIPTION                     *)
        (*    ----------- ---------- --------------------------------*)
        (*    EqPtr       TreLink    the pointer to the equation     *)
        (*                            fragment to be processed       *)
        (*    UsageList   PoolRec    the (current) list of pins used *)
        (*                                                           *)
        procedure extractids (     eqptr 	 : trelink;
                               var usagelist 	 : poolrec ) ;

          var
		goingXdown : boolean;
                listindex  : intXx4;
	     (* ListIndex  : PoolRecRng;*)


        (**)
          (*555555555555555555555555555555555555555555555555555555555*)
          (*                                                         *)
          (*  PROCEDURE : GoRight				     *)
          (*  AUTHOR    : M. Gzowski				     *)
          (*  DATE      : 3/24/86                                    *)
          (*  FUNCTION  : make a right tre transition, if possible.  *)
          (*		  Otherwise, go up.			     *)
          (*	      						     *)
          (*							     *)
          (*  MODIFICATIONS :                                        *)
          (*    NAME        DATE       DESCRIPTION                   *)
          (*    ----------- ---------- ------------------------------*)  
          (*                                                         *)
          (*  COMMENTS  :  					     *)
          (*                                                         *)
          (*  INPUT PARAMETERS :                                     *)
          (*    VARIABLE    TYPE       DESCRIPTION                   *)
          (*    ----------- ---------- ------------------------------*)
          (*    EqPtr       TreLink    current tre node pointer      *)
          (*                                                         *)
          procedure goright ( var eqptr : trelink );

            begin (*GoRight*)
              with eqptr^
               do if treXright = nil
                then begin
                  goingXdown := false;
                  eqptr := treXup;
                 end (*if...then*)
                else begin
                  eqptr := treXright;
                  goingXdown := true;
                 end; (*else*)
             end; (*GoRight*)


        (**)
          (*555555555555555555555555555555555555555555555555555555555*)
          (*                                                         *)
          (*  PROCEDURE : GoDown				     *)
          (*  AUTHOR    : M. Gzowski				     *)
          (*  DATE      : 3/24/86                                    *)
          (*  FUNCTION  : make a down tre transition, if possible.   *)
          (*		  Otherwise, go right.			     *)
          (*	      						     *)
          (*							     *)
          (*  MODIFICATIONS :                                        *)
          (*    NAME        DATE       DESCRIPTION                   *)
          (*    ----------- ---------- ------------------------------*)  
          (*                                                         *)
          (*  COMMENTS  :  					     *)
          (*                                                         *)
          (*  INPUT PARAMETERS :                                     *)
          (*    VARIABLE    TYPE       DESCRIPTION                   *)
          (*    ----------- ---------- ------------------------------*)
          (*    EqPtr       TreLink    current tre node pointer      *)
          (*                                                         *)
          procedure godown ( var eqptr : trelink );

            begin (*GoDown*)
              with eqptr^
               do if ( treXdown = nil )
                then goright (eqptr)
                else begin
                  eqptr := treXdown;
                  goingXdown := true;
                 end; (*else*)
             end; (*GoDown*)


      (**)
        (*44444444444444444444444444444444444444444444444444444444444*)
        (* ---------------- Main flow of ExtractIDs ---------------- *)
          begin (*ExtractIDs*)

          (* first see if there is anything to extract *)
            if eqptr <> nil
             then begin
               goingXdown :=true;

          (* keep extracting until the tree has been traversed *)
          (* CJ modification *)
               repeat
                 with eqptr^
                  do begin

          (* for vanilla ID node, get the ID value...             *)
          (* ...ID nodes have no children, try to go to the right *)
                    if treXkind = tkXid then   
                        begin
                          usagelist[polaradjust( treXvalue )] := true;
(* MEG 9/25/86 *)
                          usagelist[-polaradjust( treXvalue )] := true;
                          goright (eqptr);

          (* for NOT node, get the -(ID value) for the referenced ID node*)
          (* ...since we have the child's value, try to go to the right *)
                    end else if treXkind = tkXnot then  
                        begin
                          usagelist[polaradjust( -treXdown^.treXvalue)]:=true; 
(* MEG 10/10/86 *) {!! 2 !!}
                          usagelist[-polaradjust( -treXdown^.treXvalue)]:=true; {!!3!!}
                          goright (eqptr);

          (* for any other node (the node has value = 0), keep traversing... *)
          (* ...go down, unless we've just been there.			     *)
                    end else  
                        begin
                          if goingXdown

          (* if moving downward, continue... *)
                           then godown (eqptr)

          (* ...if moving upward, try to go the right first *)
                           else goright (eqptr);
                        end; (*begin*)

                   end; (*with...do*)
                until ( eqptr^.treXup = nil ) and not goingXdown;
              end; (*if...then*)
          end;  (*ExtractIDs*)

    (**)
      (*3333333333333333333333333333333333333333333333333333333333333*)
      (* ---------------- Main flow of FindPinUsage ---------------- *)
        begin (*FindPinUsage*)
(* CJ modification to move all the initialization to inittables *)

        (* get the usage *)
          for i := mindevicepin to trepincount
           do with devpins[i]
            do begin
                extractids ( equatn, usagelist );
                extractids ( tristate, usagelist );
             end; (*with...do*)

        end;  (*FindPinUsage*)

    (**)
    (*222222222222222222222222222222222222222222222222222222222222222*)
    (* ------------------ Main flow of ReadTREFile ----------------- *)
      begin (*ReadTREFile*)

      (* MEG 3/24/86 *)
        getpinpolarity;

        equationXtree := readequation;

        while ( treretcode = treXok ) and
         ( not zglobalerror )
         do begin
           pinno := equationpin(equationXtree,reg,comp,class,rightequ);

           if ( pinno >= mindevicepin ) and 
            ( pinno <= maxdevicepin )
            then begin
              pinused[pinno] := true;
      (* MEG 3/6/86 *)
              linkdevpindata(rightequ,reg,comp,class,devpins[pinno],pinno); 
              equationXtree := readequation;
             end (*if...then*)
            else
             zglobalerr ( illegalpin, pinno );
          end; (* end of while *)

      (* Check the status after reading TRE module *)
        case treretcode of
          treXok,
          treXeos  : begin end;
          treXerr  : zglobalerr ( trelogicequationreaderror, nili );
          treXnomem: zglobalerr ( trenomemory, nili );
         end; (* end of case *)

      (* MEG 3/24/86 *)
        findpinusage (usagelist);

      end;  (*ReadTREFile*)

(**)
    (*                                                               *)
    (*222222222222222222222222222222222222222222222222222222222222222*)
    (*                                                               *)
    (*  PROCEDURE : TristateRangeExists				     *)
    (*  AUTHOR    : M. Gzowski					     *)
    (*  DATE      : 9/25/86                                          *)
    (*  FUNCTION  : return boolean TRUE if there is a tristate range *)
    (*		    for the passed pin number.			     *)
    (*								     *)
    (*  MODIFICATIONS :                                              *)
    (*    NAME        DATE       DESCRIPTION                         *)
    (*    ----------- ---------- ------------------------------------*)  
    (*                                                               *)
    (*  COMMENTS  :  						     *)
    (*                                                               *)
    (*  INPUT PARAMETERS :                                           *)
    (*    VARIABLE    TYPE       DESCRIPTION                         *)
    (*    ----------- ---------- ------------------------------------*)
    (*    PinNo		int_X4	 a device pin number		     *)
    (*                                                               *)
    function tristaterangeexists( pinno : intXx4 ) : boolean;
      var
        testhigh, testlow	: intXx4;

      begin

    (* first, check for a range pointer *)
        if devpins[pinno].levelrange <> nil
         then begin

    (* now check if a tristate range exists *)
           testlow := devpins[pinno].levelrange^[tristassoc].low;
           testhigh := devpins[pinno].levelrange^[tristassoc].high;
           if (testlow = minpinassno)
            and (testhigh = minpinassno)

     (* empty range *)
             then tristaterangeexists := false
     (* yes, there is a range *)
             else tristaterangeexists := true;
          end (* if...then *)

     (* no pointer *)
         else
           tristaterangeexists := false;
      end; (*TristateRangeExists*)

(**)
(*1111111111111111111111111111111111111111111111111111111111111111111*)
(*----------------Main Flow of CompressDesignData--------------------*)
begin (*CompressDesignData*)

      initdevpins;
(* MEG 1/16/86 *)
(* get low and high range of each level component for each pin *)
      getrangeforpin;                           

(* CJ 3/26/86 *)
      inittables(maptable,pintable,columntable,pool);      
(* MEG 1/15/86 *)
(* MEG 3/24/86 *)
      readtrefile (pool);
      
(* Get array Column information *)
      readinarraycolumn ( pool, columntable );
{/DBG} (*WriteOutColumn;*)

(* MEG 1/19/86 *)
(* MEG 4/16/86 *)
(* Force routing... *)
       for pinno := maxdevicepin downto mindevicepin 
        do if tristaterangeexists(pinno) and not zglobalerror
         then begin
           forcerouteXandXcompressdata(pinno);
           retiretreXfordevicepin(pinno);
	   if zglobalerror then goto 999;
          end (*if...then*) {!! 2 !!}
(* MEG 10/10/86 bug #1007 *) {!! 2 !!}
         else if (devpins[pinno].equatn<>nil) or (devpins[pinno].tristate<>nil) {!!3!!}
          then zglobalerr (frrangedne, pinno); {!! 2 !!}

(*  clean up equation usage *)
       disposeidlinks;

(* error bailout point *)
(* MEG 1/19/86 *)
999:

(* MEG 2/6/86 *)
(* MEG 4/16/86 *)
(* set the routing flag *)
       routed := (not forceXrouteXfailure) and (not zglobalerror);

(*  Free tree and close tree *)
       freetre;
       closetre;

end; (*CompressDesignData*)

{vax  End. vax} 
