{**  DEC/CMS REPLACEMENT HISTORY, Element Z24MAIN.SRC **}
{**  *1    10-OCT-1986 08:58:32 PALASM2 "" **}
{**  DEC/CMS REPLACEMENT HISTORY, Element Z24MAIN.SRC **}
(*                                                                   *)
(*  (c) copyright Monolithic Memories, Inc. , 1986                   *)
(*                                                                   *)
{vax %include 'pal2$inc:z24global.inc'        vax}
{vax module z24main (input,output);           vax}


#include 'csopeninc.i'
#include 'ctre.i'
#include 'ctxtio.i'
#include 'fnxinc.i'
#include 'z24.i'


{ipp program z24main ;                        ipp}
{ipp pragma On(Externals_allowed_internally); ipp}
{ipp pragma C_include('ctre.inc');            ipp}
{ipp pragma C_include('ctxtio.inc');          ipp}
{ipp pragma C_include('fnxinc.inc');          ipp}
{ipp pragma C_include('z24.inc');             ipp}
 
(*1111111111111111111111111111111111111111111111111111111111111111111*)
(*                                                                   *)
(*  PROGRAM   : Z24Main                                              *)
(*  AUTHOR    : CB Lee                                               *)
(*  DATE      : 6/16/86                                              *)
(*  FUNCTION  : Main program flow.                                   *)
(*                                                                   *)
(*                                                                   *)
(*  MODIFICATIONS :                                                  *)
(*    NAME        DATE       DESCRIPTION                             *)
(*    ----------- ---------- ------------------------------------    *)
(*    M.Gzowski   1/4/86     Module modified into Program.           *)
(*                           Non-essential lines commented out for   *)
(*                           first release.                          *)
(*    M.Gzowski   1/7/86     Changed ReadPDF to Read_PDF.            *)
(*                           Added copyright notice.                 *)
(*    M.Gzowski   1/19/86    Added final call to message handler.    *)
(*    M.Gzowski   1/24/86    Added stat messages.                    *)
(*    R.Steggles  1/27/86    modify for pc port                      *)
(*    M.Gzowski   2/7/86     modify for pc port                      *)
(*    M.Gzowski   2/28/86    moved TRE file access to this module    *)
(*                           improve flow control                    *)
(*    M.Gzowski   4/17/86    fix for bug # 797                       *)
(*    Bala K.     4/22/86    function call support                   *)
(*    M.Gzowski   4/24/86    integrate new PDF file.                 *)
(*    M.Gzowski   5/9/86     integrate function call                 *)
(*    CJ Chien    6/13/86    Added Init_Route_Map procedure          *)
(*    CB Lee      6/16/86    Rewritten for clarity.                  *)
(*    I.Taller    6/19/86    call the InitDeviceType procedure       *)
(*    M.Gzowski   7/8/86     fix for bug # 882, text file name length*)
(*                           correct menu, added physical via option *)
(*    I.Taller    8/14/86    correct menue.			     *)
(*    M.Gzowski   9/5/86     add merge flag to Write_Vias calls	     *)
(*    M.Gzowski   9/17/86    modify menu and option flow. 	     *)
(*                                                                   *)
(*                                                                   *)
(*  COMMENTS  : Main procedure for ZHAL20 and ZHAL24; calls the      *)
(*              following routines:                                  *)
(*                   InitGlobals,                                    *)
(*                   InitDeviceData,                                 *)
(*                   Read_PDF,                                       *)
(*                   GetNumberofRoutingPasses,                       *)
(*                   CompressDesignData,                             *)
(*                   RouteDesign,                                    *)
(*                   MakeBasicRouteReport,                           *)
(*                   ProcessLogicalMap,                              *)
(*                   MakePhysicalMap.                                *)
(*                                                                   *)
(*  NOTES     : This module calls both the standard PASCAL IO        *)
(*              routines, WRITE / WRITELN, and text handler          *)
(*              routines, WrTextLn.                                  *)
(*              These calls represent a potential minor              *)
(*              maintenance/portability problem, and should be       *)
(*              changed to calls to unimplemented and undefined      *)
(*              routines in the ZHAL24 program message handler       *)
(*              module, ZERROR.SRC, when time permits.               *)
(*                              Mike Gzowski 1/27/86                 *)
(*                                                                   *)
(*  EXTERNAL DECLARATIONS :                                          *)
(*                                                                   *)
(*  GLOBAL DECLARATIONS :                                            *)
(*                                                                   *)
(*    VARIABLE           TYPE                                        *)
(*    -----------        ----------                                  *)
(*    FactoryOption      boolean                                     *)
(*    FAEOption          boolean                                     *)
(*    MaxRoutePass       integer                                     *)
(*    Routed             boolean                                     *)
(*    RoutePassCount     integer                                     *)
(*                                                                   *)
 
(*
 *)
  (*22222222222222222222222222222222222222222222222222222222222222222*)
  (*                                                                 *)
  (*  PROCEDURE : OpenTREFile                                        *)
  (*  AUTHOR    : M. Gzowski                                         *)
  (*  DATE      : 2/28/86                                            *)
  (*  FUNCTION  : Opens the TRE file and displays an identifier.     *)
  (*                                                                 *)
  (*  MODIFICATIONS :                                                *)
  (*    NAME        DATE       DESCRIPTION                           *)
  (*    ----------- ---------- ------------------------------------  *)
  (*    M.Gzowski   4/17/86    fix for bug # 797                     *)
  (*    M.Gzowski   4/24/86    integrate new PDF, replace const      *)
  (*                           previously in Z24.INC                 *)
  (*                                                                 *)
  (*  COMMENTS  :                                                    *)
  (*                                                                 *)
  (*  INPUT PARAMETERS :                                             *)
  (*    VARIABLE    TYPE       DESCRIPTION                           *)
  (*    ----------- ---------- ------------------------------------  *)
  (*                                                                 *)
  procedure opentrefile;
 
  (* MEG 4/24/86 *)
    const
        blank = ' ';
 
{dsy    var         dsy}
{dsy        i,j,tail : integer;   dsy}
{dsy        tmp : TreFname;       dsy}

(*
*)
    (*333333333333333333333333333333333333333333333333333333333333333*)
    (*                                                               *)
    (*  PROCEDURE : CnvtTREFnam                                      *)
    (*  AUTHOR    : M. Gzowski                                       *)
    (*  DATE      : 2/28/86                                          *)
    (*  FUNCTION  : Converts string of type TreFnam to a (returned)  *)
    (*              string of type TxtStr.                           *)
    (*                                                               *)
    (*  MODIFICATIONS :                                              *)
    (*    NAME        DATE       DESCRIPTION                         *)
    (*    ----------- ---------- ----------------------------------  *)
    (*                                                               *)
    (*  COMMENTS  :                                                  *)
    (*                                                               *)
    (*  INPUT PARAMETERS :                                           *)
    (*    VARIABLE    TYPE       DESCRIPTION                         *)
    (*    ----------- ---------- ----------------------------------  *)
    (*    InString    TreFname    a string of type TreFnam           *)
    (*                                                               *)
    function cnvttrefnam ( instring : trefname ) : txtstr;
 
      var temp : txtstr;
          i    : integer;
 
      begin
      (* start at the beginning *)
        i := 1;
 
      (* move each character from the old string to the new string *)
        while ( i <= txtXstrlen )
         and ( i <= treXfnamelen )
         do begin
           temp[i] := instring[i];
           i := succ(i);
          end; (*while...do*)
        if i < txtXstrlen
         then for i := i to txtXstrlen
          do temp[i] := blank;
 
        cnvttrefnam := temp;
      end; (*CnvtTREFnam*)
 
(*
*)
    (*333333333333333333333333333333333333333333333333333333333333333*)
    (*                                                               *)
    (*  PROCEDURE : CnvtTreStr                                       *)
    (*  AUTHOR    : M. Gzowski                                       *)
    (*  DATE      : 2/28/86                                          *)
    (*  FUNCTION  : Converts string of type TreStr to a (returned)   *)
    (*              string of type TxtStr.                           *)
    (*                                                               *)
    (*  MODIFICATIONS :                                              *)
    (*    NAME        DATE       DESCRIPTION                         *)
    (*    ----------- ---------- ----------------------------------  *)
    (*                                                               *)
    (*  COMMENTS  :                                                  *)
    (*                                                               *)
    (*  INPUT PARAMETERS :                                           *)
    (*    VARIABLE    TYPE       DESCRIPTION                         *)
    (*    ----------- ---------- ----------------------------------  *)
    (*    InString    TreStr     a string of type TreStr             *)
    (*                                                               *)
 
    function cnvttrestr ( instring : trestr ) : txtstr;
 
      var temp : txtstr;
          i    : integer;
 
      begin
      (* start at the beginning *)
        i := 1;
 
      (* move each character from the old string to the new string *)
        while ( i <= txtXstrlen )
{dsy          and ( i <= TreFileLen )   dsy}
{/dsy}         and ( i <= treXstrlen )
         do begin
           temp[i] := instring[i];
           i := succ(i);
          end; (*while...do*)
        if i < txtXstrlen
         then for i := i to txtXstrlen
          do temp[i] := blank;
 
        cnvttrestr := temp;
      end; (*CnvtTreStr*)
 
 
(*
  *)
    (*333333333333333333333333333333333333333333333333333333333333333*)
    (*                                                               *)
    (*  PROCEDURE : IsTREOK                                          *)
    (*  AUTHOR    : M. Gzowski                                       *)
    (*  DATE      : 4/17/86                                          *)
    (*  FUNCTION  : Tests global variables that are set by OpenTRE,  *)
    (*              if variables indicate potential problems, flag   *)
    (*              an error.                                        *)
    (*                                                               *)
    (*  MODIFICATIONS :                                              *)
    (*    NAME        DATE       DESCRIPTION                         *)
    (*    ----------- ---------- ----------------------------------  *)
    (*                                                               *)
    (*  COMMENTS  :                                                  *)
    (*                                                               *)
    (*  INPUT PARAMETERS :                                           *)
    (*    VARIABLE    TYPE       DESCRIPTION                         *)
    (*    ----------- ---------- ----------------------------------  *)
    (*                                                               *)
 
    procedure istreok;
 
      var temp : txtstr;
          i : integer;
 
      begin
 
      (* test the device pin count *)
        if trepincount > maxdevicepin
         then begin
           zglobalerr( tredeclaredpincount, trepincount );
           zglobalerr( tremaxdevpinexceed, maxdevicepin );
          end; (*if...then*)
  
      end; (* IsTREOK *)
 
 
(*
 *)
  (*22222222222222222222222222222222222222222222222222222222222222222*)
  (* ------------------ main flow of OpenTREFile ------------------  *)
    begin (*OpenTREFile*)
 
    (* Do initialization for the Tre module *)
      inittremod;
 
    (* open the Tre module *)
      opentre;
    (* check for file errors and display name *)
      case treretcode of
        treXerr: zglobalerr(treerrorinopeningtree,dummyvalue);
        treXpropn:zglobalerr(tremodbeenreopened,dummyvalue);
        treXok:
          begin
{/dsy}            wrtextln ( output,
{dsy        WrTextLn ( errfile,          dsy}
                       displaytretitle,
                       cnvttrestr( treheader.treXtitle ),
                       nili );
{dsy        i:= Tre_FnameLen;   dsy}
{dsy        while (TreHeader.Tre_filename[i] = blank) and (i > 0) do   i := i-1;dsy}
{dsy        tail:= i;   dsy}
{dsy        while (TreHeader.Tre_filename[i] <> '/') and (i > 0) do   i := i-1; dsy}
{dsy        if (i>0) then   dsy}
{dsy          begin  dsy}
{dsy            j:= 1;  dsy}
{dsy            for i:=i+1 to tail do  dsy}
{dsy              begin  dsy}
{dsy                tmp[j] := TreHeader.Tre_filename[i];  dsy}
{dsy                j := j+1;  dsy}
{dsy              end;  dsy}
{dsy            if (j < Tre_FnameLen) then  dsy}
{dsy              for j:=j to Tre_FnameLen do  tmp[j] := blank;  dsy}
{dsy          end;  dsy}

{/dsy}      wrtextln ( output,
{dsy        WrTextLn ( errfile,   dsy}
                       displaytrefn,
{dsy                   CnvtTreFnam( tmp ),  dsy}
{/dsy}                 cnvttrefnam( treheader.treXfilename ),
                       nili );
           end;
       end; (*case*)
 
    (* MEG 4/16/86 bug report #797 *)
    (* open the Tre module *)
      istreok;
 
    end;  (*OpenTREFile*)
 
 
(*
 *)
(*                                                                   *)
(*-------------------------------------------------------------------*)
(*                                                                   *)
(*  PROCEDURE : Init_Route_Map                                       *)
(*  AUTHOR    : CJ Chien                                             *)
(*  DATE      : 6/10/86                                              *)
(*  FUNCTION  : To give user different options to choose             *)
(*                                                                   *)
(*  MODIFICATIONS :                                                  *)
(*    NAME        DATE       DESCRIPTION                             *)
(*    ----------- ---------- ------------------------------------    *)
(*    CJ Chien    6/10/86     initial release                        *)
(*    IT          7/1/86      options restriction                    *)
(*    M.Gzowski   7/8/86      add option for physical via list       *)
(*    IT          8/14/86     changing user interface                *)
(*    M.Gzowski   9/5/86      add merge flag to Write_Vias calls     *)
(*                                                                   *)
(*  COMMENTS  :                                                      *)
(*                                                                   *)
(*  INPUT PARAMETERS :                                               *)
(*                                                                   *)
(*    VARIABLE    TYPE       DESCRIPTION                             *)
(*    ----------- ---------- ------------------------------------    *)
(*                                                                   *)
procedure initXrouteXmap;
 





begin
 
(***********************************************)
(* The first part of the route is MMI specific *)
(***********************************************)
 
 
 
(* init  *)

(* check if zhal program was called from zhal.com *)

(*MEG 7/8/86*)
(* write the menu, get the option                *)
(*       eof cause exit (treated as exit option) *)
(* get the mode *)

 
(* check option validity (legality?) *)

 
(* ... compress data & force route *)
(*MEG 7/8/86*)
(* Writing the physical via file *)
(* MEG 9/5/86 *)
 
(* reading the via map file *)
(* Writing the physical via file *)
(* MEG 9/5/86 *)
(* MEG 9/17/86 *)
(* for option 1, template merge flag is set, option 2 indicates no merge *)
 

(* output or not output the via map file ? *)
(* write the menu, get the option                *)
(*       eof cause exit (treated as exit option) *)
(* get the mode option *)

 
(* check option validity (legality?) *)

(* do nothing *)

(* Writing the via map file *)
 
 
(*****************************************************)
(* The second part of the route is non- MMI specific *)
(*****************************************************)
 
 
(* ... initialize PDF data *)
{/MMI}      (* WrTextLn(output,InitializingDevData,Nils,NilI); *)
{/MMI}      (* InitDeviceData; *)
(* ... compress data & force route *)
{/MMI} {/dsy}   wrtextln(output,comprforcrout,nils,nili);
{dsy            WrTextLn(errfile,ComprForcRout,Nils,NilI);  dsy}
{/MMI}      compressdesigndata;
 
end; (*Init_Route_Map*)
 
(*
  *)
(* 11111111111111111111111111111111111111111111111111111111111111111 *)
(*                                                                   *)
(*  FUNCTION  : zhal                                                 *)
(*  AUTHOR    : Bala Kulasekaran                                     *)
(*  DATE      : 04/15/86                                             *)
(*  PURPOSE   : Executes the ZHAL routing algorithm using PALASM2    *)
(*              equations.                                           *)
(*                                                                   *)
(*                                                                   *)
(*  MODIFICATIONS :                                                  *)
(*  NAME                  DATE        DESCRIPTION                    *)
(*  --------------------  ----------  -----------------------------  *)
(*  M.Gzowski             5/9/86      remove PDF open statement to   *)
(*                                    Read_PDF procedure.            *)
(*  CB Lee                6/16/86     Rewritten for clarity.         *)
(*  M.Gzowski             7/8/86      bug #882, text file name len   *)
(*                                                                   *)
(*  COMMENTS  :                                                      *)
(*                                                                   *)
(*  INPUT PARAMETERS :                                               *)
(*  VARIABLE    TYPE           DESCRIPTION                           *)
(*  ----------- -------------  ----------------------------------    *)
(*  mmi_zhl     zhal_rec_typ   the file record  containing location  *)
(*                             and length of all input and output    *)
(*                             files that zhal uses                  *)
(*                                                                   *)
(*  OUTPUT PARAMETERS :                                              *)
(*  VARIABLE    TYPE           DESCRIPTION                           *)
(*  ----------- -------------  ----------------------------------    *)
(*  zhal        fnxint_32      the return status of zhal function    *)
(*                             call.                                 *)
(*                                                                   *)
(* 11111111111111111111111111111111111111111111111111111111111111111 *)
 
{/ipp} {vax [global] vax}
 function zhal;  
 
label
  (* error bailout *)
        999;
 
var
   zhalXreturnXstatus  : fnxintX32;
   i                   : integer;
{/fnx}{ipp B_pdfname       :  fname_typ;                        ipp}
 
begin  (* function zhal *)
 
   zhal              := fnxXprgXactive;
   zhalXreturnXstatus:= fnxXretXok;
{dsy  screen := false;  dsy} 
(* open report file *)

{dsy         if NOT openfile (errfile, mmi_zhl.repfile_loc,    dsy}

{dsy  if mmi_zhl.repfile_len = 0 then screen := true;     dsy}
(* write the program banner *)
{dsy    writeln(errfile);    dsy}
{dsy    writeln (errfile,'ZHAL, V2.22 - MARKET RELEASE (11-19-86)'); dsy}
{dsy    writeln (errfile,'(C) - COPYRIGHT MONOLITHIC MEMORIES INC, 1986'); dsy}
{dsy    writeln(errfile); dsy}
{/dsy}    writeln;
{/dsy}    writeln ('ZHAL, V2.22 - MARKET RELEASE (11-19-86)');
{/dsy}    writeln ('(C) - COPYRIGHT MONOLITHIC MEMORIES INC, 1986');
{/dsy}    writeln;
 
(*MEG 7/8/86 bug # 882*)
{dsy    for i:= 1 to mmi_zhl.msgfile_len do    dsy}
{/dsy}    for i:= 1 to txtXfnamelen do
      txtfilename[i]  :=  mmiXzhl.msgfileXloc[i];
    txtfilelen  :=  mmiXzhl.msgfileXlen;
{dsy    for i:= 1 to mmi_zhl.trefile_len do  dsy}
{dsy      TreFileName[i]  :=  mmi_zhl.trefile_loc[i]; dsy}
{dsy    for i:= i+1 to fname_const do treFileName[i] := chr(0); dsy}
{dsy    TreFileLen  :=  mmi_zhl.trefile_len; dsy}

    initglobal;
    zglberrinit;
    if txtretcode <> txtXok then
      begin
{/dsy}        writeln ( inittxtglobalstr, ' Error opening Message File. ');
{dsy    writeln (errfile, InitTxtGlobalStr, ' Error opening Message File. '); dsy}
        zhalXreturnXstatus := fnxXsysXerr;
        goto 999;
      end; (*if...then*)
 
 
{/dsy} (* get access to the TRE file and associated data *)
{/dsy} for i := 1 to treXfnamelen do
{/dsy}   trefilename[i] := mmiXzhl.trefileXloc[i];
{/dsy} trefilelen  :=  mmiXzhl.trefileXlen;
 
(* proceed if no error...  *)
(* ... open TRE file       *)
    opentrefile;
    if zglobalerror then
      begin
        zhalXreturnXstatus := fnxXsysXerr;
        goto 999;
      end;
 
(*  Init the device depended variables *)
    initdevicetype;
    if zglobalerror then
      begin
        zhalXreturnXstatus := fnxXsysXerr;
        goto 999;
      end;
 
 
(* proceed if no error...  *)
(* ... read PDF            *)
{dsy   WrTextLn(errfile,ReadingPDF,Nils,MaxDevicePin);   dsy}
{/dsy}    wrtextln(output,readingpdf,nils,maxdevicepin);
{dsy    PDFFilename := 'ZHAL24.PDF';  dsy}
{dsy    for i:= 1 to 10 do dsy}
{dsy       mmi_zhl.pdffile_loc[mmi_zhl.pdffile_len+i] := PDFFilename[i]; dsy}
{dsy    mmi_zhl.pdffile_len := mmi_zhl.pdffile_len + 10; dsy}
    readXpdf(mmiXzhl.pdffileXloc, mmiXzhl.pdffileXlen, zhalXreturnXstatus);
    if zglobalerror then
      begin
        zhalXreturnXstatus := fnxXprgXerror;
        goto 999;
      end;
 
 
(* proceed if no error...  *)
(* ... present user menu   *)
     initXrouteXmap;
(* MEG 6/25/86 *)
{dsy    if ZGLobalError                              dsy}
{dsy      then zhal_return_status := fnx_prg_error;  dsy}
(* bug # 865   *)
     if routed
       then zglobalerr (maindevicerouteok, nili );
{/dsy}     if zglobalerror
{/dsy}       then zhalXreturnXstatus := fnxXprgXerror;
 
999:
(* Make error report and remove all access to the TRE file *)
    reportglberr;
(* MEG 7/8/86 *)
    textterminate;
    closetre;
 
{dsy  if not screen then  close (errfile);   dsy}
    zhal := zhalXreturnXstatus;
 
end; (* zhal *)
{vax end. vax}
