{**  DEC/CMS REPLACEMENT HISTORY, Element Z24.INC **}
{**  *3    10-OCT-1986 09:32:37 PALASM2 "fixed nested comment in unix conversion"**}
{**  *2    10-OCT-1986 09:06:57 SKITT "unix conversion done" **}
{**  *1     3-OCT-1986 15:07:02 PALASM2 "" **}
{**  DEC/CMS REPLACEMENT HISTORY, Element Z24.INC **}

(*-------------------------------------------------------------------*)
(*								     *)
(* Michael Gzowski						     *)
(*								     *)
(* Monolithic Memories, Inc.                                         *)
(* 2175 Mission College Blvd.                                        *)
(* Santa Clara, CA 95054-1592                                        *)
(*								     *)
(* (c) copyright 1985,1986					     *)
(*                                                                   *)


(* MEG 5/9/86 *)
{vax [environment('pal2$inc:z24.env'), 			vax}
{vax  inherit('pal2$inc:ctxtio.env',            	vax}
{vax          'pal2$inc:ctre.env', 	  		vax}
{vax 	      'pal2$inc:fnxinc.env', 			vax}
{vax           'pal2$inc:csopeninc.env')]		vax}
{vax module Z24; 					vax}
{dsy  pragma C_Include('CTXTIO.INC');  dsy}
{dsy  pragma C_Include('CTRE.INC');  dsy}
{dsy  pragma C_Include('CSOPENINC.INC');  dsy}
{ipp pragma data(common,'ZHALCOMMON'); 			ipp}
{ipp pragma on (externals_allowed_internally); 		ipp}

(*-------------------------------------------------------------------*)
(*|||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||*)
(*-------------------------------------------------------------------*)
(*|||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||*)
(*-------------------------------------------------------------------*)
(*                                                                   *)
(*  PROGRAM   : Z24.INC                                              *)
(*  MODULE    : ZHALGlobals                                          *)
(*  AUTHOR    : Michael Gzowski                                      *)
(*  DATE      : 11/18/85                                             *)
(*  FUNCTION  : This module contains the global declarations for     *)
(*		the ZHAL24 program.				     *)
(*                                                                   *)
(*  MODIFICATIONS :                                                  *)
(*    NAME        DATE       DESCRIPTION                             *) 
(*    ----------- ---------- ------------------------------------    *)
(*    M. Gzowski  11/18/85   Initial release                         *)
(*    M. Gzowski  11/27/85   Additional routines declared.	     *)
(*    M. Gzowski  12/2/85    Additional routines declared.	     *)
(*    M. Gzowski  12/3/85    Error codes added			     *)
(*    M. Gzowski  1/6/86     Message codes added		     *)
(*    M. Gzowski  1/7/86     ReadPDF changed to Read_PDF	     *)
(*    M. Gzowski  1/7/86     Add Text/message/error file name	     *)
(*    C.B. Lee    1/11/86    numerous changes for ZDAA module	     *)
(*    (M. Gzowski)						     *)
(*    C.J. Chien  1/15/86    backend support added		     *)
(*    M. Gzowski  1/17/86    changed TraverseRec,		     *)
(*			     made global routines local		     *)
(*    M. Gzowski  1/24/86    added more message codes                *)
(*    M. Gzowski  1/31/86    made TOP global			     *)
(*    M. Gzowski  2/3/86     changes for forced routing	   	     *)
(*    M. Gzowski  2/7/86     changes for port to IBM PC	   	     *)
(*    M. Gzowski  2/14/86    changes for port to IBM PC	   	     *)
(*    M. Gzowski  2/18/86    added procedure ResetDataCompress	     *)
(*			     added new message (error) codes	     *)
(*    M. Gzowski  2/20/86    changes for port to IBM PC	   	     *)
(*    M. Gzowski  2/26/86    added VCC and GND coverage.	     *)
(*    M. Gzowski  3/4/86     bug fix for # 747			     *)
(*    C.J.Chein   3/5/86     force route mods			     *)
(*    M. Gzowski						     *)
(*    M. Gzowski  3/12/86     bug fix for # 762			     *)
(*    M. Gzowski  3/21/86    force route mods                        *)
(*    C.J. Chien  3/24/86    misc. pin association and force routing *)
(*    M. Gzowski              modifications			     *)
(*    CJ Chien    3/26/86    add two new data structure              *)
(*    M. Gzowski  4/17/86    bug fix #797			     *)
(*    M. Gzowski  4/18/86    bug fix #793			     *)
(*    I. Taller   4/3/86     new PDF processor			     *)
(*    (M.Gzowski  4/23/86    above code added)			     *)
(*    Bala K.     4/16/86    function call support		     *)
(*    CJ Chien    5/1/86     add new stuff for Log io module         *)
(*    M.Gzowski   5/9/86     incorporate all of the three previous   *)
(*			      changes into a single file.	     *)
(*    CJ Chien    5/21/86    add one new file variable               *)
(*    CJ Chien    6/4/86     add new constants for Logic IO section  *)
(*    I. Taller   6/18/86    make the program more general for ZHAL20*)
(*    CJ Chien    6/27/86    remove parameter for gate align         *) 
(*    M.Gzowski   7/8/86     added new message constant		     *)
(*    I. Taller   7/10/86    add new const for pdf processor         *)
(*    M.Gzowski   7/15/86    added new message constants	     *)
(*    I. Taller   8/15/86    added new constants (mess & via map)    *)
(*    M.Gzowski   9/5/86     added parameter to Write_Vias	     *)
(*    I. Taller   9/16/86    added new constants (temp_ via) 	     *)
(*    M.Gzowski   9/16/86    added parameter OffTemplate to	     *)
(*			      procedure Get_Physical_ViaRecord	     *)
(*    I. Taller   9/25/86    added new component class - FeedBack    *)
(*                                                                   *)
(*                                                                   *)
(*                                                                   *)
(*  COMMENTS  : These are ALL the global routine, constant, type,    *)
(*		and variable  declarations for the ZHAL24 program    *)
(*		family.						     *)
(*                                                                   *)
(*  NOTES     : It would be nice to break out declaration by module  *)
(*		classification at some point.  Declaration could be  *)
(*		put into module based "include" files, with one file *)
(*		for each module of the final code.		     *)
(*                                                                   *)
(*-------------------------------------------------------------------*)
(*-------------------------------------------------------------------*)
(*  EXTERNAL DECLARATIONS :                                          *)
(*                                                                   *)
(*      External declarations for global routines of the following   *)
(*	modules are given below:				     *)
(*		MemoryBlockControl;				     *)
(* MEG 1/7/86 *)
(*		ReadPDF; 					     *)
(*		ProgramInitialization;				     *)
(*		PDFProcessor; 					     *)
(*		ConditionHandler;   				     *)
(*		DeviceArchitectureAccess.			     *)
(*                                                                   *)
(*                                                                   *)
(*-------------------------------------------------------------------*)
(*-------------------------------------------------------------------*)
(*  GLOBAL DECLARATIONS :                                            *)
(*								     *)
(*	The following pages contain the global constant, type, and   *)
(*	variable declarations.					     *)


(**)
(*----------------- GLOBAL CONSTANTS --------------------------------*)
const

{dsy	ZHALFilnamLen = 64;  dsy}
{/dsy}	zhalfilnamlen = 32;
	zhalstringlen = 32;

(* IT  6/18/86  *)
	zhal20pinno = 20;	
	zhal24pinno = 24;	
	maxzhalpinno = 24;	
	minzhalpinno = 1;	

(* IT 7/2/86   *)
	zhal24devname = 'ZHAL24                          ';
	zhal20devname = 'ZHAL20                          ';
	zhal2420devname = 'ZHAL2420                        ';
	zhal2024devname = 'ZHAL2024                        ';

(* IT 8/15/86 *)            
	zhal24viamapfile = 'PAL2$DIR:Z24VIA.MAP ';
	zhal20viamapfile = 'PAL2$DIR:Z20VIA.MAP ';

        nomordevicepins = 77; (* C.J. *)
        nomoredevpinassc = -1; (* CB 1/9 *)
  (*----------------------------------------------------------------*)
  (*	GLOBAL CONSTANTS from MemoryBlockControl Module		    *)
  (*----------------------------------------------------------------*)
	lowerlimit = 0;
	upperlimit = 128;				
	blocksize = 129;   {!! 2 !!}
	blksizxx2 = 16641;   {!! 2 !!}
	initialized = true;
	zmbctop = 0;
	additionalamount = false;
	baseamount = true; 
	locations = false;
	offsets = true; 

  (*----------------------------------------------------------------*)
  (*	GLOBAL CONSTANTS from DeviceArchitectureAccess Module	    *)
  (*----------------------------------------------------------------*)

  (* Very Large Number - used as a limit in Component Record Flags *)
	vln = 100000;

	standardintactno = 5;
        mitrecsize       = 7;   (* C.J. 12/10 *)
        iorecsize        = 2;   (* CB 1/5 *)
	
  (* constant values for Array components *)
	intraconnotused = -1;
        nomorrcconnects = -1;   	
	lineempty = 1001;
	linefull = 1003;
	lineused = 1005;
        rowdenserecsize  = 5;   (* C.J. 12/10 *)
        zXnil          = -1;    (* C.J. 12/10 *)
        zXreset        = -999;  (* C.J. 12/10 *) 
(*vvv MEG 12/3/85 vvv*)
  (* constant used for range definitions/tests *)
        mincompcls = 0;         (* CB 12/23 *)
        maxcompcls = 20;        (* CB 12/23 *)
        minloc = -1;            (* CB 12/23 *)
        maxloc = 10000;         (* CB 12/23: Same as preallocation for PDF *)
        minpinasslevel = 0;     (* CB 12/23 *)
        maxpinasslevel = 5;     (* CB 12/23 *)
        minnocomp = 0;
        maxnocomp = 66;
        minnototal= 0;          (* CB 1/2   *)
        maxnototal= 264;        (* CB 1/10  *)
        mindevicepin = 1;
        minpincount = -1;       (* CB 12/31 *)
        maxpincount = 264;        (* MEG 1/21/86 *)
        minpinassno = -1;       (* CB 12/31 *)
        maxpinassno = 5;        (* CB 12/31 *)
	minrecordtype = 0;
	maxrecordtype = 30;	(* IT 6/25 *)
	minmaxusage   = 0;
	maxmaxusage   = 24;	(* CB 1/10  *)
	minassoclevels = 0;
	maxassoclevels = 5;
	minnoassocs = 0;
	maxnoassocs = 50;
(*^^^ MEG 12/3/85 ^^^*)


  (* Component_Class definitions *)
	ccXterminal = 1;
	ccXterminalXi = 0;
	ccXterminalXo = 0;
 	ccXterminalXs = 0;
 	ccXand = 2;
	ccXandXi = 0;
	ccXandXo = 0;
	ccXandXs = 0;
	ccXor = 3;
	ccXorXi = 0;
	ccXorXo = 0;
	ccXorXs = 0;
	ccXxor = 4;
	ccXxorXi = 0;
	ccXxorXo = 0;
	ccXxorXs = 0;
	ccXnand = 5;
	ccXnandXi = 0;
	ccXnandXo = 0;
	ccXnandXs = 0;
	ccXnor = 6;
	ccXnorXi = 0;
	ccXnorXo = 0;
	ccXnorXs = 0;
	ccXxnor = 7;
	ccXxnorXi = 0;
	ccXxnorXo = 0;
	ccXxnorXs = 0;
	ccXnxor = 7;
	ccXnxorXi = 0;
	ccXnxorXo = 0;
	ccXnxorXs = 0;
	ccXinvbuff = 8;
	ccXinvbuffXi = 1;
	ccXinvbuffXo = 1;
	ccXinvbuffXs = 0;
	ccXtribuff = 9;
	ccXtribuffXi = 2;
	ccXtribuffXo = 1;
	ccXtribuffXs = 0;
	ccXinvninvbuff = 10;
	ccXinvninvbuffXi = 1;
	ccXinvninvbuffXo = 2;
	ccXinvninvbuffXs = 0;
	ccXdreg = 11;
	ccXdregXi = 4;
	ccXdregXo = 2;
	ccXdregXs = 0;
	ccXrsreg = 12;
	ccXrsregXi = 3;
	ccXrsregXo = 2;
	ccXrsregXs = 0;
	ccXjkreg = 13;
	ccXjkregXi = 3;
	ccXjkregXo = 2;
	ccXjkregXs = 0;
	ccXbuff = 14;
	ccXbuffXi = 1;
	ccXbuffXo = 1;
	ccXbuffXs = 0;
	ccXtristate = 15;	(* IT 6/18/86 *)
	ccXfeedback = 16;	(* IT 9/25/86 *)
	ccXarray = 0;
	ccXarrayXi = 0;
	ccXarrayXo = 0;
	ccXarrayXs = 1;
	ccXfanio = 20;
	ccXfanioXi = 0;
	ccXfanioXo = 0;
	ccXfanioXs = 1;
	
  (*----------------------------------------------------------------*)
  (*	GLOBAL Constants from ProgramInitialization Module	    *)
  (*----------------------------------------------------------------*)
	initfactoryoption = true;
	initfaeoption = true;
	initmaxcolno = 42;
	initmaxdevicepin = 24;

	initlogphysmap = 0;
	initlogicaliomap = 0;
	initmainindex = 0;
	initmaxroutepass = 1;
	initnocompindex = 0;
	initnorecordtype = 0;
	initoperatorindex = 0;
(*	InitPDSAuthor = ''; 	*)
	initpdfchecksum = 0;
	initpdscompany = ' ';   {!! 2 !!}
	initpdsdate = ' ';   {!! 3 !!}
(* MEG 1/7/86 *)
(* IT 4/23/86 *)
{vax	InitPDFFilename = 'PAL2$DIR:ZHAL24.PDF             ';	vax}
{ipp	InitPDFFilename = 'ZHAL24.PDF';				ipp}
	initpdffilename = 'ZHAL24.PDF';				 {!! 2 !!}
	initpdfid = 0;
	initpdfsize = 1000;
(*	InitPDSFilename = '';	*)
(*	InitPDSXPLOT = 'x';	*)
(*	InitPDSVers = 0;	*)
(*	InitPDSPattern = '';	*)
(*	InitPDSRevision = '';	*)
(*	InitPDSTitle = '';	*)
	initrectypedef = 0;
	initrouted = false;
	initroutepasscount = 0;
	initzhalnamelen = 0;
(*	InitZHALName = '';	*)
(* C.J. 12/10 *)
        initrecordcounter = 0;
        initarrayvalue = 0;     (* C.J. 12/10 *)
        initrowpincntkp = 0;     (* C.J. 12/11 *)
(* MEG 1/7/86 *)
	inittxtfilename = 'ZHAL24.MSG';			 {!! 2 !!}
{ipp	InitTxtFileName = 'ZHAL24.MSG';			ipp}
{vax	InitTxtFileName = 'PAL2$DIR:ZHAL24.MSG';	vax}
(* MEG 1/20/86 *)
	inittxtglobalstr = ' %%ZHAL%% ';	(* IT 6/18/86 *)
	initmemoryblock = false;


  (*----------------------------------------------------------------*)
  (*	GLOBAL Constants from PDFProcessor Module		    *)
  (*----------------------------------------------------------------*)
  (* Taller 4/3/86 *)
  (* TI 7/10/86  *)
  (* PDF version number *)
	pdfversionnum = 12345;
  (* CheckSum Constant *)
   	checksumconst = 256;
        eofmarker = 9999;
  (* block size in int_x4 *)
	objblocksize = 127;


  
  (*------------------------------------------------------------------------*)
  (*                                                                        *)
  (*              Global Constants for TraverseTree module                  *)
  (*------------------------------------------------------------------------*)
  (* C.J. 12/20 *)
  mintermgroup  = 4;
  stackstart = 0;
  stackend = 4;
  
  (*-------------------------------------------------------------------------*)
  (*                                                                         *)
  (*              Global Constants for ForceDeviceRoute Module               *)
  (*                                                                         *)
  (*-------------------------------------------------------------------------*)
  initXforcedXrouteXfailure = false;
  (* IT 6/19/86 *)
  zhal24maxterm = 12;
  zhal20maxterm = 9;
  (* MEG 2/28/86  *)
  initprodtermcount = 0;
  (* max columns in the array *)
  zhalmaxcolno = 42; 
  zhal24colno = 42; 
  zhal20colno = 32; 
  (*-------------------------------------------------------------------------*)
  (*	          GLOBAL Constants from CompressionData Module		     *)
  (*-------------------------------------------------------------------------*)
  (* MEG 3/24/86 *)
  complementXchar = '/';
  tristassoc = 4;
  xorassoc = 3;
  orassoc = 2;
  
  (*-------------------------------------------------------------------------*)
  (*              Global Constants for IO_Format                             *)
  (*-------------------------------------------------------------------------*)
  (* C.J. 1/15/86 *)
  newline = -501;
  space   = -502;
  standardno = 0; (* CJ 2/4/86 *)
  physvialen = 2;    (* CJ 2/4/86 *)
  viaspec    = -504; (* CJ 2/4/86 *)
  array1spec = -503; (* CJ 2/4/86 *)
  array2spec = -505; (* CJ 2/4/86 *)
  tempviabegin = -506; (* IT 9/16/86 *)
  tempviaend = -507;   (* IT 9/16/86 *)
  endsection = -1000; 
  arraynotconnect = -1;  (* CJ 2/12/86 *)
  cross = 'x';
  dash = '-';
  (* CJ 6/4/86 *)
  noX0 = '0';
  noX1 = '1';
  noX2 = '2';
  noX3 = '3';
  noX4 = '4';
  noX5 = '5';
  noX6 = '6';
  noX7 = '7';
  noX8 = '8';
  noX9 = '9';
  charXl = 'l';
  charXi = 'i';
  charXo = 'o';
(* MEG 9/5/86 *)
  charXt = 'T';
  charXf = 'F';
  noconnection = -1;
  
  startcommXlfpr = '(';
  startcommXstar = '*';
  endcommentXrtpr = ')';
  endcommentXstar = '*';
  blank = ' ';
  endoffile = 300;
  inittype = 1;
  initpdfspec = 0;
  initpdfpin = 0;
  initlinespec = 1;
  initcompaddress = 0;  
  bufferstart =1;
  bufferend = 80;
  
(* CJ 6/8 *)
  connspec = 100;
  pinspec  = 200;
  commspec = 300;
(* CJ 6/6/86 *)
  nolink  = '@';
  (*----------------------------------------------------------------*)
  (*	GLOBAL ErrorCodes from all modules			    *)
  (*----------------------------------------------------------------*)
  (* 	Error (Condition) Code Conventions:					*)
  (*		1) (Fatal) Errors codes are Even integer values	    		*)
  (*		2) Information/NonErrors codes are Odd integer values 		*)
  (*		3a) Codes in the set ( 4n, 4n+1 ) are full line messages 	*)
  (*		3b) Codes in the set ( 4n-2, 4n-1 ) are line fragments 		*)
  (*	ErrorCode range allocations:						*)
  (*		< 0	    - not used						*)
  (*		0	    - Dummy/Generic Error				*)
  (*		1	    - NORMAL						*)
  (*		2 - 999	    - general codes, Main Flow				*)
  (*		1000 - 1999 - Memory Block Control				*)
  (*		2000 - 2999 - PDF Processor					*)
  (*		3000 - 3999 - Device Architecture Access			*)
  (*		4000 - 4999 - Program Initialization				*)
  (*		5000 - 5999 - Condition Handler					*)
  (*            6000 - 6999 - Logic IO Section                                  *)      
  (* 										*)
  (*  	These KEYS apply to the preceeding code:				*)
  (* 		INT  - integer parameter used;					*)
  (* 		FRAG - code message is a line fragment.				*)
  (* 										*)
  (* NORMAL 		: this is status code that you hope gets returned 	*)
  (* DummyValue		: Used by ZGlobalErr routine as a dummy error value.	*)
(*vvv MEG 1/6/86 vvv*)
  (* MainDeviceRouteOK	: this message flags routing as successful.        	*)
(*^^^ MEG 1/6/86 ^^^*)
(* MEG 1/24/86 *)
  (* ReadingPDF		: reading the PDF now.                            	*)
  (* InitializingDevData: initializing device data now.                   	*)
  (* ComprForcRout	: compressing data and forced routing.                     	*)
  (* BlockErrBlkLoc 	: This is a Block Control routine error ("BlockErr"). 	*)
  (*                      The Block location to be examined has not been used,	*)
  (*			  it has nothing is stored there.			*)
  (* 			  The Block referenced does exist.			*)
  (* 	(INT)									*)
  (* BlockErrBlock 	: This is a Block Control routine error ("BlockErr"). 	*)
  (* 			  The Block referenced does not exist.			*)
  (* 	(INT)									*)
  (* BlockErrPrtArray	: This is a Block Control routine error ("BlockErr"). 	*)
  (* 			  The PtrOfArray referenced does not exist.		*)
  (* 	(INT)									*)
  (* DAABadRecordType	: Indicates an invalid record type i.e outside allowed 	*)
  (*			  range.						*)
  (* DAABadDevicePin	: Used to indicate an invalid device pin #.		*)
  (* DAACompTypeWrong 	: Component_Class of passed Record_Type is incorrect.	*)
  (* 	(INT)									*)
  (* DAACompTypeWrong_F : Component_Class of passed Record_Type is incorrect.	*)
  (* 	(INT, FRAG)								*)
  (* DAAExptdArrayComp 	: Expected Array Component_Class, received ...		*)
  (* 	(INT)									*)
  (* DAAExptdFanIOComp	: Expected Fan_IO Component_Class, received ...		*)
  (* 	(INT)									*)
  (* DAACompIOOutOfRng	: Component input/output is out of range Record_Type.	*)
  (* 	(INT)									*)
  (* DAAFailGetRecordType							*)
  (*			: Failed GetRecordType routine.				*)
  (* DAANExeGetRecordType							*)
  (*			: Did not execute GetRecordType routine due to a global	*)
  (*			  error.						*)
  (* DAANExeRowAssocLvlCnt							*)
  (*			: Did not execute GetRecordType routine due to a global	*)
  (*			  error.						*)
  (* DAAFailRowAssocLvlCnt							*)
  (*			: Failed RowAssocLvlCnt					*)
(*vvv MEG 12/3/85 vvv*)
  (* BadMaxUsage	: illegal MaxUsage value in LimitedIO record.		*)		
  (* BadAssocLevels	: illegal association level				*)
  (* BadNoAssocs	: illegal numbre of device pin associations.		*)
  (* BadCompAddr	: illegal component address (integer index)		*)
  (* DAAFailRowAssocLevels							*)
  (* 			: Failed RowAssocLevels routine.			*)
  (* DAAFailRowPinAssoc	: Failed RowPinAssoc routine.				*)
  (* DAAFailGetPinAssoc : Failed GetPinAssoc routine.				*)
  (* DAAFailArrayNext	: Failed ArrayNext routine.				*)
  (* DAANexeRowAssocLevels							*)
  (* 			: Did not execute RowAssocLevels routine due to a global*)
  (*			  error.						*)
  (* DAANexeRowPinAssoc	: Did not execute RowPinAssoc routine due to a global	*)
  (*			  error.						*)
  (* DAANexeGetPinAssoc	: Did not execute GetPinAssoc routine due to a global	*)
  (*			  error.						*)
  (* DAANexeArrayNext	: Did not execute ArrayNext routine due to a global	*)
  (*			  error.						*)
  (* AccessErr		: When Text writer returns Txt_AccessErr		*)
  (* NoIndex		: When Text writer returns Txt_NoIndex			*)
  (* UnknownKey		: When Text writer returns Txt_Unknownkey		*) 
  (* OutputErr		: When Text writer returns Txt_OutputErr		*) 
  (* VersionUnmatch	: The version number in PDF is not match, therefore 	*)
  (*			  this processor can not process.			*)
  (* SpaceErr		: PDF memory space is error( e.g. negative value)	*)
  (* MEG 1/9/86									*)
  (* PDFOpenFail	: some generic failure when openning PDF		*)
(*^^^ MEG 12/3/85 ^^^*)
(*vvv MEG 12/4/85 vvv*)
  (* ZMBCExam		: error in ExamineLocation routine			*)
  (* ZMBCPut		: error in PutLocation routine				*)
  (* ZMBCAccess		: error in AccessLocation routine			*)
  (* ZMBCExists		: error in LocationExists routine			*)
  (* ZMBCSave		: error in SaveNext routine				*)
(*^^^ MEG 12/4/85 ^^^*)

	normal = 1;
(* CJ 2/11/86 *)
        nomorevia = 99;
	dummyvalue = 0;

(* MEG 1/24/86 *)
	readingpdf = 5;
	initializingdevdata = 9;
	comprforcrout = 13;

	displaytretitle = 17;		(* MEG 2/28/86 *)
	displaytrefn = 21;		(* MEG 2/28/86 *)
(* CJ 6/26/86  *)
  	readingviamapmessage = 25;
  	writingviamapmessage = 29;  
  	writingphysviamessage = 33;
(*vvv MEG 1/6/86 vvv*)
	maindevicerouteok = 101;
(*^^^ MEG 1/6/86 ^^^*)

(*vvv MEG 12/3/85 vvv*)
	badmaxusage = 108;
	badassoclevels = 112;
	badnoassocs = 116;
	badcompaddr = 120;
(*^^^ MEG 12/3/85 ^^^*)
	mustpassxplot = 124;	(* MEG 2/28/86 *)
(* IT 7/1/86  *)
	invmenuoption = 128;

(* MEG 7/15/86 *)
        sendbugrpt = 132;

	makespace = 201; (* MEG 2/26/86 *)

(* CJ 6/10 *)
        choosemode = 205;
        chooseviamode = 206;
        askforinputname  = 209;
        askforoutputname  = 210;

(*vvv MEG 12/4/85 vvv*)
	blockerrblkloc = 1001;
 	blockerrblock = 1005;
	blockerrprtarray = 1009;
	zmbcexam = 1002;
	zmbcput = 1006;
	zmbcaccess = 1010;
	zmbcexists = 1014;
	zmbcsave = 1018;
(*^^^ MEG 12/4/85 ^^^*)

(*vvv MEG 12/3/85 vvv*)
	versionunmatch = 2016;
(* IT 6/19/86 *)
	devicenameunmatch = 2020;
(* MEG 1/9/86 *)
	pdfopenfail = 2028;
(* IT 7/10/86 *)
	pdfreadfail = 2032;
        pdfchecksumerr = 2036;

	daabadrecordtype = 3000;
	daabaddevicepin = 3004;
	daacomptypewrong = 3008;
	daacomptypewrongXf = 3010;
	daaexptdarraycomp = 3012;
	daaexptdfaniocomp = 3016;
	daacompiooutofrng = 3020;
	daafailgetrecordtype = 3024;
	daanexegetrecordtype = 3028;
	daanexerowassoclvlcnt = 3032;
	daafailrowassoclvlcnt = 3036;
(*vvv C.J. 12/10/85 vvv*)
	daainputleveldne      = 3040;
        daafailgetop          =	3044;
	daafailrowassoclevels = 3048;
	daafailrowpinassoc = 3052;
	daafailgetpinassoc = 3056;
	daafailarraynext = 3060;
        daafailexammitrec = 3064;
        daafailgetmitrec = 3068;
	daanexerowassoclevels = 3072;
	daanexerowpinassoc = 3076;
	daanexegetpinassoc = 3080;
	daanexearraynext = 3084;

(* C.J. *)
        daanomorepinassc    = 3088;
        daafailchngmitrec   = 3092;
        daacompclsoutb      = 3096;
        daanexeredefpin     = 3100;
        daarecordtypeoutb   = 3104;
        daanexeexammitrec   = 3108;
        daanexegetmitrec    = 3112;
        daanexegetop        = 3116;
        daafailqtycomppin   = 3120;
        daanexeqtycomppin   = 3124;
        daafailgetasslevel  = 3128;
        daanexeqtypinass    = 3132;
        daafailqtypinass    = 3136;
        daanexegetasslevel  = 3140;
        daafailcntcitsize   = 3144;
        daanexecntcitsize   = 3148;
        daafailgetpinass    = 3152;
        daanexegetpinass    = 3156;
        daafailgetpinasst   = 3160;
        daanexegetpinasst   = 3164;
        daanexegetcomploc   = 3168;
        daafailgetcomploc   = 3172;
        daafielderror       = 3176;
        daanexechngmitrec   = 3180;
        daafailgetconnec    = 3184;
        daanexegetconnec    = 3188;
        daafailredefpin     = 3192;
        daafailfindlimitr   = 3196;
        daanexefindlimitr   = 3200;
        daafailputconnec    = 3204;
        daanexeputconnec    = 3208;
        daafailclrarray     = 3212;
        daanexeclrarray     = 3216;
        daalocationoutb     = 3220;
        daanocompoutb       = 3224;
        daapinassleveloutb  = 3228;
        daapincountoutb     = 3232;
        daapinassocnooutb   = 3236;
        daapinnooutb        = 3240;
        daafailrowcoloffset = 3244;
        daanexerowcoloffset = 3248;
        daafailfindladdr    = 3252;
        daanexefindladdr    = 3256;
        daafailmovarrayl    = 3260;
        daanexemovarrayl    = 3264;
        daanexevalid        = 3268;   (* CB  1/10  *)
        daabadcompaddr      = 3272;
        daarectypenotarray  = 3276;
        daabadmaxusage      = 3280;
        daafailrowasslevel  = 3284;
        daanexerowasslevel  = 3288;
        daafailrowasslvlcnt = 3292;   (* C.J.  12/13 *)
        daanexerowasslvlcnt = 3296;
        daafailgetrowpinass = 3300;
        daanexegetrowpinass = 3304;
        daafailgetcitindex  = 3308;
        daanexegetcitindex  = 3312;
        daafaildensenextllt = 3316;
        daanexedensenextllt = 3320;
        daadenserecconflict = 3324;
        daafailqtylineintracon = 3328;
        daafailputsparsevalue = 3332;
        daafailusedlinearray = 3336;
        daafailarraylinefull = 3340;
        daafailgetlineintracon = 3344;
        daafailgetdenseintracon = 3348;
        daafailputdensevalue = 3352;
        daabadlinklistaccess = 3356;
        daafailtoaccessintraconnection = 3360;
        daafailtowriteintraconnection = 3364;
        daafailtoaccessnextmapping = 3368;
        daaerrorinintraconnection = 3372;
        daafailtofindintracon = 3376;
        
        (* C.J. 12/11 *)
        daafailunusedintracon = 3380;        

        (* C.J. 12/20 *)
        tregetwrongtrenode = 3384;
        treilleagletokeninlefteqn = 3388;
        treerrorinopeningtree = 3392;
        tremodbeenreopened = 3396;
        trelogicequationnotfound = 3400;
        trenomemory = 3404;
        trelogicequationreaderror = 3408;
        trestackempty = 3412;
        trekindoutofrange = 3416;
        trefailgettrenode = 3420;
        (* MEG 4/17/86  bug #797 *)
	tredeclaredpincount = 3424; 
	tremaxdevpinexceed = 3428;
        frrangefullused = 3440;
        (* MEG 2/18/86 *)
        frequationtoolarge = 3444;
        frtermtoolarge = 3448;
        frtermmax = 3452;
        (* MEG 2/27/86 *)
	frrangehasbeenused = 3456;
	frrangedne = 3460;
        (* CJ 2/20/86 *)
        frerrfindcolumnno = 3464;
        frerrputterminarray = 3468;
        frerrconnectand2  =  3472; (* CJ *)
        frerrallocateterm = 3476;  (* CJ *)
	frerrreadinarraycolumn = 3480; (* CJ *)
        frerrproupgate = 3484; (* CJ 3/20 *)
  	tristselerr = 3488; (* MEG 3/21/86 *)
        failtoplacesig = 3492; (* MEG 4/18/86 bug #793 *)
	frerrconnectiondoesnotmatch = 3494;  (* CJ 6/1986 *)
        failtoplaceterm = 3496; (* MEG 4/18/86 bug #793 *)
	frerrconnnext = 3498;  (* CJ 6/1986 *)
  
        ddcbadoponstack = 3500;           (* CB 12/23 *)
        ddcemptystack = 3504;             (* CB 12/23 *)
        ddcbadopinequation = 3508;        (* CJ 12/30 *)
        ddcfailgeteqterm = 3512;          (* CJ 12/30 *)
        combadtriequation = 3516;         (*CJ 1/1 86 *)
	illegalvccorgnd = 3520;		  (* MEG 2/26/86 *)
        exceedmaxprodterms = 3524;	  (* MEG 2/28/86 *)
        maxprodtermallowed = 3528;	  (* MEG 2/28/86 *)
	illegalpin = 3532;		  (* MEG 3/4/86 bug #747 *)
        ddcarrayallocation = 3536;        (* MEG 4/8/86 *)

 	badpdf = 3600;			  (* MEG 7/15/86 *)
        iotrytooverwriteviacontent = 3800; (* CJ 1/15/86 *)
        iowrongmapcontent = 3804;          (* CJ 1/15/86 *)
        iogetwrongmapcontent = 3808;       (* CJ 1/15/86 *)
        iogetphysicalviarecord = 3812;     (* CJ 1/15/86 *)
        iogetXviarecordXvia = 3816;        (* CJ 1/15/86 *)
        iophysicalviaprefixerror = 3820;   (* CJ 1/15/86 *)
        iophysicalviapostfixerror = 3824;  (* CJ 1/15/86 *)
        ioerrgetphysicalviarecord = 3828;  (* CJ 2/4/86  *)

  	feedbackselerr = 3900; (* MEG 9/25/86 *)

	daaexceedmaxlineuse = 4000;	   (* MEG 4/18/86 *)
	intdevtype = 4004;	   	   (* IT 6/19/86  *)
        accesserr = 5000;
	noindex = 5004;
	unknownkey = 5008;
	outputerr = 5012;
        labelerror = 5016;		   (* CJ 2/20/86 *)
(*^^^ MEG 12/3/85 ^^^*)

(* CJ 6/4/86 *)
        errskipcomments = 6000;
        errpindoesnotmatch = 6004;
        errcharmissinginviamap = 6008;
        errwilardcharinviamap = 6012;
        errmaparraycontent = 6016;
        errorinopenviamapfile = 6020;
          
(**)
(*----------------- GLOBAL TYPES ------------------------------------*)
type

(* MEG 2/7/86 *)
{ipp	int_X4 = longint;				ipp}
{/ipp}	intXx4 = integer;

	zhalfilnamrng = 1..zhalfilnamlen;
	zhalstringrng = 1..zhalstringlen;
	zhalfilnam = packed array[zhalfilnamrng] of char;
	zhalstring = packed array[zhalstringrng] of char;
(* IT 6/18/86 ZHAL device depended types *)
	zhaldevicetype = (zhal20, zhal20X24, zhal24);
  (*----------------------------------------------------------------*)
  (*	GLOBAL TYPES from MemoryBlockControl Module		    *)
  (*----------------------------------------------------------------*)
	arrayrange = lowerlimit..upperlimit;
	blockptr = ^block;
  (* MEG 3/12/86 *)
	block = array [arrayrange] of intXx4;
	arrayptr = ^ptrofarray;
	ptrofarray = record
		     blocks : array [arrayrange] of blockptr;
		     nextarray     : arrayptr;
		   end; (* record *)

	accessmethod = ( putvalue, getvalue, getandput );


  (*----------------------------------------------------------------*)
  (*	GLOBAL TYPES from DeviceArchitectureAccess Module	    *)
  (*----------------------------------------------------------------*)
        (* C.J. 12/23 add NoOp,IDOp,DoneOp *)
        (* MEG 2/26/86 *)
	(* IT 6/18/86 add TriStateOp  *)
	(* IT 9/25/86 add FeedBack  *)
	eqop = ( 
		orop,	andop,	xorop,	element, 
		norop,	nandop,	xnorop,	idop, 
		doneop,	noop,	vccop,	gndop, tristateop, feedbackop
		);
	opuse = ( oparrayref, opcomponentref );
	oitrecrange = oparrayref .. opcomponentref;
	oitrecord = array [oitrecrange] of intXx4;
	
	
	recordXtype = intXx4;
	mitfield = ( componentXclass, 
		     inputdef, 
		     outputdef,
		     nocomponents, 
		     citlocation,
		     pinassoclevels, 
		     pinassocdef );
	mitrecrange = componentXclass .. pinassocdef;
	mitrecord = array [mitrecrange] of intXx4;

	iospecifier = ( inputcomp, outputcomp );

	iofield = ( nextXcomponent, flag );
	iotyperange = nextXcomponent .. flag;
	iotype = array [iotyperange] of intXx4;

	linetype = ( row, column );

(* CJ 2/20/86  *)
        limitiorectype = (nototal,maxusage);
        limitiorange = nototal..maxusage;
        limitiorecord = array[limitiorange] of intXx4;

(* MEG 3/21/86 *)
(* these are the input functions, in order, of a TriState Fan I/O component *)
 	tristselect = (
   		      eqcase,
   		      enblcase,
   		      vcccase,
   		      gndcase
   		      );
(* MEG 9/25/86 *)
(* these are the input functions, in order, of a Feedback Fan I/O component *)
 	feedbackselect = ( regcase,
                           noshiftcase,
                           shiftdowncase,
                           shiftupcase
                         );
  
   
(* Taller 4/3/86 *)
  (*----------------------------------------------------------------*)
  (*	GLOBAL TYPES from Read_PDF Module			    *)
  (*----------------------------------------------------------------*)

tabletypes = (oit, mit, int, iod, cit, acr, lpm, lia);

devicenametype = packed array[1..8] of char;

(* PDF Object file Header *)

headerrecord = record	
		     memsize   : intXx4;   (* memory size for preallocation *)
		     idnum     : intXx4;   (* Identification number *)
		     mitnum    : intXx4;   (* Number of MIT records *)
		     tablesaddr: array [tabletypes] of intXx4;
		     devicename: devicenametype;
		     checksum  : intXx4;   (* checksum for entire pdf *)
		   end; (* of record *)

(* Block Defination for Input/Output  *)

	objblock = record
	   case boolean of
		false: (headerblock : headerrecord);
		true:  (intblock   : array [0..objblocksize] of intXx4);
	   end; 



  (*----------------------------------------------------------------*)
  (*	GLOBAL TYPES from Condition_Handler Module		    *)
  (*----------------------------------------------------------------*)
 	errorXlink = ^errorXcondition;
	errorXcondition = record
			    code, val		: intXx4;
			    next		: errorXlink;
			  end;
  (* MEG 3/24/86 *)
  (*----------------------------------------------------------------*)
  (*      GLOBAL TYPES From ZCompress Module                        *)
  (*----------------------------------------------------------------*)
  (* CJ 3/26/86 *)  
  (* CJ 3/28/86 *)
      listlink = ^listtype;
      listtype = record
                  col : intXx4;
                  pin : intXx4;
                  next: listlink;
                 end;
      poolrecrng = -maxzhalpinno..maxzhalpinno;
      poolrec    = array[poolrecrng] of boolean;
      pinlink = ^pinrec;
      columnrng = 0..zhalmaxcolno;
      maptabtyp = array[ columnrng ] of pinlink;
      columnusage = packed array[ columnrng ] of boolean;
      pintabrec = record
                    cnt : intXx4;
                    collink : pinlink;
                   end;
      pintabtyp = packed array[-maxzhalpinno..maxzhalpinno] of pintabrec;


  (*----------------------------------------------------------------*)
  (*      GLOBAL TYPES From TraverseTree Module                     *)
  (*----------------------------------------------------------------*)
  (* C.J. 12/20 *)
  equationtype = (pinXeq,setfXeq,rstfXeq,trstXeq,clkfXeq);
  stackrange = stackstart..stackend;
  stacktype = record
              op : eqop;
              pntr : trelink;
              end;
  stackarray = array[stackrange] of stacktype;
  (* MEG 2/20/86 *)
  stack = record
          reduce : intXx4;
          stckindex: stackrange;
          stackstruct : stackarray;
          end;
  idlink = ^idrec;
  idrec = record
          val : intXx4;
          next  : idlink;
          end;

  (* MEG 2/26/86 *)
  (* used for  categorizing equation right of equivalence *)
  termrec = record
              devpin  : intXx4;
              trstnode,
              xornode,
              left,
              ornode,
              andnode,
              done,
              vccnode,
              gndnode : boolean;
              idcount : intXx4;
              idlist  : idlink;
            end;
  (* C.J. 12/24 *)
  (* MEG 1/16/86 *)
  traverserec = record
                  tempeq               : termrec;
                  opstack , rightstack : stack;
                  nextdown             : trelink;
                  currentop            : eqop;
                  currentvalue         : intXx4;
                end; (*record*)

  lvlrng = minassoclevels..maxassoclevels;
  devpinrange = minzhalpinno..maxzhalpinno;
  range = record
          low,high : intXx4;
          end;
  rangearrptr = ^rangearray;
  rangearray = array[lvlrng] of range; (* C.J. 12/14 *)

  (* MEG 2/26/86 *)
  (* MEG 3/24/86 *)
  (* used for categorizing device pin by equations left of equivalence *)
  devpindata = record
               levelrange,levelrange2nd : rangearrptr;
               registered,
	       complemented,
    	       triflag,
	       declaredcomplement  : boolean;           
               tristate,equatn : trelink;
             end;  
  pinusage = array [devpinrange] of boolean;

(*-------------------------------------------------------------------*)
(*                                                                   *)
(*           GLOBAL TYPES FROM IO_FORMAT MODULE                      *)
(*                                                                   *)
(*-------------------------------------------------------------------*)
(* C. J.  2/4/86*)
  specrecordtype = record
                   pinno : intXx4;
                   viacount : intXx4;
                   spec     : intXx4;
                   logptr   : intXx4;
                   physptr  : intXx4;
                   end;
(* CB 3/14/86 *)
  physrectype = record
                prefix,postfix : intXx4;
                end;
                 
(* CJ 2/20/86 *)
(* MEG 9/22/86 *)
  pinrec = record
            val : intXx4;
	    level : intXx4;
            citindex : intXx4;
            mainassoc: intXx4;
            next: pinlink;
           end;

  coltabrec = array[-maxzhalpinno..maxzhalpinno] of intXx4;                 
(* CJ 5/1/86 *)
  buffertype = packed array[bufferstart..bufferend] of char; 
(* CJ 5/2/86 *)
  linktype = ^linkrec;
  linkrec  = record
                val : char;
                next: linktype;
              end;
  tabletype = array [minzhalpinno..maxzhalpinno] of linktype;
                
(**)
(*----------------- GLOBAL VARIABLES --------------------------------*)
var

(*----------------------   GLOBAL Varible index --------------------------------------------------------------------------------*)
(* CurrentBlkLoc 	: the index to the currently used position within the Block referedtobyCurrentBlockpointer		*)
(* CurrentBlock		: the index to the currently used pointer in the PtrOfArray referedtobyCurrentPtrArraypointer	*)
(* CurrentPtrArray	: the pointer to the currently used array of Block (PtrOfArray)pointers				*)
(* CurrentPtrArrayLink	: the integer count of the CurrentPtrArray's position withinthePtrOfArraylinkedlist		*)
(* LastBlkLoc		: the index to the last position within the last Block that has been(explicitly)allocated		*)
(* LastBlock		: the index to the last pointer in the last allocated PtrOfArray (LastPtrArray)withBlockallocated	*)
(* LastPtrArray		: the last PtrOfArray that has been allocated 								*)
(* LastPtrArrayLink	: the integer count of the LastPtrArray's position within thePtrOfArraylinkedlist			*)
(* 			  this is the effective number of links cuurently allocated 						*)
(* MemoryBlockInitialized : set true if the Memory Block Structure has been initialed(once)					*)
(* TopPtrArray		: the pointer (ArrayPtr) to the head of the PtrOfArray linked list					*)
(* PtrArrayLink 	: the position of the currently accessed Location in the PtrOfArraylinkedlist			*)
(* BlkPtrOffset 	: the offset of the currently accessed Location in PtrOfArray 						*)
(* BlockOffset 		: the offset of the currently accessed Location in the Block 						*)
(* MemBlkCtrlStatus 	: the current status for all routines in this module 							*)
(* CountKeeper		: The pin  count which should be processed next.							*)
(* FactoryOption	: If true, then the executable contains the Factory option.						*)
(* FAEOption		: If true, then the executable contains the FAE option.							*)
(* LogPhysMap		: Physical Via Map Address										*)
(* LogicalIOMap		: Logical Map Format Address										*)
(* MainIndex		: Main Index Table Address										*)
(* MaxRoutePass		: The maximum routing pass limit.									*)
(* NoCompIndex		: Number of Component Index Tables									*)
(* NoRecordType		: Number of Record Types										*)
(* OperatorIndex	: Operator Index Table Address										*)
(* PDSAuthor		: The PDS Author											*)
(* PDFChecksum		: Checksum for entire PDF (ADDITION)									*)
(* PDSCompany		: The PDS Company											*)
(* PDSDate		: The PDS date												*)
(* PDFFilename		: The name of the PDF file										*)
(* PDFID		: ZHAL PDF ID Number											*)
(* PDFSize		: Memory size for pre-allocation 									*)
(* PDSFilename		: The name of the PDS file										*)
(* PDSXPLOT		: PDS XPLOT flag											*)
(* PDSVers		: The PDS version number										*)
(* PDSPattern		: The PDS Pattern											*)
(* PDSRevision		: The PDS Revision											*)
(* PDSTitle		: The PDS Title												*)
(* RecTypeDef		: Record Type Definition Table Address									*)
(* Routed		: The flag to signal routing success.									*)
(* RoutePassCount	: The current routing complexity level.									*)
(* ZGlobalError		: The ZHAL program global error status flag								*)
(* ZGlbErrList		: The list of errors occured.										*)
(* ZHALNameLen		: The size of ZHAL Device Name (n)									*)
(* ZHALName		: The ZHAL Device Name string										*)
(*vvv MEG 12/3/85 vvv*)
(* MinCompAddr 		: The minimum component address (integer index)							 	*)
(* MaxCompAddr 		: The maximum component address (integer index)	
							*)
(*^^^ MEG 12/3/85 ^^^*)
(* CJ 2/4/86 *)
(* ViaPointer           : The moving pointer to a desired logical via           *)         
(*------------------------------------------------------------------------------------------------------------------------------*)

  (*----------------------------------------------------------------*)
  (*	General GLOBAL Variables 				    *)
  (*----------------------------------------------------------------*)
	returnflag		: intXx4;  (* rjs 11 feb 86 *)
	returnstatus		: boolean; (* rjs 11 feb 86 *)
	countkeeper		: intXx4;
	factoryoption		: boolean;
	faeoption		: boolean;
(* IT 6/18/86 ZHAL device depended variables  *)
        maxcolno		: intXx4;
	maxdevicepin 		: intXx4;	
	devicetype		: zhaldevicetype;	
	maxprodtermcount 	: intXx4;
	logphysmap		: intXx4;
	logicaliomap		: intXx4;
	mainindex		: intXx4;
	maxroutepass		: intXx4;
	nocompindex		: intXx4;
	norecordtype		: intXx4;
	operatorindex		: intXx4;
	pdsauthor		: trestr;
	pdfchecksum		: intXx4;
	pdscompany		: trestr;
	pdsdate			: trestr;
(* MEG 5/9/86 *)
	pdffilename		: zhalfilnam;
	pdfid			: intXx4;
	pdfsize			: intXx4;
	pdsfilename		: trefname;
	pdsxplot		: char;
	pdsvers			: integer;
	pdspattern		: trestr;
	pdsrevision		: trestr;
	pdstitle		: trestr;
	pinused			: pinusage;
	rectypedef		: intXx4;
	routed			: boolean;
	routepasscount		: intXx4;
	zglobalerror		: boolean;
	zglberrlist		: errorXlink;
	zhalnamelen		: intXx4;
	zhalname		: zhalstring;
{dsy    screen			: boolean;  dsy}
{dsy    errfile			: text; dsy}
             
        (* C.J. 12/20 *)
        devpins                 : array[devpinrange] of devpindata;        
        (* MEG 1/16/86 *)
        viapointer              : intXx4; (* CJ 1/15/86 *)
        zhalviamapfile		: trefname;        
        logmapfilname           : trefname;        
        logmapfile              : text;   (* CJ 1/15/86 *)
        writeoutfile            : text;   (* CJ 5/21/86 *)        
        physicalfilnam          : zhalfilnam; (* CJ 1/15/86 *)
        graphicfilnam           : zhalfilnam; (* CJ 1/15/86 *)
        (* CJ 2/4/86 *)
  (*----------------------------------------------------------------*)
  (*	GLOBAL Variables from MemoryBlockControl Module		    *)
  (*----------------------------------------------------------------*)
	currentblkloc		: intXx4;
	currentblock		: intXx4;
	currentptrarray		: arrayptr;
	currentptrarraylink	: intXx4;
	lastblkloc		: intXx4;
	lastblock		: intXx4;
	lastptrarray		: arrayptr;
	lastptrarraylink	: intXx4;
	memoryblockinitialized	: boolean;
	topptrarray		: arrayptr;
	ptrarraylink 		: intXx4;
	blkptroffset 		: intXx4;
	blockoffset 		: intXx4;
	memblkctrlstatus 	: intXx4;

(*vvv MEG 12/3/85 vvv*)
  (*----------------------------------------------------------------*)
  (*	GLOBAL Variables from DeviceArchitectureAccess Module	    *)
  (*----------------------------------------------------------------*)
        arrayrows               : intXx4;     (* CB 1/6 *)
        arraycolumns            : intXx4;     (* CB 1/6 *)
        headlist                : intXx4;     (* CB 1/8 *)
        taillist                : intXx4;     (* CB 1/8 *)
        mincompaddr 		: intXx4;
	maxcompaddr 		: intXx4;
(*^^^ MEG 12/3/85 ^^^*)
(* C.J. 12/10/85 *)
        daacomponentloc         : intXx4;
        daalineindex            : intXx4;
        rowpincntkeeper         : intXx4;
        daaroworcol             : linetype;   (* CB 1/6 *)
        daapinassclevel         : intXx4;     (* CB 1/8 *)
        daapinassccomploc       : intXx4;     (* CB 1/8 *)
        daapinasscrowindex      : intXx4;     (* CB 1/8 *)
        recordcounter           : intXx4;

(*-------------------------------------------------------------------*)
(*         Global Variables for traverseTree Module                  *)
(*-------------------------------------------------------------------*)
currentop                       : eqop;
currentvalue                    : intXx4;
nextdown                        : trelink;
rightstack,opstack              : stack;
(*-------------------------------------------------------------------*)
(*          Global Variables for ForceDeviceRoute                    *)
(*-------------------------------------------------------------------*)
(* IT  6/19/86  *)
maxtermids 			: intXx4;
frXindex                        : intXx4;
forceXrouteXfailure            : boolean;
(* C.J. 12/24 *)
temptermrec,temptrirec          : termrec;

(*CJ 2/20/86 *)
columntable                     : coltabrec;

(* CJ 3/27/86 *)
pintable                        : pintabtyp;
maptable                        : maptabtyp;
pool                            : poolrec;
(* CJ 3/28/86 *)
garblist                        : listlink;
currentlist                     : listlink;
(*-------------------------------------------------------------------*)
(*	    GLOBAL Variables from CompressionData Module	     *)
(*-------------------------------------------------------------------*)
freeidrec                       : idlink; (* C.J. 12/24 *)
freelink                        : idlink; (* C.J. 12/24 *)
tempeqterm                      : termrec; (* C.J. 12/27 *)
(* MEG 2/3/86 *)
rowgroup,
nooflevels,
noofrows,
arrrectype,
arrayaddress			: intXx4;
logiotable                      : tabletype;  (* CJ 5/16/86 *)
buffptr                         : intXx4;     (* CJ 6/6/86 *)
(* CJ 6/8 *)
incomment  			: boolean;
logioXpointer                   : intXx4;
pdfspec                         : intXx4;
pdfpin        			: intXx4;
pdfcompaddr   			: intXx4;
  
(*-------------------------------------------------------------------*)
(*|||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||*)
(*-------------------------------------------------------------------*)
(*|||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||*)
(*-------------------------------------------------------------------*)


(**)
  (*----------------------------------------------------------------*)
  (*	GLOBAL Routines from DeviceArchitectureAccess Module	    *)
  (*----------------------------------------------------------------*)
  function getop ( 		operator 	: eqop; 
                   		operuse  	: opuse ) 	: intXx4; external;
  function getmitrec ( 		recordXtype 	: intXx4 ) 	: mitrecord; external;
  function examinemitrec ( 	recordXtype 	: intXx4;
   			   	field       	: mitfield ) 	: intXx4; external;
  procedure changemitrec ( 	recordXtype 	: intXx4;
			   	field       	: mitfield;
  			   	val       	: intXx4 ); external;
  function nocompinputs ( 	recordXtype 	: intXx4 ) 	: intXx4; external;
  function nocompoutputs ( 	recordXtype 	: intXx4) 	: intXx4; external;
  function nocomppins ( 	recordXtype 	: intXx4;
     		        	iXo	    	: iospecifier )	: intXx4; external;
  function redefinecomppins ( 	recordXtype 	: intXx4 ) 	: boolean; external;
  function translatecomppin ( 	recordXtype 	: intXx4;
                              	iXo         	: iospecifier;
                              	comppin     	: intXx4 ) 	: intXx4; external;
  function qtycomppin ( 	recordXtype 	: intXx4;
                        	iXo         	: iospecifier )	: intXx4; external;
  function qtypinassoc ( 	recordXtype 	: intXx4;
                         	level       	: intXx4 ) 	: intXx4; external;
  (* C.J. *)  
  function getcomponentloc  ( 	recordXtype     : intXx4;
                              	citindex    	: intXx4 ) 	: intXx4; external;
  function getassoclevels ( 	recordXtype 	: intXx4 ) 	: intXx4; external;
  
  (* C.J. 12/23/85 *)
  function getpinassoc (        recordXtype     : intXx4;
                                citindex        : intXx4;
                                level           : intXx4;
                                currpin         : intXx4 )      : intXx4; external;
  function getpinassoct ( 	recordXtype 	: intXx4;
				citindex    	: intXx4;
				level       	: intXx4 ) 	: intXx4; external;
  function getpinassocc  ( 	recordXtype	: intXx4;
                                citindex        : intXx4;
				level        	: intXx4;
                                currpin         : intXx4 ) 	: intXx4; external;
  function getrecordtype ( 	componentloc 	: intXx4 ) 	: intXx4; external;
  function getconnection ( 	componentloc 	: intXx4;
				iXo          	: iospecifier;
				comppinnumber	: intXx4 ) 	: iotype; external;
  procedure putconnection ( 	componentloc 	: intXx4;
				iXo		: iospecifier;
				comppinnumber	: intXx4;
				connection   	: iotype ); external;
  function getnext ( 		componentloc 	: intXx4;
				iXo          	: iospecifier;
				comppinnumber	: intXx4 ) 	: intXx4; external;
  procedure putnext ( 		componentloc 	: intXx4;
				iXo          	: iospecifier;
				comppinnumber	: intXx4;
				nextcomp     	: intXx4); external;
  function getflag ( 		componentloc 	: intXx4;
				iXo          	:iospecifier;
				comppinnumber	: intXx4 ) 	: intXx4; external;
  function putflag ( 		componentloc 	: intXx4;
				iXo          	: iospecifier;
				comppinnumber	: intXx4;
				flag         	: intXx4 ) 	: intXx4; external;
  function connectactivec ( 	componentloc 	: intXx4;
				iXo          	: iospecifier;
				comppinnumber	: intXx4 ) 	: boolean; external;
  function connectactivea ( 	address 	: intXx4 ) 	: boolean; external;
  function connectionfree ( 	componentloc 	: intXx4;
				iXo          	: iospecifier;
				comppinnumber	: intXx4 ) 	: boolean; external;
  function connectsavail ( 	componentloc 	: intXx4;
				iXo          	: iospecifier )	: intXx4; external;
  (* CJ 4/10 *)
 function cnthardconnection( 	componentloc 	: intXx4;
				iXo          	: iospecifier )	: intXx4; external;
(* MEG 2.14.86 *)
  function arraynext (  	componentloc  	: intXx4 )  	: intXx4; external;
  procedure clrarrayrow (  	componentloc	: intXx4;
				rowindex	: intXx4 ); external;
  procedure movarrayrow ( 	componentloc 	: intXx4;
				rowindexs    	: intXx4;
				rowindexd    	: intXx4 ); external;
  procedure copyarrayrow ( 	componentloc 	: intXx4;
				rowindexs    	: intXx4;
				rowindexd    	: intXx4 ); external;
  procedure addrowintracon ( 	componentloc 	: intXx4;
				rowindex     	: intXx4;
				colindex     	: intXx4 ); external;
  function getrowintracon ( 	componentloc 	: intXx4;
				rowindex     	: intXx4 ) 	: intXx4; external;
(* MEG 2/7/86 *)
  function arrayrowfull ( 	componentloc 	: intXx4;
				rowindex     	: intXx4 ) 	: boolean; external;
  function usedrowarray ( 	componentloc 	: intXx4;
				rowindex     	: intXx4 ) 	: boolean; external;
  function qtyrowintracon  ( 	componentloc 	: intXx4;
				rowindex     	: intXx4 ) 	: intXx4; external;
  function statrowarray ( 	componentloc 	: intXx4;
				rowindex     	: intXx4 ) 	: intXx4; external;
  function rowassoclevels ( 	componentloc 	: intXx4 ) 	: intXx4; external;
  function rowassoclvlcnt ( 	componentloc 	: intXx4;
				level        	: intXx4 ) 	: intXx4; external;
  function getrowpinassoc ( 	componentloc 	: intXx4;
				level        	: intXx4;
				rowindex     	: intXx4 ) 	: intXx4; external;
  procedure clrarraycol ( 	componentloc 	: intXx4;
				colindex     	: intXx4 ); external;
  function getcitindex ( 	componentloc 	: intXx4 )      : intXx4; external;
  procedure movarraycol ( 	componentloc 	: intXx4;
				colindexs    	: intXx4;
				colindexd    	: intXx4 ); external;
  procedure copyarraycol ( 	componentloc 	: intXx4;
				colindexs    	: intXx4;	
				colindexd    	: intXx4 ); external;
  procedure addcolintracon ( 	componentloc 	: intXx4;
				colindex     	: intXx4;
				rowindex     	: intXx4 ); external;
  function getcolintracon ( 	componentloc 	: intXx4;
				colindex     	: intXx4 ) 	: intXx4; external;
  function arraycolfull ( 	componentloc 	: intXx4;
				colindex     	: intXx4 ) 	: boolean; external;
  function usedcolarray ( 	componentloc 	: intXx4;
				colindex     	: intXx4 ) 	: boolean; external;
  function qtycolintracon ( 	componentloc 	: intXx4;
				colindex     	: intXx4 ) 	: intXx4; external;
  function statcolarray ( 	componentloc 	: intXx4;
				colindex     	: intXx4 ) 	: intXx4; external;
  procedure clrarrayline ( 	componentloc 	: intXx4;
				lineindex    	: intXx4;
				orientation  	: linetype ); external;
  procedure movarrayline ( 	componentloc 	: intXx4;
				lineindexs   	: intXx4;
				lineindexd   	: intXx4;
				orientation  	: linetype ); external;
(* CB 1/10/86 *)
  procedure copyarrayline ( 	componentloc 	: intXx4;
				lineindexs   	: intXx4;
				lineindexd   	: intXx4;
				orientation  	: linetype ); external;
  procedure addlineintracon ( 	componentloc 	: intXx4;
				columnindex    	: intXx4;
				rowindex   	: intXx4   ); external;
  function getlineintracon ( 	componentloc 	: intXx4;
				lineindex    	: intXx4;
				orientation  	: linetype ) 	: intXx4; external;
  function arraylinefull ( 	componentloc 	: intXx4;
				lineindex    	: intXx4;
				orientation  	: linetype ) 	: boolean; external;
  function usedlinearray ( 	componentloc 	: intXx4;
				lineindex    	: intXx4;
				orientation  	: linetype ) 	: boolean; external;
  function qtylineintracon ( 	componentloc 	: intXx4;
				lineindex    	: intXx4;
				orientation  	: linetype ) 	: intXx4; external;
  function statlinearray ( 	componentloc 	: intXx4;
				lineindex    	: intXx4;
				orientation  	: linetype ) 	: intXx4; external;
(* CB 1/10/86 *)
  function garbagecollect (     lpointer        : intXx4 )      : intXx4; external;

(* CJ 2/20/86 *)
  function findlimitrecord(componentloc : intXx4;
                           rowcol       : linetype): limitiorecord;external;

  function findlineaddress(componentloc : intXx4;
                           lineindex    : intXx4;
                           roworcolumn  : linetype) : intXx4;external;
  
(* CJ 3/6/86 *)
  function connectfull(comploc:intXx4;
                       io:iospecifier):boolean;external;

  function notused(iorec:iotype):boolean;external;

(* CJ 5/21/86 *)
  function getdenseintracon(recaddress: intXx4; reccounter: intXx4):intXx4;external;
                           
  function getlistno(recaddress:intXx4): intXx4;external;
  (*----------------------------------------------------------------*)
  (*	GLOBAL Routines from MemoryBlockControl Module		    *)
  (*----------------------------------------------------------------*)
  procedure allocatespace (	size    	: intXx4;
				basesize 	: boolean ); external;
  procedure initblock ( 	space 		: intXx4 ); external;
  function examinelocation (    location 	: intXx4;
			    var val 		: intXx4 ) 	: intXx4; external;
  function putlocation (    	location	: intXx4;
		         	val 		: intXx4 ) 	: intXx4; external;
  function savenext (		val		: intXx4) 	: intXx4; external;
(*vvv MEG 11/27/85 vvv*)
  function nextlocation 					: intXx4; external;
(*^^^ MEG 11/27/85 ^^^*)

  (*----------------------------------------------------------------*)
  (*	GLOBAL Routines from ProgramInitialization Module	    *)
  (*----------------------------------------------------------------*)
  procedure initglobal; external; 
  procedure initdevicetype; external; 
  procedure initdevicedata; external; 

  (*----------------------------------------------------------------*)
  (*	GLOBAL Routines from PDFProcessor Module		    *)
  (*----------------------------------------------------------------*)
(* MEG 1/7/86 *)
(* MEG 5/9/86 *)
  procedure readXpdf ( pdffilenameloc : fnameXtyp;
		       pdffilenamesiz : integer;
		      var fnxXstatus  : fnxintX32 ); external;

  (*----------------------------------------------------------------*)
  (*	GLOBAL Routines from Condition_Handler Module		    *)
  (*----------------------------------------------------------------*)
  procedure zglobalerr (	errorcode 	: intXx4; 
				val		: intXx4 ); external;
  (*vvv MEG 12/2/85 vvv*)
  procedure reportglberr; external;
  procedure zglberrinit; external;
  (*^^^ MEG 12/2/85 ^^^*)

  (*-----------------------------------------------------------------*)
  (*     Global Routines from TraverseTree Module                    *)
  (*-----------------------------------------------------------------*)
  (* C.J. 12/20 *)
  (* MEG 1/17/86 *)
  function equationpin(equationptr:trelink;
                        var registered:boolean;
                        var complemented:boolean;
                        var eqclassification:equationtype;
                        var termptr : trelink): intXx4;external;
  procedure settrenode(    devicepin: intXx4;
                       var traversal: traverserec;
			   eqtype   : equationtype ); external;
  procedure gettrenode(var traversal:traverserec);external;
  function empty(var stackptr:stack) : boolean;external;  (* C.J. 12/27 *)
  function top(var stackptr:stack) : stacktype; external;  (* MEG 1/31/86 *)
  procedure retiretreXfordevicepin(devicepin : intXx4); external;
  (* CJ 1/1/86 *)
  
  (*-----------------------------------------------------------------*)
  (*     Global Routines from CompressionData  Module                *)
  (*-----------------------------------------------------------------*)
  (*C.J.  12/20 *)
  procedure compressdesigndata;external;
  (* MEG 2/18/86 *)
  procedure resetdatacompress; external;
  (*MEG 1/17/86   -> 4 lines removed *)
 
  (*------------------------------------------------------------------*)
  (*        Global Routines from ForceRoute Module                    *)
  (*------------------------------------------------------------------*)
  procedure compresstomap(var eqterm:termrec);external;
  procedure fitterm(var eqterm:termrec);external;
  (* MEG 2/3/86 *)
  (* MEG 2/26/86 *)
  (* CJ 6/27/86 *)
  procedure resetforceroute;external;

  (* CJ 2/20/ 86 *)
  procedure readinarraycolumn(pool:poolrec;var coltable:coltabrec);external;
  (*CJ 3/21/86 *)
  procedure fittricondition(devicepin:intXx4;
                            tristswitch : tristselect); external;
  (* MEG 9/25/86 *)
  procedure fitfeedback ( citindex,
                          assocpin,
                          devicepin : intXx4;
                          var feedbackusage : columnusage ); external;


  (*------------------------------------------------------------------*)
  (*        Global Routines from Input Logical Map Module             *)
  (*------------------------------------------------------------------*)
  
  function transform(buf : buffertype): intXx4; external;
  
  procedure readXprocessor(logmapfilename: trefname);external;  (* CJ 1/15/86 *)
  
  (*------------------------------------------------------------------*)
  (*        Global Routines from Output Logical Map                   *)
  (*------------------------------------------------------------------*)
  procedure writeXprocessor(logmapfilename: trefname;
			    writeoutfilename: trefname); external;  (* CJ 1/15/86 *)
  (*------------------------------------------------------------------*)
  (*        Global Routines from Process Logical Map Module           *)
  (*------------------------------------------------------------------*)
  procedure processXlogicalXmap(writefile : boolean; logmapfilename:trefname);external;
  (* CJ 5/1/86 *)
  procedure logioXinitialization(var logmapfilename:trefname;
                                 var logioXpointer : intXx4 ;
                                 var openflag      :boolean ); external; 
  (* CJ 6/6/86 *)
  procedure skipcomments(linebuffer: buffertype); external;
  function getline(var linespec : intXx4) : buffertype; external;
  procedure initialbuffer(var buf : buffertype); external;
  (*------------------------------------------------------------------*)
  (*        Global Routines from Process Physical Map                 *)
  (*------------------------------------------------------------------*)
  (* CJ 1/15/86 *)
  (* MEG 2/10/86 *)
  procedure makeXphysicalXmap;external;
  procedure initializeXphysicalXmapping;external;
  (* CJ 2/4/86 modified *)
  (* MEG 9/16/86 *)
  procedure getXphysicalXviarecord(var recordspec:specrecordtype;
			    	   var offtemplate: boolean);external;
  function getXviarecordXvia(recordspec:specrecordtype;
                              offset:intXx4;
                              var physrecord:physrectype):intXx4; external;
  (*------------------------------------------------------------------*)
  (*        Global Routines from write_PhysMap_File                   *)
  (*------------------------------------------------------------------*)
  procedure writeXphysmapXfile;external;
  procedure writeXgraphicXfile;external;  
  (*------------------------------------------------------------------*)
  (*        Global Routines from Write_Logical                        *)
  (*------------------------------------------------------------------*)
(* MEG 9/5/86 *)
  procedure writeXvias( shouldmerge: boolean);external;
{dsy    procedure dsyinit; external;  dsy}
(**)
(*-------------------------------------------------------------------*)
{ipp  pragma data;			ipp}
{vax  procedure declare_ZHAL24;		vax}
{vax  begin end; 			vax}
{vax  end. (* of module ZHALGlobals *) 	vax}
(*-------------------------------------------------------------------*)
