{**  DEC/CMS REPLACEMENT HISTORY, Element XPLOT.SRC **}
{**  *11   26-FEB-1987 14:49:06 VORA "calling one extra procedure" **}
{**  *10    9-FEB-1987 22:25:46 VORA "fixed bug for 22rx8 and 22v10 " **}
{**  *9    15-DEC-1986 12:54:55 LIN "Fixed problem caused to DAISY by fixing buf!!5!!-T.C.Lin12-15-86"**}
{**  *8     5-NOV-1986 15:42:19 LIN "Change fName extension to uppercase -UNIX-T.C.Lin11/05/86"**}
{**  *7    28-OCT-1986 12:23:23 VORA " fixed bug #886" **}
{**  *6    24-OCT-1986 13:23:21 LIN "Modified for UNIX - T.C.Lin 10/23/86" **}
{**  *5    12-OCT-1986 01:45:02 VORA " " **}
{**  *4     9-OCT-1986 13:36:41 VORA "fixed bug#997" **}
{**  *3     9-OCT-1986 10:24:03 VORA "fixed bug #833 - for Pc version it still hassomeproblem"**}
{**  *2     8-OCT-1986 13:55:22 VORA "fixed Bug #805,873,954" **}
{**  *1     3-OCT-1986 15:13:33 PALASM2 "" **}
{**  DEC/CMS REPLACEMENT HISTORY, Element XPLOT.SRC **}
(****************************************************************************)
(*               MONOLITHIC  MEMORIES INC.                                  *)
(*                                                                          *)
(*  Author : Imtiyaz Bengali                                                *)
(*                                                                          *)
(*  This program is developed in 10 modules. The master source code is      *)
(*  written in standard PASCAL. Certain variations of PASCAL are coded      *)
(*  for different environments. The environments supported by this code are *)
(*  VAX/VMS, IBM_PC (Pro Pascal) and IBM-PC (microsoft pascal). These       *)
(*  different environments have variations in I/O and module decalrations.  *)
(*  Any code that is only used for a particular environment is coded with   *)
(*  comments, e.g. {vax ... vax} is used only for vax environment. any code *)
(*  that is to be deleted for certain environment is preceded by a delete   *)
(*  deleted for VAX machine. Using special translators, one can translate   *)
(*  this master code for different environments.                            *)
(*                                                                          *)
(*   AAXPLOT.SRC  -- constant, types , var and external procedures          *)
(*   AXPLOT.SRC   -- same as AAXPLOT.SRC but for module use only.           *)
(*   XPLOT.SRC    -- main program                                           *)
(*                      procedure error, procedure error1                   *)
(*   XDB.SRC      -- module dbutilsq                                        *)
(*                      procedure hookup, procedure makenode                *)
(*                      procedure placenode, procedure makename             *)
(*                      function  expandlist, function transname            *)
(*   XFNODE.SRC   -- module formnodeq                                       *)
(*                      procedure formnode                                  *)
(*   XFEQ.SRC     -- module formeq_simq                                     *)
(*                      procedure formeq_sim                                *)
(*   XM1.SRC      -- module m1q                                             *)
(*                      procedure read_pal, procedure phantom               *)
(*                      procedure initialise, procedure print               *)
(*                      procedure jedec.                                    *)
(*   XM2.SRC      -- module m2q                                             *)
(*                      procedure create_xorlst                             *)
(*                      procedure create_orlst                              *)
(*                      procedure create_andlst                             *)
(*   XM3.SRC      -- module m3q                                             *)
(*                      procedure check4                                    *)
(*   XM4.SRC      -- module m4q                                             *)
(*                      procedure polarity, proceudre prodshare             *)
(*                      procedure blowfuse, procedure product               *)
(*                      procedure do_fxplot, procedure do_xplot             *)
(*                      procedure do_xxplot, procedure plot                 *)
(*   XM5.SRC      -- module m5q                                             *)
(*                      procedure check1, procdure check2                   *)
(*                      procedure check3, procedure check5                  *)
(*                      proceudre increment.                                *)
(*   ANDAR.SRC    -- modulee m1q                                            *)
(*                      procedure wandarr, function randarr                 *)
(*                                                                          *)
(*   Total number of modules                     : 10                       *)
(*   Total number of global procedures/functions : 34                       *)
(****************************************************************************)
  
(*****************************************************************************)
(* MAIN PROGRAM XPLOT (INPUT,OUTPUT);                                        *)
(*                                                                           *)
(*  This is the main program to generate the xplot. This program is called   *)
(*  after running the front end and a legal PALASM2.TRE is generated. The    *)
(*  following is the functional flow of the program XPLOT.                   *)
(*                                                                           *)
(*  When this program is called, it first goes through an initialistion      *)
(*  routine. This routine initialises the variables and creates a heap       *)
(*  (a linked list structure) of eqnnodeptr type. This is a local heap       *)
(*  created from which an equation tree is created for each equation that    *)
(*  is processed.                                                            *)
(*                                                                           *)
(*  Next, PALASM2.TRE (created by FRONT END), is opened for reading the      *)
(*  file. PALASM2.TRE contains all the information regarding the PDS file    *)
(*  that was processed by the front end.                                     *)
(*                                                                           *)
(*  After opening the TRE file, procedure FORMNODE is called. This procedure *)
(*  will read a particular section of the PALASM2.TRE file which has all     *)
(*  the information about the nodes (input/output pins of the PDS). In the   *)
(*  process of reading this section of the TRE file, a linked list of all    *)
(*  the nodes is created. This list is identified by variable HEADNODELIST.  *)
(*  The headnodelist is a list of all the nodes specified in the CHIP        *)
(*  section (pin list) of the PDS. All the variables are identified by an    *)
(*  identifier token( tk_id), the polarity, name of the identifier, kind     *)
(*  and the pin number. Special pins like VCC and GND are given special      *)
(*  tokens. No connect pins (NC) are omitted from the headnodelist.          *)
(*  Data type used is NODEPTR.                                               *)
(*  This procedure also reads all the relevant information in the HEADER     *)
(*  section of the PDS, like TITLE, PATTERN, etc, and the PDS file name.     *)
(*                                                                           *)
(*  The creation of the headnodelist has formed the first portion of the     *)
(*  database. Next a call to procedure READ_PAL is made. This procedure      *)
(*  opens a PDF file for the PAL device specified in the PDS file. Each PDF  *)
(*  file contains appropriate device information for every device. This      *)
(*  information is stored in arrays. The information  in these arrays is     *)
(*  used by many succeeding procedures for xplot generation, checking of     *)
(*  some conditions, formatting the output and host of other purposes. The   *)
(*  data in these arrays are also modified dynamically. A call to procedure  *)
(*  PHANTOM initialises the XPLOT array with all the information that was    *)
(*  read from the PDF file in READ_PAL procedure.                            *)
(*                                                                           *)
(*  At this junction, headnodeist is created and the device information is   *)
(*  read from the PDF files and stored in an array.                          *)
(*                                                                           *)
(*  Now a call to procedure FORMEQ_SIM is made. This procedure reads  one    *)
(*  equation at a time, reports the user which equation is being processed,  *)
(*  creates an equation tree, calls procedure PLOT to generate xplot  and    *)
(*  then disposes the tree. All the nodes required for the eqn tree are      *)
(*  taken form the local heap generated and given back to the heap when the  *)
(*  equation is disposed. A maximum of 500 tokens is the limit of the number *)
(*  of tokens per equation  (this limit can always be increased). Any time   *)
(*  an error is generated in the process of xplot, the error is reported to  *)
(*  the user and the next equation is processed. This will continue till the *)
(*  last equation is finished. This procedure reads PALASM2.TRE file to      *)
(*  construct one equation at a time. At no time more than one equation is   *)
(*  read at a time. This reduces the dynamic memory requirement and is       *)
(*  in a limited memory environment application like personal computers.     *)
(*  Every time an equation is processed, the ANDARR and ORARR are filled     *)
(*  'X', '-' '0','O'. These are filled by calling procedure WANDARR.         *)
(*                                                                           *)
(*  Once all the equations have been processed, a call to  procedure PRINT   *)
(*  is made. This procedure will print the XPLOT in a user readable format.  *)
(*  The format can be full XPLOT (showing all the used and unused product    *)
(*  terms) or brief xplot (only used product terms) in a file <filename>.xpt *)
(*  All the other information like polarity fuses, flush fuses, product term *)
(*  sharing fuses is also outputed in the same file. Each xplot has all the  *)
(*  relevant information like TITLE, PATTERN, REVISION etc.. specified in    *)
(*  the header declaration of PDS.                                           *)
(*                                                                           *)
(*  The call to JEDEC procedure ouputs the fuse information in JEDEC format  *)
(*  into a file <filename>.jed . This file can then be downloaded into a     *)
(*  programmer to blow the fuses.                                            *)
(*                                                                           *)
(*                                                                           *)
(*  Main program      :  XPLOT                                               *)
(*  Files read        :  PALASM2.TRE, <pal_type>.PDF                         *)
(*  Files written     :  <filename>.xpt, <filename>.jed                      *)
(*  Procedures called :                                                      *)
(*                    :  formnode    -- reads PALASM2.TRE and creates        *)
(*                                      headnodelist                         *)
(*                    :  read_pal    -- reads PDF file                       *)
(*                    :  phantom     -- initialise phantom fuses             *)
(*                    :  formeq_sim  -- reads PALASM2.TRE and builds one     *)
(*                                      equation at time and generates       *)
(*                                      xplot (headeqlist) and disposes that *)
(*                                      equation.                            *)
(*                    :  print       -- prints the xplot in .XPT file        *)
(*                    :  jedec       -- prints the jedec in .JED file        *)
(*                                                                           *)
(*****************************************************************************)
  
(*****************************************************************************)
(* DATA BASE CREATED.(example)                                               *)
(*                                                                           *)
(*   CHIP XX  PAL16R4                                                        *)
(*   CLK NC NC A /B NC NC NC NC GND                                          *)
(*   /OE NC NC NC Y NC NC NC NC VCC                                          *)
(*                                                                           *)
(*   EQUATIONS                                                               *)
(*                                                                           *)
(*       Y := A * B + /A * /B                                                *)
(*                                                                           *)
(*                                                                           *)
(*  headnodelist -->>  CLK ---  A  --- /B --- GND -- /OE -- Y -- VCC         *)
(*                                                                           *)
(*  headeqlist   -->>  tk_eq -- tk_clkeq <<== eqnptr (this is passed to)     *)
(*                                 !                 (procedure PLOT)        *)
(*                                 !                                         *)
(*                                OR(tk_or)                                  *)
(*                                 !                                         *)
(*                                 !                                         *)
(*                                AND(tk_and)-- AND(tk_and)                  *)
(*                                 !             !                           *)
(*                                A - B         /A - /B                      *)
(*****************************************************************************)
  
(* MV - 10/08/86 - Bug #954 - Bug fixing week *) {!! 2  !!}
(* For IBM/PC for opening tre file I needed status.pf  *) {!! 2  !!}
 {!! 3  !!}
{/fnx} {ipp Pragma Include ('STATUS.PF')  ;      ipp} {!! 2  !!}
  
(*  BALA K. Enhc # 743  03/14/86  *)
{vax [INHERIT('pal2$inc:xplotinc.env')] vax}
{/fnx} program xplot(input,output);
{/ipp}{fnx module xpt(input,output); fnx}
  
(* MV bug #954 *) {!! 2  !!}
{/fnx} {ipp With Status ;                        ipp} {!! 2  !!}
{/fnx} {ipp Var E            : TypeOf(ErrNo) ;   ipp} {!! 2  !!}
{/fnx} {ipp     Tre_FileName : String(40)    ;   ipp} {!! 2  !!}
 {!! 2  !!}

#include 'xplotinc.i'


{ipp pragma c_include('XPLOTINC.INC'); ipp}
  
{/fnx} label 1;
  
{/fnx} var qq : integer;
{/fnx}    ch : char;
{INC}
(* MV Bug #886    *) {!! 7  !!}
procedure checkXdataXeqn ; external ; {!! 11 !!}
procedure checkXeqnXdefined ; external ; {!! 10 !!}
procedure checkXv10Xfeedback (nodeXlst:nodeptr) ;external ; {!! 11 !!}
 {!! 7  !!}
(* ENHANCEMENT FOR 32T10. #608. ANAND B. *)
procedure bypassXpt;external;
function matchXid (tempstr1,tempstr2:chstring):boolean;external;
procedure makenode(var newnode:nodeptr);  external;
procedure placenode(var last,present : eqnnodeptr);  external;
procedure makename(p1,p2,p3,p4 : integer);  external;
function expandlist(var dummynode:nodeptr;
         var dummyeqn,locptr:eqnnodeptr):integer;external;
function transname(var present:eqnnodeptr;var lstnode:nodeptr):integer;external;
procedure hookup(var eqnitem : eqnnodeptr);  external;
{dsy procedure formnode(mmi_xpt : xplot_rec_typ);   external;  dsy}
{/dsy} procedure formnode;   external;
procedure formeqXsim;  external;
procedure setparams;  external;
procedure readXpal;external;
procedure createXorlst(eqnptr:eqnnodeptr;var orlst:efflstptr);external;
procedure createXandlst(eqnptr:eqnnodeptr;var andlst:efflstptr);external;
procedure createXxorlst(eqnptr:eqnnodeptr;var xorlst:efflstptr);external;
  
  
procedure check1(var eqnptr:eqnnodeptr);external;
procedure check2(var eqnptr:eqnnodeptr);external;
procedure check3(var eqnptr:eqnnodeptr);external;
procedure check4; external;
procedure check5(var eqnptr:eqnnodeptr);external;
  
procedure increment(var eqnptr:eqnnodeptr);external;
procedure polarity (var eqnptr:eqnnodeptr);external;
procedure prodshare(var eqnptr:eqnnodeptr;horiz:integer);external;
procedure blowfuse (var eqnptr:eqnnodeptr;horiz:integer);external;
procedure product  (var eqnptr:eqnnodeptr;horiz:integer);external;
procedure doXfxplot(var eqnptr:eqnnodeptr;
          setff,resetff,trstff,prldff,clkff:boolean);external;
procedure doXxplot (var eqnptr:eqnnodeptr);external;
procedure doXxxplot(var eqnptr:eqnnodeptr);external;
procedure plot (var eqnptr:eqnnodeptr);external;
procedure print(var pass:integer);external;
procedure jedec;external;
procedure phantom;external;
  
(*  BALA K.  Enhc.  #743  03/26/86  *)
{fnx procedure last_part ; external;  fnx}
  
procedure errcom(var eqnptr:eqnnodeptr; errnum:integer);
begin
(*        write(chr(7),chr(7));  *)
{dsy    writeln(errfile,'ERROR NUMBER : ',errnum:3);           dsy}
{dsy    write(errfile,'PIN          : ');                      dsy}
{dsy    if eqnptr^.child^.node_ptr^.polarity='L' then write(errfile,'/'); dsy}
{dsy    write(errfile,eqnptr^.child^.node_ptr^.name);          dsy}
{dsy    writeln(errfile);                                      dsy}
{/dsy}        writeln('ERROR NUMBER : ',errnum:3);
{/dsy}        write('PIN          : ');
{/dsy}        if eqnptr^.child^.nodeXptr^.polarity='L' then write('/');
{/dsy}        write(eqnptr^.child^.nodeXptr^.name);
{/dsy}        writeln;
end;
  
  
(***********************************************************************)
(* PROCEDURE ERROR (VAR EQNPTR:EQNNODEPTR; ERRNUM:INTEGER)             *)
(*                                                                     *)
(* eqnptr : pointer to the equation in which error is caused.          *)
(* errnum : the type of error caused.                                  *)
(*                                                                     *)
(* There are in total 44 errors caused, which are identified uniquely  *)
(* by a number. Whenever an error is detected during processing a      *)
(* single equation, PROCEDURE ERROR is called. Depending on the type   *)
(* of error identified by the error number, an error message is given  *)
(* to the user on the terminal in a clear format. In some type of      *)
(* errors, the pin name causing the error is also reported.            *)
(* Once an error is caught for an equation, further processing of that *)
(* equation is terminated, and the next equation is processed. Thus    *)
(* this is a multi error reprting scheme.                              *)
(*                                                                     *)
(*  ERROR NUMBER : error number                                        *)
(*  PIN          : <name of the pin where error occured>               *)
(*  ERROR MESSG. : error message explaining the type of error          *)
(*                                                                     *)
(*  All the errors detected are device related errors like extra pins, *)
(*  conflicting use of pins, extra number of product terms etc..       *)
(***********************************************************************)
{ipp PROCEDURE WARNING(PINNUM,WARNNUM : INTEGER);external;ipp}
{vax [GLOBAL] vax}  procedure warning(pinnum,warnnum:integer);
(*                                                                   *)
(*-------------------------------------------------------------------*)
(*                                                                   *)
(*  PROCEDURE : WARNING                                              *)
(*  AUTHOR    : ANAND BEMRA                                          *)
(*  DATE      : 7/15/85                                              *)
(*  FUNCTION  : REPORTS WARNING IF ANY, BUT ALLOWS XPLOT GENERATION. *)
(*                                                                   *)
(*  MODIFICATIONS :                                                  *)
(*    NAME        DATE       DESCRIPTION                             *)
(*    ----------- ---------- ------------------------------------    *)
(*                                                                   *)
(*  COMMENTS  : VERY SIMILAR TO ERROR PROCEDURE. MAIN DIFFERENCE     *)
(*              THAT IT DOES NOT SUPPRESS XPLOT & JEDEC GENERATION.  *)
(*              IT IS A BUG FIX FOR #427.                            *)
(*                                                                   *)
(*  INPUT PARAMETERS :                                               *)
(*                                                                   *)
(*    VARIABLE    TYPE       DESCRIPTION                             *)
(*    ----------- ---------- ------------------------------------    *)
(*    PINNUM     INTEGER     PIN NUMBER FOR WHICH A WARNING OCCURED  *)
(*    WARNNUM    INTEGER     A WARNING NUMBER .                      *)
(*                                                                   *)
  
var
  pinXlistXptr : nodeptr;
  
begin
(* INCREMENT THE WARNING COUNTER *)
  warncount := warncount + 1;
  
(* REACH THE NODE IN HEADNODELIST CONTAINING THE PIN NUMBER *)
  pinXlistXptr := headnodelist;
  while (pinnum <> pinXlistXptr^.pinXnum) do
   pinXlistXptr := pinXlistXptr^.next;
  
(* PRINT WARNING HEADER COMMON TO ALL WARNINGS.  *)
(*      WRITE(CHR(7),CHR(7)); *)
{dsy      WRITELN(errfile,'WARNING NUMBER : ',WARNNUM:3);       dsy}
{dsy        WRITE(errfile,'OUTPUT PIN     : ');                 dsy}
{dsy      IF PIN_LIST_PTR^.POLARITY = 'L' THEN WRITE(errfile,'/');   dsy}
{dsy      WRITELN(errfile,PIN_LIST_PTR^.NAME);                  dsy}
{dsy      WRITE(errfile,'WARNING MESSG. : ');                   dsy}
  
{/dsy}      writeln('WARNING NUMBER : ',warnnum:3);
{/dsy}        write('OUTPUT PIN     : ');
{/dsy}      if pinXlistXptr^.polarity = 'L' then write('/');
{/dsy}      writeln(pinXlistXptr^.name);
{/dsy}      write('WARNING MESSG. : ');
  
(* PRINT SPECIFIC WARNING MESSAGE. *)
  case warnnum of
  
  {dsy   1:  WRITELN(errfile,'CLOCK FOR THIS PIN ASSUMED TO BE GND'); dsy}
  {/dsy}   1:  writeln('CLOCK FOR THIS PIN ASSUMED TO BE GND');
(* MV Bug #886 *) {!! 8  !!}
  {dsy   2:  WriteLn(ErrFile,'Data Equation for above pin not defined');dsy} {!!7!!}
  {/dsy} 2:  writeln(' Data Equation for above pin not defined '); {!! 8  !!}
  
  end;
end;
(*****************************************************************************)
{ipp procedure error(var eqnptr:eqnnodeptr; errnum:integer);external;ipp}
{vax [GLOBAL] vax}  procedure error(var eqnptr:eqnnodeptr; errnum:integer);
  
var temptr1:nodeptr;
    i,j:integer;
    errstr,errblk : packed array [1..15] of char;
 {!! 2  !!}
  
begin
   errorcount := errorcount + 1;
   errstr:='ERROR MESSG. : ';
   errblk:='               ';
 case errnum of
  
   0 : begin
{/dsy}  writeln(errstr,'Unexpected end of input TRE or PAL file, File invalid');
{dsy   writeln(errfile,errstr,                                           dsy}
{dsy   'Unexpected end of input TRE or PAL file, File invalid');         dsy}
  
(*  BALA  K.  Enhc. #743   03/26/86   *)
{/fnx}       goto 1;
{fnx    xplot_return_status:= fnx_prg_stop;    fnx}
  
       end;
  
   1 : begin
 errcom(eqnptr,errnum);
{dsy  writeln(errfile,errstr,'This output is registered but another output of same');dsy}
{dsy  writeln(errfile,errblk,'bank is used as combinatorial.');                 dsy}
{/dsy}  writeln(errstr,'This output is registered but another output of same');
{/dsy}  writeln(errblk,'bank is used as combinatorial.');
       end;
   2 : begin
        errcom(eqnptr,errnum);
{dsy  writeln(errfile,errstr,'This output is combinatorial but another output ofsame');dsy}
{dsy  writeln(errfile,errblk,'bank is used as registered.');                    dsy}
{/dsy} writeln(errstr,'This output is combinatorial but another output of same');
{/dsy} writeln(errblk,'bank is used as registered.');
       end;
   3 : begin
        errcom(eqnptr,errnum);
 {dsy  writeln(errfile,errstr,'This output is a combinatorial but has SET functiondefinened');dsy}
 {/dsy} writeln(errstr,'This output is a combinatorial but has SET function definened');
       end;
  4 : begin
        errcom(eqnptr,errnum);
{dsy writeln(errfile,errstr,'This output is a combinatorial but has RESET functiondefined');dsy}
{/dsy} writeln(errstr,'This output is a combinatorial but has RESET function defined')
      end;
  5 : begin
        errcom(eqnptr,errnum);
(* #608. ANAND B. 11/18/85 *)
{dsy writeln(errfile,errstr,'This output is a combinatorial but has CMBF functiondefined');dsy}
{/dsy} writeln(errstr,'This output is a combinatorial but has SET function defined');
       end;
  6 : begin
        errcom(eqnptr,errnum);
{dsy writeln(errfile,errstr,'This output is a combinatorial but has CLOCK functiondefined');dsy}
{/dsy} writeln(errstr,'This output is a combinatorial but has CLOCK function defined');
       end;
   7 : begin
        errcom(eqnptr,errnum);
{dsy writeln(errfile,errstr,'This output is using more than 8 product terms'); dsy}
{/dsy} writeln(errstr,'This output is using more than 8 product terms');
       end;
  8 : begin
        errcom(eqnptr,errnum);
{dsy        write(errfile,'               ');  dsy}
{/dsy}  write('               ');
        i:=offarr[eqnptr^.child^.nodeXptr^.pinXnum];
        j:=outarr[i].shXpin;
        temptr1:=headnodelist;
        while (temptr1<>nil) and (temptr1^.pinXnum<>j) do
         temptr1:=temptr1^.next;
        if temptr1^.polarity='L' then
       {dsy  write(errfile,'/');  dsy}
       {/dsy}  write('/');
{dsy        writeln(errfile,temptr1^.name);   dsy}
{/dsy}        writeln(temptr1^.name);
{dsy writeln(errfile,errstr,'These outputs are using more than 16 product terms');dsy}
{/dsy} writeln(errstr,'These outputs are using more than 16 product terms');
       end;
   9 : begin
        errcom(eqnptr,errnum);
{dsy writeln(errfile,errstr,'The polarity of the output on the left side of the equation');dsy}
{dsy writeln(errfile,errblk,'should be opposite to the polarity in the pinlist');dsy}
{/dsy} writeln(errstr,'The polarity of the output on the left side of the equation');
{/dsy} writeln(errblk,'should be opposite to the polarity in the pinlist');
  
      end;
  10 : begin
        errcom(eqnptr^.child,errnum);
{dsy  writeln(errfile,errstr,'SET function has more than one product term'); dsy}
{/dsy} writeln(errstr,'SET function has more than one product term');
       end;
  11 : begin
        errcom(eqnptr,errnum);
{dsy writeln(errfile,errstr,'This output is used as a combinatorial but is definedas');dsy}
{dsy writeln(errfile,errblk,'registered output.');                              dsy}
{/dsy} writeln(errstr,'This output is used as a combinatorial but is defined as ');
{/dsy} writeln(errblk,'registered output.');
       end;
  12 : begin
        errcom(eqnptr,errnum);
{dsy writeln(errfile,errstr,'This output is used as registered but'); dsy}
{dsy writeln(errfile,errblk,'is defined as a combinatorial output');  dsy}
{/dsy} writeln(errstr,'This output is used as registered but');
{/dsy} writeln(errblk,'is defined as a combinatorial output');
       end;
  13 : begin
        errcom(eqnptr,errnum);
{dsy        writeln(errfile,errstr,'This output is a registered but'); dsy}
{dsy        writeln(errfile,errblk,'has no CLOCK function defined for it.'); dsy}
{/dsy}        writeln(errstr,'This output is a registered but');
{/dsy}        writeln(errblk,'has no CLOCK function defined for it.');
       end;
  14 : begin
        errcom(eqnptr^.child,errnum);
{dsy     writeln(errfile,errstr,'RESET function has more than 1 product term'); dsy}
{/dsy}        writeln(errstr,'RESET function has more than 1 product term');
       end;
  15 : begin
        errcom(eqnptr^.child,errnum);
{dsy    writeln(errfile,errstr,'TRI STATE function has more than 1 product term');dsy}
{/dsy}        writeln(errstr,'TRI STATE function has more than 1 product term');
       end;
  16 : begin
        errcom(eqnptr^.child,errnum);
{dsy        writeln(errfile,errstr,'CMBF function has more than 1 product term');dsy}
{/dsy}        writeln(errstr,'CMBF function has more than 1 product term');
       end;
  17 : begin
        errcom(eqnptr^.child,errnum);
{dsy        writeln(errfile,errstr,'CLOCK function has more than 1 product term');dsy}
{/dsy}        writeln(errstr,'CLOCK function has more than 1 product term');
       end;
  18 : begin
        errcom(eqnptr,errnum);
{dsy        writeln(errfile,errstr,'This output is using more than 4 product terms');dsy}
{/dsy}        writeln(errstr,'This output is using more than 4 product terms');
       end;
  19 : begin
        errcom(eqnptr,errnum);
{dsy        writeln(errfile,errstr,'This output is using more than 7 product terms');dsy}
{/dsy}        writeln(errstr,'This output is using more than 7 product terms');
       end;
 20 : begin
        errcom(eqnptr,errnum);
{dsy        write(errfile,'               ');   dsy}
{/dsy}        write('               ');
        i:=offarr[eqnptr^.child^.nodeXptr^.pinXnum];
        j:=outarr[i].shXpin;
        temptr1:=headnodelist;
        while (temptr1<>nil) and (temptr1^.pinXnum<>j) do
         temptr1:=temptr1^.next;
        if temptr1^.polarity='L' then 
{dsy        write(errfile,'/');  dsy}
{/dsy}        write('/');
{dsy        writeln(errfile,temptr1^.name);  dsy}
{dsy        writeln(errfile,errstr,'These outputs are using more than 8 product terms');dsy}
{/dsy}        writeln(temptr1^.name);
{/dsy}        writeln(errstr,'These outputs are using more than 8 product terms');
       end;
 21 : begin
        errcom(eqnptr,errnum);
{dsy        write(errfile,'               ');   dsy}
{/dsy}        write('               ');
        i:=offarr[eqnptr^.child^.nodeXptr^.pinXnum];
        j:=outarr[i].shXpin;
        temptr1:=headnodelist;
        while (temptr1<>nil) and (temptr1^.pinXnum<>j) do
         temptr1:=temptr1^.next;
        if temptr1^.polarity='L' then 
{dsy        write(errfile,'/');   dsy}
{/dsy}        write('/');
{dsy        writeln(errfile,temptr1^.name);   dsy}
{dsy        writeln(errfile,errstr,'These outputs are using more than 14 productterms');dsy}
{/dsy}        writeln(temptr1^.name);
{/dsy}        writeln(errstr,'These outputs are using more than 14 product terms');
       end;
 22 : begin
        errcom(eqnptr,errnum);
{dsy  writeln(errfile,errstr,'The polarity of the output on the left side of theequation');dsy}
{dsy  writeln(errfile,errblk,'should be same to the polarity in the pinlist');  dsy}
{/dsy} writeln(errstr,'The polarity of the output on the left side of the equation');
{/dsy} writeln(errblk,'should be same to the polarity in the pinlist');
       end;
 23 : begin
        errcom(eqnptr,errnum);
{dsy        writeln(errfile,errstr,'This output is using more than 2 product terms');dsy}
{/dsy}        writeln(errstr,'This output is using more than 2 product terms');
      end;
 24 : begin
       (* write(chr(7),chr(7)); *)
{dsy        writeln(errfile,'ERROR NUMBER : ',errnum:3);   dsy}
{dsy        write(errfile, 'OUTPUT PIN   : ');   dsy}
{/dsy}        writeln('ERROR NUMBER : ',errnum:3);
{/dsy}        write(  'OUTPUT PIN   : ');
    (* BUG FIX # 293 - ANAND  6/12/85 *)
        if(eqnptr <>nil) then
         if (eqnptr^.nodeXptr <> nil) then
           begin
             if(eqnptr^.nodeXptr^.polarity = 'L') then
{dsy              WRITE(errfile,'/');  dsy}
{/dsy}              write('/');
             if (eqnptr^.nodeXptr^.name[1] <> chr(0))then
{dsy              WRITE(errfile,EQNPTR^.NODE_PTR^.NAME);   dsy}
{/dsy}              write(eqnptr^.nodeXptr^.name);
{dsy             WRITELN(errfile);  dsy}
{/dsy}             writeln;
           end;
  
{dsy        writeln(errfile,errstr,'This output cannot be used as a feedback signal');dsy}
{/dsy}        writeln(errstr,'This output cannot be used as a feedback signal');
      end;
 25 : begin
        errcom(eqnptr,errnum);
{dsy        write(errfile,errstr,'Cannot define a simple/functional equation ');dsy}
{dsy        writeln(errfile,'for an input pin');    dsy}
{/dsy}        write(errstr,'Cannot define a simple/functional equation ');
{/dsy}        writeln('for an input pin');
      end;
 26 : begin
        errcom(eqnptr,errnum);
{dsy        writeln(errfile,errstr,'This output is using more than 3 product terms');dsy}
{/dsy}        writeln(errstr,'This output is using more than 3 product terms');
       end;
 27 : begin
        errcom(eqnptr,errnum);
{dsy        writeln(errfile,errstr,'This output is using more than one xor(:+:) term');dsy}
{/dsy}        writeln(errstr,'This output is using more than one xor(:+:) term');
       end;
 28 : begin
        errcom(eqnptr,errnum);
{dsy        writeln(errfile,errstr,'This output is using more than two product terms',dsy}
{dsy                       ' per one xor term');                                dsy}
{/dsy}  writeln(errstr,'This output is using more than two product terms',' per one xor term');
       end;
  29 : begin
        errcom(eqnptr,errnum);
{dsy    writeln(errfile,errstr,'This output is using more than four product terms',dsy}
{dsy                       ' per one xor term');                                dsy}
{/dsy} writeln(errstr,'This output is using more than four product terms',' per one xor term');
       end;
  30 : begin
        errcom(eqnptr,errnum);
{dsy     writeln(errfile,errstr,'This output is using more than 16 product terms');dsy}
{/dsy}        writeln(errstr,'This output is using more than 16 product terms');
       end;
  31 : begin
{dsy        writeln(errfile);writeln(errfile);      dsy}
{dsy        writeln(errfile,'ERROR NUMBER :',errnum);    dsy}
{dsy        writeln(errfile,errstr,'Pins allowed :', totinp+totout:3);  dsy}
{dsy        writeln(errfile,errblk,'Pins used    :', pin_number:3);    dsy}
{/dsy}        writeln;writeln;
{/dsy}        writeln('ERROR NUMBER :',errnum);
{/dsy}        writeln(errstr,'Pins allowed :', totinp+totout:3);
{/dsy}        writeln(errblk,'Pins used    :', pinXnumber:3);
       end;
  32 : begin
        (*write(chr(7),chr(7)); *)
{dsy        writeln(errfile,'ERROR NUMBER : ',errnum:3);  dsy}
{/dsy}        writeln('ERROR NUMBER : ',errnum:3);
(* BUG FIX #566- ANAND B. 9/10/85 *)
(*      write(  'PIN          : '); *)
  
        (* BUG FIX # 293 - ANAND 6/12/85  *)
(*      IF(EQNPTR<>NIL) THEN
          IF(EQNPTR^.NODE_PTR <>NIL) THEN
           BEGIN
             IF(EQNPTR^.NODE_PTR^.POLARITY = 'L') THEN    WRITE('/');
             IF(EQNPTR^.NODE_PTR^.NAME[1]<>CHR(0)) THEN
                WRITE(EQNPTR^.NODE_PTR^.NAME);
               WRITELN;
           END;
  *)
{dsy        writeln(errfile,errstr,'Undefinable/Unusable pin in this equation');dsy}
{/dsy}        writeln(errstr,'Undefinable/Unusable pin in this equation');
       end;
  
  33 : begin
        errcom(eqnptr,errnum);
{dsy        writeln(errfile,errstr,'Simple/Functional equation already defined');dsy}
{/dsy}        writeln(errstr,'Simple/Functional equation already defined');
       end;
  34 : begin
        errcom(eqnptr^.child,errnum);
{dsy   writeln(errfile,errstr,' Cannot define functional equation for this output');dsy}
{/dsy}        writeln(errstr,' Cannot define functional equation for this output');
       end;
  35 : begin
        (*write(chr(7),chr(7));*)
{dsy        writeln(errfile,'ERROR NUMBER:',errnum:3);  dsy}
{dsy        writeln(errfile,errstr, 'The product term ', horizm-1:3,' cannot be edited');dsy}
{/dsy}        writeln('ERROR NUMBER:',errnum:3);
{/dsy}        writeln(errstr, 'The product term ', horizm-1:3,' cannot be edited');
       end;
  36 : begin
        errcom(eqnptr,errnum);
{dsy    writeln(errfile,errstr,'Pins 23/14 do not have XOR function in PAL20X8');dsy}
{/dsy}        writeln(errstr,'Pins 23/14 do not have XOR function in PAL20X8');
       end;
  37 :begin
       errcom(eqnptr,errnum);
{dsy       writeln(errfile,errstr,'Pins 23/22/21/14/15/16 do not have XOR fnc. inPAL20X4');dsy}
{/dsy}       writeln(errstr,'Pins 23/22/21/14/15/16 do not have XOR fnc. in PAL20X4');
      end;
  38 : begin
        errcom(eqnptr,errnum);
(* #608. ANAND B. 11/18/85 *)
(* BALA K. #743 03/31/86  *)
(* line overflow problems *)
{dsy   writeln(errfile,errstr,'Programmable combinatorial (.CMBF) function not','supported');dsy}
{/dsy} writeln(errstr,'Programmable combinatorial (.CMBF) function not',' supported');
       end;
  39 : begin
{dsy        writeln(errfile);   dsy}
{/dsy}        writeln;(*(Chr(7),Chr(7));*)
{dsy        writeln(errfile,'ERROR NUMBER :', errnum);  dsy}
{dsy        writeln(errfile,errstr,'XNOR (:*:) is not supported in any PAL device');dsy}
{/dsy}        writeln('ERROR NUMBER :', errnum);
{/dsy}        writeln(errstr,'XNOR (:*:) is not supported in any PAL device');
       end;
  40 : begin
{dsy        writeln(errfile);   dsy}      
{/dsy}        writeln;(*(Chr(7),Chr(7));*)
{dsy        writeln(errfile,'ERROR NUMBER :', errnum); dsy}
{dsy        writeln(errfile,errstr,'XOR (:+:) is not a legal operator for non_XorPAL');dsy}
{dsy        writeln(errfile,errblk,'devices for e.g. PAL16R8, PAL20S10 etc. etc..');dsy}
{/dsy}        writeln('ERROR NUMBER :', errnum);
{/dsy}        writeln(errstr,'XOR (:+:) is not a legal operator for non_Xor PAL');
{/dsy}        writeln(errblk,'devices for e.g. PAL16R8, PAL20S10 etc. etc..    ');
       end;
  41 : begin
        errcom(eqnptr,errnum);
{dsy     writeln(errfile,errstr,'The functional equation for this pin is using a');dsy}
{dsy    writeln(errfile,errblk,'registered equation(:=) instead of combinatorial');dsy}
{dsy    writeln(errfile,errblk,'equation (=).                ');   dsy}
{/dsy}        writeln(errstr,'The functional equation for this pin is using a');         
{/dsy}        writeln(errblk,'registered equation(:=) instead of combinatorial');        
{/dsy} writeln(errblk,'equation (=).                     ');
       end;
  42 : begin
{dsy   writeln(errfile);      dsy}
{dsy        writeln(errfile,'ERROR NUMBER :',errnum);   dsy}
{dsy        writeln(errfile,errstr,'PAL16A4 and PAL16X4 are not supported by XPLOT.');dsy}
{/dsy}        writeln;(*(chr(7),chr(7));*)                                      
{/dsy}        writeln('ERROR NUMBER :',errnum);                                 
{/dsy}        writeln(errstr,'PAL16A4 and PAL16X4 are not supported by XPLOT.');
       end;
  43 : begin
{dsy        writeln(errfile);   dsy}
{dsy        writeln(errfile,'ERROR NUMBER :',errnum);  dsy}
{dsy        writeln(errfile,errstr,'PAL16C1 and PAL20C1 cannot have more than one');dsy}
{/dsy}        writeln;(*(chr(7),chr(7));*)                                    
{/dsy}        writeln('ERROR NUMBER :',errnum);                               
{/dsy}        writeln(errstr,'PAL16C1 and PAL20C1 cannot have more than one');
  
        (*     SOFTWARE BUG FIX FOR BUG #285   BY C.J. 6/10/1985  *)
  
{dsy        writeln(errfile,errblk,'equation defined for an output.');   dsy}
    {/dsy} writeln(errblk,'equation defined for an output.');
(*  BALA K.   Enhc.  #743  03/26/86  *)
{/fnx}   goto 1;
{fnx     xplot_return_status := fnx_prg_stop; fnx}
       end;
  44 : begin
{dsy        writeln(errfile);    dsy}
{dsy        writeln(errfile,'ERROR NUMBER :',errnum);                           dsy}
{dsy        writeln(errfile,errstr,'Exceeded the maximum number of tokens used');dsy}
{dsy        writeln(errfile,errblk,'per equation.');    dsy}
{/dsy}        writeln;(*(chr(7),chr(7));*)                                 
{/dsy}        writeln('ERROR NUMBER :',errnum);                            
{/dsy}        writeln(errstr,'Exceeded the maximum number of tokens used');
{/dsy}        writeln(errblk,'per equation.');                             
       end;
  
 (* BUG FIX FOR #324 & 325 - ANAND 6/12/85 *)
  45 : begin
        errcom(eqnptr,errnum);
{dsy        WRITELN(errfile,ERRSTR,'This output is using more than 1 product term');dsy}
{/dsy}  writeln(errstr,'This output is using more than 1 product term');
       end;
  
  (* BUG FIX FOR #351 BY C.J. 6/18 *)
  46 : begin
         errcom(eqnptr,errnum);
{dsy         WRITELN(errfile,ERRSTR,'This output is using more than 6 product terms');dsy}
{/dsy}         writeln(errstr,'This output is using more than 6 product terms');
       end;
(* BUG FIX FOR #366 - ANAND 7/9/85                                     *)
  47 : begin
{dsy          WRITELN(errfile);  dsy}
{dsy          WRITELN(errfile,'ERROR NUMBER : ',ERRNUM:3);  dsy}
{dsy          WRITE(errfile,'PIN          : ');    dsy}

{/dsy}         writeln;
{/dsy}         writeln('ERROR NUMBER : ',errnum:3);
{/dsy}         write('PIN          : ');
         if(eqnptr^.nodeXptr^.polarity = 'L') then
{/dsy} write('/');
{dsy  WRITE(errfile,'/');  dsy}
         i := 1;
         while(eqnptr^.nodeXptr^.name[i] <> chr(0)) do
          begin
{dsy           WRITE(errfile,EQNPTR^.NODE_PTR^.NAME[I]);   dsy}
{/dsy}           write(eqnptr^.nodeXptr^.name[i]);
           i := i + 1;
          end;
{dsy         WRITELN(errfile);       dsy}
{dsy         WRITE(errfile,'ERROR MESSG. : An output pin in the bank of this pinwas');dsy}
{dsy         WRITELN(errfile,'previously used as');  dsy}
{dsy         WRITELN(errfile,errblk,'combinatorial.This pin is now being used asfeedback.');dsy}
{dsy         WRITE(errfile,errblk,'Output pins in combinatorial bank cannot be usedas');dsy}
{dsy         WRITELN(errfile,'feedback.');  dsy}
{/dsy}    writeln;
{/dsy}        write('ERROR MESSG. : An output pin in the bank of this pin was ');
{/dsy}        writeln('previously used as');
{/dsy}        writeln(errblk,'combinatorial.This pin is now being used as feedback.');
{/dsy}        write(errblk,'Output pins in combinatorial bank cannot be used as ');
{/dsy}        writeln('feedback.');
       end;
(* BUG FIX FOR #366 - ANAND 7/9/85                                  *)
   48:
       begin
{dsy     WRITELN(errfile);   dsy}
{dsy         WRITELN(errfile);         dsy}
{dsy         WRITELN(errfile,'ERROR NUMBER : ',ERRNUM:3);     dsy}
{dsy         WRITE(errfile,'PIN          : ');                dsy}

{/dsy}         (*WRITE(CHR(7),CHR(7));*)writeln;
{/dsy}         writeln;
{/dsy}         writeln('ERROR NUMBER : ',errnum:3);
{/dsy}         write('PIN          : ');
         if(eqnptr^.nodeXptr^.polarity = 'L') then
{/dsy}  write('/');
{dsy    WRITE(errfile,'/');  dsy}
         i := 1;
         while(eqnptr^.nodeXptr^.name[i] <> chr(0)) do
          begin
{/dsy}           write(eqnptr^.nodeXptr^.name[i]);
{dsy           WRITE(errfile,EQNPTR^.NODE_PTR^.NAME[I]);  dsy}
           i := i + 1;
          end;
{dsy      WRITELN(errfile);
{dsy      WRITE(errfile,'ERROR MESSG. : An output pin in the bank of this pin was');dsy}
{dsy      WRITELN(errfile,'previously used as');                                dsy}
{dsy      WRITE(errfile,errblk,'feedback. This pin is now being used as ');     dsy}
{dsy      WRITELN(errfile,' combinatorial output.');                            dsy}
{dsy      WRITELN(errfile,errblk,'Output pins used as feedback have to be registered.');dsy}

{/dsy}         writeln;
{/dsy}        write('ERROR MESSG. : An output pin in the bank of this pin was ');
{/dsy}        writeln('previously used as');
{/dsy}        write(errblk,'feedback. This pin is now being used as ');
{/dsy}        writeln(' combinatorial output.');
{/dsy}        writeln(errblk,'Output pins used as feedback have to be registered.');
       end;
  
(* ENHANCEMENT TO INCLUDE 22RX8. ANAND B. 9/4/85  *)
(* USED BY 32T10 PART. 11/11/85 *)
  
  49 : begin
         errcom(eqnptr,errnum);
{dsy     WRITE(errfile,ERRSTR,'Cannot have same polarity and also :+: term in an');dsy}
{dsy     WRITELN(errfile,'equation');                                           dsy}
{/dsy}         write(errstr,'Cannot have same polarity and also :+: term in an ');
{/dsy}         writeln('equation');
       end;
  
  50 :
       begin
        errcom(eqnptr,errnum);
{dsy   WRITE(errfile,ERRSTR,'Only one side of :+: gate can have more than one ');dsy}
{dsy   WRITELN(errfile,'product term');   dsy}
{/dsy}        write(errstr,'Only one side of :+: gate can have more than one ');
{/dsy}        writeln('product term');
       end;
  
(* ENHANCEMENT FOR 32T10 #608. ANAND B. 11/11/85 *)
  51 : begin
         errcom(eqnptr,errnum);
{dsy   WRITELN(errfile,'Product terms already used by external node equation. ');dsy}
{/dsy}         writeln('Product terms already used by external node equation. ');
       end;
  
  52 : begin
         errcom(eqnptr,errnum);
{dsy   WRITELN(errfile,'Product terms already used by internal node equation. ');dsy}
{/dsy}         writeln('Product terms already used by internal node equation. ');
       end;
  
  53 : begin
         errcom(eqnptr,errnum);
{dsy    WRITE(errfile,'A Reg. Eqn. for an output pin must only be in terms of its');dsy}
{dsy    writeln(errfile,' internal node. ');                                    dsy}
{dsy    writeln(errfile,'Use internal node to define registered equations. ');  dsy}
{/dsy}         write('A Reg. Eqn. for an output pin must only be in terms of its');
{/dsy}         writeln(' internal node. ');
{/dsy}         writeln('Use internal node to define registered equations. ');
       end;
  
(* 4/23/86 AMIRAM NEIMAN  ENHANCEMENT #661 *)
  
  54 : begin
         errcom(eqnptr,errnum);
{dsy    writeln(errfile,'TRST equations should be defined only as active high.');dsy}
{/dsy}         writeln('TRST equations should be defined only as active high.');
       end;
  55 : begin
         errcom(eqnptr,errnum);
{dsy      writeln(errfile,'SETF equations should be defined only as active high.');dsy}
{/dsy}         writeln('SETF equations should be defined only as active high.');
       end;
  56 : begin
         errcom(eqnptr,errnum);
{dsy         writeln(errfile,'RSTF equations should be defined only as active high.');dsy}
{/dsy}         writeln('RSTF equations should be defined only as active high.');
       end;
  
(* 8/18/86 Amiram Neiman  ENHANCEMENT #913 *)
  
  57 : begin
         errcom(eqnptr,errnum);
{dsy         writeln(errfile,'ERROR --> SETTING .TRST = GND IN A 32VX10 MEANS THAT');dsy}
{dsy         writeln(errfile,'YOU CANNOT DEFINE THE OUTPUT, SINCE YOU HAVE TURNEDITOFF!');dsy}
{/dsy}         writeln('ERROR --> SETTING .TRST = GND IN A 32VX10 MEANS THAT');
{/dsy}         writeln('YOU CANNOT DEFINE THE OUTPUT, SINCE YOU HAVE TURNED IT OFF!');
       end;
  
(* 4/28/86 Amiram Neiman  BUG #676 *)
  
  58 : begin
         errcom(eqnptr,errnum);
{dsy         writeln(errfile,'GLOBAL is not a valid pin.');    dsy}
{dsy         writeln(errfile,'Proper usage is GLOBAL.RSTF = ... ');  dsy}
{dsy         writeln(errfile,'and             GLOBAL.SETF = ...');    dsy}
{/dsy}         writeln('GLOBAL is not a valid pin.');
{/dsy}         writeln('Proper usage is GLOBAL.RSTF = ... ');
{/dsy}         writeln('and             GLOBAL.SETF = ...');

       end;
  
(* 22V10 MV 07/01/86 - using Xor not allowed for 22V10  *)
  59 : begin
         errcom (eqnptr ,errnum) ;
{dsy         WriteLn (errfile,'Using Xor not allowed for 22V10 part ') ; dsy}
{dsy         WriteLn (errfile);  dsy}
{/dsy}         writeln ('Using Xor not allowed for 22V10 part ') ;
{/dsy}         writeln ;
       end  ;  (* End 22V10 - 59 *)
  
(* 22V10  MV 07/01/86 - errors 60:61 for product terms  *)
(*        used are > specified in pdf file              *)
   60 : begin
          errcom (eqnptr , errnum)   ;
{dsy  WriteLn (errfile,ErrStr , ' This output is using more then 10 product terms');dsy}
{dsy         WriteLn (errfile);  dsy}
{/dsy}          writeln (errstr , ' This output is using more then 10 product terms');
{/dsy}          writeln ;
        end       ; (* end 22V10 - 60  *)

   61 : begin
          errcom (eqnptr , errnum)   ;
{dsy          WriteLn (errfile,ErrStr , ' This output is using more then 12 productterms');dsy}
{dsy         WriteLn (errfile);  dsy}
{/dsy}          writeln (errstr , ' This output is using more then 12 product terms');
{/dsy}          writeln  ;
        end        ; (* end 22V10 - 61  *)
   
    62 : begin
           errcom (eqnptr , errnum) ;
{dsy         WriteLn (errfile,ErrStr ,' This output is using more then 14 productterms');dsy}
{dsy         WriteLn (errfile);  dsy}
{/dsy}           writeln (errstr ,' This output is using more then 14 product terms');
{/dsy}           writeln   ;
         end         ; (* end 22V10 - 62  *)
(* MV 08/19/86 - Bug # 917   *)
    63 :  begin
            errcom  (eqnptr , errnum ) ;
{dsy  WriteLn (errfile,ErrStr , ' Can not use XOR in Tristate equation  ') ; dsy} {!!9!!}
{dsy            WriteLn(errfile); dsy} {!! 9  !!}
{/dsy}        writeln (errstr , ' Can not use XOR in Tristate equation  ') ; {!!9!!}
{/dsy}          writeln  ; {!! 9  !!}
          end        ;  (* end bug # 917  *)

(* MV 10/06/86  - Bug #805 - Bug fixing week *) {!! 2  !!}
    64  :  begin {!! 6  !!}
{dsy             WriteLn  (ErrFile,' This part is not supported yet ') ; dsy} {!!5!!}
{fnx         Xplot_Return_Status   := Fnx_Sys_Err  ;       Fnx} {!! 5  !!}
{/dsy}             writeln  (errstr)   ; {!! 5  !!}
{/dsy}          writeln  (errstr,' This part is not supported yet ') {!! 6  !!}
{fnx         Xplot_Return_Status   := Fnx_Sys_Err  ;       Fnx} {!! 5  !!}
           end        ;  (* End Bug #805 *) {!! 2  !!}
 {!! 2  !!}
(* MV 10/06/86 - Bug #873 - Bug fixing week *) {!! 2  !!}
{/dsy} 65  :  begin {!! 6  !!}
{/dsy}             writeln (errstr,' Above PDF file not found') ; {!! 5  !!}
{/dsy}             writeln           ; {!! 5  !!}
{/dsy}            goto   1          ; {!! 5  !!}
{/dsy}           end                 ; (* End Bug #873 *) {!! 6  !!}

(* MV 10/06/86 - Bug #833 - Bug fixing week  *) {!! 3  !!}
{/dsy} {ipp    66  :  Begin          ipp} {!! 9  !!}
{/dsy} {ipp         WriteLn (ErrStr,'Error Number ',ErrNum) ;     ipp} {!! 9  !!}
{/dsy} {ipp         WriteLn (ErrStr,'On IBM/PC You cannot have file name without');ipp} {!!9!!}
{/dsy} {ipp            WriteLn (ErrStr,'extension  more then 8 characters ') ;ipp} {!!9!!}
{/dsy} {ipp             WriteLn  (ErrStr)  ; ipp} {!! 9  !!}
{/dsy} {ipp             GoTo  1  ;ipp} {!! 9  !!}
{/dsy} {ipp           End        ;ipp} {!! 9  !!}
 {!! 6  !!}
{vax    67  :  Begin       Vax} {!! 5  !!}
{vax            WriteLn (ErrStr,' Error Number ',ErrNum) ;    vax} {!! 5  !!}
{vax            WriteLn (ErrStr,' On vax you cannot have filename without');Vax} {!!5!!}
{Vax            WriteLn (Errstr,' Extension more then 11 characters')  ;  Vax} {!!5!!}
{/dsy} {vax             GoTo  1          ;Vax} {!! 5  !!}
{vax            End   ;Vax} {!! 5  !!}
(* MV 10/09/86 - Bug #997      *) {!! 4  !!}
    68  :   begin {!! 4  !!}
{dsy         WriteLn (Errfile,' Error Number ',ErrNum) ;    dsy} {!! 5  !!}
{dsy         WriteLn (ErrFile,' State Machine syntax is not supported'); dsy} {!!5!!}
{dsy         WriteLn (ErrFile,' by Xplot. Please run Expander Program'); dsy} {!!5!!}
{/dsy}              writeln (errstr,' Error Number ',errnum) ; {!! 6  !!}
{/dsy}              writeln (errstr,' State Machine syntax is not supported'); {!!5!!}
{/dsy}              writeln (errstr,' by Xplot. Please run Expander Program'); {!!5!!}
{fnx             Xplot_return_status := Fnx_Prg_Stop   ;      Fnx} {!! 6  !!}
            end ; (* End Bug #997  *) {!! 4  !!}
 {!! 4  !!}
end;
 {goto 1;}
{dsy   writeln(errfile);  dsy}
{/dsy}  writeln;
  errflag:=true;
  nofile:=true;   { true for no generation of .xpt and .jed files}
end;




  
procedure errcom1(var temptr1:nodeptr; errnum:integer);
begin
    (*write(chr(7),chr(7));*)
{dsy    writeln(errfile,'ERROR NUMBER :',errnum:3); dsy}
{dsy    write  (errfile,'OUTPUT PIN   : ');   dsy}
{dsy    if temptr1^.polarity='L' then write(errfile,'/');    dsy}
{dsy    write(errfile,temptr1^.name);    dsy}
{dsy    writeln(errfile);       dsy}

{/dsy}    writeln('ERROR NUMBER :',errnum:3);
{/dsy}    write  ('OUTPUT PIN   : ');
{/dsy}    if temptr1^.polarity='L' then write('/');
{/dsy}    write(temptr1^.name);
{/dsy}    writeln;

end;
  
{ipp procedure error1 (pinnumb,errnum:integer);external; ipp}
{vax [GLOBAL] vax} procedure error1 (pinnumb,errnum:integer);
  
var temptr1:nodeptr;
    errstr,errblk : packed array [1..15] of char;
  
begin
   errorcount := errorcount + 1;
   errstr:='ERROR MESSG. : ';
   errblk:='               ';
  
temptr1:=headnodelist;
while temptr1^.pinXnum<>pinnumb do temptr1:=temptr1^.next;
  
case errnum of
  
        3 : begin
            errcom1(temptr1,errnum);
{dsy writeln(errfile,errstr,'This output is combinatorial but has SET function defined');dsy}
{/dsy} writeln(errstr,'This output is combinatorial but has SET function defined');
            end;
        4 : begin
            errcom1(temptr1,errnum);
{dsy writeln(errfile,errstr,'This output is combinatorial but has RESET functiondefined');dsy}
{/dsy} writeln(errstr,'This output is combinatorial but has RESET function defined');
            end;
        5 : begin
            errcom1(temptr1,errnum);
(* ENHANCEMENT FOR 32T10 #608. ANAND B. 11/18/85 *)
{dsy writeln(errfile,errstr,'This output is combinatorial but has CMBF function defined');dsy}
{/dsy} writeln(errstr,'This output is combinatorial but has CMBF function defined');
            end;
        6 : begin
            errcom1(temptr1,errnum);
{dsy writeln(errfile,errstr,'This output is combinatorial but has CLOCK functiondefined');dsy}
{/dsy} writeln(errstr,'This output is combinatorial but has CLOCK function defined');
            end;
        13 : begin
            errcom1(temptr1,errnum);
{dsy writeln(errfile,errstr,'This output is registered but has no CLOCK functiondefined');dsy}
{/dsy} writeln(errstr,'This output is registered but has no CLOCK function defined');
            end;
(* SOFTWARE BUG FIX FOR BUG #350 BY C.J. 6/25/85    *)
        50: begin
            errcom1(temptr1,errnum);
{dsy   WRITELN(errfile,ERRSTR,'Token gnd is not defined correctly in pin list');dsy}
{/dsy}            writeln(errstr,'Token gnd is not defined correctly in pin list');
            end;
        51: begin
            errcom1(temptr1,errnum);
   {dsy   writeln(errfile,errstr,'Token vcc is not defined correctly in pin list');dsy}
{/dsy}            writeln(errstr,'Token vcc is not defined correctly in pin list');
            end;
     end;
 {goto 1;}
{dsy  writeln;  dsy}
 {/dsy} writeln;
 errflag:=true;
 nofile:=true;      { true for no generation of .xpy and .jed files}
end;

(* For God's sake, initial all global variables at the beginning *)
{dsy  procedure init; external;   dsy}
{dsy  procedure  init;  dsy}
{dsy  var  dsy}
{dsy   i, j : integer;  dsy}

{dsy begin  dsy}
{dsy   screen := FALSE;  dsy}
{dsy   for i := 14 to 23 do PRODUCT_TERMS_USED[i] := false;  dsy}
{dsy   for i := 1 to max_out do  dsy}
{dsy     begin  dsy}
{dsy       feedback[i] := -1;   dsy}
{dsy       error_reported[i] := false;  dsy}
{dsy     end;  dsy}
{dsy   ofset:=0; reg_eqn := false;  warncount := 0;  dsy}
{dsy   errorcount := 0;  vccflag := false;  gndflag := false;  dsy}
{dsy   brieflg := false;  errflag := false;  nofile := false;  dsy}
{dsy   eqfrst := nil;  eqlast := nil;  orlst1 := nil;  dsy}
{dsy   for i := 1 to index do namex[i] := ' ';   dsy}
{dsy   FREE_LST_ST:=nil; FREE_LST_EN:=nil; ORLST:=nil; stacktopptr:=nil;  dsy}
{dsy   stack := nil;  headnodelist := nil;  headeqlist := nil;  dsy}
{dsy   headsimlist := nil;  fuses := 0;  fnx_pdf_len := 0;  dsy}
{dsy   contextx := NOD;  dsy}
{dsy   for i:=1 to 6 do for j:=1 to dblen do dbstr[i][j]:=chr(0);  dsy}
{dsy   pin_number := 0;  errnum := 0;  start := 0;  dsy}
{dsy   horizm := 0; horiz := 0;  dsy}
{dsy   switch_pol := false;  dsy}
{dsy   for i:=1 to max_hor do for j:=1 to 2 do orarr[i][j]:=chr(0);  dsy}
{dsy   for i:=1 to (max_inp+max_out) do locarr[i]:=0;  dsy}
{dsy   for i:=1 to max_out do  dsy}
{dsy     with outarr[i] do  dsy}
{dsy     begin  dsy}
{dsy       max:=0; start:=0; current:=0; total:=0;  dsy}
{dsy       sh_pin:=0;link:=0; orindex:=0;  dsy}
{dsy       polarity:=0; rbp:=0; ps:=0; up_down:=0;  dsy}
{dsy       setf:=0; resetf:=0; trstf:=0; prldf:=0;  dsy}
{dsy       clkf:=0; polf:=0; setp:=0; resetp:=0;  dsy}
{dsy       trstp:=0; prldp:=0; clkp:=0;  dsy}
{dsy       kind:=0;  dsy}
{dsy     end;  dsy}
{dsy   for i:=1 to (max_inp+max_out) do offarr[i]:=0;  dsy}
{dsy   for i := 1 to maxflush do flarr[i] := 0;  dsy}
{dsy   for i := 1 to max_hor do  dsy}
{dsy     begin  dsy}
{dsy       skip[i] := 0;  pharr[i] := 0;  dsy}
{dsy       pharr1[i] := 0;  pharr2[i] := 0;  dsy}
{dsy     end;  dsy}
{dsy   totinp := 0;  totout := 0;  totfuse := 0;  dsy}
{dsy   totprod := 0;  totvert := 0;  phantom1 := 0;  dsy}
{dsy   totph := 0;  totph1 := 0;  totph2 := 0;  dsy}
{dsy   rbp := 0;  ps := 0;  polf := 0;  dsy}
{dsy   ii := 0;  jj := 0;  dsy}
{dsy   for i := 1 to 8 do binarr[i] := 0;  dsy}
{dsy   for i:=1 to 4 do  dsy}
{dsy     begin  dsy}
{dsy       tchksumarr[i]:=chr(0);  dsy}
{dsy       fchksumarr[i]:=chr(0);  dsy}
{dsy     end;  dsy}
{dsy   tchksum := 0;  tchksmh := 0;  fchksum := 0;  dsy}
{dsy   binptr := 0; andlst := nil; fchksmh:=0;  dsy}
{dsy end;   dsy}

(*  BALA K. Enhc # 743  03/14/86  *)
  
{/ipp} {fnx [GLOBAL] fnx}
{fnx  function  xplot; fnx}
{fnx  var     qq            : integer;               fnx}
{dsy  label  999;   dsy}
  
begin
{fnx  xplot := fnx_prg_active; fnx}
{fnx  xplot_return_status := fnx_ret_ok; fnx}
{dsy init; dsy}   (* initial global variables ** Larry Lin ** 7-09-86 *)  
(*  open  errfile  *)
{/dsy} {fnx if not openfile (output,mmi_xpt.errfile_loc,mmi_xpt.errfile_len,NEWFILE)thenfnx}
{/dsy} {fnx xplot_return_status := fnx_sys_err;  fnx}
{dsy  if not openfile (errfile,mmi_xpt.errfile_loc,mmi_xpt.errfile_len,NEWFILE) thendsy}
{dsy     begin                                                    dsy}
{dsy       xplot_return_status := fnx_sys_err;                    dsy}
{dsy       goto 999                                               dsy}
{dsy     end;                                                     dsy}
{dsy   if (mmi_xpt.errfile_len = 0) then screen := TRUE;          dsy}
  
  errflag:=false;    { No error at the start of the program. This flag is}
                     { set true when an error is detected in an equation }
                     { and is reset to false at the start of the next equation}
  nofile :=false;    { this flag is set true, as soon as the first error is }
                     { detected and no .xpt and .jed files are created}
  
  
  (* SOFTWARE BUG FIX FOR BUG #??? BY C.J. 7/12 *)
  
   freeXlstXst := nil;
   freeXlstXen := nil;
  
{dsy  WRITELN(errfile);      dsy}
{dsy  WRITELN (errfile,'PALASM XPLOT, V2.22 - MARKET RELEASE (11-19-86)'); dsy}
{dsy  WRITELN (errfile,'(C) - COPYRIGHT MONOLITHIC MEMORIES INC, 1986');    dsy}
{dsy  WRITELN(errfile);               dsy}
  
{/dsy} writeln;
{/dsy} writeln ('PALASM XPLOT, V2.22 - MARKET RELEASE (11-19-86)');
{/dsy} writeln ('(C) - COPYRIGHT MONOLITHIC MEMORIES INC, 1986');
{/dsy} writeln;
(* MV 10/08/86  - Bug #954 Bug fixing week    *) {!! 2  !!}
(* Amazing . 2 years and no one reported this bug ??????  *) {!! 8  !!}
  
{/fnx} {opening PALASM2.TRE for reading}
{/fnx} {vax  open(specstre,'PALASM2.TRE',history := readonly, vax} {!! 8  !!}
{/fnx} {vax            sharing := readonly,error := continue) ; Vax} {!! 7  !!}
{/fnx} {vax  If Status (Specstre)  <> 0 Then          Vax} {!! 8  !!}
{/fnx} {vax  Begin                                    Vax} {!! 8  !!}
{/fnx} {vax    WriteLn ('Cannot find Palasm2.tre file') ; Vax} {!! 2  !!}
{/fnx} {vax    WriteLn ('Please run Palasm2 front end') ; vax} {!! 2  !!}
{/fnx} {vax    ErrorCount  :=  ErrorCount + 1           ; vax} {!! 2  !!}
{/fnx} {vax    GoTo 1                                   ; vax} {!! 2  !!}
{/fnx} {vax   End  ;                                      vax} {!! 2  !!}
 {!! 2  !!}
 {!! 2  !!}
(* MV bug #954 - for IBM/PC only   *) {!! 2  !!}
 {!! 2  !!}
{/fnx} {ipp  Tre_FileName  := 'PALASM2.TRE';   ipp} {!! 2  !!}
{/fnx} {ipp  Return_IO_Status   :=  True   ;   ipp} {!! 2  !!}
{/fnx} {ipp  Reset (Specstre,Tre_FileName) ;   ipp} {!! 2  !!}
{/fnx} {ipp  Return_IO_Status   :=  False  ;   ipp} {!! 2  !!}
{/fnx} {ipp  E   :=   ErrNo                ;   ipp} {!! 2  !!}
{/fnx} {ipp     if E  <> No_Error_Occurred  Then   ipp} {!! 2  !!}
{/fnx} {ipp     Begin                          ipp} {!! 2  !!}
{/fnx} {ipp       WriteLn (' Cannot find Palasm2.tre file ');   ipp} {!! 2  !!}
{/fnx} {ipp       WriteLn (' Please run Palasm2 front end ');   ipp} {!! 2  !!}
{/fnx} {ipp       ErrorCount  :=  ErrorCount + 1            ;   ipp} {!! 2  !!}
{/fnx} {ipp       Goto 1   ;                   ipp} {!! 2  !!}
{/fnx} {ipp     End        ;                   ipp} {!! 2  !!}
 {!! 2  !!}
 reset(specstre, 'PALASM2.TRE'); 
  
(*  BALA  K.  Enhc.  #743  03/26/86   *)
  
(* open infile *)
{fnx if not openfile (specstre,mmi_xpt.infile_loc,mmi_xpt.infile_len,OLDFILE) thenfnx}
{dsy     begin     dsy}
{fnx xplot_return_status := fnx_sys_err;  fnx}
{dsy     writeln(errfile,'Error - Invalid PDS-TRE file setup');   dsy}
{dsy     goto 999                                                 dsy}
{dsy    end;                                                      dsy}
  
{fnx if xplot_return_status = fnx_ret_ok then begin fnx}
        contextx := nod;
{/dsy}        formnode;          { form list of all nodes, headnodelist}
{dsy     formnode(mmi_xpt);    dsy}
{fnx end; fnx}
  
{fnx if xplot_return_status = fnx_ret_ok then begin  fnx}
{fnx    fnx_pdf_name := mmi_xpt.pdffile_loc; fnx}
{fnx    fnx_pdf_len  := mmi_xpt.pdffile_len; fnx}
        readXpal;
{fnx end; fnx}
  
{fnx if xplot_return_status = fnx_ret_ok then   fnx}
        phantom;
  
{fnx if xplot_return_status = fnx_ret_ok then   begin fnx}
        contextx := equ;
        formeqXsim;
{fnx end; fnx}
(* MV Bug #886 - for 20RA10 - If data eqn. not used issue warning *) {!! 7  !!}
        if palXtype = pX20ra10 then {!! 7  !!}
           checkXdataXeqn {!! 10 !!}
        else if (palXtype = pX22v10) or (palXtype = pX22rx8) then {!! 10 !!}
           checkXeqnXdefined ; {!! 10 !!}
(* MV 22V10 - Bug for feedback *) {!! 11 !!}
       if palXtype = pX22v10 then {!! 11 !!}
          checkXv10Xfeedback (headnodelist); {!! 11 !!}
  
{fnx if xplot_return_status = fnx_ret_ok then begin fnx}
  
   check4;            { check for some conditions}
(* ENHANCEMENT #608. ANAND B. 11/11/85 *)
(* BALA K. #641 01/13/86 *)
   if (palXtype = pX32vx10) then
     bypassXpt;
  
  { if no errors are detected,  than the xplot is outputed to .XPT file}
  { and jedec is outputed to .JED file.                                }
  
   if (not nofile) then
   begin
   ii:=1;
{/dsy}   while (ii<=index) and (xptfile[ii]<>' ') do
{/dsy}   ii:=ii+1;
{/dsy}   if ii> index then {!! 3  !!}
{/dsy}            writeln('ERROR IN FILE NAME')
{/dsy}  else
{/dsy}           begin
{/dsy}            xptfile[ii]:='.';
{/dsy}            xptfile[ii+1]:='X'; {!! 8  !!}
{/dsy}            xptfile[ii+2]:='P'; {!! 8  !!}
{/dsy}            xptfile[ii+3]:='T'; {!! 8  !!}
{/dsy}        {ipp set_length(xptfile,ii+3); ipp}
{/dsy}            jedfile[ii]:='.';
{/dsy}            jedfile[ii+1]:='J'; {!! 8  !!}
{/dsy}            jedfile[ii+2]:='E'; {!! 8  !!}
{/dsy}            jedfile[ii+3]:='D'; {!! 8  !!}
{/dsy}        {ipp set_length(jedfile,ii+3); ipp}
{/dsy}
{/dsy}          writeln;
{dsy               WRITELN(errfile);       dsy}
  
(*   BALA  K.  Enhc.  #743   03/26/86   *)
  
        {/fnx} {vax  open(f1,xptfile); vax}
        {/fnx} {ipp rewrite(f1,xptfile); ipp}
         rewrite(f1,xptfile); 
  
(* open xplot file *)
        {fnx if not openfile (f1,mmi_xpt.xptfile_loc,mmi_xpt.xptfile_len,NEWFILE)thenfnx}
{dsy     begin     dsy}
        {fnx xplot_return_status := fnx_sys_err;  fnx}
{dsy     writeln(errfile,'Error - Invalid XPLOT file setup');     dsy}
{dsy     goto 999                       dsy}
{dsy     end;                           dsy}
  
        writeln (f1,'PALASM XPLOT, V2.22 - MARKET RELEASE (11-19-86)');
        writeln (f1,'(C) - COPYRIGHT MONOLITHIC MEMORIES INC, 1986');
        qq:=1; print(qq);
  
(*   BALA  K.  Enhc.  #743   03/26/86   *)
{/dsy}        {/fnx}   writeln('The fuseplot is stored in ===>',xptfile);
  {dsy   writeln(errfile,'The fuseplot is stored in ===>',mmi_xpt.xptfile_loc); dsy}
{/dsy}        {fnx  writeln('The fuseplot is stored in ===>',mmi_xpt.xptfile_loc);fnx}
  
  
{ A varix format fuse info. is generated for PAL64R32}
        if (totvert=128) then begin
{/dsy}            xptfile[ii+1]:='V'; {!! 8  !!}
{/dsy}            xptfile[ii+2]:='R'; {!! 8  !!}
{/dsy}            xptfile[ii+3]:='X'; {!! 8  !!}
{dsy            xptfile := mmi_xpt.xptfile_loc;       dsy}
{dsy            if (xptfile[mmi_xpt.xptfile_len-2]='V') and dsy}
{dsy            (xptfile[mmi_xpt.xptfile_len-1]='R') and dsy}
{dsy            (xptfile[mmi_xpt.xptfile_len]='X') dsy}
{dsy            then dsy}
{dsy            begin dsy}
{dsy            xptfile[mmi_xpt.xptfile_len-2]:='v';  dsy}
{dsy            xptfile[mmi_xpt.xptfile_len-1]:='r';  dsy}
{dsy            xptfile[mmi_xpt.xptfile_len]:='x';    dsy}
{dsy            end else dsy}
{dsy            begin dsy}
{dsy            xptfile[mmi_xpt.xptfile_len-2]:='V'; dsy}
{dsy            xptfile[mmi_xpt.xptfile_len-1]:='R'; dsy}
{dsy            xptfile[mmi_xpt.xptfile_len]:='X'; dsy}
{dsy            end; dsy}

(*   BALA  K.  Enhc.  #743   03/26/86   *)
  
{/dsy}        {/fnx } {ipp set_length(xptfile,ii+3); ipp}
        {/fnx}  {vax  open(f1,xptfile); vax}
        {/fnx}  {ipp rewrite(f1,xptfile); ipp}
         rewrite(f1,xptfile); 

{dsy  if not openfile(f1,mmi_xpt.xptfile_loc,mmi_xpt.xptfile_len,NEWFILE) then  dsy}
{dsy    begin    dsy}
{dsy     xplot_return_status := fnx_sys_err;   dsy}
{dsy     writeln(errfile,'Error - in open .VRX file');   dsy}
{dsy     goto 999;   dsy}
{dsy    end;   dsy}  
  
        writeln (f1,'PALASM XPLOT, V2.22 - MARKET RELEASE (11-19-86)');
        writeln (f1,'(C) - COPYRIGHT MONOLITHIC MEMORIES INC, 1986');
          qq:=2;  print(qq);
{dsy      writeln(errfile,'The VARIX output is stored in ===>',xptfile);  dsy}
{/dsy}          writeln('The VARIX output is stored in ===>',xptfile);
        end;
  
(*   BALA  K.  Enhc.  #743   03/26/86   *)
  
        {/fnx} {vax  open(f2,jedfile); vax}
        {/fnx} {ipp rewrite(f2,jedfile); ipp}
         rewrite(f2,jedfile); 
  
(*  open jedec file *)
        {fnx if not openfile (f2,mmi_xpt.jedfile_loc,mmi_xpt.jedfile_len,NEWFILE)thenfnx}
{dsy  begin    dsy}
        {fnx xplot_return_status := fnx_sys_err;  fnx}
{dsy            writeln(errfile,'ERROR - Invalid JEDEC file setup');  dsy}
{dsy            goto 999           dsy}
{dsy         end;                  dsy}
  
        writeln (f2,'PALASM XPLOT, V2.22 - MARKET RELEASE (11-19-86)');
        writeln (f2,'(C) - COPYRIGHT MONOLITHIC MEMORIES INC, 1986');

(* 22V10 MV 07/08/86 - if paltype is 22v10 do not generate jedec *)
(*                     until first silicon is available          *)
{int if pal_type <> P_22V10 then int}
          jedec;

(*  BALA  K.  Enhc.  #743   03/26/86   *)
        {/fnx}  writeln('The jedec is stored in    ===>',jedfile);
{dsy   writeln(errfile,'The jedec is stored in    ===>',mmi_xpt.jedfile_loc); dsy}
{/dsy}       {fnx writeln('The jedec is stored in    ===>',mmi_xpt.jedfile_loc);fnx}
         end;
  
(*  BALA K.  Enhc. #743   03/26/86   *)
{/dsy} {fnx end;  fnx}
   end;
{fnx  last_part;   fnx}
{dsy   999:   dsy}
{fnx  xplot := xplot_return_status; fnx}
{dsy   if not screen then  close (errfile);  dsy}
{/dsy}  {fnx close (output); fnx}
{/dsy}  {fnx rewrite (output,'con'); fnx}
{fnx  end;         fnx}
  
{fnx  procedure last_part ; fnx}
{/fnx}  1: begin
{/fnx}    end;
{fnx   begin   fnx}
  
(*BUG FIX #427 - ANAND B. 7/15/85 *)
if (errorcount > 0) or (warncount > 0) then
 begin
{dsy   WRITELN(errfile);   dsy}
{dsy     WRITE(errfile,' %%% XPLOT %%% ERROR COUNT = ',ERRORCOUNT:3,';'); dsy}
{dsy     WRITELN(errfile,' WARNING COUNT = ',WARNCOUNT:3,';',' FILE = ',DESIGN_FILE);dsy}
{dsy     WRITELN(errfile);  dsy}
{/dsy}   writeln;
{/dsy}   write(' %%% XPLOT %%% ERROR COUNT = ',errorcount:3,';');
{/dsy}   writeln(' WARNING COUNT = ',warncount:3,';',' FILE = ',designXfile);
{/dsy}   writeln;
{fnx if warncount > 0 then xplot_return_status := fnx_prg_warn fnx}
{fnx else xplot_return_status := fnx_prg_error; fnx}
 end
else
{fnx if xplot_return_status = fnx_ret_ok then fnx}
 begin
{dsy  WRITELN(errfile);   dsy}
{/dsy}   writeln;
{dsy   WRITELN(errfile,' %%% XPLOT %%% FILE PROCESSED SUCCESSFULLY : ',DESIGN_FILE);dsy}
{/dsy}   writeln(' %%% XPLOT %%% FILE PROCESSED SUCCESSFULLY : ',designXfile);
{/dsy}   writeln;
 {dsy   WRITELN(errfile); dsy}
 end;
  
{fnx end;  fnx}
{/fnx} end.
 {!! 4  !!}
 {!! 6  !!}
