{**  DEC/CMS REPLACEMENT HISTORY, Element XM5.SRC **}
{**  *6     9-FEB-1987 22:28:14 VORA "fixed bug for 22rx8 and 22v10 - added procedure"**}
{**  *5     6-NOV-1986 09:38:26 PALASM2 "Check_Data_Eqn should have been declaredexternal"**}
{**  *4     6-NOV-1986 08:40:34 PALASM2 "Check_Data_Eqn declared twice for pc. Oneremoved"**}
{**  *3    29-OCT-1986 17:17:52 VORA " fixed bug #886 " **}
{**  *2    28-OCT-1986 12:24:03 VORA " fixed bug #886" **}
{**  *1     3-OCT-1986 15:13:29 PALASM2 "" **}
{**  DEC/CMS REPLACEMENT HISTORY, Element XM5.SRC **}
(************************************************************************)
(* This module contains the following proceudres                        *)
(*  procedure Check_Data_Eqn                                            *) {!! 2!!}
(*  procedure check1, procedure check2, procedure check3                *)
(*  procedure check5, procedure increment.                              *)
(************************************************************************)
{ipp program m5; ipp}
{ipp pragma c_include('XPLOTINC.INC'); ipp}
{/ipp}{vax [INHERIT('pal2$inc:xplotinc.env')] module m5[PUBLIC]; vax}


#include 'xplotinc.i'

(* MV Bug #886  *) {!! 2 !!}
procedure warning (pinnum,warnum : integer ) ; external         ; {!! 2 !!}

procedure error (var eqnptr:eqnnodeptr; errnum:integer);external;
(***********************************************************************) {!! 2 !!}
(*                                                                     *) {!! 2 !!}
(*  Procedure Check_Data_Eqn ;                                         *) {!! 2 !!}
(*                                                                     *) {!! 2 !!}
(*  This Procedure given a pointer to Headnodelist checks if data      *) {!! 2 !!}
(*  Equation is defined for it.If not issues warning                   *) {!! 2 !!}
(*                                                                     *) {!! 2 !!}
(***********************************************************************) {!! 2 !!}
 {!! 2 !!}
 {!! 2 !!}
{ipp   Procedure Check_Data_Eqn ; external;    ipp} {!! 5 !!}
{Vax[Global] Vax} procedure checkXdataXeqn ; {!! 3 !!}
  var {!! 3 !!}
    tempXheadlist     :   nodeptr ;(* Temp Pointer to Headnodelist     *) {!! 2 !!}
                                   (* for Traversing purpose           *) {!! 2 !!}
  begin {!! 2 !!}
    tempXheadlist     :=  headnodelist     ; {!! 2 !!}
    while tempXheadlist <> nil do {!! 2 !!}
    begin {!! 4 !!}
      if((tempXheadlist^.kind = d)or(tempXheadlist^.kind= r)) and {!! 2 !!}
         (tempXheadlist^.pinXnum in [14..23]) then {!! 2 !!}
      begin {!! 2 !!}
        if (tempXheadlist^.eqnptr = nil)and(tempXheadlist^.uXsetf<>nil)and {!! 3!!}
           (tempXheadlist^.uXresetf<>nil) then {!! 3 !!}
           warning (tempXheadlist^.pinXnum,2)   ; {!! 2 !!}
      end   ; {!! 2 !!}
      tempXheadlist   := tempXheadlist^.next     ; {!! 2 !!}
    end     ; (* End While   *) {!! 2 !!}
 {!! 2 !!}
 end        ; (* End Of Procedure Check_Data_Eqn    *) {!! 2 !!}
 {!! 2 !!}
 {!! 3 !!}
 {!! 3 !!}
 {!! 2 !!}
 {!! 6 !!}
 {!! 6 !!}
(***********************************************************************) {!! 6 !!}
(*                                                                     *) {!! 6 !!}
(*  Procedure Check_eqn_defined ;                                      *) {!! 6 !!}
(*                 Only for 22V10 or 22RX8 PAL only                    *) {!! 6 !!}
(*  This Procedure given a pointer to Headnodelist checks if data      *) {!! 6 !!}
(*  Equation is defined for it.If not it defaults to combinatorial     *) {!! 6 !!}
(*                                                                     *) {!! 6 !!}
(***********************************************************************) {!! 6 !!}
 {!! 6 !!}
{ipp   Procedure Check_eqn_defined ; external;    ipp}  {!! 6 !!}
{Vax[Global] Vax} procedure checkXeqnXdefined ; {!! 6 !!}
  var  {!! 6 !!}
    tempXheadlist     :   nodeptr ;(* Temp Pointer to Headnodelist     *)  {!! 6!!}
    lowerXpinnum,upperXpinnum : integer ; {!! 6 !!}
    pinXnumber        :   integer       ; {!! 6 !!}
  begin  {!! 6 !!}
    if palXtype = pX22v10 then {!! 6 !!}
    begin {!! 6 !!}
      upperXpinnum    :=  23    ; {!! 6 !!}
      lowerXpinnum    :=  14    ; {!! 6 !!}
    end  {!! 6 !!}
    else  {!! 6 !!}
    begin {!! 6 !!}
      upperXpinnum    :=  22    ; {!! 6 !!}
      lowerXpinnum    :=  15    ; {!! 6 !!}
    end ; {!! 6 !!}
    pinXnumber        :=  upperXpinnum - lowerXpinnum  + 1 ; {!! 6 !!}
    tempXheadlist     :=  headnodelist     ;  {!! 6 !!}
    while tempXheadlist <> nil do {!! 6 !!}
    begin  {!! 6 !!}
      if (tempXheadlist^.pinXnum in [lowerXpinnum..upperXpinnum]) then {!! 6 !!}
      begin  {!! 6 !!}
        if (tempXheadlist^.eqnptr = nil)  then {!! 6 !!}
           outarr[pinXnumber].rbp  :=  1  ;(* Make it combinatorial *) {!! 6 !!}
        pinXnumber := pinXnumber - 1 ; {!! 6 !!}
      end ; {!! 6 !!}
      tempXheadlist   := tempXheadlist^.next     ; {!! 6 !!}
    end     ; (* End While   *) {!! 6 !!}
 {!! 6 !!}
 end        ; (* End Of Procedure Check_Data_Eqn    *)  {!! 6 !!}
 {!! 6 !!}
 {!! 6 !!}
 {!! 6 !!}
 {!! 6 !!}
(***********************************************************************)
{ PROCEDURE CHECK1:                                                     }
{  This procedure resolves the conflict of register bypass fuse and     }
{  catches any conflict. The following are the various conditions       }
{  under which error can occur.                                         }
{  .rbp field = -2 means the register does not have bypass fuse         }
{  .rbp field = -1 means the register does have bypass fuse             }
{  .rbp field =  0 -- 'x'                                               }
{  .rbp filed =  1 -- '-'                                               }
{                                                                       }
{   error 1: the output is registered and has bypass fuse and one of    }
{            the output in that bank of registers is comb.              }
{                                                                       }
{   error 2: the output is combinatorial and has bypass fuse and one    }
{            of the output in that bank of registers is register        }
{                                                                       }
{   calling procedure: do_xplot                                         }
{   variable passed  : pointer to the equation.                         }
(***********************************************************************)
{ipp procedure check1 (var eqnptr:eqnnodeptr);external; ipp}
{vax [GLOBAL] vax}  procedure check1 (var eqnptr:eqnnodeptr);

var pinnumb,offset,j,j1 : integer;
    errflag:boolean;

  procedure setXrbpXfield;
(* ENHANCEMENT FOR 22RX8 - ANAND B. 9/4/85 *)
(* ENHANCEMENT FOR 20LH8, #607 - ANAND B. 10/16/85 *)
(*                                                                   *)
(*-------------------------------------------------------------------*)
(*                                                                   *)
(*  PROCEDURE : SET_RBP_FIELD                                        *)
(*  AUTHOR    : ANAND BEMRA                                          *)
(*  DATE      : 9/4/85                                               *)
(*  FUNCTION  : FOR REG. EQN. RBP FIELD IS SET TO 0, FOR COMB. EQN.  *)
(*              RBP FIELD IS SET TO 1.                               *)
(*                                                                   *)
(*  MODIFICATIONS :                                                  *)
(*    NAME        DATE       DESCRIPTION                             *)
(*    ----------- ---------- ------------------------------------    *)  
(*                                                                   *)
(*  COMMENTS  :                                                      *)
(*                                                                   *)
(*  INPUT PARAMETERS :                                               *)
(*                                                                   *)
(*    VARIABLE    TYPE       DESCRIPTION                             *)
(*    ----------- ---------- ------------------------------------    *)
(*                                                                   *)
    begin
(* 22V10 MV 07/01/86 - 22V10 added *)
     if (palXtype in [pX22rx8,pX22v10]) then
      begin
      if eqnptr^.kind = tkXclkeq then
       outarr[offset].rbp := 0
      else if eqnptr^.kind = tkXasseq then
       outarr[offset].rbp := 1;
      end
(* BALA K. #653 01/13/86 *)
     else if palXtype = pX10h20g8 then
       begin
          if eqnptr^.kind = tkXclkeq then
            outarr[offset].rbp := 0
          else if eqnptr^.kind = tkXasseq then
            outarr[offset].rbp := 1;
       end;
    end;
       

begin
 pinnumb:= eqnptr^.child^.nodeXptr^.pinXnum;
 offset := offarr[pinnumb];
(* ENHANCEMENT FOR 22RX8 - ANAND B. 9/4/85 *)
(* ENHANCEMENT FOR 20LH8,#607 - ANAND B. 10/16/85 *)
(* LINK DOES NOT MAKE SENSE SINCE EACH OUTPUT CAN BE INDENPENDENTLY BYPASSED*)

(* BALA K. #653 01/13/86 *)
(* 22V10 MV 07/01/86 - 22V10 added *)
if (palXtype in [pX22rx8,pX10h20g8,pX22v10]) then
  setXrbpXfield
else
 begin

 if (outarr[offset].rbp<>-2) then
  begin
   if eqnptr^.kind=tkXclkeq then
    begin
    j1:=outarr[offset].link;
    j:=outarr[offset].link;
    errflag:= false;
    while (j1<>outarr[offarr[j]].link) and (not errflag)  do
     begin
      if    outarr[offarr[j]].rbp=1
      then  errflag:=true
      else
       begin                        { chnages made by Imtiyaz}
        outarr[offarr[j]].rbp:=0;
        j:=outarr[offarr[j]].link;
       end;
     end;
    if errflag then error(eqnptr,1)
               else outarr[offset].rbp:=0;
   end
  else
   begin
    j:=outarr[offset].link;
    j1:=outarr[offset].link;
     errflag:= false;
      while (j1<>outarr[offarr[j]].link) and (not errflag)  do
       begin
        if     outarr[offarr[j]].rbp=0
         then  errflag:=true
         else
          begin                        { changes made by Imtiyaz}
            outarr[offarr[j]].rbp:=1;
            j:=outarr[offarr[j]].link;
          end;
       end;
     if errflag then error(eqnptr,2)
               else outarr[offset].rbp:=1; { dash }
    end;
 end;
end;
end;

(******************************************************************)
{ PROCEDURE CHECK2:                                                }
{  This procedure checks for functionality conflicts.              }
{                                                                  }
{    If (eqn is comb) and (the output has no function) and         }
{     the (output is declared as registered) then error 11.        }
{                                                                  }
{    if (eqn is comb) and (the output has function) and            }
{       (u_setf eqn is not default to 'VCC' then error 3           }
{    same for u_resetf,u_clkf,u_prldf: error 4,5,6                 }
{                                                                  }
{    if (eqn is registered) and (the output is declared comb)      }
{        then error 12.                                            }
{                                                                  }
{    if (eqn is registered) and (the output has function) and      }
{       (the u_clkf is nil) then report error 13                   }
{                                                                  }
{    calling procdure: do_xplot                                    }
{    variable passed : pointer to the equation.                    }
(******************************************************************)
{ipp procedure check2(var eqnptr:eqnnodeptr);external; ipp}
{vax [GLOBAL] vax}  procedure check2(var eqnptr:eqnnodeptr);

var pinnumb,offset: integer;
    temptr1:eqnnodeptr;

begin
 pinnumb:= eqnptr^.child^.nodeXptr^.pinXnum;
 offset := offarr[pinnumb];
 temptr1:=eqnptr^.child;
 if eqnptr^.kind=tkXasseq then
 begin
(* ENHANCEMENT #608. ANAND B. 11/11/85 *)
(* BALA K. #641 01/13/86 *)
  if palXtype = pX32vx10 then
    if (outarr[offset].kind =1) then error(eqnptr,11);
  if (outarr[offset].setf=0)
  and(outarr[offset].resetf=0)
  and(outarr[offset].clkf=0)
  and(outarr[offset].prldf=0)
   then
    begin
      if (outarr[offset].kind=1) then error(eqnptr,11)  {1 is registered}
    end;                                                 {0 is combinatorial}
   {else
    begin
      if (temptr1^.node_ptr^.u_setf<>nil) then
       begin
        if (temptr1^.rsibling^.kind<>tk_id)
         then error(eqnptr,3)
         else
           if (temptr1^.rsibling^.node_ptr^.name<>'VCC            ')
            then error(eqnptr,3);
        end;
      if (temptr1^.node_ptr^.u_resetf<>nil) then
       begin
        if (temptr1^.rsibling^.kind<>tk_id)
         then error(eqnptr,4)
         else
           if (temptr1^.rsibling^.node_ptr^.name<>'VCC            ')
            then error(eqnptr,4);
        end;
      if (temptr1^.node_ptr^.u_clkf<>nil) then
       begin
        if (temptr1^.rsibling^.kind<>tk_id)
         then error(eqnptr,5)
         else
           if (temptr1^.rsibling^.node_ptr^.name<>'VCC            ')
            then error(eqnptr,5) else error(eqnptr,5);
        end;
      if (temptr1^.node_ptr^.u_prldf<>nil) then
       begin
        if (temptr1^.rsibling^.kind<>tk_id)
         then error(eqnptr,6)
         else
           if (temptr1^.rsibling^.node_ptr^.name<>'VCC            ')
            then error(eqnptr,6);
        end;
    end;}
  end;
 if (eqnptr^.kind=tkXclkeq) then
  begin
   if (outarr[offset].kind=0) and (outarr[offset].clkf=0)
     then error(eqnptr,12);                            {1 is registered}
  end;
end;

(***************************************************************)
{ PROCEDURE CHECK3:                                             }
{ This procedure checks for the maximum number of product terms }
{ available for a particular output or a pair of outputs. If the}
{ number exceeds the max available, then it reports error.      }
{                                                               }
{     error number 7 : for a single output with no sharing, the }
{                      total is greater than 8 (max)            }
{     error number 8 : for a pair of output with sharing, the   }
{                      total is greater than 16 (max)           }
{     error number 18: for a single output the total is         }
{                      greater than 4 (max)                     }
{     error number 19: for a single output, greater than 7      }
{     error number 20: for a pair of output,grater than 8       }
{     error number 21: for a pair of output, greate than 14     }
{     error number 23: for a single output, greater than 2      }
{     error number 26: for a single output, greater than 3      }
{     error number 30: for a single output, greater than 16     }
{     ERROR NUMBER 45: FOR A SINGLE OUTPUT, GREATER THAN 1      } 
{     calling procedure : procedure do_xplot                    }
{     variable passed : pointer to the equation (eqnptr)        }
(***************************************************************)
{ipp procedure check3 (var eqnptr:eqnnodeptr);external; ipp}
{vax [GLOBAL] vax}  procedure check3 (var eqnptr:eqnnodeptr);

var pinnumb,offset:integer;

begin
 pinnumb:=eqnptr^.child^.nodeXptr^.pinXnum;
 offset :=offarr[pinnumb];      { offset reference in the out_arr}
with outarr[offset] do begin
 if shXpin = 0 then        { the output does not share }
  begin
   if total >= max then   { greater than max }
   if max = 8 then error(eqnptr,7)
   else if max = 4 then error(eqnptr,18)
   else if max = 7 then error(eqnptr,19)
   else if max = 2 then error(eqnptr,23)
   else if max = 3 then error(eqnptr,26)
   else if max =16 then error(eqnptr,30) 
(* 22V10 MV 07/01/86 - for this part , following else structure  *)
(* was needed                                                    *)
   else if max =10 then error(eqnptr,60) 
   else if max =12 then error(eqnptr,61)
   else if max =14 then error(eqnptr,62) 
   

   (* SOFTWARE BUG FIX FOR BUG #351 BY C.J. 6/19 *)
   else if max = 6 then error(eqnptr,46) 

   (* BUG FIX #324 & 325 - ANAND 6/12/85 *)
   else if max = 1 then error(eqnptr,45);
  end
else
  if total                  { shared output }
   + outarr[offarr[shXpin]].total >= max
    then if max=16 then error(eqnptr,8)
    else if max=8  then error(eqnptr,20)
    else if max=14 then error(eqnptr,21);
 end;
end;


(**********************************************************************)
(* PROCEDURE CHECK5 (VAR EQNPTR:EQNNODEPTR)                           *)
(*                                                                    *)
(* This procedure reports all the errore (22 and 9) for PAL16C1 and   *)
(* PAL20C1.                                                           *)
(**********************************************************************)
{ipp procedure check5(var eqnptr:eqnnodeptr);external; ipp}
{vax [GLOBAL] vax} procedure check5(var eqnptr:eqnnodeptr);
             
begin
  with eqnptr^.child^ do begin
  if palXtype=pX16c1 then if nodeXptr^.pinXnum=16 then
     if state<>nodeXptr^.polarity then error(eqnptr,22);
  if palXtype=pX16c1 then if nodeXptr^.pinXnum=15 then
     if state=nodeXptr^.polarity then error(eqnptr,9);
  if palXtype=pX20c1 then if nodeXptr^.pinXnum=19 then
     if state<>nodeXptr^.polarity then error(eqnptr,22);
  if palXtype=pX20c1 then if nodeXptr^.pinXnum=18 then
     if state=nodeXptr^.polarity then error(eqnptr,9);
 end;
end;

(*****************************************************************)
(* PROCEDURE INCREEMENT (VAR  EQNPTR:EQNNODEPTR);                *)
(*                                                               *)
(* eqnptr -- pointer to the equation.                            *)
(*                                                               *)
(* This procedure increments or decrements the product term by   *)
(* one depending on the .up_down field of the out_arr. If that   *)
(* is 1 the increment and if -1 than decrement. In PALs with     *)
(* product term sharing, the top output of the pair has product  *)
(* term going from top to bottom (incrementing) and for the      *)
(* bottom output, the count is decrementing.                     *)
(*                                                               *)
(* The procedure changes the .current field of the out_arr for   *)
(* the output pin under consideration.                           *)
(*****************************************************************) 
{ipp procedure increment(var eqnptr:eqnnodeptr);external; ipp}
{vax [GLOBAL] vax}  procedure increment(var eqnptr:eqnnodeptr);

var pinnumb,offset : integer;

begin
 pinnumb:=eqnptr^.child^.nodeXptr^.pinXnum;
 offset :=offarr[pinnumb];
 with outarr[offset] do begin
   if (palXtype=pX20x10) and (current mod 4 = 0) then 
   current:=current+4;
   if upXdown = 1 then current:=current+1; 
   if upXdown = 0 then current:=current-1;
   total:= total+1;
 end;
end;
