{**  DEC/CMS REPLACEMENT HISTORY, Element XM4.SRC **}
{**  *4    10-OCT-1986 15:24:28 VORA "Have Pizza and go home" **}
{**  *3    10-OCT-1986 11:43:39 VORA "fixed bug #991" **}
{**  *2     8-OCT-1986 13:59:06 VORA "fixed bug #949,885" **}
{**  *1     3-OCT-1986 15:13:22 PALASM2 "" **}
{**  DEC/CMS REPLACEMENT HISTORY, Element XM4.SRC **}
(***********************************************************************)
(* This module has the following procedures:                           *)
(*                                                                     *)
(* procedure plot,  procedure prodshare, proceudre blowfuse,           *)
(* procedure product, procedure do_fxplot, procedure do_xplot          *)
(* procedure do_xxplot, proceudre plot.                                *)
(***********************************************************************)
{ipp program m4q; ipp}
{ipp pragma c_include('XPLOTINC.INC'); ipp}
{/ipp}{vax [INHERIT('pal2$inc:xplotinc.env')] module m4q[PUBLIC]; vax}


#include 'xplotinc.i'


function  randarr(var ix,jx:integer):char; external;
procedure wandarr(var ix,jx:integer; var  xch:char); external;

procedure jedec;external;
procedure print;external;
procedure readXpal;external;
procedure initialise; external;
procedure increment(var eqnptr:eqnnodeptr);external;
procedure check1(var eqnptr:eqnnodeptr);external;
procedure check2(var eqnptr:eqnnodeptr);external;
procedure check3(var eqnptr:eqnnodeptr);external;
procedure check5(var eqnptr:eqnnodeptr);external;
procedure createXandlst(eqnptr:eqnnodeptr; var andlst:efflstptr);external;
procedure createXorlst(eqnptr:eqnnodeptr;var orlst:efflstptr);external;
procedure createXxorlst(eqnptr:eqnnodeptr;var xorlst:efflstptr);external;
procedure error (var eqnptr:eqnnodeptr; errnum:integer);external;

(* SOFTWARE BUG FIX FOR BUG #??? BY C.J. 7/12 *)
procedure killXlst(var tempnode:efflstptr);external;


var gndflg,vccflg,idflg:boolean;
{ipp PROCEDURE BYPASS_PT;external;ipp}
{vax [GLOBAL] vax}  procedure bypassXpt;
(*                                                                   *)
(*-------------------------------------------------------------------*)
(*                                                                   *)
(*  PROCEDURE : BYPASS_PT                                            *)
(*  AUTHOR    : ANAND BEMRA                                          *)
(*  DATE      : 11/11/85                                             *)
(*  FUNCTION  : BLOWS FUSES TENTATIVELY FOR A REG. EQN.              *)
(*              CAN BE OVERIDDEN BY .CMBF FUNCTION.                  *)
(*                                                                   *)
(*  MODIFICATIONS :                                                  *)
(*    NAME        DATE       DESCRIPTION                             *)
(*    ----------- ---------- ------------------------------------    *)  
(*                                                                   *)
(*  COMMENTS  :                                                      *)
(*                                                                   *)
(*  INPUT PARAMETERS :                                               *)
(*                                                                   *)
(*    VARIABLE    TYPE       DESCRIPTION                             *)
(*    ----------- ---------- ------------------------------------    *)
(*     FDEF       CHAR       USED FOR '-' IN XPLOT                   *)
(*OUTPUT_PIN_NUMB SUBRANGE   EXTERNAL NODE NUMBERS.                  *)
(*HORIZ,J,Y       INTEGER    USED FOR ACCESSING ANDARR               *)

 const
  lowerXoutputXpinnumb = 14;
  upperXoutputXpinnumb = 23;
 var
  fdef : char;
  outputXpinXnumb : 14..23;
  horiz,j,y : integer;
 begin

   fdef := dash;
   for outputXpinXnumb := lowerXoutputXpinnumb to upperXoutputXpinnumb do
     begin

(* MV Bug #990 - 10/10/86 - Bug fixing week   *) {!! 4 !!}
(* If .Trst= Gnd used and also Output = P.T or Output.Cmbf = P.t *) {!! 4 !!}
(* illegal and issue error.                                      *) {!! 4 !!}
 {!! 4 !!}
        if (outarr[offarr[outputXpinXnumb]].trstf =4) and  {!! 4 !!}
           (outarr[offarr[outputXpinXnumb]].total <>0) then {!! 4 !!}
        begin {!! 4 !!}
             errorcount  := errorcount + 1 ; {!! 4 !!}
             writeln (' Error Number ' ,'57') ; {!! 4 !!}
             writeln (' Output Pin Number',outputXpinXnumb) ; {!! 4 !!}
             writeln (' In 32VX10 you cannot have .TRST = GND and ') ; {!! 4 !!}
             writeln (' Also Output = P.T                         ') ; {!! 4 !!}
        end  {!! 4 !!}
        else if (outarr[offarr[outputXpinXnumb]].trstf =4)and {!! 4 !!}
                (outarr[offarr[outputXpinXnumb]].rbp = -2)then {!! 4 !!}
        begin {!! 4 !!}
          errorcount  := errorcount + 1   ; {!! 4 !!}
          writeln (' Error Number ','57') ; {!! 4 !!}
          writeln (' Output Pin Number ',outputXpinXnumb) ; {!! 4 !!}
          writeln (' In 32VX10 you cannot have .TRST =GND and ') ; {!! 4 !!}
          writeln (' Also .CMBF function  for same pin')  ; {!! 4 !!}
        end ; {!! 4 !!}
 {!! 4 !!}
(* MV 10/10/86 - End Bug #990   *) {!! 4 !!}
 {!! 4 !!}
(* SKIP IF .CMBF FUNCTION IS DEFINED ALREADY *)
       if (outarr[offarr[outputXpinXnumb]].rbp <>-2) then

        begin
          if (outarr[offarr[outputXpinXnumb]].rbp =1) then
           begin
             horiz := outarr[offarr[outputXpinXnumb]].prldp;
             for j := 1 to totvert do
              begin
               y := j;
               wandarr(horiz,y,fdef);
               fuses := fuses + 1;
              end;
(* 7/3/1986 A. Neiman BUG #801 *)
              okXtoXblowXptXfuses[horiz]:= false;
           end;
         end;
       end; 
    end;

(*************************************************************************)
(* PROCEDURE POLARITY (VAR EQNPTR:EQNNODEPTR)                            *)
(*                                                                       *)
(* eqnptr -- pointer to the equation to be xplotted.                     *)
(*                                                                       *)
(* This procedure determines  whether the polarity fuse is to be blown   *)
(* or not. First it determines  the pin number of the output and then    *)
(* determines from the .polf field of the outarr of the output, whether  *)
(* this device is active low or active high device.                      *)
(*                                                                       *)
(* The variable 'polf' identifies whether the device has a polarity fuse *)
(* or not. If polf = 1 then the device has the polarity fuse and polf=0  *)
(* otherwise.This variable is given the value from the PDF file.         *)
(*                                                                       *)
(* If the device is active high .plof = 1 then if the device does not    *)
(* have polarity fuse and the signals are of opposite polarities, report *)
(* error 22, else blow th fuse or leave intact.                          *)
(*                                                                       *)
(* If the device is active low .polf = 0 and if the device does not have *)
(* polarity fuse (polf =0) and the signals are of same polarities, report*)
(* error 9, else blow the fuse or leave intact.                          *)
(*************************************************************************)
{ipp procedure polarity (var eqnptr:eqnnodeptr);external; ipp}
{vax [GLOBAL] vax}  procedure polarity (var eqnptr:eqnnodeptr);

var pinnumb,offset:integer;
    temptr1:eqnnodeptr;
begin
 pinnumb:=eqnptr^.child^.nodeXptr^.pinXnum;
 offset:=offarr[pinnumb];
 temptr1:=eqnptr^.child;
 if outarr[offset].polf=1
 then
  begin
   { the device  does not have polarity fuse and the device is active high}
   { if polarities are different, report error 22                         }
   if (polf = 0)and( ((temptr1^.state='L')and(temptr1^.nodeXptr^.polarity='H'))
                  or((temptr1^.state='H')and(temptr1^.nodeXptr^.polarity='L')))
    then error(eqnptr,22);  
   { polarity fuse exists, blow or leave intact}
   if ((temptr1^.state='L')and(temptr1^.nodeXptr^.polarity='H'))
    or((temptr1^.state='H')and(temptr1^.nodeXptr^.polarity='L'))
     then outarr[offset].polarity := 1   { dash}
     else outarr[offset].polarity := 0;  { cross}
  end
 else
  begin
  {device does not have polarity fuse and the device is active low}
  { then if the polarities are same, then report error 9.         }
  if (polf=0) and( ((temptr1^.state='L')and(temptr1^.nodeXptr^.polarity='L'))
                  or((temptr1^.state='H')and(temptr1^.nodeXptr^.polarity='H')))
    then error(eqnptr,9);
  {polarity fusee exists, then blow o leave intact}
  if ((temptr1^.state='L')and(temptr1^.nodeXptr^.polarity='L'))
   or((temptr1^.state='H')and(temptr1^.nodeXptr^.polarity='H'))
   then outarr[offset].polarity := 1 {dash}
   else outarr[offset].polarity := 0 {cross}
  end
end;

(***************************************************************************)
(* PROCEDURE PRODSHARE (VAR EQNPTR:EQNNODEPTR; HORIZ:INTEGER)              *)
(*                                                                         *)
(*  eqnptr -- pointer to the quation                                       *)
(*  horiz  -- the current product term (in andarr)under process.           *)
(*                                                                         *)
(*  This procedure determines which fuse in the or array is to be blown.   *)
(*  Orarry is a two dimensional array which is initialised to all fuses    *)
(*  intact. For every output pin, the outarr.orindex fieeld is either      *)
(*  filled with 0 (no product term sharing for the output), 1 (if the      *)
(*  output is connected to the first or gate), 2(if the output is connected*)
(*  to the second or gate). This values are initialied form the PDF file.  *)
(*                                                                         *)
(*  When the product term is to be used for the first time, the fuses in   *)
(*  the orarry are blown, depending upon the value in the .orindex field.  *)
(*                                                                         *)
(*  Some devices like PAL20RS4 have only one orarray fuse for some outputs *)
(*  in which case, the the second file in the orarray is filled with blank.*)
(***************************************************************************)
{ipp procedure prodshare (var eqnptr:eqnnodeptr;horiz:integer);external; ipp}
{vax [GLOBAL] vax}  procedure prodshare (var eqnptr:eqnnodeptr;horiz:integer);

var pinnumb,offset:integer;

 begin
  pinnumb:=eqnptr^.child^.nodeXptr^.pinXnum;
  offset:=offarr[pinnumb];
  if outarr[offset].orindex>0 then  { the output has orarray fuses}
   begin
    if (orarr[horiz,1]=cross) and (orarr[horiz,2]=cross) {first time use check}
     then
      begin
       orarr[horiz,outarr[offset].orindex] := dash;   { blow the fuse}
       fuses:=fuses+1;
      end;
    end
   else
     begin
      orarr[horiz,2]:=' ';      { certain outputs have only one }
      end;
 end;                           { fuse in or array }

(***************************************************************************)
(* PROCEDURE BLOWFUSE (VAR EQNPTR:EQNNODEPTR; HORIZ:INTEGER)               *)
(*                                                                         *)
(* eqnptr -- the current node under consideration                          *)
(* horiz  -- the current product term in use.                              *)
(*                                                                         *)
(* This procedure blows all the unwanted fuses and leaves those fuses      *)
(* intact as required by the node pointed by the eqnptr.                   *)
(*                                                                         *)
(* At first it is determined, whether the current product term is used for *)
(* the first time or not. If the product term is used for the first time   *)
(* than all the fuses ('X') in the product term are blown.                 *)
(*                                                                         *)
(* Next, the vertical location of the fuse for the id node pointed by the  *)
(* eqnptr is fetched from the locarr (read from the PDF file). If an       *)
(* inversion is required, than the vert number is incremented. At this     *)
(* instant we have the horiz loacation (horiz) and the vertical location   *)
(* (vert), and a fuse ('X') is inserted in that location in the andarr. The*)
(* fuse number is decreased by one.                                        *)
(*                                                                         *)
(* If the id is VCC then vccflg is set true                                *)
(* If the id is GND then gndflg is set true                                *)
(* if the id is plain then idflg is set true.                              *)
(*                                                                         *)
(* If the vertical location in locarr is 0, then it means that the id node *)
(* cannot be used in the equation, e.g. special pins like GND,VCC,some pins*)
(* do not have feedbacks etc.., and an error 32 is reported.               *)
(*                                                                         *)
(* The use of the three flags will described in procedure product.         *)
(***************************************************************************)
{ipp procedure blowfuse(var eqnptr:eqnnodeptr;horiz:integer);external; ipp}
{vax [GLOBAL] vax}  procedure blowfuse(var eqnptr:eqnnodeptr;horiz:integer);

var pinnumb,offset,vert,i:integer;
     ix,iy,iy1,iy2 : integer; fdef : char;

begin

pinnumb:=eqnptr^.nodeXptr^.pinXnum;
offset :=offarr[pinnumb];
vert:=locarr[pinnumb];   { the vertical location is always for true signal}
                         { the vertical loc for complement is +1 }
if eqnptr^.kind = tkXvcc then vccflg:=true;  { VCC signal}
if eqnptr^.kind = tkXgnd then gndflg:=true;  { GND signal}
if eqnptr^.kind = tkXid then                 { plain id}
 begin
  if locarr[pinnumb]=0 then error(eqnptr,32); { illegal use of signal}
  idflg:=true;
  ix:=horiz; fdef:=dash;
  iy1:=vert; iy2:=vert+1;                                      
  if (randarr(ix,iy1)=cross) and (randarr(ix,iy2)=cross) then  { blow all the }
   begin                                                       { fuses if the }
    for i:=1 to totvert do                                     { product term }
     begin                                                     { is used for  }
      iy:=i;                                                   { the first    }
      if ((randarr(ix,iy)<>'O')and(randarr(ix,iy)<>'0')) then  { time.        }
       begin
        wandarr(ix,iy,fdef);
        fuses:=fuses+1;
       end;
     end;
(* 7/3/1986 A. Neiman BUG #801 *)
     okXtoXblowXptXfuses[ix]:= false;
    end;
    if ((eqnptr^.state='L') and (eqnptr^.nodeXptr^.polarity='H'))  { checking }
      or((eqnptr^.state='H') and (eqnptr^.nodeXptr^.polarity='L')) { for      }
     then vert:=vert+1;                                            { inversion}
     ix:=horiz; iy:=vert; fdef:=cross; wandarr(ix,iy,fdef);
     fuses:=fuses-1;
   end;
end;


(****************************************************)
(* This is a redundant procedure                    *)
(****************************************************)
{ipp procedure blowfuse1(var eqnptr:eqnnodeptr;horiz:integer);external; ipp}
procedure blowfuse1(var eqnptr:eqnnodeptr;horiz:integer);
var pinnumb,offset,vert,i:integer;
     ix,iy,iy1,iy2 : integer; fdef : char;
begin
pinnumb:=eqnptr^.nodeXptr^.pinXnum;
offset :=offarr[pinnumb];
vert:=locarr[pinnumb];   { the vertical location is always for true signal}
                         { the vertical loc for complement is +1 }
{if (eqnptr^.kind=tk_vcc) and (andlst<>nil)
then vccflag:=true;
if (eqnptr^.kind=tk_gnd) and (andlst<>nil)
then gndflag:=true;}
if (eqnptr^.kind=tkXvcc) and (not vccflag) and (not gndflag)
 then
  begin
{%%%   if (andarr[horiz,1]=cross) and (andarr[horiz,2]=cross)%%%}
ix:=horiz; iy1:=1; iy2:=2;
if (randarr(ix,iy1)=cross) and (randarr(ix,iy2)=cross)
    then
     begin
      ix:=horiz; fdef:=dash; for i:=1 to totvert do
       begin
        iy:=i;
        if ((randarr(ix,iy)<>'0')and(randarr(ix,iy)<>'O')) then
        begin
        {%%%     andarr[horiz,i]:=dash;%%%} iy:=i; wandarr(ix,iy,fdef);
        fuses:=fuses+1;
        end;
       end;
(* 7/3/1986 A. Neiman BUG #801 *)
        okXtoXblowXptXfuses[ix]:= false;
     end;
   end;
if (eqnptr^.kind<>tkXgnd)
and(eqnptr^.kind<>tkXvcc)
then begin
if locarr[pinnumb]=0 then error (eqnptr,32);
{%%% if (andarr[horiz,vert]=cross) and (andarr[horiz,vert+1]=cross)%%%}
ix:=horiz; iy:=vert; iy1:=vert+1;
if (randarr(ix,iy)=cross) and (randarr(ix,iy1)=cross)
 then
  begin
    ix:=horiz; fdef:=dash; for i:=1 to totvert do
    begin
    iy:=i;
    if ((randarr(ix ,iy)<>'0')and(randarr(ix,iy)<>'O')) then
     begin  
         {%%%     andarr[horiz,i]:=dash;%%%} iy:=i; wandarr(ix,iy,fdef);
     fuses:=fuses+1;
     end;
    end;
(* 7/3/1986 A. Neiman BUG #801 *)
    okXtoXblowXptXfuses[ix]:= false;
  end;
end;
if (eqnptr^.kind=tkXgnd) and (not vccflag) and (not gndflag)
  then
   begin
    ix:=horiz; fdef:=cross; for i:=1 to totvert do
     begin
       {%%%      if andarr[horiz,i]=dash then fuses:=fuses-1;%%%}
       {%%%      andarr[horiz,i]:= cross;%%%}
       iy:=i; if randarr(ix,iy)=dash then fuses:=fuses-1;
       wandarr(ix,iy,fdef);
     end;
(* 7/3/1986 A. Neiman BUG #801 *)
    okXtoXblowXptXfuses[ix]:= false;
   end
 else if (eqnptr^.kind <> tkXvcc)and(not vccflag)and(not gndflag)  then
   begin
    if ((eqnptr^.state='L') and (eqnptr^.nodeXptr^.polarity='H'))
     or((eqnptr^.state='H') and (eqnptr^.nodeXptr^.polarity='L'))
        then  vert:=vert+1;
        {%%%    andarr[horiz,vert] := cross;%%%}
        ix:=horiz; iy:=vert; fdef:=cross; wandarr(ix,iy,fdef);
    fuses:=fuses-1;
   end;
end;

(*************************************************************************)
(* PROCEUDRE PRODUCT (VAR EQNPTR:EQNNODEPTR; HORIZ:INTEGER)              *)
(*                                                                       *)
(* eqnptr -- pointer to a part of the eqn tree.                          *)
(* horiz  -- current product term in use.                                *)
(*                                                                       *)
(*  -- tk_clkeq                                                          *)
(*      !                                                                *)
(*      Y --  OR                                                         *)
(*            !                                                          *)
(*           AND -- AND   <<== eqnptr                                    *)
(*            !      !                                                   *)
(*           A - B  /A - AND                                             *)
(*                        !                                              *)
(*                        C - /B                                         *)
(*                                                                       *)
(* This procedure is called with a part of a tree as shown in the fig.   *)
(* Now a list of 'and gates' is created (two gates in the figure). Then  *)
(* for each id attached to the 'and gate', the fuses in the product term *)
(* pointed by horiz, is left intact. (three  fuses for /A, C and /B) are *)
(* left intact in the above figure. This is done by calling procedure    *)
(* blowfuse for every id.                                                *)
(*                                                                       *)
(* If only gndflg is true, the produc term is grounded.                  *)
(* If only vccflg is true, then all fuses are blown.                     *)
(* If vccflg and gndflg are true , then the product term is to be edited *)
(* i.e. the orarray fuses are to be blown. If no orarray is present than *)
(* error 35 is reported.                                                 *)
(*************************************************************************)
{ipp procedure product(var eqnptr:eqnnodeptr;horiz:integer);external; ipp}
{vax [GLOBAL] vax}  procedure product(var eqnptr:eqnnodeptr;horiz:integer);

var temptr1,temptr2,junk:eqnnodeptr;
    (* SOFTWARE BUG FIX FOR BUG # ??? BY C.J. 7/18  *)
    tempand : efflstptr;

    ix,iy,i:integer;
    fdef:char;

begin

 andlst:=nil;
 createXandlst(eqnptr,andlst);
 
(* SOFTWARE BUG FIX FOR BUG #??? BY C.J. 7/18 *) 
tempand := andlst;

 if andlst<>nil then
  begin                 { one or more and gates}
   blowfuse (andlst^.eqn^.child,horiz);           { id C in the fig.}
   blowfuse (andlst^.eqn^.child^.rsibling,horiz); {id /B in the fig.}
   andlst:=andlst^.next;
   while andlst<>nil do
    begin
     blowfuse(andlst^.eqn^.child,horiz);          { id /A in the fig.}
     andlst:=andlst^.next;
    end;
  end
  else blowfuse(eqnptr,horiz);                    {only one id }
if (vccflg) and (gndflg) then  { produc term editing}
 begin
  if ps=0 then begin horizm:=horiz;error(junk,35);end  { no orarray}
  else
   begin
    if orarr[horiz,1]=cross then orarr[horiz,1]:=dash;
    if orarr[horiz,2]=cross then orarr[horiz,2]:=dash;
    fuses:=fuses+1;
   end;
 end;
if (gndflg) and (not vccflg) then      { GND id in the equation}
 begin                                 { ground the product term}
  ix:=horiz; fdef:=cross;
  for i:=1 to totvert do
   begin
    iy:=i;
    if randarr(ix,iy)=dash then 
     begin wandarr(ix,iy,fdef); fuses:=fuses-1; end;
   end;   
(* 7/3/1986 A. Neiman BUG #801 *)
(* MV 10/06/86 - Bug #949 - Bug Fixing Week *) {!! 2 !!}
(* Amir didnot realize that IX could also have value 0 or >256 *) {!! 2 !!}
    if (ix >= 1) and (ix <= 256) then {!! 2 !!}
       okXtoXblowXptXfuses[ix]:= false; {!! 2 !!}
  end;
if (vccflg) and (not gndflg) and (not idflg) then   { blow all the fuse}
 begin
  ix:=horiz; fdef:=dash;
  for i:=1 to totvert do
   begin
    iy:=i;
    if randarr(ix,iy)=cross then
    begin wandarr(ix,iy,fdef); fuses:=fuses+1; end;
   end;
(* 7/3/1986 A. Neiman BUG #801 *)
(* MV 10/06/86 - Bug #949 - Bug Fixing Week *) {!! 2 !!}
(* Amir didnot realize that IX could also have value 0 or >256 *) {!! 2 !!}
    if (ix >= 1) and (ix <= 256) then {!! 2 !!}
       okXtoXblowXptXfuses[ix]:= false; {!! 2 !!}
 end;

(* SOFTWARE BUG FIX FOR BUG #??? BY C.J. 7/18 *)
killXlst(tempand);
end;

(**************************************************************************)
(* PROCEDURE DO_FXPLOT (VAR EQNPTR:EQNNODEPTR)                            *)
(*                                                                        *)
(* eqnptr -- pointer to the equation                                      *)
(*                                                                        *)
(* This procedure generates fuseplot for functional equations only.       *)
(* For every equation it will call procedure PLOT.                        *)
(* The follwing errors are caught.                                        *)
(*         error 10,14,15,16,17 -- more than one product term for the     *)
(*                                 five functions.                        *)
(*         error 33  -- more than one functional equation defined for     *)
(*                      the particular output.                            *)
(*         error 34  -- cannot define a functional equation for this      *)
(*                      output.                                           *)
(*                                                                        *)
(* The proceduree also defaults the product term to all blown or all      *)
(* intact depending on the function and part type when no functional eqn. *)
(* is defined.                                                            *)
(**************************************************************************)
{ipp procedure do_fxplot(var eqnptr:eqnnodeptr);external; ipp}
{vax [GLOBAL] vax}  procedure doXfxplot(var eqnptr:eqnnodeptr);
label 999 ;

var  eqnptr1,temptr1,temptr2:eqnnodeptr;
     pinnumb,offset,horiz,i,ix,iy : integer;
     fdef:char;
begin

  gndflg:=false;vccflg:=false;idflg:=false;
 pinnumb:=eqnptr^.child^.child^.nodeXptr^.pinXnum;
 offset:=offarr[pinnumb];
 if (offset <1 )or (offset > maxXout)
    then begin 
         end
    else begin   
 if (eqnptr^.child^.kind<>tkXtrst) then   { if not tristate function}
  begin
   if outarr[offset].trstf=1 then         { default tristate to all blown}
    begin
     horiz:=outarr[offset].trstp;
     
     (* Software bug fix for bug #374   by C.J. 6/25 *)
     if (horiz < 1) or (horiz > maxXhor)
          then begin
               end
          else begin
               orarr[horiz,1]:=' ';
               orarr[horiz,2]:=' ';
               ix:=horiz; fdef := dash; for i:=1 to totvert do 
               begin
               iy:=i;
               wandarr(ix,iy,fdef);
(* ENHANCEMENT #608. ANAND B. 11/11/85 *)
               fuses := fuses + 1;
(* TRST P_T IS BLOWN IF A FUNCTIONAL OUTPUT IS DEFINED FOR AN OUTPUT PIN *)
(* A NEG. VALUE IS CHOSEN SO THAT IT CAN BE OVERRIDEN BY A TRST FUNCTION *)
(* SINCE TRSTF IS NO LONGER 1, IT CANNOT BE BLOWN AGAIN IN PROCEDURE DEFAULT *)
               outarr[offset].trstf := -2;
               end;
(* 7/3/1986 A. Neiman BUG #801 *)
               okXtoXblowXptXfuses[ix]:= false;
               end;{}           
    end;
  end;  
  end;{}
 eqnptr1:=nil;
 temptr1:=nil;
 temptr2:=nil;
 orlst:=nil;
 
 (* SOFTWARE BUG FIX FOR BUG # 374 BY C.J. 6/25 *)
 if (offset <1) or (offset > maxXout)
     then begin 
          end
     else begin

 if eqnptr^.child^.kind=tkXset then    { set function}
  begin
(* 22V10,22RX8,32VX10 MV 08/07/86 - can not define set function *)
(*                                  except global pin           *)
    if (pinnumb <> 25) and (palXtype in [pX32vx10,pX22v10,pX22rx8]) then
    begin 
      error (eqnptr , 34)  ;
    end ;
(* MV 08/19/86 - Bug #917  *)
   if (pinnumb = 25) and(eqnptr^.child^.rsibling^.kind =14) then
   begin
     error (eqnptr^.child , 58) ;
     goto 999 ;
   end        ; (* End Bug #917 *)

   horiz:=outarr[offset].setp;                        { set product term}
   if outarr[offset].setf = 0 then error(eqnptr,34);  { cannot define set eqn}
   if outarr[offset].setf >1 then error(eqnptr^.child,33);   
                                                { setf already defined }
   with eqnptr^.child^.rsibling^ do
   if kind=tkXvcc then outarr[offset].setf:=3         { all blown}
   else if kind=tkXgnd then outarr[offset].setf:=4    { all intact}
   else outarr[offset].setf:=2;                       { id defined}
  end;
 if eqnptr^.child^.kind=tkXreset then                 { reset funcion }
  begin      
(* 22V10,22RX8,32VX10 MV 08/07/86 - can not define reset function      *)
(*                                  except Global Pin                  *)
   if (pinnumb <> 25) and(palXtype in [pX32vx10,pX22v10,pX22rx8]) then
      error (eqnptr , 34)  ;
(* MV 08/19/86 Bug #917 *)
   if (pinnumb = 25) and(eqnptr^.child^.rsibling^.kind = 14) then
   begin
     error (eqnptr^.child , 58)  ;
     goto 999 ;
   end        ; (* End Bug #917 *)
   horiz:=outarr[offset].resetp;                      { reset product term} 
   if outarr[offset].resetf = 0 then error(eqnptr,34);{ cannot define eqn} 
   if outarr[offset].resetf>1 then error(eqnptr^.child,33);  
                                                { eqn already defined}
  with eqnptr^.child^.rsibling^ do 
  if kind=tkXvcc then outarr[offset].resetf:=3        { all blown}
   else if kind=tkXgnd then outarr[offset].resetf:=4  { all intact}
   else outarr[offset].resetf:=2;                     { id defined}

  end;
 if eqnptr^.child^.kind=tkXprld then                  { preload function}
  begin              
(* ENHANCEMENT #608. ANAND B. 11/11/85 *)
(* TK_PRLD IS ACTUALLY CMBF. HERE RBP IS BEING SET TO -2 SO THAT *)
(* CMBF FUNCTION IS NOT OVERIDDEN.                               *)
   outarr[offset].rbp := -2;
   horiz:=outarr[offset].prldp;                       { preload product term}
   if outarr[offset].prldf = 0 then error(eqnptr,34); { cannot define eqn}
   if outarr[offset].prldf >1 then error(eqnptr^.child,33);  
                                                { eqn already defined}
  with eqnptr^.child^.rsibling^ do
  if kind=tkXvcc then outarr[offset].prldf:=3         { all blown}
   else if kind=tkXgnd then outarr[offset].prldf:=4   { all inatct}
   else outarr[offset].prldf:=2;                      { id defined}

  end;
if eqnptr^.child^.kind=tkXtrst then                   { tristate function}
  begin
   horiz:=outarr[offset].trstp;                       { tristate prod term}
  if outarr[offset].trstf = 0 then error(eqnptr,34);  { cannot define eqn}
  if outarr[offset].trstf>1 then error(eqnptr^.child,33);    
                                                { eqn already defined}
(* MV 08/19/86 Bug#917 *)
  if eqnptr^.child^.rsibling^.kind = 14 then
  begin
    error (eqnptr^.child ,63) ;
    goto 999 ;
  end        ; (* End Bug#917 *)

  with eqnptr^.child^.rsibling^ do
  if kind=tkXvcc then outarr[offset].trstf:=3         { all blown}
   else if kind=tkXgnd then outarr[offset].trstf:=4   { all intact}
   else outarr[offset].trstf:=2;                      { id defined}

  end;
 if eqnptr^.child^.kind=tkXclk then                   { clock function}
  begin                   
   horiz:=outarr[offset].clkp;                        { clock prod term}
   if outarr[offset].clkf = 0 then error(eqnptr,34);  { cannot define eqn}
   if outarr[offset].clkf>1 then error(eqnptr^.child,33);    
                                                { eqn already defined}
  with eqnptr^.child^.rsibling^ do
  if kind=tkXvcc then outarr[offset].clkf:=3          { all blown}
   else if kind=tkXgnd then outarr[offset].clkf:=4    { all intact}
   else outarr[offset].clkf:=2;                       { id defined}

  end;
  temptr1:=eqnptr;
  temptr2:=temptr1^.rsibling;
  temptr1^.rsibling:=nil;
  createXorlst(temptr1,orlst);
  if orlst<>nil then
    begin
     with eqnptr^.child^ do begin
         if kind=tkXset then error(eqnptr,10);    {more than one prod term}
         if kind=tkXreset then error(eqnptr,14);  { errors}
         if kind=tkXtrst then error(eqnptr,15);
         if kind=tkXprld then error(eqnptr,16);
         if kind=tkXclk then error(eqnptr,17);
     end;
    end
   else
    begin
     product(temptr1^.child^.rsibling,horiz);    { blow the product term}
     temptr1^.rsibling:=temptr2;
    end;
end;
killXlst(orlst);
999 :
end;

(***********************************************************************)
(* PROCEUDRE DO_XPLOT (VAR EQNPTR:EQNNODEPTR)                          *)
(*                                                                     *)
(* eqnptr -- pointer to the equation.                                  *)
(*                                                                     *)
(*      -- tk_clkeq  <<== eqnptr                                       *)
(*           !                                                         *)
(*           Y -- OR                                                   *)
(*                !                                                    *)
(*               AND -- OR                                             *)
(*                !     !                                              *)
(*              A -- B  AND -- AND                                     *)
(*                       !      !                                      *)
(*                      /A--/B  /C -- D                                *)
(*                                                                     *)
(* This proceudre is called with the eqnptr. At first various checks   *)
(* are made for the output, regarding register bypass, functional      *)
(* conflict and the number of product terms. After that all the product*)
(* terms for the output are defaulted to default states, this is done  *)
(* by proceudre DEFAULT.                                               *)
(*                                                                     *)
(* Next, a list of all or gates (orlst) is created with the or gates   *)
(* in the right order. To each or gate ate least one or two products   *)
(* are attached. In the above example,                                 *)
(*                                                                     *)
(* product term A * B is attached to or gate 1                         *)
(* product terms /A*/B and /C*/D are attached to or gate 2.            *)
(*                                                                     *)
(* Now product term A*B is taken and procedure PRODUCT is called to    *)
(* the fuses, then the product term number is incremented by calling   *)
(* procedure INCREMENT. Then product term /A*/B is used and so on.     *)
(* Every time a new product term is used, the product term number      *)
(* check is made.                                                      *)
(***********************************************************************)
{ipp procedure do_xplot(var eqnptr:eqnnodeptr);external; ipp}
{vax [GLOBAL] vax}  procedure doXxplot(var eqnptr:eqnnodeptr);

var
    (* SOFTWARE BUG FIX FOR BUG #??? BY C.J. 7/12 *)
    tmpor:efflstptr;
    temptr11: efflstptr;
    pinnumb,offset,horiz,orcnt:integer;
    temptr1,temptr2 : eqnnodeptr;

{ This procedure defaults various product terms for a particular output}
{ Tristate product terms are all blown}
{ If the output is defined as combinatorial, and the output has set    }
{ function and reset function, than both the product terms are blown   }
{ high}
procedure default;

var i:integer;
     ix,iy,iy1,iy2 : integer; fdef : char;

begin

 if outarr[offset].trstf=1 then     { blow all the tristate product term high}
  begin
   horiz:=outarr[offset].trstp;
   orarr[horiz,1]:=' ';
   orarr[horiz,2]:=' ';
   ix:=horiz; fdef:=dash; for i:=1 to totvert do
    begin
      {%%%      andarr[horiz,i]:=dash;%%%} iy:=i; wandarr(ix,iy,fdef);
      fuses:=fuses+1;
(* ENHANCEMENT #608. ANAND B. 11/11/85 *)
(* TRST P_T BLOWN IF EQUATION IS DEFINED FOR AN OUTPUT PIN . *)
(* SETTING TRSTF TO A NEG. VALUE ALLOWS IT TO BE OVERRIDDEN BY TRST FUNCTION*)
(* SINCE TRSTF IS NO LONGER EQUAL TO 1, IT WILL NOT BE BLOWN IN DO_FXPLOT *)
      outarr[offset].trstf := -2;
    end;
(* 7/3/1986 A. Neiman BUG #801 *)
    okXtoXblowXptXfuses[ix]:= false;
  end;

(* ENHANCEMENT FOR 22RX8 -ANAND B. 9/4/85 *)
(* TO MAKE SURE SETF AND RSTF PRODUCT TERMS OF 22RX8 ARE NOT BLOWN *)
(* FOR A COMB. EQN. *)
if (palXtype in [pX20ra10,pX16ra8]) then

if  (eqnptr^.kind=tkXasseq)         { if the output is defined as }
 and(outarr[offset].setf<>0)        { combinatorial and the output}
 and(outarr[offset].resetf<>0)      { has a set and reset function}
 then                               { associated with it, then blow}
  begin                             { the produc terms high}
   horiz:=outarr[offset].setp;      { set product term}
   orarr[horiz,1]:=' ';             { or array fuses are given blanks}
   orarr[horiz,2]:=' ';
   ix:=horiz; fdef:=dash; for i:=1 to totvert do
    begin
      {%%%      andarr[horiz,i]:=dash;%%%} iy:=i; wandarr(ix,iy,fdef);
      fuses:=fuses+1;
    end;
   horiz:=outarr[offset].resetp;   { reset product term}
   orarr[horiz,1]:=' ';            { orarrays for functional prod terms}
   orarr[horiz,2]:=' ';            { are given blanks}

   ix:=horiz; fdef:=dash; for i:=1 to totvert do
    begin
      {%%%      andarr[horiz,i]:=dash;%%%} iy:=i; wandarr(ix,iy,fdef);
      fuses:=fuses+1;
    end;
  outarr[offset].kind:=0;
end;
end;


begin    { begin of procedure do_xplot}

orlst:=nil;
orlst1:=nil;
(* ENHANCEMENT #608. ANAND B. 11/11/85*)
(* BALA K. #641 01/13/86 *)
if (palXtype <> pX32vx10) then
check1(eqnptr);        { checks for register bypass }
check2(eqnptr);        { checks for function conflict }
check3(eqnptr);        { checks for numbr of product terms }
createXorlst(eqnptr,orlst);   { creates the orlst }
tmpor := orlst;
if orlst<> nil then
 begin
  pinnumb:=eqnptr^.child^.nodeXptr^.pinXnum;
  offset:=offarr[pinnumb];
  default;                       { product term default}
  horiz:=outarr[offset].current; { current product term to be used}
  if (palXtype<>pX16c1) and (palXtype<>pX20c1) then polarity(eqnptr);
  while orlst^.next<>nil do                {for every or gate except the last}
   begin
    gndflg:=false;vccflg:=false;idflg:=false;
    check3(eqnptr);               { check for number of product terms}
    prodshare(eqnptr,horiz);      { oarray fuses}
    temptr1:=orlst^.eqn^.child;   { one product term in eqntree}
    temptr2:=temptr1^.rsibling;   { next product term in eqntree}
    temptr1^.rsibling:=nil;

    product(temptr1,horiz);       { blow the fuses}
    increment(eqnptr);            { increment the product term count}
    horiz:=outarr[offset].current;{ new product term count}
    temptr1^.rsibling:=temptr2;
    orlst:=orlst^.next;
   end; 
  { the following is done for the last or gate}
  gndflg:=false;vccflg:=false;idflg:=false;
  check3(eqnptr);       { check for number of product terms}
  prodshare(eqnptr,horiz);  
  temptr1:=orlst^.eqn^.child;
  temptr2:=orlst^.eqn^.child^.rsibling;
  temptr1^.rsibling:=nil;
  product(temptr1,horiz);
  increment(eqnptr);    { increment the number of products for the output}
  gndflg:=false;vccflg:=false;idflg:=false;
  horiz:=outarr[offset].current;
  check3(eqnptr);
  prodshare(eqnptr,horiz);

  product(temptr2,horiz);
  increment(eqnptr);
  horiz:=outarr[offset].current;
  temptr1^.rsibling:=temptr2;
  {dispose(temptr1); }     {  vax dispose of pointers }
  {dispose(temptr2);}
  end
 else
   begin   { if no or gates are present}
    gndflg:=false;vccflg:=false;idflg:=false;
    pinnumb:=eqnptr^.child^.nodeXptr^.pinXnum;
    offset:=offarr[pinnumb];
    default;
    horiz:=outarr[offset].current;
    check3(eqnptr);
    if (palXtype<>pX16c1) and (palXtype<>pX20c1)
      then polarity(eqnptr);
    prodshare(eqnptr,horiz);

    product(eqnptr^.child^.rsibling,horiz);
    increment(eqnptr);
   end;
   (* SOFTWARE BUG FIX FOR BUG #??? BY C.J. 7/18 *)
   if tmpor <> nil then
   while tmpor^.next <> nil do
      begin
          orlst := tmpor;
          tmpor := tmpor^.next;
          end; 
   if orlst <> nil
    then  
         orlst^.next := nil;
   orlst := nil;
   killXlst(tmpor);
end;

(*********************************************************************)
(* PROCEDURE DO_XXPLOT (VAR EQNPTR:EQNNODEPTR)                       *)
(*                                                                   *)
(* eqnptr -- pointer to the equation                                 *)
(*                                                                   *)
(* The proceudre is called with the equation pointer. At first a call*)
(* to create an xorlst is made. If the xorlst is nil then a call to  *)
(* do_xplot is made. If The xorlst is not nil, then a check for only *)
(* one xor gate is made else and error is reported. Now for every    *)
(* node attached to the xor gate, procedure do_xplot is called. Check*)
(* for only two or gate per xor gate is  also made at this point.    *)
(* Once all the checks are passed, proceudre do_xplot is called for  *)
(* product term.                                                     *)
(*********************************************************************)
{ipp procedure do_xxplot(var eqnptr:eqnnodeptr);external; ipp}
{vax [GLOBAL] vax} procedure doXxxplot(var eqnptr:eqnnodeptr);

var 
    (* SOFTWARE BUG FIX FOR BUG #??? BY C.J. 7/12 *)
    
    xorlst{,orlst}:efflstptr;
    temptr1,temptr2,temptr3:eqnnodeptr;
    pinnumb,offset:integer;

procedure polarXxor;
(*                                                                   *)
(*-------------------------------------------------------------------*)
(*                                                                   *)
(*  PROCEDURE : POLAR_XOR                                            *)
(*  AUTHOR    : ANAND BEMRA                                          *)
(*  DATE      : 9/4/85                                               *)
(*  FUNCTION  :                                                      *)
(*    IT ALLOWS THE USER TO USE ONE SIDE OF XOR GATE (FIRST PRODUCT  *)
(*    TERM) EITHER AS POLARITY FUSE OR AS A NORMAL :+: TERM BUT NOT  *)
(*    BOTH. IF PIN LIST AND OUTPUT PIN HAVE SAME POLARITY THEN THE   *)
(*    FIRST P_T IS USED AS POLARITY FUSE. IT DOES THIS BY BLOWING    *)
(*    ALL THE FUSES IN THE FIRST P_T.                                *)
(*    THE FIRST P_T NEED NOT BE THE L.H.S OF :+: TERM.               *)     
(*                                                                   *)
(*  MODIFICATIONS :                                                  *)
(*    NAME        DATE       DESCRIPTION                             *)
(*    ----------- ---------- ------------------------------------    *)  
(*                                                                   *)
(*  COMMENTS  :                                                      *)
(*    THE PROCEDURE WORKS LIKE THIS:                                 *)
(*   IF SAME POLARITY THEN                                           *)
(*     BEGIN                                                         *)
(*        CREATE_XORLST();                                              *)
(*        IF XORLST <> NIL THEN ERROR                                   *)
(*        ELSE                                                          *)
(*         BEGIN                                                        *)
(*          BLOW FUSES OF FIRST P_T;                                    *)      
(*          DO_XPLOT(EQNPTR);                                           *)
(*         END;                                                         *)
(*       END                                                            *)
(*     ELSE                                                             *)
(*      BEGIN                                                           *)
(*        CREATE_XORLST();                                              *)
(*        IF XORLST = NIL THEN INCREMENT CURRENT & DO_XPLOT             *)
(*        ELSE                                                          *)
(*          BEGIN                                                       *)
(*           FIND #_P_T FOR TREE 1 OF XOR TERM;                         *)
(*           IF > 8 THEN ERROR;                                         *)
(*           IF > 1 THEN MORE THAN ONE P_T IS USED & HENCE TREE2        *)
(*                       CANNOT HAVE MORE THAN ONE P_T;                 *)
(*           DO_XPLOT(T1);                                              *)
(*           FIND #_P_T FOR T2;                                         *)
(*           IF MORE THAN ONE P_T FOR T1                                *)
(*             THEN IF #_P_T(T2) > 1 THEN ERROR                         *)
(*                  ELSE DO_XPLOT(T2->FIRST P_T);                       *)
(*           ELSE                                                       *)
(*             DO_XPLOT(T2);                                            *)
(*                                                                      *)
(*                                                                      *)
(*  INPUT PARAMETERS :                                                  *)
(*                                                                      *)
(*    VARIABLE    TYPE       DESCRIPTION                                *)
(*    ----------- ---------- ------------------------------------       *)
(* ALREADY_MORE_THAN_ONE BOOLEAN TELLS IF FIRST TERM OF :+: USES        *)
(*                               MORE THAN ONE P_T                      *)
(* NUM_OF_PROD_TERMS     0..100  TELLS NUMB. OF P_T FOR A GIVEN :+: SIDE*) 
(* IX,IY,I               INTEGER USED FOR CO-ORDINATES OF ANDARR,       *)
(*                               IF POLARITY IS SAME.                   *)
(* FDEF                  CHAR                                           *)

 const
   maxXprodXtermsXforXorXgate = 8;
 var
(* 6/18/1986 Amiram Neiman  BUG #801 *)
   horiz : integer;
   alreadyXmoreXthanXone : boolean;
   numbXofXprodXterms : 0..100;
   ix,iy,i : integer;
   fdef : char;   

 procedure prodXcount;
(*                                                                   *)
(*-------------------------------------------------------------------*)
(*                                                                   *)
(*  PROCEDURE : PROD_COUNT                                           *)
(*  AUTHOR    : ANAND BEMRA                                          *)
(*  DATE      : 9/4/85                                               *)
(*  FUNCTION  : COUNTS P_T OF A GIVEN TERM OF :+: GATE.              *)
(*                                                                   *)
(*  MODIFICATIONS :                                                  *)
(*    NAME        DATE       DESCRIPTION                             *)
(*    ----------- ---------- ------------------------------------    *)  
(*                                                                   *)
(*  COMMENTS  :                                                      *)
(*                                                                   *)
(*  INPUT PARAMETERS :                                               *)
(*                                                                   *)
(*    VARIABLE    TYPE       DESCRIPTION                             *)
(*    ----------- ---------- ------------------------------------    *)
(*                                                                   *)

  var
   pointerXforXcounting : efflstptr;
   begin
     pointerXforXcounting := orlst;
     numbXofXprodXterms := 1;
     while pointerXforXcounting <> nil do
      begin
        numbXofXprodXterms := numbXofXprodXterms + 1;
        pointerXforXcounting := pointerXforXcounting^.next;
      end;
   end;

 begin
(* OF POLAR_XOR PROCEDURE *)
  numbXofXprodXterms := 1;
  alreadyXmoreXthanXone := false;
  pinnumb := eqnptr^.child^.nodeXptr^.pinXnum;
  offset := offarr[pinnumb];

(* 22V10,22RX8,32VX10  MV 07/08/86  -  issue error for using global pin *)
(*                                  -  as simple euation                *)
   if (pinnumb = 25)and (eqnptr^.kind = 24 )and(palXtype in 
                             [pX32vx10,pX22rx8,pX22v10]) then
   begin
     error (eqnptr , 58)  ; 
   end  ;    (* End 22V10 , 22RX8   *)
     

(* 6/18/1986  Amiram Neiman  Bug #801 *)
     horiz:=outarr[offset].trstp;
(* 22V10 MV 07/01/86 - following code not needed for 22v10  *)
     
     (* Software bug fix for bug #374   by C.J. 6/25 *)
     if (horiz < 1) or (horiz > maxXhor)
          then begin
               end
          else if (palXtype <> pX22v10)
                  and (okXtoXblowXptXfuses[horiz]) then begin 
               orarr[horiz,1]:=' ';
               orarr[horiz,2]:=' ';
               ix:=horiz; fdef := dash; for i:=1 to totvert do 
               begin
               iy:=i;
               wandarr(ix,iy,fdef);
(* ENHANCEMENT #608. ANAND B. 11/11/85 *)
               fuses := fuses + 1;
(* TRST P_T IS BLOWN IF A FUNCTIONAL OUTPUT IS DEFINED FOR AN OUTPUT PIN *)
(* A NEG. VALUE IS CHOSEN SO THAT IT CAN BE OVERRIDEN BY A TRST FUNCTION *)
(* SINCE TRSTF IS NO LONGER 1, IT CANNOT BE BLOWN AGAIN IN PROCEDURE DEFAULT *)
               outarr[offset].trstf := -2;
               end;
               end;{}           


(*TO DETERMINE SAME/OPPOSITE POLARITY BETWEEN PIN NAME & L.H.S OF EQUATION *)
  polarity(eqnptr);
  createXxorlst(eqnptr,xorlst);
  if outarr[offset].polarity = 1 then 
(* FUSE BLOWN SINCE SAME POLARITY *)
   begin
     if xorlst <> nil then
     begin
(* 22V10 MV 07/01/86 - xor not allowed in the equation *)
       if palXtype = pX22v10 then
          error (eqnptr ,59)
       else 
          error(eqnptr,49)
(*      WRITELN('ERROR - CANNOT HAVE SAME POLARITY AND ALSO :+: TERM ') *)
     end 
     else
       begin
(* BLOW FUSES OF CURRENT AND INCREMENT CURRENT; *)
(* this style of blowing the product term for polarity was adapted from *)
(* the way tristate p_t was blown *)
(* 22V10  MV 07/01/86 - 22V10 do not need to blow fuse for xor p.t *)
        if palXtype <> pX22v10   then
        begin
          horiz := outarr[offset].start;
          orarr[horiz,1] := ' ';
          orarr[horiz,2] := ' ';
          ix := horiz; fdef := dash;
          for i := 1 to totvert do
          begin
(* suspect for this unnecessary assignment could be that iy is declared *)
(* as a variable parameter (again unnecessarily!) in wandarr *)
(* Behind all this is the fact that index variable cannot be changed *)
(*                                                      in the loop *)

            iy := i; wandarr(ix,iy,fdef);
            fuses := fuses + 1;
          end;

(* 7/3/1986 A. Neiman BUG #801 *)
        okXtoXblowXptXfuses[ix]:= false;

        outarr[offset].current := outarr[offset].start + 1;
        end ;    (* End If - Pal_Type = 22RX8  *)

        doXxplot(eqnptr);
       end; 
   end
  else 
(* OPP. POLARITY *)
   begin
    if xorlst = nil then
     begin
(* max prod terms for xor gate with one term intact. *)
(* 22V10 MV 07/01/86 - we do not have Xor . so decrementing   *)
(* outarr[offset].max is not needed                           *)
       if palXtype <> pX22v10  then
       begin
         outarr[offset].max := outarr[offset].max-1 ;
         outarr[offset].current := outarr[offset].start + 1;
       end  ;  (* end if                                      *)

       doXxplot(eqnptr);
     end
    else
     begin
       if palXtype = pX22v10 then
          error (eqnptr ,59)
       else 
       begin
         temptr3 := eqnptr^.child^.rsibling;
         if xorlst^.next <> nil then
            error(eqnptr,27);
         temptr2 := xorlst^.eqn^.child^.rsibling;
         temptr1 := xorlst^.eqn^.child;
         temptr1^.rsibling := nil;
         orlst := nil;
         createXorlst(temptr1,orlst);
         prodXcount;    
         if numbXofXprodXterms > outarr[offset].max-1 then
            error(eqnptr,7)
 (* WRITELN('ERROR- TOO MANY PRODUCT TERMS') *)
         else
         begin
           if numbXofXprodXterms > 1 then
           begin
             outarr[offset].current := outarr[offset].start + 1;
             alreadyXmoreXthanXone := true;
           end;
          eqnptr^.child^.rsibling := temptr1;
          doXxplot(eqnptr);
          killXlst(orlst); 
          orlst := nil;
          createXorlst(temptr2,orlst);
          eqnptr^.child^.rsibling := temptr2;
          prodXcount;
          if alreadyXmoreXthanXone then
          begin
            if numbXofXprodXterms > 1 then
(*         WRITELN('ERROR- ONLY ONE TERM OF :+: CAN HAVE MORE THAN ONE P_T')*)
             error(eqnptr,50)
            else
              begin
              (* IF NUMB_OF_PROD_TERMS = 1 *)
              outarr[offset].current := outarr[offset].start;
              end;
          end
          else
          begin
           if numbXofXprodXterms > outarr[offset].max-1 then
            error(eqnptr,7);
           outarr[offset].current := outarr[offset].start + 1;
          end;
 

         if (not errflag) then
             doXxplot(eqnptr);
         
(* RECONSTRUCTING THE TREE *)
         eqnptr^.child^.rsibling := temptr3;
         temptr3^.child^.rsibling := temptr2;

(* OF NUMB_OF_PROD_TERMS <= MAX PROD TERMS *)
       end;
(* OF XORLST <> NIL *)
     end;
(* 22V10  MV 07/01/86 - End of if pal_type <> 22V10 *)
     end ; (* End Else - pal_type <> 22V10 *)
(* OF OPP. POLARITY *)
    end;
   killXlst(orlst); 
(* OF PROCEDURE POLAR_XOR *)
 end;  
  
     

begin

xorlst:=nil;
orlst:=nil;
(* ENHANCEMENT FOR 22RX8- ANAND B. 9/4/85 *)
(* SINCE THERE ARE DIFFERENCES BETWEEN 22RX8 AND OTHER RX PARTS A SEPARATE *)
(* PROCEDURE IS CALLED.                                                    *)
(*   FOR AN XOR PART, TWO CALLS ARE MADE TO DO_XPLOT- ONE FOR EACH :+: TERM*)
(*      Q0 := A * B * C :+: E *F *G  IS BROKEN UP AS TWO TREES.            *)
(*           Q0 := A * B * C  & Q0 := E * F * G                            *)

(* BALA K. #641 01/13/86 *)
(* 22V10  MV 07/01/86 - 22V10 added *)
if (palXtype in [pX22rx8,pX32vx10,pX22v10]) then
  polarXxor
else
begin
 createXxorlst(eqnptr,xorlst);
 if xorlst<>nil then 
 begin
  if (palXtype<>pX20x10) and (palXtype<>pX20x8) and (palXtype<>pX20x4)
  then error(eqnptr,40);  { xor gate in other PAL devices is an error}
  temptr3:=eqnptr^.child^.rsibling;
  if xorlst^.next<>nil then error(eqnptr,27);    {more than one xor operand}
  temptr2:=xorlst^.eqn^.child^.rsibling;
  temptr1:=xorlst^.eqn^.child;
  temptr1^.rsibling:=nil;
  orlst:=nil;
  createXorlst(temptr1,orlst);
  if palXtype=pX16x4 then 
   begin                   {PAL 16X4 does not have more than 4 prod terms}
    if orlst<>nil then
     if orlst^.next^.next^.next<>nil then error(eqnptr,29) 
   end                                                     
  else
   begin                 { others have not more than two product terms}
    if orlst<>nil then
    if orlst^.next<>nil then error(eqnptr,28);
   end;
  eqnptr^.child^.rsibling:=temptr1;
  doXxplot(eqnptr);    { generate the fuse plot, for first two prod terms}
                       { attached to the xor gate}
  pinnumb:=eqnptr^.child^.nodeXptr^.pinXnum;
  if (palXtype=pX20x8) and ((pinnumb=23) or (pinnumb=14)) then
  error(eqnptr,36);  { these pins have no xor defined}
  if (palXtype=pX20x4) and ((pinnumb=23)or(pinnumb=22)or(pinnumb=21)
  or(pinnumb=14)or(pinnumb=15)or(pinnumb=16)) then error(eqnptr,37); {no xor}
  offset:=offarr[pinnumb];
  if palXtype = pX16x4 then 
   begin
    outarr[offset].current:=outarr[offset].start+4;   { increment the product}
    outarr[offset].current:=outarr[offset].start+4;   { term number by 4}
   end
  else
   begin 
    outarr[offset].current:=outarr[offset].start+2;  { increment the prduct }
    outarr[offset].start:=outarr[offset].start+2;    { term number by }
   end;
 (* SOFTWARE BUG FIX FOR BUG #??? BY C.J. 7/12 *)
  killXlst(orlst);
  orlst:=nil;
  createXorlst(temptr2,orlst);
  if orlst<>nil then
   if orlst^.next<>nil then error(eqnptr,28);
  eqnptr^.child^.rsibling:=temptr2;
  if (not errflag) then doXxplot(eqnptr); { In Xor pals, the do_xplot}
                                          { is called twice for one equation}
                                          { hence the same errors are repeated}
  eqnptr^.child^.rsibling:=temptr3;       { twice. Thus, if an error has }
  temptr3^.child^.rsibling:=temptr2;      { occured first time, than no  }
 end                                      { second call to do_xplot}
  else doXxplot(eqnptr);    { if no xor gate call do_xplot}

  (* SOFTWARE BUG FIX FOR BUG #??? BY C.J. 7/12  *)
    killXlst(xorlst);
  
  end;
  end;


(******************************************************************)
(* PROCEDURE PLOT (VAR EQNPTR:EQNNODEPTR)                         *)
(*                                                                *)
(* eqnptr -- pointer to the equation.                             *)
(*                                                                *)
(* For every equation tree build in FUNCTION EVALUATE of          *)
(* procedure FORMEQ_SIM (module formeq_simq file xfeq.SRC) , this *)
(* proceudre PLOT is called. This procedure will either call      *)
(* do_xxplot if it is plain equation or do_fxplot if it is  a     *)
(* functional equation.                                           *)
(******************************************************************)
{ipp procedure plot (var eqnptr:eqnnodeptr); external; ipp}
{vax [GLOBAL] vax}  procedure plot (var eqnptr:eqnnodeptr);
(* ENHANCEMENT #608. ANAND B. 11/11/85 *)
const
  lowerXoutputXpinnumb = 14;
  upperXoutputXpinnumb = 23;
var temptr1,temptr2:eqnnodeptr;
    eqncntr:integer;
    pinXnumber : integer;

 procedure externalXnode;
(*                                                                   *)
(*-------------------------------------------------------------------*)
(*                                                                   *)
(*  PROCEDURE : EXTERNAL_NODE                                        *)
(*  AUTHOR    : ANAND BEMRA                                          *)
(*  DATE      : 11/11/85                                             *)
(*  FUNCTION  : HANDLES EQN. DEFINED FOR EXTERNAL NODE.              *)
(*                                                                   *)
(*  MODIFICATIONS :                                                  *)
(*    NAME        DATE       DESCRIPTION                             *)
(*    ----------- ---------- ------------------------------------    *)  
(*                                                                   *)
(*  COMMENTS  :                                                      *)
(*                                                                   *)
(*  INPUT PARAMETERS :                                               *)
(*                                                                   *)
(*    VARIABLE    TYPE       DESCRIPTION                             *)
(*    ----------- ---------- ------------------------------------    *)
(*    OFFSET       INTEGER    GIVES OFFSET OF AN EXTERNAL NODE       *)

  var
   offset : integer;


   procedure polarXmux;
(*                                                                   *)
(*-------------------------------------------------------------------*)
(*                                                                   *)
(*  PROCEDURE : POLAR_MUX                                            *)
(*  AUTHOR    : ANAND BEMRA                                          *)
(*  DATE      : 11/11/85                                             *)
(*  FUNCTION  : DETERMINES WHETHER TO BLOW POLARITY MUX FUSE.        *)
(*                                                                   *)
(*  MODIFICATIONS :                                                  *)
(*    NAME        DATE       DESCRIPTION                             *)
(*    ----------- ---------- ------------------------------------    *)  
(*                                                                   *)
(*  COMMENTS  :                                                      *)
(*                                                                   *)
(*  INPUT PARAMETERS :                                               *)
(*                                                                   *)
(*    VARIABLE    TYPE       DESCRIPTION                             *)
(*    ----------- ---------- ------------------------------------    *)
(*  COUNT_OF_HIGH  SUBRANGE  INCREMENTED WHEN AN INTERNAL & ITS CORR *)
(*                           ESPONDING EXTERNAL NODE ARE DEFINED AS  *)
(*                           HIGH IN PIN LIST AND IN EQN.            *)


    var
     countXofXhigh : 0..4;
    begin
     countXofXhigh := 0;
     if(eqnptr^.child^.nodeXptr^.polarity='H') then countXofXhigh :=countXofXhigh+1;
     if(eqnptr^.child^.rsibling^.nodeXptr^.polarity='H') then
       countXofXhigh :=countXofXhigh+1;
     if(eqnptr^.child^.state='H') then countXofXhigh :=countXofXhigh+1;
     if(eqnptr^.child^.rsibling^.state='H') then countXofXhigh :=countXofXhigh+1;
     if(countXofXhigh in [1,3]) then

(* BLOW POLARITY MUX *)
      outarr[offarr[pinXnumber]].polarity := 1
     else

(* KEEP POLARITY MUX INTACT *)
      outarr[offarr[pinXnumber]].polarity := 0;

(* OF POLAR_MUX *)    
   end;


   procedure useXproductXterms;
     begin
       if productXtermsXused[pinXnumber] then
(* writeln('error-p_terms used by internal node eqn.') *)
           error(eqnptr,52)
       else
          begin    
           productXtermsXused[pinXnumber] := true;
           temptr1 := eqnptr;
           temptr2 := temptr1^.rsibling;
           temptr1^.rsibling := nil;
           doXxxplot(temptr1);
           temptr1^.rsibling:= temptr2;
           eqncntr := eqncntr + 1;
(* Execution reaches here for eqn. of type o22 = i9 + i4 * r17                *)
(* in do_xxplot, polarity would have been set to 1, if output pin and         *)
(* pin list had same polarity. That info.is necessary to blow one term of xor.*)
(* However we don't want to blow the polar mux based on that information.     *)
(* To blow polarity mux fuse, we would need output eqn. of the form o22 =/r22 *)

           outarr[offset].polarity := 0;
          end;
     end;


  begin
(* OF EXTERNAL_NODE *)
    if eqnptr^.kind = tkXclkeq then
     begin
       if (eqnptr^.child^.rsibling^.kind = tkXid) then

(* CHECK IF R.H.S OF EQN. IS THE CORRESPONDING INTERNAL NODE. *)
       if (pinXnumber=eqnptr^.child^.rsibling^.nodeXptr^.pinXnum-12) then

        begin
         offset := offarr[pinXnumber];

(* -2 INDICATES THAT A .CMBF FUNTION IS WRITTEN *)
         if outarr[offset].rbp <> -2 then 

(* BLOW P_T *)
(* MV 10/10/86 - Bug #991 - R.H.S is buried node don't blow the fuse *) {!! 3 !!}
          outarr[offset].rbp := 0 ; {!! 3 !!}

         polarXmux;
        end
       else

(* WRITELN('ERROR-CANNOT USE := WITH P_T ON R.H.S OF EQN. FOR EXT. NODE');*)
         error(eqnptr,53)
      else
         error(eqnptr,53);
     end
    else
(* KIND = TK_ASSEQ *)
     begin
      offset := offarr[pinXnumber];

(* -2 INDICATES THAT A .CMBF FUNTION IS WRITTEN *)
      if outarr[offset].rbp <> -2 then 

(* KEEP BYPASS P_T INTACT *)
(* MV 10/10/86 - Bug #991 - Bug fixing week    *) {!! 3 !!}
(* for combinatorial eqn. Blow P.T             *) {!! 3 !!}
       outarr[offset].rbp := 1; {!! 3 !!}

if (eqnptr^.child^.rsibling^.nodeXptr = nil) then
  useXproductXterms
else
(* CHECK IF R.H.S OF EQN. IS THE CORRESPONDING INTERNAL NODE. *)
      if(pinXnumber=eqnptr^.child^.rsibling^.nodeXptr^.pinXnum-12) then

        polarXmux
      else
        useXproductXterms;


      end;
(* OF PROCEDURE EXTERNAL_NODE *)
 end;

begin
 eqncntr:=0;
   with eqnptr^.child^ do
     if (kind<>tkXset) and(kind<>tkXreset) and(kind<>tkXprld)
     and(kind<>tkXclk) and(kind<>tkXtrst)
  then
   begin     { plain eaution}
    {cannot define equation for this output}

    (*   SOFTWARE  BUG FIX FOR BUG # 293    BY C.J.  6/4/1985  *)
   
    if offarr[eqnptr^.child^.nodeXptr^.pinXnum]=0 
       then begin
            error(eqnptr,32);
            eqncntr := eqncntr + 1;
            end
       else begin
(*ENHANCEMENT #608. ANAND B. 11/11/85 *)
(* BALA K. #641 01/13/86 *)
              if palXtype = pX32vx10 then
               begin
                pinXnumber := eqnptr^.child^.nodeXptr^.pinXnum;
(* CHECK IF IT IS AN OUTPUT PIN EQN. *)
                if (pinXnumber>=lowerXoutputXpinnumb) and
                   (pinXnumber<=upperXoutputXpinnumb) then
                  externalXnode
(* MV 10/08/86 Bug #885 - Bug fixing week *) {!! 2 !!}
                else {!! 3 !!}
                  if (pinXnumber =25) and(eqnptr^.child^.kind =1)then {!! 2 !!}
                    error (eqnptr,58) {!! 3 !!}
                else {!! 2 !!}
(* 4/28/86 Amiram Neiman  BUG #676 *)
                    if ((pinXnumber-12) in
                        [lowerXoutputXpinnumb..upperXoutputXpinnumb]) then 

(* INTERNAL NODE OF 32T10 *)
                      begin
(* CHECK IF THE CORRESPONDING EXTERNAL PIN IS USED *)

                       if productXtermsXused[pinXnumber-12] then 
(* WRITELN('ERROR-P_T ALREADY USED BY EXTERNAL NODE ') *)
                        error(eqnptr,51)
(* MV 10/08/86 Bug #885 - Bug fixing week *) {!! 2 !!}
                       else {!! 3 !!}
                         if (pinXnumber = 25) and(eqnptr^.child^.kind =1) then {!!2!!}
                            error (eqnptr,58) {!! 3 !!}
                       else 
                        begin
                          productXtermsXused[pinXnumber-12] := true;
                          temptr1 := eqnptr;
                          temptr2 := temptr1^.rsibling;
                          temptr1^.rsibling := nil;
                          doXxxplot(temptr1);
                          temptr1^.rsibling := temptr2;
                          eqncntr := eqncntr + 1;
                        end;
                     end;
           end
         else
          begin
            check5(eqnptr);
            temptr1:=eqnptr;
            temptr2:=temptr1^.rsibling;
            temptr1^.rsibling:=nil;
            doXxxplot(temptr1);
            temptr1^.rsibling:=temptr2;
            eqncntr:=eqncntr+1;
          end;
         end
   end
   else
    begin { functional equation}
     { cannot define functional equation for this pin}
     if offarr[eqnptr^.child^.child^.nodeXptr^.pinXnum]=0 
     then error(eqnptr,32);
     temptr1:=eqnptr;
     temptr2:=temptr1^.rsibling;
     doXfxplot(temptr1);
     temptr1^.rsibling:=temptr2;
    end;
end;

