(* SOFTWARE BUG FIX FOR BUG #??? BY C.J. 7/12  *)

(*------------------------------------------------------------------*)
(*                                                                  *)
(*       PROCEDURE: NW_LST                                          *)
(*                                                                  *)
(*       AUTHOR: BOB STEGGLES                                       *)
(*       DATE: 7/12/85                                              *)
(*       FUNCTION: TO CREATE A NODE FOR OR LIST OR XOR LIST OR AND  *)
(*                 LIST                                             *)
(*       INPUT PARAMETERS: TEMPNODE AS A TYPE OF EFFLSTPTR          *)
(*------------------------------------------------------------------*)
{ipp program m2q; ipp}
{ipp pragma c_include('XPLOTINC.INC'); ipp}
{/ipp}{vax [INHERIT('pal2$inc:xplotinc.env')] module m2q[PUBLIC]; vax}


#include 'xplotinc.i'


{IPP PROCEDURE NW_LST(VAR TEMPNODE:EFFLSTPTR);EXTERNAL; IPP}
{VAX [GLOBAL] VAX}procedure nwXlst(var tempnode:efflstptr);
begin
   if (freeXlstXst = nil) or (freeXlstXst = freeXlstXen) then 
	begin
		new(tempnode);
	end
      else begin
           tempnode := freeXlstXst;
           freeXlstXst := freeXlstXst^.next;
           end;
   tempnode^.eqn := nil;
   tempnode^.next := nil;
end; 
(************************************************************************)
(* This module contains the following procedures.                       *)
(*                                                                      *)
(* procedure create_xorlst, procedure create_orlst                      *)
(* procedure create_andlst.                                             *)
(************************************************************************)

procedure error(var eqnptr:eqnnodeptr;errnum:integer);external;

(*************************************************************************)
(* PROCEDURE CREATE_XORLST (EQNPTR:EQNNODEPTR; VAR XORLST:EFFLSTPTR);    *)
(*                                                                       *)
(* Eqnptr ==>> pointer to the equation                                   *)
(* xorlst ==>> list of all the nodes pointing to xor operator.           *)
(*                                                                       *)
(* In this procedure, the equation tree is scanned recursively, and if   *)
(* there is an xor operator, a pointer pointing to that operator is      *)
(* created and added to the xorlst. If no operators are present, than    *)
(* xorlst is nil.                                                        *)
(*                                                                       *)
(* It is a recursive procedure.                                          *)
(*************************************************************************)
{ipp procedure create_xorlst(eqnptr:eqnnodeptr; 
		var xorlst:efflstptr); external; ipp}
{vax [GLOBAL] vax} procedure createXxorlst(eqnptr:eqnnodeptr; var xorlst:efflstptr);

var tempnode : efflstptr;

begin
 if eqnptr<>nil then
  begin
   if eqnptr^.kind = tkXxnor then error(eqnptr,39); {no xnor operator}
   if eqnptr^.kind =  tkXxor then
    begin                            {adding node to the list}

     (* SOFTWARE BUG FIX FOR BUG #??? BY C.J. 7/12 *)
     nwXlst(tempnode);

     tempnode^.next:=xorlst;
     tempnode^.eqn:=eqnptr;
     xorlst:=tempnode;
    end;
  createXxorlst (eqnptr^.child,xorlst);
  createXxorlst (eqnptr^.rsibling,xorlst);
 end;
end;

(*************************************************************************)
(* PROCEDURE CREATE_ORLST  (EQNPTR:EQNNODEPTR; VAR  ORLST:EFFLSTPTR);    *)
(*                                                                       *)
(* Eqnptr ==>> pointer to the equation                                   *)
(* orlst  ==>> list of all the nodes pointing to  or operator.           *)
(*                                                                       *)
(* In this procedure, the equation tree is scanned recursively, and if   *)
(* there is an  or operator, a pointer pointing to that operator is      *)
(* created and added to the  orlst. If no operators are present, than    *)
(* orlst is nil.                                                         *)
(*                                                                       *)
(* It is a recursive procedure.                                          *)
(*************************************************************************)
{ipp procedure create_orlst(eqnptr:eqnnodeptr; var 
                 orlst:efflstptr);external; ipp}
{vax [GLOBAL] vax} procedure createXorlst(eqnptr:eqnnodeptr; var orlst:efflstptr);

var tempnode: efflstptr;

begin
 if eqnptr<>nil then
  begin
   if eqnptr^.kind =  tkXor then
    begin
     if orlst=nil then
      begin

       (* SOFTWARE BUG FIX FOR BUG #??? BY C.J. 7/12    *)
        
       nwXlst(tempnode);       { adding the first node}

       tempnode^.next:=nil;    { the order of or nodes is very}
       tempnode^.eqn:=eqnptr;  { important, because that is how}
       orlst:=tempnode;        { the product terms are to be blown}
       orlst1:=tempnode;       { hence the list is added at front}
      end
    else
     begin

      (* SOFTWARE BUG FIX FOR BUG #??? BY C.J. 7/12 *)
      nwXlst(tempnode);            { adding successive nodes in the list}

      tempnode^.next:=nil;
      tempnode^.eqn:=eqnptr;
      orlst1^.next:=tempnode;
      orlst1:=tempnode;
     end;    
    end;
  createXorlst (eqnptr^.child,orlst);      {recursive calls till child is nil}
  createXorlst (eqnptr^.rsibling,orlst);   { goto rsibling}
 end;
end;


(*************************************************************************)
(* PROCEDURE CREATE_ANDLST (EQNPTR:EQNNODEPTR; VAR ANDLST:EFFLSTPTR);    *)
(*                                                                       *)
(* Eqnptr ==>> pointer to the equation                                   *)
(* andlst ==>> list of all the nodes pointing to and operator.           *)
(*                                                                       *)
(* In this procedure, the equation tree is scanned recursively, and if   *)
(* there is an and operator, a pointer pointing to that operator is      *)
(* created and added to the andlst. If no operators are present, than    *)
(* andlst is nil.                                                        *)
(*                                                                       *)
(* It is a recursive procedure.                                          *)
(*************************************************************************)
{ipp procedure create_andlst(eqnptr:eqnnodeptr;
                       var andlst:efflstptr);external; ipp}
{vax [GLOBAL] vax} procedure createXandlst(eqnptr:eqnnodeptr; var andlst:efflstptr);

var tempnode : efflstptr;

begin
 if eqnptr<>nil then
  begin
   if eqnptr^.kind =  tkXand then
    begin

     (* SOFTWARE BUG FIX FOR BUG #??? BY C.J. 7/12 *)
     nwXlst(tempnode);

     tempnode^.next:=andlst;
     tempnode^.eqn:=eqnptr;
     andlst:=tempnode;
    end;
  createXandlst (eqnptr^.child,andlst);    {recursive call till child is nil}
  createXandlst (eqnptr^.rsibling,andlst); {recursive call till rsibling is nil}
 end;
end;
