{**  DEC/CMS REPLACEMENT HISTORY, Element XM1.SRC **}
{**  *5     9-FEB-1987 13:51:19 PALASM2 "to put loop var in main procedure" **}
{**  *4     8-FEB-1987 12:51:00 VORA "fixed bug #1179 " **}
{**  *3     3-NOV-1986 14:56:00 CHIEN "TO SUPPORT NEW PAL TYPE 18P8" **}
{**  *2     8-OCT-1986 13:58:13 VORA " fixed bug #873" **}
{**  *1     3-OCT-1986 15:13:09 PALASM2 "" **}
{**  DEC/CMS REPLACEMENT HISTORY, Element XM1.SRC **}
(************************************************************************)
(* This module has the following procedures:                            *)
(*                                                                      *)
(*  procedure read_pal, procedure phantom, procedure initialise         *)
(*  procedure print,    procedure jedec.                                *)
(************************************************************************)
  
{ipp pragma c_include('status.pf');ipp}
{ipp program m1; ipp}
{ipp with status; ipp}
{ipp var e: typeof(errno); ipp}
{ipp pragma c_include('XPLOTINC.INC'); ipp}
{/ipp}{vax [INHERIT('pal2$inc:xplotinc.env')] module m1q[PUBLIC]; vax}


#include 'xplotinc.i'


  type unixfiletype= packed array [1..64] of char;  
  procedure unxlibnam( var f: unixfiletype); external;  

procedure error (var eqnptr:eqnnodeptr; errnum:integer);external;
function  randarr(var ix,jx:integer):char; external;
procedure wandarr(var ix,jx:integer; var  xch:char); external;
var title1,title2,title3,title4 : lnbuf;
    dfield : packed array [1..5] of char;
{vax    fvaxname:packed array [1..24] of char; vax}
{ipp    fvaxname:string(24); ipp}
    fvaxname: unixfiletype;    
  
(*****************************************************************************)
(* FUNCTION CHECK (horiz:integer):boolean;                                   *)
(*                                                                           *)
(* This function checks whether a particular product term is intact or used. *)
(* It is true if the product term is used and false otherwise.               *)
(*****************************************************************************)
function check(horiz:integer):boolean;
var ix,iy,i:integer;
    flag:boolean;
begin
 ix:=horiz;
 flag:=false;
 for i:=1 to totvert do
  begin
   iy:=i;
   if randarr(ix,iy)=dash then flag:=true;
  end;
check:=flag;
end;
  
  
(***********************************************************************)
(* PROCEDURE HEADR (var size,pass:integer)                             *)
(*                                                                     *)
(* This procedure generates header information for xplot ouputs.       *)
(* The header information is the numbering of the vertical lines.      *)
(***********************************************************************)
procedure headr(var size,pass:integer);
var j,k,l :integer;
    frst,last : integer;
begin
 writeln(f1);
 frst:=0; last:=size-1;
 if (size=128) and (pass=1) then last:=(size div 2)-1;
 l:=0; k:=0;
 if ((size<>128) or (size=128) and (pass=1)) then write(f1,'    ');
 for j:=frst to last do begin
     if size<>128 then if l<>0 then write(f1,l:1) else write(f1,' ');
     if size=128 then write(f1,l:1);
     k:=k+1;
     if k>9 then begin k:=0; l:=l+1; end;
     if (size=128) and (l>9) then l:=0;
     if (size<64) and ((j mod 4)=3) then write(f1,' ');
     if (size=64) and ((j mod 8)=7) then write(f1,' ');
     if (size>64) and (pass=1) and ((j mod 8)=7) then write(f1,' ');
 end;
 writeln(f1);
 k:=0;
 if ((size<>128) or (size=128) and (pass=1)) then write(f1,'    ');
 for j:=frst to last do begin
     write(f1,k:1);
     k:=k+1;
     if k>9 then k:=0;
     if (size<64) and ((j mod 4)=3) then write(f1,' ');
     if (size=64) and ((j mod 8)=7) then write(f1,' ');
     if (size>64) and (pass=1) and ((j mod 8)=7) then write(f1,' ');
  end;
  
if (size=128) and (pass=1) then begin
 writeln(f1);
 writeln(f1);
 frst:=size div 2 ; last:=size-1;
 l:=6; k:=4;
 write(f1,'    ');
 for j:=frst to last do begin
     write(f1,l:1);
     k:=k+1;
     if k>9 then begin k:=0; l:=l+1; end;
     if (l>9) then l:=0;
     if ((j mod 8)=7) then write(f1,' ');
 end;
 writeln(f1);
 k:=4;
 if (pass=1) then write(f1,'    ');
 for j:=frst to last do begin
     write(f1,k:1);
     k:=k+1;
     if k>9 then k:=0;
     if (pass=1) and ((j mod 8)=7) then write(f1,' ');
  end;
end;
 writeln(f1);
 writeln(f1);
end;
  
(*****************************************************************)
(* FUNCTION RDLN (var line:lnbuf):integer;                       *)
(*                                                               *)
(* This function reads unwanted lines from PDF files.            *)
(*****************************************************************)
function rdln(var line:lnbuf):integer;
var ij,ik : integer;
begin
  ij:=0;
  while not eof(palfile) and not eoln(palfile) do begin
       ij:=ij+1;
       read(palfile,line[ij]);
  end;
for ik:=ij+1 to 50 do line[ik]:=' ';
if not eof(palfile) then readln(palfile);
rdln:=ij; {len that was }
end;
  
(***************************************************************************)
(* PROCEDURE READ_PAL;                                                     *)
(*                                                                         *)
(*  This procedure reads all the information from the PDF file related to  *)
(*  the xplot (till ':' character).The complete information from the PDF   *)
(*  files are stored in different arrays. The information in these arrays  *)
(*  is then used to blow the fuses, check for errors etc.. Some of the data*)
(*  is also changed dynamically.                                           *)
(*                                                                         *)
(*  The PDF file to be opened is determined from the pal_type. If the PDF  *)
(*  file is not found,than the error is reported to the user and the progr *)
(*  exits without crashing the system. An error is also reported if there  *)
(*  is a version mismatch.                                                 *)
(*                                                                         *)
(*  Refer to the documentation for PDF file information.                   *)
(***************************************************************************)
{ipp procedure read_pal;external; ipp}
{vax [GLOBAL] vax}  procedure readXpal;
var
{/ipp} filename : packed array [1..index] of char;
{ipp   filename : string(index); ipp}
    i,j,jj : integer;
    ch: char;
    junk2:eqnnodeptr;
begin
for i:=1 to index do filename[i]:=chr(0);
{not supported}
if (palXtype=pX16a4) or (palXtype=pX16x4) then error(junk2,42);
{determining the PDF file to be read}
 case palXtype of
(* NAS #499 7/16/85 *)
pX16ra8 : filename:='P16RA8.PDF     ';  pX22rx8 : filename:='P22RX8.PDF     ';
(* BALA K. #641 01/10/86 *)
pX32vx10 : filename:='P32VX10.PDF   ';

(* 22V10 MV 07/01/86 - new pdf file for 22V10  *)
pX22v10  : filename:='P22V10.PDF    ';
  
pX64r32 : filename:='P64R32.PDF     ';  pX32r16  : filename:='P32R16.PDF     ';
pX20rs10: filename:='P20RS10.PDF    ';  pX20ra10 : filename:='P20RA10.PDF    ';
pX20rs8 : filename:='P20RS8.PDF     ';  pX20rs4 : filename:='P20RS4.PDF     ';
pX20s10 : filename:='P20S10.PDF     ';
(* BALA K. #652 01/10/86 *)
pX10h20p8 : filename:='P10H20P8.PDF   ';
pX16l8  : filename:='P16L8.PDF      ';  pX16r8  : filename:='P16R8.PDF      ';
pX16r6  : filename:='P16R6.PDF      ';  pX16r4  : filename:='P16R4.PDF      ';
pX16p8  : filename:='P16P8.PDF      ';  pX16rp8 : filename:='P16RP8.PDF     ';
pX16rp6 : filename:='P16RP6.PDF     ';  pX16rp4 : filename:='P16RP4.PDF     ';
pX12l10 : filename:='P12L10.PDF     ';  pX14l8  : filename:='P14L8.PDF      ';
pX16l6  : filename:='P16L6.PDF      ';  pX18l4  : filename:='P18L4.PDF      ';
pX20l2  : filename:='P20L2.PDF      ';  pX20c1  : filename:='P20C1.PDF      ';
pX20x10 : filename:='P20X10.PDF     ';  pX20x8  : filename:='P20X8.PDF      ';
pX20x4  : filename:='P20X4.PDF      ';  pX20l8  : filename:='P20L8.PDF      ';
pX20r8  : filename:='P20R8.PDF      ';  pX20r6  : filename:='P20R6.PDF      ';
pX20r4  : filename:='P20R4.PDF      ';  pX10h8  : filename:='P10H8.PDF      ';
pX10l8  : filename:='P10L8.PDF      ';  pX12h6  : filename:='P12H6.PDF      ';
pX12l6  : filename:='P12L6.PDF      ';  pX14h4  : filename:='P14H4.PDF      ';
pX14l4  : filename:='P14L4.PDF      ';  pX16h2  : filename:='P16H2.PDF      ';
pX16l2  : filename:='P16L2.PDF      ';  pX16c1  : filename:='P16C1.PDF      ';
(* NAS #362 10/14/85 *)
pX8l14  : filename:='P8L14.PDF      ';  pX6l16  : filename:='P6L16.PDF      ';
pX16x4  : filename:='P16X4.PDF      ';  pX16a4  : filename:='P16A4.PDF      ';
(* NAS #607 10/14/85 *)
pX20l10 : filename:='P20L10.PDF     ';
(* BALA K. #653 01/10/86 *)
pX10h20g8 : filename:='P10H20G8.PDF   ';
end;
  
(* determine length of file name on ibmpc *)
{ipp I := length(filename); ipp}
{ipp while (filename[I]=' ') and (i>0) do I:=I-1; ipp}
{ipp set_length(filename,I); ipp}
  
{opening the PDF file, and making it ready for reading purposes}
{if the file is not found, then the program will inform the user}
{and exit without crashing the system.}
  
(* open pdffile *)
{fnx for J := 1 to I do fnx}
{fnx    fnx_pdf_name[fnx_pdf_len+J] := filename[J]; fnx}
{fnx fnx_pdf_len := fnx_pdf_len + J; fnx}
{fnx if not openfile (palfile,fnx_pdf_name,fnx_pdf_len,SHAREDFILE) then begin fnx}
{fnx    xplot_return_status := fnx_sys_err;fnx}
{fnx    for J := 1 to fnx_pdf_len do write(fnx_pdf_name[J]); fnx}
{fnx    write(' file not found'); fnx}
{/dsy} {fnx    writeln; fnx}
{dsy    writeln(errfile);      dsy}
  
{fnx end; fnx}

  for i:= 1 to index do fvaxname[i]:= filename[i];  
  unxlibnam( fvaxname );  
  reset( palfile, fvaxname );  

{/fnx}{vax fvaxname:='PAL2$DIR:'+filename; vax}
{/fnx}{vax   open(palfile,filename,history:=readonly,sharing:=readonly,error:=continue);vax}
{/fnx}{vax   if (status(palfile)<>0) then begin  vax}
{/fnx}{vax       open(palfile,fvaxname,history:=readonly,sharing:=readonly,error:=continue);vax}
(* MV 10/06/86 - Bug # 873 _ Bug fixing week  *) {!! 2 !!}
{/fnx}{vax       if (status(palfile)<>0) then  Begin   Vax} {!! 2 !!}
{/fnx}{Vax         WriteLn (  FileName ) ;              Vax} {!! 2 !!}
{/fnx}{vax         Error (Junk2 ,65) ;    End ;        vax} {!! 2 !!}
(* MV End Bug #873    *) {!! 2 !!}
{/fnx}{vax    end;  vax}
(* MV 10/06/86 - Bug #873 - Bug fixing week *) {!! 2 !!}
{/fnx}{Vax   If Status(PalFile) = 0 Then                     VAX} {!! 2 !!}
{/fnx}{vax      reset(palfile);   vax} {!! 2 !!}
{/fnx}{ipp fvaxname[1]:= 'B'; ipp}
{/fnx}{ipp fvaxname[2]:= ':'; ipp}
{/fnx}{ipp for i:=1 to index do fvaxname[i+2]:=filename[i];ipp}
{/fnx}{ipp set_length(fvaxname,i+2); ipp}
{/fnx}{ipp return_io_status:=true;ipp}
{/fnx}{ipp reset(palfile,filename); ipp}
{/fnx}{ipp return_io_status:=false; ipp}
{/fnx}{ipp e:=errno;ipp}
{/fnx}{ipp if e<> no_error_occurred then ipp}
{/fnx}{ipp  begin ipp}
{/fnx}{ipp   close(palfile);ipp}
{/fnx}{ipp   return_io_status:=true;ipp}
{/fnx}{ipp   reset(palfile,fvaxname);ipp}
(* MV 10/06/86 - Bug #873 - Bug fixing week *) {!! 2 !!}
(* Suppose to be for IBM/PC only            *) {!! 2 !!}
{/fnx}{ipp   if errno<>no_error_occurred then Begin ipp} {!! 2 !!}
{/fnx}{ipp   writeln(  FileName ) ;  ipp} {!! 2 !!}
{/fnx}{ipp   Error (Junk2,65)     ; End ;  ipp} {!! 2 !!}
{/fnx}{ipp   return_io_status:=false;ipp}
{/fnx}{ipp  end; ipp}
{/fnx}{/ipp}reset(palfile);
  
(* read pdf file *)
{fnx if xplot_return_status <> fnx_sys_err then begin fnx}
readln(palfile,i);
if (i=222) then begin
  i:=1;
  ch:=' ';
  for i:=1 to index do filename1[i]:=' ';
  i:=1;
  while not eoln(palfile) do
   begin
   read(palfile,ch);
   if ch<>' ' then
     begin
      filename1[i]:=ch;
      i:=i+1;
     end;
   end;
  if not eof(palfile) then readln(palfile);
  ch:=' '; for i:=1 to 5 do dfield[i]:=' '; i:=1;
  while (not eoln(palfile)) and (i<=5) do
   begin
    read(palfile,ch);
    if (ch<>' ') then
     begin
      dfield[i]:=ch;
      i:=i+1;
     end;
   end;
  
  { totinp -- total number of inputs.}
  { totout -- total number of outputs.}
  { totprod -- total number of product terms}
  { totvert -- total number of vertical lines}
  { phantom1 -- '1' if phantom fuses present, '0' otherwise}
  { rbp -- register bypass fuse, '0' not present}
  { ps  -- product term sharing, '0' not present}
  { polf--   { offarr -- offset values of the output pins in the xplot print out}
  { locarr -- vertical location of different pins}
  { flarr -- flush fuse info, dafault to all intact}
  { outarr -- information of all the output pins.}
  { orarr  -- or array information , defaulted to not present}
  { skip   -- formatting of product terms in the xplot printout}
  { pharr  -- product term phantom fuses (0) }
  { pharr1 -- input lines phantom fuses (O) }
  { pharr2 -- cross points phantom fuses(O) }
  
  if not eof(palfile) then readln(palfile);
  read(palfile,totinp,totout,totprod,totvert,phantom1);
  readln (palfile); {,totfuse,fuses);}
  for i:=1 to totout+totinp do   read(palfile,offarr[i]);
  for i:=1 to totout+totinp do   read(palfile,locarr[i]);
  read(palfile,rbp,ps,polf);
  for i:=1 to maxflush do read(palfile,flarr[i]);
  for i:=1 to totout do with outarr[i] do
     read(palfile,max, start, current, total, shXpin, link, orindex,
                     polarity, rbp, ps, upXdown, setf, resetf, trstf, prldf,
                     clkf, polf, setp, resetp, trstp, prldp, clkp, kind);
  
   for i:=1 to totprod do
    for j:=1 to 2 do
     begin
      read(palfile,jj);
      if jj=1 then orarr[i,j]:=' '
                else orarr[i,j]:=cross;
     end;
   if not eof(palfile) then readln(palfile);
   for i:=1 to totprod do read(palfile,skip[i]);
   if not eof(palfile) then readln(palfile);
  
   i:=rdln(title1);
   i:=rdln(title2);
   i:=rdln(title3);
   i:=rdln(title4);
   totph:=0;
   totph1:=0;
   totph2:=0;
  
{read pahantom fuse location information}
   if phantom1=1 then
    begin
     read(palfile,i);
     while (not eof(palfile)) and (palfile^<>':') do
      begin
  
       while i<>1000 do
        begin
         totph:=totph+1;       {product term phantom (0) }
         pharr[totph]:=i;
         if eoln(palfile) then readln(palfile);
         read(palfile,i);
        end;
       if not eof(palfile) then readln(palfile);
       read(palfile,i);
  
       while i<>1000 do
        begin
         totph1:=totph1+1;      { vertical lines phantom (O)}
         pharr1[totph1]:=i;
         if eoln(palfile) then readln(palfile);
         read(palfile,i);
        end;
       if not eof(palfile) then readln(palfile);
       read(palfile,i);
  
       while i<>1000 do
        begin
         totph2:=totph2+1;
         pharr2[totph2]:=i;      { cross point phantom (O) }
         if eoln(palfile) then readln(palfile);
         read(palfile,i);
        end;
       if not eof(palfile) then readln(palfile);
     end;
    end;
 if pinXnumber<>totinp+totout then error(junk2,31);
  
end
else error(junk2,0);  {nas 11/28/84}
{fnx end; fnx}
end;
  
(**************************************************************************)
(* PROCEDURE PHANTOM;                                                     *)
(*                                                                        *)
(* This procedure fills the andarr with the high or low phantom fuses     *)
(* depending on the information read from the PDF file in pharr,pharr1,   *)
(* and pharr2 arrays in read_pal procdure.                                *)
(*                                                                        *)
(* pharr1 stroes high phantom info (O)                                    *)
(* pharr2 stores low  phantom info (O)                                    *)
(* pharr  stroes low  phantom info (0)                                    *)
(**************************************************************************)
{ipp procedure phantom;external; ipp}
{vax [GLOBAL] vax}  procedure phantom;
  
var i,j,ix,iy : integer;
    fdef:char;
  
begin
 if phantom1=1 then
  for i:=1 to totprod do
  for j:=1 to totph1 do
  begin
   ix:= i;
   iy:= pharr1[j];
   fdef:='O';
   wandarr(ix,iy,fdef);
  end;
  
 if phantom1=1 then
  for i:=1 to totph do
  for j:=1 to totvert do
  begin
   ix:= pharr[i];
   iy:= j;
   fdef:='0';
   wandarr(ix,iy,fdef);
  end;
 if phantom1=1 then
  for i:=1 to totph2 do
  for j:=1 to totvert do
  begin
   ix:= pharr2[i];
   iy:= j;
   fdef:='O';
   wandarr(ix,iy,fdef);
  end;
end;
  
(*****************************************************************************)
(* PROCEDURE INITIALISE;                                                     *)
(*                                                                           *)
(* This procedure initialises many global variables. It also creates a local *)
(* heap from which single equation is build.                                 *)
(*****************************************************************************)
{ipp procedure initialise;external; ipp}
{vax [GLOBAL] vax}  procedure initialise;
  
const
    lowerXoutputXpinnumb = 14;
    upperXoutputXpinnumb = 23;
var i,j : integer;
    ix,iy,iy1,iy2 : integer; fdef : char;
    tmp : eqnnodeptr;
  
begin

  (* 7/3/1986 A Neiman BUG #801 *)
  for i:= 1 to maxXhor do
    okXtoXblowXptXfuses[i]:= true;

  
(* ENHANCEMENT #608. ANAND B. *)
  for i := lowerXoutputXpinnumb to upperXoutputXpinnumb do
    productXtermsXused[i] := false;
  
(* INITIALISATION OF VARIABLES USED IN PROCEDURE CHECK_FEEDBACK IN MODULE    *)
(* XFEQ. BUG FIX #366. ANAND B. 77/9/85                                      *)
  for i := 1 to maxXout do
     begin
       feedback[i] := initialXfeedback;
       errorXreported[i] := false;
     end;
  ofset := 0;
  
(* BUG FIX #427. ANAND B. 7/17/85 *)
  warncount := 0;
  errorcount := 0;
  
  { building of a local heap }
  new(tmp);
  eqfrst:=tmp;
  eqlast:=tmp;
  
(* NAS #278,294,295 6/3/85 *)
{  for i:=1 to maxtkeq do begin
     new(tmp);
     eqlast^.child:=tmp;
     eqlast:=tmp;
     tmp^.child:=nil;
  end;}
(* NAS #278,294,295 6/3/85 *)
  
 {initialising the andarr with 'X'}
{/ipp}  for i:=1 to maxXhor do
{/ipp}    for j:=1 to maxXvert do begin
{/ipp}          ix:=i; iy:=j; fdef:=cross; wandarr(ix,iy,fdef);
{/ipp}  end;
  
 {initialising the orarray with 'X'}
 for i:=1 to maxXhor do  for j:=1 to 2 do   orarr[i,j]:= cross;
  
{ The following are additions made by IMB 12/9/84}
 tchksum:=0;    {initialise transmit check sum}
 tchksmh:=0;    {initialise transmit check sum}
 fchksum:=0;    {initialise fuse check sum}
 fchksmh:=0;    {initialise fuse check sum}
 binarr[1]:=1;  binarr[2]:=2;   binarr[3]:=4;   binarr[4]:=8;
 binarr[5]:=16; binarr[6]:=32;  binarr[7]:=64;   binarr[8]:=128;
 for i:=1 to 4 do tchksumarr[i]:=chr(0);
 for i:=1 to 4 do fchksumarr[i]:=chr(0);
 binptr:=1;
 end;
  
(***************************************************************************)
(* PROCEDURE PRINT;                                                        *)
(*                                                                         *)
(* This proceudre prints a full or brief xplot in the filename.xpt file.   *)
(* Befor the xplot, it prints all the data base info like TITLE, PATTERn,  *)
(* PAL_TYPE, etc.. for user documentation. Then it prints the vertical     *)
(* numbering of the vertical lines. After that it prints the andarr and    *)
(* orarr. After that it prints the polarity and flush fuse info. and last  *)
(* it gives the total fuses blown.                                         *)
(*                                                                         *)
(* The xplot is properly formated for easy readability. If the line length *)
(* exceeds 80 characters, the program prints on the next line. Each product*)
(* term is numbered according to the logic diagram.                        *)
(*                                                                         *)
(* Brief xplot will only show those product terms that have been used.     *)
(* Full  xplot will show all the product terms. Phantom fuses are also     *)
(* shown in the xplot.                                                     *)
(*                                                                         *)
(* A varix plot is generated for downloading to VARIX programmer. This file*)
(* is only generated for MEGA PAls (PAL 64R32)                             *)
(***************************************************************************)
{ipp procedure print(VAR pass:integer);external; ipp}
{vax [GLOBAL] vax}  procedure print(var pass:integer);
const
    lowerXoutputXpinnumb = 14;
    upperXoutputXpinnumb = 23;
  
var horiz,vert,i,j,off:integer;
    ix,iy,iy1,iy2 : integer; fdef : char;
    flag:boolean;
(* 22V10  MV 07/08/86 - introduced Dummy_Out to avoid conflict from  *)
(*                    - DUMMY_TOTOUT                                  *)
    dummyXout     :  integer     ;

  
procedure writeXrbpXfuse;
(*                                                                   *)
(*-------------------------------------------------------------------*)
(*                                                                   *)
(*  PROCEDURE : WRITE_RBP_FUSE                                       *)
(*  AUTHOR    : ANAND BEMRA                                          *)
(*  DATE      : 9/4/85                                               *)
(*  FUNCTION  : WRITES IN THE XPT FILE RBP FUSE STATUS.              *)
(*                                                                   *)
(*  MODIFICATIONS :                                                  *)
(*    NAME        DATE       DESCRIPTION                             *)
(*    ----------- ---------- ------------------------------------    *)
(*                                                                   *)
(*  COMMENTS  : HERE ONLY XPT FILE IS WRITTEN INTO. NOT THE JED FILE.*)
(*                                                                   *)
(*  INPUT PARAMETERS :                                               *)
(*                                                                   *)
(*    VARIABLE    TYPE       DESCRIPTION                             *)
(*    ----------- ---------- ------------------------------------    *)
(*                                                                   *)
  
var i : integer;
(* NEED THIS VARIABLE TO COMPILE ON THE PP COMPILER *)
    dummyXtotout : 1..1000;
(* BUG FIX # 607 - ANAND B. 10/16/85 *)
begin
(* 22V10 MV 07/01/86 - 22V10 added *)

  if (palXtype in [pX22rx8,pX22v10]) then
   dummyXtotout := totout - 1
(* TOTOUT-1 'CAUSE PIN 25 WITH AN OFFSET OF 9 IS A DUMMY OUTPUT PIN *)
(* BALA K. #653 01/10/86 *)
  else if palXtype = pX10h20g8 then
    dummyXtotout := totout;
  if rbp = 1 then
    begin
      writeln(f1); writeln(f1);
      write(f1,'       OUTPUT PINS: ');
      writeln(f1,title3);
      writeln(f1,'                    ',title4);
      write(f1,'       FLUSH FUSE:  ');
(* 22V10 MV 07/01/86 - 22V10 added *)
     if (palXtype in [pX22rx8,pX22v10]) then
      begin
       for i := dummyXtotout downto 1 do
  
        if outarr[i].rbp = 1 then
          begin
            fuses := fuses + 1;
            write(f1,dash)
          end
        else
          write(f1,cross);
      end
(* BALA K. #653 01/10/86 *)
     else if palXtype = pX10h20g8 then
       for i := 1 to dummyXtotout  do
  
        if outarr[i].rbp = 1 then
          begin
            fuses := fuses + 1;
            write(f1,dash)
          end
        else
          write(f1,cross);
  
     end;
 end;
  
begin
{f1 is filename.XPT file variable}
{writing the data base}
writeln(f1);
(* BALA K. Enhc #739  02/25/86  *)
{/dsy} write(f1,'Title    :',dbstr[1]); writeln(f1,chr(9),'Author  :',dbstr[4]);
{/dsy} write(f1,'Pattern  :',dbstr[2]); writeln(f1,chr(9),'Company :',dbstr[5]);
{/dsy} write(f1,'Revision :',dbstr[3]); writeln(f1,chr(9),'Date    :',dbstr[6]);
  
{dsy write(f1,'Title    :',dbstr[1]);          dsy}
{dsy writeln(f1,'     ','Author  :',dbstr[4]); dsy}
{dsy write(f1,'Pattern  :',dbstr[2]);          dsy}
{dsy writeln(f1,'     ','Company :',dbstr[5]); dsy}
{dsy write(f1,'Revision :',dbstr[3]);          dsy}
{dsy writeln(f1,'     ','Date    :',dbstr[6]); dsy}
  
writeln(f1);
  
writeln(f1,filename1);
for i:=1 to 30 do write(f1,title0[i]);
writeln(f1);
  
headr(totvert,pass);  {writing the vertical numbering}
off:=0;flag:=false;  { no product term is used}
  
{writing the andarr and orarr}
for horiz := 1 to totprod do
 begin
 ix:=horiz;
 if check(ix) or not(brieflg) then
 begin
   flag:=true;     { at least one product term is used}
   if ((totvert<>128) or ((totvert=128) and (pass=1))) then
      write(f1,horiz-1:3,' ');
   for vert:= 1 to totvert do
   begin
    ix:=horiz; iy:=vert; write(f1,randarr(ix,iy));
    if (totvert<64) and ((vert mod 4)=0) then write(f1,' ');
    if (totvert>=64) and ((vert mod 8)=0) and (pass=1) then write(f1,' ');
    if (totvert=128) and (pass=1) and (vert=64) then begin
           writeln(f1); write(f1,'    '); end;
   end;
   if totvert=128 then write(f1,' ');
{  write(f1,' ');}
   for i:=1 to 2 do write(f1,orarr[horiz,i]);
   if skip[horiz]=1 then begin writeln(f1, ' '); flag:=false;end;
   writeln(f1);
 end
 else begin
  if (skip[horiz]=1) and (flag)  then begin writeln(f1,' ');
  flag:=false; end;
 end;
end;
writeln(f1);    writeln(f1);
  
(* ENHANCEMENT FOR 22RX8 - ANAND B. 9/4/85 *)
(* IN 22RX8, POLARITY IS GOVERNED BY PRODUCT TERM & NOT A POLARITY FUSE. *)
  
if palXtype <> pX22rx8 then
  
{writing polarity fuse info.}
if polf=1 then
begin
 write(f1,'      OUTPUT PINS: ');
 for i:=1 to totout do write(f1,title1[i]);
 writeln(f1);
 write(f1,'                   ');
 for i:=1 to totout do write(f1,title2[i]);
 writeln(f1);
 write(f1,'    POLARITY FUSE: ');
(* ENHANCEMENT #608. ANAND B. 11/11/85 *)
(* BALA K. #641 01/10/86 *)
 if (palXtype = pX32vx10) then
   begin
     for i := lowerXoutputXpinnumb to upperXoutputXpinnumb do
      begin
       if outarr[offarr[i]].polarity = 1 then
         begin
           write(f1,dash);
           fuses := fuses + 1;
         end
       else
          write(f1,cross);
      end;
   end
else
 begin
(* 22V10 MV 07/08/86 - for 22RX8 polarity fuse is governed by product *)
(*                   - term .but for 22v10 it is governed by polarity *)
(*                   - fuse .To avoid printing the polarity fuse for  *)
(*                   - pin 25 , introduced a variable dummy_Out    *)
dummyXout   := totinp  + totout     ;
if palXtype = pX22v10 then
   dummyXout  := dummyXout  - 1 ;

 for i:=1 to dummyXout do
  if offarr[i]<>0
   then
      if outarr[offarr[i]].polarity=1
    then
     begin
      write(f1,dash);
      fuses:=fuses+1;
     end
   else write(f1,cross);
  end;
 end;
  
{writing the flush fuse info}
(* ENHANCEMENT FOR 22RX8 - ANAND B. 9/4/85 *)
(* EACH OUTPUT PIN HAS A REGISTER BYPASS FUSE (ALSO CALLED FLUSH FUSE) *)
(* UNLIKE MEGAPALS WHERE A BANK OF OUTPUTS HAVE A SINGLE BYPASS FUSE.  *)
(* ENHANCEMENT FOR 20LH8 ;#607 - ANAND B. 10/16/85 *)
  
  
(* BALA K. #653 01/10/86 *)
(* 22V10 MV 07/01/86 - 22V10 added *)

if (palXtype in [pX22rx8,pX22v10,pX10h20g8]) then
  writeXrbpXfuse;
  
if(palXtype in [pX32r16,pX64r32]) then
if rbp=1 then
 begin
  writeln(f1);
  writeln(f1);
  write(f1,'     OUTPUT  BANK: ');
  for i:=1 to totout do write(f1,title3[i]);
  writeln(f1);
  {write(f1,'                   ');
  for i:=1 to totout do write(f1,title4[i]);
  writeln(f1);}
  write(f1,'       FLUSH FUSE: ');
  for i:=1 to maxflush do
   begin
    if flarr[i]<>0 then
     begin
      if i=1 then write(f1,'     ')else write(f1,'       ');
      if outarr[offarr[flarr[i]]].rbp = 1 then
                                           begin
                                            fuses:=fuses+1;
                                            write(f1,dash);
                                           end
                                         else
                                           write(f1,cross);
     end;
   end;
  (*for i:=1 to totinp+totout do
  if offarr[i]<>0
   then if outarr[offarr[i]].rbp=1 then write(f1,'-')
                                   else write(f1,'x');*)
 end;
writeln(f1);
writeln(f1);
writeln (f1,'TOTAL FUSES BLOWN: ', fuses:5);
end;
  
  
(******************************************************************)
(* PROCEDURE JEDEC;                                               *)
(*                                                                *)
(* This procedure generates the JEDEC format of the xplot printed *)
(* in print procedure. Refer to JEDEC documentation for jedec     *)
(* format.                                                        *)
(*                                                                *)
(* Only the used product terms are reported. Proper addresses are *)
(* calculated. The maximum filed of address is 5 bit for PAL64R32 *)
(* Checksum and Fuse sum are also calculated and reported in the  *)
(* jedec file.                                                    *)
(*                                                                *)
(* All the data base information is reported before start of text *)
(* character.The device code read from the PDF file is also       *)
(* reported.                                                      *)
(******************************************************************)
{ipp procedure jedec;external; ipp}
{vax [GLOBAL] vax}  procedure jedec;
  
const etx=3;    stx=2;  one='1';        zero='0';       star='*';
(* BALA K.  Enhc #742  02/25/86  *)
{dsy        LF = 0;    dsy}
{/dsy}      lf = 13;
{/dsy}      cr = 10;
{dsy        CR = 13;           dsy}
  
var horiz,vert,i,j,start,last:integer;
    ix,iy,iy1,iy2 : integer; fdef : char;
    flag:boolean;
    temparr:array[1..maxXio] of integer; 
    flink: integer;  
  
  (*  SOFTWARE BUG FIX FOR BUG # 414 BY C.J. 6/26/1985 *)
  
  {IPP  FLINK :LONGINT;   IPP}
  {VAX  FLINK :INTEGER;   VAX}
(* 22V10  MV 08/07/86 - added Dummy_Out variable            *)
   dummyXout     :  integer ; (* = Totinp+TotOut            *)  

  
(************************************************************)
(* PROCEDURE INTTOCHAR;                                     *)
(*   This procedure coverts an integer to character string. *)
(*   e.g. integer 123 is converted to '00123'               *)
(************************************************************)
procedure inttochar;
  
(*   SOFTWARE BUG FIX FOR BUG #414 BY C. J. 6/25/1985   *)
var i,rem,quot:integer;
    {IPP   SUM:LONGINT;    IPP}
    {VAX   SUM:INTEGER;    VAX}
       sum:integer;    
var
    fstr:packed array[1..6]of char;
  
begin
 fstr[1]:='L';
 for i:=2 to 6 do fstr[i]:='0';
 sum:=flink;
 i:=6;
 repeat
  quot:=sum div 10;
  rem:=sum mod 10;
  sum:=quot;
  fstr[i]:=chr(rem+ord('0'));
  i:=i-1;
 until sum=0;
 for i:=1 to 6 do
  begin
   {for megapal, a 5 bit address is required}
   if palXtype = pX64r32 then
    begin
     write(f2,fstr[i]);
     tchksum:=tchksum+ord(fstr[i]);
    end
   else
    begin
     if (i<>2) then write(f2,fstr[i]);
     if (i<>2) then tchksum:=tchksum+ord(fstr[i]);
    end;
   end;
  write (f2,' ');
  tchksum:=tchksum+ord(' ');
end;
  
  
{this procedure is used to derive the right binary addition to}
{calculate fuse check sum (fchksum).}
  
procedure add(number:integer);
begin
  if number=1 then begin
                tchksum:=tchksum+ord('1');
                fchksum:=fchksum+binarr[binptr];
           end
        else tchksum:=tchksum+ord('0');
  if binptr=8 then binptr:=1 else binptr:=binptr+1;
  fchksmh:=fchksmh+(fchksum div 256);
  fchksum:=fchksum mod 256;
{WRITELN(F2,FCHKSUM,BINARR[BINPTR],BINPTR); {}
 end;
  
  
(***************************************************************)
(* PROCEDURE SPLIT_SUM;                                        *)
(*                                                             *)
(* This procedure splits a sum into two 4-bit arrays.          *)
(***************************************************************)
procedure splitXsum( var sum:integer4;
                     var sumarr:sumXarr);
 var i,j:integer4;
     k:integer;
     hexnumb:char;
  
{converts integer to hexadecimal number}
procedure hexconv(decnumb:integer4; var hexnumb:char);
begin
case ord(decnumb) of
        0 : hexnumb:='0';
        1 : hexnumb:='1';
        2 : hexnumb:='2';
        3 : hexnumb:='3';
        4 : hexnumb:='4';
        5 : hexnumb:='5';
        6 : hexnumb:='6';
        7 : hexnumb:='7';
        8 : hexnumb:='8';
        9 : hexnumb:='9';
        10 : hexnumb:='A';
        11 : hexnumb:='B';
        12 : hexnumb:='C';
        13 : hexnumb:='D';
        14 : hexnumb:='E';
        15 : hexnumb:='F';
  end;
end;
  
begin
 for k:=1 to 4 do
  begin
   i:=sum mod 16;
   hexconv(i,hexnumb);
   sumarr[5-k]:=hexnumb;
   j:=sum div 16;
   sum:=j;
  end;
end;
  
(* ENHANCEMENT FOR 22RX8 & 20LH8 - ANAND B.  *)
(* FIX #607 FOR 20LH8 *)
procedure rbpXinfoXinXjedec;
(*                                                                   *)
(*-------------------------------------------------------------------*)
(*                                                                   *)
(*  PROCEDURE : RBP_INFO_IN_JEDEC                                    *)
(*  AUTHOR    : ANAND BEMRA                                          *)
(*  DATE      : 9/4/85                                               *)
(*  FUNCTION  : WRITES REGISTER BYPASS FUSE STATUS IN JED FILE.      *)
(*                                                                   *)
(*  MODIFICATIONS :                                                  *)
(*    NAME        DATE       DESCRIPTION                             *)
(*    ----------- ---------- ------------------------------------    *)
(*                                                                   *)
(*  COMMENTS  :                                                      *)
(*                                                                   *)
(*  INPUT PARAMETERS :                                               *)
(*                                                                   *)
(*    VARIABLE    TYPE       DESCRIPTION                             *)
(*    ----------- ---------- ------------------------------------    *)
(*                                                                   *)
  
var
  i : integer;
  dummyXtotout : 1..1000;
(* ENHANCEMENT #607 - ANAND B. 10/16/85 *)
begin
(* 22V10 MV 07/01/86 - 22V10 added    *)
   if (palXtype = pX22rx8) or(palXtype = pX22v10) then
   dummyXtotout := totout - 1
(* TOTOUT-1 'CAUSE PIN 25 WITH AN OFFSET OF 9 IS A DUMMY OUTPUT PIN *)
(* BALA K. #653 01/10/86 *)
  else if palXtype = pX10h20g8 then
    dummyXtotout := totout;
 for i := 1 to dummyXtotout do
  begin
  if outarr[i].rbp = 1 then
   begin
    write(f2,one);
    add(1);
    flink := flink + 1;
   end
  else
   begin
    write(f2,zero);
    add(0);
    flink := flink + 1;
   end;
(* OF FOR LOOP *)
  end;
 end;
  
  
procedure polarXfuseX32vx10;
(*                                                                   *)
(*-------------------------------------------------------------------*)
(*                                                                   *)
(*  PROCEDURE : POLAR_FUSE_32vx10                                    *)
(*  AUTHOR    : ANAND BEMRA                                          *)
(*  DATE      : 11/11/85                                             *)
(*  FUNCTION  : WRITES POLARITY FUSE INFO. IN JEDEC FILE.            *)
(*                                                                   *)
(*  MODIFICATIONS :                                                  *)
(*    NAME        DATE       DESCRIPTION                             *)
(*    ----------- ---------- ------------------------------------    *)
(*                                                                   *)
(*  COMMENTS  :                                                      *)
(*                                                                   *)
(*  INPUT PARAMETERS :                                               *)
(*                                                                   *)
(*    VARIABLE    TYPE       DESCRIPTION                             *)
(*    ----------- ---------- ------------------------------------    *)
(*                                                                   *)
  
const
  lowerXoutputXpinnumb = 14;
  upperXoutputXpinnumb = 23;
var 
  i    :  integer     ;

 begin
   inttochar;
   for i := upperXoutputXpinnumb downto lowerXoutputXpinnumb do
    begin
      if outarr[offarr[i]].polarity = 1 then
       begin
        write(f2,one);
        add(1);
        flink := flink + 1;
       end;
      if outarr[offarr[i]].polarity = 0 then
       begin
        write(f2,zero);
        flink:= flink+1;
        add(0);
       end;
    end;
  end;
(*********************************************************) {!! 4 !!}
(* MV 22V10 - BUG #1179- change in printing for jedec    *) {!! 4 !!}
(* Crude way of fixing this bug. It was a quick fix.     *) {!! 4 !!}
(* Procedure Write_Pol_Flush_fuse                        *) {!! 4 !!}
(*  Author  : Mahesh Vora                                *) {!! 4 !!}
(*  Date    : 02-06-87                                   *) {!! 4 !!}
(*  Function: This procedure prints the polarity fuse and*) {!! 4 !!}
(*            flush fuse. Hard coded data for 22v10      *) {!! 4 !!}
(*                                                       *) {!! 4 !!}
(*********************************************************) {!! 4 !!}
 procedure writeXpolXflushXfuse ; {!! 4 !!}
 {!! 5 !!}
var {!! 5 !!}
    i: integer; {!! 5 !!}
 {!! 5 !!}
  procedure writeXpolXrbp (var i : integer ;tmpXout : integer); {!! 4 !!}
  var {!! 5 !!}
    tmpXi , numXpinsXprinted  : integer   ; {!! 4 !!}
  begin {!! 4 !!}
    numXpinsXprinted   :=   0 ; {!! 4 !!}
 {!! 4 !!}
    tmpXi   :=  i ; {!! 4 !!}
    while (tmpXi <= tmpXout) and(numXpinsXprinted <> 10) do {!! 4 !!}
    begin {!! 4 !!}
     if(numXpinsXprinted <> 10) then {!! 4 !!}
     begin {!! 4 !!}
       if temparr[tmpXi]  = 1 then {!! 4 !!}
       begin {!! 4 !!}
         write (f2,one); {!! 4 !!}
         add (1)       ; {!! 4 !!}
         flink := flink + 1  ; {!! 4 !!}
         numXpinsXprinted := numXpinsXprinted + 1 ; {!! 4 !!}
       end {!! 5 !!}
       else if temparr[tmpXi]  = 0 then {!! 4 !!}
       begin {!! 4 !!}
         write (f2,zero); {!! 4 !!}
         add (0) ; {!! 4 !!}
         numXpinsXprinted := numXpinsXprinted + 1 ; {!! 4 !!}
         flink := flink + 1 ; {!! 4 !!}
       end ; {!! 4 !!}
       if outarr[tmpXi].rbp = 1 then {!! 4 !!}
       begin {!! 4 !!}
         write (f2,one) ; {!! 4 !!}
         add (1)  ; {!! 4 !!}
         flink := flink + 1 ; {!! 4 !!}
         numXpinsXprinted := numXpinsXprinted + 1 ; {!! 4 !!}
       end {!! 5 !!}
       else {!! 5 !!}
       begin {!! 4 !!}
         write (f2,zero) ; {!! 4 !!}
         add (0)         ; {!! 4 !!}
         flink := flink + 1 ; {!! 4 !!}
         numXpinsXprinted := numXpinsXprinted + 1 ; {!! 4 !!}
       end ; {!! 4 !!}
      end  ;(* END IF *) {!! 4 !!}
    tmpXi  := tmpXi  +  1  ; {!! 4 !!}
    end  ; (* end of for loop   *) {!! 4 !!}
    i  := tmpXi    ; (* Return I *) {!! 4 !!}
 end     ; (* End of nested procedure write_pol_rbp *) {!! 4 !!}
 {!! 4 !!}
 begin {!! 4 !!}
   dummyXout   :=   totinp   +  totout ; {!! 4 !!}
   dummyXout   :=   dummyXout - 1  ; {!! 4 !!}
    for i := dummyXout downto 1 do {!! 4 !!}
     if offarr[i] <> 0 then {!! 4 !!}
      temparr[offarr[i]] := outarr[offarr[i]].polarity ; {!! 4 !!}
   i   :=  1  ; {!! 4 !!}
   writeXpolXrbp (i, dummyXout); {!! 4 !!}
   writeln (f2,star)  ; {!! 4 !!}
   inttochar ; {!! 4 !!}
   writeXpolXrbp (i,dummyXout); {!! 4 !!}
   tchksum  := tchksum + lf +cr + ord(star) ; {!! 4 !!}
 {!! 4 !!}
 end  ;  (* End of Procedure Write_pol_Flush_Fuse   *) {!! 4 !!}
 {!! 4 !!}
  
  
begin
{writing the database}
writeln(f2);
(* BALA K.  Enhc #739  02/25/86  *)
{/dsy} write(f2,'Title    :',dbstr[1]); writeln(f2,chr(9),'Author  :',dbstr[4]);
{/dsy} write(f2,'Pattern  :',dbstr[2]); writeln(f2,chr(9),'Company :',dbstr[5]);
{/dsy} write(f2,'Revision :',dbstr[3]); writeln(f2,chr(9),'Date    :',dbstr[6]);
  
{dsy write(f2,'Title    :',dbstr[1]);          dsy}
{dsy writeln(f2,'     ','Author  :',dbstr[4]); dsy}
{dsy write(f2,'Pattern  :',dbstr[2]);          dsy}
{dsy writeln(f2,'     ','Company :',dbstr[5]); dsy}
{dsy write(f2,'Revision :',dbstr[3]);          dsy}
{dsy writeln(f2,'     ','Date    :',dbstr[6]); dsy}
writeln(f2);
  
{start of text}
writeln(f2,chr(stx));
{for i:=1 to max_inp+max_out do temparr[i]:=chr(0);}
for i:=1 to maxXinp+maxXout do temparr[i]:=2; {imb 3/4/85}
tchksum:=stx+lf+cr;  {imb 1/7/85}
writeln(f2,filename1);
for i:=1 to index do tchksum:=tchksum+ord(filename1[i]);
tchksum:=tchksum+lf+cr;
  
for i:=1 to 30 do if title0[i]<>' ' then write(f2,title0[i]);
for i:=1 to 30 do if title0[i]<>' ' then tchksum:=tchksum+ord(title0[i]);
writeln(f2,star);
tchksum:=tchksum + ord(star) + lf + cr; {imb}
  
{device code fiels}
(* rjs 9/12/86 bug #840,860 			*)
(* for i:=1 to 5 do 				*)
(* begin					*)
(*  if dfield[i]<>' ' then begin		*)
(*   write(f2,dfield[i]);			*)
(*   tchksum:=tchksum+ord(dfield[i]);		*)
(*  end;					*)
(* end;						*)
(* writeln(f2,star);				*)
(* tchksum:=tchksum+ord(star)+lf+cr;		*)
  
{writing the 'G0' and 'F0' field}
writeln(f2,'G0*F0*');
tchksum:=tchksum+ord('G')+ord('F') +2*ord(star)+2*ord('0')+cr+lf;
{writeln(f2,'L0000');
tchksum:= tchksum + ord('G') + ord('F') + ord('L') + 2*ord(star)
         + 6*ord('0') + 2*lf + 2*cr;} {imb}
  
flink:=0;
  
{writing the andarr, phantom fuses are not reported. Every time a fuse}
{is reported, the fuse address is incremented and tchksum and fchksum are}
{ updated}
  
for horiz := 1 to totprod do
 begin
  flag:=false;
  ix:=horiz;
  if check(ix) then begin
   inttochar;
   for vert:= 1 to totvert do
     begin
     if (vert=65) and (palXtype=pX64r32)  { for 64r32, go to }
      then                                { next line after 64 fuses}
       begin                              { are witten in a line}
        writeln(f2);
        write(f2,'       ');              { leading blanks}
        tchksum:=tchksum+cr+lf+7*ord(' ');
       end;
      ix:=horiz; iy:=vert;
      if (randarr(ix,iy)=dash) then
       begin
        flag:=true;
        write(f2,one);
        add(1);
        flink:=flink+1;
       end;
      if (randarr(ix,iy)=cross) then
       begin
        flag:=true;
        write(f2,zero);
        add(0);
        flink:=flink+1;
       end;
   end;
  if flag then
  begin
   writeln(f2,star);
{   WRITELN(F2,fchksum);  {}
   tchksum:=tchksum+lf+cr+ord(star);
   tchksmh:=tchksmh+ (tchksum div 256);
   tchksum:=(tchksum mod 256);
  end;
 end
 else
  begin
   for vert:=1 to totvert do
    begin
     iy:=vert;
     if (randarr(ix,iy)=cross) then begin
        flink:=flink+1;
(* bug fix  620    R.Steggles 06 Nov 84 *)
        if binptr=8 then binptr:=1 else binptr:=binptr+1;
     end;
    end;
  end;
 end;
  
{polarity fuse info, tchksum is updated}
(* ENHANCEMENT FOR 22RX8 -ANAND B. 9/4/85 *)
(* SINCE 22RX8 HAS A PRODUCT TERM FOR POLARITY AND NOT A POLARITY FUSE, *)
(* THERE SHOULD BE NO SEPARATE ENTRY IN JEDEC FOR POLARITY FUSE.        *)
  
if (palXtype <> pX22rx8) then
  
if polf=1 then
begin
(* ENHANCEMENT #608. ANAND B. 11/11/85 *)
(* BALA K. #641 01/10/86 *)
 if (palXtype = pX32vx10) then
   polarXfuseX32vx10
 else if (palXtype <> pX22v10) then {!! 4 !!}
 begin
dummyXout  :=  totinp  + totout   ;
 for i:= dummyXout  downto 1 do   {nas 12/3} {fuse order}
 if offarr[i]<>0 then temparr[offarr[i]]:=outarr[offarr[i]].polarity;
 inttochar;
 for i:=1 to dummyXout do     {imb 1/7/85}
  begin
   if temparr[i]=1
    then
     begin
      write(f2,one);
      add(1);
      flink:=flink+1;
     end;
   if temparr[i]=0
    then
     begin
      write(f2,zero);
      flink:=flink+1;
      add(0);
     end;
  end;
 end;
(* MV 22V10   BUG #?  *) {!! 4 !!}
 if palXtype <> pX22v10 then {!! 4 !!}
 begin {!! 4 !!}
   writeln(f2,star); {!! 4 !!}
   tchksum:=tchksum+lf+cr+ord(star); {!! 4 !!}
 end ; {!! 4 !!}
end;
  
(* to write flush fuse info. in jedec file for 10H20G8 *)
(* rjs 6feb86 bug #662 *)
  if (palXtype in [pX10h20g8]) then begin
        inttochar;
        rbpXinfoXinXjedec;
        writeln(f2,star);
        tchksum:=tchksum+cr+lf+ord(star);
  end;
  
{product term sharing info, tchksum is updated}
if ps=1 then
begin
i:=1;
while i<=totout do
 begin
  if outarr[i].shXpin<> 0 then
   begin
    start:= outarr[i].start;
    last := outarr[i].start+outarr[i].total-1;
    if last>= start then inttochar;
    for j:=start to last do
     begin
      if orarr[j,1]=cross then
        begin
         write(f2,zero);
         flink:=flink+1;
         add(0);
        end;
      if orarr[j,1]=dash then
        begin
         write(f2,one);
         flink:=flink+1;
         add(1);
        end;
      if orarr[j,2]=cross then
        begin
         write(f2,zero);
         flink:=flink+1;
         add(0);
        end;
      if orarr[j,2]=dash then
        begin
         write(f2,one);
         flink:=flink+1;
         add(1);
        end;
      if j=last then
        begin
         writeln(f2,star);
         tchksum:=tchksum+lf+cr+ord(star);
        end;
     end;
    start:=last+1;
    last:=start+outarr[i].max-outarr[i].total-1;
    if last>=start then inttochar;
    i:=i+1;
    for j:=start to last do
     begin
      if orarr[j,1]=cross then
        begin
         write(f2,zero);
         flink:=flink+1;
         add(0);
        end;
      if orarr[j,1]=dash then
        begin
         write(f2,one);
         add(1);
         flink:=flink+1;
        end;
      if orarr[j,2]=cross then
         begin
          write(f2,zero);
          add(0);
          flink:=flink+1;
         end;
      if orarr[j,2]=dash then
         begin
          write(f2,one);
          add(1);
          flink:=flink+1;
         end;
      if j=last then
         begin
          writeln(f2,star);
          tchksum:=tchksum+lf+cr+ord(star);
         end;
     end;
    i:=i+1;
  end
else
 begin
  i:=i+1;
 end;
end;
end;
  
(* ENHANCEMENT #608. ANAND B. 11/11/85 *)
(* BALA K. #641 01/10/86 *)
if (palXtype <> pX32vx10) then
begin
{register bypass info, tchksum is updated}
(* rjs 6feb86 bug #662 *)
if (rbp=1) and (palXtype <> pX10h20g8) then
 begin
  inttochar;  { integer to char}
  
(* TO WRITE FLUSH FUSE INFO. IN JEDEC FILE. SLIGHTLY DIFF. FROM MEGAPALS *)
(* 'CAUSE OF INDEPENT RBP FUSE FOR EACH OUTPUT.  *)
  
(* BALA K. #653 01/10/86 *)
(* 22V10 MV 07/01/86 - 22V10 added    *)
(* 22V10 MV 02/06/87 - BUG # ?        *) {!! 4 !!}
 {!! 4 !!}
  if (palXtype in [pX22rx8]) then {!! 4 !!}
      rbpXinfoXinXjedec
  else if (palXtype = pX22v10) then {!! 4 !!}
      writeXpolXflushXfuse {!! 5 !!}
  else
  
  for i:=1 to maxflush do
   begin
    if flarr[i]<>0 then
     if outarr[offarr[flarr[i]]].rbp = 1
      then
       begin
        write(f2,one);
        add(1);
        flink:=flink+1;
       end
      else
       begin
        write(f2,zero);
        add(0);
        flink:=flink+1;
       end;
   end;
 writeln(f2,star);
 tchksum:=tchksum+cr+lf+ord(star);
end;
end;
  
  
   {fchksum is split}
   fchksmh:=fchksmh+(fchksum div 256);
   fchksum:=(fchksum mod 256);
   fchksmh:=(fchksmh mod 256);
   fchksum:=fchksum+256*fchksmh;
  
   {tchksum is split}
   tchksmh:=tchksmh+(tchksum div 256);
   tchksum:=(tchksum mod 256);
   tchksmh:=(tchksmh mod 256);
   tchksum:=tchksum+256*tchksmh;
  
splitXsum(fchksum,fchksumarr);
write(f2,'C');
tchksum:=tchksum+ord('C');
for i:=1 to 4 do
 begin
  write(f2,fchksumarr[i]);
  tchksum:=tchksum+ord(fchksumarr[i]);
 end;
write(f2,'*');
tchksum:=tchksum+ord('*');
writeln(f2);
write(f2,chr(etx));
tchksum:=tchksum+etx+lf+cr;
splitXsum(tchksum,tchksumarr);
for i:=1 to 4 do write(f2,tchksumarr[i]);
end;
