{**  DEC/CMS REPLACEMENT HISTORY, Element XFNODE.SRC **}
{**  *9    18-JAN-1987 23:17:10 LIN "Fixed error caused to DAISY by previous bugfixing-T.C.Lin1-18-87"**}
{**  *8     6-NOV-1986 16:37:36 PALASM2 "nested comments due to NOTES of cms" **}
{**  *7     5-NOV-1986 11:05:00 VORA " fixed bug related on PC for 22V10 " **}
{**  *6     3-NOV-1986 14:52:46 CHIEN "TO SUPPORT NEW PAL TYPE 18P8" **}
{**  *5    22-OCT-1986 15:38:57 VORA "Bug #1021 is fixed " **}
{**  *4    12-OCT-1986 01:45:59 VORA " " **}
{**  *3     9-OCT-1986 10:24:34 VORA "fixed bug #833" **}
{**  *2     8-OCT-1986 13:59:44 VORA "fixed bug #801" **}
{**  *1     3-OCT-1986 15:13:04 PALASM2 "" **}
{**  DEC/CMS REPLACEMENT HISTORY, Element XFNODE.SRC **}
(*****************************************************************************)
(* This module contains the following procedures:                            *)
(*                                                                           *)
(*  procedure formnode.  (global)                                            *)
(*****************************************************************************)
{ipp program formnodeq; ipp}
{ipp pragma c_include('XPLOTINC.INC'); ipp}
{/ipp}{vax [INHERIT('pal2$inc:xplotinc.env')] module formnodeq[PUBLIC]; vax}
  

#include 'xplotinc.i'


procedure initialise; external;
{ipp procedure iandarr(jx,jy,j:integer; tlst:data_str); external; ipp}
  
(*  SOFTWARE BUG FIX FOR BUG # 350 BY C.J. 6/25/1985    *)
  
procedure error1(pinnumb,errnum:integer);external;
  
procedure error (var eqnptr:eqnnodeptr; errnum:integer);external;
procedure makenode(var newnode:nodeptr);  external;
function transname(var present:eqnnodeptr;var lstnode:nodeptr):integer;external;
procedure setparams;  external;
  
(*****************************************************************************)
(* PROCEDURE FORMNODE                                                        *)
(*                                                                           *)
(* This procedure creates the list of all the nodes defined in the CHIP      *)
(* statement. The pointer to this list is called headnodelist. Each node is  *)
(* uniquely identified by the name and the pinnumber of the signal. Special  *)
(* identification is used for VCC and GND nodes. No node is created for NC   *)
(* pin.                                                                      *)
(*                                                                           *)
(* Initially the program formnode reads the section of PALASM.TRE from the   *)
(* top of the file and till the number -2. This portion of the TRE file has  *)
(* the PDS filename, the current level of the software and the six header    *)
(* information, TITLE,PATTERN,REVISION,AUTHOR,COMPANY,DATE.                  *)
(*                                                                           *)
(* The first line of PDF file also has some answers to questions asked in    *)
(* front end. The answers are for brief xplot and jedec format of            *)
(* simulation vectors. The information regarding brief xplot is only used in *)
(* this program. Simulation answer is used in SIM program.                   *)
(*                                                                           *)
(* The PDS filename is used to create <filename>.xpt for xplot and           *)
(* <filename>.jed for jedec outputs.                                         *)
(*                                                                           *)
(* The <paltype> is used to open the right device (PDF) file.                *)
(*                                                                           *)
(* The version number is used to check the correct version of the program in *)
(* use. The check is made that the right version of PDF file is used. If     *)
(* there is a mismatch between thee versions of PDF file and the version     *)
(* read from the TRE file than an error is reported and the program quits.   *)
(*                                                                           *)
(* All the header information is stored in DBSTR array. This info,. is later *)
(* outputed on .XPT file and .JED file.                                      *)
(*                                                                           *)
(* Thee pinlist information is present in the PALASM2.TRE file between  -2   *)
(* and -3 integers. The procedure than reads each signal name, creates a     *)
(* newnode, gives a pinnumber, checks for the polarity inversion and adds    *)
(* the node to the headnodelist. If the pin is a no connect pin then         *)
  
{/dsy} {ipp procedure formnode;external; ipp}
{dsy  procedure formnode(mmi_xpt:xplot_rec_typ);external;   dsy}
{vax [GLOBAL] vax}  procedure formnode;
  
var tmpXkind,j,level,kind,ii : integer;
    junk,ch : char;
    tailnodelist : nodeptr;
    gotlevel : boolean;
    junk2 : eqnnodeptr;
    lnbf:packed array [1..dblen] of char;
  
  
begin
  
  { reading filename.PDS from PALASM2.TRE file and creating}
  { filename.XPT and filename.JED files.                   }
  
{/dsy}  for ii:=1 to index do
{/dsy}   begin
{/dsy}     xptfile[ii]:=' ';
{/dsy}     jedfile[ii]:= ' ';
{/dsy} (* REFERENCES TO DESIGN_FILE ARE A BUG FIX FOR #427. ANAND B. 7/17/85 *)
{/dsy}     designXfile[ii] := ' ';
{/dsy}   end;
  
  ch:=' ';
  ii:=1;
{dsy While (ch <> '.') and (not eoln(specstre)) and (ii <= fname_const) do dsy}
{/dsy}  while (ch<>'.') and (not eoln (specstre)) and (ii<=index) do
   begin
    if ch<>' ' then
     begin
      xptfile[ii]:=ch;
      jedfile[ii]:=ch;
      designXfile[ii] := ch;
 {!! 3 !!}
(* MV 10/08/86 - Bug #833 - Bug fixing week *) {!! 3 !!}
(* For Vax only                             *) {!! 3 !!}
{/dsy}{vax      If II > 11 Then        vax} {!! 4 !!}
{/dsy}{vax       Error (junk2 ,67)  ;  vax} {!! 4 !!}
 {!! 4 !!}
(* FOR PC ONLY                              *) {!! 3 !!}
{/fnx} {ipp If II > 8 Then                 ipp} {!! 3 !!}
{/fnx} {ipp   Error (Junk2,66) ;           ipp} {!! 3 !!}
 {!! 3 !!}
       ii := ii + 1   ; {!! 3 !!}
     end;
    read(specstre,ch);
   end;
{/dsy}  {ipp set_length(xptfile,ii-1); ipp}
  
  designXfile[ii] := '.';
  
(* MV Bug #1021 - Palasm2 F.E does not put Blank    *) {!! 5 !!}
{/dsy}  while (ch<>' ') and (not eoln(specstre)) and(ii <15)do {!! 9 !!}
{dsy  while (ch<>' ') and (not eoln(specstre)) And (II<fname_const) do  dsy} {!!9!!}
    begin
      read(specstre,ch);
      ii := ii + 1;
      designXfile[ii] := ch;
    end;
{dsy ii:=ii+1;  dsy}
{dsy for ii := ii to fname_const do  dsy}
{dsy    DESIGN_FILE[II] := ' ';  dsy}
  while (ch=' ') and (not eoln(specstre)) do read(specstre,ch);
  if not eoln(specstre) then read(specstre,ch);
  
  {brief xplot or not}
  if (ch='Y') or (ch='y') then brieflg := true else brieflg:=false;
  
  if not (eof(specstre)) then begin
  readln(specstre);
  if not (eof(specstre)) then begin
  readln(specstre);
  (* throw away CHIP *)
  ch:=' ';
  
  { reading header information till level -2 is reached.}
  { the level is the level of the token specified in the TRE file.}
  
  while (level <> -2) do
   begin
      read(specstre,level);   {nas 11/28/85}
      if (level<>-2) then
        begin
           read(specstre,kind);
           for ii:=1 to dblen do lnbf[ii]:=' ';
           ii:=1;
           while (not(eoln(specstre)) and (ii<=dblen)) do
           begin
              read(specstre,ch);  lnbf[ii]:=ch; ii:=ii+1;
           end;
           if (kind<100) then dbstr[kind-84]:=lnbf;
           if ((kind>100) and (kind<>222)) then
                tmpXkind := kind
           else
                tmpXkind :=0;
       end;
      readln(specstre);
   end;
  if tmpXkind = 0 then begin
  
  
{dsy      writeln(errfile,'File being processed: ',DESIGN_FILE);  dsy}
  
{/dsy}          writeln('File being processed: ',xptfile); {nas 2/13/84}
{/dsy}          writeln('Title    :',dbstr[1]); writeln;
{dsy      writeln(errfile,'Title    :',dbstr[1]); writeln(errfile);   dsy}
  
          for ii:=1 to 30 do title0[ii]:=' ';
          ii:=1;
          read(specstre,level,kind);
  
          while not eoln(specstre) do
           begin
            read(specstre,ch);
            if ch<>' ' then
             begin
              title0[ii]:=ch;
              ii:=ii+1;
             end;
            end;
  
          if not eof(specstre) then readln(specstre);
 (* readln(specstre);*)   (* throw away CHIP name *)
  
  (* get part type *)
  
          read(specstre,level,kind);
  
    if kind in [tkXpal16ra8,tkXpal22rx8,tkXpal32vx10,tkXpal22v10,  
                tkXpal20ra10,tkXpal20rs10,tkXpal32r16,tkXpal64r32, 
                tkXpal10h20p8,tkXpal20s10,tkXpal20rs8,tkXpal20rs4, 
                tkXpal16l8,tkXpal16r8,tkXpal16r6,tkXpal16r4,       
                tkXpal16p8,tkXpal16rp8,tkXpal16rp6,tkXpal16rp4,    
                tkXpal12l10,tkXpal14l8,tkXpal16l6,tkXpal18l4,      
                tkXpal20l2,tkXpal20c1,tkXpal20x10,tkXpal20x8,      
                tkXpal20x4,tkXpal20l8,tkXpal20r8,tkXpal20r6,       
                tkXpal20r4,tkXpal10h8,tkXpal10l8,tkXpal12h6,       
                tkXpal12l6,tkXpal14h4,tkXpal14l4,tkXpal16h2,       
                tkXpal16l2,tkXpal16c1,tkXpal8l14,tkXpal6l16,       
                tkXpal16x4,tkXpal16a4,tkXpal20l10,tkXpal10h20g8]   
     then begin  
          case kind of
(* NAS #499 7/16/85 *)
         tkXpal16ra8  : palXtype := pX16ra8;   tkXpal22rx8  : palXtype := pX22rx8;
(* BALA K. #641 01/10/86 *)
         tkXpal32vx10 : palXtype := pX32vx10;

(* 22V10 MV 07/01/86 - new token for 22V10 added *)
         tkXpal22v10 : palXtype := pX22v10;
  
         tkXpal20ra10 : palXtype := pX20ra10;  tkXpal20rs10 : palXtype := pX20rs10;
         tkXpal32r16 : palXtype := pX32r16;    tkXpal64r32  : palXtype := pX64r32;
(* BALA K. #652 01/10/86 *)
         tkXpal10h20p8 : palXtype := pX10h20p8;
         tkXpal20s10 : palXtype := pX20s10;
         tkXpal20rs8 : palXtype := pX20rs8;    tkXpal20rs4 : palXtype := pX20rs4;
         tkXpal16l8  : palXtype := pX16l8;     tkXpal16r8  : palXtype := pX16r8;
         tkXpal16r6  : palXtype := pX16r6;     tkXpal16r4  : palXtype := pX16r4;
         tkXpal16p8  : palXtype := pX16p8;     tkXpal16rp8 : palXtype := pX16rp8;
         tkXpal16rp6 : palXtype := pX16rp6;    tkXpal16rp4 : palXtype := pX16rp4;
         tkXpal12l10 : palXtype := pX12l10;    tkXpal14l8  : palXtype := pX14l8;
         tkXpal16l6  : palXtype := pX16l6;     tkXpal18l4  : palXtype := pX18l4;
         tkXpal20l2  : palXtype := pX20l2;     tkXpal20c1  : palXtype := pX20c1;
         tkXpal20x10 : palXtype := pX20x10;    tkXpal20x8  : palXtype := pX20x8;
         tkXpal20x4  : palXtype := pX20x4;     tkXpal20l8  : palXtype := pX20l8;
         tkXpal20r8  : palXtype := pX20r8;     tkXpal20r6  : palXtype := pX20r6;
         tkXpal20r4  : palXtype := pX20r4;     tkXpal10h8  : palXtype := pX10h8;
         tkXpal10l8  : palXtype := pX10l8;     tkXpal12h6  : palXtype := pX12h6;
         tkXpal12l6  : palXtype := pX12l6;     tkXpal14h4  : palXtype := pX14h4;
         tkXpal14l4  : palXtype := pX14l4;     tkXpal16h2  : palXtype := pX16h2;
         tkXpal16l2  : palXtype := pX16l2;     tkXpal16c1  : palXtype := pX16c1;
        (* NAS #362/607 10/15/85 *)
         tkXpal8l14  : palXtype := pX8l14;     tkXpal6l16  : palXtype := pX6l16;
         tkXpal16x4  : palXtype := pX16x4;     tkXpal16a4  : palXtype := pX16a4;
         tkXpal20l10 : palXtype := pX20l10;
(* BALA K. #653 01/10/86 *)
         tkXpal10h20g8 : palXtype := pX10h20g8;
(* CJ 10/31/86 - TO SUPPORT NEW PAL TYPE 18P8 *) {!! 6 !!}
         tkXpal18p8 : palXtype := pX18p8; {!! 7 !!}
  
(* 5/6/86 Amiram Neiman  BUG #805 *)
(* MV 10/06/86 - Bug #805 - Bug fixing week *) {!! 2 !!}
(* Apperantly this bug was fixed by Amir but probably not tested. *) {!! 2 !!}
(* Also error 54 doesnot seems to be appropriate for this bug so  *) {!! 2 !!}
(* added error no 64                                              *) {!! 2 !!}
        end;
    end else error(junk2,64);  {!! 4 !!}
  
{ transplanted initialiazation - NAS 4/26/85 }
(* ENHANCEMENT FOR 22RX8 FOR THE PC. ANAND B. 9/6/85 *)
(* ALTHOUGH ACTUAL ARRAY FOR 22RX8 IS 82 BY 44, 88X48 IS CHOSEN 'CAUSE OF*)
(* DIVISIBILITY BY 8 *)
(* ENHANCEMENT #608. ANAND B. 11/11/85 *)
(* BALA K. #641 01/15/86 *)
(* MV 22V10 - Generic problem on PC for 22V10 - Changed array size   *) {!! 7 !!}
{ipp CASE KIND OF ipp} {!! 8 !!}
{ipp        tk_pal64r32 : iandarr(256,128,4,'X-0O           ') ;ipp} {!! 8 !!}
{ipp        tk_pal32r16 : iandarr(128,64,4,'X-0O           ');ipp} {!! 8 !!}
{ipp        tk_pal22rx8 : iandarr(88,48,4,'X-0O           ');ipp} {!! 8 !!}
{ipp        tk_pal22v10 : IANDARR(152,64,4,'X-0O           '); ipp}{!! 7 !!} {!!8!!}
{ipp        tk_pal32vx10 : IANDARR(152,64,4,'X-0O           ');ipp} {!! 8 !!}
{ipp        otherwise     iandarr(80,40,4,'X-0O           ');ipp} {!! 8 !!}
{ipp      END; ipp} {!! 8 !!}
  
  initialise;        { Initilise the heap and variables}
  new(headeqlist);
  new(headnodelist);
  
  for j := 1 to index do namex[j] := chr(0);
  level := 1;
  pinXnumber := 0;
  new(headnodelist);
  tailnodelist := headnodelist;
  read(specstre,level);
  gotlevel := true;
  
  { read signal names from the palasm2.tre file till level -3 is reached}
  { if the token kind read is tk_not, then switch_pol to true. This means}
  { that the signal has to be inverted.                                  }
  
  while (level <> -3) do begin
  
    if not(gotlevel) then read(specstre,level);
    gotlevel := false;
  
    if (level <> -3) then begin
  
    read(specstre,kind);
  
    for j := 1 to index do namex[j] := chr(0);
    switchXpol := false;
  
    if (kind = tkXnot) then begin   {inverted signal}
      switchXpol := true;
      readln(specstre);
      read(specstre,level,kind)
    end;
  
    if (kind = tkXgnd) then begin   { GND pin }
      new(tailnodelist^.next);
      tailnodelist := tailnodelist^.next;
      namex[1] := 'G';
      namex[2] := 'N';
      namex[3] := 'D';
      kind := 1;
      for j := 1 to index do tailnodelist^.name[j] := namex[j];
      pinXnumber := pinXnumber + 1;
      makenode(tailnodelist);
      tailnodelist^.kind:=i;
      tailnodelist^.polarity := 'H';
      tailnodelist^.pinXnum  := pinXnumber;
      readln(specstre);
  
 (* SOFTWARE BUG FIX FOR BUG # 350 BY C.J. 6/25/85    *)
      case palXtype of
      pX14l8,pX16l6,pX18l4,pX20l2,pX20c1,pX20l10,pX20x10,pX20x8,pX20x4,
      pX20l8,pX20r8,pX20r6,pX20r4,pX12l10,pX20s10,pX20rs4,pX20rs8,pX20rs10,
(* NAS #499 7/16/85 *)
(* BALA K. #641 01/10/86 *)
      pX32vx10,pX22rx8,pX22v10,
(* NAS #362 10/14/85 *)
      pX8l14,pX6l16,pX20ra10 :
      begin
          if pinXnumber<>12
              then error1(pinXnumber,50);
      end;
      pX10h8,pX12h6,pX14h4,pX16h2,pX16c1,pX10l8,pX12l6,pX14l4,pX16l2,pX16l8,
      pX16r8,pX16r6,pX16r4,pX16x4,pX16a4,pX16p8,pX16rp8,pX16rp6,pX16rp4,
(* NAS #499 7/16/85 *)
      pX16ra8 :
(* NAS #362 10/14/85 *)
      begin
           if pinXnumber <>10
              then error1(pinXnumber,50);
      end;
      pX32r16:begin
              if pinXnumber<>30
                  then error1(pinXnumber,50);
              end;
      pX64r32:begin
              if (pinXnumber <> 11)and (pinXnumber <>53)
                  then error1(pinXnumber,50);
              end;
(* NAS #607 10/14/85 *)
(* BALA K. #653 01/10/86 *)
      pX10h20g8,
(* BALA K. #652 01/10/86 *)
      pX10h20p8:if(pinXnumber<>12)
               then error1(pinXnumber,50);
      end;
    end
    else if (kind = tkXvcc) then begin    {VCC pin}
      new(tailnodelist^.next);
      tailnodelist := tailnodelist^.next;
      namex[1] := 'V';
      namex[2] := 'C';
      namex[3] := 'C';
      kind :=1;
      for j := 1 to index do tailnodelist^.name[j] := namex[j];
      pinXnumber := pinXnumber + 1;
      makenode(tailnodelist);
      tailnodelist^.kind:=i;
      tailnodelist^.polarity := 'H';
      tailnodelist^.pinXnum:=pinXnumber;
      readln(specstre);
  
      (* SOFTWARE BUG FIX FOR BUG # 350 BY C.J. 6/25/1985   *)
      case palXtype of
      pX14l8,pX16l6,pX18l4,pX20l2,pX20c1,pX20l10,pX20x10,pX20x8,pX20x4,
      pX20l8,pX20r8,pX20r6,pX20r4,pX12l10,pX20s10,pX20rs4,pX20rs8,pX20rs10,
(* NAS #499 7/16/85 *)
(* BALA K. #641 01/10/86 *)
      pX32vx10,
      pX22rx8,
      pX22v10,
(* NAS #362 10/14/85 *)
      pX8l14,pX6l16,pX20ra10 :
      begin
           if pinXnumber <> 24
               then error1(pinXnumber,51);
      end;
      pX10h8,pX12h6,pX14h4,pX16h2,pX16c1,pX10l8,pX12l6,pX14l4,pX16l2,pX16l8,
      pX16r8,pX16r6,pX16r4,pX16x4,pX16a4,pX16p8,pX16rp8,pX16rp6,pX16rp4,
(* NAS #499 7/16/85 *)
      pX16ra8 :
(* NAS #362 10/14/85 *)
      begin
        if pinXnumber <> 20
             then error1(pinXnumber,51);
      end;
      pX32r16:if pinXnumber <>10
                then error1(pinXnumber,51);
      pX64r32:if (pinXnumber <>32) and (pinXnumber <> 74)
                then error1(pinXnumber,51);
(* NAS #607 10/14/85 *) (* RJS #619 *)
(* BALA K. #653 01/10/86 *)
      pX10h20g8,
(* BALA K. #652 01/10/86 *)
      pX10h20p8:if(pinXnumber<>6)and(pinXnumber<>19)and(pinXnumber<>24)
               then error1(pinXnumber,51);
      end;
    end
    else if (kind = tkXnc) then begin     (* kind 27 is NO CONNECT *)
      pinXnumber := pinXnumber + 1;       { increment the pin number}
      readln(specstre)
    end
    else if (kind = tkXarray) then begin   { array id}
      readln(specstre);
      level := transname(junk2,tailnodelist);
      while (tailnodelist^.next <> nil) do begin
        tailnodelist := tailnodelist^.next;
        pinXnumber := pinXnumber + 1;
        tailnodelist^.pinXnum := pinXnumber
      end;
      gotlevel := true
    end
    else if (kind = tkXid) then begin      { plain id}
      new(tailnodelist^.next);
      tailnodelist := tailnodelist^.next;  {add to the list}
      pinXnumber := pinXnumber + 1;        {incr. pinnumber}
      tailnodelist^.pinXnum := pinXnumber;
      while (specstre^ = chr(32)) do read(specstre,junk);
      j := 1;
      while not(eoln(specstre)) do begin              {read signal name}
        if (j <= index) then read(specstre,namex[j]);
        j := j + 1
      end;
      for j := 1 to index do tailnodelist^.name[j] := namex[j];
      makenode(tailnodelist);                         {make a newnode}
      readln(specstre)
    end
    end
  end;
  readln(specstre);
  headnodelist := headnodelist^.next;  {add to the headnodelist}
 end
 else error(junk2,0);
 end
 else error(junk2,0);
 end
 else error(junk2,0);
end;
