
/* #define DR_ERRM 1*/
/* #define DR_TRCM 1 */
#define DR_ANCM 1

#include "dr.h"
#if NDR > 0 || Ndr > 0 

/*
 * IKON 10084 VMEbus DR11-W EMULATOR for Integrated Solutions system 
 */ 

#include "../machine/pte.h"
#include "../h/param.h"
#include "../h/systm.h"
#include "../h/buf.h"
#include "../h/conf.h"
#include "../h/dir.h"
#include "../h/user.h"
#include "../h/map.h"
#include "../h/vm.h"
#include "../h/cmap.h"
#include "../h/uio.h"
#include "../h/kernel.h"
#include "../h/ioctl.h"
#include "../is68kdev/qbvar.h"
#include "../is68kdev/drreg.h"


/* The following is a  structure type that corresponds to
 * the 10084 board's register set.
 *
 * Note that some registers appear at 
 * different offsets, depending on whether
 * they are being written or read.
 *
 * The dma address register is 24 bits
 * wide - the low 16 bits are accessed as 
 * a ushort value.
 * The high 8 bits may be accesses as a char at one address 
 * or a as a ushort at the next lower work address.
 */

struct  drdevice   {
     ushort   dr_cstat;     	/* control and status sregisters*/
     ushort   dr_data;     	/* input and output data registers*/
     char     dr_addmod;     	/* address modifier for dma*/
     char     dr_intvect;     	/* interrupt vector*/
     ushort   dr_pulse;     	/* pulse command register*/
     ushort   dr_xx08;     	/* not used*/
     ushort   dr_xx0A;     	/* not used*/
     ushort   dr_xx0C;     	/* not used*/
     ushort   dr_xx0E;     	/* not used*/
     ushort   dr_xx10;     	/* not used*/
     ushort   dr_walo;     	/* low dma add register--when written*/
     ushort   dr_range;     	/* dma range counter*/
     ushort   dr_ralo;     	/* low dma add register--when read*/
     ushort   dr_xx18;     	/* not used*/
     char     dr_xx1A;     	/* not used*/
     char     dr_wahi;     	/* high dma add register--when written*/
     ushort   dr_xx1C;     	/* not used*/
     char     dr_xx1E;      	/* not used*/
     char     dr_rahi;     	/* high dma add register--when read*/
     };
/*
 * DR controller addresses
 */
u_short *DRstd[] = {
#ifdef  M68020
		(u_short *)0xFFFE00,  (u_short *)0xFFFF00,
#else	M68020
		(u_short *)0x7FFE00,  (u_short *)0x7FFF00,
#endif	M68020
		0 };
		
/* Declare the local buffer - actually the local buffer header */
struct   buf   drbuf[NDR];

/*
 * this structure is used to hold pointers, flags, commands, and status for
 * the dr11 driver.
 */

struct   dr_aux	{
     struct     drdevice     *dr_pcurad;/* the physical address of active dr11*/
     struct     buf     *dr_actf;     	/* these pointers to the drdevice */
     struct     buf     *dr_actl;
     ushort     dr_flags;          	/* will hold open, active, etc*/
     ushort     dr_cmd;
     ushort     dr_istat;		/* latest interrupt status */
     ushort     dr_time;     		/* # of tocks until time-out*/
     ushort     dr_tock;     		/* # of tocks accumulated*/
     ushort     dr_cseq;     		/* current sequence number*/
     ushort     dr_lseq;     		/* same name for type and struct*/
} dr_aux[NDR];

/* Buffer headres used to pass ioctl commands to the internal routines */
struct	buf	cldbuf[NDR];

int	drprobe(),	drslave(),	drattach(),	drintr();
int	drminphys();
struct	qb_ctlr		*drcinfo[NDR];
struct	qb_device	*drdinfo[NDR];

typedef unsigned short *iaddr_t; 
#define UNIT(dev)      (minor(dev)>>3)
#define DRADDR(dev)    ((struct drdevice *)(drdinfo[UNIT(dev)])->qi_mi->qm_addr) 
/*
 * DR/dr controller/device driver structure
 */
struct	qb_driver DRdriver =
	{ drprobe, drslave, drattach, DRstd, "dr", drdinfo, "DR",drcinfo };

static int fvec;
		
/*
 * Check that controller exists.
 */ 

drprobe(draddr)
	register struct drdevice *draddr;
{
        register ushort temp;

	fvec = freevec();
	draddr->dr_intvect = fvec;
	draddr->dr_addmod = DRADMD; 
	draddr->dr_walo = 0x8000;
	draddr->dr_wahi = 0x00;
	draddr->dr_data = DR_PADD;
	temp=draddr->dr_cstat; 
	if ( (temp&ATTN) == ATTN ){ 
		draddr->dr_range = PAD_NUM;
		temp = IENB | GO;
		draddr->dr_pulse = temp;
        	temp = CYCL;
        	draddr->dr_pulse = temp;
	}else{
		temp = MCLR;
		draddr->dr_cstat = temp;
		draddr->dr_range = 0x00;
		temp = IENB | RATN;
		draddr->dr_cstat = temp;
		temp = CYCL | GO;
		draddr->dr_pulse = temp;
		}
        DELAY(100); 
        if ((draddr->dr_cstat&REDY) != REDY)
		return (0);
	return (sizeof (struct drdevice));
}

drslave(qi,draddr)
	register struct	qb_device	*qi;
	register struct drdevice	*draddr;
{
        if ((draddr->dr_cstat&REDY) != REDY)
		return (0);
	return (1);
}

drattach(qi)
        register struct qb_device	*qi;
{
	register struct drdevice *draddr;
	register ushort status;
	register ushort temp;
	register struct dr_aux	*drstat;

	draddr = (struct drdevice *)qi->qi_mi->qm_addr;
	drstat = &dr_aux[qi->qi_mi->qm_ctlr];
     	drstat->dr_flags=DR_PRES; 	/* clears all-sets pres*/
     	drstat->dr_pcurad=draddr;
	draddr->dr_intvect = fvec;
	temp=MCLR;
     	draddr->dr_cstat=temp;
dummy00:
	status=draddr->dr_cstat;
#ifdef DR_ANCM
printf("dr11 present, initial status = 0x%x\n",draddr->dr_cstat);
#endif DR_ANCM
	drstat->dr_istat = 0;
	drstat->dr_flags = DR_PRES;
	drstat->dr_cmd=0;
}

drreset()
{
}
/*
 * drwatch() is the local watchdog time.  It is called by the system
 * clock routine approximately every 10 seconds.
 */

drwatch(argg)
register u_short *argg;   			/* not currently used*/
{

	register struct qb_ctlr *qm;
	register struct drdevice *draddr;
	register int ctlr, intlevel;
	ushort temp;
	register struct buf *bp;
        register struct dr_aux *drstat;
        register int unit;
	register struct buf *dp;
	register struct qb_device *qi;
        register dev_t dev;
#ifdef DR_TRCM
printf("drwatch() called\n"); 
#endif DR_TRCM

for (ctlr = 0; ctlr < NDR; ctlr++) {
	qm = drcinfo[ctlr];
	bp = qm->qm_tab.b_actf;
        dp = &cldbuf[ctlr];
        dev = dp->b_dev;
	unit= UNIT(dev);
	qi = drdinfo[unit];
	draddr = (struct drdevice *)qm->qm_addr;
	drstat = &dr_aux[qm->qm_ctlr];
	if(drstat->dr_cseq != drstat->dr_lseq){
		drstat->dr_tock = 0;
	} else {
		if(drstat->dr_flags & DR_ACTV) {     	
			drstat->dr_tock++;
			if (drstat->dr_tock >= drstat->dr_time) {     
#ifdef DR_TRCM
printf("timeout waiting for dma end-of-range\n");
#endif DR_TRCM
				temp = RMSK;
				draddr->dr_pulse = temp; /*use pulse register*/
				temp = MCLR;
				draddr->dr_pulse = temp;
				drstat->dr_flags &= ~DR_ACTV;
				drstat->dr_flags |= DR_TMDM;     
				bp = drstat->dr_actf;
				bp->b_flags |= B_ERROR; /* flag error*/
				iodone(bp);
				}
		};
		if(drstat->dr_flags & DR_ATWT) {	
			drstat->dr_tock++;     
			if(drstat->dr_tock >= drstat->dr_time) {     
#ifdef DR_TRCM
printf("timeout waiting for attention\n");
#endif DR_TRCM
			temp= RMSK;
			draddr->dr_pulse = temp;
			drstat->dr_flags &= ~DR_ATWT;
			drstat->dr_flags |= DR_TMAT;     /* set timeout flag*/
						/* Wake up drioctl(). */
			dp = &cldbuf[qi->qi_ctlr];
			wakeup((caddr_t)dp);
			}
		};
	}
	if(drstat->dr_flags & DR_OPEN){
#ifdef DR_TRCM
printf("calling timeout when OPENED\n");
#endif DR_TRCM
		timeout(drwatch,(caddr_t)&dr_aux[unit],DR_TICK);
                }
	drstat->dr_lseq = drstat->dr_cseq;
} 
return;
}

dropen(dev, flag)
dev_t dev;
int flag;
{
	register int			unit = UNIT(dev);
	register struct drdevice *draddr = DRADDR(dev);
	register ushort temp;
        register struct dr_aux *drstat;
	register struct qb_device	*qi;

#ifdef DR_TRCM
printf("dropen called");
#endif DR_TRCM

	qi = drdinfo[unit];
	drstat = &dr_aux[qi->qi_mi->qm_ctlr];

	if (unit >= Ndr || (qi = drdinfo[unit]) == 0 || qi->qi_alive == 0)
		return (ENXIO);  	/* dr11 not present*/
	if (drstat->dr_flags & DR_OPEN)
		return (ENXIO);  	/* dr11 already open */
	drstat->dr_flags | = DR_OPEN;    /* set to open  to avoid multi opens*/
	temp = DR_ZERO;    		/* clear funtion and*/
	draddr->dr_cstat = temp;     	/* int enable latches*/
	temp = ( RDMA | RATN);     	/* clear left over attn*/
	draddr->dr_pulse = temp;     	/* and e-o-r flags*/

/* Attempt to establish a local watch dog time.  This call will start it
 * -- it will continue to call itself as long as the dr11 is open
 */ 
	drstat->dr_time = DR_TOCK;
	drstat->dr_cseq = 1;
	drstat->dr_lseq = 0;
	timeout(drwatch,(caddr_t)&dr_aux[unit],DR_TICK);
	return (0);
}

drclose(dev,flag)
dev_t dev;
int flag;
{
	register int			unit = UNIT(dev);
	register struct drdevice *draddr = DRADDR(dev);
	register ushort temp;
	int intlevel;
        register struct dr_aux *drstat;
	register struct qb_device	*qi;

#ifdef DR_TRCM
printf("drclose called");
#endif DR_TRCM
	qi = drdinfo[unit];
	drstat = &dr_aux[qi->qi_mi->qm_ctlr];
	if (!(drstat->dr_flags & DR_OPEN)) {
#ifdef DR_ERRM
printf("dr11 already closed");
#endif DR_ERRM
	return;
	}
	drstat->dr_flags &= ~DR_OPEN;     
	intlevel = spl5();     /* protect int mask clear*/
	temp = DR_ZERO;
	draddr->dr_cstat = temp;
	splx(intlevel);
	return;
}

drstrategy(bp)
register  struct  buf  *bp;
{
	register struct qb_device *qi;
        register struct dr_aux *drstat;
	register int unit;
	register struct drdevice *draddr;
	register ushort temp;
	register unsigned int bufadr;
	ushort   status;
	int      intlevel;

#ifdef DR_TRCM
printf("drstrategy called\n");
#endif DR_TRCM
	unit = dkunit(bp);
	qi = drdinfo[unit];
	draddr = (struct drdevice *)qi->qi_mi->qm_addr;
	drstat = &dr_aux[qi->qi_mi->qm_ctlr];
					/* make sure dr11 has been opened*/
	if (unit >= Ndr)
		goto bad;
	if ((qi = drdinfo[unit]) == 0 || qi->qi_alive == 0)
		goto bad;
					/* make sure that dr11 */
					/*isn't busy when drstrategy is called*/
	if (drstat->dr_flags & DR_ACTV) 
		goto bad;		/* dr11 already active*/
#ifdef DR_TRCM
printf("starting dma set-up sequence\n");
#endif DR_TRCM
	bufadr = qbaddr(bp);
	drstat->dr_actf = bp;
	draddr->dr_walo = (ushort)(bufadr >> 1); /* right shift one bit*/
	draddr->dr_wahi = (char)(bufadr >> 17); /* get high byte & shift*/
#ifdef DR_TRCM 
printf("transfer count = 0x%x\n",bp->b_bcount);
#endif DR_TRCM
	if(bp->b_bcount>0x20000) 
		goto bad; 	/* will be greater than 64K words*/
	temp = (ushort)((bp->b_bcount >> 1) -1);
	draddr->dr_range = temp;
	temp = DRADMD;
	draddr->dr_addmod = (char)temp;
	if ( !(bp->b_flags & B_READ)) {
#ifdef DR_TRCM
printf("attempting dma write\n");
#endif DR_TRCM
	}  else  {
#ifdef DR_TRCM
printf("attempting dma read\n");
#endif DR_TRCM
	}
#ifdef DR_TRCM 
dumm0:	status = draddr->dr_ralo;
     printf("low address read back = 0x%x\n", status);
dumm1:     status = (ushort)(draddr->dr_rahi);
     printf("high address read back = 0x%x\n", status);
dumm2:     status = draddr->dr_range;
     printf("range read back = 0x%x\n", status);
dumm3:    status = (ushort)(draddr->dr_addmod);
     printf("address modifier read back = 0x%x\n", status);
dumm4:     status = (ushort)(draddr->dr_intvect);
     printf("interrupt vector read back = 0x%x\n", status);
#endif DR_TRCM

/* Clear dmaf and attf to assure a clean dma start */ 
	temp = (RDMA | RATN);
	draddr->dr_pulse = temp;
	if(drstat->dr_cmd & DR_DFCN) {     	
#ifdef DR_TRCM
printf("deferred function bit write\n");
#endif DR_TRCM
		drstat->dr_cmd &= ~DR_DFCN;
		temp = (drstat->dr_cmd & DR_FMSK);       /* mask out fcn bits */
		draddr->dr_cstat = temp;
		}
/* increment sequence counter for watchdog timer*/
	drstat->dr_cseq++;
	drstat->dr_flags |= DR_ACTV;
#ifdef DR_TRCM
printf("issuing go\n");
#endif DR_TRCM
	temp = IENB | GO;
	draddr->dr_pulse = temp;
	if(drstat->dr_cmd & DR_PCYL) {     
#ifdef DR_TRCM
printf("software cycle request\n");
#endif DR_TRCM
		drstat->dr_cmd &= ~DR_PCYL;     /* clear request*/
		temp = CYCL;
		draddr->dr_pulse = temp;     /* use pulse reg again*/
		}

/* Now check for deferred aclo fnct2 pulse request -- usually to tell
 * the transmitter (via its attention) that we have enabled dma
 */
	if(drstat->dr_cmd & DR_DACL) {     
#ifdef DR_TRCM
printf("sending deferred aclo pulse\n");
#endif DR_TRCM
		drstat->dr_cmd &= ~DR_DACL;     /* clear request*/
		temp = FCN2;
		draddr->dr_pulse =temp;     /* pulse aclo fcn2 sig */
		}
	return;

bad:  	bp->b_flags |= B_ERROR;
	iodone(bp);
#ifdef DR_TRCM
printf("dr11 not open when read or write attempted");
#endif DR_TRCM
	return;
}

drwrite(dev, uio)
dev_t dev;
struct uio	*uio;
{
	register int	unit = UNIT(dev);

#ifdef DR_TRCM
printf("drwrite called\n");
#endif DR_TRCM
	if(unit >= Ndr)
		return (ENXIO);
	return (physio(drstrategy, &drbuf[unit], dev, B_WRITE,drminphys,uio));
}

drread(dev,uio)
dev_t dev;
struct uio	*uio;
{
	register int	unit = UNIT(dev);

#ifdef DR_TRCM
printf("drread called\n");
#endif DR_TRCM
	if(unit >= Ndr)
		return (ENXIO);
return (physio(drstrategy,&drbuf[unit],dev,B_READ,drminphys, uio));
}

drminphys(bp)
struct buf	*bp;
{
	bp->b_bcount = min(bp->b_bcount, 0x20000);
}

drintr(ctlr)
register int	ctlr; 
{
	register struct qb_ctlr  *qm = drcinfo[ctlr];
	register struct drdevice *draddr = (struct drdevice *)qm->qm_addr; 
	register struct buf *bp = qm->qm_tab.b_actf ;
	register ushort temp,lstate;
	register ushort status;
        register struct dr_aux *drstat;
	register struct buf *dp;
        register int unit;
	register struct qb_device *qi;
	register dev_t dev;

#ifdef DR_TRCM
printf("drintr.....stat= %x\n",draddr->dr_cstat);
#endif DR_TRCM
	drstat = &dr_aux[ctlr];
	bp = drstat->dr_actf;
dumy0:  status=draddr->dr_cstat;
	drstat->dr_istat = status;     	/* save interrupt status */
#ifdef DR_TRCM
printf("status at interrupt time = 0x%x\n",status);
#endif DR_TRCM

/* Make sure that the dr11 is really interrupting -- at least one of
 * attf or dmaf must be set.
 * If neither is set this is a spurious interrupt -- a very serious
 * hardware or software error 
 */ 

	if (!(status & (ATTF | DMAF))) {
		bp->b_flags |= B_ERROR;
#ifdef DR_ERRM
printf("dmaf or attf not set when interrupt received\n");
#endif DR_ERRM
		}
	if(status & DMAF) {
		drstat->dr_flags |= DR_DMAX;
#ifdef DR_TRCM
printf("dma end of range interrupt\n");
#endif DR_TRCM
		if(!(drstat->dr_flags & DR_ACTV)) {   
#ifdef DR_ERRM
printf("e-o-f interrupt when dma not active\n");
#endif DR_ERRM
			bp->b_flags |= B_ERROR;    /* repsort error*/
			} else {
			drstat->dr_flags &= ~DR_ACTV;
			iodone (bp);
			}
	temp = RDMA;
	draddr->dr_pulse = temp;
	}
/* Now test for attention interrupt -- it may be set in addition to the
 * dma end of range interrupt.  If we get one we will issue a wakeup to the
 * drioctl() routine which is presumable waiting for one. 
 */
	if(status & ATTF) {
		drstat->dr_flags |= DR_ATRX;
#ifdef DR_TRCM
printf("attention interrupt received\n");
#endif DR_TRCM
		drstat->dr_flags &= ~DR_ATWT;
		temp = RATN;
		draddr->dr_pulse = temp;
        	dp = &cldbuf[ctlr];
        	dev = dp->b_dev;
		unit= UNIT(dev);
		qi = drdinfo[unit];
		dp = &cldbuf[qi->qi_ctlr];
		wakeup((caddr_t)dp);
		}
	return;
}

drioctl(dev, cmd, usraddr)
dev_t dev;
int cmd;
iaddr_t usraddr;
{

	register int			unit = UNIT(dev);
	register struct drdevice *draddr = DRADDR(dev);
	register ushort temp;
	register ushort status;
        register struct qb_device  *qi;
        register struct dr_aux *drstat;
	register struct buf	*bp;
	ushort arg[8];                  /*holds in and out command/status*/
	int intlevel;
        register int i;
        register u_short *p1,*p2;

	qi = drdinfo[unit];
	drstat = &dr_aux[qi->qi_mi->qm_ctlr];
	bp = &cldbuf[qi->qi_ctlr];
        p1 = arg;
        p2 = usraddr;
        for (i=0; i<4; i++){
		*p1++ = *usraddr++;
		} 
	drstat->dr_cmd = (ushort)cmd;
#ifdef DR_TRCM
printf("drioctl() called\n");
printf("command = 0x%x\n",drstat->dr_cmd);
printf("arg[0] = 0x%x\n",arg[0]);
printf("arg[1] = 0x%x\n",arg[1]);
#endif DR_TRCM

	if(drstat->dr_cmd & ~(DR_WAIT | DR_RSET | DR_PIOW | DR_PACL
		| DR_SFCN | DR_FMSK | DR_RPER | DR_STIM
		| DR_DACL | DR_PCYL | DR_DFCN | DR_RATN | DR_RDMA 
		| DR_STGO | DR_PFN1 | DR_PFN3 | DR_STAT ))
                return (EINVAL);        /* invalid argument */       
	if(drstat->dr_cmd & DR_STIM) {    
#ifdef DR_TRCM
printf("setting time-out, value = 0x%x\n",arg[1]);
#endif DR_TRCM
		drstat->dr_time = arg[1];  
		}
	if(drstat->dr_cmd & DR_PIOW) {   
#ifdef DR_TRCM
printf("writing to p-i/o outpuit, value = 0x%x\n",arg[0]);
#endif DR_TRCM
		temp = arg[0];  
		draddr->dr_data = temp;  	/* write to p-i/o reg*/
		}
	if(drstat->dr_cmd & DR_RATN) { 
#ifdef DR_TRCM
printf("clearing dr11 attn flag\n");
#endif DR_TRCM
		temp = RATN;
		draddr->dr_pulse = temp;  /* use pulse register*/
		}
	if(drstat->dr_cmd & DR_RDMA) { 
#ifdef DR_TRCM
printf("clearing dr11 dmaf flag\n");
#endif DR_TRCM
		temp = RDMA;
		draddr->dr_pulse = temp;  /* use pulse register*/
		}
	if(drstat->dr_cmd & DR_RPER) {  
#ifdef DR_TRCM
printf("clearing parity error flag in drioctl\n");
#endif DR_TRCM
		temp = RPER;
		draddr->dr_pulse = temp;  /* use pulse register*/
		}
	if(drstat->dr_cmd & DR_RSET) {  
#ifdef DR_TRCM
printf("issuing mclr to dr11\n");
#endif DR_TRCM
		temp = MCLR;
		draddr->dr_pulse = temp;  /* use pulse register*/
		}
	if(drstat->dr_cmd & DR_SFCN) {   
		temp = (drstat->dr_cmd & DR_FMSK);   /* get function bits*/
#ifdef DR_TRCM
printf("fcn bits set in drioctl(), value = 0x%x\n",temp);
#endif DR_TRCM
		draddr->dr_cstat = temp;  /* write to control reg*/
		}
	if(drstat->dr_cmd & DR_STGO) {   
#ifdef DR_TRCM
printf("GO bit set in drioctl(), value = 0x%x\n",DR_STGO);
#endif DR_TRCM
		temp = GO;
		draddr->dr_cstat = temp;
                }
	if(drstat->dr_cmd & DR_PACL) {  
#ifdef DR_TRCM
printf("pulsing aclo fnct2 in drioctl()\n");
#endif DR_TRCM
		temp = FCN2;
		draddr->dr_pulse = temp;  /* use pulse register*/
		}
	if(drstat->dr_cmd & DR_WAIT) {  
#ifdef DR_TRCM
printf("waiting for attn interrupt in drioctl()\n");
#endif DR_TRCM

/* The setting of the dr11 interrupt enable latch and the call to sleep
 * will be protected from dr11 interrupts by raising the porocessor
 * prisority above that of hte dr11 (it is assumed to be interrupt
 * prisority 4 or lower).  
 */
		intlevel = spl5();
		if(!(drstat->dr_flags & DR_ATRX)) {  
			drstat->dr_cseq++;
			drstat->dr_flags |= DR_ATWT;     /* set waiting flag  */
			temp = IENB;                    /* enable interrupts */
			draddr->dr_pulse = temp;        /* use pulse register */
			sleep((caddr_t)bp,PRIBIO); 
				/*sleep((caddr_t)&(waitloc[unit]),PRIBIO); */
			}
	splx(intlevel);     				/*restore intrupt lvel*/
	}

#ifdef DR_TRCM
printf("reading status values in drioctl()\n");
#endif DR_TRCM
dmmy0: arg[0] = drstat->dr_flags;
       drstat->dr_flags &= ~(DR_ATRX | DR_DMAX | DR_TMAT | DR_TMDM);
dmmy1: arg[1] = draddr->dr_cstat;
dmmy2: arg[2] = drstat->dr_istat;
dmmy3: arg[3] = draddr->dr_data;
dmmy4: status = (ushort)(draddr->dr_addmod) << 8;
dmmy5: arg[4] = status | (ushort)(draddr->dr_intvect);
dmmy6: arg[5] = draddr->dr_range;	        /* range counter*/
dmmy7: arg[6] = (ushort)(draddr->dr_rahi);      /*hi address register*/
dmmy8: arg[7] = draddr->dr_ralo;     	        /*lo address register*/
        p1 = arg;
        for (i=0; i<8; i++){
		*p2++ = *p1++;
		} 
	return (0);
}
#endif
