/*
 * (C) COPYRIGHT 1986
 * AIM TECHNOLOGY INCORPORATED ALL RIGHTS RESERVED
 */

char sccs_id[] = "%W% %G%  --  AIM Benchmarks Suite III  SERIALNO\n";

#include <stdio.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <signal.h>
#include <ctype.h>

#ifdef SYS3
#include <termio.h>
#else					/* Version 7 or 4.2BSD */
#include <sgtty.h>
#endif

#ifndef ZILOG				/* zilog chose to change some names */
#include <setjmp.h>
#else					/* everyone else left them alone */
#include <setret.h>
#define setjmp(x) setret(x)
#define longjmp(x,y) longret(x,y)
typedef ret_buf jmp_buf;
#endif

#include "ttytest.h"

#define TIMEOUT -11
#define TIME 2

char list[] = "a\nb\nc\nd\ne\nf\ng\nh\ni\nj\nk\nl\nm\nn\no\np\n";
struct ttdata mydata = {0L,0L,0L};
int ractive = 1;
int thepipe;
jmp_buf env;
jmp_buf tmo_env;

int rstopper(),rstarter(),render();
int timer();
long atol();

main(argc,argv)
int argc;
char **argv;
{
    int nread,nwrote;
    int c,lastc;
    int done = 0;
    register int index = 0,bindex = 0;	/* index to expected char sequence */

    if(argc < 2)  {
	fprintf(stderr,"%s: usage fdes\n",argv[0]);
	exit(1);
    }
    thepipe = (int)atol(argv[1]);
    nwrote = 1;
    write(thepipe,&nwrote,sizeof nwrote);
    signal(SIGHUP,rstopper);
    signal(SIGINT,rstarter);
    signal(SIGTERM,render);
    signal(SIGALRM,timer);
    if(setjmp(env))
	pause();
    for(;;)  {
	if((nwrote = write(1,list,SEQLEN)) < 0)  { /* write tty should be 1 */
	    mydata.errors = mydata.num_rd = -1;
	    write(thepipe,&mydata,sizeof mydata);
	    exit(1);
	}
	mydata.num_wt += nwrote;
	done = 0;
	lastc = -1;
	while(!done  && (c = tgetc(0)) >= 0)  {
	    if(lastc == 'p')  
		done = 1;
	    lastc = c;
	    mydata.num_rd++;
	    if(c != list[index])  {
		mydata.errors++;
		if(islower(c))
		    index = c - 'a';
		else if(c == '\n')
		    index++;
	    }
	    index++;
	    index %= SEQLEN;
	}
    }
}

rstopper(sig)
int sig;
{
    signal(sig,rstopper);		/* reset the signal */
    tflush(0);
    tflush(1);
    write(thepipe,&mydata,sizeof mydata);
    mydata.errors = mydata.num_rd = mydata.num_wt = 0;
    longjmp(env,1);
}
rstarter(sig)
int sig;
{
    signal(sig,rstarter);
    return;
}
render(sig)
int sig;
{
    tflush(0);
    tflush(1);
    exit(0);
}

tgetc(file)
int file;
{
    char c;
    int nread;

    if(setjmp(tmo_env))
	return TIMEOUT;
    alarm(TIME);
    for(;;)  {
	nread = read(file,&c,sizeof c);
	if(nread == 0)
	    continue;
	if(nread < 0)  {
	    alarm(0);
	    return EOF;
	}
	alarm(0);
	break;
    }
    return (c & 0xff);
}

timer(sig)
int sig;
{
    signal(sig,timer);
    longjmp(tmo_env,1);
}
