/*
 * (C) COPYRIGHT 1986
 * AIM TECHNOLOGY INCORPORATED  ALL RIGHTS RESERVED
 */

char sccs_id[] = "@(#)multiuser.c	1.7 9/22/87  --  AIM Benchmarks Suite III  SERIALNO\n";

#define WORKLD 50
#define WORKFILE "workfile"
#define STROKES 50	 	/* baud rate per user typing */
#define MAXITR 5
#define RTMSEC(x) rtmsec(x)
#define CHILDHZ(x) ((long) times(&t[0]),t[0].tms_cstime+t[0].tms_cutime)
#define LIST 50			/* number of procs to do / user */
#define CONTINUE 1

#ifndef HZ   		/* default 60-Hz clock freq */
#define HZ 60
#endif

#include <stdio.h>
#include "ttytest.h"
#include "vmtest.h" 
#include "testerr.h"
#include "tp_test.h"

char *ctime();				/* to get the date */
int dead_kid();

long debug;

#ifdef SYS3
/* ---------- rtmsec for unix Systems 3 and later, including Sys 5 */
#include <sys/types.h>
#include <sys/times.h>
#ifndef  ZILOG
#include <string.h>
#else
char *strcpy();
char *strncpy();
#endif
#include <signal.h>
#include <time.h>
long  times();

long
rtmsec(reset)
int reset;
{
/* rtmsec the timing routines used by multiuser */

	struct tms  ts;
	static long epoch;
	long tmp;

	/*
	**  Milliseconds resturned are now since first call.
	*/
	if ( epoch == 0 || reset == 1 ) {
	    epoch = times(&ts);		/* save */
	    DEBUG(printf("reseting epoch to %ld\n",epoch));
	}
	if(epoch < 0)  {
	    fprintf(stderr,"times returned < 0: %ld\n",epoch);
	    epoch = 0;
	}
	if(1000 * (tmp = (times(&ts) - epoch)) / HZ < 0)
	    fprintf(stderr,"1000 * (times - epoch) / HZ = %ld\n",1000*tmp/HZ);
	
	return ( 1000*(times(&ts)-epoch) / HZ );
}

#else
/* ---------- rtmsec for Version 7, and for all Berkeley BSD */
#include <sys/types.h>
#include <sys/timeb.h>
#include <sys/times.h>
#include <strings.h>
#include <signal.h>
#include <sys/time.h>

long
rtmsec(reset)
int reset;
{
	struct timeb timeb;
	static long epoch;
	/* 
	**  Milliseconds returned are now since first call.  In order
	**  to avoid multiply overflow, the new code subtracts
	**  epoch before multiplying by 1000 to convert seconds to
	**  milliseconds. Notice, 68 years, expressed in
	**  seconds, exceeds 2**31!, and that is before multiplying by
	**  1000;  Happily, this alteration will not affect
	**  time computations based on the difference
	**  of any two rtmsec calls, as epoch cancels itself thusly:
	**  	(rtmsec2-epoch) - (rtmsec1-epoch)  =
	**	(rtmsec2-rtmsec1) + (epoch-epoch)  =
	**	(rtmsec2-rtmsec1) + 0		   =
	**  This is true for any epoch value.
	*/

	if (epoch==0 || reset == 1) {
	      ftime(&timeb), epoch = timeb.time;	/* save it */
	      DEBUG(printf("reseting epoch to %ld\n",epoch));
	}

	ftime(&timeb);
	return ( (timeb.time-epoch)*1000L + timeb.millitm );
}
#endif

typedef int (*PFI)();
long t1, t2, rt1, rt2;			/* time variables */
struct tms t[2];
int gun;				/* start all processes running */
int work;				/* work load for processes */
int numdir;				/* number of disk directories */
char dkarr[10][70];			/* dirs for disk thrasher */
char wdev[70];				/* write tty character device */
char rdev[70];				/* read tty character device */
int nwbd[1];				/* baud rate for tty exerciser */
char lpcom[70];				/* line printer command array */
char tpcom[70];				/* tape drive device */
long vm_res;				/* virtual memory results */
int vmgo,tpgo,lpgo;			/* if exercising ... */
int kids;				/* number of users forked */

struct {				/* command / weight array */
    int hits;
    char cmd[50];
} tasks[WORKLD];
int maxusers[MAXITR];			/* max users at once */
int minusers[MAXITR];			/* min number of users */
int incr[MAXITR];			/* skip incr number each run */
int iters;

long atol();

main(argc,argv)
int argc;
char **argv;
{
    FILE *fp, *fopen();			/* file pointer */
    char fld1[20], fld2[50];
    int i, j, k, n, flg;		/* counters */
    int p;
    int letgo();			/* signal process */
    int killall();
    PFI sigvalu = NULL;
    int vmres,runnum;			/* run number */

    if((sigvalu = signal(SIGINT,SIG_IGN)) == (PFI)-1)  {
	fprintf(stderr,"Can't set signal\n");
	perror("SIGINT");
	exit(1);
    }
    if(sigvalu == SIG_IGN)
	setpgrp();
    else
	signal(SIGINT,sigvalu);
    signal(SIGINT,SIG_IGN);		/* catch signal and ingnor */
    signal(SIGTERM,killall);		/* child process problem */

    while(--argc > 0)  {
	if((*++argv)[0] == '-')  {
	    switch((*argv)[1])  {
#ifdef DEBUGON
	    case 'd': debug = atol(&(*argv)[2]);break;
#endif
	    default:
		fprintf(stderr,"unknown option %c\n",((*argv)[1]));
		break;
	    }
	}
    }
    kids = 0;
    getmname();

    /* open work file and read in tasks */
    if ((fp = fopen(WORKFILE,"r")) == NULL) {
	printf("No workfile in current directory ... EXIT\n");
	exit(1);
    }
    gun = 0;
    k = 0;
    do  {
        flg = 0;
	i = 0;
	j = 0;
	/* for each line in "workfile" */
        while ((n = getc(fp)) != EOF && n != '\n') {
	    if (n == ' ') {
		if (flg == 0) {
		    flg++;
		    continue;
		}
	    }
	    /* read in field one */
	    if (flg == 0)	
	    	fld1[i++] = n;

	    /* read in field two */
	    if (flg >= 1)
		fld2[j++] = n;
	}
        fld1[i] = '\0';
        fld2[j] = '\0';
	strcpy(tasks[k].cmd,fld2);
	tasks[k].hits = atoi(fld1);
	++k;
    } while (n != EOF); 
	work = k - 1;

	/* set up array with weighted task names */
	for (i = 1;i<=work;i++)
	    tasks[i].hits = tasks[i].hits + tasks[i-1].hits;

	/* print out weighted task list */
	DEBUG(printf("worklist: \n");
	for (i = 0;i<=work;i++)
	    printf("%d %s\n",tasks[i].hits,tasks[i].cmd));

	printf("\nAIM Technology Suite III\n   Testing started.....\n\n");
	fflush(stdout);
	/* start virtual memory exercisers */
	if (vmgo) {
	    printf("vmtest going\n");
	    fflush(stdout);
	    if ((vmres = vmctl(&vm_res,CONTINUE))<0) {
		printf("VMTEST NOT WORKING..EXIT\n");
		fflush(stdout);
		killall();
	    }
	}

	/* here is where it all happens */
    for (p=0;p<iters;p++)
	for(runnum=minusers[p];runnum<=maxusers[p];runnum += incr[p]) {
	    printf("simulating %d users ....\n",runnum);
	    fflush(stdout);
	    runtap(runnum,LIST);
	}
	if (vmgo) {
	    vmctl(&vm_res,KILLMEM);
	}
	printf("\nAIM Technology Suite III\n   Testing over\n");
	fflush(stdout);
	exit(0);
}


runtap(cnum,loadnm)
int cnum;
int loadnm;

{

    int i, j, k;
    char fofof[10];    
    int rand();				/* random number generator */
    void srand();			/* seed planter */
    unsigned seed;			/* seed */
    int randnum;			/* random number */
    int execl();
    char cmd[134];			/* executable command to "system" */
    long ftm1, ftm2;			/* time variables for control */
    char *p;				/* string holder */
    extern int errno;
    char dmpstr[70];			/* temp data string to output */
    long stuff;				/* ttyctl parameters */
    int raw = 1;			/* raw tty (boolean) */
    struct ttdata data;			/* tty data */
    char elpcom[70],etpcom[70];		/* exerciser stuff */
    char erdev[70],ewdev[70];		/* tty devices */


	/* reset epoch in rtmsec */
	RTMSEC(1);

	/* for each user */
	for (i=0;i<cnum;i++) {

	    /* fork off a child process */
	    if (fork_() == 0)  {
		srand(i);
		signal(SIGINT,letgo);
		signal(SIGTERM,SIG_DFL);
		signal(SIGHUP,dead_kid);

		/* wait for gun, so all children start together */
		pause(); 
		if (i == 0)
		    ftm1 = RTMSEC(0);

		/* spawn off loadnm number of procs, one at a time */
		for (j=0;j<loadnm;j++) {
	    	    randnum = rand();

		    /* locate selected job to do */
	    	    while (randnum > tasks[work].hits)
	    		randnum = randnum % tasks[work].hits;

	    	    k = 0;
	    	    while (tasks[k].hits < randnum)
			k++;

	    	    p = tasks[k].cmd;
		    if (numdir > 0)
	    		sprintf(cmd,"exec %s %s",p,dkarr[j%numdir]);
		    else
	    		sprintf(cmd,"exec %s",p);

		    /* run selected task, wait for completion or try again */
		    /* keep trying to system a command */
		    errno = 0;
		    sprintf(fofof,"\n%d",i);
		    if ((system(cmd))<0) {
			perror(fofof);
			kill(getppid(),SIGTERM);
		    }

		}

		/* controll process time */
		if (i == 0) {
		    ftm2 = RTMSEC(0);
		    sprintf(dmpstr,"%d %4.1f control ",cnum,(ftm2 - ftm1)/1000.);
		    dump(dmpstr);
		    sprintf(dmpstr,"%4.6f proc/sec ",(LIST/((ftm2-ftm1)/1000.)));
		    dump(dmpstr);
		}

		exit(0);
	    }
	}

	/* start line printer exerciser */
	if (lpgo) {
	    strncpy(elpcom,&lpcom[1],(strlen(lpcom)-3));
	    if (fork_() == 0) {
		signal(SIGINT,letgo);
		signal(SIGTERM,SIG_DFL);
		printf("lptest going\n");
		fflush(stdout);
		pause();
		execl("./lptest","lptest",elpcom);
		/* if you get here, lptest is not working... */
		printf("LINE PRINTER TEST NOT WORKING..EXIT\n");
		fflush(stdout);
		kill(getppid(),SIGTERM);
	    }
	}

	/* start tty exerciser */
	if (nwbd[0] != 0) {
		strncpy(erdev,&rdev[1],(strlen(rdev)-2));
		strncpy(ewdev,&wdev[1],(strlen(wdev)-2));
	        if (ttyctl(nwbd[0],ewdev,erdev,raw,&data) < 0) {
		    printf("TTY EXERCISER NOT WORKING!..EXIT\n"); 
		    fflush(stdout);
		    killall();
		}
	        printf("ttytest going\n");
		fflush(stdout);
	}


	/* start tape drive exerciser */
	if (tpgo) {
	    strncpy(etpcom,&tpcom[1],(strlen(tpcom)-2));
	    if(tp_ctl(CONTINUE,etpcom,&stuff) < 0 ) {
		printf("TAPE EXERCISER NOT WORKING!\n"); 
		fflush(stdout);
		killall();
	    }
	    printf("tapetest going\n");
	    fflush(stdout);
	}

	/* wait for all user processes to fork */
	sleep(5);

	/* start timers and send sig to children to start doing their tasks  */
	t1 = CHILDHZ(0); rt1 = RTMSEC(0);  
	kill(0,SIGINT);

	/* wait for children to finish the chores */
	while (wait((int *)0)) {
	    --kids;
	    if (kids == 0)
		break;
	}

	t2 = CHILDHZ(0); rt2 = RTMSEC(0); 
	/* testing over */

	/* Halt any exercisers that are running */
	if (nwbd[0] != 0) {
	    KILLTTY;
	}

	if (tpgo) {
	    tp_ctl(KILLTAPE,etpcom,&stuff);
	}
	/* write data to toutput file */
	sprintf(dmpstr,"%4.1f real ",(rt2-rt1)/1000.);
	dump(dmpstr);
	sprintf(dmpstr,"%4.1f cpu\n",(t2-t1)/HZ.);  
	dump(dmpstr);

}
fork_()
{

/*
**  fork_ is called by runntap to control process forking, and process
**  numbering.  repeated attempts are made to fork, returning process
**  ids if successful, or -1 if no process are available.
*/
	int k,fk;

	    for (k=0;k<5;k++)
		if((fk = fork())==-1)  {
		    continue;
		}
		else {
		    ++kids;
	    	    return (fk);
		}

	    /* if fork fails */
	    killall();
	return -1;			/* shut up lint */
}
letgo()
{
/*  start child process */

	gun = 1;  /* BANG!... and there off */
}
dump(str)
char *str;
{

/*  dump simply opens "toutput" in the current directory, and prints out
**  formated data.
*/

    FILE *fp;

    fp = fopen("toutput","a");
    if (fp == NULL) {
	printf("cannot open toutput data file.. EXIT\n");
	exit(3);
    }
    fputs(str,fp);
    fclose(fp);

}
getmname()
{
/*
**  getmname reads machine name and the range of users to simulate from
**  standard input.  The config file is then read, and peripheral exercisers
**  set up.  Extensive error checking is performed.  The routine is exited,
**  killing everything if errors are encounterd.
*/
    char header[132];  				/* formated info for each machine */
    char mname[20];				/* machine name */
    char *ldate;				/* date */
    char sdate[13];				/* date again */
    char ttlab[15];				/* TTY ON or OFF */
    char tplab[9];				/* TAPE ON or OFF */
    char lplab[9];				/* LP ON or OFF */
    char vmlab[9];				/* VM ON or OFF */
    long vtime, time();
    char strtp[10];				/* temp string */
    FILE *fp;					/* file pointer */
    FILE *fp2;					/* file pointer */
    char rstring[70];				/* read from config file */
    char vmcom[70];				/* virtual memory command */
    char mixstr[44];				/* read from mix file */
    int i,j;

    lpcom[0] = '\0';				/* initializations */
    tpcom[0] = '\0';
    vmcom[0] = '\0';

    /* check for config file */
    fp = fopen("config","r");
    if(fp == NULL) {
	printf("no config file\n");
	exit(1);
    }
    /* Pick up Machine name, and other information */

    printf("Please enter this machines name: ");
    fflush(stdout);
    gets(mname);
    vtime = time((long *)0);
    ldate = ctime(&vtime);
    sscanf(ldate,"%*s %12c",sdate);

    printf("Please enter the number of iterations to run: ");
    fflush(stdout);
    gets(strtp);
    /* MORE ERROR CHECKING NEEDED */
    iters = atoi(strtp);
    for (j = 0; j<iters;j++) {
    
    printf("Enter information for range %d\n\n",j);
    printf("Please enter the Max number of users to simulate: ");
    fflush(stdout);
    gets(strtp);
    maxusers[j] = atoi(strtp);
    if ((strtp == '\0') || (maxusers <= 0)) {
	printf("ok, goodbye\n");
	exit(0);
    }
    printf("Please enter the starting number of users to simulate: ");
    fflush(stdout);
    gets(strtp); 
    if (atoi(strtp) == 0)
        minusers[j] = 1;
    else
	if (atoi(strtp) < 0) {
	    printf("cannot simultate negative number of users\n");
	    exit(0);
	}
	else
	    minusers[j] = atoi(strtp);
    if (minusers[j] > maxusers[j]) {
	printf("Min number of users must be < Max number of users\n");
	exit(0);
    }
    printf("testing every how many users: ");
    fflush(stdout);
    gets(strtp); 
    if (atoi(strtp) <= 0)
	incr[j] = 1;
    else
    	incr[j] = atoi(strtp);

    }  /* end itereation */

    numdir = 0;

    /* read config file */
    while(fgets(rstring,70,fp) != NULL) {
        switch(rstring[0]) {
	    case '0':
		sscanf(rstring,"%*c %d",nwbd);
		break;
	    case '1':
		sscanf(rstring,"%*c %s",wdev);
		break;
	    case '2':
		sscanf(rstring,"%*c %s",rdev);
		break;
	    case '3':
	        sscanf(rstring,"%*c %s",dkarr[numdir++]);
		break;
	    case '4':
	        sscanf(rstring,"%*c %70c",lpcom);
		break;
	    case '5':
	        sscanf(rstring,"%*c %s",tpcom);
		break;
	    case '6':
	        sscanf(rstring,"%*c %s",vmcom);
		break;
	}
    }
    if ((strncmp(dkarr[0],"\"OFF\"",5)) == 0)
	numdir = 0;

    if ((nwbd[0] == 0) || (wdev == '\0') || (rdev == '\0')) {
	nwbd[0] = 0;
	sprintf(ttlab,"TTY OFF");
    }
    else 
	sprintf(ttlab,"TTY %d baud",nwbd[0]);

    lpgo = 0;
    if ((strncmp(lpcom,"\"OFF\"",5)) != 0) {
	sprintf(lplab,"LP ON");
	lpgo = 1;
    }
    else
        sprintf(lplab,"LP OFF");

    tpgo = 0;
    if ((strcmp(tpcom,"\"OFF\"")) != 0) {
	sprintf(tplab,"TAPE ON");
	tpgo = 1;
    }
    else
	sprintf(tplab,"TAPE OFF");

    vmgo = 0;
    if ((strcmp(vmcom,"\"ON\"")) == 0) {
	vmgo = 1;
	sprintf(vmlab,"VM ON");
    }
    else
	sprintf(vmlab,"VM OFF");

    fp2 = fopen("mixb","r");
    if (fp2 == NULL)  {
	fprintf(stderr,"File: mixb is unavaliable.  Exiting\n");
	perror("mixb");
	exit(1);
    }
    if(fgets(mixstr,44,fp2) == NULL)  {
	fprintf(stderr,"File: mixb is empty\n");
	exit(1);
    } 
    for (i=0;i<44;i++)
	if (mixstr[i] == '\n')
	    mixstr[i] = '\0';

    sprintf(header,": %s %s %s, %s, %s, %s, %s\n",mname,sdate,ttlab,tplab,lplab,vmlab,mixstr);
    dump(header);
    fclose(fp);
    fclose(fp2);
}
killall()
{

/*
**  killall sends signals to all child process and waits
**  for there death
**  
*/

    printf("\nSUITE III Testing over....\n");
    printf(" Max number of processes reached\n");

    signal(SIGTERM,SIG_IGN);
    kill(0,SIGTERM);
    while (wait((int *)0) != -1)
	; /* wait for all users to die */

    exit(0);
}
dead_kid(sig)
int sig;
{
    signal(sig,SIG_IGN);
    wait(0L);
    kill(getppid(),SIGTERM);
    exit(1);
}
