/*
 *	Draw a spiral
 *
 *	Compile with:
 *	cc -O spiral.c -o spiral -lvt
 */
#include <vt.h>
#include <signal.h>

#define XMIN	0
#define YMIN	0
#include "sin.h"
#define SIN(x)	sin[(x)%360]
#define COS(x)  sin[((x)+90)%360]

struct pen{
	short	x, y;
	short	angle;
};

struct gconfig	gc;
struct pen 	bic;
short	width, height;
int	size, angle;
int	delta = 2;
int	thickness = 1;
short	color, bgcolor = VT_Black;
struct colors {
	int	r;
	int	g;
	int	b;
} colors[] = {
	{ 2, 11, 13},
	{ 0,  0, 14},
	{ 0, 14,  0},
	{ 0, 14, 14},
	{14,  0,  0},
	{14,  0, 14},
	{14, 14,  0},
	{ 0, 14,  8},
	{ 0,  8, 14},
	{14,  8,  0},
	{ 8, 14,  0},
	{ 8,  0, 14},
	{14,  0,  8},
	{ 8, 14,  8},
	{14,  8, 14},
	{15, 15, 15}
};
struct wstate ws;


cleanup()
{
    BlockRefreshAdjust(1);
    SetPosition(1, 0, 0);
    SetColor(1, ws.bcolor);
    PaintRectangleInterior(1, 10000, 10000);
    SetWindowState(1, &ws);
    exit(0);
}

main(argc, argv)
int	argc;
char	**argv;
{
int	adjustsize(), refresh();
int	max_color;

	if (GetGraphicsConfig(1, &gc) == -1) {
		printf("%s: not a window\n", argv[0]);
		exit(1);
	}

	signal(SIGTERM, cleanup);
	signal(SIGHUP, cleanup);
	signal(SIGQUIT, cleanup);
	signal(SIGINT, cleanup);

	GetWindowState(1, &ws);
	width = ws.width;
	height= ws.height;
	SetLineDisc(1, TWSDISC);
	SetBuf(1, 100);
    	SetMouseMode(1, VT_MOUSE_DOWN);
	SetRefresh(1, 0, refresh);
	SetAdjust(1, 0, adjustsize);
	SetAddressing(1, VT_RELATIVE);
	SetThickness(1, thickness);
	if ((max_color = gc.realcolors) <= 2) {
		/* white background looks better on monochrome */
		bgcolor = VT_White;
	} else {
		/* get some nice colors if available */
		register int	c;
		for (c=0; c<(sizeof(colors)/sizeof(struct colors)); c++) {
			SetLocalLUT(1, c,
			    colors[c].r, colors[c].g, colors[c].b, VT_SHARE);
		}
		/* free them up */
		for (c=0; c<(sizeof(colors)/sizeof(struct colors)); c++) {
			SetLocalLUT(1, c, 0, 0, 0, VT_FREE);
		}
	}
	SetBColor(1, bgcolor);
	cls();
	size = width > height ? width : height;
	srandom(time(0));
	color = max_color/2;	/* prettier colors (usually) to start with */
	while (1) {
		angle = random() % 360;
		bic.angle = random() % 360;
		bic.x = width/2;
		bic.y = height/2;
		color = (color+1) % max_color;
		if (color == bgcolor)
		    color = (color+1) % max_color;
		SetColor(1, color);
		spiral(&bic, size, angle);
		Flush(1);
		sleep(1);
		cls();
	}
}

cls()
{
	SetPosition(1, 0, 0);
	SetColor(1, bgcolor);
	PaintRectangleInterior(1, 10000, 10000);
	SetColor(1, color);
}

spiral(pen, maxsize, angle)
struct pen	*pen;
int	maxsize, angle;
{
	register i;
	for(i=1; i<maxsize; i+=delta){
		go(pen, i);
		turn(pen, angle);
	}
}

go(pen, distance)
struct pen	*pen;
int	distance;
{
	register	deltax, deltay;
	if(!distance) return;
	deltax = distance * COS(pen->angle);
	deltay = distance * SIN(pen->angle);
	if(distance < 0){
		pen->x += deltax;
		pen->y += deltay;
		SetPosition(1, pen->x, pen->y);
		PaintLine(1, -deltax, -deltay);
	}else{
		SetPosition(1, pen->x, pen->y);
		PaintLine(1, deltax, deltay);
		pen->x += deltax;
		pen->y += deltay;
	}
}

turn(pen, angle)
struct pen	*pen;
int	angle;
{
	pen->angle = (pen->angle + angle) % 360;
}

refresh(id, x, y, w, h)
int	id;
short	x, y, w, h;
{
	struct wstate	ws;
	GetWindowState(1, &ws);
	SetPosition(1, 0, 0);
	SetColor(1, bgcolor);
	PaintRectangleInterior(1, 5000, 5000);
	SetWindowState(1, &ws);
}

adjustsize(id, w, h)
int id;
short w, h;
{
	width=w; height=h;
	size = width > height ? width : height;
}

