C
C	recvtf -- draw, move, and delete rectangles using libvtf
C
C	compile with:
C		f77 -o recvtf -O recvtf.f -lvtf
C
C----------------------------------------------------------------------
C Program: Object oriented rectangles drawing program.
C   This program demonstrates the Fortran interface to the virtual
C   terminal graphics library.  This program demonstrates a window
C   size insensitive program.  It scales itself to the initial size
C   of the window, and responds to refresh, but ignores all calls
C   to adjust its size since no Adjust routine is present.
C   Simply by adding an adjust routine which will capture the new
C   window width and height, and using that information (drawboxw, drawboxh),
C   one can teach this program to adjust itself to window size changes.
C
C Author:  Steve Misek
C          Integrated Solutions, Inc.
C          July 2, 1985 
C
C Constants:
C   LIBVTF constants can be found in sections 5.3, 5.4, and 5.5
C   of the LIBVTF interface manual, but necessary constants are 
C   included in the vtf common block.
C----------------------------------------------------------------------
      program Rectangles
	 call Initialize
	 call TouchBoxes
	 call Finish
      stop
      end
C----------------------------------------------------------------------
C BLOCK DATA
C
C   inter-object space
C	SPACE		10
C   generic box width, height and color
C	BOXWIDTH	50
C	BOXHEIGHT	50 
C	BOXLINE	2
C   number of available colors, and location of color selection boxes
C	NCOLORS	9
C	COLORBOXX	SPACE  
C	COLORBOXY	SPACE
C	COLORBOXW	(NCOLORS*BOXWIDTH)
C	COLORBOXH	BOXHEIGHT
C   location and size of current color box
C	SELECTBOXX	(COLORBOXX + COLORBOXW + SPACE)
C	SELECTBOXY	SPACE
C	SELECTBOXW	BOXWIDTH
C	SELECTBOXH	BOXHEIGHT
C   number, location and size of mode selection boxes
C	NMODE		3
C	MODEBOXX	(SELECTBOXX + SELECTBOXW + SPACE + BOXWIDTH)
C	MODEBOXY	SPACE
C	MODEBOXW	(NMODE*2*BOXWIDTH)
C	MODEBOXH	BOXHEIGHT
C   various modes
C	DRAWMODE	0
C	MOVEMODE	1
C	DELETEMODE	2
C   start location of drawing area
C	DRAWBOXX	(COLORBOXX)
C	DRAWBOXY	(COLORBOXY + COLORBOXH + SPACE)
C	DRAWBOXW	<variable>
C	DRAWBOXH	<variable>
C----------------------------------------------------------------------
      block data
C
      common /static/ space, boxwidth, boxheight, boxline,
     +       colorboxx, colorboxy, colorboxw, colorboxh,
     +       selectboxx, selectboxy, selectboxw, selectboxh,
     +       nmode, modeboxx, modeboxy, modeboxw, modeboxh,
     +       drawboxx, drawboxy, drawboxw, drawboxh,
     +       colors, ncolors
      common /dynamic/ curmode, curcolor, istate, repeat
      common /dlist/ rx, ry, rw, rh, rcolor, npoints
      common /vtf/ twsdisc, vtwhite, vtblack, vtstrend, vtmousedown,
     +        vtcenter, vtmouseleft, vtmousemiddle, vtmouseright
C
      integer space, boxwidth, boxheight, boxline, colorboxx,
     +        colorboxy, colorboxw, colorboxh, selectboxx,
     +        selectboxy, selectboxw, selectboxh, nmode, modeboxx,
     +        modeboxy, modeboxw, modeboxh, drawboxx, drawboxy,
     +        drawboxw, drawboxh, colors(9), ncolors
      integer curmode, curcolor, npoints, istate(28), repeat
      integer rx(500), ry(500), rw(500), rh(500), rcolor(500)
      integer twsdisc, vtwhite, vtblack, vtstrend, vtmousedown,
     +        vtcenter, vtmouseleft, vtmousemiddle, vtmouseright
C
      data	space		/10/
      data	boxwidth	/50/
      data	boxheight	/50/
      data	boxline		/2/
      data	colorboxx	/10/
      data	colorboxy	/10/
      data	colorboxw	/450/
      data	colorboxh	/50/
      data	selectboxx	/470/
      data	selectboxy	/10/
      data	selectboxw	/50/
      data	selectboxh	/50/
      data	nmode		/3/
      data	modeboxx	/580/
      data	modeboxy	/10/
      data	modeboxw	/300/
      data	modeboxh	/50/
      data	drawboxx	/10/
      data	drawboxy	/70/
      data	colors   	/ 0, 5, 3, 7, 2, 8, 4, 6, 1/
      data	ncolors		/9/
      data	curmode		/0/
      data	curcolor	/0/
      data	repeat		/0/
      data	npoints		/0/
      data	twsdisc		/5/
      data	vtwhite		/1/
      data	vtblack		/0/
      data	vtstrend	/-2/
      data	vtmousedown	/16/
      data	vtcenter	/2/
      data	vtmouseleft	/1/
      data	vtmousemiddle	/2/
      data	vtmouseright	/4/
C
      end
C----------------------------------------------------------------------
C subroutine: Initialize
C	capture the initial window state.
C       set up refresh routines, and initialize window for graphics
C input:  
C	istate  - empty array
C output: 
C	istate  - initial window state
C----------------------------------------------------------------------
      subroutine Initialize
C
      common /static/ space, boxwidth, boxheight, boxline,
     +       colorboxx, colorboxy, colorboxw, colorboxh,
     +       selectboxx, selectboxy, selectboxw, selectboxh,
     +       nmode, modeboxx, modeboxy, modeboxw, modeboxh,
     +       drawboxx, drawboxy, drawboxw, drawboxh,
     +       colors, ncolors
      common /dynamic/ curmode, curcolor, istate, repeat
      common /vtf/ twsdisc, vtwhite, vtblack, vtstrend, vtmousedown,
     +        vtcenter, vtmouseleft, vtmousemiddle, vtmouseright
      integer space, boxwidth, boxheight, boxline, colorboxx,
     +        colorboxy, colorboxw, colorboxh, selectboxx,
     +        selectboxy, selectboxw, selectboxh, nmode, modeboxx,
     +        modeboxy, modeboxw, modeboxh, drawboxx, drawboxy,
     +        drawboxw, drawboxh, colors(9), ncolors
      integer curmode, curcolor, istate(28), repeat
      integer twsdisc, vtwhite, vtblack, vtstrend, vtmousedown,
     +        vtcenter, vtmouseleft, vtmousemiddle, vtmouseright
C
      external	Refresh, RefreshBoxes
      call GetWindowState(1, istate)
      call SetLineDisc(1, twsdisc)
      call BlockRefAdj(1)
      call SetRefresh(1, 0, Refresh)
      call SetBuf(1, 1024)
      call SetMouseMode(1, vtmousedown)
      call SetThickness(1, boxline)
      drawboxw = istate(16) - drawboxx - (space*2)
      drawboxh = istate(17) - drawboxy - (space*2)
      call BackGround
      call RefreshBoxes( (drawboxx-boxline), (drawboxy-boxline),
     +         (drawboxw+(2*boxline)), (drawboxh+(2*boxline)) )
      return
      end
C----------------------------------------------------------------------
C subroutine: BackGround
C	<see routine>
C input:  
C	<none>
C output: 
C	<none>
C----------------------------------------------------------------------
      subroutine BackGround
      integer	i
C
      common /static/ space, boxwidth, boxheight, boxline,
     +       colorboxx, colorboxy, colorboxw, colorboxh,
     +       selectboxx, selectboxy, selectboxw, selectboxh,
     +       nmode, modeboxx, modeboxy, modeboxw, modeboxh,
     +       drawboxx, drawboxy, drawboxw, drawboxh,
     +       colors, ncolors
      common /dynamic/ curmode, curcolor, istate, repeat
      common /vtf/ twsdisc, vtwhite, vtblack, vtstrend, vtmousedown,
     +        vtcenter, vtmouseleft, vtmousemiddle, vtmouseright
      integer space, boxwidth, boxheight, boxline, colorboxx,
     +        colorboxy, colorboxw, colorboxh, selectboxx,
     +        selectboxy, selectboxw, selectboxh, nmode, modeboxx,
     +        modeboxy, modeboxw, modeboxh, drawboxx, drawboxy,
     +        drawboxw, drawboxh, colors(9), ncolors
      integer curmode, curcolor, istate(28), repeat
      integer twsdisc, vtwhite, vtblack, vtstrend, vtmousedown,
     +        vtcenter, vtmouseleft, vtmousemiddle, vtmouseright
C
      call PaintRegion(1, 0, 0, istate(16), istate(17), vtwhite)
      do 10 i=1, ncolors
	call PaintRegion(1, (colorboxx + boxwidth*(i-1)),
     +          colorboxy, boxwidth, boxheight, colors(i))
 10   continue
      call PaintRegion(1, selectboxx, selectboxy, selectboxw,
     +        selectboxh, curcolor)
C
C paint rectangle border around color selections
C
       call SetColor(1, vtblack)
       call SetPosition(1, colorboxx, colorboxy)
       call RecBorder(1, colorboxw, colorboxh)
       i = colorboxx + boxwidth
 20    continue
	  if (i .ge. (colorboxxx + colorboxw)) goto 30
	     call SetPosition(1, i, colorboxy)
	     call PaintLine(1, 0, boxheight)
	     i = i + boxwidth
	     go to 20
 30    continue

       call SetPosition(1, modeboxx, modeboxy)
       call RecBorder(1, modeboxw, modeboxh)
       i = modeboxx + 2*boxwidth
 40    continue
	  if (i .ge. (modeboxx + modeboxw)) goto 50
	    call SetPosition(1, i, modeboxy)
	    call PaintLine(1, 0, boxheight)
	    i = i + 2*boxwidth
	    go to 40
 50    continue
       call SetJustify(1, vtcenter)
       call SetPosition(1, (modeboxx+boxwidth), (modeboxy+(modeboxh/2)))
       call PaintString(1, vtstrend, "Draw")
       call SetPosition(1, (modeboxx+(3*boxwidth)),
     +                     (modeboxy+(modeboxh/2)))
       call PaintString(1, vtstrend, "Move")
       call SetPosition(1, (modeboxx+(5*boxwidth)),
     +                     (modeboxy+(modeboxh/2)))
       call PaintString(1, vtstrend, "Delete")
       call InvertRegion(1, (modeboxx + curmode * (2*boxwidth)),
     +                      modeboxy, (2*boxwidth), modeboxh)
       call SetPosition(1, selectboxx, selectboxy)
       call RecBorder(1, selectboxw, selectboxh)
       return
       end
C----------------------------------------------------------------------
C subroutine: RefreshBoxes
C input:  
C	x, y, w, h - rectangular region to be painted
C output: 
C constants:
C----------------------------------------------------------------------
      subroutine RefreshBoxes(x, y, w, h)
      integer x, y, w, h
      integer cx, cy, cw, ch, i
C
      common /static/ space, boxwidth, boxheight, boxline,
     +       colorboxx, colorboxy, colorboxw, colorboxh,
     +       selectboxx, selectboxy, selectboxw, selectboxh,
     +       nmode, modeboxx, modeboxy, modeboxw, modeboxh,
     +       drawboxx, drawboxy, drawboxw, drawboxh,
     +       colors, ncolors
      common /dlist/ rx, ry, rw, rh, rcolor, npoints
      common /vtf/ twsdisc, vtwhite, vtblack, vtstrend, vtmousedown,
     +        vtcenter, vtmouseleft, vtmousemiddle, vtmouseright
      integer space, boxwidth, boxheight, boxline, colorboxx,
     +        colorboxy, colorboxw, colorboxh, selectboxx,
     +        selectboxy, selectboxw, selectboxh, nmode, modeboxx,
     +        modeboxy, modeboxw, modeboxh, drawboxx, drawboxy,
     +        drawboxw, drawboxh, colors(9), ncolors
      integer rx(500), ry(500), rw(500), rh(500), rcolor(500)
      integer twsdisc, vtwhite, vtblack, vtstrend, vtmousedown,
     +        vtcenter, vtmouseleft, vtmousemiddle, vtmouseright
C
       call GetPermClip(1, cx, cy, cw, ch)
       call SetPermClip(1, drawboxx-boxline, drawboxy-boxline,
     +                  drawboxw+(2*boxline), drawboxh+(2*boxline))
       call ResPermClip(1, x, y, w, h)
       call PaintRegion(1, x, y, w, h, vtwhite)
       do 10 i=1, npoints
	  call DrawRectangle(i)
 10    continue
       call SetColor(1, vtblack)
       call SetPosition(1, drawboxx, drawboxy)
       call RecBorder(1, drawboxw, drawboxh)
       call SetPermClip(1, cx, cy, cw, ch)
       return
       end
C----------------------------------------------------------------------
C subroutine: Refresh
C input:  
C	id         - unused
C	x, y, w, h - rectangular region to be refreshed
C output: 
C constants:
C----------------------------------------------------------------------
       subroutine Refresh(id, x, y, w, h)
       integer id, x, y, w, h
       integer cx, cy, cw, ch
       call GetPermClip(1, cx, cy, cw, ch)
       call SetPermClip(1, x, y, w, h)
       call BackGround
       call RefreshBoxes(x, y, w, h)
       call SetPermClip(1, cx, cy, cw, ch)
       return
       end
C----------------------------------------------------------------------
C subroutine: PaintRegion
C	paint rectangular region with color
C	buffer is flushed upon entry and exit
C	current color is changed to VT_Black
C input:  
C	fd         - file descriptor of current window
C	x, y, w, h - rectangular region to be painted
C	color      - color to paint region
C output: 
C	<none>
C----------------------------------------------------------------------
       subroutine PaintRegion(fd, x, y, w, h, color)
C
      common /vtf/ twsdisc, vtwhite, vtblack, vtstrend, vtmousedown,
     +        vtcenter, vtmouseleft, vtmousemiddle, vtmouseright
      integer twsdisc, vtwhite, vtblack, vtstrend, vtmousedown,
     +        vtcenter, vtmouseleft, vtmousemiddle, vtmouseright
C
       integer fd, x, y, w, h, color
       call WFlush(fd)
       call SetColor(fd, color)
       call SetPosition(fd, x, y)
       call RecInterior(fd, w, h)
       call SetColor(fd, vtblack)
       call WFlush(fd)
       return
       end
C----------------------------------------------------------------------
C subroutine: Finish
C input:  
C	istate - initial window state
C output: 
C	<none>
C constants:
C	VT_White = 0
C----------------------------------------------------------------------
      subroutine Finish
C
      common /dynamic/ curmode, curcolor, istate, repeat
      common /vtf/ twsdisc, vtwhite, vtblack, vtstrend, vtmousedown,
     +        vtcenter, vtmouseleft, vtmousemiddle, vtmouseright
      integer curmode, curcolor, istate(28), repeat
      integer twsdisc, vtwhite, vtblack, vtstrend, vtmousedown,
     +        vtcenter, vtmouseleft, vtmousemiddle, vtmouseright
C
      call SetPermClip(1, 0, 0, 10000, 10000)
      call PaintRegion(1, 0, 0, 10000, 10000, vtwhite)
      call SetWindowState(1, istate)
      call WFlush(1)
      return
      end
C----------------------------------------------------------------------
C subroutine: TouchBoxes
C input:  
C output: 
C constants:
C----------------------------------------------------------------------
       subroutine TouchBoxes
       integer CheckCoord, getvtseq, DisplayPopUp
       integer key, input(6)
C
      common /static/ space, boxwidth, boxheight, boxline,
     +       colorboxx, colorboxy, colorboxw, colorboxh,
     +       selectboxx, selectboxy, selectboxw, selectboxh,
     +       nmode, modeboxx, modeboxy, modeboxw, modeboxh,
     +       drawboxx, drawboxy, drawboxw, drawboxh,
     +       colors, ncolors
      common /dynamic/ curmode, curcolor, istate, repeat
      common /dlist/ rx, ry, rw, rh, rcolor, npoints
      common /vtf/ twsdisc, vtwhite, vtblack, vtstrend, vtmousedown,
     +        vtcenter, vtmouseleft, vtmousemiddle, vtmouseright
      integer space, boxwidth, boxheight, boxline, colorboxx,
     +        colorboxy, colorboxw, colorboxh, selectboxx,
     +        selectboxy, selectboxw, selectboxh, nmode, modeboxx,
     +        modeboxy, modeboxw, modeboxh, drawboxx, drawboxy,
     +        drawboxw, drawboxh, colors(9), ncolors
      integer curmode, curcolor, npoints, istate(28), repeat
      integer rx(500), ry(500), rw(500), rh(500), rcolor(500)
      integer twsdisc, vtwhite, vtblack, vtstrend, vtmousedown,
     +        vtcenter, vtmouseleft, vtmousemiddle, vtmouseright
C
 10   continue
	key = getvtseq(1, input)
	if (key .eq. 157) goto 20
	    call DisplayStatus(1, "use the mouse")
	    goto 10
 20     continue
	    call RemoveStatus(1)
	    repeat = 0
	    key = iand(input(2), vtmouseright)
	       if (key .gt. 0) goto 100
	    key = iand(input(2), vtmouseleft)
	       if (key .gt. 0) goto 200
	    if (iand(input(2), vtmousemiddle).gt.0) goto 300
	    goto 400
 100        continue
		repeat = 1
		goto 200
 200        continue
		key = CheckCoord(input(5), input(6))
		if (key .ne. 1) goto 400
		    call SetPermClip(1, drawboxx, drawboxy,
     +                                 drawboxw, drawboxh)
		    if (curmode.eq.0) call DrawBox(input(5), input(6))
		    if (curmode.eq.1) call MoveBox(input(5), input(6))
		    if (curmode.eq.2) call DeleteBox(input(5), input(6))
		    call SetPermClip(1, 0, 0, 10000, 10000)
		    goto 400
 300        continue
		call SetPosition(1, input(5), input(6))
		key = DisplayPopUp(1, "Do@Clear@Exit@")
		if (key .eq. 0) goto 400
		if (key .eq. 1) goto 310
		if (key .eq. 2) goto 320
		goto 400
 310            continue
		   npoints = 0
		   call PaintRegion(1, drawboxx, drawboxy,
     +                     drawboxw, drawboxh, vtwhite)
		   goto 400
 320            continue
		   return
 400       continue
	   if (1 .eq. 1) goto 10
       return
       end
C----------------------------------------------------------------------
C subroutine: DrawRectangle
C input:  
C output: 
C----------------------------------------------------------------------
      subroutine DrawRectangle(r)
      integer r
C
      common /dynamic/ curmode, curcolor, istate, repeat
      common /dlist/ rx, ry, rw, rh, rcolor, npoints
      common /vtf/ twsdisc, vtwhite, vtblack, vtstrend, vtmousedown,
     +        vtcenter, vtmouseleft, vtmousemiddle, vtmouseright
      integer curmode, curcolor, npoints, istate(28), repeat
      integer rx(500), ry(500), rw(500), rh(500), rcolor(500)
      integer twsdisc, vtwhite, vtblack, vtstrend, vtmousedown,
     +        vtcenter, vtmouseleft, vtmousemiddle, vtmouseright
C
       call PaintRegion(1, rx(r), ry(r), rw(r), rh(r), rcolor(r))
       call SetColor(1, vtblack)
       call SetPosition(1, rx(r), ry(r))
       call RecBorder(1, rw(r), rh(r))
       call WFlush(1)
       return
       end
C----------------------------------------------------------------------
C subroutine: CheckCoord 
C input:  
C	x - current x input coordinate
C	y - current y input coordinate
C output: 
C       determines which box the current location is pointing
C       at, and sets values accordingly
C----------------------------------------------------------------------
      integer function CheckCoord(x, y)
      integer x, y, rvalue
C
      common /static/ space, boxwidth, boxheight, boxline,
     +       colorboxx, colorboxy, colorboxw, colorboxh,
     +       selectboxx, selectboxy, selectboxw, selectboxh,
     +       nmode, modeboxx, modeboxy, modeboxw, modeboxh,
     +       drawboxx, drawboxy, drawboxw, drawboxh,
     +       colors, ncolors
      common /dynamic/ curmode, curcolor, istate, repeat
      common /vtf/ twsdisc, vtwhite, vtblack, vtstrend, vtmousedown,
     +        vtcenter, vtmouseleft, vtmousemiddle, vtmouseright
      integer space, boxwidth, boxheight, boxline, colorboxx,
     +        colorboxy, colorboxw, colorboxh, selectboxx,
     +        selectboxy, selectboxw, selectboxh, nmode, modeboxx,
     +        modeboxy, modeboxw, modeboxh, drawboxx, drawboxy,
     +        drawboxw, drawboxh, colors(9), ncolors
      integer curmode, curcolor, istate(28), repeat
      integer twsdisc, vtwhite, vtblack, vtstrend, vtmousedown,
     +        vtcenter, vtmouseleft, vtmousemiddle, vtmouseright
C
      rvalue = 0
      if  ( (x .gt. drawboxx) 			.and. 
     +      (x .lt. (drawboxx+drawboxw))	.and.
     +      (y .gt. drawboxy)			.and.
     +      (y .lt. (drawboxy+drawboxh)))       goto 10
      if  ( (x .gt. colorboxx)			.and.
     +      (x .lt. (colorboxx+colorboxw))	.and.
     +      (y .gt. colorboxy)			.and.
     +      (y .lt. (colorboxy+colorboxh)))     goto 20
      if  ( (x .gt. modeboxx)			.and.
     +      (x .lt. (modeboxx+modeboxw))	.and.
     +      (y .gt. modeboxy)			.and.
     +      (y .lt. (modeboxy+modeboxh)))       goto 30
	  goto 40
 10    continue
	  rvalue = 1
	  goto 40
 20    continue
	  curcolor = colors(1 + (x-colorboxx)/boxwidth)
	  call PaintRegion(1, selectboxx, selectboxy,
     +                       selectboxw, selectboxh, curcolor)
	  goto 40
 30    continue
	  call InvertRegion(1, (modeboxx +   curmode * (2*boxwidth)),
     +                     modeboxy, (2*boxwidth), modeboxh)
	  curmode = (x - modeboxx)/(2*boxwidth)
	  call InvertRegion(1, (modeboxx + curmode * (2*boxwidth)),
     +                     modeboxy, (2*boxwidth), modeboxh)
	  goto 40
 40    continue
       CheckCoord = rvalue
       return
       end
C----------------------------------------------------------------------
C subroutine: 
C input:  
C output: 
C----------------------------------------------------------------------
      integer function IdentifyBox(x, y)
      integer x, y, i
      common /dlist/ rx, ry, rw, rh, rcolor, npoints
      integer rx(500), ry(500), rw(500), rh(500), rcolor(500)
      i = npoints
 10   continue
	 if ( (x .ge. (rx(i)-boxline))		.and.
     +        (x .le. (rx(i)+rw(i)+2*boxline))	.and.
     +        (y .ge. (ry(i)-boxline))		.and.
     +        (y .le. (ry(i)+rh(i)+2*boxline)) ) goto 20
	 i = i - 1
	 if (i .gt. 0) goto 10
 20   continue
      IdentifyBox = i
      return
      end
C----------------------------------------------------------------------
C subroutine: MoveBox
C input:  
C output: 
C----------------------------------------------------------------------
      subroutine MoveBox(px, py)
      integer  px, py
      integer  box, x, y, w, h, i
      integer  IdentifyBox
C
      common /static/ space, boxwidth, boxheight, boxline,
     +       colorboxx, colorboxy, colorboxw, colorboxh,
     +       selectboxx, selectboxy, selectboxw, selectboxh,
     +       nmode, modeboxx, modeboxy, modeboxw, modeboxh,
     +       drawboxx, drawboxy, drawboxw, drawboxh,
     +       colors, ncolors
      common /dynamic/ curmode, curcolor, istate, repeat
      common /dlist/ rx, ry, rw, rh, rcolor, npoints
      integer space, boxwidth, boxheight, boxline, colorboxx,
     +        colorboxy, colorboxw, colorboxh, selectboxx,
     +        selectboxy, selectboxw, selectboxh, nmode, modeboxx,
     +        modeboxy, modeboxw, modeboxh, drawboxx, drawboxy,
     +        drawboxw, drawboxh, colors(9), ncolors
      integer curmode, curcolor, npoints, istate(28), repeat
      integer rx(500), ry(500), rw(500), rh(500), rcolor(500)
C
      box = IdentifyBox(px, py)
      if (box .gt. 0) goto 10
	 call DisplayStatus(1, "not a box")
	 goto 20
 10   continue
	 x = rx(box) - boxline
	 y = ry(box) - boxline
	 w = rw(box) + (boxline*2)
	 h = rh(box) + (boxline*2)
	 call TrackFixedBox(1, rx(box), ry(box), rw(box), rh(box),
     +       drawboxx, drawboxy, drawboxw, drawboxh, boxline)
	 rx(npoints+1)     = rx(box)
	 ry(npoints+1)     = ry(box)
	 rw(npoints+1)     = rw(box)
	 rh(npoints+1)     = rh(box)
	 rcolor(npoints+1) = rcolor(box)
	 do 30 i=box, npoints
	    rx(i)     = rx(i+1)
	    ry(i)     = ry(i+1)
	    rw(i)     = rw(i+1)
	    rh(i)     = rh(i+1)
	    rcolor(i) = rcolor(i+1)
 30      continue
	 call RefreshBoxes(x, y, w, h)
	 call DrawRectangle(npoints)
 20   continue
      return
      end
C----------------------------------------------------------------------
C subroutine: DeleteBox
C input:  
C output: 
C----------------------------------------------------------------------
      subroutine DeleteBox(px, py)
      integer  px, py
      integer  box, x, y, w, h, i
C
      common /static/ space, boxwidth, boxheight, boxline,
     +       colorboxx, colorboxy, colorboxw, colorboxh,
     +       selectboxx, selectboxy, selectboxw, selectboxh,
     +       nmode, modeboxx, modeboxy, modeboxw, modeboxh,
     +       drawboxx, drawboxy, drawboxw, drawboxh,
     +       colors, ncolors
      common /dlist/ rx, ry, rw, rh, rcolor, npoints
      integer space, boxwidth, boxheight, boxline, colorboxx,
     +        colorboxy, colorboxw, colorboxh, selectboxx,
     +        selectboxy, selectboxw, selectboxh, nmode, modeboxx,
     +        modeboxy, modeboxw, modeboxh, drawboxx, drawboxy,
     +        drawboxw, drawboxh, colors(9), ncolors
      integer rx(500), ry(500), rw(500), rh(500), rcolor(500)
C
      box = IdentifyBox(px, py)
      if (box .gt. 0) goto 10
	 call DisplayStatus(1, "not a box")
	 goto 20
 10   continue
	 x = rx(box) - boxline
	 y = ry(box) - boxline
	 w = rw(box) + (boxline*2)
	 h = rh(box) + (boxline*2)
	 do 30 i=box, (npoints-1)
	    rx(i)     = rx(i+1)
	    ry(i)     = ry(i+1)
	    rw(i)     = rw(i+1)
	    rh(i)     = rh(i+1)
	    rcolor(i) = rcolor(i+1)
 30      continue
	 npoints = npoints -1
	 call RefreshBoxes(x, y, w, h)
 20   continue
      return
      end
C----------------------------------------------------------------------
C subroutine: DrawBox
C input:  
C output: 
C----------------------------------------------------------------------
      subroutine DrawBox(px, py)
      integer px, py
C
      common /static/ space, boxwidth, boxheight, boxline,
     +       colorboxx, colorboxy, colorboxw, colorboxh,
     +       selectboxx, selectboxy, selectboxw, selectboxh,
     +       nmode, modeboxx, modeboxy, modeboxw, modeboxh,
     +       drawboxx, drawboxy, drawboxw, drawboxh,
     +       colors, ncolors
      common /dynamic/ curmode, curcolor, istate, repeat
      common /dlist/ rx, ry, rw, rh, rcolor, npoints
      integer space, boxwidth, boxheight, boxline, colorboxx,
     +        colorboxy, colorboxw, colorboxh, selectboxx,
     +        selectboxy, selectboxw, selectboxh, nmode, modeboxx,
     +        modeboxy, modeboxw, modeboxh, drawboxx, drawboxy,
     +        drawboxw, drawboxh, colors(9), ncolors
      integer curmode, curcolor, npoints, istate(28), repeat
      integer rx(500), ry(500), rw(500), rh(500), rcolor(500)
C
      npoints = npoints + 1
      rx(npoints) = px
      ry(npoints) = py
      rw(npoints) = 0
      rh(npoints) = 0
      rcolor(npoints) = curcolor
      if (repeat .eq. 0) goto 10
	 if (npoints .le. 0) goto 20
             rw(npoints) = rw(npoints-1)
             rh(npoints) = rh(npoints-1)
      go to 20
 10   continue
         call TrackRubberBox(1, rx(npoints), ry(npoints), rw(npoints),
     +     rh(npoints), drawboxx, drawboxy, drawboxw, drawboxh, boxline)
 20   continue
      if (rw(npoints) .ge. 0) goto 30
         rw(npoints) = -rw(npoints)
         rx(npoints) =  rx(npoints) - rw(npoints)
 30   continue
      if (rh(npoints) .ge. 0) goto 40
         rh(npoints) = -rh(npoints)
         ry(npoints) =  ry(npoints) - rh(npoints)
 40   continue
      call DrawRectangle(npoints)
      return
      end
