/*
 * moveb -- move an area of a bitmap within a window
 *
 * compile with:
 *	cc -o moveb -O moveb.c -ltools -lbm -lvt
 */

#include  <vt.h>
#include  <stdio.h> 
#include  <signal.h> 
#include  <tools.h>
#include  <bitmap.h>

#define	BOUNDED		1	/* movement algorithms */
#define	TILED		2

#define	SOLIDSOLID	1	/* move: solid    paint: solid */
#define	SOLIDTRANS	2	/* move: solid    paint: trans */
#define	TRANSSOLID	3	/* move: trans    paint: solid */
#define	TRANSTRANS	4	/* move: trans    paint: trans */

struct foo {short active, sx, sy, x, y, w, h};

short  MAXW, MAXH, translucent, algorithm;
struct foo ar;
struct BMD *tempbmd[4];
struct vtseq input;                   
struct wstate istate;    

cleanup()
{
    BlockRefreshAdjust(1);
    SetPosition(1, 0, 0);
    SetColor(1, istate.bcolor);
    PaintRectangleInterior(1, 10000, 10000);
    SetWindowState(1, &istate);
    exit(0);
}

main(argc, argv)
int argc;
char *argv[];
{
    short i;
    struct gconfig	gc;
    char *file;
    char   ebuf[200];

    if (argc > 2) {
       printf(" usage: %s bitmapfilename\n", argv[0]);
       exit(1);
    } else if (argc < 2) {
       file = "/usr/src/demo/escher.b";
    } else {
       file = argv[1];
    }
    if (GetGraphicsConfig(1, &gc) == -1) {
	    printf("%s: not a window\n", argv[0]);
	    exit(1);
    }
    if ((tempbmd[0] = BM_Read(file)) == 0) {
       sprintf(ebuf, "%s: %s", argv[0], file);
       perror(ebuf);
       exit(1);
    }
    MAXW = tempbmd[0]->width;
    MAXH = tempbmd[0]->height;
    signal(SIGTERM, cleanup);
    signal(SIGHUP, cleanup);
    signal(SIGQUIT, cleanup);
    signal(SIGINT, cleanup);
    initialize();
    for (;;)  {
       switch(getvtseq(1, &input)) {
	  case VT_MOUSE:
		if (!(input.u.mouse.buttons & VT_MOUSE_DOWN))
		    continue;
	        switch(input.u.mouse.buttons & ( VT_MOUSE_LEFT  | 
						  VT_MOUSE_MIDDLE|
						  VT_MOUSE_RIGHT   ) )
		{
	           case VT_MOUSE_LEFT:
		      switch (algorithm) {
			 case 0:
			    break;
			 case BOUNDED:
			    boundmove();
			    break;
			 case TILED:
			    tiledmove();
			    break;
			 default:
			    break;
		      }
		      break;
	           case VT_MOUSE_MIDDLE:
                      SetPosition(1, input.u.mouse.x, input.u.mouse.y);
		      switch (algorithm) {
			 case BOUNDED:
                            i = DisplayPopUp(1,
"Move Bitmap\0Opaque-opaque\0Opaque-translucent\0Translucent-opaque\0Translucent-translucent\0");
			    break;
			 case TILED:
			    i = DisplayPopUp(1,
"Move Bitmap\0Opaque-opaque\0Opaque-translucent\0");
			    break;
			 default:
			    break;
		      }
                      switch(i) {
                         case 0:
			    break;
                         case SOLIDSOLID: /* move: solid    paint: solid */
			    translucent = SOLIDSOLID;
			    break;
                         case SOLIDTRANS: /* move: solid    paint: trans */
			    translucent = SOLIDTRANS;
			    break;
                         case TRANSSOLID: /* move: trans    paint: solid */
			    translucent = TRANSSOLID;
			    break;
                         case TRANSTRANS: /* move: trans    paint: trans */
			    translucent = TRANSTRANS;
			    break;
			 default:
			    break;
		      }
		      break;
	           case VT_MOUSE_RIGHT:
                      SetPosition(1, input.u.mouse.x, input.u.mouse.y);
switch(DisplayPopUp(1, "Algorithm\0Bounded\0Tiled\0Exit\0"))
		      {
                         case 0:
			    break;
                         case BOUNDED:
			    algorithm = BOUNDED;
			    break;
                         case TILED:
			    algorithm = TILED;
			    break;
                         case 3:
			    finish();
			    break;
			 default:
			    break;
		      }
		      break;
		   default: break;
	        }
	    break;
	  default:
	    DisplayStatus(1, "MOVE: That keystroke not implemented.");
	    break;
       }
    }
}

boundmove()
{
    register short dx, dy, sx, sy;
    register short x, y, w, h;
    short sw, sh;

    sw = 0;
    sh = 0;
    sx = input.u.mouse.x;
    sy = input.u.mouse.y;
    TrackRubberBox(1, sx, sy, &sw, &sh, 0, 0, MAXW, MAXH, 2);
    if (sw<0) {
       sx += sw;
       sw = -sw;
    }
    if (sh<0) {
       sy += sh;
       sh = -sh;
    }
    input.u.mouse.x = sx + sw;
    input.u.mouse.y = sy + sh;

    SetMouseMode(1, VT_MOUSE_CONTINUOUS|VT_MOUSE_UP|VT_MOUSE_DOWN);          
    if (translucent != SOLIDSOLID) {
       BM_CopyRegion(tempbmd[0], sx, sy, tempbmd[2], 0, 0, sw, sh);
       BM_InvertRegion(tempbmd[2], 0, 0, sw, sh);
    }
    dx=input.u.mouse.x;
    dy=input.u.mouse.y;
    for (;;) {

       (void) getvtseq(1, &input);
       if (input.u.mouse.buttons & VT_MOUSE_UP) break;

       w = sw;
       x = dx - input.u.mouse.x;
       if (x<0) x = -x;
       w += x;
       x = input.u.mouse.x;
       if (x > dx) x = dx;

       h = sh;
       y = dy - input.u.mouse.y;
       if (y<0) y = -y;
       h += y;
       y = input.u.mouse.y;
       if (y > dy) y = dy;

       BM_CopyRegion(tempbmd[0], x, y, tempbmd[1], x, y, w, h);

       if ((translucent == TRANSSOLID) || (translucent == TRANSTRANS)) {
          BM_PaintRegion(tempbmd[1], input.u.mouse.x, input.u.mouse.y, sw, sh,
	      VT_Black, tempbmd[2]->bitmap.address, 0, 0, tempbmd[2]->width);
       }
       else {
          BM_CopyRegion(tempbmd[0], sx, sy, tempbmd[1],
	      input.u.mouse.x, input.u.mouse.y, sw, sh);
       }

       BM_DisplayBitmap(1, COPYRASTER, tempbmd[1], x, y, x, y, w, h, 0);

       dx=input.u.mouse.x;
       dy=input.u.mouse.y;
    } 
    SetMouseMode(1, VT_MOUSE_DOWN|VT_MOUSE_UP);          

    if ((translucent == SOLIDSOLID)||(translucent == TRANSSOLID)) 
       BM_CopyRegion(tempbmd[0], sx, sy, tempbmd[0], dx, dy, sw, sh);
    else {
       BM_CopyRegion(tempbmd[0], sx, sy, tempbmd[1], 0, 0, sw, sh);
       BM_InvertRegion(tempbmd[1], 0, 0, sw, sh);
       BM_PaintRegion(tempbmd[0], dx, dy, sw, sh, VT_Black,
          tempbmd[1]->bitmap.address, 0, 0, tempbmd[1]->width);
    }

    BM_DisplayBitmap(1, COPYRASTER, tempbmd[0], sx, sy, sx, sy, sw, sh, 0);
    BM_DisplayBitmap(1, COPYRASTER, tempbmd[0], dx, dy, dx, dy, sw, sh, 0);
}

finish()
{
   RemoveStatus(1);
   SetPermanentClipping(1, 0, 0, 10000, 10000);
   SetPosition(1, 0, 0);
   SetColor(1, istate.bcolor);
   PaintRectangleInterior(1, 10000, 10000);
   SetWindowState(1, &istate);
   exit(0);
}

initialize()
{
   int refresh();

   GetWindowState(1, &istate);
   SetLineDisc(1, TWSDISC);
   SetRefresh(1, 0, refresh);
   SetMouseMode(1, VT_MOUSE_DOWN|VT_MOUSE_UP);
   SetBuf(1, 1024);
   SetColor(1, VT_Black);                  
   SetThickness(1, 2);                      
   SetAddressing(1, VT_RELATIVE); 
   if ((tempbmd[1] = BM_Allocate(MAXW, MAXH)) == 0) {
      DisplayStatus(1, "MOVE: unable to allocate internal bitmap #2\n");
      exit(1);
   }
   if ((tempbmd[2] = BM_Allocate(MAXW, MAXH)) == 0) {
      DisplayStatus(1, "MOVE: unable to allocate internal bitmap #3\n");
      exit(1);
   }
   BM_DisplayBitmap(1, COPYRASTER, tempbmd[0], 0, 0, 0, 0, MAXW, MAXH, 0);
   translucent = SOLIDSOLID;
   algorithm = BOUNDED;
   ar.active = 0;
}

refresh(id, x, y, w, h)
int id;
short x, y, w, h;
{
   if (ar.active == 0)
       BM_DisplayBitmap(1, COPYRASTER, tempbmd[0], x, y, x, y, w, h, 0);
   else
       BM_DisplayBitmap(1, COPYRASTER, tempbmd[0], ar.sx, ar.sy,
		       ar.x, ar.y, ar.w, ar.h, 0);
}

tiledmove()
{
    register short dx, dy, sx, sy;
    short sw, sh;

    sw = 0;
    sh = 0;
    sx = input.u.mouse.x;
    sy = input.u.mouse.y;
    TrackRubberBox(1, sx, sy, &sw, &sh, 0, 0, MAXW, MAXH, 2);
    if (sw<0) {
       sx += sw;
       sw = -sw;
    }
    if (sh<0) {
       sy += sh;
       sh = -sh;
    }
    ar.active = 1;
    ar.sx = sx;
    ar.sy = sy;
    ar.x = sx;
    ar.y = sy;
    ar.w = sw;
    ar.h = sh;
    dx = sx;
    dy = sy;
    input.u.mouse.x = sx + sw;
    input.u.mouse.y = sy + sh;

    SetMouseMode(1, VT_MOUSE_CONTINUOUS|VT_MOUSE_UP|VT_MOUSE_DOWN);          
    if (translucent != SOLIDSOLID) {
       BM_CopyRegion(tempbmd[0], sx, sy, tempbmd[2], 0, 0, sw, sh);
       BM_InvertRegion(tempbmd[2], 0, 0, sw, sh);
    }

    for (;;) {

       (void) getvtseq(1, &input);
       ar.x = input.u.mouse.x;
       ar.y = input.u.mouse.y;
       if (input.u.mouse.buttons & VT_MOUSE_UP) break;

       CopyRegion(1, dx, dy, input.u.mouse.x, input.u.mouse.y, sw, sh);
       TileRegion(tempbmd[0], dx, dy, input.u.mouse.x, input.u.mouse.y, sw, sh);

       dx=input.u.mouse.x;
       dy=input.u.mouse.y;
    } 

    SetMouseMode(1, VT_MOUSE_DOWN|VT_MOUSE_UP);          

    if ((translucent == SOLIDSOLID)||(translucent == TRANSSOLID)) 
       BM_CopyRegion(tempbmd[0], sx, sy, tempbmd[0], dx, dy, sw, sh);
    else {
       BM_CopyRegion(tempbmd[0], sx, sy, tempbmd[1], 0, 0, sw, sh);
       BM_InvertRegion(tempbmd[1], 0, 0, sw, sh);
       BM_PaintRegion(tempbmd[0], dx, dy, sw, sh, VT_Black,
          tempbmd[1]->bitmap.address, 0, 0, tempbmd[1]->width);
    }

    BM_DisplayBitmap(1, COPYRASTER, tempbmd[0], sx, sy, sx, sy, sw, sh, 0);
    BM_DisplayBitmap(1, COPYRASTER, tempbmd[0], dx, dy, dx, dy, sw, sh, 0);
}

TileRegion(bmd, sx, sy, dx, dy, sw, sh)
struct BMD *bmd;
short sx, sy, dx, dy, sw, sh;
{
   register short x1, y1, w1, h1;
   register short x2, y2, w2, h2;

   x2=x1=sx;
   y2=y1=sy;
   w2=w1=sw;
   h2=h1=sh;

   if (sx > dx) {
      if (sy > dy) {               /*  (sx>dx) && (sy>dy) */
	 y1 = dy + sh;
	 w1 = sw - sx + dx;
	 h1 = sy - dy;
	 x2 = sx + w1;
	 w2 = sw - w1;
      }
      else {                       /*  (sx>dx) && (sy<=dy) */ 
	 w1 = sw - sx + dx;
	 h1 = dy - sy;
	 x2 = sx + w1;
	 w2 = sw - w1;
      }
   }
   else {
      if (sy > dy) {               /*  (sx <= dx) && (sy>dy) */
	 w1 = dx - sx;
	 x2 = sx + w1;
	 y2 = dy + sh;
	 w2 = sw - w1;
	 h2 = sy - dy;
      }
      else {                       /* (sx <= dx) && (sy <= dy) */
	 w1 = dx - sx;
	 x2 = sx + w1;
	 w2 = sw - w1;
	 h2 = dy - sy;
      }
   }
   BM_DisplayBitmap(1, COPYRASTER, bmd, x1, y1, x1, y1, w1, h1, 0);
   BM_DisplayBitmap(1, COPYRASTER, bmd, x2, y2, x2, y2, w2, h2, 0);

   ar.active = 0;
}
