/*
 *	menu - An example menu program
 *
 *  	Compile with:
 * 	cc -O menu.c -o menu -ltools -lvt
 *
 */
#include <vt.h>
#include <tools.h>

struct choice	pointsize_choices[] = {
	{LABEL,	"6",	VT_White},
	{LABEL,	"8",	VT_White},
	{LABEL,	"10",	VT_White},
	{LABEL,	"12",	VT_White},
	{LABEL,	"14",	VT_White},
	{LABEL,	"16",	VT_White},
	{LABEL,	"18",	VT_White},
	{LABEL,	"20",	VT_White},
	{LABEL,	"22",	VT_White},
	{LABEL,	"24",	VT_White},
	{LABEL,	"28",	VT_White},
	{LABEL,	"36",	VT_White}
};

struct choice	emphasis_choices[] = {
	{LABEL,	"Italics",		VT_White},
	{LABEL,	"Bold",		VT_White},
	{LABEL,	"Underline",	VT_White}
};

struct question	font_questions[] = {
	{STRING,	"Font Name",	25,	0 },
	{SELECT,	"Point Size",	12,	pointsize_choices },
	{TOGGLE,	"Emphasis",		3,	emphasis_choices }
};

struct menu font_menu = {
	"Set Font",	3,	font_questions
};

char	fontname[25]	= "Helvetica";
int	pointsize	= 0;
bool	emphasis[3]	= { FALSE, FALSE, FALSE };

int	*font_answers[]	= { (int *) fontname, &pointsize, (int *) emphasis };

main()
{
	while (PresentMenu(&font_menu, font_answers) == 0);
	printf("PresentMenu failed\n");
}
