/*
 *	Compile with:
 *	cc -O hilbert.c -o hilbert -lvt
 */
#include <vt.h>
#include <signal.h>

#define XMIN	0
#define YMIN	0
#include "sin.h"
#define SIN(x)	sin[(x)%360]
#define COS(x)  sin[((x)+90)%360]

struct pen{
	short	x, y;
	short	angle;
};

struct pen 	bic;
short	width, height;
int	index, side;
int	thickness = 1;
struct wstate ws;

cleanup()
{
    BlockRefreshAdjust(1);
    SetPosition(1, 0, 0);
    SetColor(1, ws.bcolor);
    PaintRectangleInterior(1, 10000, 10000);
    SetWindowState(1, &ws);
    exit(0);
}

main(argc, argv)
int	argc;
char	**argv;
{
int	adjustsize(), ignoreref();
struct gconfig	gc;


	if( argc < 2){
		printf("usage:	%s index, [side [thickness]]\n", argv[0]);
		exit(1);
 	}
	if (GetGraphicsConfig(1, &gc) == -1) {
		printf("%s: not a window\n", argv[0]);
		exit(1);
	}

	signal(SIGTERM, cleanup);
	signal(SIGHUP, cleanup);
	signal(SIGQUIT, cleanup);
	signal(SIGINT, cleanup);

	sscanf(argv[1],"%d",&index);
	if( argc > 2){
		sscanf(argv[2],"%d",&side);
	}
	if( argc > 3){
		sscanf(argv[3],"%d",&thickness);
	}
	GetWindowState(1, &ws);
	width = ws.width;
	height= ws.height;
	if( argc > 2){
		sscanf(argv[2],"%d",&side);
	}else{
		side = ((width < height) ? width : height)/ ((1<<index)-1);
	}
	SetLineDisc( 1, TWSDISC);
	SetBuf(1, 100);
    	SetMouseMode(1, VT_MOUSE_DOWN);
	SetRefresh(1, 0, ignoreref);
	SetAdjust(1, 0, adjustsize);
	SetAddressing(1, VT_RELATIVE);
	SetThickness(1, thickness);
	cls();
	bic.angle = 270;
	bic.x = 0;
	bic.y = height;
	hilbert( &bic, index, side);
	Flush(1);
	cls();
	SetWindowState(1, &ws);
}

cls()
{
	SetPosition(1,0,0);
	SetColor(1,VT_White);
	PaintRectangleInterior(1, 2000, 2000);
	SetColor(1,VT_Black);
}

hilbert( pen, n, s)
struct pen	*pen;
int		n, s;
{
	short	m, a;

	if( n == 0){
		turn( pen, 180);
		return;
	}else if (n > 0){
		a = 90;
		m = n - 1;
	}else{
		a = -90;
		m = n + 1;
	}
	turn( pen, a);
	hilbert( pen, -m, s);
	turn( pen, a);
	go( pen, s);
	hilbert( pen, m, s);
	turn( pen, -a);
	go( pen, s);
	turn( pen, -a);
	hilbert( pen, m, s);
	go( pen, s);
	turn( pen, a);
	hilbert( pen, -m, s);
	turn( pen, a);
}

go( pen, distance)
struct pen	*pen;
int	distance;
{
	register	deltax, deltay;
	if(!distance) return;
	deltax = distance * COS(pen->angle);
	deltay = distance * SIN(pen->angle);
	if( distance < 0){
		pen->x += deltax;
		pen->y += deltay;
		SetPosition(1, pen->x, pen->y);
		PaintLine(1, -deltax, -deltay);
	}else{
		SetPosition(1, pen->x, pen->y);
		PaintLine(1, deltax, deltay);
		pen->x += deltax;
		pen->y += deltay;
	}
}

turn( pen, angle)
struct pen	*pen;
int	angle;
{
	pen->angle = (pen->angle + angle) % 360;
}

ignoreref()
{
}

adjustsize(id,w,h)
int id;
short w, h;
{
	width=w; height=h;
	SetPosition(1,0,0);
	SetColor(1,VT_White);
	PaintRectangleInterior(1,5000, 5000);
}
