/*
* grid -- draws an alignment grid 
*	with options :
*	    i : invert, black on white (default white on black)
*	    s : small squares (default)
*	    l : large squares
*
* compile with :
*	cc -O grid.c -o grid -lgip -lvt
*/

#include <vt.h>
#include <stdio.h>
#include <gip.h>

#define LINE_WIDTH 2
#define	PMASK  0xff

int	iflag;		/* invert flag */

main(argc, argv)
int	argc;
char	*argv[];
{
    register char	*s;
    struct gconfig	gc;
    int			fd;		/* window descriptor */
    int			box_size = 32;	/* default size of box */

    if (GetGraphicsConfig(1, &gc) == -1) {
	fprintf(stderr, "%s: not a window\n", argv[0]);
	exit(1);
    }
        
    if (argc > 2) {
	fprintf(stderr, "usage: grid [il]\n");
	exit(1);
    }

    for (s = (*++argv)[0] == '-' ? argv[0] + 1 : argv[0]; *s != '\0'; s++)
	switch(*s) {
	    case 'i' : iflag++; break;
	    case 'l' : box_size = 96; break;
	    case 's' : box_size = 32; break;
	    default : fprintf(stderr, "grid : no option %c.\n", *s); break;
	} 

    /* connect to workstation screen */
    if ((fd = GIP_Init()) == -1) {
	fprintf(stderr, "GIP_Init Error : %s.\n", GIP_Error);
	exit(1);
    }
    SetLineDisc(fd, TWSDISC);	/* set keyboard for no echo, raw mode*/
    Draw_Lines(box_size);	/* draw grid */
    getvtchar(fd);		/* get any keyboard or mouse input */
    GIP_Quit();			/* close GIP from screen */
}

Draw_Lines(box_size)
int box_size;
{
    register int dx, dy;
    int half_w, half_h;

    half_w = ScreenPixmap.width>>1;
    half_h = ScreenPixmap.height>>1;

    /* invert screen */
    if (!iflag)
	GIP_RasterOp(GIPclear, 
	    NULL, 0, 0, &ScreenPixmap, 0, 0, NULL, 0, 0,
	    ScreenPixmap.width, ScreenPixmap.height, PMASK);

    /* draw lines */
    for (dy = iflag ? box_size : 0; dy < half_h; dy += LINE_WIDTH + box_size)
	GIP_RasterOp(GIPinvert, 
	    NULL, 0, 0, &ScreenPixmap, 0, dy, NULL, 0, 0, 
	    ScreenPixmap.width, LINE_WIDTH, PMASK);

    /* make center line wider */
    dy -= box_size;
    GIP_RasterOp(GIPinvert, 
	NULL, 0, 0, &ScreenPixmap, 0, dy, NULL, 0, 0, 
	ScreenPixmap.width, LINE_WIDTH, PMASK);

    for (dy = iflag ? ScreenPixmap.height - (box_size + LINE_WIDTH) : 
	    ScreenPixmap.height - LINE_WIDTH; 
	    dy > half_h; dy -= LINE_WIDTH + box_size)
	GIP_RasterOp(GIPinvert, 
	    NULL, 0, 0, &ScreenPixmap, 0, dy, NULL, 0, 0, 
	    ScreenPixmap.width, LINE_WIDTH, PMASK);

    /* make center line wider */
    dy += box_size;	
    GIP_RasterOp(GIPinvert, 
	    NULL, 0, 0, &ScreenPixmap, 0, dy, NULL, 0, 0, 
	    ScreenPixmap.width, LINE_WIDTH, PMASK);

    for (dx = iflag ? box_size : 0; dx < half_w; dx += LINE_WIDTH + box_size)
	GIP_RasterOp(GIPinvert, 
	    NULL, 0, 0, &ScreenPixmap, dx, 0, NULL, 0, 0, 
	    LINE_WIDTH, ScreenPixmap.height, PMASK);

    dx -= box_size;		/* make center line wider */
    GIP_RasterOp(GIPinvert, 
	NULL, 0, 0, &ScreenPixmap, dx, 0, NULL, 0, 0,
	LINE_WIDTH, ScreenPixmap.height, PMASK);
	    
    for (dx = iflag ? ScreenPixmap.width - (box_size + LINE_WIDTH) :
	     ScreenPixmap.width - LINE_WIDTH; dx > half_w; 
	     dx -= LINE_WIDTH + box_size)
	GIP_RasterOp(GIPinvert, 
	    NULL, 0, 0, &ScreenPixmap, dx, 0, NULL, 0, 0, 
	    LINE_WIDTH, ScreenPixmap.height, PMASK);

    /* make center line wider */
    dx += box_size;
    GIP_RasterOp(GIPinvert, 
	NULL, 0, 0, &ScreenPixmap, dx, 0, NULL, 0, 0, 
	LINE_WIDTH, ScreenPixmap.height, PMASK);
}
