(*
 gaugep -- track horizontal mouse movement with a gauge

 compile with:
	pc -o gaugep -O gaugep.p -ltoolsp -lbmp -lvtp
*)
program main(input,output);

const
#include "/usr/include/pascal/gconst.h"
	SPACE		= 20;	(* inter-object space		*)
	LTICKS		= 5;	(* number of ticks left/right	*)

type
#include "/usr/include/pascal/gtype.h"
marray = packed array [0..200] of char;
short5 = packed array [0..4] of short;
gstate = packed record
	   x,y,w,h:short;	(* location of gauge		*)
	   pos:short;		(* position of pointer in gauge	*)
end;

var
	istate : wstate;	(* initial window state		*)
	inmouse : vtseq;	(* for getvtseq inmouse		*)
	void : integer;		(* indicates return value unused*)
	message : marray;	(* message array		*)
	LeftGauge : GAUGE;	(* left/right motion gauge	*)
	done : short;		(* implies finish was called	*)
	sizes : short5;
	gfont : short;
	lcolor : short;
	uflag : short;
	tcolor : short;
	bcolor : short;
	vbcolor : short;
	ncolor : short;
	gc : gconfig;

#include "/usr/include/pascal/gproc.h"

procedure ClearScreen(color:short);
begin
	SetPosition(1, 0, 0);
	SetColor(1, color);
	PaintRectangleInterior(1, 10000, 10000);
end;

procedure Finish;
begin
	done := 1;
	ClearScreen(VTWhite);
	RemoveStatus(1);
	SetWindowState(1, istate);
end;

procedure VTAdjust(fd,id:integer; w, h:short);
begin
	istate.width := w;	istate.height := h;
	istate.tw := w;		istate.th := h;
	if (LeftGauge <> nil)	then DeleteGauge(LeftGauge);
	message := 'Left@@Middle@@Right@@';
	message[4]  := chr(0);	message[5]  := chr(0);
	message[12] := chr(0);	message[13] := chr(0);
	message[19] := chr(0);	message[20] := chr(0);
	sizes[0] := 8;	sizes[1] := 6;	sizes[2] := 4;
	sizes[3] := 6;	sizes[4] := 8;
	LeftGauge := CreateGauge(fd, SPACE, SPACE, istate.width-2*SPACE, 
		istate.height-2*SPACE, bcolor, tcolor, lcolor, ncolor,
		gfont, inmouse.x, message[0], sizes[0], LTICKS);
end;

procedure VTRefresh(fd,id:integer; x, y, w, h:short);
var
	rstate : wstate;
begin
	void := GetWindowState(fd, rstate);
	SetTemporaryClipping(fd, x, y, w, h);
	ClearScreen(vbcolor);
	RefreshGauge(LeftGauge);
	SetColor(fd, tcolor);
	SetThickness(fd, 1);
	SetPosition(fd, SPACE, SPACE);
	PaintRectangleBorder(fd, istate.width-2*SPACE, istate.height-2*SPACE);
	SetWindowState(fd, rstate);
end;

procedure Initialize;
begin
	uflag := 0;
	LeftGauge := nil;
	tcolor := VTWhite;	bcolor := VTBlack;
	vbcolor := VTGray50;	ncolor := VTWhite;
   	void := GetWindowState(1, istate);
	void := SetLineDisc(1, TWSDISC);
	void := BlockRefreshAdjust(1);
	SetRefresh(1,0);	SetAdjust(1,0);
	SetMouseMode(1, [VTMOUSEDOWN,VTMOUSECONTINUOUS]);
	SetAddressing(1, VTRELATIVE);
	if (SetLocalLUT(1, 3, 0, 14, 0, VTSHARE) <> -1) then tcolor := 3;
	if (SetLocalLUT(1, 4, 15, 0, 0, VTSHARE) <> -1) then ncolor := 4;
	if (SetLocalLUT(1, 5, 3, 3, 3, VTSHARE) <> -1) then vbcolor := 5;
	lcolor := tcolor;
	message := 'menu';	message[4] := chr(0);
	gfont := GetFontId(message[0]);
	VTAdjust(1, 0, istate.width, istate.height);
	VTRefresh(1, 0, 0, 0, istate.width, istate.height);
end;

procedure TrackMouse;
var leave : short;
begin
	uflag := 1;
	leave := 0;
	while (leave = 0) do begin
		void := getvtseq(1, inmouse);
		if (VTMOUSEDOWN in inmouse.buttons) then leave:=1
		else MoveGauge(LeftGauge, inmouse.x-SPACE);
	end;
end;

procedure Gauges;
var
    j, i : short;
begin
    done := 0;
    while (done = 0) do begin
	if (uflag = 0)	then	i := getvtseq(1, inmouse)
	else			i := VTMOUSE;
	case i of
	    VTMOUSE: begin
		RemoveStatus(1);
		if (VTMOUSERIGHT in inmouse.buttons) then Finish
		else if (VTMOUSEMIDDLE in inmouse.buttons) then begin
			SetPosition(1, inmouse.x,inmouse.y);
			message := 'Gauge@Exit@@';
			message[5] := chr(0);
			message[10] := chr(0);
			message[11] := chr(0);
			j := DisplayPopUp(1,message[0]);
			if (j <> 0) then Finish;
		end else TrackMouse;
	    end;
	    VTEOF,VTASCII,VTHARDKEY : begin
	       message := 'use the mouse';	message[13] := chr(0);
	       DisplayStatus(1, message[0]);
	    end;
	end;
    end;
end;

begin
	void := GetGraphicsConfig(1,gc);
	if (void = -1) then writeln('Not a window.')
	else begin
		Initialize;
		Gauges;
		Finish;
	end;
end.
