C
C	gaugef -- track horizontal mouse movement with a gauge
C
C	compile with:
C		f77 -o gaugef -O gaugef.f -libtoolsf -libbmf -lvtf
C
	program Gauge
	call Initialize
	call Loop
	call Finish
	stop
	end

	subroutine Loop
	common /vtf/ istate, input, vtmcontinu, twsdisc, vtmdown,
     +		vtmouseleft, vtmousemiddle, vtmouseright, vtshare,
     +		tcolor, bcolor, vbcolor, ncolor, space, key,
     +		gfont, lcolor, LeftGauge
	integer istate(28), input(6), vtmcontinu, twsdisc, vtmdown,
     +		vtmouseleft, vtmousemiddle, vtmouseright, vtshare,
     +		tcolor, bcolor, vbcolor, ncolor, space, key,
     +		gfont, lcolor, LeftGauge
	integer DisplayPopUp, key
	call getvtseq(1, input)
 10	continue
		call RemoveStatus(1)
		if (iand(input(2), vtmouseright ).gt.0) call Finish
		if (iand(input(2), vtmousemiddle).gt.0) goto 300
		call TrackMouse
		goto 400
 300	continue
		call SetPosition(1, input(5),input(6))
		i = DisplayPopUp(1,"Gauge@Exit@")
		if (i .ne. 0) call Finish
		call TrackMouse
		goto 400
 400	continue
		if (0 .eq. 0) goto 10
	return
	end

	subroutine Initialize
	common /vtf/ istate, input, vtmcontinu, twsdisc, vtmdown,
     +		vtmouseleft, vtmousemiddle, vtmouseright, vtshare,
     +		tcolor, bcolor, vbcolor, ncolor, space, key,
     +		gfont, lcolor, LeftGauge
	integer istate(28), input(6), vtmcontinu, twsdisc, vtmdown,
     +		vtmouseleft, vtmousemiddle, vtmouseright, vtshare,
     +		tcolor, bcolor, vbcolor, ncolor, space, key,
     +		gfont, lcolor, LeftGauge
	external	Refresh, Adjust
	integer		gc(12), err, GraphicsConfig
	integer		SetLocalLUT, GetFontId
	err = GraphicsConfig(1, gc)
	if (err .ne. -1 ) goto 10
		write(6,100)
 100		format("Not a window.")
		stop
  10	continue
	call GetWindowState(1, istate)
	call SetLineDisc(1, twsdisc)
	call BlockRefAdj(1)
	call SetRefresh(1, 0, Refresh)
	call SetAdjust(1, 0, Adjust)
	call SetAddress(1, vtrelative)
	call SetMouseMode(1, vtmdown + vtmcontinu)
	err = SetLocalLUT(1, 3, 0, 14, 0, vtshare)
	if (err .ne. -1) tcolor = 3
	err = SetLocalLUT(1, 4, 15, 0, 0, vtshare)
	if (err .ne. -1) ncolor = 4
	err = SetLocalLUT(1, 5, 3, 3, 3, vtshare)
	if (err .ne. -1) vbcolor = 5
	lcolor = tcolor
	gfont = GetFontId("menu")
	input(5) = 0
	call Adjust(1, istate(16), istate(17))
	call Refresh(1, 0, 0, istate(16), istate(17))
	return
	end

	subroutine TrackMouse
	common /vtf/ istate, input, vtmcontinu, twsdisc, vtmdown,
     +		vtmouseleft, vtmousemiddle, vtmouseright, vtshare,
     +		tcolor, bcolor, vbcolor, ncolor, space, key,
     +		gfont, lcolor, LeftGauge
	integer istate(28), input(6), vtmcontinu, twsdisc, vtmdown,
     +		vtmouseleft, vtmousemiddle, vtmouseright, vtshare,
     +		tcolor, bcolor, vbcolor, ncolor, space, key,
     +		gfont, lcolor, LeftGauge
 10	continue
	call getvtseq(1, input)
	if (iand(input(2),vtmdown) .ne. 0) return
	call MoveGauge(LeftGauge, input(5)-space)
	if (0 .eq. 0) goto 10
	return
	end

	subroutine Finish
	common /vtf/ istate, input, vtmcontinu, twsdisc, vtmdown,
     +		vtmouseleft, vtmousemiddle, vtmouseright, vtshare,
     +		tcolor, bcolor, vbcolor, ncolor, space, key,
     +		gfont, lcolor, LeftGauge
	integer istate(28), input(6), vtmcontinu, twsdisc, vtmdown,
     +		vtmouseleft, vtmousemiddle, vtmouseright, vtshare,
     +		tcolor, bcolor, vbcolor, ncolor, space, key,
     +		gfont, lcolor, LeftGauge
	call SetMouseMode(1, vtmdown)
	call ClearScreen(istate(2))
	call RemoveStatus(1)
	call SetWindowState(1, istate)
	stop
	end

	subroutine ClearScreen(color)
	integer color
	common /vtf/ istate, input, vtmcontinu, twsdisc, vtmdown,
     +		vtmouseleft, vtmousemiddle, vtmouseright, vtshare,
     +		tcolor, bcolor, vbcolor, ncolor, space, key,
     +		gfont, lcolor, LeftGauge
	integer istate(28), input(6), vtmcontinu, twsdisc, vtmdown,
     +		vtmouseleft, vtmousemiddle, vtmouseright, vtshare,
     +		tcolor, bcolor, vbcolor, ncolor, space, key,
     +		gfont, lcolor, LeftGauge
	call SetPosition(1, 0, 0)
	call SetColor(1, color)
	call RecInterior(1, 10000, 10000)
	return
	end

	subroutine Refresh(id, x, y, w, h)
	common /vtf/ istate, input, vtmcontinu, twsdisc, vtmdown,
     +		vtmouseleft, vtmousemiddle, vtmouseright, vtshare,
     +		tcolor, bcolor, vbcolor, ncolor, space, key,
     +		gfont, lcolor, LeftGauge
	integer istate(28), input(6), vtmcontinu, twsdisc, vtmdown,
     +		vtmouseleft, vtmousemiddle, vtmouseright, vtshare,
     +		tcolor, bcolor, vbcolor, ncolor, space, key,
     +		gfont, lcolor, LeftGauge
	integer id, x, y, w, h
	integer rstate(28)
	call GetWindowState(1, rstate)
	call SetTempClip(1, x, y, w, h)
	call ClearScreen(vbcolor)
	call RefreshGauge(LeftGauge)
	call SetColor(1, tcolor)
	call SetThickness(1, 1)
	call SetPosition(1, space, space)
	call RecBorder(1, istate(16)-2*space, istate(17)-2*space)
	call SetWindowState(1, rstate)
	return
	end

	subroutine Adjust(id, w, h)
	common /vtf/ istate, input, vtmcontinu, twsdisc, vtmdown,
     +		vtmouseleft, vtmousemiddle, vtmouseright, vtshare,
     +		tcolor, bcolor, vbcolor, ncolor, space, key,
     +		gfont, lcolor, LeftGauge
	integer istate(28), input(6), vtmcontinu, twsdisc, vtmdown,
     +		vtmouseleft, vtmousemiddle, vtmouseright, vtshare,
     +		tcolor, bcolor, vbcolor, ncolor, space, key,
     +		gfont, lcolor, LeftGauge
	integer id, w, h
	integer sizelist(5), CreateGauge
	istate(16) = w
	istate(17) = h
	istate(24) = w
	istate(25) = h
	if (LeftGauge .ne. 0)	call DeleteGauge(LeftGauge)
	sizelist(1) = 8
	sizelist(2) = 4
	sizelist(3) = 6
	sizelist(4) = 4
	sizelist(5) = 8
	LeftGauge = CreateGauge(1, space, space, istate(16)-2*space,
     +		istate(17)-2*space, bcolor, tcolor, lcolor, ncolor,
     +		gfont, input(5), "Left@@Middle@@Right@", sizelist, 5)
	return
	end
C----------------------------------------------------------------------
C BLOCK DATA
C----------------------------------------------------------------------
	block data
	common /vtf/ istate, input, vtmcontinu, twsdisc, vtmdown,
     +		vtmouseleft, vtmousemiddle, vtmouseright, vtshare,
     +		tcolor, bcolor, vbcolor, ncolor, space, key,
     +		gfont, lcolor, LeftGauge
	integer istate(28), input(6), vtmcontinu, twsdisc, vtmdown,
     +		vtmouseleft, vtmousemiddle, vtmouseright, vtshare,
     +		tcolor, bcolor, vbcolor, ncolor, space, key,
     +		gfont, lcolor, LeftGauge
C
	data	vtwhite		/1/
	data	tcolor		/1/
	data	ncolor		/1/
	data	vtblack		/0/
	data	bcolor		/0/
	data	vbcolor		/-2/
	data	twsdisc		/5/
	data	vtstrend	/-2/
	data	vtshare 	/1/
	data	vtmdown		/16/
	data	vtmcontinu	/128/
	data	vtmouseleft	/1/
	data	vtmousemiddle	/2/
	data	vtmouseright	/4/
	data	space		/20/
	data	LeftGauge	/0/
	end
