/*	
 * gauge -- track horzontal movement of the mouse with a gauge
 *
 * Compile with:
 *	cc -o gauge -O gauge.c -ltools -lvt 
 */

#include <vt.h>
#include <tools.h>

#define	SPACE	20

struct	gconfig gc;
struct	wstate ws;
struct	vtseq input;
int	Adjust(), Refresh();
short	gfont, lcolor;
short	tcolor = VT_White;
short	bcolor = VT_Black;
short	vbcolor = VT_Gray50;
short	ncolor = VT_White;
char	*Gauge = (char *)0;
struct tick	lticks[] = {
	{ "Left",	8 },
	{ "",		4 },
	{ "Middle",	6 },
	{ "",		4 },
	{ "Right",	8 },
};
#define	LTICKS	(sizeof(lticks)/sizeof(struct tick))

main(argc, argv)
int	argc;
char	*argv[];
{
	if (GetGraphicsConfig(1, &gc) == -1) {
	    printf("%s: not a window\n", argv[0]);
	    exit(1);
	}
	GetWindowState(1, &ws);
	SetLineDisc(1, TWSDISC);
	BlockRefreshAdjust(1);
	SetBuf(1, 512);
	if (SetLocalLUT(1, 3, 0, 14, 0, VT_SHARE) != -1) tcolor = 3;
	if (SetLocalLUT(1, 4, 15, 0, 0, VT_SHARE) != -1) ncolor = 4;
	if (SetLocalLUT(1, 5, 3, 3, 3, VT_SHARE) != -1) vbcolor = 5;
	lcolor = tcolor;
	gfont = GetFontId("menu");
	SetAdjust(1, 0, Adjust);
	SetRefresh(1, 0, Refresh);
	SetMouseMode(1, VT_MOUSE_DOWN | VT_MOUSE_CONTINUOUS);
	SetAddressing(1, VT_RELATIVE);
	input.u.mouse.x = 0;
	Adjust(1, ws.width, ws.height);
	Refresh(1, 0, 0, ws.width, ws.height);

	(void) getvtseq(1, &input);
	for (;;) {
		RemoveStatus(1);
	    	switch(input.u.mouse.buttons & 
			   (VT_MOUSE_LEFT | VT_MOUSE_MIDDLE | VT_MOUSE_RIGHT) ){
	    		case VT_MOUSE_RIGHT:
				Finish();
				break;
	    		case VT_MOUSE_MIDDLE:
				SetPosition(1, input.u.mouse.x, input.u.mouse.y);
				if (DisplayPopUp(1, "Gauge\0Exit\0")) Finish();
				else TrackMouse();
				break;
	    		default:
				TrackMouse();
				break;
		}
	}
}

TrackMouse()
{
	for (;;) {
		(void) getvtseq(1, &input);
		if (input.u.mouse.buttons & VT_MOUSE_DOWN) return;
		MoveGauge(Gauge, input.u.mouse.x-SPACE);
	}
}

Finish()
{
	SetMouseMode(1, VT_MOUSE_DOWN);
	ClearScreen(ws.bcolor);
	RemoveStatus(1);
	SetWindowState(1, &ws);
	exit(0);
}

ClearScreen(color)
short color;
{
	SetPosition(1, 0, 0);
	SetColor(1, color);
	PaintRectangleInterior(1, 10000, 10000);
}

Refresh(id, x, y, w, h)
int id;
short x, y, w, h;
{
	struct wstate rstate;
	GetWindowState(1, &rstate);
	SetTemporaryClipping(1, x, y, w, h);
	ClearScreen(vbcolor);
	RefreshGauge(Gauge);
	SetColor(1, tcolor);
	SetThickness(1, 1);
	SetPosition(1, SPACE, SPACE);
	PaintRectangleBorder(1, ws.width-2*SPACE, ws.height-2*SPACE);
	SetWindowState(1, &rstate);
}

Adjust(id, w, h)
int id;
short w, h;
{
	ws.tw = ws.width = w;	ws.th = ws.height = h;
	if (Gauge)	DeleteGauge(Gauge);
	Gauge = CreateGauge(1, SPACE, SPACE, ws.width-2*SPACE,
		ws.height-2*SPACE, bcolor, tcolor, lcolor, ncolor,
		gfont, input.u.mouse.x, lticks, LTICKS);
}
