/*
 *	Compile with:
 *	cc -O erode.c -o erode -lbm -lvt
 */
#include <stdio.h>
#include <signal.h>
#include <vt.h>
#include <bitmap.h>

#define	NX	32
#define	NY	32
#define NITER	500
#define NPASS	16
#define NUPDOWN	20
#define XXX	0x7F
#define ZZ	(width/(NX*2))
#define	X0	(width/(NX/2))
#define	Y0	(width/(NX/2))

short plane[NX][NY];
short rplane[NX][NY];

struct wstate ws;
int	adjustsize(), refresh();

int	thickness = 1;
short	width, height;
struct BMD *bm[NPASS];

cleanup()
{
    BlockRefreshAdjust(1);
    SetPosition(1, 0, 0);
    SetColor(1, ws.bcolor);
    PaintRectangleInterior(1, 10000, 10000);
    SetWindowState(1, &ws);
    exit(0);
}

main(argc, argv)
int	argc;
char	*argv[];
{
	register int i, j;
	struct gconfig	gc;

	if (GetGraphicsConfig(1, &gc) == -1) {
		printf("%s: not a window\n", argv[0]);
		exit(1);
	}

	signal(SIGTERM, cleanup);
	signal(SIGHUP, cleanup);
	signal(SIGQUIT, cleanup);
	signal(SIGINT, cleanup);

	srandom(getpid());
	plot_init();

	for (i = 0 ; i < NITER ; i++) {
		init_plane();

		SetRefresh(1, 0, refresh);
		for (j = 0 ; j < NPASS ; j++) {
			plot_plane(j);
			relax_plane();
		}

		SetRefresh(1, 1, refresh);
		fast_plot();
	}
}

init_plane()
{
	register int x, y;

	for (x = 0 ; x < NX ; x++) 
	    for (y = 0 ; y < NY ; y++)
		plane[x][y] = (random() & XXX) - (height/12);

	for (x = 0 ; x < NX/4 ; x++) 
		if (random() & 1)
			init_spike();

	relax_plane();
	relax_plane();
	for (x = 0 ; x < NX ; x++) 
	    for (y = 0 ; y < NY ; y++)
		if (random()&1)
			plane[x][y] += (random() & XXX) - (height/12);
		else
			plane[x][y] -= (random() & XXX) - (height/12);
	relax_plane();
	relax_plane();
	relax_plane();
	relax_plane();
	relax_plane();
	relax_plane();
}

init_spike()
{
	register int x, y, p;

	p = random() & 1;
	while ((x = random() & 0xFF) >= NX);
	while ((y = random() & 0xFF) >= NY);
	if (p)
		plane[x][y] += random() & (XXX << 4);
	else
		plane[x][y] -= random() & (XXX << 4);
	plane[(x+1)%NX][y] = plane[x][y];
	plane[x][(y+1)%NY] = plane[x][y];
	plane[(x+1)%NX][(y+1)%NY] = plane[x][y];
	if (p)
		plane[x][y] += XXX/2;
	else
		plane[x][y] -= XXX/2;
}

plot_plane(i)
{
	register int x, y;

	BM_SetPosition(bm[i], 0, 0);
	BM_SetPattern(bm[i], BMP00);
	BM_PaintRectangleInterior(bm[i], 2000, 2000);
	BM_SetPattern(bm[i], BMP01);

	BM_SetPosition(bm[i], X0 + 0, height - Y0);
	BM_PaintLine(bm[i], X0 + (NX-1)*ZZ, height - Y0);
	BM_PaintLine(bm[i], X0 + 2*((NX-1)*ZZ), height - (Y0 + (NY-1)*ZZ));
	BM_PaintLine(bm[i], X0 + (NX-1)*ZZ, height - (Y0 + (NY-1)*ZZ));
	BM_PaintLine(bm[i], X0 + 0, height - Y0);

	for (x = 0 ; x < NX ; x++)  {
	    register int xx =  X0 + x*ZZ;
	    BM_SetPosition(bm[i], xx, height - Y0);
	    for (y = 0 ; y < NY ; y++)
		BM_PaintLine(bm[i], xx + y*ZZ, 
			height - (Y0 + plane[x][y] + y*ZZ));
	    BM_PaintLine(bm[i], xx + (y-1)*ZZ, height - (Y0 + (y-1)*ZZ));
	}
	for (y = 0 ; y < NY ; y++)  {
	    int yy = Y0 + y*ZZ;
	    BM_SetPosition(bm[i], yy, height - (yy));
	    for (x = 0 ; x < NX ; x++)
		BM_PaintLine(bm[i], yy + x*ZZ, height - (plane[x][y] + yy));
	    BM_PaintLine(bm[i], yy + (x-1)*ZZ, height - yy);
	}
	BM_DisplayBitmap(1, COPYRASTER, bm[i], 0, 0,
			    (ws.width-width)/2, (ws.height-height)/2,
			    width, height, 1);
}

fast_plot()
{
	register int i, j;

	for (j = 0 ; j < NUPDOWN ; j++) {
	    for (i = 0 ; i < NPASS ; i++)
		BM_DisplayBitmap(1, COPYRASTER, bm[i], 0, 0,
			(ws.width-width)/2, (ws.height-height)/2,
			width, height, 1);
	    for (i = NPASS-1 ; i >= 0 ; i--)
		BM_DisplayBitmap(1, COPYRASTER, bm[i], 0, 0,
			(ws.width-width)/2, (ws.height-height)/2,
			width, height, 1);
	}
}

relax_plane()
{
	register int x, y;

	for (x = 1 ; x < NX-1 ; x++) 
	    for (y = 1 ; y < NY-1 ; y++)
			rplane[x][y] = (plane[x][y] + plane[x-1][y] + 
					plane[x+1][y] + plane[x][y+1] + 
					plane[x][y-1] ) / 5;
	for (x = 1 ; x < NX-1 ; x++) {
	    rplane[x][0] = (plane[x][0] + plane[x-1][0] + plane[x+1][0] + 
				plane[x][1]) / 4;
	    rplane[x][NY-1] = (plane[x][NY-1] + plane[x-1][NY-1] + 
				plane[x+1][NY-1] + plane[x][NY-2])/4;
	}
	for (y = 1 ; y < NY-1 ; y++) {
	    rplane[0][y] = (plane[0][y] + plane[1][y] + plane[0][y+1] + 
				plane[0][y-1] ) / 4;
	    rplane[NX-1][y] = (plane[NX-1][y] + plane[NX-2][y] + 
				plane[NX-1][y+1] + plane[NX-1][y-1])/4;
	}
	rplane[0][0] = (plane[0][0] + plane[1][0] + plane[0][1]) / 3;
	rplane[0][NY-1] = (plane[0][NY-1] + plane[1][NY-1] + plane[0][NY-2]) /3;
	rplane[NX-1][0] = (plane[NX-1][0] + plane[NX-2][0] + plane[NX-1][1]) /3;
	rplane[NX-1][NY-1] = (plane[NX-1][NY-1] + plane[NX-1][NY-2] + 
				plane[NX-2][NY-1]) / 3;
	for (x = 0 ; x < NX ; x++) 
	    for (y = 0 ; y < NY ; y++)
			plane[x][y] = rplane[x][y];
}

plot_init()
{
	register int i;

	GetWindowState(1, &ws);
	width = ws.width;
	height= ws.height;

	SetLineDisc( 1, TWSDISC);
	SetMouseMode(1, 0);
	SetRefresh(1, 0, refresh);
	SetAdjust(1, 0, adjustsize);
	for (i = 0 ; i < NPASS ; i++) {
		bm[i] = BM_Allocate(width, height);
		BM_SetAddressing(bm[i], VT_ABSOLUTE);
		BM_SetThickness(bm[i], thickness);
	}
}

refresh(id, x, y, w, h)
int	id;
short	x, y, w, h;
{
	struct wstate	ws;
	GetWindowState(1, &ws);
	if (id == 1) SetTemporaryClipping(1, x, y, w, h);
	SetPosition(1, 0, 0);
	SetColor(1, VT_White);
	PaintRectangleInterior(1, 5000, 5000);
	SetWindowState(1, &ws);
}

adjustsize(id, w, h)
int id;
short w, h;
{
#ifdef notdef
	width=w;
	height=h;
#endif

	ws.width = w;
	ws.height = h;
}
