(*
 ebar2dp -- example 2D elevator bar program

 compile with:
	pc -o ebar2dp -O ebar2dp.p -ltoolsp -lvtp
*)
program main(input, output);

const
#include "/usr/include/pascal/gconst.h"

type
#include "/usr/include/pascal/gtype.h"

var
   i, void : integer;
   e2d : EBAR;
   jstate : wstate;
#include "/usr/include/pascal/gproc.h"

procedure initialize;
begin
   void := GetWindowState(1, jstate);
   void := SetLineDisc(1, TWSDISC);
   SetRefresh(1, 0);
   SetBuf(1, 1024);
end; (* procedure init *)

procedure clearscreen;
begin
   SetPosition(1, 0, 0);
   SetColor(1, VTWhite);
   PaintRectangleInterior(1, jstate.width, jstate.height);
   SetColor(1, VTBlack);
end; (* procedure clearscreen *)

procedure finish;
begin
   clearscreen;
   SetWindowState(1, jstate);
end; (* procedure finish *)

procedure elevator;
var i : integer;
    x, y, done : short;
    inmouse : vtseq;
begin
   done := 0;
   e2d := CreateElevatorBar2D(1, 50, 50, 400, 400, VTGray50, 2, EBNOARROWS,
      0, 0, (EBMAX div 4), (EBMAX div 4), VTWhite);
   RefreshElevatorBar2D(e2d);
   SetMouseMode(1, [VTMOUSEDOWN]);
   i := getvtseq(1, inmouse);
   repeat 
      case i of
	    VTEOF : done := 1;
	    VTASCII : done := 1;
	    VTHARDKEY : done := 1;
	    VTMOUSE : begin
               if (VTMOUSELEFT in inmouse.buttons) then begin
		  x := inmouse.x;
		  y := inmouse.y;
		  void := DoElevatorBar2D(e2d, x, y);
	       end;
               if (VTMOUSERIGHT in inmouse.buttons) then done := 1;
	   end;
      end;
      if (done <> 1) then i := getvtseq(1, inmouse);
   until (done > 0);
end;

procedure VTRefresh(fd, id:integer; x, y, w, h:short);
begin
   RefreshElevatorBar2D(e2d);
end;

begin
   initialize;
   clearscreen;
   elevator;
   finish;
end.
