/*
 ebar2d -- example 2D elevator bar program

 compile with:
	cc -o ebar2d -O ebar2d.c -ltools -lvt
*/

#include <vt.h>
#include <tools.h>

char *e2d;

refresh(id, x, y, w, h)
int	id;
short	x, y, w, h;
{
   struct wstate ws;
   GetWindowState(1, &ws);
   SetTemporaryClipping(1, x, y, w, h);
   RefreshElevatorBar2D(e2d);
   SetWindowState(1, &ws);
}

main(argc, argv)
int	argc;
char	*argv[];
{
   struct wstate jstate;
   struct gconfig iconfig;

   if (GetGraphicsConfig(1, &iconfig) == -1) {
      printf("%s: not a window\n", argv[0]);
      exit(1);
   }
   GetWindowState(1, &jstate);
   BlockRefreshAdjust(1);
   SetLineDisc(1, TWSDISC);
   SetBuf(1, 512);
   SetMouseMode(1, VT_MOUSE_DOWN);
   SetRefresh(1, 0, refresh);
   SetPosition(1, 0, 0);
   SetColor(1, VT_White);
   PaintRectangleInterior(1, jstate.width, jstate.height);

   elevator();

   SetPosition(1, 0, 0);
   SetColor(1, jstate.bcolor);
   PaintRectangleInterior(1, 10000, 10000);
   SetWindowState(1, &jstate);
}

elevator()
{
   struct vtseq input;

   e2d = CreateElevatorBar2D(1, 50, 50, 400, 400, VT_Gray50, 2, EB_NOARROWS,
      0, 0, (EB_MAX/4), (EB_MAX/4), VT_White);
   RefreshElevatorBar2D(e2d);
   for (;;) {
      switch (getvtseq(1, &input)) {
         case VT_MOUSE:
	    switch (input.u.mouse.buttons &
		(VT_MOUSE_LEFT|VT_MOUSE_MIDDLE|VT_MOUSE_RIGHT)) {
	    case VT_MOUSE_LEFT:
		DoElevatorBar2D(e2d, &input.u.mouse.x, &input.u.mouse.y);
		break;
	    case VT_MOUSE_MIDDLE:
		SetPosition(1, input.u.mouse.x, input.u.mouse.y);
		if (DisplayPopUp(1, "2D Elevator\0Exit\0"))
		    return;
		break;
	    case VT_MOUSE_RIGHT:
		    return;
		break;
	    }
	    break;
         default:
	    break;
      }
   }
}
