(*
 ebar1dp -- example elevator program

 compile with:
	pc -o ebar1dp -O ebar1dp.p -ltoolsp -lvtp
*)

program main(input, output);

const
#include "/usr/include/pascal/gconst.h"

type
#include "/usr/include/pascal/gtype.h"

var
   i, void : integer;
   jstate : wstate;
   ebar : EBAR;
#include "/usr/include/pascal/gproc.h"

procedure initialize;
begin
   void := GetWindowState(1, jstate);
   void := SetLineDisc(1, TWSDISC);
   SetAdjust(1, 0);
   SetRefresh(1, 0);
   SetBuf(1, 1024);
   SetPosition(1, 0, 0);
   SetColor(1, VTWhite);
   PaintRectangleInterior(1, jstate.width, jstate.height);
end; (* procedure init *)

procedure finish;
begin
   SetPosition(1, 0, 0);
   SetColor(1, jstate.bcolor);
   PaintRectangleInterior(1, jstate.width, jstate.height);
   SetWindowState(1, jstate);
end; (* procedure finish *)

procedure VTAdjust(fd, id:integer; w, h:short);
begin
   DeleteElevatorBar(ebar);
   ebar := CreateElevatorBar(1, 0, 0, w, 25, VTGray50,
	1, EBHORIZONTAL, EBARROWS, 0, ((w * EBMAX) div 1024), VTWhite);
end;

procedure VTRefresh(fd, id:integer; x, y, w, h:short);
begin
   RefreshElevatorBar(ebar);
end;

procedure elevator;
var 
   i, ii, done : integer;
   inmouse : vtseq;
begin
   ebar := CreateElevatorBar(1, 0, 0, jstate.width, 25, VTGray50,
		1, EBHORIZONTAL, EBARROWS, 0,
		((jstate.width * EBMAX) div 1024), VTWhite);
   RefreshElevatorBar(ebar);
   done := 0;
   while (done <> 1) do begin
      i := getvtseq(1, inmouse);
      case i of
         VTEOF : ;
         VTASCII : ;
         VTHARDKEY : ;
         VTMOUSE : begin
            if ((VTMOUSELEFT in inmouse.buttons)and(inmouse.y < 25)) then
               void := DoElevatorBar(ebar, inmouse.x, inmouse.y);
            if (VTMOUSERIGHT in inmouse.buttons) then done:=1;
         end;
      end;
   end;
   DeleteElevatorBar(ebar);
end;

begin
   initialize;
   elevator;
   finish;
end.
