/*
 ebar1d -- example elevator program

 compile with:
	cc -o ebar1d -O ebar1d.c -ltools -lvt
*/

#include <vt.h>
#include <tools.h>

#define	EH	25
char	*ebar;
short	screenw;

refresh(id, x, y, w, h)
int id;
short x, y, w, h;
{
   struct wstate ws;
   GetWindowState(1, &ws);
   SetTemporaryClipping(1, x, y, w, h);
   RefreshElevatorBar(ebar);
   SetWindowState(1, &ws);
}

adjust(id, w, h)
int id;
short w, h;
{
   DeleteElevatorBar(ebar);
   ebar = CreateElevatorBar(1, 0, 0, w, EH, VT_Gray50,
		1, EB_HORIZONTAL, EB_ARROWS, 0, (w*EB_MAX/screenw), VT_White);
}

main(argc, argv)
int	argc;
char	*argv[];
{
   struct wstate jstate;
   struct gconfig gc;
   if (GetGraphicsConfig(1, &gc) == -1) {
	printf("%s: not a window\n", argv[0]);
	exit(1);
   }
   screenw = gc.w;
   GetWindowState(1, &jstate);
   SetLineDisc(1, TWSDISC);
   BlockRefreshAdjust(1);
   SetBuf(1, 512);
   SetRefresh(1, 0, refresh);
   SetAdjust(1, 0, adjust);
   SetPosition(1, 0, 0);
   SetColor(1, VT_White);
   PaintRectangleInterior(1, jstate.width, jstate.height);

   ebar = CreateElevatorBar(1, 0, 0, jstate.width, EH, VT_Gray50,
		1, EB_HORIZONTAL, EB_ARROWS, 0,
		(jstate.width*EB_MAX/screenw), VT_White);
   elevator();
   DeleteElevatorBar(ebar);

   SetPosition(1, 0, 0);
   SetColor(1, jstate.bcolor);
   PaintRectangleInterior(1, 10000, 10000);
   SetWindowState(1, &jstate);
}

elevator()
{
   struct vtseq input;

   RefreshElevatorBar(ebar);
   for (;;) {
      switch (getvtseq(1, &input)) {
         case VT_MOUSE:
	    switch (input.u.mouse.buttons &
		(VT_MOUSE_LEFT|VT_MOUSE_MIDDLE|VT_MOUSE_RIGHT)) {
	    case VT_MOUSE_LEFT:
		if (input.u.mouse.y < EH) 
		    DoElevatorBar(ebar, input.u.mouse.x, input.u.mouse.y);
		break;
	    case VT_MOUSE_MIDDLE:
		SetPosition(1, input.u.mouse.x, input.u.mouse.y);
		if (DisplayPopUp(1, "1D Elevator\0Exit\0"))
		    return;
		break;
	    case VT_MOUSE_RIGHT:
		    return;
		break;
	    }
	    break;
         default:
	    break;
      }
   }
}
