program main(input, output);
const
#include "/usr/include/pascal/gconst.h"
	NUMCURSOR	= 7;
	W		= 40;
	H		= 40;
	BITWIDTH	= 680;	(*  W*(NUMCURSOR + 11)  *)
	BITHEIGHT	= 160;	(*  H*4  *)
type
#include "/usr/include/pascal/gtype.h"
	long32	= array [0..31] of integer;
var
	void : integer;
	istate : wstate;
	inmouse : vtseq;
	i, done : integer;
	bmd : BMD;
	face : long32;
	mask : long32;
	xhot,yhot : short;
	blink : short;
#include "/usr/include/pascal/gproc.h"

procedure VTRefresh(fd,id : integer; x,y,w,h : short);
begin
   void := bmDisplayBitmap(1,COPYRASTER,bmd,0,0,0,0,BITWIDTH,BITHEIGHT,VTWhite);
end;

procedure ClearScreen;
begin
    SetPosition(1, 0, 0);
    SetColor(1, VTWhite);
    PaintRectangleInterior(1, 10000, 10000);
    Flush(1);
end;

procedure ShowCursor;
type
   short64 = array [0..63] of short;
   dtype = (types,typel);   (* short or long *)
   rtype = record 
      case key:dtype of
	 types : (left,right:short);	(* short: split in half  *)
	 typel : (whole:integer);	(* long: retain as whole *)
   end;
var
   i,j :integer;
   pface : short64;
   pmask : short64;
   conv : rtype;
begin
   bmClearRegion(bmd,0,0,BITWIDTH,BITHEIGHT,VTWhite);
   void := GetWindowState(1, istate);
   void := SetLineDisc(1, TWSDISC);
   ClearScreen;
   bmSetThickness(bmd, 2);
   bmSetAddressing(bmd, VTRELATIVE);
   bmSetColor(bmd, VTBlack);

   bmSetPosition(bmd, W, H*2);
   bmPaintRectangleInterior(bmd, W*NUMCURSOR, H);
   bmSetPosition(bmd, W, H);
   bmPaintRectangleBorder(bmd, W*NUMCURSOR, H*2);
   for i:=1 to NUMCURSOR do begin
      bmSetPosition(bmd, W*i, H);
      bmPaintLine(bmd, 0, H);
   end;
   bmSetPosition(bmd, W*(NUMCURSOR + 2), H);
   bmPaintRectangleBorder(bmd, 2*W, 2*H);
   bmSetPosition(bmd, W*(NUMCURSOR + 5), H);
   bmPaintRectangleInterior(bmd, 2*W, 2*H);
   bmPaintRectangleBorder(bmd, 2*W, 2*H);
   bmSetPosition(bmd, W*(NUMCURSOR + 8), H);
   bmSetColor(bmd,VTGray50);
   bmPaintRectangleInterior(bmd, 2*W, 2*H);
   bmSetColor(bmd,VTBlack);
   bmPaintRectangleBorder(bmd, 2*W, 2*H);

   for i:=0 to (NUMCURSOR-1) do begin
      void := GetCursor(i,mask[0],face[0],xhot,yhot,blink);
      for j:=0 to 31 do begin
	 conv.whole := mask[j];
	 pmask[j*2]     := conv.left;
	 pmask[j*2 + 1] := conv.right;
	 conv.whole := face[j];
	 pface[j*2]     := conv.left;
	 pface[j*2 + 1] := conv.right;
      end;
      bmPaintRegion(bmd,((i+1)*W+4),H+4,32,32,VTBlack,pmask[0],0,0,32);
      bmToggleRegion(bmd,((i+1)*W+4),H+4,32,32,pface[0],0,0,32);
      bmPaintRegion(bmd,((i+1)*W+4),(2*H+4),32,32,VTBlack,pmask[0],0,0,32);
      bmToggleRegion(bmd,((i+1)*W+4),(2*H+4),32,32,pface[0],0,0,32);
   end;
end;

begin
    bmd := bmAllocate(BITWIDTH,BITHEIGHT);
    if (bmd <> nil) then begin
       void := BlockRefreshAdjust(0);
       SetRefresh(1,0);
       ShowCursor;
       VTRefresh(1,0,0,0,BITWIDTH,BITHEIGHT);
       SetMouseMode(1,[VTMOUSEDOWN]);
       done := 0;
       while (done = 0) do begin
	  i := getvtseq(1,inmouse);
	  case i of
	     VTMOUSE: begin
                inmouse.x := ((inmouse.x - W) div W);
		if ((inmouse.x >= 0) and (inmouse.x < NUMCURSOR)) then
		begin
		   void := GetCursor(inmouse.x,mask[0],face[0],xhot,yhot,blink);
		   DefineGlobalCursor(1,mask[0],face[0],xhot,yhot,blink);
		end;
	     end;
	     VTEOF: done := done+1 ;
	     VTASCII: done := done+1 ;
	     VTHARDKEY: done := done+1 ;
	  end;
       end;
       void := GetCursor(0,mask[0],face[0],xhot,yhot,blink);
       DefineGlobalCursor(1,mask[0],face[0],xhot,yhot,blink);
       bmDeallocate(bmd);
       ClearScreen;
       SetWindowState(1, istate);
    end
    else begin
       writeln(' Unable to allocate bitmap');
    end;
end.
