#include <vt.h>
#include <bitmap.h>
#include <tools.h>
#include <signal.h>

#define	NUMCURSOR	7
#define	W	40
#define	H	40
#define	BITWIDTH	W * (NUMCURSOR + 11)
#define	BITHEIGHT	H * 4

struct	wstate	istate;	
struct	vtseq	input;
struct	BMD *bmd;

long *mask[] = { (long *) &cur_ularrow.mask[0],
                 (long *) &cur_pencil.mask[0],
                 (long *) &cur_bucket.mask[0],
                 (long *) &cur_eraser.mask[0],
                 (long *) &cur_crosshair.mask[0],
                 (long *) &cur_triangle.mask[0],
                 (long *) &cur_finger.mask[0] };

long *face[] = { (long *) &cur_ularrow.face[0],
                 (long *) &cur_pencil.face[0],
                 (long *) &cur_bucket.face[0],
                 (long *) &cur_eraser.face[0],
                 (long *) &cur_crosshair.face[0],
                 (long *) &cur_triangle.face[0],
                 (long *) &cur_finger.face[0] };

short *x[] = { (short *) &cur_ularrow.x,
               (short *) &cur_pencil.x,
               (short *) &cur_bucket.x,
               (short *) &cur_eraser.x,
               (short *) &cur_crosshair.x,
               (short *) &cur_triangle.x,
               (short *) &cur_finger.x };

short *y[] = { (short *) &cur_ularrow.y,
               (short *) &cur_pencil.y,
               (short *) &cur_bucket.y,
               (short *) &cur_eraser.y,
               (short *) &cur_crosshair.y,
               (short *) &cur_triangle.y,
               (short *) &cur_finger.y };

cleanup()
{
    BlockRefreshAdjust(1);
    SetPosition(1, 0, 0);
    SetColor(1, istate.bcolor);
    PaintRectangleInterior(1, 10000, 10000);
    DefineGlobalCursor(1, mask[0], face[0], *(x[0]), *(y[0]));
    SetWindowState(1, &istate);
    exit(0);
}

main()
{
	extern refresh();
	if ((bmd = BM_Allocate(BITWIDTH, BITHEIGHT))==0) {
		printf(" Unable to Allocate bitmap\n");
		exit(1);
	}
	signal(SIGTERM, cleanup);
	signal(SIGHUP, cleanup);
	signal(SIGQUIT, cleanup);
	signal(SIGINT, cleanup);
	GetWindowState(1, &istate);
	SetLineDisc(1, TWSDISC);
	(void) BlockRefreshAdjust(1);
	SetRefresh(1, 0, refresh);
	SetBuf(1, 512);
	ShowCursor();
	refresh(1, 0, 0, BITWIDTH, BITHEIGHT);
	SetMouseMode(1, VT_MOUSE_DOWN);
	while (1) {
		if (getvtseq(1, &input) != VT_MOUSE) continue;
		if (input.u.mouse.buttons & VT_MOUSE_MIDDLE) {
			SetPosition(1, input.u.mouse.x, input.u.mouse.y);
			if (DisplayPopUp(1, "Cursor\0Exit\0"))
			    Finish();
		}
		else if (input.u.mouse.buttons & VT_MOUSE_RIGHT)
		    Finish();
		else {
			short curid;
			curid = ((input.u.mouse.x) / W) - 1;
			if ((curid >= 0) && (curid < NUMCURSOR) &&
			    (input.u.mouse.y > H) && (input.u.mouse.y < 3*H))
			    DefineGlobalCursor(1, mask[curid], face[curid],
				*(x[curid]), *(y[curid]), 0);
		}
	}
}

Finish()
{
	DefineGlobalCursor(1, mask[0], face[0], *(x[0]), *(y[0]));
	ClearScreen(istate.bcolor);
	SetWindowState(1, &istate);
	exit(0);
}

refresh(id, x, y, w, h)
{
	BM_DisplayBitmap(1,COPYRASTER,bmd,0,0,0,0,BITWIDTH,BITHEIGHT,VT_White);
}

ShowCursor()
{
	register short i;

	BM_ClearRegion(bmd, 0, 0, BITWIDTH, BITHEIGHT, VT_White);
	ClearScreen(VT_White);
	BM_SetThickness(bmd, 2);
	BM_SetAddressing(bmd, VT_RELATIVE);
	BM_SetColor(bmd, VT_Black);

	BM_SetPosition(bmd, W, H*2);
	BM_PaintRectangleInterior(bmd, W*NUMCURSOR, H);
	BM_SetPosition(bmd, W, H);
	BM_PaintRectangleBorder(bmd, W*NUMCURSOR, H*2);
	for (i=1;i<=NUMCURSOR;i++) {
		BM_SetPosition(bmd, W*i, H);
		BM_PaintLine(bmd, 0, H);
	}
	BM_SetPosition(bmd, W*(NUMCURSOR + 2), H);
	BM_PaintRectangleBorder(bmd, 2*W, 2*H);
	BM_SetPosition(bmd, W*(NUMCURSOR + 5), H);
	BM_PaintRectangleInterior(bmd, 2*W, 2*H);
	BM_PaintRectangleBorder(bmd, 2*W, 2*H);
	BM_SetPosition(bmd, W*(NUMCURSOR + 8), H);
	BM_SetColor(bmd, VT_Gray50);
	BM_PaintRectangleInterior(bmd, 2*W, 2*H);
	BM_SetColor(bmd, VT_Black);
	BM_PaintRectangleBorder(bmd, 2*W, 2*H);

	for (i=0;i<NUMCURSOR;i++) {
		BM_PaintRegion(bmd,((i+1)*W+4),H+4,32,32,VT_Black,mask[i],0,0,32);
		BM_ToggleRegion(bmd,((i+1)*W+4),H+4,32,32,face[i],0,0,32);
		BM_PaintRegion(bmd,((i+1)*W+4),(2*H+4),32,32,VT_Black,mask[i],0,0,32);
		BM_ToggleRegion(bmd,((i+1)*W+4),(2*H+4),32,32,face[i],0,0,32);
	}
}

ClearScreen(color)
short	color;
{
	SetPosition(1, 0, 0);
	SetColor(1, color);
	PaintRectangleInterior(1, 10000, 10000);
}
