/*
 *	Draw a spiral
 *
 *	Compile with:
 *	cc -O commander.c -o commander -lvt
 */
#include <vt.h>
#include <signal.h>

#define XMIN	0
#define YMIN	0
#include "sin.h"
#define SIN(x)	sin[(x)%360]
#define COS(x)  sin[((x)+90)%360]
#define NPENS	4

struct pen{
	short	x, y;
	short	angle;
};

struct pen 	bics[NPENS];
short	width, height;
int	size, angle;
int	delta = 1;
int	thickness = 1;
struct wstate ws;

cleanup()
{
    BlockRefreshAdjust(1);
    SetPosition(1, 0, 0);
    SetColor(1, ws.bcolor);
    PaintRectangleInterior(1, 10000, 10000);
    SetWindowState(1, &ws);
    exit(0);
}

main(argc, argv)
int	argc;
char	**argv;
{
int	adjustsize(), ignoreref();
short	i;
struct gconfig	gc;

	if( argc < 3){
		printf("usage:	%s size, angle [delta] [thickness]\n", argv[0]);
		exit(1);
 	}
	if (GetGraphicsConfig(1, &gc) == -1) {
		printf("%s: not a window\n", argv[0]);
		exit(1);
	}

	signal(SIGTERM, cleanup);
	signal(SIGHUP, cleanup);
	signal(SIGQUIT, cleanup);
	signal(SIGINT, cleanup);

	sscanf(argv[1],"%d",&size);
	sscanf(argv[2],"%d",&angle);
	if( argc > 3){
		sscanf(argv[3],"%d",&delta);
	}
	if( argc > 4){
		sscanf(argv[4],"%d",&thickness);
	}
	GetWindowState(1, &ws);
	width = ws.width;
	height= ws.height;
	SetLineDisc( 1, TWSDISC);
	SetBuf(1, 200);
    	SetMouseMode(1, VT_MOUSE_DOWN);
	SetRefresh(1, 0, ignoreref);
	SetAdjust(1, 0, adjustsize);
	SetAddressing(1, VT_RELATIVE);
	SetThickness(1, thickness);
	cls();
	for( i=0; i<NPENS; i++){  /* fan out */
		bics[i].angle = i * (360 / NPENS);
		bics[i].x = width/2;
		bics[i].y = height/2;
		move( &bics[i], size/2);
	}
	spirals( bics, size, angle, NPENS);
	Flush(1);
	cls();
	SetWindowState(1, &ws);
}

cls()
{
	SetPosition(1,0,0);
	SetColor(1,VT_White);
	PaintRectangleInterior(1, 2000, 2000);
	SetColor(1,VT_Black);
}

spirals( pen, maxsize, angle, n)
struct pen	*pen;
int	maxsize, angle, n;
{
	register i, j;
	for( i=1; i<maxsize; i+=delta){
	    for( j=0; j<NPENS; j++){
		go(&pen[j], i);
		turn(&pen[j], angle);
	    }
	}
}

move( pen, distance)
struct pen	*pen;
int	distance;
{
	register	deltax, deltay;
	if(!distance) return;
	deltax = distance * COS(pen->angle);
	deltay = distance * SIN(pen->angle);
	pen->x += deltax;
	pen->y += deltay;
}

go( pen, distance)
struct pen	*pen;
int	distance;
{
	register	deltax, deltay;
	if(!distance) return;
	deltax = distance * COS(pen->angle);
	deltay = distance * SIN(pen->angle);
	if( distance < 0){
		pen->x += deltax;
		pen->y += deltay;
		SetPosition(1, pen->x, pen->y);
		PaintLine(1, -deltax, -deltay);
	}else{
		SetPosition(1, pen->x, pen->y);
		PaintLine(1, deltax, deltay);
		pen->x += deltax;
		pen->y += deltay;
	}
}

turn( pen, angle)
struct pen	*pen;
int	angle;
{
	pen->angle = (pen->angle + angle) % 360;
}

ignoreref()
{
}

adjustsize(id,w,h)
int id;
short w, h;
{
	width=w; height=h;
	SetPosition(1,0,0);
	SetColor(1,VT_White);
	PaintRectangleInterior(1,5000, 5000);
}
