C
C	clkvtf -- draw an analog clock using libvtf
C
C	compile with:
C		f77 -o clkvtf -O clkvtf.f -lvtf
C
      program clock
      integer save(28), modtime
      external RefreshTime, AdjustTime
C
      common /vtf/ TWSDISC, VTRELATIVE, VTABSOLUTE, SCALE
      common /dlist/ xtable, ytable, clockx, clocky, curtime,
     +               clockr, poshour, posminute, oposhour, oposminute,
     +               rminute, rhour, rmarker, thickness
      common /colors/ VTGRAY37, VTWHITE, VTBLACK
      integer VTGRAY37, VTWHITE, VTBLACK
      integer TWSDISC, VTRELATIVE, VTABSOLUTE, SCALE
      integer xtable(60), ytable(60), clockx, clocky, curtime,
     +        clockr, poshour, posminute, oposhour, oposminute,
     +        rminute, rhour, rmarker, thickness
C
C Save the initial window state, and
C initialize the window for graphics.
C
      call GetWindowState(1, save)
      call SetLineDisc(1, TWSDISC)
      call BlockRefAdj(1)
      call SetBColor(1, VTGRAY37)
      call SetMouseMode(1, 0)
      call SetBuf(1, 2000)
      call SetRefresh(1, 0, RefreshTime)
      call SetAdjust(1, 0, AdjustTime)
      call SetAddress(1, VTRELATIVE)
C
C Draw the initial clock.
C
      call DrawBackground
      call Wflush(1)
      call NewPosition
      call NewSize(save(16), save(17))
      call DrawClock(clockx, clocky, clockr, poshour, posminute)
      call Wflush(1)
C
C Update the clock hands every minute.
C
10    continue
C
C Wait until the next change in minutes.
C
	call BlockRefAdj(0)
	modtime = 60 - mod(curtime, 60)
	call sleep(modtime)
	call BlockRefAdj(1)
C
C What are the new hand positions?
C
	
	call NewPosition
C
C If either hand moved, delete it 
C by drawing it in surface color.
C
	if (posminute .ne. oposminute)
     +     call DrawHand(clockx, clocky, oposminute, rminute, VTWHITE)
	if (poshour.ne. oposhour)
     +     call DrawHand(clockx, clocky, oposhour, rhour, VTWHITE)
C
C Draw the new clock face then make
C sure the screen is updated.
C
	call DrawFace(clockx, clocky, poshour, posminute)
	call Wflush(1)
      if (1 .eq. 1) goto 10
      stop
      end
C-----------------------------------------------------------------------
C BLOCK DATA
C	clockx		- clock x position
C	clocky		- clock y position
C	clockr		- clock radius
C       poshour		- current hour hand position
C       posminute	- current minute hand position
C       oposhour	- old hour hand position
C       oposminute	- old minute hand position
C       rminute		- minute hand radius
C       rhour		- hour hand radius
C	rmarker		- radial position of markers
C	thickness	- thickness of face objects
C	xtable		- x coordinates of points on a large face
C	ytable		- y coordinates of points on a large face
C	TWSDISC		- tws graphics discipline = 5
C	VTRELATIVE	- relative mode = 0
C	VTABSOLUTE	- absolute mode = 1
C	SCALE		- 1000000
C-----------------------------------------------------------------------
      block data
C
      common /vtf/ TWSDISC, VTRELATIVE, VTABSOLUTE, SCALE
      common /dlist/ xtable, ytable, clockx, clocky, curtime,
     +               clockr, poshour, posminute, oposhour, oposminute,
     +               rminute, rhour, rmarker, thickness
      common /colors/ VTGRAY37, VTWHITE, VTBLACK
      integer VTGRAY37, VTWHITE, VTBLACK
      integer TWSDISC, VTRELATIVE, VTABSOLUTE, SCALE
      integer xtable(60), ytable(60), clockx, clocky, curtime,
     +        clockr, poshour, posminute, oposhour, oposminute,
     +        rminute, rhour, rmarker, thickness
      data VTGRAY37	/-7/
      data VTWHITE	/1/
      data VTBLACK	/0/
      data TWSDISC	/5/
      data VTRELATIVE	/0/
      data VTABSOLUTE	/1/
      data SCALE	/1000000/
      data ytable /  1000000,   994522,   978147,   951056,   913545,
     +                866025,   809017,   743145,   669130,   587785,
     +                500000,   406737,   309017,   207912,   104528,
     +                000000,  -104531,  -207914,  -309019,  -406739,
     +               -500002,  -587787,  -669132,  -743146,  -809018,
     +               -866026,  -913546,  -951057,  -978148,  -994522,
     +              -1000000,  -994522,  -978147,  -951056,  -913545,
     +               -866025,  -809016,  -743144,  -669130,  -587784,
     +               -499999,  -406735,  -309016,  -207911,  -104527,
     +                000000,   104530,   207913,   309018,   406738,
     +                500001,   587786,   669131,   743145,   809017,
     +                866026,   913546,   951057,   978148,   994522 /

      data xtable /   000000,   104529,   207912,   309017,   406737,
     +                500000,   587786,   669131,   743145,   809017,
     +                866025,   913546,   951057,   978148,   994522,
     +               1000000,   994522,   978147,   951056,   913545,
     +                866024,   809016,   743143,   669129,   587784,
     +                499998,   406735,   309015,   207910,   104527,
     +                000000,  -104530,  -207913,  -309018,  -406738,
     +               -500001,  -587786,  -669132,  -743146,  -809018,
     +               -866026,  -913546,  -951057,  -978148,  -994522,
     +              -1000000,  -994522,  -978147,  -951056,  -913545,
     +               -866025,  -809016,  -743144,  -669130,  -587785,
     +               -499999,  -406736,  -309016,  -207911,  -104528/
      end
C-----------------------------------------------------------------------
      subroutine NewPosition
      integer time, tarray(9)
      common /vtf/ TWSDISC, VTRELATIVE, VTABSOLUTE, SCALE
      common /dlist/ xtable, ytable, clockx, clocky, curtime,
     +               clockr, poshour, posminute, oposhour, oposminute,
     +               rminute, rhour, rmarker, thickness
      integer TWSDISC, VTRELATIVE, VTABSOLUTE, SCALE
      integer xtable(60), ytable(60), clockx, clocky, curtime,
     +        clockr, poshour, posminute, oposhour, oposminute,
     +        rminute, rhour, rmarker, thickness
C
C Save the previous positions of the hands.
C
      oposminute = posminute
      oposhour   = poshour
C
C Get the current time.
C Break it into components.
C
      curtime = time(0)
      call ltime(curtime, tarray)
C
C Set the new positions of the hands.
C
      posminute = tarray(2)
      poshour	= mod(tarray(3), 12)
      poshour   = (poshour * 5) + (tarray(2) / 12)
      return
      end
C-----------------------------------------------------------------------
C Subroutine DrawClock
C Input
C	x	- x position of clock
C	y	- y position of clock
C	r	- radius of clock
C	h	- hour hand position in minutes from vertical
C	m	- minute hand position in minutes from vertical
C-----------------------------------------------------------------------
      subroutine DrawClock(x, y, r, h, m)
      integer x, y, r, h, m
C
      call DrawShadow(x, y, r)
      call DrawBorder(x, y, r)
      call DrawSurface(x, y, r)
      call DrawFace(x, y, h, m)
      return
      end
C-----------------------------------------------------------------------
C Subroutine DrawShadow
C Input
C	x	- x coordinate of clock
C	y	- y coordinate of clock
C	r	- radius of clock
C-----------------------------------------------------------------------
      subroutine DrawShadow(x, y, r)
      integer x, y, r
      common /vtf/ TWSDISC, VTRELATIVE, VTABSOLUTE, SCALE
      common /dlist/ xtable, ytable, clockx, clocky, curtime,
     +               clockr, poshour, posminute, oposhour, oposminute,
     +               rminute, rhour, rmarker, thickness
      common /colors/ VTGRAY37, VTWHITE, VTBLACK
      integer VTGRAY37, VTWHITE, VTBLACK
      integer TWSDISC, VTRELATIVE, VTABSOLUTE, SCALE
      integer xtable(60), ytable(60), clockx, clocky, curtime,
     +        clockr, poshour, posminute, oposhour, oposminute,
     +        rminute, rhour, rmarker, thickness
C
      call SetPosition(1, x+2*thickness, y+2*thickness)
      call SetColor(1, VTBLACK)
      call CirInterior(1, r)
      return
      end
C-----------------------------------------------------------------------
C Subroutine DrawBorder
C Input
C	x	- x coordinate of clock
C	y	- y coordinate of clock
C	r	- radius of clock
C-----------------------------------------------------------------------
      subroutine DrawBorder(x, y, r)
      integer x, y, r
      common /vtf/ TWSDISC, VTRELATIVE, VTABSOLUTE, SCALE
      common /dlist/ xtable, ytable, clockx, clocky, curtime,
     +               clockr, poshour, posminute, oposhour, oposminute,
     +               rminute, rhour, rmarker, thickness
      common /colors/ VTGRAY37, VTWHITE, VTBLACK
      integer VTGRAY37, VTWHITE, VTBLACK
      integer TWSDISC, VTRELATIVE, VTABSOLUTE, SCALE
      integer xtable(60), ytable(60), clockx, clocky, curtime,
     +        clockr, poshour, posminute, oposhour, oposminute,
     +        rminute, rhour, rmarker, thickness
C
      call SetPosition(1, x, y)
      call SetColor(1, VTBLACK)
      call SetThickness(1, thickness)
      call CirBorder(1, r)
      return
      end
C-----------------------------------------------------------------------
C Subroutine DrawBorder
C Input
C	x	- x coordinate of clock
C	y	- y coordinate of clock
C	r	- radius of clock
C-----------------------------------------------------------------------
      subroutine DrawSurface(x, y, r)
      integer x, y, r
      common /vtf/ TWSDISC, VTRELATIVE, VTABSOLUTE, SCALE
      common /dlist/ xtable, ytable, clockx, clocky, curtime,
     +               clockr, poshour, posminute, oposhour, oposminute,
     +               rminute, rhour, rmarker, thickness
      common /colors/ VTGRAY37, VTWHITE, VTBLACK
      integer VTGRAY37, VTWHITE, VTBLACK
      integer TWSDISC, VTRELATIVE, VTABSOLUTE, SCALE
      integer xtable(60), ytable(60), clockx, clocky, curtime,
     +        clockr, poshour, posminute, oposhour, oposminute,
     +        rminute, rhour, rmarker, thickness
C
      call SetPosition(1, x, y)
      call SetColor(1, VTWHITE)
      call CirInterior(1, r)
      return
      end
C-----------------------------------------------------------------------
C Subroutine DrawFace
C Input
C	x	- x coordinate of clock
C	y	- y coordinate of clock
C	h	- position of hour hand
C	m	- position of minute hand
C-----------------------------------------------------------------------
      subroutine DrawFace(x, y, h, m)
      integer x, y, h, m
      common /vtf/ TWSDISC, VTRELATIVE, VTABSOLUTE, SCALE
      common /dlist/ xtable, ytable, clockx, clocky, curtime,
     +               clockr, poshour, posminute, oposhour, oposminute,
     +               rminute, rhour, rmarker, thickness
      common /colors/ VTGRAY37, VTWHITE, VTBLACK
      integer VTGRAY37, VTWHITE, VTBLACK
      integer TWSDISC, VTRELATIVE, VTABSOLUTE, SCALE
      integer xtable(60), ytable(60), clockx, clocky, curtime,
     +        clockr, poshour, posminute, oposhour, oposminute,
     +        rminute, rhour, rmarker, thickness
C
      call DrawHand(x, y, m, rminute, VTBLACK)
      call DrawHand(x, y, h, rhour, VTBLACK)
      call DrawPost(x, y)
      call DrawMarkers(x, y, rmarker)
      return
      end
C-----------------------------------------------------------------------
C Subroutine DrawBackground
C-----------------------------------------------------------------------
      subroutine DrawBackground
      common /colors/ VTGRAY37, VTWHITE, VTBLACK
      integer VTGRAY37, VTWHITE, VTBLACK
      call SetPosition(1, 0, 0)
      call SetColor(1, VTGRAY37)
      call RecInterior(1, 10000, 10000)
      return
      end
C-----------------------------------------------------------------------
C Subroutine DrawHand
C Input
C	x	- x coordinate of clock */
C	y	- y coordinate of clock */
C	pos	- radial position of hand */
C	radius	- length of hand */
C	color	- color of hand */
C-----------------------------------------------------------------------
      subroutine DrawHand(x, y, pos, radius, color)
      integer x, y, pos, radius, color
      integer x15, y15, x45, y45, xpoint(3), ypoint(3)
      common /vtf/ TWSDISC, VTRELATIVE, VTABSOLUTE, SCALE
      common /dlist/ xtable, ytable, clockx, clocky, curtime,
     +               clockr, poshour, posminute, oposhour, oposminute,
     +               rminute, rhour, rmarker, thickness
      integer TWSDISC, VTRELATIVE, VTABSOLUTE, SCALE
      integer xtable(60), ytable(60), clockx, clocky, curtime,
     +        clockr, poshour, posminute, oposhour, oposminute,
     +        rminute, rhour, rmarker, thickness
C
      call SetPosition(1, x, y)
      call SetColor(1, color)
C
C Points on polygon defining the hand.
C
      x15 = mod((pos+15), 60) + 1
      x45 = mod((pos+45), 60) + 1
      y15 = mod((pos+15), 60) + 1
      y45 = mod((pos+45), 60) + 1
      xpoint(1) = x + ((xtable(x15) * 2*thickness)/SCALE)
      ypoint(1) = y - ((ytable(y15) * 2*thickness)/SCALE)
      xpoint(2) = x + ((xtable(x45) * 2*thickness)/SCALE)
      ypoint(2) = y - ((ytable(y45) * 2*thickness)/SCALE)
      xpoint(3) = x + ((xtable(pos) * radius)/SCALE)
      ypoint(3) = y - ((ytable(pos) * radius)/SCALE)
      call SetAddress(1, VTABSOLUTE)
      call PolyInterior(1, 3, xpoint, ypoint)
      call SetAddress(1, VTRELATIVE)
      return
      end
C-----------------------------------------------------------------------
C Subroutine DrawMarkers
C Input
C	x	- x coordinate of clock
C	y	- y coordinate of clock
C	r	- radius of clock
C-----------------------------------------------------------------------
      subroutine DrawMarkers(x, y, r)
      integer x, y, r, i, j
      common /vtf/ TWSDISC, VTRELATIVE, VTABSOLUTE, SCALE
      common /dlist/ xtable, ytable, clockx, clocky, curtime,
     +               clockr, poshour, posminute, oposhour, oposminute,
     +               rminute, rhour, rmarker, thickness
      common /colors/ VTGRAY37, VTWHITE, VTBLACK
      integer VTGRAY37, VTWHITE, VTBLACK
      integer TWSDISC, VTRELATIVE, VTABSOLUTE, SCALE
      integer xtable(60), ytable(60), clockx, clocky, curtime,
     +        clockr, poshour, posminute, oposhour, oposminute,
     +        rminute, rhour, rmarker, thickness
C
      call SetColor(1, VTBLACK)
      do 10 i=1, 60
         call SetPosition(1, (x+(xtable(i)*r)/SCALE), 
     +                       (y+(ytable(i)*r)/SCALE))
	 j = mod((i-1), 5)
         if (j .eq. 0) call CirInterior(1, thickness)
         if (j .ne. 0) call CirInterior(1, thickness/3)
 10   continue
      return
      end
C-----------------------------------------------------------------------
C Subroutine DrawPost
C Input
C	x	- x coordinate of clock
C	y	- y coordinate of clock
C-----------------------------------------------------------------------
      subroutine DrawPost(x, y)
      integer x, y
      common /dlist/ xtable, ytable, clockx, clocky, curtime,
     +               clockr, poshour, posminute, oposhour, oposminute,
     +               rminute, rhour, rmarker, thickness
      common /colors/ VTGRAY37, VTWHITE, VTBLACK
      integer VTGRAY37, VTWHITE, VTBLACK
      integer xtable(60), ytable(60), clockx, clocky, curtime,
     +        clockr, poshour, posminute, oposhour, oposminute,
     +        rminute, rhour, rmarker, thickness
C
      call SetPosition(1, x, y)
      call SetThickness(1, thickness)
      call SetColor(1, VTBLACK)
      call CirBorder(1, thickness)
      call SetColor(1, VTWHITE)
      call CirInterior(1, thickness)
      return
      end
C-----------------------------------------------------------------------
C Subroutine NewSize
C Input
C	w	- new width of window
C	h	- new height of window
C-----------------------------------------------------------------------
      subroutine NewSize(w, h)
      integer w, h
      common /dlist/ xtable, ytable, clockx, clocky, curtime,
     +               clockr, poshour, posminute, oposhour, oposminute,
     +               rminute, rhour, rmarker, thickness
      integer xtable(60), ytable(60), clockx, clocky, curtime,
     +        clockr, poshour, posminute, oposhour, oposminute,
     +        rminute, rhour, rmarker, thickness
C
C Center the clock
C
      clockx = w/2
      clocky = h/2
C
C Radius is 45% of smaller window dimension, but at least 1
C
      clockr = w
      if (h .lt. w) clockr = h
      clockr = (45*clockr)/100
      if (clockr .le. 0) clockr = 1
C
C Minute hand radius is 90% of clock radius, but at least 1
C
      rminute = (90 * clockr) / 100
      if (rminute .le. 0) rminute = 1
C
C Marker radius is at tip of minute hand
C
      rmarker = rminute
C
C Hour hand radius is 60% of clock radius, but at least 1
C
      rhour = (60 * clockr) / 100
      if (rhour .le. 0) rhour = 1
C
C Thickness is 1/25th of clock radius, but at least 2
C
      thickness = clockr / 25
      if (thickness .le. 1) thickness = 2
      return
      end
C-----------------------------------------------------------------------
C Subroutine RefreshTime
C Input
C-----------------------------------------------------------------------
      subroutine RefreshTime(id, x, y, w, h)
      integer id, x, y, w, h
      integer ws(28)
      common /dlist/ xtable, ytable, clockx, clocky, curtime,
     +               clockr, poshour, posminute, oposhour, oposminute,
     +               rminute, rhour, rmarker, thickness
      common /colors/ VTGRAY37, VTWHITE, VTBLACK
      integer VTGRAY37, VTWHITE, VTBLACK
      integer xtable(60), ytable(60), clockx, clocky, curtime,
     +        clockr, poshour, posminute, oposhour, oposminute,
     +        rminute, rhour, rmarker, thickness
C
      call GetWindowState(1, ws)
      call SetTempClip(1, x, y, w, h)
      call DrawBackground
      call Wflush(1)
      call DrawClock(clockx, clocky, clockr, poshour, posminute)
      call SetWindowState(1, ws)
      return
      end
C-----------------------------------------------------------------------
C Subroutine AdjustTime
C    Refresh will redraw the screen.  Just need to get the
C    new size and clock position into the display list.
C Input
C	w	- new screen width
C	h	- new screen height
C-----------------------------------------------------------------------
      subroutine AdjustTime(id, w, h)
      integer id, w, h
      call NewSize(w, h)
      return
      end
