/*
 *	Compile with:
 *	cc -O casey.c -o casey -lvt
 */
#include <vt.h>
#include <signal.h>


#define minval		20              /* minimum pixel value */
#define N		5               /* number of sides in the polygon */
#define Steps		32		/* # of interpolations between poly */

struct point
  {
  int x;
  int y;
  };

struct point ring_gon [Steps][N+1];

short	width, height;
int	thickness = 1;
int debug = 0;

struct wstate ws;
int	adjustsize(), refresh();

struct point start_gon [N];
struct point end_gon   [N];
struct point delta_gon [N];
short  fcolor, bcolor;
struct colors {
	int	r;
	int	g;
	int	b;
} colors[] = {
	{ 2, 11, 13},
	{ 0,  0, 14},
	{ 0, 14,  0},
	{ 0, 14, 14},
	{14,  0,  0},
	{14,  0, 14},
	{14, 14,  0},
	{ 0, 14,  8},
	{ 0,  8, 14},
	{14,  8,  0},
	{ 8, 14,  0},
	{ 8,  0, 14},
	{14,  0,  8},
	{ 8, 14,  8},
	{14,  8, 14},
	{15, 15, 15}
};

cleanup()
{
    BlockRefreshAdjust(1);
    SetPosition(1, 0, 0);
    SetColor(1, ws.bcolor);
    PaintRectangleInterior(1, 10000, 10000);
    SetWindowState(1, &ws);
    exit(0);
}

main(argc, argv)
int	argc;
char	*argv[];
{
  int  i, j;
  int  ring_pntr;
  unsigned rand();
  short	max_color;
  struct gconfig gc;

  /* Continuous Birthday Plot */

  if (GetGraphicsConfig(1, &gc) == -1) {
	printf("%s: not a window\n", argv[0]);
	exit(1);
  }

  signal(SIGTERM, cleanup);
  signal(SIGHUP, cleanup);
  signal(SIGQUIT, cleanup);
  signal(SIGINT, cleanup);
  
  GetWindowState(1, &ws);
  width = ws.width;
  height= ws.height;
  SetBuf(1, 50);
  if (debug)
	printf("width is %d, height is %d\n", width, height);
  else
  	SetLineDisc( 1, TWSDISC);
  SetMouseMode(1, VT_MOUSE_DOWN);
  SetRefresh(1, 0, refresh);
  SetAdjust(1, 0, adjustsize);
  SetAddressing(1, VT_ABSOLUTE);
  SetThickness(1, thickness);
  if ((max_color = gc.realcolors) <= 2) {
	/* white background looks better on monochrome */
	bcolor = VT_White;
  } else {
	/* get some nice colors if available */
	register int	c;
	for (c=0; c<(sizeof(colors)/sizeof(struct colors)); c++) {
		SetLocalLUT(1, c,
		    colors[c].r, colors[c].g, colors[c].b, VT_SHARE);
	}
	/* free them up */
	for (c=0; c<(sizeof(colors)/sizeof(struct colors)); c++) {
		SetLocalLUT(1, c, 0, 0, 0, VT_FREE);
        }
	bcolor = 0;
  }
  SetBColor(1, bcolor);

  for (i = 0; i <= Steps-1; i++)		/* initialize ring */
    {
    for (j = 0; j <= N; j++)
      {
      ring_gon [i][j].x = 0;
      ring_gon [i][j].y = 0;
      }
    }
    cls();
    ring_pntr = 0;

  for (i = 0; i <= N-1; i++)			/* fill Start Polygon */
    {
    start_gon[i].x = (short)(((double)rand()/0x7ffffffe)*(width));
    start_gon[i].y = (short)(((double)rand()/0x7ffffffe)*(height));
    }

  fcolor = max_color/2;
  while (1) {

    fcolor = (fcolor+1)%max_color;
    if (fcolor == bcolor)
	fcolor = (fcolor+1)%max_color;
    for (i = 0; i <= N-1; i++)			/* fill End Polygon */
      {
      /* find next random polygon */
      end_gon[i].x = (short)(((double)rand()/0x7ffffffe)*(width));
      end_gon[i].y = (short)(((double)rand()/0x7ffffffe)*(height));
      delta_gon[i].x = (end_gon[i].x - start_gon[i].x) / Steps;
      delta_gon[i].y = (end_gon[i].y - start_gon[i].y) / Steps;
      }

    for (i = 0; i <= Steps-1; i++)
      {
      for (j = 0; j <= N-1; j++)		/* copy start_gon to ring */
        {
        ring_gon [ring_pntr][j].x = start_gon [j].x;
        ring_gon [ring_pntr][j].y = start_gon [j].y;
        }
						/* store the first point
						   as the last to form a
						   closed polygon */
      ring_gon [ring_pntr][N].x = start_gon [0].x;
      ring_gon [ring_pntr][N].y = start_gon [0].y;

      SetColor(1, fcolor);

      if (draw_polygon (ring_pntr)) goto quitit;

      if (ring_pntr >= Steps-1)			/* increment ring pointer */
        ring_pntr = 0;
      else
        ring_pntr++;

      SetColor(1, bcolor);

      if (draw_polygon (ring_pntr)) goto quitit;

      for (j = 0; j <= N-1; j++)
        {
	start_gon [j].x += delta_gon [j].x;
        start_gon [j].y += delta_gon [j].y;
      }
    }
  }
quitit:
  cls();
  SetWindowState(1, &ws);
}


draw_polygon (pntr)
  int pntr;
{
  int i;

  for (i = 0; i <= N-1; i++)
  {
    if (debug ) {
    printf ("x1: %d, y1: %d\n", ring_gon[pntr][i].x, ring_gon[pntr][i].y);
    printf ("x2: %d, y2: %d\n", ring_gon[pntr][i+1].x, ring_gon[pntr][i+1].y);
    }
    else {
    SetPosition (1, ring_gon[pntr][i].x, ring_gon[pntr][i].y);
    PaintLine(1, ring_gon[pntr][i+1].x, ring_gon[pntr][i+1].y);
    Flush(1);
    }
  }
  return (0);
}

cls()
{
	if (debug) 
		return;
	SetPosition(1, 0, 0);
	SetColor(1, bcolor);
	PaintRectangleInterior(1, 10000, 10000);
	SetColor(1, fcolor);
}

refresh(id, x, y, w, h)
int	id;
short	x, y, w, h;
{
}

adjustsize(id, w, h)
int id;
short w, h;
{
	init();
	if (debug) 
		return;
	width=w; height=h;
}

init()
{
  register int i;

  for (i = 0; i <= N-1; i++)			/* fill Start Polygon */
    {
    start_gon[i].x = (short)(((double)rand()/0x7ffffffe)*(width));
    start_gon[i].y = (short)(((double)rand()/0x7ffffffe)*(height));
    }

}
