(*
 buttonp -- demonstrate the button tool

 compile with:
	pc -o buttonp -O buttonp.p -ltoolsp -lbmp -lvtp
*)
program main(input,output);

const
#include "/usr/include/pascal/vtpconst.h"
#include "/usr/include/pascal/bmpconst.h"
#include "/usr/include/pascal/toolspconst.h"
	HEX80	=	128;	(* hex80 = dec128	*)

type
#include "/usr/include/pascal/vtptype.h"
#include "/usr/include/pascal/bmptype.h"
#include "/usr/include/pascal/toolsptype.h"
marray = packed array [0..200] of char;
pbstruct = packed array [0..7] of pbutton;

var
	istate : wstate;	(* initial window state		*)
	inmouse : vtseq;	(* for getvtseq inmouse		*)
	void : integer;		(* indicates return value unused*)
	message : marray;	(* message array		*)
	plabel : marray;	(* label array			*)
	pbs : pbstruct;		(* button data structure	*)
	font : short;		(* button font			*)
	done : short;		(* implies finish was called	*)
	dir : integer;		(* button field direction	*)
	style, newstyle : short;
	gc : gconfig;
	bfd : BFD;
#include "/usr/include/pascal/vtpproc.h"
#include "/usr/include/pascal/bmpproc.h"
#include "/usr/include/pascal/toolspproc.h"

procedure Toggle(var id:short);
begin
	if (id = 0) then id := 1
	else		 id := 0;
end;

procedure ClearScreen(color:short);
begin
	SetPosition(1, 0, 0);
	SetColor(1, color);
	PaintRectangleInterior(1, 10000, 10000);
end;

procedure Finish;
begin
	done := 1;
	DeleteButtonField(bfd);
	ClearScreen(VTWhite);
	RemoveStatus(1);
	SetWindowState(1, istate);
end;

procedure VTAdjust(fd,id:integer; w, h:short);
begin
	istate.width := w;	istate.height := h;
	istate.tw := w;		istate.th := h;
	style := newstyle;
	DeleteButtonField(bfd);
	bfd := CreateButtonField(1, 8, plabel[0], pbs[0], dir, -1, style, 2,
		font, VTGray50, 0, 0, istate.width, istate.height);
end;

procedure VTRefresh(fd,id:integer; x, y, w, h:short);
var
	rstate : wstate;
begin
	void := GetWindowState(fd, rstate);
	SetPermanentClipping(fd, x, y, w, h);
	RefreshButtonField(bfd);
	SetWindowState(fd, rstate);
end;

procedure InitButton;
begin
plabel := 'Direction@Oval@Rectangle@Shadow@Same Size@Left@Right@Exit@@';
plabel[9] := chr(0);
plabel[14] := chr(0);
plabel[24] := chr(0);
plabel[31] := chr(0);
plabel[41] := chr(0);
plabel[46] := chr(0);
plabel[52] := chr(0);
plabel[57] := chr(0);
plabel[58] := chr(0);
pbs[0].fcolor := VTBlack; pbs[0].bcolor := VTWhite; pbs[0].highlighted := 0;
pbs[1].fcolor := VTBlack; pbs[1].bcolor := VTWhite; pbs[1].highlighted := 0;
pbs[2].fcolor := VTBlack; pbs[2].bcolor := VTWhite; pbs[2].highlighted := 1;
pbs[3].fcolor := VTBlack; pbs[3].bcolor := VTWhite; pbs[3].highlighted := 0;
pbs[4].fcolor := VTBlack; pbs[4].bcolor := VTWhite; pbs[4].highlighted := 0;
pbs[5].fcolor := VTBlack; pbs[5].bcolor := VTWhite; pbs[5].highlighted := 0;
pbs[6].fcolor := VTBlack; pbs[6].bcolor := VTWhite; pbs[6].highlighted := 0;
pbs[7].fcolor := VTBlack; pbs[7].bcolor := VTWhite; pbs[7].highlighted := 0;
end;

procedure Initialize;
begin
   	void := GetWindowState(1, istate);
	void := SetLineDisc(1, TWSDISC);
	void := BlockRefreshAdjust(1);
	SetMouseMode(1, [VTMOUSEDOWN]);
	SetRefresh(1,0);	SetAdjust(1,0);
	message := 'title';	message[5] := chr(0);
	font := GetFontId(message[0]);
	dir := EBHORIZONTAL;
	SetBuf(1, 1024);
	SetBColor(1, VTGray50);
	style := BFRECT;
	newstyle := style;
	bfd := CreateButtonField(1, 8, plabel[0], pbs[0], dir, -1, style,
		 2, font, VTGray50, 0, 0, istate.width, istate.height);
	RefreshButtonField(bfd);
end;

procedure Buttons;
var
    j, i : short;
begin
    done := 0;
    while (done = 0) do begin
	i := getvtseq(1, inmouse);
	case i of
	    VTMOUSE: begin
		RemoveStatus(1);
		case (ButtonInput(bfd, inmouse.x, inmouse.y)) of
		   -1: ;
		   0: begin
			if (dir = 1) then
				newstyle := newstyle - HEX80
			else	newstyle := newstyle + HEX80;
			if (dir = 0) then dir := 1
			else		  dir := 0;
		   	end;
		   1: begin
			if (pbs[1].highlighted = 1) then
				newstyle := newstyle - BFOVAL
			else	newstyle := newstyle + BFOVAL;
			Toggle(pbs[1].highlighted);
		   	end;
		   2: begin
			if (pbs[2].highlighted = 1) then
				newstyle := newstyle - BFRECT
			else	newstyle := newstyle + BFRECT;
			Toggle(pbs[2].highlighted);
		   	end;
		   3: begin
			if (pbs[3].highlighted = 1) then
				newstyle := newstyle - BFSHADOW
			else	newstyle := newstyle + BFSHADOW;
			Toggle(pbs[3].highlighted);
		   	end;
		   4: begin
			if (pbs[4].highlighted = 1) then
				newstyle := newstyle - BFSAMESIZE
			else	newstyle := newstyle + BFSAMESIZE;
			Toggle(pbs[4].highlighted);
		   	end;
		   5: begin
			if (pbs[5].highlighted = 1) then
				newstyle := newstyle - BFLEFTJ
			else	newstyle := newstyle + BFLEFTJ;
			Toggle(pbs[5].highlighted);
		   	end;
		   6: begin
			if (pbs[6].highlighted = 1) then
				newstyle := newstyle - BFRIGHTJ
			else	newstyle := newstyle + BFRIGHTJ;
			Toggle(pbs[6].highlighted);
		   	end;
		   7: begin
			done := 1;
		   	end;
		end;
		if (done = 0 ) then begin
		   if (newstyle <> style) then begin
		       style := newstyle;
		       DeleteButtonField(bfd);
		       bfd := CreateButtonField(1, 8, plabel[0], pbs[0],
				dir, -1, style, 2, font, VTGray50,
				0, 0, istate.width, istate.height);
		       RefreshButtonField(bfd);
		   end;
		end;
	    end;
	    VTEOF,VTASCII,VTHARDKEY : begin
	       message := 'use the mouse';	message[13] := chr(0);
	       DisplayStatus(1, message[0]);
	    end;
	end;
    end;
end;

begin
	void := GetGraphicsConfig(1,gc);
	if (void = -1) then writeln('Not a window.')
	else begin
		InitButton;
		Initialize;
		Buttons;
		Finish;
	end;
end.
