C
C	buttonf -- demonstrate button tool
C
C	compile with:
C		f77 -o buttonf -O buttonf.f -libtoolsf -libbmf -lvtf
C
	program Rectangles
	integer gc(12), GraphicsConfig
	if (GraphicsConfig(1,gc) .eq. -1) goto 999
		call Initialize
		call Buttons
	stop
 999	continue
	write(6,100)
 100	format("Not a window.")
	stop
	end
C-----------
C BLOCK DATA
C-----------
	block data
	common /vtf/	istate, twsdisc, vtwhite, vtblack, vtmousedown,
     +		inmouse, pbs, font, dir, style, newstyle, bfd,
     +		vtgray50, HEX80, BFOVAL, BFRECT, BFSHADOW, BFSAMESIZE,
     +		BFLEFTJ, BFRIGHTJ, BFHORIZONTAL
	integer istate(28), twsdisc, vtwhite, vtblack, vtmousedown,
     +		inmouse(6), pbs(24), font, dir, style, newstyle, bfd,
     +		vtgray50, HEX80, BFOVAL, BFRECT, BFSHADOW, BFSAMESIZE,
     +		BFLEFTJ, BFRIGHTJ, BFHORIZONTAL
	data	twsdisc		/5/
	data	vtwhite		/1/
	data	vtblack		/0/
	data	vtgray50	/-2/
	data	vtmousedown	/16/
	data	BFSHADOW	/1/
	data	BFSAMESIZE	/2/
	data	BFRECT		/4/
	data	BFOVAL		/8/
	data	BFRIGHTJ	/16/
	data	BFLEFTJ		/32/
	data	BFHORIZONTAL	/1/
	data	HEX80		/128/
	data	pbs	/0,1,0,	0,1,0,	0,1,1,	0,1,0,
     +			 0,1,0,	0,1,0,	0,1,0,	0,1,0 /
	end
C-----------------------
C subroutine: Initialize
C-----------------------
	subroutine Initialize
	common /vtf/	istate, twsdisc, vtwhite, vtblack, vtmousedown,
     +		inmouse, pbs, font, dir, style, newstyle, bfd,
     +		vtgray50, HEX80, BFOVAL, BFRECT, BFSHADOW, BFSAMESIZE,
     +		BFLEFTJ, BFRIGHTJ, BFHORIZONTAL
	integer istate(28), twsdisc, vtwhite, vtblack, vtmousedown,
     +		inmouse(6), pbs(24), font, dir, style, newstyle, bfd,
     +		vtgray50, HEX80, BFOVAL, BFRECT, BFSHADOW, BFSAMESIZE,
     +		BFLEFTJ, BFRIGHTJ, BFHORIZONTAL
	integer GetFontId, CreateButton
	external	Refresh, Adjust
	call GetWindowState(1, istate)
	call SetLineDisc(1, twsdisc)
	call SetMouseMode(1, vtmousedown)
	call BlockRefAdj(1)
	call SetRefresh(1, 0, Refresh)
	call SetAdjust(1, 0, Adjust)
	font = GetFontId("title")
	dir = BFHORIZONTAL
	call SetBColor(1, vtgray50)
	style = BFRECT
	newstyle = style
	bfd = CreateButton(1, 8,
     + "Direction@Oval@Rectangle@Shadow@Same Size@Left@Right@Exit@",
     +		pbs, dir, -1, style, 2, font, vtgray50, 0, 0,
     +		istate(16), istate(17))
	call RefreshButton(bfd)
	call SetBuf(1, 1024)
	return
	end
C--------------------
C subroutine: Refresh
C--------------------
	subroutine Refresh(id, x, y, w, h)
	common /vtf/	istate, twsdisc, vtwhite, vtblack, vtmousedown,
     +		inmouse, pbs, font, dir, style, newstyle, bfd,
     +		vtgray50, HEX80, BFOVAL, BFRECT, BFSHADOW, BFSAMESIZE,
     +		BFLEFTJ, BFRIGHTJ, BFHORIZONTAL
	integer istate(28), twsdisc, vtwhite, vtblack, vtmousedown,
     +		inmouse(6), pbs(24), font, dir, style, newstyle, bfd,
     +		vtgray50, HEX80, BFOVAL, BFRECT, BFSHADOW, BFSAMESIZE,
     +		BFLEFTJ, BFRIGHTJ, BFHORIZONTAL
	integer id, x, y, w, h, rstate(28)
	call GetWindowState(1, rstate)
	call SetPermClip(1, x, y, w, h)
	call RefreshButton(bfd)
	call SetWindowState(1, rstate)
	return
	end
C-------------------
C subroutine: Adjust
C-------------------
	subroutine Adjust(id, w, h)
	common /vtf/	istate, twsdisc, vtwhite, vtblack, vtmousedown,
     +		inmouse, pbs, font, dir, style, newstyle, bfd,
     +		vtgray50, HEX80, BFOVAL, BFRECT, BFSHADOW, BFSAMESIZE,
     +		BFLEFTJ, BFRIGHTJ, BFHORIZONTAL
	integer istate(28), twsdisc, vtwhite, vtblack, vtmousedown,
     +		inmouse(6), pbs(24), font, dir, style, newstyle, bfd,
     +		vtgray50, HEX80, BFOVAL, BFRECT, BFSHADOW, BFSAMESIZE,
     +		BFLEFTJ, BFRIGHTJ, BFHORIZONTAL
	integer id, w, h, CreateButton
	istate(16) = w
	istate(17) = h
	istate(24) = w
	istate(25) = h
	style = newstyle
	call DeleteButton(bfd)
	bfd = CreateButton(1, 8,
     + "Direction@Oval@Rectangle@Shadow@Same Size@Left@Right@Exit@",
     +		pbs, dir, -1, style, 2, font, vtgray50, 0, 0,
     +		istate(16), istate(17))
	return
	end
C------------------------
C subroutine: ClearScreen
C------------------------
	subroutine ClearScreen(color)
	integer color
	call SetPosition(1, 0, 0)
	call SetColor(1, color)
	call RecInterior(1, 10000, 10000)
	return
	end
C-------------------
C subroutine: Finish
C-------------------
	subroutine Finish
	common /vtf/	istate, twsdisc, vtwhite, vtblack, vtmousedown,
     +		inmouse, pbs, font, dir, style, newstyle, bfd,
     +		vtgray50, HEX80, BFOVAL, BFRECT, BFSHADOW, BFSAMESIZE,
     +		BFLEFTJ, BFRIGHTJ, BFHORIZONTAL
	integer istate(28), twsdisc, vtwhite, vtblack, vtmousedown,
     +		inmouse(6), pbs(24), font, dir, style, newstyle, bfd,
     +		vtgray50, HEX80, BFOVAL, BFRECT, BFSHADOW, BFSAMESIZE,
     +		BFLEFTJ, BFRIGHTJ, BFHORIZONTAL
	call DeleteButton(bfd)
	call ClearScreen(VTWhite)
	call RemoveStatus(1)
	call SetWindowState(1, istate)
	stop
	end
C-----------------------
C subroutine: Buttons
C-----------------------
	subroutine Buttons
	common /vtf/	istate, twsdisc, vtwhite, vtblack, vtmousedown,
     +		inmouse, pbs, font, dir, style, newstyle, bfd,
     +		vtgray50, HEX80, BFOVAL, BFRECT, BFSHADOW, BFSAMESIZE,
     +		BFLEFTJ, BFRIGHTJ, BFHORIZONTAL
	integer istate(28), twsdisc, vtwhite, vtblack, vtmousedown,
     +		inmouse(6), pbs(24), font, dir, style, newstyle, bfd,
     +		vtgray50, HEX80, BFOVAL, BFRECT, BFSHADOW, BFSAMESIZE,
     +		BFLEFTJ, BFRIGHTJ, BFHORIZONTAL
	integer input(6), getvtseq, ButtonInput, key
	integer CreateButton, sign, Toggle
 10	continue
	if (getvtseq(1,input) .eq. 157) goto 20
		call DisplayStatus(1, "use the mouse")
		goto 10
 20	continue
		key = ButtonInput(bfd, input(5), input(6))
		if ((key .lt. 0).or.(key.ge.8)) goto 40
		call RemoveStatus(1)
		sign = 1
		goto (100,200,300,400,500,600,700,800),key+1
 100	continue
		if (dir .ne. 0) sign = -1
		newstyle = newstyle + sign * HEX80
		dir = Toggle(dir)
		goto 30
 200	continue
		if (pbs(6) .ne. 0) sign = -1
		newstyle = newstyle + sign*BFOVAL
		pbs(6) = Toggle(pbs(6))
		goto 30
 300	continue
		if (pbs(9) .ne. 0) sign = -1
		newstyle = newstyle + sign*BFRECT
		pbs(9) = Toggle(pbs(9))
		goto 30
 400	continue
		if (pbs(12) .ne. 0) sign = -1
		newstyle = newstyle + sign*BFSHADOW
		pbs(12) = Toggle(pbs(12))
		goto 30
 500	continue
		if (pbs(15) .ne. 0) sign = -1
		newstyle = newstyle + sign*BFSAMESIZE
		pbs(15) = Toggle(pbs(15))
		goto 30
 600	continue
		if (pbs(18) .ne. 0) sign = -1
		newstyle = newstyle + sign*BFLEFTJ
		pbs(18) = Toggle(pbs(18))
		goto 30
 700	continue
		if (pbs(21) .ne. 0) sign = -1
		newstyle = newstyle + sign*BFRIGHTJ
		pbs(21) = Toggle(pbs(21))
		goto 30
 800	continue
		call Finish
		goto 30
 30	continue
		if (newstyle .eq. style) goto 40
			style = newstyle
			call DeleteButton(bfd)
			bfd = CreateButton(1, 8,
     + "Direction@Oval@Rectangle@Shadow@Same Size@Left@Right@Exit@",
     +		pbs, dir, -1, style, 2, font, vtgray50, 0, 0,
     +		istate(16), istate(17))
			call RefreshButton(bfd)
 40	continue
	if (1 .eq. 1) goto 10
	return
	end
C-----------------
C function: Toggle
C-----------------
	integer function toggle(i)
	integer i
	toggle = 0
	if (i.eq.0) toggle = 1
	return
	end
