/*
 * button -- a program to demonstrate the button tool
 *
 * compile with:
 *	cc -o button -O button.c -ltools -lvt
 *
 */

#include <vt.h>
#include <tools.h>

#define FONT	"title"		/* title font */
#define THICK	2
#define FCOLOR	VT_Gray50

VT_FONTID	font;

struct button	bs[] = {
	{"Direction", 	VT_Black, VT_White, 0},
	{"Oval", 	VT_Black, VT_White, 0},
	{"Rectangle", 	VT_Black, VT_White, 1},
	{"Shadow", 	VT_Black, VT_White, 0},
	{"Same size", 	VT_Black, VT_White, 0},
	{"Left", 	VT_Black, VT_White, 0},
	{"Right", 	VT_Black, VT_White, 0},
	{"Exit", 	VT_Black, VT_White, 0},
};

#define NBUTTONS	(sizeof(bs)/sizeof(struct button))

int	dir = EB_HORIZONTAL;
char	style, newstyle;
short	width, height;

main(argc, argv)
int	argc;
char	*argv[];
{
	register char	*bfd;
	struct wstate 	ws;
	struct vtseq	input;
	int		redraw(), adjust();
	struct gconfig	gc;

	if (GetGraphicsConfig(1, &gc) == -1) {
	    printf("%s: not a window\n", argv[0]);
	    exit(1);
	}
	GetWindowState(1, &ws);
	SetLineDisc(1, TWSDISC);
	BlockRefreshAdjust(1);
	font = GetFontId(FONT);
	width = ws.width; height = ws.height;
	SetMouseMode(1, VT_MOUSE_DOWN);
	SetBuf(1, 1024);
	SetBColor(1, FCOLOR);
	bfd = CreateButtonField(1, NBUTTONS, bs, dir, -1, 
				newstyle=style=BF_RECT, THICK, font, FCOLOR, 
				0, 0, width, height);
	SetRefresh(1, bfd, redraw);
	SetAdjust(1, bfd, adjust);
	RefreshButtonField(bfd);

	while(getvtseq(1, &input)== VT_MOUSE){
		switch(ButtonInput(bfd, input.u.mouse.x, input.u.mouse.y)){
		case 0:
			newstyle ^= 0x80;
			dir = !dir;
			break;
		case 1:
			newstyle ^= BF_OVAL;
			bs[1].highlighted ^= 1;
			break;
		case 2:
			newstyle ^= BF_RECT;
			bs[2].highlighted ^= 1;
			break;
		case 3:
			newstyle ^= BF_SHADOW;
			bs[3].highlighted ^= 1;
			break;
		case 4:
			newstyle ^= BF_SAMESIZE;
			bs[4].highlighted ^= 1;
			break;
		case 5:
			newstyle ^= BF_LEFTJ;
			bs[5].highlighted ^= 1;
			break;
		case 6:
			newstyle ^= BF_RIGHTJ;
			bs[6].highlighted ^= 1;
			break;
		case 7:
			goto byebye;
			break;
		}
		if( newstyle != style){
		    DeleteButtonField(bfd);
		    bfd = CreateButtonField(1, NBUTTONS, bs, dir, -1, 
				style=newstyle, THICK, font, FCOLOR, 0, 0, 
				width, height);
		    SetRefresh(1, bfd, redraw);
		    SetAdjust(1, bfd, adjust);
		    RefreshButtonField(bfd);
		}
	}

byebye:
	DeleteButtonField(bfd);

	SetPosition(1, 0, 0);
	SetColor(1, ws.bcolor);
	PaintRectangleInterior(1, 10000, 10000);
	SetWindowState(1, &ws);
}

redraw(bfd, x, y, w, h)
char	*bfd;
short	x, y, w, h;
{
	struct wstate	ws;

	GetWindowState(1, &ws);
	SetPermanentClipping(1, x, y, w, h);
	RefreshButtonField(bfd);
	SetWindowState(1, &ws);
}

adjust(bfd, w, h)
char	*bfd;
short	w, h;
{
	width = w; height = h;
	DeleteButtonField(bfd);
	bfd = CreateButtonField(1, NBUTTONS, bs, dir, -1, style=newstyle, 
		    THICK, font, FCOLOR, 0, 0, width, height);
}
